/*
 * Decompiled with CFR 0.152.
 */
package platform;

import assembler.Z80Instruction;
import components.OutputListener;
import components.cartridge.GBCartridge;
import disassembler.LR35902Disassembler;
import java.util.Arrays;
import java.util.LinkedList;
import platform.MemoryTracer;
import system.GameBoy;

public class GBMemoryTracer
extends MemoryTracer {
    private static final int SOURCE_HRAM_FLAG = 0x10000000;
    private static final int SOURCE_IO_FLAG = 0x20000000;
    private final OutputListener outputListener = new OutputListener(){

        @Override
        public void outputAvailable(int n, int n2, int n3) {
            try {
                int n4;
                if (n != 0x110000 && n != 0x110008 && (n < 70 || n > 73)) {
                    return;
                }
                if (!GBMemoryTracer.this.isCartridgeEnabled()) {
                    return;
                }
                int n5 = GBMemoryTracer.this.getPrevOpcode();
                int[] nArray = new int[2];
                nArray[0] = GBMemoryTracer.this.getPrevMappedPC();
                int[] nArray2 = nArray;
                if (n == 70) {
                    int n6 = n2 << 8;
                    int n7 = 0;
                    while (n7 < GBMemoryTracer.this.oamSources.length) {
                        nArray2[1] = GBMemoryTracer.this.toMappedAddress(n6 + n7);
                        int n8 = nArray2[0];
                        ((GBMemoryTracer)GBMemoryTracer.this).oamSources[n7] = (long)n8 << 32 | (long)nArray2[1];
                        GBMemoryTracer.this.updateDataTypes(nArray2, 4);
                        ++n7;
                    }
                    GBMemoryTracer.fireOutputAvailable(n, -1);
                    return;
                }
                if (n5 < 0) {
                    return;
                }
                nArray2 = GBMemoryTracer.this.getMemorySource();
                if (nArray2[1] < 0) {
                    nArray2[1] = -nArray2[1];
                }
                int n9 = nArray2[0];
                if (n == 0x110000) {
                    if (GBMemoryTracer.this.vramSources[n2 & 0x3FFF] != ((long)n9 << 32 | (long)nArray2[1])) {
                        GBMemoryTracer.this.vramSources[n2 & 0x3FFF] = (long)n9 << 32 | (long)nArray2[1];
                        GBMemoryTracer.fireOutputAvailable(n, n2 & 0x3FFF);
                    }
                    GBMemoryTracer.this.updateDataTypes(nArray2, (n2 & 0x1FFF) < 6144 ? 2 : 3);
                } else if (n >= 71 && n <= 73) {
                    if (GBMemoryTracer.this.colorSources[n - 71] != ((long)n9 << 32 | (long)nArray2[1])) {
                        Arrays.fill(GBMemoryTracer.this.colorSources, (n - 71) * 4, (n - 71 + 1) * 4, (long)n9 << 32 | (long)nArray2[1]);
                        GBMemoryTracer.fireOutputAvailable(n, n - 71);
                    }
                    GBMemoryTracer.this.updateDataTypes(nArray2, 1);
                } else if (n == 0x110008 && ((n4 = n2 & 0x7F) & 1) == 0) {
                    if (GBMemoryTracer.this.colorSources[n4 / 2] != ((long)n9 << 32 | (long)nArray2[1])) {
                        GBMemoryTracer.this.colorSources[n4 / 2] = (long)n9 << 32 | (long)nArray2[1];
                        GBMemoryTracer.fireOutputAvailable(n, n4 / 2);
                    }
                    GBMemoryTracer.this.updateDataTypes(nArray2, 1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GBMemoryTracer.this.clearTrace();
            }
        }
    };
    private final long[] oamSources = new long[160];
    private final long[] hramSources = new long[127];

    public GBMemoryTracer(GameBoy gameBoy, GBCartridge gBCartridge) {
        super(gameBoy, gBCartridge);
    }

    @Override
    protected int getIndexOfPC() {
        return 5;
    }

    @Override
    protected int toMappedAddress(int n) {
        if (GameBoy.isHRAMaddress(n)) {
            return 0x10000000 | this.mapAddress(n);
        }
        if (GameBoy.isIOaddress(n)) {
            return 0x20000000 | this.mapAddress(n);
        }
        return super.toMappedAddress(n);
    }

    @Override
    protected void updateTrace(int n, Z80Instruction z80Instruction) {
        super.updateTrace(n, z80Instruction);
        int n2 = z80Instruction.getOpCode();
        if (n2 >> 6 == 0 && ((n2 & 0xF) == 1 || (n2 & 7) == 6)) {
            if ((n2 & 0xF) == 1) {
                int n3 = n2 >> 4;
                if (n3 < 3) {
                    this.regSources[n3 << 1] = new int[]{n, n + 2};
                    this.regSources[n3 << 1 | 1] = new int[]{n, n + 1};
                }
            } else if ((n2 & 7) == 6) {
                this.regSources[n2 >> 3 & 7] = new int[]{n, n + 1};
            }
        } else if (n2 >> 6 == 1) {
            int n4 = n2 >> 3 & 7;
            int n5 = n2 & 7;
            if (n5 == 6) {
                if (n4 != 6) {
                    this.regSources[n4] = null;
                }
            } else if (n4 != 6) {
                this.regSources[n4] = this.regSources[n5];
            }
        } else {
            switch (n2) {
                case 10: 
                case 26: 
                case 42: 
                case 58: {
                    this.regSources[7] = null;
                    break;
                }
                case 240: {
                    this.regSources[7] = new int[]{n, this.toMappedAddress(0xFF00 | z80Instruction.getArg())};
                    break;
                }
                case 250: {
                    this.regSources[7] = new int[]{n, this.toMappedAddress(z80Instruction.getArg())};
                    break;
                }
                case 175: {
                    this.regSources[7] = new int[]{n, -1};
                    break;
                }
                case 193: {
                    this.regSources[0] = new int[]{n, this.toMappedAddress(this.getSP() + 1)};
                    this.regSources[1] = new int[]{n, this.toMappedAddress(this.getSP())};
                    break;
                }
                case 209: {
                    this.regSources[2] = new int[]{n, this.toMappedAddress(this.getSP() + 1)};
                    this.regSources[3] = new int[]{n, this.toMappedAddress(this.getSP())};
                    break;
                }
                case 225: {
                    this.regSources[4] = new int[]{n, this.toMappedAddress(this.getSP() + 1)};
                    this.regSources[5] = new int[]{n, this.toMappedAddress(this.getSP())};
                    break;
                }
                case 241: {
                    this.regSources[7] = null;
                }
            }
        }
    }

    @Override
    protected boolean shouldTrace(Z80Instruction z80Instruction) {
        if (z80Instruction == null) {
            return false;
        }
        if (!z80Instruction.isValid()) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xCF) == 9) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xC7) == 198) {
            return false;
        }
        if (z80Instruction.getOpCode() == 7) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xFF00) == 51968) {
            return (z80Instruction.getOpCode() & 0xFFC0) == 51968;
        }
        if ((z80Instruction.getOpCode() & 0xFFF7) == 243) {
            return false;
        }
        if (z80Instruction.getOpCode() == 233) {
            return false;
        }
        if (z80Instruction.isJump() || z80Instruction.isCall() || z80Instruction.isRet()) {
            return false;
        }
        if (z80Instruction.getOpCode() == 211) {
            return false;
        }
        if (z80Instruction.getOpCode() == 52 || z80Instruction.getOpCode() == 53 || (z80Instruction.getOpCode() & 0xFFC7) == 3 || (z80Instruction.getOpCode() & 0xFFC7) == 4 || (z80Instruction.getOpCode() & 0xFFC7) == 5) {
            return false;
        }
        if (z80Instruction.getOpCode() == 54 || (z80Instruction.getOpCode() & 0xFFF8) == 112 || (z80Instruction.getOpCode() & 0xFFCF) == 2) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xFFE7) == 39) {
            return false;
        }
        if ((z80Instruction.getOpCode() & 0xFFF8) == 184 || z80Instruction.getOpCode() == 254) {
            return false;
        }
        if (z80Instruction.getOpCode() == 183) {
            return false;
        }
        return z80Instruction.getOpCode() > 0;
    }

    @Override
    protected void setListenersEnabled(boolean bl) {
        if (bl) {
            ((GameBoy)this.getDecoratedSystem()).addOutputListener(this.outputListener);
        } else {
            ((GameBoy)this.getDecoratedSystem()).removeOutputListener(this.outputListener);
        }
    }

    int[] traceReg(int n) {
        int[] nArray = this.regSources[n];
        if (nArray != null) {
            return nArray;
        }
        int n2 = n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n3 = -1;
        for (int[] nArray2 : this.trace) {
            int n4;
            if (nArray2 == null) break;
            int n5 = nArray2[this.getIndexOfPC()];
            Z80Instruction z80Instruction = this.disassemble(n5);
            int n6 = z80Instruction.getOpCode();
            if (n6 >> 6 == 0 && ((n6 & 0xF) == 1 || (n6 & 7) == 6)) {
                if ((n6 & 0xF) == 1) {
                    n4 = n6 >> 4;
                    if (n4 >= 3 || n >> 1 != n4) continue;
                    this.regSources[n] = new int[]{n5, n5 + 2 - (n & 1)};
                    return this.regSources[n];
                }
                if ((n6 & 7) != 6 || (n4 = n6 >> 3 & 7) == 6 || n != n4) continue;
                this.regSources[n] = new int[]{n5, n5 + 1};
                return this.regSources[n];
            }
            if (n6 >> 6 == 1) {
                n4 = n6 >> 3 & 7;
                if (n != n4) continue;
                int n7 = n6 & 7;
                if (n7 == 6) {
                    if (n4 == 6) continue;
                    this.regSources[n] = new int[]{n5, nArray2[2]};
                    return this.regSources[n];
                }
                if (n4 == 6 || this.regSources[n = n7] == null) continue;
                this.regSources[n2] = this.regSources[n];
                return this.regSources[n2];
            }
            switch (n6) {
                case 10: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, nArray2[0]};
                    return this.regSources[n];
                }
                case 26: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, nArray2[1]};
                    return this.regSources[n];
                }
                case 42: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, nArray2[2]};
                    return this.regSources[n];
                }
                case 58: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, nArray2[2]};
                    return this.regSources[n];
                }
                case 240: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, this.toMappedAddress(0xFF00 | z80Instruction.getArg())};
                    return this.regSources[n];
                }
                case 250: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, this.toMappedAddress(z80Instruction.getArg())};
                    return this.regSources[n];
                }
                case 175: {
                    if (n != 7) break;
                    this.regSources[n] = new int[]{n5, -1};
                    return this.regSources[n];
                }
                case 51993: 
                case 52002: {
                    if (n != 7) break;
                    if (n6 == 52002 && n3 == 31) {
                        n = 2;
                        if (this.regSources[n] == null) break;
                        this.regSources[n2] = this.regSources[n];
                        return this.regSources[n2];
                    }
                    if (n6 != 51993 || n3 != 23 || this.regSources[n = 1] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 193: {
                    if (n >> 1 != 0) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 209: {
                    if (n >> 1 != 1) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 225: {
                    if (n >> 1 != 2) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 241: {
                    if (n >> 1 != 3) break;
                    linkedList.push(n);
                    n = -1;
                    break;
                }
                case 197: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 0 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 213: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 1 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 229: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 2 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
                case 245: {
                    if (linkedList.isEmpty() || (Integer)linkedList.peek() >> 1 != 3 || this.regSources[n = ((Integer)linkedList.pop()).intValue()] == null) break;
                    this.regSources[n2] = this.regSources[n];
                    return this.regSources[n2];
                }
            }
            n3 = n6;
        }
        int[] nArray3 = new int[2];
        nArray3[0] = this.getPrevMappedPC();
        this.regSources[n2] = nArray3;
        return nArray3;
    }

    @Override
    protected long traceMemory() {
        long l;
        int n = this.getPrevOpcode();
        if (n == 52 || n == 53) {
            return -1L;
        }
        int[] nArray = this.getMemorySource();
        if (nArray[1] <= 0) {
            nArray[1] = -nArray[1];
        } else if ((nArray[1] & 0x10000000) != 0) {
            long l2 = this.hramSources[nArray[1] & 0xFFFFFF];
            if ((int)l2 != 0 && (int)l2 != 1 && (int)l2 != 2) {
                nArray[0] = (int)(l2 >> 32);
                nArray[1] = (int)l2;
            }
        } else if ((nArray[1] & 0x8000000) != 0) {
            long l3;
            long l4 = l3 = (nArray[1] & 0xFFFFFF) < this.sramSources.length ? this.sramSources[nArray[1] & 0xFFFFFF] : 0L;
            if ((int)l3 != 0 && (int)l3 != 1 && (int)l3 != 2) {
                nArray[0] = (int)(l3 >> 32);
                nArray[1] = (int)l3;
            }
        } else if ((nArray[1] & 0x1000000) != 0 && (int)(l = this.ramSources[nArray[1] & 0xFFFFFF]) != 0 && (int)l != 1 && (int)l != 2) {
            nArray[0] = (int)(l >> 32);
            nArray[1] = (int)l;
        }
        return (long)nArray[0] << 32 | (long)nArray[1];
    }

    private int[] getMemorySource() {
        int n = this.getPrevMappedPC();
        int n2 = this.getPrevOpcode();
        int[] nArray = new int[2];
        nArray[0] = n;
        int[] nArray2 = nArray;
        switch (n2) {
            case 2: 
            case 18: 
            case 50: 
            case 224: 
            case 226: 
            case 234: {
                nArray2 = this.traceReg(7);
                break;
            }
            case 34: {
                nArray2 = this.traceReg(7);
                break;
            }
            case 54: {
                nArray2 = new int[]{n, n + 1};
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: {
                nArray2 = this.traceReg(n2 & 7);
            }
        }
        return nArray2;
    }

    @Override
    protected Z80Instruction disassemble(int n) {
        if ((n & 0x2000000) != 0) {
            return LR35902Disassembler.disassemble(this.cartridge.getRom(), n & 0xFFFFFF);
        }
        if ((n & 0x1000000) != 0) {
            return LR35902Disassembler.disassemble(this.getRAM(), n & 0xFFFFFF);
        }
        if ((n & 0x10000000) != 0) {
            GameBoy gameBoy = (GameBoy)this.getDecoratedSystem();
            return LR35902Disassembler.disassemble(gameBoy.getMemory(), 0x80 | n & 0xFFFFFF);
        }
        if ((n & 0x8000000) != 0) {
            return LR35902Disassembler.disassemble(this.getSRAM(), n & 0xFFFFFF);
        }
        return null;
    }

    @Override
    protected void handleWriteByte(int n, int n2, int n3) {
        try {
            if (GameBoy.isHRAMaddress(n)) {
                n = this.mapAddress(n);
                long l = this.traceMemory();
                if (l >= 0L && this.hramSources[n] != l) {
                    this.hramSources[n] = l;
                    GBMemoryTracer.fireOutputAvailable(0, n);
                }
            } else {
                super.handleWriteByte(n, n2, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.clearTrace();
        }
    }

    @Override
    protected String locationToString(int n) {
        int n2 = n & 0xFF000000;
        if (n2 == 0x10000000) {
            return "HRAM";
        }
        if (n2 == 0x20000000) {
            return "I/O";
        }
        return super.locationToString(n2);
    }

    @Override
    protected String addressToString(int n) {
        int n2 = n & 0xFF000000;
        if (n2 == 0x10000000) {
            return super.addressToString(0xFF80 | n & 0xFFFFFF).substring(5);
        }
        if (n2 == 0x20000000) {
            return super.addressToString(0xFF00 | n & 0xFFFFFF).substring(4);
        }
        return super.addressToString(n);
    }

    public static long getHRAMsource(int n) {
        if (!(instance instanceof GBMemoryTracer) || !enabled) {
            return 0L;
        }
        return ((GBMemoryTracer)GBMemoryTracer.instance).hramSources[n];
    }

    public static long getOAMsource(int n) {
        if (!(instance instanceof GBMemoryTracer) || !enabled) {
            return 0L;
        }
        return ((GBMemoryTracer)GBMemoryTracer.instance).oamSources[n];
    }

    @Override
    protected long[] getInstanceSpriteSources(long[] lArray) {
        if (!(instance instanceof GBMemoryTracer) || !enabled) {
            return null;
        }
        if (lArray == null || lArray.length != this.oamSources.length) {
            return (long[])this.oamSources.clone();
        }
        System.arraycopy(this.oamSources, 0, lArray, 0, lArray.length);
        return lArray;
    }
}

