/*
 * Decompiled with CFR 0.152.
 */
package output;

import components.video.GBCLCDController;
import components.video.GBLCDController;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import output.PaletteRenderer;
import output.PixelProvider;
import output.SpriteRenderer;
import output.TilemapRenderer;
import output.TilesetRenderer;
import output.ViewerCache;
import platform.DisplayWindow;
import platform.viewers.ViewerWindow;

public class GBDisplayWindow
implements PaletteRenderer,
TilesetRenderer,
TilemapRenderer,
SpriteRenderer,
PixelProvider {
    private static final String[] GB_PALETTE_NAMES;
    private static final String[] GBC_PALETTE_NAMES;
    private static final String[] BASE_ADDRESS_NAMES;
    private static final String[] TILE_BASE_ADDRESS_NAMES;
    private static final int ENTRIES_PER_PALETTE = 4;
    private static final int PALETTE_VIEWER_COLS = 2;
    private static final int PALETTE_VIEWER_ENTRY_SIZE = 16;
    private static final int PALETTE_VIEWER_SPACING_PALETTES = 8;
    private static final int PALETTE_VIEWER_SPACING_ENTRIES = 1;
    private static final int[] COLORS_GRAY;
    public static final int WIDTH = 160;
    public static final int HEIGHT = 144;
    private final DisplayWindow displayWindow;
    private int[] vram;
    private int[] oam;
    private GBLCDController lcd;
    private int[][] lines = new int[144][160];
    private int[] line = this.lines[0];
    private int[][] tileData = new int[32768][8];
    private boolean[] tileDirty = new boolean[32768];
    private int spriteToHighlight = -1;
    private int prevModeNameTimestamp;
    private final boolean[] layers = new boolean[]{true, true, true};
    private final int[] bgAndWindowDataAddress = new int[144];
    private final int[] bgTilemapDisplayAddress = new int[144];
    private final int[] hScrollValues = new int[144];
    private final int[] vScrollValues = new int[144];
    private final int[] firstLineSCY = new int[160];
    private final int[] lastLineSCY = new int[160];
    private final int[] regBGP = new int[144];
    private final int[] regOBP0 = new int[144];
    private final int[] regOBP1 = new int[144];
    private final boolean[] objHeight = new boolean[40];
    private final boolean[] objHeightSet = new boolean[40];
    private final int[] cgbColors = new int[64];
    private final int[][] cachedCgbColors = new int[144][this.cgbColors.length];
    private static boolean cgbColorsDirty;
    private static final int[] MIRRORED_BITS;
    private static final int[] STRETCHED_BITPLANE;
    private static final int[] PERMUTED_ATTRIBUTES;
    private static final int[] DMG_COLORS;
    private static final int[] CGB_COLOR_CORRECTION;
    private static double[] cgbColorCorrectionSums;

    static {
        int n;
        GB_PALETTE_NAMES = new String[]{"Auto", "Gray", "BGP0", "OBP0", "OBP1"};
        GBC_PALETTE_NAMES = new String[]{"Auto", "Gray", "BGP0", "BGP1", "BGP2", "BGP3", "BGP4", "BGP5", "BGP6", "BGP7", "OBP0", "OBP1", "OBP2", "OBP3", "OBP4", "OBP5", "OBP6", "OBP7"};
        BASE_ADDRESS_NAMES = new String[]{"Auto", "9800", "9C00"};
        TILE_BASE_ADDRESS_NAMES = new String[]{"Auto", "8000", "8800"};
        COLORS_GRAY = new int[]{DisplayWindow.COLOR_WHITE, DisplayWindow.COLOR_LIGHT_GRAY, DisplayWindow.COLOR_DARK_GRAY, DisplayWindow.COLOR_BLACK};
        MIRRORED_BITS = new int[256];
        STRETCHED_BITPLANE = new int[256];
        PERMUTED_ATTRIBUTES = new int[256];
        DMG_COLORS = new int[]{DisplayWindow.COLOR_WHITE, DisplayWindow.COLOR_LIGHT_GRAY, DisplayWindow.COLOR_DARK_GRAY, DisplayWindow.COLOR_BLACK};
        CGB_COLOR_CORRECTION = new int[9];
        cgbColorCorrectionSums = new double[3];
        int n2 = 0;
        while (n2 < MIRRORED_BITS.length) {
            n = n2;
            int n3 = 8;
            while (n > 0) {
                int n4 = n2;
                MIRRORED_BITS[n4] = MIRRORED_BITS[n4] << 1;
                int n5 = n2;
                MIRRORED_BITS[n5] = MIRRORED_BITS[n5] | n & 1;
                n >>= 1;
                --n3;
            }
            int n6 = n2++;
            MIRRORED_BITS[n6] = MIRRORED_BITS[n6] << n3;
        }
        n2 = 0;
        while (n2 < STRETCHED_BITPLANE.length) {
            n = 0;
            while (n < 8) {
                if ((n2 & 1 << n) != 0) {
                    int n7 = n2;
                    STRETCHED_BITPLANE[n7] = STRETCHED_BITPLANE[n7] | 1 << (n << 1);
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < PERMUTED_ATTRIBUTES.length) {
            GBDisplayWindow.PERMUTED_ATTRIBUTES[n2] = (n2 & 0x60) >> 4;
            int n8 = n2;
            PERMUTED_ATTRIBUTES[n8] = PERMUTED_ATTRIBUTES[n8] | (n2 & 8) >> 3;
            ++n2;
        }
    }

    public static void setDmgColors(int[] nArray) {
        if (nArray == null) {
            GBDisplayWindow.DMG_COLORS[0] = DisplayWindow.COLOR_WHITE;
            GBDisplayWindow.DMG_COLORS[1] = DisplayWindow.COLOR_LIGHT_GRAY;
            GBDisplayWindow.DMG_COLORS[2] = DisplayWindow.COLOR_DARK_GRAY;
            GBDisplayWindow.DMG_COLORS[3] = DisplayWindow.COLOR_BLACK;
            return;
        }
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Number of colors must be 4");
        }
        int n = 0;
        while (n < nArray.length) {
            GBDisplayWindow.DMG_COLORS[n] = nArray[n];
            ++n;
        }
    }

    public static void setCgbColorCorrection(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("colorCorrection must not be null");
        }
        if (nArray.length != 9) {
            throw new IllegalArgumentException("colorCorrection must have 9 entries");
        }
        System.arraycopy(nArray, 0, CGB_COLOR_CORRECTION, 0, nArray.length);
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                n2 += nArray[n * 3 + n3];
                ++n3;
            }
            GBDisplayWindow.cgbColorCorrectionSums[n] = n2;
            ++n;
        }
        cgbColorsDirty = true;
    }

    public GBDisplayWindow(DisplayWindow displayWindow) {
        this.displayWindow = displayWindow;
    }

    public void makeTileDirty(int n) {
        this.tileDirty[n] = true;
        this.tileDirty[0x1000 | n] = true;
        this.tileDirty[0x2000 | n] = true;
        this.tileDirty[0x3000 | n] = true;
        this.tileDirty[0x4000 | n ^ 7] = true;
        this.tileDirty[0x5000 | n ^ 7] = true;
        this.tileDirty[0x6000 | n ^ 7] = true;
        this.tileDirty[0x7000 | n ^ 7] = true;
    }

    private void updateTile(int n) {
        if (this.tileDirty[n]) {
            int n2 = (n & 0xFFF) << 1;
            if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 && (n & 0x1000) != 0) {
                n2 |= 0x2000;
            }
            if ((n & 0x4000) != 0) {
                n2 ^= 0xE;
            }
            int n3 = this.vram[n2];
            int n4 = this.vram[n2 | 1];
            if (n3 == 0 && n4 == 0) {
                Arrays.fill(this.tileData[n], 0);
            } else {
                if ((n & 0x2000) == 0) {
                    n3 = MIRRORED_BITS[n3];
                    n4 = MIRRORED_BITS[n4];
                }
                int n5 = STRETCHED_BITPLANE[n4] << 1 | STRETCHED_BITPLANE[n3];
                int n6 = 0;
                while (n6 < 8) {
                    int n7 = n5 & 3;
                    n5 >>= 2;
                    this.tileData[n][n6] = n7;
                    ++n6;
                }
            }
            this.tileDirty[n] = false;
        }
    }

    private int[] getTileData(int n) {
        int[] nArray = this.tileData[n];
        if (this.tileDirty[n]) {
            nArray = (int[])nArray.clone();
            int n2 = (n & 0xFFF) << 1;
            if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 && (n & 0x1000) != 0) {
                n2 |= 0x2000;
            }
            if ((n & 0x4000) != 0) {
                n2 ^= 0xE;
            }
            int n3 = this.vram[n2];
            int n4 = this.vram[n2 | 1];
            if (n3 == 0 && n4 == 0) {
                Arrays.fill(nArray, 0);
            } else {
                if ((n & 0x2000) == 0) {
                    n3 = MIRRORED_BITS[n3];
                    n4 = MIRRORED_BITS[n4];
                }
                int n5 = STRETCHED_BITPLANE[n4] << 1 | STRETCHED_BITPLANE[n3];
                int n6 = 0;
                while (n6 < 8) {
                    int n7 = n5 & 3;
                    n5 >>= 2;
                    nArray[n6] = n7;
                    ++n6;
                }
            }
        }
        return nArray;
    }

    public void renderBlankScreen() {
        if (this.displayWindow != null) {
            this.displayWindow.fill(this.lcd instanceof GBCLCDController ? DisplayWindow.COLOR_WHITE : DMG_COLORS[0]);
            this.displayWindow.renderFrame(false);
        }
    }

    public void renderStopScreen() {
        if (this.displayWindow != null) {
            this.displayWindow.fill(this.lcd instanceof GBCLCDController ? DisplayWindow.COLOR_BLACK : DMG_COLORS[0]);
            this.displayWindow.renderFrame(false);
        }
    }

    public void avoidFrameSkip() {
        if (this.displayWindow != null) {
            while (this.displayWindow.shouldSkipFrame()) {
                this.displayWindow.renderFrame(false);
            }
        }
    }

    public void renderFrame() {
        if (this.displayWindow != null) {
            cgbColorsDirty = true;
            Arrays.fill(this.tileDirty, true);
            this.renderLine(0);
            int n = this.lcd.getRegLY() + 1;
            while (n < 144) {
                this.lcd.fillSpriteBuffer(n);
                this.lcd.updateWySatisfied(n);
                this.renderLine(n);
                ++n;
            }
            n = 0;
            while (n <= Math.min(143, this.lcd.getRegLY())) {
                this.lcd.fillSpriteBuffer(n);
                this.lcd.updateWySatisfied(n);
                this.renderLine(n);
                ++n;
            }
            this.displayWindow.renderFrame(false);
        }
    }

    public void drawCurrentLine() {
        this.renderLine(this.lcd.getRegLY());
    }

    private void renderLine(int n) {
        int n2;
        if (!this.displayWindow.shouldSkipFrame()) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (n == 0) {
                if (cgbColorsDirty) {
                    n2 = 0;
                    while (n2 < 64) {
                        this.updateColor(n2 & 3, n2 >> 2);
                        ++n2;
                    }
                    cgbColorsDirty = false;
                }
                n2 = 0;
                while (n2 < this.firstLineSCY.length) {
                    this.firstLineSCY[n2] = this.lcd.getSCY(n2);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.objHeight.length) {
                    if (!this.objHeightSet[n2]) {
                        this.objHeight[n2] = this.lcd.getOBJHeight(0) == 16;
                    }
                    ++n2;
                }
                Arrays.fill(this.objHeightSet, false);
            }
            this.line = this.lines[n];
            Arrays.fill(this.line, 0);
            int n11 = n2 = (this.lcd.getMode() & 4) != 0 ? 1 : 0;
            if (this.layers[0]) {
                n10 = -this.lcd.getSCXlow();
                this.displayWindow.setCursorDirect(0, n);
                n9 = 0;
                while (n9 <= 20 && n10 < 160) {
                    n8 = n + this.lcd.getSCY(n10);
                    n7 = n8 / 8;
                    n6 = n + this.lcd.getSCY(n10, 2) & 7;
                    n5 = n + this.lcd.getSCY(n10, 4) & 7;
                    n4 = this.lcd.getBGTileMapDisplayAddress(n9) | (n7 & 0x1F) << 5;
                    n3 = 0;
                    if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
                        n3 = this.vram[0x2000 | n4 | n9 + (this.lcd.getSCX(n10 / 8) >> 3) & 0x1F];
                    }
                    this.drawBGandWindowTile(this.vram[n4 | n9 + (this.lcd.getSCX(n10 / 8) >> 3) & 0x1F], n3, n10, n6, n5, n2 != 0, false);
                    ++n9;
                    n10 += 8;
                }
            }
            if (this.layers[1] && this.lcd.getWindowEnabledWX() <= 166 && this.lcd.isWySatisfied()) {
                n10 = 0;
                n9 = this.lcd.getWindowLine() / 8;
                n8 = this.lcd.getWindowEnabledWX() - 7;
                if (n8 == -7 && this.lcd.getSCXlow() > 0) {
                    n8 = this.lcd.getSCXlow() == 7 ? ++n8 : (n8 += 7 - this.lcd.getSCXlow());
                }
                if (!(this.lcd instanceof GBCLCDController) && this.lcd.getWindowEnabledWX() == 166) {
                    if (this.lcd.getSCXlow() == 0) {
                        n8 = 0;
                        n7 = 1;
                    } else {
                        n8 += 7 - this.lcd.getSCXlow();
                        n7 = 0;
                    }
                } else {
                    n7 = 0;
                }
                n6 = this.lcd.getWindowLine() & 7;
                this.displayWindow.setCursorDirect(Math.max(0, n8), n);
                n5 = this.lcd.isWindowDisplayEnabled(n8 / 8) ? 1 : 0;
                n4 = n7;
                while (n4 <= 20 && n8 < 160) {
                    if (n5 != 0) {
                        if (n8 >= 0 && n8 == this.lcd.getWX(n8) - 7 && this.lcd.getWX(n8) != this.lcd.getWindowEnabledWX()) {
                            n3 = n2 != 0 ? this.lcd.getRegBGP(n8) & 3 : 0;
                            this.displayWindow.setColorDirect(n8, n, this.getColor(n3, 0, n8));
                            this.line[n8] = 64;
                            ++n8;
                        }
                        n3 = this.lcd.getWindowTileMapDisplayAddress(n4) | (n9 & 0x1F) << 5;
                        int n12 = 0;
                        if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
                            n12 = this.vram[0x2000 | n3 | n4 & 0x1F];
                        }
                        this.drawBGandWindowTile(this.vram[n3 | n4 & 0x1F], n12, n8, n6, n6, n2 != 0, true);
                        n10 = 1;
                        n5 = this.lcd.isWindowDisplayEnabled(n8 / 8) ? 1 : 0;
                    }
                    ++n4;
                    n8 += 8;
                }
                if (n10 != 0) {
                    this.lcd.incWindowLine();
                }
                if (n5 == 0 && (this.lcd.getWindowEnabledWX() & 7) == 7 - this.lcd.getSCXlow() && !(this.lcd instanceof GBCLCDController)) {
                    n4 = 159;
                    while (n4 >= 0 && n4 > this.lcd.getWindowEnabledWX() - 7) {
                        this.displayWindow.setColorDirect(n4, n, this.displayWindow.getColorDirect(n4 - 1, n));
                        --n4;
                    }
                    if (n4 >= 0) {
                        System.arraycopy(this.line, n4, this.line, n4 + 1, this.line.length - (n4 + 1));
                        this.line[n4] = 64;
                        n3 = n2 != 0 ? this.lcd.getRegBGP(n4) & 3 : 0;
                        this.displayWindow.setColorDirect(n4, n, this.getColor(n3, 0, n4));
                    }
                }
            }
            if (this.layers[2]) {
                this.drawSprites(n, n2 != 0);
            }
        }
        if (n == 143 && !this.lcd.isFirstFrame()) {
            this.displayWindow.renderFrame(true);
            n2 = 0;
            while (n2 < this.lastLineSCY.length) {
                this.lastLineSCY[n2] = this.lcd.getSCY(n2);
                ++n2;
            }
        }
        this.bgAndWindowDataAddress[n] = this.lcd.getBGandWindowDataAddress(0, 0);
        this.bgTilemapDisplayAddress[n] = this.lcd.getBGTileMapDisplayAddress(0);
        this.hScrollValues[n] = this.lcd.getSCX(0) & 0xF8 | this.lcd.getSCXlow();
        this.vScrollValues[n] = this.lcd.getSCY(0);
        if (this.lcd instanceof GBCLCDController) {
            System.arraycopy(this.cgbColors, 0, this.cachedCgbColors[n], 0, this.cgbColors.length);
            this.regBGP[n] = this.lcd.getRegBGP();
            this.regOBP0[n] = this.lcd.getRegOBP0();
            this.regOBP1[n] = this.lcd.getRegOBP1();
        }
    }

    public void updateColor(int n, int n2) {
        this.cgbColors[n2 << 2 | n] = GBDisplayWindow.calcCgbColor(n, n2 >= 8 ? this.lcd.getOBP(n2 & 7) : this.lcd.getBGP(0, n2));
    }

    private int getColor(int n, int n2, int n3) {
        return this.getColor(n, n2, n3, this.cgbColors);
    }

    private int getColor(int n, int n2, int n3, int[] nArray) {
        if (this.lcd instanceof GBCLCDController) {
            return nArray[n2 << 2 | n];
        }
        int n4 = (int)(n2 >= 8 ? (long)(n2 == 9 ? this.lcd.getRegOBP1(n3) : this.lcd.getRegOBP0(n3)) : this.lcd.getBGP(n3, 0));
        return DMG_COLORS[n4 >> n * 2 & 3];
    }

    private static int calcCgbColor(int n, long l) {
        int n2 = (int)(l >> n * 16 & 0xFFFFL);
        int n3 = Math.max(0, (n2 & 0x1F) - 1);
        int n4 = Math.max(0, (n2 >> 5 & 0x1F) - 1);
        int n5 = Math.max(0, (n2 >> 10 & 0x1F) - 1);
        return DisplayWindow.toPlatformColor(GBDisplayWindow.calcCorrectedColor(n3, n4, n5, 0), GBDisplayWindow.calcCorrectedColor(n3, n4, n5, 1), GBDisplayWindow.calcCorrectedColor(n3, n4, n5, 2));
    }

    private static int calcCorrectedColor(int n, int n2, int n3, int n4) {
        if (cgbColorCorrectionSums[n4] == 0.0) {
            return (n4 == 0 ? n : (n4 == 1 ? n2 : n3)) * 255 / 30;
        }
        int n5 = n4 * 3;
        double d = 30.0 - (double)(n * CGB_COLOR_CORRECTION[n5] + n2 * CGB_COLOR_CORRECTION[n5 + 1] + n3 * CGB_COLOR_CORRECTION[n5 + 2]) / cgbColorCorrectionSums[n4];
        return (int)(255.0 - d * d * 255.0 / 900.0);
    }

    private void drawBGandWindowTile(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        int n7;
        int n8;
        boolean bl3 = (n2 & 0x80) != 0;
        int n9 = n2 & 7;
        int n10 = this.lcd.getBGandWindowDataAddress(n3, 0) != 0 ? 128 + (n ^ 0x80) : n;
        int n11 = this.lcd.getBGandWindowDataAddress(n3, 2) != 0 ? 128 + (n ^ 0x80) : n;
        int n12 = PERMUTED_ATTRIBUTES[n2] << 9 | n10;
        int n13 = (n12 & 0xFFF) << 3 | n4;
        int n14 = Math.min(8, 160 - n3);
        this.updateTile(n13);
        int[] nArray = this.tileData[n13];
        if (n3 < 0) {
            n8 = -n3;
            n3 = 0;
        } else {
            n8 = 0;
        }
        if (n11 != n10) {
            n7 = PERMUTED_ATTRIBUTES[n2] << 9 | n11;
            n6 = (n7 & 0xFFF) << 3 | n5;
            int[] nArray2 = this.tileData[n6];
            this.updateTile(n6);
            int n15 = 0;
            while (n15 < nArray.length) {
                nArray[n15] = nArray2[n15] & 2 | nArray[n15] & 1;
                ++n15;
            }
            this.tileDirty[n13] = true;
        } else if (n5 != n4) {
            n7 = (n12 & 0xFFF) << 3 | n5;
            int[] nArray3 = this.tileData[n7];
            this.updateTile(n7);
            int n16 = 0;
            while (n16 < nArray.length) {
                nArray[n16] = nArray3[n16] & 2 | nArray[n16] & 1;
                ++n16;
            }
            this.tileDirty[n13] = true;
        }
        n7 = n8;
        while (n7 < n14) {
            n6 = this.lcd.isBGDisplayEnabled(n3) ? this.lcd.mixWithTileSelReset(n3, n >> (n7 ^ 7) & 1, nArray[n7]) : 0;
            this.line[n3] = n9 << 10 | (bl3 ? 0x8000 | n6 : n6);
            if (bl2) {
                int n17 = n3;
                this.line[n17] = this.line[n17] | 0x40;
            }
            if (bl) {
                n6 = this.lcd.getRegBGP(n3) >> n6 * 2 & 3;
            }
            this.displayWindow.setNextColor(this.getColor(n6, n9, n3));
            ++n7;
            ++n3;
        }
    }

    private void drawSpriteTile(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        int n7 = n6 - n5;
        if (n7 >= 0 && n7 < 8) {
            int n8;
            int n9 = 8 | (this.lcd instanceof GBCLCDController && !bl ? n3 & 7 : (n3 & 0x10) >> 4);
            boolean bl3 = (n3 & 0x80) != 0;
            boolean bl4 = (n3 & 0x10) != 0;
            int n10 = PERMUTED_ATTRIBUTES[n3] << 9 | n2;
            int n11 = (n10 & 0xFFF) << 3 | n7;
            int n12 = Math.min(8, 160 - n4);
            this.updateTile(n11);
            int[] nArray = this.tileData[n11];
            if (n4 < 0) {
                n8 = -n4;
                n4 = 0;
            } else {
                n8 = 0;
            }
            int n13 = n8;
            while (n13 < n12) {
                int n14;
                if (this.lcd.isOBJDisplayEnabled(n4) && (n14 = nArray[n13]) > 0 && (this.line[n4] & 0x4000) == 0) {
                    if ((this.line[n4] & 0x80) != 0) {
                        if (bl2 && this.oam[n << 2 | 1] < this.oam[(this.line[n4] & 0x3F) << 2 | 1]) {
                            if (bl) {
                                n14 = (bl4 ? this.lcd.getRegOBP1(n4) : this.lcd.getRegOBP0(n4)) >> n14 * 2 & 3;
                            }
                            this.displayWindow.setColorDirect(n4, n6, this.getColor(n14, n9, n4));
                            this.line[n4] = n9 << 10 | n14 << 8 | 0x80 | n;
                        }
                    } else if (this.lcd.isBGPriorityOverride(n4) || (this.line[n4] & 0x8000) == 0 && !bl3 || (this.line[n4] & 3) == 0) {
                        if (bl) {
                            n14 = (bl4 ? this.lcd.getRegOBP1(n4) : this.lcd.getRegOBP0(n4)) >> n14 * 2 & 3;
                        }
                        this.displayWindow.setColorDirect(n4, n6, this.getColor(n14, n9, n4));
                        this.line[n4] = n9 << 10 | n14 << 8 | 0x80 | n;
                    } else {
                        int n15 = n4;
                        this.line[n15] = this.line[n15] | 0x4000;
                    }
                }
                ++n13;
                ++n4;
            }
        }
    }

    private void drawSprites(int n, boolean bl) {
        int n2 = this.lcd.getSpriteCount();
        boolean bl2 = this.lcd.isOBJxBasedPriority();
        boolean bl3 = this.lcd.getOBJHeight(0) == 16;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.lcd.getSpriteBufferIndex(n3);
            int n5 = this.oam[n4 << 2];
            int n6 = this.oam[n4 << 2 | 1];
            this.objHeight[n4] = bl3;
            this.objHeightSet[n4] = true;
            if (n6 < 168) {
                boolean bl4 = this.lcd.getOBJHeight(n6) == 16;
                int n7 = this.lcd.getSpriteTileNumber(n4, n6);
                int n8 = this.lcd.getSpriteAttributes(n4, n6);
                if (bl3) {
                    if ((n8 & 0x40) != 0) {
                        this.drawSpriteTile(n4, n7 & 0xFE, n8, n6 - 8, n5 - 8, n, bl, bl2);
                        this.drawSpriteTile(n4, bl4 ? n7 | 1 : n7 & 0xFE, n8, n6 - 8, n5 - 16, n, bl, bl2);
                    } else {
                        this.drawSpriteTile(n4, n7 & 0xFE, n8, n6 - 8, n5 - 16, n, bl, bl2);
                        this.drawSpriteTile(n4, bl4 ? n7 | 1 : n7 & 0xFE, n8, n6 - 8, n5 - 8, n, bl, bl2);
                    }
                } else {
                    this.drawSpriteTile(n4, n7, n8, n6 - 8, n5 - 16, n, bl, bl2);
                }
            }
            ++n3;
        }
        if (this.spriteToHighlight >= 0 && n2 > 0) {
            this.highlightSprite(this.spriteToHighlight, false);
        }
    }

    private void highlightSprite(int n, boolean bl) {
        int n2;
        if (n < 0) {
            if (bl) {
                this.displayWindow.eraseSelectionCursor();
            }
            return;
        }
        int n3 = this.oam[n << 2];
        int n4 = this.oam[n << 2 | 1];
        if (n3 == 0 || n3 >= 160 || n4 == 0 || n4 >= 168) {
            return;
        }
        if (bl) {
            this.displayWindow.setSelectionCursor(n4 - 8, n3 - 16, 8, this.lcd.getOBJHeight(0));
            return;
        }
        this.displayWindow.eraseSelectionCursor();
        boolean bl2 = this.lcd.getOBJHeight(0) == 16;
        int n5 = this.lcd.getRegLY();
        if (bl2 && (n5 - (n3 - 16) < 0 || n5 - (n3 - 16) >= 16) || !bl2 && (n5 - (n3 - 16) < 0 || n5 - (n3 - 16) >= 8)) {
            return;
        }
        int n6 = n5 - (n3 - 16);
        int n7 = n2 = bl2 ? 15 : 7;
        if (n6 >= 0 && n6 <= n2) {
            if (n6 == 0 || n6 == n2) {
                this.displayWindow.setColor(Math.max(0, n4 - 8), n5, Math.min(8, n4), DisplayWindow.COLOR_LIGHT_GRAY);
            } else {
                if (n4 - 8 >= 0) {
                    this.displayWindow.setColor(n4 - 8, n5, DisplayWindow.COLOR_LIGHT_GRAY);
                }
                if (n4 - 8 + 8 - 1 >= 0 && n4 - 8 + 8 - 1 < 160) {
                    this.displayWindow.setColor(Math.max(0, n4 - 8 + 8 - 1), n5, DisplayWindow.COLOR_LIGHT_GRAY);
                }
            }
        }
    }

    public void setLCD(GBLCDController gBLCDController) {
        this.lcd = gBLCDController;
        this.vram = gBLCDController.getVRAM();
        this.oam = gBLCDController.getOAM();
        this.displayWindow.init(160, 144);
        cgbColorsDirty = gBLCDController instanceof GBCLCDController;
    }

    @Override
    public Dimension getPaletteDimension(ViewerWindow viewerWindow) {
        int n = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 8 : 2;
        int n2 = viewerWindow.getFontHeight();
        int n3 = viewerWindow.getCharWidth('7') + 4;
        return new Dimension(n3 + 152 - 8, n2 + n * 17);
    }

    @Override
    public boolean hideColorIndex() {
        return true;
    }

    @Override
    public void renderPalettes(ViewerWindow viewerWindow) {
        if (this.lcd == null) {
            return;
        }
        boolean bl = (this.lcd.getMode() & 4) != 0;
        int n = this.lcd instanceof GBCLCDController && !bl ? 8 : 2;
        int n2 = viewerWindow.getFontHeight();
        int n3 = viewerWindow.getCharWidth('7') + 4;
        int n4 = 0;
        while (n4 < n) {
            int n5 = n2 + n4 * 17;
            viewerWindow.drawString(Integer.toString(n4), 2, n5 + 8 - n2 / 2);
            int n6 = 0;
            while (n6 < 2) {
                boolean bl2;
                boolean bl3 = bl2 = n6 == 1;
                if (bl2 || n4 <= 0 || this.lcd instanceof GBCLCDController && !bl) {
                    int n7 = n6 << 3 | n4;
                    int n8 = n3 + n6 * 8 + n6 * 17 * 4;
                    if (n4 == 0) {
                        String string = bl2 ? "OBP" : "BGP";
                        viewerWindow.drawString(string, n8 + 34 - viewerWindow.getStringWidth(string) / 2, 0);
                    }
                    int n9 = 0;
                    while (n9 < 4) {
                        int n10 = 0;
                        while (n10 < 16) {
                            int n11 = this.lcd instanceof GBCLCDController && bl ? (bl2 ? (n4 == 1 ? this.lcd.getRegOBP1() : this.lcd.getRegOBP0()) >> n9 * 2 & 3 : this.lcd.getRegBGP() >> n9 * 2 & 3) : n9;
                            viewerWindow.setColor(n8 + n9 * 17, n5 + n10, 16, this.getColor(n11, n7, 0));
                            ++n10;
                        }
                        ++n9;
                    }
                }
                ++n6;
            }
            ++n4;
        }
    }

    @Override
    public int getColor(int n) {
        if (this.lcd instanceof GBCLCDController) {
            int n2;
            int n3 = n2 = (this.lcd.getMode() & 4) == 0 ? 8 : 1;
            if (n < n2 * 4) {
                return (int)(this.lcd.getBGP(0, n / 4) >> n * 16 & 0xFFFFL);
            }
            return (int)(this.lcd.getOBP((n -= n2 * 4) / 4) >> n * 16 & 0xFFFFL);
        }
        if (n < 4) {
            return (int)this.lcd.getBGP(0, 0) >> n * 2 & 3;
        }
        return (int)this.lcd.getOBP((n -= 4) / 4) >> (n & 3) * 2 & 3;
    }

    private int getBGR(int n) {
        if (this.lcd instanceof GBCLCDController) {
            return this.getColor(n);
        }
        switch (this.getColor(n)) {
            case 0: {
                return Short.MAX_VALUE;
            }
            case 1: {
                return 21140;
            }
            case 2: {
                return 10570;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getBlue(int n) {
        return this.getBGR(n) >> 10 & 0x1F;
    }

    @Override
    public int getGreen(int n) {
        return this.getBGR(n) >> 5 & 0x1F;
    }

    @Override
    public int getRed(int n) {
        return this.getBGR(n) & 0x1F;
    }

    @Override
    public boolean isColorValid(int n) {
        if (n < 0) {
            return false;
        }
        if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
            return n < 64;
        }
        return n < 12;
    }

    @Override
    public int getColorAt(int n, int n2, ViewerWindow viewerWindow) {
        int n3 = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 8 : 2;
        int n4 = viewerWindow.getFontHeight();
        int n5 = viewerWindow.getCharWidth('7') + 4;
        int n6 = (n2 - n4) / 17;
        int n7 = (n -= n5) / 75;
        if ((n -= n7 * 75) < 0 || n2 < n4 || n >= 67) {
            return -1;
        }
        if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
            return (n7 * n3 + n6) * 4 + n / 17;
        }
        if (n6 > n7) {
            return -1;
        }
        return (n7 + n6) * 4 + n / 17;
    }

    @Override
    public int getColorX(int n, ViewerWindow viewerWindow) {
        int n2 = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 8 : 2;
        int n3 = viewerWindow.getCharWidth('7') + 4;
        if (!(this.lcd instanceof GBCLCDController) || (this.lcd.getMode() & 4) != 0) {
            return (n >= 4 ? n3 + 68 + 8 : n3) + n % 4 * 17;
        }
        return (n >= n2 * 4 ? n3 + 68 + 8 : n3) + n % 4 * 17;
    }

    @Override
    public int getColorY(int n, ViewerWindow viewerWindow) {
        int n2 = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 8 : 2;
        int n3 = viewerWindow.getFontHeight();
        if (!(this.lcd instanceof GBCLCDController) || (this.lcd.getMode() & 4) != 0) {
            return n3 + (n >= 8 ? 17 : 0);
        }
        return n3 + (n %= n2 * 4) / 4 * 17;
    }

    @Override
    public int getColorEntrySize() {
        return 16;
    }

    @Override
    public int getBytesPerColor() {
        return this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 2 : 1;
    }

    @Override
    public Dimension getTilesetDimension(int n, boolean bl, boolean bl2) {
        int n2 = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 2 : 1;
        int n3 = 384 / n;
        boolean bl3 = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 && n3 < n;
        int n4 = bl2 ? 9 : 8;
        int n5 = bl2 ? 9 : 8;
        return new Dimension((!bl3 && n2 > 1 ? n * n2 * n4 + 1 : n * n4) - (bl2 ? 1 : 0), (bl3 && n2 > 1 ? (bl ? n3 / 2 * n2 * (bl2 ? 17 : 16) : n3 * n2 * n5) + 3 : (bl ? n3 / 2 * (bl2 ? 17 : 16) : n3 * n5)) + 2 - (bl2 ? 1 : 0));
    }

    @Override
    public int getTileWidth(boolean bl) {
        return 8;
    }

    @Override
    public boolean isLayoutSupported(int n) {
        int n2;
        int n3 = n2 = this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 2 : 1;
        return n2 * 384 % n == 0 && (n & n - 1) == 0;
    }

    @Override
    public boolean is8x16supported() {
        return true;
    }

    @Override
    public int getTileAt(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        int n5 = n4 = bl2 ? 9 : 8;
        int n6 = bl ? (bl2 ? 17 : 16) : (bl2 ? 9 : 8);
        int n7 = n2 / n6 / (128 / n3);
        int n8 = n / n4 / n3 + n7 / 3;
        n2 -= (n7 %= 3);
        if (this.isTilesetVertical(n3)) {
            n2 -= n8 * 3;
        } else {
            n -= n8;
        }
        int n9 = n2 / n6 * n3 + n / n4 % n3;
        if (bl) {
            n9 *= 2;
        }
        if (n >= n3 * n4) {
            n9 += 512;
        } else if (n9 >= 384) {
            n9 += 128;
        }
        return n9;
    }

    @Override
    public boolean isTileValid(int n) {
        return n >= 0 && n < (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 ? 896 : 384) && (n < 384 || n >= 512);
    }

    @Override
    public int getTileX(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = n3 = bl2 ? 9 : 8;
        if (n >= 512) {
            n -= 512;
            if (this.isTilesetVertical(n2)) {
                return (bl ? n >> 1 : n) % n2 * n3;
            }
            return n2 * n3 + 1 + (bl ? n >> 1 : n) % n2 * n3;
        }
        return (bl ? n >> 1 : n) % n2 * n3;
    }

    @Override
    public int getTileY(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = bl ? (bl2 ? 17 : 16) : (bl2 ? 9 : 8);
        int n5 = n3 = n >= 512 && this.isTilesetVertical(n2) ? 3 : 0;
        if (n >= 512) {
            n -= !this.isTilesetVertical(n2) ? 512 : 128;
        }
        int n6 = (bl ? n >> 1 : n) / n2;
        return n6 * n4 + n % 384 / 128 + n3;
    }

    @Override
    public int getTileVRAMaddress(int n) {
        return 16 * n;
    }

    @Override
    public int getTilePixelColor(int n, int n2, int n3, ViewerCache viewerCache) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (n >= 384) {
            n -= 128;
        }
        if (!(this.lcd instanceof GBCLCDController) && (n3 -= 2) > 0) {
            n3 += 7;
        }
        boolean bl = (this.lcd.getMode() & 4) != 0;
        int[] nArray = n3 < 0 ? this.guessPalettes(bl, viewerCache) : null;
        int n4 = nArray != null ? nArray[n] : n3;
        int n5 = n2 / 8;
        int n6 = n2 % 8;
        boolean bl2 = n4 >= 8;
        int n7 = (bl && (nArray != null && nArray[n5] == 9 || n3 == 9) ? 16 : 0) | (n >= 384 ? 8 : 0);
        int n8 = PERMUTED_ATTRIBUTES[n7] << 9 | n % 384;
        int n9 = (n8 & 0xFFF) << 3 | n5;
        int[] nArray2 = this.getTileData(n9);
        int n10 = nArray2[n6];
        if (bl) {
            n10 = bl2 ? ((n7 & 0x10) != 0 ? this.lcd.getRegOBP1() : this.lcd.getRegOBP0()) >> n10 * 2 & 3 : this.lcd.getRegBGP() >> n10 * 2 & 3;
        }
        return 4 * n4 + n10;
    }

    @Override
    public int getTilePixelOffset(int n) {
        return n / 8 * 2;
    }

    @Override
    public String getTileCPUaddress(int n) {
        return GBDisplayWindow.vramAddressToCPUaddress(this.getTileVRAMaddress(n));
    }

    private static String vramAddressToCPUaddress(int n) {
        int n2 = n / 8192;
        int n3 = 0x8000 | n & 0x1FFF;
        return String.format("%02X:%04X", n2, n3);
    }

    private boolean isTilesetVertical(int n) {
        int n2 = 384 / n;
        return this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0 && n2 < n;
    }

    @Override
    public void renderTileset(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        int n3;
        int n4;
        int n5;
        if (this.lcd == null) {
            return;
        }
        if (!(this.lcd instanceof GBCLCDController) && (n -= 2) > 0) {
            n += 7;
        }
        boolean bl3 = (this.lcd.getMode() & 4) != 0;
        int[] nArray = n == -2 ? this.guessPalettes(bl3, viewerCache) : null;
        int n6 = bl2 ? 9 : 8;
        int n7 = bl2 ? 9 : 8;
        int n8 = 0;
        while (n8 < 384) {
            n5 = bl3 && (nArray != null && nArray[n8] == 9 || n == 9) ? 16 : 0;
            n4 = (bl ? n8 >> 1 : n8) % n2 * n6;
            n3 = (bl ? (n8 >> 1) / n2 * (bl2 ? 17 : 16) + (n8 & 1) * 8 : n8 / n2 * n7) + n8 / 128;
            this.renderTile(viewerWindow, n8, n5, n4, n3, nArray != null ? nArray[n8] : n);
            ++n8;
        }
        if (this.lcd instanceof GBCLCDController && !bl3) {
            n8 = 384 / n2;
            n5 = this.lcd instanceof GBCLCDController && !bl3 && n8 < n2 ? 1 : 0;
            n4 = 0;
            while (n4 < 384) {
                n3 = (n5 == 0 ? n2 * n6 + 1 : 0) + (bl ? n4 >> 1 : n4) % n2 * n6;
                int n9 = (n5 != 0 ? (bl ? n8 / 2 * (bl2 ? 17 : 16) : n8 * n7) + 3 : 0) + (bl ? (n4 >> 1) / n2 * (bl2 ? 17 : 16) + (n4 & 1) * 8 : n4 / n2 * n7) + n4 / 128;
                this.renderTile(viewerWindow, n4, 8, n3, n9, nArray != null ? nArray[384 + n4] : n);
                ++n4;
            }
        }
    }

    @Override
    public void renderTile(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        if (this.lcd == null || !this.isTileValid(n)) {
            return;
        }
        if (!(this.lcd instanceof GBCLCDController) && (n2 -= 2) > 0) {
            n2 += 7;
        }
        boolean bl3 = (this.lcd.getMode() & 4) != 0;
        int[] nArray = n2 == -2 ? this.guessPalettes(bl3, viewerCache) : null;
        int n3 = n >= 384 ? n - 128 : n;
        int n4 = bl3 && (nArray != null && nArray[n3] == 9 || n2 == 9) ? 16 : 0;
        this.renderTile(viewerWindow, bl ? n & 0xFFFFFFFE : n, n4, 0, 0, nArray != null ? nArray[n3] : n2);
        if (bl) {
            this.renderTile(viewerWindow, n | 1, n4, 0, 8, nArray != null ? nArray[n3] : n2);
        }
    }

    private int[] guessPalettes(boolean bl, ViewerCache viewerCache) {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray = viewerCache.getGuessedPalettes(this.lcd instanceof GBCLCDController && !bl ? 768 : 384);
        Arrays.fill(nArray, -1);
        int n5 = 0;
        while (n5 < 40) {
            n4 = this.oam[n5 << 2 | 2];
            n3 = this.oam[n5 << 2 | 3];
            n2 = 8 + (this.lcd instanceof GBCLCDController && !bl ? n3 & 7 : (n3 & 0x10) >> 4);
            int n6 = n = this.lcd instanceof GBCLCDController && !bl ? (n3 & 8) >> 3 : 0;
            if (this.objHeight[n5]) {
                nArray[n * 384 + (n4 & 0xFE)] = n2;
                nArray[n * 384 + (n4 | 1)] = n2;
            } else {
                nArray[n * 384 + n4] = n2;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < 144) {
            n4 = this.bgTilemapDisplayAddress[n5];
            n3 = (n5 + this.vScrollValues[n5] & 0xFF) / 8;
            n2 = n4 | (n3 & 0x1F) << 5;
            n = 0;
            int n7 = 0;
            while (n7 < 32) {
                int n8 = 0;
                if (this.lcd instanceof GBCLCDController && !bl) {
                    n8 = this.vram[0x2000 | n2 | n & 0x1F];
                }
                int n9 = this.vram[n2 | n & 0x1F];
                if (this.bgAndWindowDataAddress[n5] != 0) {
                    n9 = 128 + (n9 ^ 0x80);
                }
                int n10 = nArray.length > 384 ? (n8 & 8) >> 3 : 0;
                nArray[n10 * 384 + n9] = n8 & 7;
                ++n7;
                ++n;
            }
            ++n5;
        }
        return nArray;
    }

    private void renderTile(ViewerWindow viewerWindow, int n, int n2, int n3, int n4, int n5) {
        if (n5 == -2) {
            n5 = n2 & 7;
        }
        this.renderTile(viewerWindow, n, n2, n3, n4, n5, n5 >= 8, (this.lcd.getMode() & 4) != 0, this.cachedCgbColors[0]);
    }

    private void renderTile(ViewerWindow viewerWindow, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int[] nArray) {
        this.renderTile(viewerWindow, n, n2, n3, n4, 0, n5, viewerWindow.getBackgroundRGB(), bl, bl2, nArray);
    }

    private void renderTile(ViewerWindow viewerWindow, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, int[] nArray) {
        if (bl2 || !(this.lcd instanceof GBCLCDController)) {
            n2 &= 0xFFFFFFF0;
        }
        int n8 = 0;
        while (n8 < 8) {
            this.renderTileLine(viewerWindow, n, n2, n3, n4 + n8, Math.min(143, Math.max(0, n5 + n8)), n8, n6, n7, bl, bl2, nArray);
            ++n8;
        }
    }

    private void renderTileLine(ViewerWindow viewerWindow, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, int[] nArray) {
        if (!(this.lcd instanceof GBCLCDController)) {
            n2 &= 0xFFFFFFF0;
        }
        int n9 = PERMUTED_ATTRIBUTES[n2] << 9 | n;
        int n10 = (n9 & 0xFFF) << 3 | n6;
        viewerWindow.setCursor(n3, n4);
        int[] nArray2 = this.getTileData(n10);
        int n11 = 0;
        while (n11 < nArray2.length) {
            if (!bl || nArray2[n11] > 0) {
                int n12 = nArray2[n11];
                if (bl2 && n7 >= 0) {
                    n12 = bl ? ((n2 & 0x10) != 0 ? this.regOBP1[n5] : this.regOBP0[n5]) >> n12 * 2 & 3 : this.regBGP[n5] >> n12 * 2 & 3;
                }
                viewerWindow.setNextColor(n7 >= 0 ? this.getColor(n12, n7, 0, nArray) : COLORS_GRAY[n12]);
            } else {
                viewerWindow.setNextColor(n8);
            }
            ++n11;
        }
    }

    @Override
    public String[] getPaletteNames() {
        if (this.lcd instanceof GBCLCDController) {
            return GBC_PALETTE_NAMES;
        }
        return GB_PALETTE_NAMES;
    }

    @Override
    public Dimension getTilemapDimension(boolean bl) {
        return new Dimension(bl ? 287 : 256, bl ? 287 : 256);
    }

    @Override
    public String[] getBaseAddressNames() {
        return BASE_ADDRESS_NAMES;
    }

    @Override
    public String[] getTileBaseAddressNames() {
        return TILE_BASE_ADDRESS_NAMES;
    }

    @Override
    public void renderTilemap(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        int n3;
        int n4;
        int n5;
        if (this.lcd == null) {
            return;
        }
        --n;
        --n2;
        int[][] nArray = viewerCache.getTilemapAddresses(3, 256);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        boolean bl3 = (this.lcd.getMode() & 4) != 0;
        this.collectBaseAddressValues(nArray2, nArray3);
        int[] nArray4 = nArray[2];
        int n6 = 0;
        while (n6 < 144) {
            nArray4[n6 + this.vScrollValues[n6] & 0xFF] = n6;
            ++n6;
        }
        n6 = bl ? 9 : 8;
        int n7 = 0;
        while (n7 < 256) {
            n5 = n < 0 ? nArray2[n7] : 6144 + n * 1024;
            n4 = n7 / 8;
            n3 = n5 | (n4 & 0x1F) << 5;
            int n8 = 0;
            int n9 = 0;
            int n10 = n2 < 0 ? nArray3[n7] : n2;
            int n11 = 0;
            while (n11 < 32) {
                int n12 = 0;
                if (this.lcd instanceof GBCLCDController && !bl3) {
                    n12 = this.vram[0x2000 | n3 | n9 & 0x1F];
                }
                int n13 = this.vram[n3 | n9 & 0x1F];
                if (n10 != 0) {
                    n13 = 128 + (n13 ^ 0x80);
                }
                this.renderTileLine(viewerWindow, n13, n12, n8, bl ? n7 + n7 / 8 : n7, nArray4[n7], n7 & 7, bl2 ? n12 & 7 : -1, 0, false, bl3, this.cachedCgbColors[nArray4[n7]]);
                ++n11;
                n8 += n6;
                ++n9;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < 144) {
            n5 = n7 + this.vScrollValues[n7];
            n4 = this.hScrollValues[n7];
            n3 = n4 + 160 & 0xFF;
            if (n4 > 0) {
                viewerWindow.xorColor(GBDisplayWindow.toTilemapCoord(n4 - 1, bl), GBDisplayWindow.toTilemapCoord(n5 & 0xFF, bl), DisplayWindow.COLOR_WHITE);
            }
            if (n3 > 0) {
                viewerWindow.xorColor(GBDisplayWindow.toTilemapCoord(n3, bl), GBDisplayWindow.toTilemapCoord(n5 & 0xFF, bl), DisplayWindow.COLOR_WHITE);
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < 160) {
            if (this.firstLineSCY[n7] > 0) {
                viewerWindow.xorColor(GBDisplayWindow.toTilemapCoord(this.hScrollValues[0] + n7 & 0xFF, bl), GBDisplayWindow.toTilemapCoord(this.firstLineSCY[n7] - 1 & 0xFF, bl), DisplayWindow.COLOR_WHITE);
            }
            viewerWindow.xorColor(GBDisplayWindow.toTilemapCoord(this.hScrollValues[143] + n7 & 0xFF, bl), GBDisplayWindow.toTilemapCoord(this.lastLineSCY[n7] + 144 & 0xFF, bl), DisplayWindow.COLOR_WHITE);
            ++n7;
        }
    }

    private static int toTilemapCoord(int n, boolean bl) {
        return bl ? n + n / 8 : n;
    }

    @Override
    public boolean isDisplayOn(int n) {
        return this.lcd.isLCDDisplayEnabled();
    }

    private void collectBaseAddressValues(int[] nArray, int[] nArray2) {
        Arrays.fill(nArray2, -1);
        int n = 0;
        while (n < 144) {
            nArray[n + this.vScrollValues[n] & 0xFF] = this.bgTilemapDisplayAddress[n];
            nArray2[n + this.vScrollValues[n] & 0xFF] = this.bgAndWindowDataAddress[n];
            ++n;
        }
        if (nArray[0] == 0 && nArray[nArray.length - 1] == 0) {
            nArray[0] = 6144;
        }
        n = 1;
        while (n < nArray.length) {
            if (nArray[n] == 0) {
                nArray[n] = nArray[n - 1];
            }
            if (nArray2[n] < 0) {
                nArray2[n] = nArray2[n - 1];
            }
            ++n;
        }
        n = nArray.length - 2;
        while (n >= 0) {
            if (nArray[n] == 0) {
                nArray[n] = nArray[n + 1];
            }
            if (nArray2[n] < 0) {
                nArray2[n] = nArray2[n + 1];
            }
            --n;
        }
    }

    private int getYforTilemapIndex(int n) {
        int n2 = 0;
        while (n2 < 144) {
            if ((n2 + this.vScrollValues[n2] & 0xFF) / 8 == n / 32) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int getHorizontalScroll(int n) {
        int n2 = this.getYforTilemapIndex(n);
        if (n2 >= 0) {
            return this.hScrollValues[n2];
        }
        return this.lcd.getSCX(0);
    }

    @Override
    public int getVerticalScroll() {
        return this.lcd.getRegSCY();
    }

    @Override
    public int[] getTilemapData(int n, int[] nArray, ViewerCache viewerCache) {
        --n;
        int[] nArray2 = nArray != null && nArray.length == 1024 ? nArray : new int[1024];
        int[][] nArray3 = viewerCache.getTilemapAddresses(3, 256);
        int[] nArray4 = nArray3[0];
        int[] nArray5 = nArray3[1];
        this.collectBaseAddressValues(nArray4, nArray5);
        if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
            int n2 = 0;
            while (n2 < 32) {
                int n3 = (n < 0 ? nArray4[n2 * 8] : 6144 + n * 1024) + n2 * 32;
                int n4 = 0;
                while (n4 < 32) {
                    int n5 = n3 | n4 & 0x1F;
                    nArray2[n2 * 32 + n4] = this.vram[0x2000 | n5] << 8 | this.vram[n5];
                    ++n4;
                }
                ++n2;
            }
        } else {
            int n6 = 0;
            while (n6 < 32) {
                int n7 = (n < 0 ? nArray4[n6 * 8] : 6144 + n * 1024) + n6 * 32;
                int n8 = 0;
                while (n8 < 32) {
                    nArray2[n6 * 32 + n8] = this.vram[n7 | n8 & 0x1F];
                    ++n8;
                }
                ++n6;
            }
        }
        return nArray2;
    }

    @Override
    public String getModeName(int n) {
        String string;
        if (!this.lcd.isLCDDisplayEnabled()) {
            return null;
        }
        int n2 = this.prevModeNameTimestamp;
        this.prevModeNameTimestamp = this.getTimestamp();
        if (n2 != this.prevModeNameTimestamp) {
            return null;
        }
        int n3 = this.lcd.getRegSTAT() & 3;
        int n4 = this.lcd.calcDotsInModeLeft();
        int n5 = this.lcd.getRegLY();
        switch (n3) {
            case 0: {
                string = "0 (HBlank)";
                break;
            }
            case 1: {
                string = "1 (VBlank)";
                break;
            }
            case 2: {
                string = "2 (OAM Scan)";
                break;
            }
            default: {
                string = "3 (Rendering)";
            }
        }
        return "Line " + GBDisplayWindow.padTo4chars(n5) + " | " + GBDisplayWindow.padTo4chars(n4) + " dots left in mode " + string;
    }

    @Override
    public boolean isModeNameDependsOnIndex() {
        return false;
    }

    private static String padTo4chars(int n) {
        if (n < 10) {
            return "   " + n;
        }
        if (n < 100) {
            return "  " + n;
        }
        if (n < 1000) {
            return " " + n;
        }
        return Integer.toString(n);
    }

    @Override
    public int getVRAMAddressOfTilemapEntry(int n, int n2, ViewerCache viewerCache) {
        int[][] nArray = viewerCache.getTilemapAddresses(3, 256);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        this.collectBaseAddressValues(nArray2, nArray3);
        int n3 = --n2 < 0 ? nArray2[n / 32 * 8] : 6144 + n2 * 1024;
        return n3 + n;
    }

    @Override
    public int getVRAMAddressOfTilemapEntryAttributes(int n, int n2, ViewerCache viewerCache) {
        --n2;
        if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
            return 0x2000 | this.getVRAMAddressOfTilemapEntry(n, n2 + 1, viewerCache);
        }
        return this.vram.length;
    }

    @Override
    public String getCPUAddressOfTilemapEntry(int n, int n2, ViewerCache viewerCache) {
        return GBDisplayWindow.vramAddressToCPUaddress(this.getVRAMAddressOfTilemapEntry(n, n2, viewerCache));
    }

    @Override
    public String getTilemapEntryAttributes(int n, int[] nArray) {
        if (!(this.lcd instanceof GBCLCDController) || (this.lcd.getMode() & 4) != 0) {
            return "None";
        }
        return String.valueOf(String.format("$%02X", nArray[n] >> 8)) + " (hflip: " + GBDisplayWindow.isAttributeHflip(nArray[n] >> 8) + " | vflip: " + GBDisplayWindow.isAttributeVflip(nArray[n] >> 8) + " | palette: BGP" + this.getPaletteFromAttributes(nArray[n] >> 8) + " | priority: " + GBDisplayWindow.isAttributePriority(nArray[n] >> 8) + ")";
    }

    @Override
    public boolean hasTilemapAttributes() {
        return this.lcd instanceof GBCLCDController;
    }

    private static boolean isAttributeHflip(int n) {
        return (n & 0x20) != 0;
    }

    private static boolean isAttributeVflip(int n) {
        return (n & 0x40) != 0;
    }

    private int getPaletteFromAttributes(int n) {
        if (this.lcd instanceof GBCLCDController && (this.lcd.getMode() & 4) == 0) {
            return n & 7;
        }
        return (n & 0x10) >> 4;
    }

    private static boolean isAttributePriority(int n) {
        return (n & 0x80) != 0;
    }

    @Override
    public int getTilemapTileWidth(boolean bl) {
        return bl ? 9 : 8;
    }

    @Override
    public int getTilemapTileHeight(boolean bl) {
        return bl ? 9 : 8;
    }

    @Override
    public int getTilemapEntryTile(int n, int[] nArray, ViewerCache viewerCache) {
        if (nArray == null || n >= nArray.length) {
            return -1;
        }
        int[][] nArray2 = viewerCache.getTilemapAddresses(3, 256);
        int[] nArray3 = nArray2[0];
        int[] nArray4 = nArray2[1];
        this.collectBaseAddressValues(nArray3, nArray4);
        int n2 = nArray[n] & 0xFF;
        if (nArray4[n / 32 * 8] != 0) {
            n2 = 128 + (n2 ^ 0x80);
        }
        return ((nArray[n] & 0x800) >> 11) * 512 + n2;
    }

    @Override
    public int getAddressOfSpriteVpos(int n) {
        return n << 2;
    }

    @Override
    public int getAddressOfSpriteHpos(int n) {
        return this.getAddressOfSpriteVpos(n) + 1;
    }

    @Override
    public int getAddressOfSpriteTile(int n) {
        return this.getAddressOfSpriteHpos(n) + 1;
    }

    @Override
    public int getAddressOfSpriteAttributes(int n) {
        return this.getAddressOfSpriteTile(n) + 1;
    }

    @Override
    public String getCPUAddressOfSprite(int n) {
        return Integer.toHexString(0xFE00 | this.getAddressOfSpriteVpos(n)).toUpperCase();
    }

    @Override
    public boolean hasSpriteAttributes() {
        return true;
    }

    @Override
    public String getNameOfSpriteLocation() {
        return "OAM";
    }

    @Override
    public int getSpriteTile(int n, int[][] nArray) {
        return nArray[n][2];
    }

    @Override
    public String getSpriteAttributes(int n) {
        int n2 = this.oam[this.getAddressOfSpriteAttributes(n)];
        return String.valueOf(String.format("$%02X", n2)) + " (hflip: " + GBDisplayWindow.isAttributeHflip(n2) + " | vflip: " + GBDisplayWindow.isAttributeVflip(n2) + " | palette: OBP" + this.getPaletteFromAttributes(n2) + " | priority: " + GBDisplayWindow.isAttributePriority(n2) + ")";
    }

    @Override
    public int getSpriteWidth(int n) {
        return 8;
    }

    @Override
    public int getSpriteHeight(int n) {
        if (n >= 0 && n < this.objHeight.length) {
            return this.objHeight[n] ? 16 : 8;
        }
        return 0;
    }

    @Override
    public Dimension getSpritesDimension(boolean bl) {
        return new Dimension(bl ? 89 : 80, bl ? 67 : 64);
    }

    @Override
    public void renderSprites(ViewerWindow viewerWindow, boolean bl) {
        this.renderSprites(viewerWindow, false, 0, bl);
    }

    @Override
    public void renderSprites(ViewerWindow viewerWindow, int n, boolean bl) {
        this.renderSprites(viewerWindow, true, n, bl);
    }

    private void renderSprites(ViewerWindow viewerWindow, boolean bl, int n, boolean bl2) {
        if (this.lcd == null) {
            return;
        }
        if (!bl) {
            n = this.getColor(0, 8, 0, this.cachedCgbColors[0]);
        }
        boolean bl3 = (this.lcd.getMode() & 4) != 0;
        int n2 = bl2 ? 9 : 8;
        int n3 = bl2 ? 17 : 16;
        int n4 = 0;
        while (n4 < 40) {
            int n5;
            int[] nArray;
            int n6 = this.oam[n4 << 2];
            int n7 = this.oam[n4 << 2 | 2];
            int n8 = this.oam[n4 << 2 | 3];
            int n9 = n6 - 16;
            if (this.lcd instanceof GBCLCDController) {
                nArray = this.cachedCgbColors[Math.min(143, Math.max(0, n9))];
                n5 = 8 | (bl3 ? (n8 & 0x10) >> 4 : n8 & 7);
            } else {
                n5 = 8 | (n8 & 0x10) >> 4;
                nArray = null;
            }
            if (this.objHeight[n4]) {
                if ((n8 & 0x40) != 0) {
                    this.renderTile(viewerWindow, n7 & 0xFE, n8, n4 % 10 * n2, n4 / 10 * n3 + 8, n9, n5, n, true, bl3, nArray);
                    this.renderTile(viewerWindow, n7 | 1, n8, n4 % 10 * n2, n4 / 10 * n3, n9, n5, n, true, bl3, nArray);
                } else {
                    this.renderTile(viewerWindow, n7 & 0xFE, n8, n4 % 10 * n2, n4 / 10 * n3, n9, n5, n, true, bl3, nArray);
                    this.renderTile(viewerWindow, n7 | 1, n8, n4 % 10 * n2, n4 / 10 * n3 + 8, n9, n5, n, true, bl3, nArray);
                }
            } else {
                this.renderTile(viewerWindow, n7, n8, n4 % 10 * n2, n4 / 10 * n3, n9, n5, n, true, bl3, nArray);
                int n10 = 0;
                while (n10 < 8) {
                    viewerWindow.setColor(n4 % 10 * n2, n4 / 10 * n3 + 8 + n10, 8, n);
                    ++n10;
                }
            }
            if (n6 == 0 || n6 >= 160) {
                viewerWindow.drawLine(n4 % 10 * n2, n4 / 10 * n3, n4 % 10 * n2 + 7, n4 / 10 * n3 + 15, Color.RED);
            }
            ++n4;
        }
    }

    @Override
    public boolean isWideSprites() {
        return false;
    }

    @Override
    public int[][] getSpriteData(int[][] nArray) {
        if (nArray == null || nArray.length != 40 || nArray[0].length != 4) {
            nArray = new int[40][4];
        }
        int n = 0;
        while (n < 40) {
            int n2 = this.oam[n << 2];
            int n3 = this.oam[n << 2 | 1];
            int n4 = this.oam[n << 2 | 2];
            int n5 = this.oam[n << 2 | 3];
            nArray[n][0] = n2;
            nArray[n][1] = n3;
            nArray[n][2] = n4;
            nArray[n][3] = n5;
            ++n;
        }
        return nArray;
    }

    @Override
    public void setSpriteToHighlight(int n) {
        this.spriteToHighlight = n;
        this.highlightSprite(n, true);
    }

    @Override
    public int getTimestamp() {
        return this.getFrame() << 24 | (this.lcd.isLCDDisplayEnabled() ? this.lcd.getRegLY() << 16 | this.lcd.calcCurrentDot() : this.lcd.getCyclesSinceLastFrame());
    }

    @Override
    public int getFrame() {
        return this.displayWindow.getFrameNumber();
    }

    @Override
    public void getPixels(int[] nArray) {
        if (this.lcd != null) {
            int n = 0;
            Arrays.fill(nArray, 0, 80, 16769676);
            int n2 = this.getDotsPerLine() - 80;
            int n3 = 0;
            while (n3 < 144) {
                System.arraycopy(nArray, 0, nArray, n3 * this.getDotsPerLine(), 80);
                n += 80;
                int n4 = this.lcd.getMode3cycles(n3);
                int n5 = 0;
                while (n5 < n2) {
                    if (n5 < n4) {
                        int n6 = this.lcd.toScreenDot(n3, n5) & Integer.MAX_VALUE;
                        nArray[n++] = n6 < 160 ? this.displayWindow.getColorDirect(n6, n3) : 0x888888;
                    } else {
                        nArray[n++] = 14939101;
                    }
                    ++n5;
                }
                ++n3;
            }
            Arrays.fill(nArray, 144 * this.getDotsPerLine(), nArray.length, 0xBFFFFF);
        }
    }

    @Override
    public String getMode(int n, int n2) {
        if (n >= 144) {
            return "<font bgcolor=#bfffff>1 (VBlank)</font>";
        }
        if (n2 < 80) {
            return "<font bgcolor=#ffe28c>2 (OAM Scan)</font>";
        }
        int n3 = this.lcd.getMode3cycles(n);
        if ((n2 -= 80) < n3) {
            if ((n2 = this.lcd.toScreenDot(n, n2) & Integer.MAX_VALUE) < 160) {
                return "3 (Rendering)";
            }
            return "<font bgcolor=#888888>3 (Delayed)</font>";
        }
        return "<font bgcolor=#e3f3dd>0 (HBlank)</font>";
    }

    @Override
    public String getPixelDescription(int n, int n2) {
        if ((n2 -= 80) < 0 || n >= this.lines.length) {
            return null;
        }
        if ((n2 = this.lcd.toScreenDot(n, n2) & Integer.MAX_VALUE) >= 160) {
            return null;
        }
        int n3 = this.lines[n][n2];
        if ((n3 & 0x80) != 0) {
            return "OBP" + (n3 >> 10 & 7) + ":" + (n3 >> 8 & 3) + " (Sprite " + (n3 & 0x3F) + ")";
        }
        if ((n3 & 0x40) != 0) {
            return "BGP" + (n3 >> 10 & 7) + ":" + (n3 & 0x3F) + " (" + ((n3 & 0x8000) != 0 ? "Priority " : "") + "Window)";
        }
        return "BGP" + (n3 >> 10 & 7) + ":" + (n3 & 0x3F) + " (" + ((n3 & 0x8000) != 0 ? "Priority " : "") + "Background)";
    }

    @Override
    public int getDotsPerLine() {
        return 456;
    }

    @Override
    public int getNumScanlines() {
        return 154;
    }
}

