/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.Rumbler;
import net.java.games.input.WinTabComponent;
import net.java.games.input.WinTabContext;
import net.java.games.input.WinTabEnvironmentPlugin;
import net.java.games.input.WinTabPacket;

public class WinTabDevice
extends AbstractController {
    public static final int XAxis = 1;
    public static final int YAxis = 2;
    public static final int ZAxis = 3;
    public static final int NPressureAxis = 4;
    public static final int TPressureAxis = 5;
    public static final int OrientationAxis = 6;
    public static final int RotationAxis = 7;
    private WinTabContext context;
    private List<Event> eventList = new ArrayList<Event>();

    private WinTabDevice(WinTabContext winTabContext, int n, String string, Component[] componentArray) {
        super(string, componentArray, new Controller[0], new Rumbler[0]);
        this.context = winTabContext;
    }

    @Override
    protected boolean getNextDeviceEvent(Event event) throws IOException {
        if (this.eventList.size() > 0) {
            Event event2 = this.eventList.remove(0);
            event.set(event2);
            return true;
        }
        return false;
    }

    @Override
    protected void pollDevice() throws IOException {
        this.context.processEvents();
        super.pollDevice();
    }

    @Override
    public Controller.Type getType() {
        return Controller.Type.TRACKPAD;
    }

    public void processPacket(WinTabPacket winTabPacket) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Event event = ((WinTabComponent)componentArray[n]).processPacket(winTabPacket);
            if (event != null) {
                this.eventList.add(event);
            }
            ++n;
        }
    }

    public static WinTabDevice createDevice(WinTabContext winTabContext, int n) {
        String string = WinTabDevice.nGetName(n);
        WinTabEnvironmentPlugin.log("Device " + n + ", name: " + string);
        ArrayList<WinTabComponent> arrayList = new ArrayList<WinTabComponent>();
        int[] nArray = WinTabDevice.nGetAxisDetails(n, 1);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("ZAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("Xmin: " + nArray[0] + ", Xmax: " + nArray[1]);
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 1, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n, 2);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("YAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("Ymin: " + nArray[0] + ", Ymax: " + nArray[1]);
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 2, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n, 3);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("ZAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("Zmin: " + nArray[0] + ", Zmax: " + nArray[1]);
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 3, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n, 4);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("NPressureAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("NPressMin: " + nArray[0] + ", NPressMax: " + nArray[1]);
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 4, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n, 5);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("TPressureAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("TPressureAxismin: " + nArray[0] + ", TPressureAxismax: " + nArray[1]);
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 5, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n, 6);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("OrientationAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("OrientationAxis mins/maxs: " + nArray[0] + "," + nArray[1] + ", " + nArray[2] + "," + nArray[3] + ", " + nArray[4] + "," + nArray[5]);
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 6, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n, 7);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.log("RotationAxis not supported");
        } else {
            WinTabEnvironmentPlugin.log("RotationAxis is supported (by the device, not by this plugin)");
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n, 7, nArray));
        }
        String[] stringArray = WinTabDevice.nGetCursorNames(n);
        arrayList.addAll(WinTabComponent.createCursors(winTabContext, n, stringArray));
        int n2 = 0;
        while (n2 < stringArray.length) {
            WinTabEnvironmentPlugin.log("Cursor " + n2 + "'s name: " + stringArray[n2]);
            ++n2;
        }
        n2 = WinTabDevice.nGetMaxButtonCount(n);
        WinTabEnvironmentPlugin.log("Device has " + n2 + " buttons");
        arrayList.addAll(WinTabComponent.createButtons(winTabContext, n, n2));
        Component[] componentArray = arrayList.toArray(new Component[0]);
        return new WinTabDevice(winTabContext, n, string, componentArray);
    }

    private static final native String nGetName(int var0);

    private static final native int[] nGetAxisDetails(int var0, int var1);

    private static final native String[] nGetCursorNames(int var0);

    private static final native int nGetMaxButtonCount(int var0);
}

