/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.java.games.input.DefaultControllerEnvironment;

class PluginClassLoader
extends ClassLoader {
    private static String pluginDirectory;
    private static final FileFilter JAR_FILTER;

    static {
        JAR_FILTER = new JarFileFilter();
    }

    public PluginClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        byte[] byArray = this.loadClassData(string);
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private byte[] loadClassData(String string) throws ClassNotFoundException {
        if (pluginDirectory == null) {
            pluginDirectory = String.valueOf(DefaultControllerEnvironment.libPath) + File.separator + "controller";
        }
        try {
            return this.loadClassFromDirectory(string);
        }
        catch (Exception exception) {
            try {
                return this.loadClassFromJAR(string);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string, iOException);
            }
        }
    }

    private byte[] loadClassFromDirectory(String string) throws ClassNotFoundException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer(pluginDirectory);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(File.separator);
            stringBuffer.append(stringTokenizer.nextToken());
        }
        stringBuffer.append(".class");
        File file = new File(stringBuffer.toString());
        if (!file.exists()) {
            throw new ClassNotFoundException(string);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            assert (file.length() <= Integer.MAX_VALUE);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            int n2 = fileInputStream.read(byArray);
            assert (n == n2);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private byte[] loadClassFromJAR(String string) throws ClassNotFoundException, IOException {
        File file = new File(pluginDirectory);
        File[] fileArray = file.listFiles(JAR_FILTER);
        if (fileArray == null) {
            throw new ClassNotFoundException("Could not find class " + string);
        }
        int n = 0;
        while (n < fileArray.length) {
            JarFile jarFile = new JarFile(fileArray[n]);
            JarEntry jarEntry = jarFile.getJarEntry(String.valueOf(string) + ".class");
            if (jarEntry != null) {
                InputStream inputStream = null;
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                    assert (jarEntry.getSize() <= Integer.MAX_VALUE);
                    int n2 = (int)jarEntry.getSize();
                    assert (n2 >= 0);
                    byte[] byArray = new byte[n2];
                    int n3 = inputStream.read(byArray);
                    assert (n2 == n3);
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            ++n;
        }
        throw new FileNotFoundException(string);
    }

    private static class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toUpperCase().endsWith(".JAR");
        }
    }
}

