/*
 * Decompiled with CFR 0.152.
 */
package json;

import json.JSONArray;
import json.JSONObject;
import util.string.SubCharSequence;

public class JSONParser {
    private static final SubCharSequence NULL_VALUE = SubCharSequence.from("null");
    private static final Token NULL = new Token(Terminal.KEYWORD, NULL_VALUE);

    public static JSONObject parse(CharSequence charSequence) {
        Stream stream = new Stream(charSequence);
        Token token = stream.nextToken();
        if (token.getTerminal() != Terminal.OPENING_BRACES) {
            return null;
        }
        return JSONParser.parse(stream);
    }

    static JSONObject parse(Stream stream) {
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        Token token = stream.nextToken();
        while (!token.isEOF() && token.getTerminal() != Terminal.CLOSING_BRACES) {
            CharSequence charSequence;
            if (bl) {
                if (token.getTerminal() != Terminal.COMMA) {
                    throw new IllegalArgumentException("Comma expected, " + token + " encountered");
                }
                token = stream.nextToken();
            }
            if (token.getTerminal() == Terminal.STRING_LITERAL) {
                charSequence = token.getText().subSequence(1, token.getText().length() - 1);
            } else if (token.getTerminal() == Terminal.IDENTIFIER) {
                charSequence = token.getText();
            } else {
                throw new IllegalArgumentException("key expected, " + token + " encountered");
            }
            token = stream.nextToken();
            if (token.getTerminal() != Terminal.KEY_VALUE_SEPARATOR) {
                throw new IllegalArgumentException("Key value separator expected, " + token + " encountered");
            }
            token = stream.nextToken();
            Object object = JSONParser.parseValue(token, stream);
            if (object != NULL) {
                jSONObject.putSuper(charSequence.toString(), object.toString());
            }
            bl = true;
            token = stream.nextToken();
        }
        return jSONObject;
    }

    public static JSONArray parseArray(CharSequence charSequence) {
        Stream stream = new Stream(charSequence);
        Token token = stream.nextToken();
        if (token.getTerminal() != Terminal.OPENING_BRACKET) {
            return null;
        }
        return JSONParser.parseArray(stream);
    }

    static JSONArray parseArray(Stream stream) {
        JSONArray jSONArray = new JSONArray();
        boolean bl = false;
        Token token = stream.nextToken();
        while (!token.isEOF() && token.getTerminal() != Terminal.CLOSING_BRACKET) {
            if (bl) {
                if (token.getTerminal() != Terminal.COMMA) {
                    throw new IllegalArgumentException("Comma expected, " + token + " encountered");
                }
                token = stream.nextToken();
            }
            jSONArray.add(JSONParser.parseValue(token, stream));
            bl = true;
            token = stream.nextToken();
        }
        return jSONArray;
    }

    static Object parseValue(Token token, Stream stream) {
        switch (token.getTerminal()) {
            case KEYWORD: {
                return token;
            }
            case NUMBER_LITERAL: 
            case IDENTIFIER: {
                return token.getText();
            }
            case STRING_LITERAL: {
                return token.getText().subSequence(1, token.getText().length() - 1).toString().replace("\\\\", "$\\$").replace("\\\"", "\"").replace("\\t", "\t").replace("\\n", "\n").replace("$\\$", "\\");
            }
            case KEY_VALUE_SEPARATOR: 
            case OPENING_BRACES: {
                return JSONParser.parse(stream);
            }
            case OPENING_BRACKET: {
                return JSONParser.parseArray(stream);
            }
        }
        throw new IllegalArgumentException("Value expected, " + token + " encountered");
    }

    static class Stream {
        private final CharSequence text;
        private int pos;

        Stream(CharSequence charSequence) {
            if (charSequence == null) {
                throw new IllegalArgumentException("text must not be null");
            }
            this.text = charSequence;
        }

        boolean isEOF() {
            return this.pos >= this.text.length();
        }

        Token peekToken() {
            Terminal terminal;
            if (this.isEOF()) {
                return new Token(Terminal.EOF, SubCharSequence.from(this.text, this.pos, this.pos));
            }
            int n = this.pos;
            char c = this.text.charAt(n++);
            switch (c) {
                case '{': {
                    terminal = Terminal.OPENING_BRACES;
                    break;
                }
                case '}': {
                    terminal = Terminal.CLOSING_BRACES;
                    break;
                }
                case '[': {
                    terminal = Terminal.OPENING_BRACKET;
                    break;
                }
                case ']': {
                    terminal = Terminal.CLOSING_BRACKET;
                    break;
                }
                case ':': {
                    terminal = Terminal.KEY_VALUE_SEPARATOR;
                    break;
                }
                case ',': {
                    terminal = Terminal.COMMA;
                    break;
                }
                case '\"': {
                    terminal = Terminal.STRING_LITERAL;
                    while (n < this.text.length() && (this.text.charAt(n) != '\"' || this.text.charAt(n - 1) == '\\')) {
                        ++n;
                    }
                    if (n >= this.text.length()) {
                        throw new IllegalArgumentException("Missing closing quotation mark for string literal starting from column " + this.pos);
                    }
                    ++n;
                    break;
                }
                default: {
                    if (Character.isDigit(c)) {
                        terminal = Terminal.NUMBER_LITERAL;
                        while (n < this.text.length() && Character.isDigit(this.text.charAt(n))) {
                            ++n;
                        }
                        break;
                    }
                    if (c <= ' ') {
                        terminal = Terminal.WHITESPACE;
                        while (n < this.text.length() && this.text.charAt(n) <= ' ') {
                            ++n;
                        }
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        terminal = Terminal.IDENTIFIER;
                        while (n < this.text.length() && Character.isJavaIdentifierPart(this.text.charAt(n))) {
                            ++n;
                        }
                        break;
                    }
                    throw new IllegalArgumentException("Unexpected character encountered '" + c + "'");
                }
            }
            if (terminal == Terminal.IDENTIFIER && NULL_VALUE.equals(SubCharSequence.from(this.text, this.pos, n))) {
                return NULL;
            }
            return new Token(terminal, SubCharSequence.from(this.text, this.pos, n));
        }

        Token fetchToken() {
            Token token = this.peekToken();
            this.pos += token.getText().length();
            return token;
        }

        Token nextToken() {
            Token token = this.fetchToken();
            while (token.getTerminal() == Terminal.WHITESPACE) {
                token = this.fetchToken();
            }
            return token;
        }
    }

    static enum Terminal {
        NUMBER_LITERAL,
        STRING_LITERAL,
        KEY_VALUE_SEPARATOR,
        KEYWORD,
        IDENTIFIER,
        OPENING_BRACES,
        CLOSING_BRACES,
        OPENING_BRACKET,
        CLOSING_BRACKET,
        COMMA,
        WHITESPACE,
        EOF;

    }

    static class Token {
        private final Terminal terminal;
        private final CharSequence text;

        public Token(Terminal terminal, CharSequence charSequence) {
            this.terminal = terminal;
            this.text = charSequence;
        }

        public Terminal getTerminal() {
            return this.terminal;
        }

        public CharSequence getText() {
            return this.text;
        }

        public boolean isEOF() {
            return this.terminal == Terminal.EOF;
        }

        public String toString() {
            return (Object)((Object)this.terminal) + "(" + this.text + ")";
        }
    }
}

