/*
 * Decompiled with CFR 0.152.
 */
package highlighting;

import highlighting.Highlighter;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.text.html.StyleSheet;

public class ConTEXTHighlighter
implements Highlighter {
    private HashMap<String, String> highlightMap;
    private HashMap<String, String> keyWords;
    private HashSet<Character> numConstBegChars;
    private HashSet<Character> numConstChars;
    private HashSet<Character> identifierBegChars;
    private HashSet<Character> identifierChars;
    private final String[] stringBegChars;
    private final String[] stringEndChars;
    private final char escapeChar;
    private final BitSet delimiterChars = new BitSet();
    private StyleSheet styleSheet;
    private HashMap<String, String> cache = new HashMap();
    private final Color foreground;
    private final Color background;
    private final Color currentLineForeground;
    private final Color currentLineBackground;
    private final Color selectionForeground;
    private final Color selectionBackground;

    private ConTEXTHighlighter(File file) throws FileNotFoundException {
        int n;
        int n2;
        String string;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SelectionCol", "");
        hashMap.put("CurrentLineCol", "");
        try {
            object = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            string = ((BufferedReader)object).readLine();
            while (string != null) {
                try {
                    String[] stringArray;
                    if (!string.startsWith("//") && (stringArray = string.split(":")).length == 2) {
                        hashMap.put(stringArray[0].trim(), stringArray[1].trim());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = ((BufferedReader)object).readLine();
            }
            ((BufferedReader)object).close();
            this.highlightMap = hashMap;
            this.keyWords = new HashMap();
            string = (String)hashMap.get("KeyWords1");
            n2 = 2;
            while (string != null) {
                String[] stringArray = string.split(" ");
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String string2 = stringArray[n];
                    this.keyWords.put(string2, (String)hashMap.get("Keyword" + (n2 - 1) + "Col"));
                    ++n;
                }
                string = (String)hashMap.get("KeyWords" + n2);
                ++n2;
            }
            this.numConstBegChars = ConTEXTHighlighter.parseCharacters((String)hashMap.get("NumConstBegChars"));
            this.numConstChars = ConTEXTHighlighter.parseCharacters((String)hashMap.get("NumConstChars"));
            this.identifierBegChars = ConTEXTHighlighter.parseCharacters((String)hashMap.get("IdentifierBegChars"));
            this.identifierChars = ConTEXTHighlighter.parseCharacters((String)hashMap.get("IdentifierChars"));
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                throw (FileNotFoundException)iOException;
            }
            iOException.printStackTrace();
        }
        object = (String)hashMap.get("StringBegChar");
        this.stringBegChars = object != null ? ((String)object).split(" ") : new String[]{};
        string = (String)hashMap.get("StringEndChar");
        this.stringEndChars = string != null ? string.split(" ") : new String[]{};
        this.escapeChar = ((String)hashMap.get("EscapeChar")).charAt(0);
        Object[] objectArray = new char[]{',', '(', ')', '[', ']', '+', '-', '*', '/', '=', '!', '&', '|', '~', '#', '@', ':', '<', '>'};
        n = objectArray.length;
        int n4 = 0;
        while (n4 < n) {
            n2 = objectArray[n4];
            this.delimiterChars.set(n2);
            ++n4;
        }
        objectArray = this.stringBegChars;
        n = this.stringBegChars.length;
        n4 = 0;
        while (n4 < n) {
            char c = objectArray[n4];
            this.delimiterChars.set(c.charAt(0));
            ++n4;
        }
        String[] stringArray = ((String)hashMap.get("SpaceCol")).split(" ");
        this.foreground = stringArray.length >= 1 ? this.getStyleSheet().stringToColor(ConTEXTHighlighter.colorAttributeToHTML(stringArray[0])) : null;
        this.background = stringArray.length > 1 ? this.getStyleSheet().stringToColor(ConTEXTHighlighter.colorAttributeToHTML(stringArray[1])) : null;
        stringArray = ((String)hashMap.get("SelectionCol")).split(" ");
        this.selectionForeground = stringArray.length >= 1 ? this.getStyleSheet().stringToColor(ConTEXTHighlighter.colorAttributeToHTML(stringArray[0])) : null;
        this.selectionBackground = stringArray.length > 1 ? this.getStyleSheet().stringToColor(ConTEXTHighlighter.colorAttributeToHTML(stringArray[1])) : null;
        stringArray = ((String)hashMap.get("CurrentLineCol")).split(" ");
        this.currentLineForeground = stringArray.length >= 1 ? this.getStyleSheet().stringToColor(ConTEXTHighlighter.colorAttributeToHTML(stringArray[0])) : null;
        this.currentLineBackground = stringArray.length > 1 ? this.getStyleSheet().stringToColor(ConTEXTHighlighter.colorAttributeToHTML(stringArray[1])) : null;
    }

    public static Highlighter loadFromFile(File file) throws FileNotFoundException {
        return new ConTEXTHighlighter(file);
    }

    @Override
    public String highlight(String string) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        String string2;
        if (this.highlightMap == null || this.highlightMap.isEmpty() || string == null || string.isEmpty()) {
            return string;
        }
        if (string.length() >= 256) {
            string2 = string.substring(256);
            string = string.substring(0, 256);
        } else {
            string2 = "";
        }
        String string3 = this.highlightMap.get("LineComment");
        String string4 = "";
        if (string3 != null) {
            String string5;
            object2 = string3.split(" ");
            int n4 = -1;
            object = object2;
            n3 = ((String[])object2).length;
            n2 = 0;
            while (n2 < n3) {
                string5 = object[n2];
                n = string.indexOf(string5);
                if (n >= 0 && (n4 < 0 || n < n4)) {
                    n4 = n;
                }
                ++n2;
            }
            if (n4 >= 0) {
                string5 = ConTEXTHighlighter.parseAttributes(this.highlightMap.get("CommentCol"));
                if (string5 != null) {
                    string4 = String.valueOf(string4) + string5;
                }
                string4 = String.valueOf(string4) + string.substring(n4).replace("<", "&lt;").replace("&lt;font ", "<font ").replace("&lt;/font>", "</font>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replace(" ", "&nbsp;");
                if (string5 != null) {
                    string4 = String.valueOf(string4) + "</b></i></u></font>";
                }
                string = string.substring(0, n4);
            }
        }
        if ((object2 = this.cache.get(string)) == null) {
            StringBuilder stringBuilder = new StringBuilder();
            int n5 = 0;
            while (n5 < string.length()) {
                n2 = n5;
                while (n2 < string.length()) {
                    n3 = string.charAt(n2);
                    if (n3 <= 32 || this.delimiterChars.get(n3)) break;
                    ++n2;
                }
                String string6 = "";
                if (n2 < string.length()) {
                    string6 = string.substring(n2, n2 + 1);
                }
                if (this.stringEndChars.length > 0) {
                    String[] stringArray = this.stringBegChars;
                    int n6 = this.stringBegChars.length;
                    n = 0;
                    while (n < n6) {
                        object = stringArray[n];
                        if (string6.equals(object)) {
                            n2 = string.length();
                            String[] stringArray2 = this.stringEndChars;
                            int n7 = this.stringEndChars.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String string7 = stringArray2[n8];
                                int n9 = string.indexOf(string7, n5 + 1);
                                if (n9 > 0) {
                                    while (n9 > 0 && string.charAt(n9 - 1) == this.escapeChar) {
                                        n9 = string.indexOf(string7, n9 + 1);
                                    }
                                    if (n9 >= 0) {
                                        n2 = n9 + 1;
                                    }
                                }
                                ++n8;
                            }
                            string6 = "";
                        }
                        ++n;
                    }
                }
                this.appendHighlightedToken(stringBuilder, string.substring(n5, n2));
                this.appendHighlightedSymbol(stringBuilder, string6);
                n5 = n2 + string6.length();
            }
            object2 = stringBuilder.toString();
            this.cache.put(string, (String)object2);
        }
        object2 = String.valueOf(object2) + string4;
        if (!string2.isEmpty()) {
            return "<html><body style=\"white-space:nowrap\">" + (String)object2 + string2 + "</body></html>";
        }
        return object2.isEmpty() ? "" : "<html><body style=\"white-space:nowrap\">" + (String)object2 + "</body></html>";
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    @Override
    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    @Override
    public Color getCurrentLineForeground() {
        return this.currentLineForeground;
    }

    @Override
    public Color getCurrentLineBackground() {
        return this.currentLineBackground;
    }

    private StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            this.styleSheet = new StyleSheet();
        }
        return this.styleSheet;
    }

    private void appendHighlightedSymbol(StringBuilder stringBuilder, String string) {
        if (string != null && !string.isEmpty()) {
            if (string.length() == 1) {
                char c = string.charAt(0);
                if (c == '\t') {
                    stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    return;
                }
                if (c == ' ') {
                    stringBuilder.append("&nbsp;");
                    return;
                }
                if (c == '<') {
                    string = "&lt;";
                }
            }
            stringBuilder.append(ConTEXTHighlighter.parseAttributes(this.highlightMap.get("SymbolCol"))).append(string).append("</b></i></u></font>");
        }
    }

    private void appendHighlightedToken(StringBuilder stringBuilder, String string) {
        if (!string.isEmpty()) {
            if (this.numConstBegChars.contains(Character.valueOf(string.charAt(0)))) {
                stringBuilder.append(ConTEXTHighlighter.parseAttributes(this.highlightMap.get("NumberCol")));
                int n = 1;
                while (n < string.length() && this.numConstChars.contains(Character.valueOf(string.charAt(n)))) {
                    ++n;
                }
                stringBuilder.append(string.substring(0, n)).append("</b></i></u></font>");
                stringBuilder.append(string.substring(n, string.length()));
            } else {
                String string2 = this.keyWords.get(string.trim().toLowerCase());
                if (string2 != null) {
                    stringBuilder.append(ConTEXTHighlighter.parseAttributes(string2));
                    stringBuilder.append(String.valueOf(string) + "</b></i></u></font>");
                } else if (this.identifierBegChars.contains(Character.valueOf(string.charAt(0)))) {
                    stringBuilder.append(ConTEXTHighlighter.parseAttributes(this.highlightMap.get("IdentifierCol")));
                    int n = 1;
                    while (n < string.length() && this.identifierChars.contains(Character.valueOf(string.charAt(n)))) {
                        ++n;
                    }
                    stringBuilder.append(string.substring(0, n)).append("</b></i></u></font>");
                    stringBuilder.append(string.substring(n, string.length()));
                } else {
                    String[] stringArray = this.stringBegChars;
                    int n = this.stringBegChars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string3 = stringArray[n2];
                        if (string.startsWith(string3)) {
                            stringBuilder.append(ConTEXTHighlighter.parseAttributes(this.highlightMap.get("StringCol"))).append(string).append("</b></i></u></font>");
                            return;
                        }
                        ++n2;
                    }
                    stringBuilder.append(string);
                }
            }
        }
    }

    private static String colorAttributeToHTML(String string) {
        if (string.startsWith("$")) {
            int n = 0;
            try {
                n = Integer.parseInt(string.substring(1), 16);
                n = n & 0xFF00FF00 | (n & 0xFF0000) >> 16 | (n & 0xFF) << 16;
            }
            catch (NumberFormatException numberFormatException) {}
            return String.format("%08X", n);
        }
        return string.substring(2);
    }

    private static String parseAttributes(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(" ");
        if (stringArray.length >= 1) {
            String string2 = ConTEXTHighlighter.colorAttributeToHTML(stringArray[0]);
            String string3 = "";
            if (!"WindowText".equals(string2)) {
                string3 = "<font color=\"" + string2 + "\">";
            }
            if (stringArray.length >= 3) {
                int n = 0;
                while (n < stringArray[2].length()) {
                    string3 = String.valueOf(string3) + "<" + Character.toLowerCase(stringArray[2].charAt(n)) + ">";
                    ++n;
                }
            }
            return string3;
        }
        return null;
    }

    private static HashSet<Character> parseCharacters(String string) {
        HashSet<Character> hashSet = new HashSet<Character>();
        if (string != null) {
            String[] stringArray = string.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2.contains("..")) {
                    char c = string2.charAt(0);
                    while (c <= string2.charAt(3)) {
                        hashSet.add(Character.valueOf(c));
                        c = (char)(c + '\u0001');
                    }
                } else {
                    hashSet.add(Character.valueOf(string2.charAt(0)));
                }
                ++n2;
            }
        }
        return hashSet;
    }
}

