/*
 * Decompiled with CFR 0.152.
 */
package expressions;

public class Token {
    static final int TYPE_NUMBER = 0;
    static final int TYPE_OPERATOR = 1;
    static final int TYPE_IDENTIFIER = 2;
    static final int TYPE_PARENTHESIS = 3;
    private static final int NUM_TYPES = 4;
    private final int type;
    private final String token;
    private final long value;

    Token(int n, String string) {
        this(n, string, 10);
    }

    Token(int n, String string, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal type :" + Integer.toString(n));
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("token must not be null or empty.");
        }
        this.type = n;
        this.token = string;
        this.value = n == 0 ? Token.parseValue(string, n2) : Integer.MIN_VALUE;
    }

    private static long parseValue(String string, int n) {
        if (string.length() == 1) {
            return string.charAt(0) - 48;
        }
        switch (string.charAt(0)) {
            case '%': {
                return Token.parseBinaryNumber(string.substring(1));
            }
            case '$': {
                return Long.parseLong(string.substring(1), 16);
            }
            case '0': {
                if ("xX".indexOf(string.charAt(1)) < 0) break;
                return Long.parseLong(string.substring(2), 16);
            }
            case '\'': {
                if (string.charAt(1) == '\\') {
                    switch (string.charAt(2)) {
                        case 'n': {
                            return 10L;
                        }
                        case 'r': {
                            return 13L;
                        }
                        case 't': {
                            return 9L;
                        }
                        case '0': {
                            return 0L;
                        }
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            return string.charAt(2);
                        }
                    }
                    throw new NumberFormatException("Unknown escape character " + string);
                }
                return string.charAt(1);
            }
        }
        return Long.parseLong(string, n);
    }

    private static long parseBinaryNumber(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != '_') {
                int n3 = Character.digit(c, 2);
                if (n3 < 0) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                n = n << 1 | n3;
            }
            ++n2;
        }
        return n;
    }

    public boolean isNumber() {
        return this.type == 0;
    }

    public boolean isOperator() {
        return this.type == 1;
    }

    public boolean isIdentifier() {
        return this.type == 2;
    }

    public boolean isParenthesis() {
        return this.type == 3;
    }

    public String getToken() {
        return this.token;
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return this.token;
    }
}

