/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.EventColorModel;
import events.EventFilterListener;
import events.EventFilterModel;
import events.EventModel;
import events.EventScreenPixelModel;
import events.EventSelectionListener;
import events.EventSelectionModel;
import events.SingleEventSelectionModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class EventViewer
extends JComponent
implements EventFilterListener,
EventSelectionListener {
    private static final Insets INSETS = new Insets(0, 0, 0, 0);
    static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private BufferedImage displayImage;
    private BufferedImage eventsImage;
    private int[] pixels;
    private EventModel model;
    private EventFilterModel filterModel;
    private EventScreenPixelModel pixelModel;
    private EventColorModel eventColorModel;
    private EventSelectionModel selectionModel;
    int cursorX = -1;
    int cursorY = -1;
    int eventAtCursor = -1;
    private int dragStartX;
    private int dragStartY;
    private int selectionX;
    private int selectionY;
    private int selectionW;
    private int selectionH;
    private float scale = 1.0f;
    private boolean integerScaling;
    private boolean eventsInvalid;
    private MouseEvent lastMouseEvent;

    public EventViewer(EventModel eventModel, EventFilterModel eventFilterModel, EventScreenPixelModel eventScreenPixelModel, EventColorModel eventColorModel) {
        this.pixelModel = eventScreenPixelModel;
        this.selectionModel = new SingleEventSelectionModel();
        this.selectionModel.addEventSelectionListener(this);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EventViewer.this.updateCursor(mouseEvent);
                if (EventViewer.this.selectionW > 0 && EventViewer.this.selectionH > 0) {
                    if (!mouseEvent.isShiftDown() && (mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) {
                        EventViewer.this.getSelectionModel().clearSelection();
                    }
                    int n = EventViewer.this.getFrame();
                    int n2 = EventViewer.this.getModel().getNumberOfEvents(n);
                    int n3 = 0;
                    while (n3 < n2) {
                        if (EventViewer.this.isEventFilterEnabled(n, n3)) {
                            int n4 = EventViewer.this.getModel().getScanline(n, n3);
                            int n5 = EventViewer.this.getModel().getDot(n, n3);
                            if (n4 + 1 >= EventViewer.this.selectionY && n4 - 1 < EventViewer.this.selectionY + EventViewer.this.selectionH && n5 + 1 >= EventViewer.this.selectionX && n5 - 1 < EventViewer.this.selectionX + EventViewer.this.selectionW) {
                                EventViewer.this.getSelectionModel().setEventSelected(n3, true);
                            }
                        }
                        ++n3;
                    }
                }
                EventViewer.this.selectionW = 0;
                EventViewer.this.selectionH = 0;
                EventViewer.this.dragStartX = -1;
                EventViewer.this.dragStartY = -1;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EventViewer.this.updateCursor(mouseEvent);
                EventSelectionModel eventSelectionModel = EventViewer.this.getSelectionModel();
                int n = EventViewer.this.eventAtCursor;
                if (mouseEvent.isShiftDown()) {
                    if (n >= 0) {
                        int n2 = EventViewer.this.getModel().getNumberOfEvents(EventViewer.this.getFrame());
                        int n3 = n - 1;
                        boolean bl = false;
                        while (n3 >= 0) {
                            if (!bl) {
                                if (eventSelectionModel.isEventSelected(n3)) {
                                    bl = true;
                                }
                            } else if (n3 == 0 || !eventSelectionModel.isEventSelected(n3)) break;
                            --n3;
                        }
                        ++n3;
                        int n4 = n;
                        if (!bl) {
                            n3 = n;
                            ++n4;
                            while (n4 < n2) {
                                if (!bl) {
                                    if (eventSelectionModel.isEventSelected(n4)) {
                                        bl = true;
                                    }
                                } else if (n4 == n2 || !eventSelectionModel.isEventSelected(n4)) break;
                                ++n4;
                            }
                        }
                        if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) {
                            eventSelectionModel.clearSelection();
                        }
                        if (bl) {
                            int n5 = n3;
                            while (n5 < n4) {
                                if (EventViewer.this.isEventFilterEnabled(EventViewer.this.getFrame(), n5)) {
                                    eventSelectionModel.setEventSelected(n5, true);
                                }
                                ++n5;
                            }
                        }
                        eventSelectionModel.setEventSelected(n, true);
                    }
                } else {
                    if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) {
                        eventSelectionModel.clearSelection();
                    }
                    if (n >= 0) {
                        eventSelectionModel.setEventSelected(n, !eventSelectionModel.isEventSelected(n));
                    }
                }
                EventViewer.this.dragStartX = EventViewer.this.toScreenX(mouseEvent.getX());
                EventViewer.this.dragStartY = EventViewer.this.toScreenY(mouseEvent.getY());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EventViewer.this.cursorX = -1;
                EventViewer.this.cursorY = -1;
                EventViewer.this.eventAtCursor = -1;
                EventViewer.this.selectionW = 0;
                EventViewer.this.selectionH = 0;
                EventViewer.this.setCursor(DEFAULT_CURSOR);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EventViewer.this.updateCursor(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EventViewer.this.updateCursor(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                EventViewer.this.updateCursor(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                EventViewer.this.updateCursor(mouseEvent);
                int n = EventViewer.this.toScreenX(mouseEvent.getX());
                int n2 = EventViewer.this.toScreenY(mouseEvent.getY());
                EventViewer.this.selectionX = Math.min(n, EventViewer.this.dragStartX);
                EventViewer.this.selectionW = Math.abs(n - EventViewer.this.dragStartX);
                EventViewer.this.selectionY = Math.min(n2, EventViewer.this.dragStartY);
                EventViewer.this.selectionH = Math.abs(n2 - EventViewer.this.dragStartY);
                EventViewer.this.repaint();
            }
        });
        this.setModel(eventModel, eventFilterModel, eventColorModel);
    }

    void updateCursor(MouseEvent mouseEvent) {
        this.cursorX = this.toScreenX(mouseEvent.getX());
        this.cursorY = this.toScreenY(mouseEvent.getY());
        this.lastMouseEvent = mouseEvent;
        this.updateEventAtCursor();
    }

    void updateEventAtCursor() {
        int n;
        this.eventAtCursor = n = this.getEventAt(this.cursorY, this.cursorX);
        this.setCursor(n >= 0 ? HAND_CURSOR : DEFAULT_CURSOR);
        if (this.cursorX >= 0 && this.cursorY >= 0 && this.cursorX < this.pixelModel.getDotsPerLine() && this.cursorY < this.pixelModel.getNumScanlines()) {
            int n2 = this.getFrame();
            String string = this.getToolTipText();
            if (n >= 0) {
                int n3 = this.getModel().getEventType(n2, n);
                int n4 = this.getModel().getScanline(n2, n);
                int n5 = this.getModel().getDot(n2, n);
                int n6 = this.getModel().getOldValue(n2, n);
                int n7 = this.getModel().getNewValue(n2, n);
                String string2 = this.pixelModel.getPixelDescription(n4, n5);
                this.setToolTipText("<html><table><tr><td><b>Scanline</b>:</td><td>" + n4 + "</td></tr>" + "<tr><td><b>Dot</b>:</td><td>" + n5 + "</td></tr>" + "<tr><td><b>Mode</b>:</td><td>" + this.pixelModel.getMode(n4, n5) + "</td></tr>" + (string2 != null ? "<tr><td><b>Pixel</b>:</td><td>" + string2 + "</td></tr>" : "") + "<tr><td><b>Event</b>:</td><td><font color='white' bgcolor=#" + String.format("%06x", this.getEventColorModel().getColor(n3).getRGB() & 0xFFFFFF) + ">" + this.getModel().getEventName(n2, n) + "</font></td></tr>" + (n6 >= 0 ? "<tr><td><b>Old Value</b>:</td><td>" + String.format("%02X", this.getModel().getOldValue(n2, n)) + "</td></tr>" : "") + (n7 >= 0 ? "<tr><td><b>New Value</b>:</td><td>" + String.format("%02X", this.getModel().getNewValue(n2, n)) + "</td></tr>" : "") + "<tr><td><b>PC</b>:</td><td>" + this.getModel().getPCasString(n2, n) + "</td></tr>" + "</table></html>");
            } else {
                String string3 = this.pixelModel.getPixelDescription(this.cursorY, this.cursorX);
                this.setToolTipText("<html><table><tr><td><b>Scanline</b>:</td><td>" + this.cursorY + "</td></tr>" + "<tr><td><b>Dot</b>:</td><td>" + this.cursorX + "</td></tr>" + "<tr><td><b>Mode</b>:</td><td>" + this.pixelModel.getMode(this.cursorY, this.cursorX) + "</td></tr>" + (string3 != null ? "<tr><td><b>Pixel</b>:</td><td>" + string3 + "</td></tr>" : "") + "</table></html>");
            }
            if (this.lastMouseEvent != null && !this.getToolTipText().equals(string)) {
                ToolTipManager.sharedInstance().mouseMoved(this.lastMouseEvent);
            }
        } else {
            this.setToolTipText(null);
        }
    }

    public void updateImage() {
        int n = this.pixelModel.getDotsPerLine();
        int n2 = this.pixelModel.getNumScanlines();
        if (this.displayImage == null || this.displayImage.getHeight() != n2 || this.displayImage.getWidth() != n) {
            this.displayImage = new BufferedImage(this.pixelModel.getDotsPerLine(), this.pixelModel.getNumScanlines(), 1);
            this.eventsImage = new BufferedImage(this.displayImage.getWidth(), this.displayImage.getHeight(), 2);
            this.pixels = ((DataBufferInt)this.displayImage.getRaster().getDataBuffer()).getData();
            this.revalidate();
        }
        this.pixelModel.getScreenPixels(this.pixels);
        this.invalidateEvents();
    }

    private synchronized void updateEvents() {
        int n;
        int n2;
        int n3 = this.getFrame();
        int n4 = this.model.getNumberOfEvents(n3);
        if (n4 <= 0) {
            return;
        }
        Graphics2D graphics2D = this.eventsImage.createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, this.eventsImage.getWidth(), this.eventsImage.getHeight());
        graphics2D.setComposite(composite);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            if (this.isEventFilterEnabled(n3, n6)) {
                n2 = this.model.getEventType(n3, n6);
                graphics2D.setColor(this.eventColorModel.getColor(n2));
                n = this.model.getDot(n3, n6);
                int n7 = this.model.getScanline(n3, n6);
                if (n >= 0 && n7 >= 0) {
                    graphics2D.drawRect(n - 1, n7 - 1, 3, 3);
                    if (this.selectionModel.isEventSelected(n6)) {
                        ++n5;
                    }
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n4 && n5 > 0) {
            if (this.selectionModel.isEventSelected(n6) && this.isEventFilterEnabled(n3, n6)) {
                n2 = this.model.getDot(n3, n6);
                n = this.model.getScanline(n3, n6);
                if (n2 >= 0 && n >= 0) {
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.drawRect(n2 - 2, n - 2, 5, 5);
                    graphics2D.setColor(Color.GRAY);
                    graphics2D.drawRect(n2 - 3, n - 3, 7, 7);
                    --n5;
                }
            }
            ++n6;
        }
        this.updateEventAtCursor();
        graphics2D.dispose();
    }

    private synchronized void invalidateEvents() {
        this.eventsInvalid = true;
        this.repaint();
    }

    private int getEventAt(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n2 >= 0 && n < this.pixelModel.getNumScanlines() && n < this.pixelModel.getDotsPerLine()) {
            int n4 = this.getFrame();
            int n5 = this.model.getNumberOfEvents(n4);
            int n6 = 0;
            while (n6 < n5) {
                if (this.isEventFilterEnabled(n4, n6)) {
                    int n7 = this.model.getDot(n4, n6);
                    int n8 = this.model.getScanline(n4, n6);
                    if (n8 == n && n7 == n2) {
                        return n6;
                    }
                    if (n3 < 0 && n7 >= 0 && n8 >= 0 && Math.abs(n8 - n) <= 2 && Math.abs(n7 - n2) <= 2) {
                        n3 = n6;
                    }
                }
                ++n6;
            }
        }
        return n3;
    }

    protected boolean isEventFilterEnabled(int n, int n2) {
        int n3 = this.model.getEventType(n, n2);
        return this.filterModel.isEventTypeFilterEnabled(n3) && (this.filterModel.isShowReads() || !this.model.isRead(n, n2));
    }

    public void setModel(EventModel eventModel, EventFilterModel eventFilterModel, EventColorModel eventColorModel) {
        this.model = eventModel;
        if (this.filterModel != null) {
            this.filterModel.removeEventFilterListener(this);
        }
        this.filterModel = eventFilterModel;
        eventFilterModel.addEventFilterListener(this);
        this.eventColorModel = eventColorModel;
        this.updateImage();
    }

    public EventModel getModel() {
        return this.model;
    }

    public void setSelectionModel(EventSelectionModel eventSelectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeEventSelectionListener(this);
        }
        this.selectionModel = eventSelectionModel;
        eventSelectionModel.addEventSelectionListener(this);
    }

    public EventSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public EventFilterModel getFilterModel() {
        return this.filterModel;
    }

    public EventColorModel getEventColorModel() {
        return this.eventColorModel;
    }

    public int getFrame() {
        return 0;
    }

    protected Color getSelectionForeground() {
        return null;
    }

    protected Color getSelectionBackground() {
        return null;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public float getScale() {
        return this.scale;
    }

    public void setIntegerScaling(boolean bl) {
        this.integerScaling = bl;
        this.repaint();
    }

    public boolean isIntegerScaling() {
        return this.integerScaling;
    }

    private float getScaleX() {
        return (float)this.getContentWidth() / (float)this.displayImage.getWidth();
    }

    private float getScaleY() {
        return (float)this.getContentHeight() / (float)this.displayImage.getHeight();
    }

    private int getContentWidth() {
        Insets insets = this.getInsets(INSETS);
        return this.getWidth() - insets.left - insets.right;
    }

    private int getContentHeight() {
        Insets insets = this.getInsets(INSETS);
        return this.getHeight() - insets.top - insets.bottom;
    }

    public int toScreenX(int n) {
        if (this.displayImage == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.displayImage.getWidth() * this.getScale());
        int n3 = Math.max(0, this.getContentWidth() - n2) / 2;
        int n4 = n - n3 - insets.left;
        if (n4 < 0) {
            n4 = (int)((float)n4 - this.getScale());
        }
        return (int)((float)n4 / this.getScale());
    }

    public int toScreenY(int n) {
        if (this.displayImage == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.displayImage.getHeight() * this.getScale());
        int n3 = Math.max(0, this.getContentHeight() - n2) / 2;
        int n4 = n - n3 - insets.top;
        if (n4 < 0) {
            n4 = (int)((float)n4 - this.getScale());
        }
        return (int)((float)n4 / this.getScale());
    }

    public int toWindowX(int n) {
        if (this.displayImage == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.displayImage.getWidth() * this.getScale());
        int n3 = Math.max(0, this.getContentWidth() - n2) / 2;
        return insets.left + (int)((float)n * this.getScale()) + n3;
    }

    public int toWindowY(int n) {
        if (this.displayImage == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.displayImage.getHeight() * this.getScale());
        int n3 = Math.max(0, this.getContentHeight() - n2) / 2;
        return insets.top + (int)((float)n * this.getScale()) + n3;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        final int n = ToolTipManager.sharedInstance().getInitialDelay();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setInitialDelay(n);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
            }
        });
        Container container = this.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container != null) {
            ((Window)container).addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                }

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                    ToolTipManager.sharedInstance().setInitialDelay(n);
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.eventsInvalid) {
            this.updateEvents();
        }
        this.scale = Math.min(this.getScaleX(), this.getScaleY());
        if (this.integerScaling) {
            this.scale = Math.max(1, (int)this.scale);
        }
        Insets insets = this.getInsets(INSETS);
        int n = (int)((float)this.displayImage.getWidth() * this.scale);
        int n2 = (int)((float)this.displayImage.getHeight() * this.scale);
        int n3 = insets.left + (this.getContentWidth() - n) / 2;
        int n4 = insets.top + (this.getContentHeight() - n2) / 2;
        graphics.drawImage(this.displayImage, n3, n4, n3 + n, n4 + n2, 0, 0, this.displayImage.getWidth(), this.displayImage.getHeight(), null);
        graphics.drawImage(this.eventsImage, n3, n4, n3 + n, n4 + n2, 0, 0, this.eventsImage.getWidth(), this.eventsImage.getHeight(), null);
        if (this.selectionW > 0 && this.selectionH > 0) {
            graphics.setXORMode(Color.WHITE);
            graphics.drawRect(n3 + (int)((float)this.selectionX * this.scale), n4 + (int)((float)this.selectionY * this.scale), (int)((float)this.selectionW * this.scale), (int)((float)this.selectionH * this.scale));
            graphics.setPaintMode();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.displayImage.getWidth(), this.displayImage.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)((float)this.displayImage.getWidth() * this.scale), (int)((float)this.displayImage.getHeight() * this.scale));
    }

    @Override
    public void eventFilterChanged(int n, boolean bl) {
        this.invalidateEvents();
    }

    @Override
    public void selectionChanged(int n, boolean bl) {
        this.invalidateEvents();
    }
}

