/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.Event;
import events.EventModel;
import events.EventType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractArrayListEventModel
implements EventModel {
    private final Event CURRENT = new Event(){

        @Override
        public int getType() {
            return AbstractArrayListEventModel.this.eventNames.length;
        }

        @Override
        public int getOldValue() {
            return -1;
        }

        @Override
        public int getNewValue() {
            return -1;
        }

        @Override
        public int getScanline() {
            return AbstractArrayListEventModel.this.getCurrentScanline();
        }

        @Override
        public int getDot() {
            return AbstractArrayListEventModel.this.getCurrentDot();
        }

        @Override
        public int getPC() {
            return AbstractArrayListEventModel.this.getCurrentPC();
        }
    };
    final String[] eventGroupNames;
    final String[] eventNames;
    final int[][] eventTypes;
    List<Event> events = new ArrayList<Event>();
    int numEvents;
    List<Event> exEvents = new ArrayList<Event>();
    int exNumEvents;

    public AbstractArrayListEventModel(EventType[] eventTypeArray) {
        LinkedHashMap<String, ArrayList<EventType>> linkedHashMap = new LinkedHashMap<String, ArrayList<EventType>>();
        this.eventNames = new String[eventTypeArray.length];
        Object object = eventTypeArray;
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventType eventType = object[n2];
            ArrayList<EventType> arrayList = (ArrayList<EventType>)linkedHashMap.get(eventType.getGroup());
            if (arrayList == null) {
                arrayList = new ArrayList<EventType>();
                linkedHashMap.put(eventType.getGroup(), arrayList);
            }
            arrayList.add(eventType);
            this.eventNames[eventType.ordinal()] = eventType.toString();
            ++n2;
        }
        this.eventGroupNames = new String[linkedHashMap.size()];
        this.eventTypes = new int[linkedHashMap.size()][];
        int n3 = 0;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object = (List)entry.getValue();
            this.eventTypes[n3] = new int[object.size()];
            int n4 = 0;
            while (n4 < this.eventTypes[n3].length) {
                this.eventTypes[n3][n4] = ((EventType)object.get(n4)).ordinal();
                ++n4;
            }
            this.eventGroupNames[n3++] = (String)entry.getKey();
        }
    }

    @Override
    public int getNumberOfEventGroups() {
        return this.eventGroupNames.length;
    }

    @Override
    public String getEventGroupName(int n) {
        return this.eventGroupNames[n];
    }

    @Override
    public int[] getEventTypes(int n) {
        return this.eventTypes[n];
    }

    @Override
    public String getEventTypeName(int n) {
        if (n == this.eventNames.length) {
            return "Curr";
        }
        return this.eventNames[n];
    }

    @Override
    public synchronized int getNumberOfEvents(int n) {
        return n == 0 ? this.numEvents + 1 : this.exNumEvents;
    }

    private synchronized Event getEvent(int n, int n2) {
        List<Event> list = n == 0 ? this.events : this.exEvents;
        int n3 = this.numEvents;
        if (n == 0 && n2 == n3 || n2 >= list.size()) {
            return this.CURRENT;
        }
        return list.get(n2);
    }

    @Override
    public int getEventType(int n, int n2) {
        return this.getEvent(n, n2).getType();
    }

    @Override
    public int getPC(int n, int n2) {
        return this.getEvent(n, n2).getPC();
    }

    @Override
    public String getPCasString(int n, int n2) {
        return this.pcToString(this.getPC(n, n2));
    }

    protected abstract String pcToString(int var1);

    @Override
    public int getScanline(int n, int n2) {
        return this.getEvent(n, n2).getScanline();
    }

    @Override
    public int getDot(int n, int n2) {
        return this.getEvent(n, n2).getDot();
    }

    @Override
    public String getEventName(int n, int n2) {
        return this.getEventTypeName(this.getEvent(n, n2).getType());
    }

    @Override
    public int getOldValue(int n, int n2) {
        return this.getEvent(n, n2).getOldValue();
    }

    @Override
    public int getNewValue(int n, int n2) {
        return this.getEvent(n, n2).getNewValue();
    }

    @Override
    public String getDetails(int n, int n2) {
        Event event = this.getEvent(n, n2);
        return event.getDetails() != null ? event.getDetails() : this.getDetails(event);
    }

    @Override
    public boolean isRead(int n, int n2) {
        return this.isRead(this.getEvent(n, n2));
    }

    protected abstract String getDetails(Event var1);

    protected abstract int getCurrentScanline();

    protected abstract int getCurrentDot();

    protected abstract int getCurrentPC();

    protected abstract boolean isRead(Event var1);

    public void addEvent(EventType eventType, int n, int n2, int n3, int n4, int n5, int n6, String string) {
        if (this.events.size() <= this.numEvents) {
            this.events.add(new Event());
        }
        this.events.get(this.numEvents++).set(eventType.ordinal(), n, n2, n3, n4, n5, n6, string);
    }

    public synchronized void finishFrame() {
        List<Event> list = this.events;
        this.events = this.exEvents;
        this.exEvents = list;
        this.exNumEvents = this.numEvents;
        this.numEvents = 0;
    }
}

