/*
 * Decompiled with CFR 0.152.
 */
package disassembler.dialects;

import assembler.HexStrings;
import disassembler.Section;
import disassembler.SectionProvider;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import disassembler.dialects.AssemblerDialect;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import util.map.HashIntMap;
import util.map.HashMap;
import util.map.Map;
import util.set.IntHashSet;

public class RgbdsDialect
implements AssemblerDialect {
    private static AssemblerDialect instance;

    private RgbdsDialect() {
    }

    public static AssemblerDialect getInstance() {
        if (instance == null) {
            instance = new RgbdsDialect();
        }
        return instance;
    }

    @Override
    public void writeHeader(List<Z80Disassembler.SourceLine> list, int[] nArray, boolean bl) {
        list.add(new Z80Disassembler.SourceLine("; If you want to reassemble this disassembly make sure to disable RGBDS optimizations."));
        list.add(new Z80Disassembler.SourceLine("; To disable them use the -h and -L commandline flags when invoking rgbasm."));
    }

    @Override
    public void writeRAMdefinitions(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeRamSections(list, map, sectionProvider, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    @Override
    public void updateRAMdefinitions(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.rewriteRamSections(list, map, sectionProvider, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    @Override
    public void writePortDefinitions(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        RgbdsDialect.writePortEqus(list, map, hashMap, string);
    }

    @Override
    public void updatePortDefinitions(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        RgbdsDialect.rewritePortEqus(list, map, hashMap, string);
    }

    @Override
    public void writeStartOfBank(List<Z80Disassembler.SourceLine> list, int n, int n2) {
        list.add(new Z80Disassembler.SourceLine("SECTION \"rom" + Integer.toHexString(n) + "\", " + (n == 0 ? "ROM0" : "ROMX, BANK[$" + Integer.toHexString(n) + "]")));
    }

    @Override
    public void writeSection(List<Z80Disassembler.SourceLine> list, Section section) {
        list.add(new Z80Disassembler.SourceLine(section.toString()));
    }

    @Override
    public char getChildLabelChar() {
        return '.';
    }

    @Override
    public String getDataPrefix(int n) {
        if (n > 4) {
            return "ds";
        }
        return n == 2 ? "dw" : "db";
    }

    @Override
    public String getHighByte(String string) {
        return "HIGH(" + string + ")";
    }

    @Override
    public String getLowByte(String string) {
        return "LOW(" + string + ")";
    }

    @Override
    public String getCurrentAddressSymbol() {
        return "@";
    }

    @Override
    public boolean requiresDataCommas() {
        return true;
    }

    @Override
    public boolean requiresSquareBrackets() {
        return true;
    }

    @Override
    public boolean requiresAbsoluteAddressesForRelativeBranches() {
        return true;
    }

    @Override
    public boolean supportsAnonymousLabels() {
        return false;
    }

    @Override
    public String getIncBinLine(String string) {
        return string != null ? "INCBIN \"" + string + "\"" : "INCBIN ...";
    }

    private void writeRamSections(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeRamSections(list, list.size(), map, sectionProvider, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    private void writeRamSections(List<Z80Disassembler.SourceLine> list, int n, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        int n2;
        int n3;
        int n4;
        if (n < 0) {
            return;
        }
        BitSet bitSet = hashMap.keyBitSet();
        BitSet bitSet2 = hashMap2.keyBitSet();
        BitSet bitSet3 = Symbols.getRamSymbolKeys(map);
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>(2 * (hashMap.size() + hashMap2.size()));
        boolean bl = true;
        int n5 = 0;
        int n6 = 0;
        while (n6 < 65536) {
            List<Symbols.Symbol> list2;
            List<Symbols.Symbol> list3 = list2 = bitSet3.get(0xC000 | n6) ? Symbols.findRamSymbols(0xC000 | n6, map) : null;
            if (bitSet.get(n6) || list2 != null && !list2.isEmpty()) {
                String string3;
                Section section;
                if (sectionProvider != null && (section = sectionProvider.getRamSection(n6)) != null) {
                    arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                    arrayList.add(new Z80Disassembler.SourceLine(section.toString()));
                    n5 = n6 + section.getSize();
                    bl = false;
                }
                if (bl) {
                    arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                    if (n6 < 4096) {
                        arrayList.add(new Z80Disassembler.SourceLine("SECTION \"wram_" + Integer.toHexString(0xC000 | n6) + "\", WRAM0[" + "$" + Integer.toHexString(0xC000 | n6 & 0xFFF).toUpperCase() + "]"));
                    } else if (n6 >= 65408) {
                        arrayList.add(new Z80Disassembler.SourceLine("SECTION \"hram_" + Integer.toHexString(n6) + "\", HRAM[" + "$" + Integer.toHexString(n6).toUpperCase() + "]"));
                    } else {
                        arrayList.add(new Z80Disassembler.SourceLine("SECTION \"wram_" + Integer.toHexString(0xC000 | n6) + "\", WRAMX[" + "$" + Integer.toHexString(0xD000 | n6 & 0xFFF).toUpperCase() + "]"));
                    }
                    bl = false;
                }
                if ((n4 = (n3 = Math.min(bitSet.nextSetBit(n6 + 1) & Integer.MAX_VALUE, (n6 < 65408 ? bitSet3.nextSetBit(0xC000 | n6 + 1) - 49152 : bitSet3.nextSetBit(n6 + 1)) & Integer.MAX_VALUE)) - n6) > 1) {
                    int n7 = n5 > n6 ? n5 - n6 : hashIntMap.get(n6);
                    int n8 = n4 = n7 != Integer.MIN_VALUE ? Math.min(n4, n7) : 1;
                }
                String string4 = n4 == 1 ? ": db" : (string3 = n4 == 2 ? ": dw" : ": ds $" + Integer.toHexString(n4));
                if (list2 != null && !list2.isEmpty()) {
                    n2 = 0;
                    while (n2 < list2.size()) {
                        Symbols.Symbol symbol = list2.get(n2);
                        arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(symbol.getLabel()) + (n2 == list2.size() - 1 ? string3 : ":") + (symbol.getComment() != null ? "\t" + symbol.getComment() : "")));
                        ++n2;
                    }
                } else {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, 0xC000 | n6)) + string3));
                }
                n6 += n4 - 1;
            } else {
                bl = true;
                n3 = bitSet3.nextSetBit(49152 + n6);
                if (n3 < 65408) {
                    n3 -= 49152;
                }
                n6 = Math.min(bitSet.nextSetBit(n6) & Integer.MAX_VALUE, n3 & Integer.MAX_VALUE) - 1;
            }
            ++n6;
        }
        n6 = this.getSRAMsize();
        int n9 = n6 - 1;
        n3 = 0;
        while (n3 < this.getNumSRAMbanks()) {
            bl = true;
            n4 = 0;
            while (n4 < n6) {
                int n10 = n3 * n6 | n4 & n9;
                if (bitSet2.get(n10)) {
                    int n11;
                    if (bl) {
                        arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                        arrayList.add(new Z80Disassembler.SourceLine("SECTION \"sram_" + Integer.toHexString(this.getSRAMstart() + n10) + "\", SRAM[" + "$" + Integer.toHexString(this.getSRAMstart() + n4).toUpperCase() + (n3 > 0 ? "], BANK[" + n3 + "]" : "]")));
                        bl = false;
                    }
                    if ((n11 = (n2 = bitSet2.nextSetBit(n10 + 1) & Integer.MAX_VALUE) - n10) > 1) {
                        int n12 = hashIntMap2.get(n10);
                        int n13 = n11 = n12 != Integer.MIN_VALUE ? Math.min(n11, n12) : 1;
                    }
                    String string5 = n11 == 1 ? ": db" : (n11 == 2 ? ": dw" : ": ds $" + Integer.toHexString(n11));
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string2, n10)) + string5));
                    n4 += n11 - 1;
                } else {
                    bl = true;
                    n4 = (bitSet2.nextSetBit(n10) & Integer.MAX_VALUE) - n3 * n6 - 1;
                }
                ++n4;
            }
            ++n3;
        }
        arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        list.addAll(n, arrayList);
    }

    protected int getNumSRAMbanks() {
        return 4;
    }

    protected int getSRAMsize() {
        return 8192;
    }

    protected int getSRAMstart() {
        return 40960;
    }

    private static int removeRamSections(List<Z80Disassembler.SourceLine> list) {
        int n = Z80Disassembler.findBeginningOfDisassembly(list);
        while (n < list.size()) {
            Z80Disassembler.SourceLine sourceLine = list.get(n);
            if (sourceLine.toString().startsWith("SECTION") && (sourceLine.toString().contains("WRAM0[") || sourceLine.toString().contains("WRAMX[") || sourceLine.toString().contains("HRAM[") || sourceLine.toString().contains("SRAM["))) {
                int n2 = n - 1;
                while (sourceLine.toString().startsWith("SECTION") && (sourceLine.toString().contains("WRAM0[") || sourceLine.toString().contains("WRAMX[") || sourceLine.toString().contains("HRAM[") || sourceLine.toString().contains("SRAM["))) {
                    sourceLine = list.get(++n);
                    while (sourceLine != Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT && !sourceLine.toString().startsWith("SECTION")) {
                        sourceLine = list.get(++n);
                    }
                }
                list.subList(n2, n).clear();
                return n2;
            }
            ++n;
        }
        return -1;
    }

    private void rewriteRamSections(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeRamSections(list, RgbdsDialect.removeRamSections(list), map, sectionProvider, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    private static void writePortEqus(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        RgbdsDialect.writePortEqus(list, list.size(), map, hashMap, string);
    }

    private static void writePortEqus(List<Z80Disassembler.SourceLine> list, int n, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        if (n < 0) {
            return;
        }
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>(hashMap.size() + 4);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        IntHashSet intHashSet = new IntHashSet();
        IntHashSet intHashSet2 = new IntHashSet();
        for (Map.Entry<IntHashSet> entry : hashMap.entrySet()) {
            int n2 = entry.getKey();
            treeSet.add(n2);
            boolean bl = false;
            boolean bl2 = false;
            if (map.get(n2) != map.get(-n2)) {
                int[] nArray = entry.getValue().keys();
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray[n4];
                    if (Z80Disassembler.isPortRead(n2, n5)) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                    if (!bl || !bl2) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                intHashSet2.add(n2);
            }
            if (!bl) continue;
            intHashSet.add(n2);
        }
        if (!treeSet.isEmpty()) {
            arrayList.add(Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT);
            Iterator<Map.Entry<IntHashSet>> iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)((Object)iterator.next());
                if (!intHashSet2.contains(n6) && intHashSet.contains(n6)) continue;
                String string2 = map.get(n6);
                if (string2 != null) {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(string2) + " EQU" + HexStrings.PREFIXED_HEX_STRINGS[n6]));
                    continue;
                }
                if (intHashSet2.contains(n6)) {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n6)) + " EQU" + HexStrings.PREFIXED_HEX_STRINGS[n6]));
                    continue;
                }
                arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n6)) + " EQU" + HexStrings.PREFIXED_HEX_STRINGS[n6]));
            }
            if (!intHashSet.isEmpty()) {
                arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                arrayList.add(new Z80Disassembler.SourceLine("; Input Ports"));
                iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n7 = (Integer)((Object)iterator.next());
                    if (!intHashSet.contains(n7)) continue;
                    String string3 = map.get(-n7);
                    if (string3 != null) {
                        arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(string3) + " EQU" + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                        continue;
                    }
                    if (intHashSet2.contains(n7)) {
                        arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n7)) + " EQU" + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                        continue;
                    }
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n7)) + " EQU" + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                }
            }
            arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        }
        list.addAll(n, arrayList);
    }

    private static int removePortEqus(List<Z80Disassembler.SourceLine> list) {
        int n = Z80Disassembler.findBeginningOfDisassembly(list);
        while (n < list.size()) {
            Z80Disassembler.SourceLine sourceLine = list.get(n);
            if (sourceLine == Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT) {
                int n2 = n++;
                sourceLine = list.get(n);
                while (sourceLine.toString().contains(" EQU ")) {
                    sourceLine = list.get(++n);
                }
                if ("; Input Ports".equals(list.get(n + 1).toString())) {
                    ++n;
                    sourceLine = list.get(++n);
                    while (sourceLine.toString().startsWith(" EQU ")) {
                        sourceLine = list.get(++n);
                    }
                }
                list.subList(n2, ++n).clear();
                return n2;
            }
            if (sourceLine.getAddress() >= 0) {
                while (n > 0 && sourceLine != Z80Disassembler.SourceLine.EMPTY_LINE) {
                    sourceLine = list.get(--n);
                }
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    private static void rewritePortEqus(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        RgbdsDialect.writePortEqus(list, RgbdsDialect.removePortEqus(list), map, hashMap, string);
    }

    public String toString() {
        return "RGBDS";
    }
}

