/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import assembler.HexStrings;
import assembler.LR35902Assembler;
import assembler.LR35902Instruction;
import assembler.MemoryMap;
import assembler.NoMemoryMap;
import assembler.ROMBankMap;
import assembler.Section;
import assembler.SourceMap;
import assembler.Z80Assembler;
import assembler.Z80Instruction;
import assembler.Z80ParseResult;
import assembler.Z80SourceLine;
import assembler.gb.GBParserMultiplexer;
import assembler.mastersystem.DefaultROMBankMap;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.ParseException;
import assembler.sjasm.SjasmParser;
import assembler.wladx.WLAParser;
import components.cartridge.Cartridge;
import components.cartridge.GBCartridge;
import components.cartridge.MSXCartridge;
import components.cartridge.SMSCartridge;
import components.cpu.CpuInfo;
import components.cpu.Z80Info;
import disassembler.AbortException;
import disassembler.AbstractCSourceMap;
import disassembler.Address;
import disassembler.CDBSourceMap;
import disassembler.HashMapStack;
import disassembler.LR35902Disassembler;
import disassembler.ResolveAddressException;
import disassembler.Section;
import disassembler.SectionProvider;
import disassembler.Symbols;
import disassembler.Value;
import disassembler.dialects.AssemblerDialect;
import evscript.EvscriptDebugInfo;
import evscript.EvscriptSourceMap;
import filesystem.MemoryFAT;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import msx.MSXDisk;
import msx.MSXZ80Info;
import platform.LabelProvider;
import sdcc.CDBParser;
import sdcc.cdb.FunctionRecord;
import sdcc.cdb.LinkerAsmRecord;
import sdcc.cdb.LinkerCRecord;
import sdcc.cdb.LinkerSymbolRecord;
import sdcc.cdb.Record;
import sdcc.cdb.SymbolRecord;
import system.DebuggableSystem;
import system.RamRomMap;
import util.deque.ArrayIntDeque;
import util.deque.IntDeque;
import util.map.HashIntBiMap;
import util.map.HashIntMap;
import util.map.HashMap;
import util.map.IntMap;
import util.map.Map;
import util.set.IntHashSet;

public class Z80Disassembler {
    private static final int[] ENTRY_POINTS;
    static final RamRomMap defaultRamRomMap;
    private static int MAX_DATA_BLOCK_SIZE;
    private static int DSB_DATA_BLOCK_SIZE;
    private static String FORMAT_CODE_LABEL;
    private static String FORMAT_DATA_LABEL;
    protected static String FORMAT_RAM_LABEL;
    private static String FORMAT_SRAM_LABEL;
    protected static String FORMAT_PORT_LABEL;
    private static boolean CREATE_LINK_FILE;
    private static boolean USE_ANONYMOUS_LABELS;
    private static boolean USE_UPPERCASE_MNEMONICS;
    private static boolean PAD_MNEMONICS;
    private static boolean ALLOW_CALLS_TO_UNKNOWN_RAM;
    private static PrintStream ERROR_STREAM;
    private static final PrintStream NIRVANA;
    private static final State DUMMY_STATE;
    private static final State UNMODIFIABLE_DUMMY_STATE;
    protected static Z80Disassembler instance;
    protected static HashMap<IntHashSet> seen;
    protected static HashMap<IntHashSet> dataSeen;
    protected static HashMap<IntHashSet> ramSeen;
    protected static HashMap<IntHashSet> sramSeen;
    protected static HashMap<IntHashSet> portSeen;
    private static HashMap<IntHashSet> path;
    private static HashIntMap dataSeenPartial;
    private static HashIntMap ramSizes;
    private static HashIntMap sramSizes;
    private static HashIntMap tableEntrySeen;
    private static BitSet dataSeenExact;
    private static BitSet labels;
    private static BitSet overridingRet;
    private static BitSet badCode;
    protected static byte[] code;
    private static HashMap<Z80Instruction> instructions;
    private static int[] indexMinValues;
    private static BitSet instructionStart;
    private static BitSet functionPointers;
    private static BitSet memoryJump;
    private static BitSet memoryTableRead;
    private static BitSet memoryTableReadRead;
    private static HashMap<util.map.Map<Table>> entriesOfTablePointToTables;
    private static BitSet entriesOfTablePointToTablesOfPointerTables;
    private static HashMap<IntHashSet> entriesOfTablePointToTablesOfTablesOfPointerTables;
    private static BitSet entriesOfTablePointToTablesOfJumpTables;
    private static BitSet entriesOfTablePointToJumpTables;
    private static HashMap<List<Value>> memoryPointers;
    private static HashMap<State> memoryPointerStates;
    private static HashMap<Table> memoryTables;
    private static HashMap<MemoryJump> memoryJumps;
    private static HashMap<RamCodeWrite> ramCodeWrites;
    private static TreeSet<Table> jumpTables;
    private static TreeSet<Table> pointerTables;
    private static HashMap<Value> bank0;
    private static HashMap<Value> bank1;
    private static HashMap<Value> bank2;
    private static HashMap<Value> bank3;
    private static BitSet sramEnabled;
    private static HashMap<Value> sramBank;
    private static int[] slots;
    protected static HashIntBiMap ramCode;
    private static HashIntMap sramCode;
    private static ArrayList<DataBlock> dataBlocks;
    private static IntDeque retAddresses;
    private static boolean abort;
    protected static Boolean shouldReturn;
    private static int beginningOfDisassembly;
    protected static boolean msx;
    private static int[] msxEntryPoints;
    private static Cartridge dummyCartridge;
    private static SourceMap sourceMap;
    protected static AssemblerDialect dialect;
    private static String prevNonChildLabel;
    protected static String[] singleByteDataBlockLines;
    private static final int SDCC_MAX_LABEL_LENGTH_FOR_MATCH = 32;

    static {
        int[] nArray = new int[3];
        nArray[1] = 56;
        nArray[2] = 102;
        ENTRY_POINTS = nArray;
        defaultRamRomMap = new RamRomMap(){

            @Override
            public int toRomAddress(int n) {
                if (ramCode == null) {
                    return Integer.MIN_VALUE;
                }
                return ramCode.get(n);
            }

            @Override
            public int toRamAddress(int n) {
                if (ramCode == null) {
                    return Integer.MIN_VALUE;
                }
                return ramCode.getKey(n);
            }
        };
        FORMAT_CODE_LABEL = "";
        FORMAT_DATA_LABEL = "";
        FORMAT_RAM_LABEL = "";
        FORMAT_SRAM_LABEL = "";
        FORMAT_PORT_LABEL = "";
        NIRVANA = new PrintStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }
        }){

            @Override
            public void print(String string) {
            }

            @Override
            public void println(String string) {
            }

            @Override
            public void println(Object object) {
            }
        };
        DUMMY_STATE = new State(){

            @Override
            public void exx() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void exAF() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void exStackTopHL(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setPC(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void pushPC() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void addToPC(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void addToSP(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void saveSP(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void ldSP(RegisterPair registerPair) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void union(Collection<State> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void union(State state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setRAMvalue(int n, Value value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void djnz() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int popPC() {
                throw new UnsupportedOperationException();
            }
        };
        UNMODIFIABLE_DUMMY_STATE = Z80Disassembler.unmodifiableState(DUMMY_STATE);
        singleByteDataBlockLines = new String[256];
    }

    public static Reference getReferenceHierarchy(int n) {
        return new Reference(n);
    }

    public static Reference getRamReferenceHierarchy(int n) {
        return new RamReference(n);
    }

    public static Reference getSramReferenceHierarchy(int n, int n2) {
        return new SramReference(instance.mapSRAMaddress(n, Z80Disassembler.getSRAMbank(n2).getMin()));
    }

    public static Reference getPortReferenceHierarchy(SourceLine sourceLine, util.map.Map<String> map) {
        if (sourceLine == null || sourceLine.getInstruction() == null || !Z80Disassembler.isPortSeen(sourceLine.getInstruction().getArg() & 0xFF, sourceLine.getAddress())) {
            return null;
        }
        int n = sourceLine.getInstruction().getArg() & 0xFF;
        boolean bl = Z80Disassembler.isPortRead(n, sourceLine.getAddress());
        boolean bl2 = map.get(n) == map.get(-n);
        return new PortReference(n, bl || bl2, !bl || bl2);
    }

    public static Reference getPortReferenceHierarchy(int n, boolean bl, boolean bl2) {
        return new PortReference(n, bl, bl2);
    }

    public static String getFormattedRAMlabel(int n) {
        return String.format(FORMAT_RAM_LABEL, n);
    }

    public static String getFormattedSRAMlabel(int n) {
        return String.format(FORMAT_SRAM_LABEL, n);
    }

    public static String getFormattedPortLabel(int n) {
        return String.format(FORMAT_PORT_LABEL, n);
    }

    public static Z80Instruction disassemble(int[] nArray, int n) {
        block4: {
            try {
                if (n >= 0 && n < nArray.length) break block4;
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        if (instance != null) {
            return instance.getInstruction(nArray, n);
        }
        return Z80Instruction.parse(nArray, n);
    }

    protected CpuInfo getCpuInfo() {
        if (msx) {
            return MSXZ80Info.getInstance();
        }
        return Z80Info.getInstance();
    }

    public static int getMinCycles(Z80Instruction z80Instruction) {
        if (z80Instruction == null || instance == null) {
            return 0;
        }
        CpuInfo cpuInfo = instance.getCpuInfo();
        int n = z80Instruction.getPrefix();
        int n2 = z80Instruction.getOpCode();
        if (n2 >= 256) {
            n = n << 8 | n2 >> 8;
            n2 &= 0xFF;
        }
        return cpuInfo.getMinCycles(n2, n);
    }

    public static int getMaxCycles(Z80Instruction z80Instruction) {
        if (z80Instruction == null || instance == null) {
            return 0;
        }
        CpuInfo cpuInfo = instance.getCpuInfo();
        int n = z80Instruction.getPrefix();
        int n2 = z80Instruction.getOpCode();
        if (n2 >= 256) {
            n = n << 8 | n2 >> 8;
            n2 &= 0xFF;
        }
        return cpuInfo.getMaxCycles(n2, n);
    }

    public static List<Z80Instruction> disassemble(int[] nArray, int n, int n2, boolean bl) {
        ArrayList<Z80Instruction> arrayList = new ArrayList<Z80Instruction>();
        while (n < nArray.length && n2 > 0) {
            Z80Instruction z80Instruction = instance != null ? instance.getInstruction(nArray, n) : Z80Instruction.parse(nArray, n);
            n += z80Instruction.getSize();
            n2 -= z80Instruction.getSize();
            arrayList.add(z80Instruction);
            if (bl && z80Instruction.isRet()) break;
        }
        return arrayList;
    }

    protected static UnmodifiableState unmodifiableState(State state) {
        if (state instanceof UnmodifiableState) {
            return (UnmodifiableState)state;
        }
        return new UnmodifiableState(state);
    }

    public static Z80Disassembler createInstance(boolean bl) {
        msx = bl;
        msxEntryPoints = null;
        if (instance == null) {
            instance = new Z80Disassembler();
            return instance;
        }
        if (!instance.getClass().equals(Z80Disassembler.class)) {
            Z80Disassembler.cleanUp();
            instance = null;
            return Z80Disassembler.createInstance(bl);
        }
        return instance;
    }

    private static Z80Disassembler getInstance() {
        if (instance == null) {
            return Z80Disassembler.createInstance(msx);
        }
        return instance;
    }

    private void loadConfig(int[] nArray, RamRomMap ramRomMap, File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    String[] stringArray;
                    int n = string.indexOf(59);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    if ((stringArray = (string = string.trim()).split("\\s+")).length > 0) {
                        int n2;
                        int n3;
                        if ("code".equalsIgnoreCase(stringArray[0])) {
                            if (stringArray.length > 1) {
                                int n4 = n3 = Integer.parseInt(stringArray[1], 16);
                                if (stringArray.length > 2) {
                                    n4 = Integer.parseInt(stringArray[2], 16);
                                }
                                n2 = n3;
                                Z80Instruction z80Instruction = this.getInstruction(nArray, n2);
                                while (n2 <= n4) {
                                    if (!Z80Disassembler.isCode(n2)) {
                                        State state = new State();
                                        if (n2 >= 32768) {
                                            state.setBank2(new Value(n2 / 16384));
                                        }
                                        this.analyze(nArray, ramRomMap, n2, n2, n2, state, new ArrayIntDeque());
                                    }
                                    z80Instruction = this.getInstruction(nArray, n2 += z80Instruction.getSize());
                                }
                            }
                        } else if ("jump".equalsIgnoreCase(stringArray[0]) || "jumptbl".equalsIgnoreCase(stringArray[0]) || "jumptable".equalsIgnoreCase(stringArray[0])) {
                            n3 = Integer.parseInt(stringArray[1], 16);
                            State state = new State();
                            if (n3 >= 32768) {
                                state.setBank2(new Value(n3 / 16384));
                            }
                            n2 = n3;
                            if (stringArray.length > 2) {
                                n2 += Integer.parseInt(stringArray[2]) * 2;
                            } else {
                                int n5 = 0;
                                while (n5 <= 255 && !Z80Disassembler.hasLabel(n2) && !Z80Disassembler.hasLabel(n2 + 1) && this.isROMaddress(Z80Disassembler.READ_WORD(nArray, n2), state)) {
                                    n2 += 2;
                                    n5 += 2;
                                }
                            }
                            int n6 = 0;
                            if (stringArray.length > 3) {
                                n6 = Integer.parseInt(stringArray[3], 16);
                            }
                            Z80Disassembler.addTable(jumpTables, n3, n2, Address.asUnknown(Value.newUnknownValue(nArray.length)), Z80Disassembler.toAddress(n6, ramRomMap, state), state);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            System.out.println("Configfile loaded: " + file.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void clearBinaries(final File file) {
        File[] fileArray = file.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file2) {
                return file2.getName().endsWith(".inc") && file2.getName().startsWith(file.getName().substring(0, file.getName().lastIndexOf(46)));
            }
        });
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                file2.delete();
                ++n2;
            }
        }
    }

    public static void writeToFile(int[] nArray, List<SourceLine> list, String string, util.map.Map<List<Symbols.Symbol>> map) {
        ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>(list);
        File file = new File(string);
        Z80Disassembler.clearBinaries(file);
        try {
            if (CREATE_LINK_FILE) {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(string.replace(".asm", ".link")))));
                printWriter.println("[objects]");
                printWriter.println(string.replace(".asm", ".o"));
                printWriter.close();
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int n = 0;
            String string2 = dialect.getIncBinLine(null);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                SourceLine sourceLine = (SourceLine)arrayList.get(n2);
                boolean bl = true;
                if (n < dataBlocks.size()) {
                    DataBlock dataBlock = dataBlocks.get(n);
                    if (sourceLine.getAddress() == dataBlock.start) {
                        if (sourceLine.toString().equals(string2)) {
                            bl = false;
                            Symbols.Symbol symbol = Symbols.findSymbol(dataBlock.start, map);
                            String string3 = symbol != null ? symbol.getLabel() : String.format(FORMAT_DATA_LABEL, dataBlock.start);
                            File file2 = new File(string.replace(".asm", String.valueOf(string3.replace("?", "")) + ".inc"));
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                            byte[] byArray = new byte[dataBlock.length];
                            int n3 = 0;
                            while (n3 < byArray.length) {
                                byArray[n3] = (byte)nArray[dataBlock.start + n3];
                                ++n3;
                            }
                            try {
                                bufferedOutputStream.write(byArray);
                                bufferedOutputStream.close();
                                printWriter.println(dialect.getIncBinLine(file2.getName()));
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        ++n;
                    } else if (sourceLine.getAddress() > dataBlock.start) {
                        ERROR_STREAM.println("Skipped datablock: " + dataBlock);
                        ++n;
                    }
                }
                if (bl) {
                    printWriter.println(sourceLine);
                }
                ++n2;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void cleanUp() {
        if (seen != null) {
            seen.clear();
        }
        seen = null;
        if (dataSeen != null) {
            dataSeen.clear();
        }
        dataSeen = null;
        if (ramSeen != null) {
            ramSeen.clear();
        }
        ramSeen = null;
        if (sramSeen != null) {
            sramSeen.clear();
        }
        sramSeen = null;
        if (portSeen != null) {
            portSeen.clear();
        }
        portSeen = null;
        if (path != null) {
            path.clear();
        }
        path = null;
        dataSeenPartial = null;
        ramSizes = null;
        sramSizes = null;
        ramCode = null;
        sramCode = null;
        if (tableEntrySeen != null) {
            tableEntrySeen.clear();
        }
        tableEntrySeen = null;
        labels = null;
        dataSeenExact = null;
        badCode = null;
        code = null;
        if (instructions != null) {
            instructions.clear();
        }
        instructions = null;
        instructionStart = null;
        indexMinValues = null;
        memoryJump = null;
        memoryTableRead = null;
        memoryTableReadRead = null;
        if (entriesOfTablePointToTables != null) {
            entriesOfTablePointToTables.clear();
        }
        entriesOfTablePointToTables = null;
        entriesOfTablePointToTablesOfPointerTables = null;
        if (entriesOfTablePointToTablesOfTablesOfPointerTables != null) {
            entriesOfTablePointToTablesOfTablesOfPointerTables.clear();
        }
        entriesOfTablePointToTablesOfTablesOfPointerTables = null;
        entriesOfTablePointToTablesOfJumpTables = null;
        entriesOfTablePointToJumpTables = null;
        if (memoryPointers != null) {
            memoryPointers.clear();
        }
        memoryPointers = null;
        if (memoryPointerStates != null) {
            memoryPointerStates.clear();
        }
        memoryPointerStates = null;
        if (memoryTables != null) {
            memoryTables.clear();
        }
        memoryTables = null;
        if (memoryJumps != null) {
            memoryJumps.clear();
        }
        memoryJumps = null;
        if (ramCodeWrites != null) {
            ramCodeWrites.clear();
        }
        ramCodeWrites = null;
        if (jumpTables != null) {
            jumpTables.clear();
        }
        jumpTables = null;
        if (pointerTables != null) {
            pointerTables.clear();
        }
        pointerTables = null;
        functionPointers = null;
        slots = null;
        if (bank0 != null) {
            bank0.clear();
        }
        bank0 = null;
        if (bank1 != null) {
            bank1.clear();
        }
        bank1 = null;
        if (bank2 != null) {
            bank2.clear();
        }
        bank2 = null;
        if (bank3 != null) {
            bank3.clear();
        }
        bank3 = null;
        sramEnabled = null;
        if (sramBank != null) {
            sramBank.clear();
        }
        sramBank = null;
        if (dataBlocks != null) {
            dataBlocks.clear();
        }
        dataBlocks = null;
        retAddresses = null;
        dummyCartridge = null;
        shouldReturn = null;
    }

    public static synchronized void abort() {
        abort = true;
    }

    public static List<SourceLine> analyze(int[] nArray, File file, boolean bl, util.map.Map<List<Symbols.Symbol>> map, util.map.Map<String> map2, AssemblerDialect assemblerDialect, SectionProvider sectionProvider, int n, int n2, boolean bl2, String string, String string2, String string3, String string4, String string5, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return Z80Disassembler.analyze(nArray, null, file, bl, map, map2, assemblerDialect, sectionProvider, n, n2, bl2, string, string2, string3, string4, string5, bl3, bl4, bl5, bl6);
    }

    public static List<SourceLine> analyze(int[] nArray, RamRomMap ramRomMap, File file, boolean bl, util.map.Map<List<Symbols.Symbol>> map, util.map.Map<String> map2, AssemblerDialect assemblerDialect, SectionProvider sectionProvider, int n, int n2, boolean bl2, String string, String string2, String string3, String string4, String string5, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        dialect = assemblerDialect;
        instance.analyze(nArray, ramRomMap, file, bl, bl6);
        try {
            List<SourceLine> list = Z80Disassembler.generateLines(nArray, ramRomMap, map, map2, assemblerDialect, sectionProvider, Integer.MAX_VALUE, n2, bl2, string, string2, string3, string4, string5, bl3, bl4, bl5);
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Arrays.asList(new SourceLine("An error occurred."));
        }
    }

    private static List<File> loadSDCCMapLinkedFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            boolean bl = false;
            String string = "";
            boolean bl2 = false;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                try {
                    if (bl2) {
                        string2 = String.valueOf(string) + string2;
                    }
                    if (!string2.isEmpty()) {
                        if (bl) {
                            if (string2.startsWith("Libraries Linked")) {
                                return arrayList;
                            }
                            bl2 = string2.indexOf(91) < 0;
                            int n = string2.indexOf(32);
                            if (n >= 0) {
                                arrayList.add(new File(string2.substring(0, n)));
                            }
                        } else if (string2.startsWith("Files Linked")) {
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = string2;
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static SourceMap getSourceMap() {
        return sourceMap;
    }

    public static boolean isSourceMapped(int n) {
        return sourceMap != null && sourceMap.getFileROM(n) != null;
    }

    public static int mapAddress(int n, int n2) {
        return dummyCartridge.mapAddress(n, n2);
    }

    public static boolean loadCDBfileIfAvailable(File file, File file2, Map<String, List<Symbols.Symbol>> map, int[] nArray) {
        if (sourceMap instanceof CDBSourceMap) {
            return false;
        }
        String string = file.getName();
        File file3 = new File(file.getParentFile(), String.valueOf(string.substring(0, string.lastIndexOf(46))) + ".cdb");
        if (!file3.exists()) {
            file3 = new File(new File(file3.getParentFile(), "build"), file3.getName());
        }
        if (!file3.exists()) {
            file3 = new File(file2.getParentFile(), String.valueOf(file2.getName().substring(0, file2.getName().lastIndexOf(46))) + ".cdb");
        }
        if (!file3.exists()) {
            return false;
        }
        try {
            List<Record> list = CDBParser.parse(file3);
            HashSet<String> hashSet = new HashSet<String>();
            sourceMap = new CDBSourceMap(file3.getParentFile(), list, map, dummyCartridge);
            boolean bl = false;
            BitSet bitSet = new BitSet();
            for (Record record : list) {
                int n;
                int n2;
                int n3;
                List<Symbols.Symbol> list2;
                Record record2;
                if (record instanceof FunctionRecord) {
                    hashSet.add(((FunctionRecord)record).getName());
                } else if (record instanceof SymbolRecord && ((SymbolRecord)(record2 = (SymbolRecord)record)).getTypeRecord().isFunction()) {
                    hashSet.add(((SymbolRecord)record2).getName());
                }
                if (record instanceof LinkerSymbolRecord) {
                    record2 = (LinkerSymbolRecord)record;
                    if (!hashSet.contains(((LinkerSymbolRecord)record2).getName())) continue;
                    list2 = map.get(String.valueOf(((LinkerSymbolRecord)record2).getScope()) + "$" + ((LinkerSymbolRecord)record2).getName() + "$" + ((LinkerSymbolRecord)record2).getLevel() + "$" + ((LinkerSymbolRecord)record2).getBlock());
                    if (list2 != null && !list2.isEmpty()) {
                        n3 = list2.get(0).getAddress();
                        n2 = list2.get(0).getBank();
                    } else {
                        n3 = ((LinkerSymbolRecord)record2).getAddress() & 0xFFFF;
                        n2 = ((LinkerSymbolRecord)record2).getAddress() / 65536;
                    }
                    if (!Z80Disassembler.setCode(nArray, defaultRamRomMap, n3, n2)) continue;
                    n = dummyCartridge.mapAddress(n3, n2);
                    Z80Disassembler.addLabel(n);
                    bl = true;
                    continue;
                }
                if (record instanceof LinkerCRecord) {
                    record2 = (LinkerCRecord)record;
                    list2 = map.get("C$" + ((LinkerCRecord)record2).getFilename() + "$" + ((LinkerCRecord)record2).getLineNumber() + "$" + ((LinkerCRecord)record2).getLevel() + "$" + ((LinkerCRecord)record2).getBlock());
                    if (list2 != null && !list2.isEmpty()) {
                        n3 = list2.get(0).getAddress();
                        n2 = list2.get(0).getBank();
                    } else {
                        n3 = ((LinkerCRecord)record2).getEndAddress() & 0xFFFF;
                        n2 = ((LinkerCRecord)record2).getEndAddress() / 65536;
                    }
                    n = dummyCartridge.mapAddress(n3, n2);
                    if (Z80Disassembler.isCode(n) || !Z80Disassembler.setCode(nArray, defaultRamRomMap, n3, n2)) continue;
                    bl = true;
                    continue;
                }
                if (!(record instanceof LinkerAsmRecord)) continue;
                record2 = (LinkerAsmRecord)record;
                list2 = map.get("A$" + ((LinkerAsmRecord)record2).getFilename() + "$" + ((LinkerAsmRecord)record2).getLineNumber());
                if (list2 != null && !list2.isEmpty()) {
                    n3 = list2.get(0).getAddress();
                    n2 = list2.get(0).getBank();
                } else {
                    n3 = ((LinkerAsmRecord)record2).getEndAddress() & 0xFFFF;
                    n2 = ((LinkerAsmRecord)record2).getEndAddress() / 65536;
                }
                n = dummyCartridge.mapAddress(n3, n2);
                if (Z80Disassembler.isCode(n) || !Z80Disassembler.setCode(nArray, defaultRamRomMap, n3, n2)) continue;
                bl = true;
            }
            if (bl) {
                labels.or(bitSet);
                Z80Disassembler.removeCodeFromDataSeen();
                instance.analyzeTables(nArray, defaultRamRomMap);
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static EvscriptDebugInfo loadEvscriptDebugInfo(File file, Map<String, List<Symbols.Symbol>> map, DebuggableSystem debuggableSystem, File file2) {
        try {
            EvscriptDebugInfo evscriptDebugInfo = EvscriptDebugInfo.parse(file);
            sourceMap = new EvscriptSourceMap(evscriptDebugInfo, sourceMap, map, debuggableSystem, file2);
            return evscriptDebugInfo;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private static SourceMap createCSourceMap(File file, List<SourceLine> list) {
        DisassemblerCSourceMap disassemblerCSourceMap = new DisassemblerCSourceMap(file);
        String string = null;
        int n = -1;
        for (SourceLine sourceLine : list) {
            if (sourceLine.getAddress() >= 0) {
                if (string == null) continue;
                disassemblerCSourceMap.addMapping(sourceLine.getAddress(), string, n - 1);
                string = null;
                n = -1;
                continue;
            }
            String string2 = sourceLine.toString();
            int n2 = Math.max(string2.indexOf(".c:"), string2.indexOf(".h:"));
            if (n2 < 0) continue;
            int n3 = n2;
            while (n3 > 0 && string2.charAt(n3 - 1) > ' ' && string2.charAt(n3 - 1) != ';') {
                --n3;
            }
            File file2 = new File(string2.substring(n3, n2 + 2));
            String string3 = string2.substring(n2 + ".c:".length());
            int n4 = string3.indexOf(58);
            n = Integer.parseInt(string3.substring(0, n4));
            string = file2.getPath();
        }
        return disassemblerCSourceMap.isValid() ? disassemblerCSourceMap : null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SourceLine> readLines(File file, int[] nArray, Map<String, List<Symbols.Symbol>> map, util.map.Map<List<Symbols.Symbol>> map2, SectionProvider sectionProvider, ExpressionEvaluator expressionEvaluator) throws IOException {
        ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>();
        if (file.getName().toLowerCase().endsWith(".lst")) {
            Z80Assembler z80Assembler = new Z80Assembler(expressionEvaluator){
                final Pattern pattern = Pattern.compile("\"([^\"])\"");

                @Override
                public Z80Instruction assemble(String string) throws ParseException {
                    return super.assemble(this.pattern.matcher(string).replaceAll("'$1'").replace("'''", "$27").replace("low ", "<").replace("high ", ">").replace('[', '(').replace(']', ')'));
                }
            };
            map2.clear();
            Symbols.loadLSTSymbols(file, map2);
            map.clear();
            Symbols.getSymbolsByName(map2, map);
            SjasmParser.ParseResult parseResult = SjasmParser.readLines(file, z80Assembler, expressionEvaluator);
            if (ERROR_STREAM != NIRVANA) {
                for (Exception object2 : parseResult.getExceptions()) {
                    object2.printStackTrace(ERROR_STREAM);
                }
            }
            Z80Disassembler.readSjasmLines(arrayList, nArray, new BitSet(), parseResult, map, map2);
            DisassemblerSourceMap file2 = new DisassemblerSourceMap(nArray.length);
            List<Z80SourceLine> list = parseResult.getLines();
            int n = Math.min(arrayList.size(), list.size());
            int n2 = 0;
            while (n2 < n) {
                SourceLine sourceLine = (SourceLine)arrayList.get(n2);
                Z80SourceLine z80SourceLine = (Z80SourceLine)list.get(n2);
                file2.addMapping(z80SourceLine, sourceLine);
                ++n2;
            }
            sourceMap = file2;
        } else if (file.getName().toLowerCase().endsWith(".map")) {
            final Pattern pattern = Pattern.compile("#(\\d+)");
            Z80Assembler z80Assembler = instance instanceof LR35902Disassembler ? new LR35902Assembler(expressionEvaluator){
                final Pattern ldHLpattern;
                {
                    super(expressionEvaluator);
                    this.ldHLpattern = Pattern.compile("ldhl\\s+sp,\\s*(.*)|lda\\s+HL,\\s*(\\d+)\\(SP\\)");
                }

                @Override
                public Z80Instruction assemble(String string) throws ParseException {
                    return super.assemble(pattern.matcher(this.ldHLpattern.matcher(string.replace("#0x", "$")).replaceAll("ld hl, sp+$1$2")).replaceAll("$1"));
                }
            } : new Z80Assembler(expressionEvaluator){
                final Pattern ixIYpattern = Pattern.compile("(-?\\d+) \\((ix|iy)\\)");

                @Override
                public Z80Instruction assemble(String string) throws ParseException {
                    return super.assemble(this.ixIYpattern.matcher(string.replace("#0x", "$")).replaceAll("\\($2+$1\\)"));
                }
            };
            Object object3 = null;
            for (File file3 : Z80Disassembler.loadSDCCMapLinkedFiles(file)) {
                String string;
                Object object;
                File file2;
                if (file3.isAbsolute() && file3.getParentFile() != null && !file3.getParentFile().exists()) {
                    void var9_19;
                    if (var9_19 == null || !file3.getParentFile().getName().equals(var9_19.getName())) {
                        Object var9_20 = null;
                        File file4 = file.getParentFile();
                        while (file4 != null) {
                            void var9_21;
                            file2 = file3.getParentFile();
                            object = new File("");
                            while (file2 != null) {
                                object = new File(file2.getName(), ((File)object).getPath());
                                File file5 = new File(file4, ((File)object).getPath());
                                if (file5.exists()) {
                                    File file6 = file5;
                                    break;
                                }
                                file2 = file2.getParentFile();
                            }
                            if (var9_21 != null) break;
                            file4 = file4.getParentFile();
                        }
                    }
                    string = var9_19 != null ? new File((File)var9_19, file3.getName()).getPath() : file3.getPath();
                } else {
                    string = file3.getPath();
                }
                int n = string.lastIndexOf(46);
                if (n < 0) continue;
                file2 = new File(String.valueOf(string.substring(0, n)) + ".asm");
                if (!file2.exists()) {
                    file2 = new File(String.valueOf(string.substring(0, n)) + ".s");
                }
                if (!file3.isAbsolute()) {
                    if (!file2.exists()) {
                        file2 = new File(file.getParentFile(), String.valueOf(string.substring(0, n)) + ".asm");
                    }
                    if (!file2.exists() && file.getParentFile() != null) {
                        file2 = new File(file.getParentFile().getParentFile(), String.valueOf(string.substring(0, n)) + ".asm");
                    }
                    if (!file2.exists() && file.getParentFile().getParentFile() != null) {
                        file2 = new File(file.getParentFile().getParentFile().getParentFile(), String.valueOf(string.substring(0, n)) + ".asm");
                    }
                    if (!file2.exists()) {
                        if (!file2.exists()) {
                            file2 = new File(file.getParentFile(), String.valueOf(string.substring(0, n)) + ".s");
                        }
                        if (!file2.exists() && file.getParentFile() != null) {
                            file2 = new File(file.getParentFile().getParentFile(), String.valueOf(string.substring(0, n)) + ".s");
                        }
                        if (!file2.exists() && file.getParentFile().getParentFile() != null) {
                            file2 = new File(file.getParentFile().getParentFile().getParentFile(), String.valueOf(string.substring(0, n)) + ".s");
                        }
                    }
                }
                if (!file2.exists()) continue;
                object = WLAParser.readLines(file2, z80Assembler, expressionEvaluator);
                if (ERROR_STREAM != NIRVANA) {
                    for (Exception exception : ((WLAParser.ParseResult)object).getExceptions()) {
                        exception.printStackTrace(ERROR_STREAM);
                    }
                }
                Z80Disassembler.readLines(-1, new ParsingState(arrayList, nArray, map, sectionProvider, (Z80ParseResult)object, true));
            }
            if (sourceMap == null) {
                sourceMap = Z80Disassembler.createCSourceMap(file.getParentFile(), arrayList);
            }
        } else {
            Z80ParseResult z80ParseResult;
            Z80Assembler z80Assembler = instance instanceof LR35902Disassembler ? new LR35902Assembler(expressionEvaluator){

                @Override
                public Z80Instruction assemble(String string) throws ParseException {
                    return super.assemble(string.replace('[', '(').replace(']', ')'));
                }
            } : new Z80Assembler(expressionEvaluator){

                @Override
                public Z80Instruction assemble(String string) throws ParseException {
                    return super.assemble(string.replace('[', '(').replace(']', ')').replace("$-", "-"));
                }
            };
            Z80ParseResult z80ParseResult2 = z80ParseResult = instance instanceof LR35902Disassembler ? GBParserMultiplexer.readLines(file, z80Assembler, expressionEvaluator) : WLAParser.readLines(file, z80Assembler, expressionEvaluator);
            if (ERROR_STREAM != NIRVANA) {
                for (Exception exception : z80ParseResult.getExceptions()) {
                    exception.printStackTrace(ERROR_STREAM);
                }
            }
            ParsingState parsingState = new ParsingState(arrayList, nArray, map, sectionProvider, z80ParseResult, false);
            Z80Disassembler.readLines(-1, parsingState);
            try {
                parsingState.mapEmptySections();
                parsingState.mapFreeSections();
                parsingState.mapSuperFreeSections();
            }
            catch (IllegalStateException illegalStateException) {}
            sourceMap = parsingState.createSourceMap();
            parsingState.resolveUndeterminedRepts();
            Z80Disassembler.adjustSymbols(map2, z80ParseResult.getROMBankMap(), z80ParseResult.getMemoryMap());
        }
        Z80Disassembler.removeCodeFromDataSeen();
        instance.analyzeTables(nArray, defaultRamRomMap);
        return arrayList;
    }

    private static void adjustSymbols(util.map.Map<List<Symbols.Symbol>> map, ROMBankMap rOMBankMap, MemoryMap memoryMap) {
        if (rOMBankMap == null) {
            return;
        }
        if (memoryMap == null) {
            memoryMap = new NoMemoryMap();
        }
        int[] nArray = map.keySet();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            List<Symbols.Symbol> list = map.get(n3);
            Symbols.Symbol symbol = list.get(0);
            if (instance.isROMaddress(symbol.getAddress(), false)) {
                try {
                    int n4 = memoryMap.findSlotForAddress(symbol.getAddress());
                    int n5 = rOMBankMap.resolveAddress(symbol.getBank(), memoryMap.resolveAddress(n4, symbol.getAddress()));
                    if (n5 != n3) {
                        map.remove(n3);
                        map.put(n5, list);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            ++n2;
        }
    }

    private static void adjustMsxDiskSymbol(String string, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map, Map<String, List<Symbols.Symbol>> map2) {
        if (ramRomMap == null) {
            return;
        }
        try {
            Symbols.Symbol symbol;
            int n;
            List<Symbols.Symbol> list = map2.get(string);
            if (list != null && (n = ramRomMap.toRomAddress(instance.mapRAMaddress((symbol = list.get(0)).getAddress()))) != Integer.MIN_VALUE && n != symbol.getAddress()) {
                Symbols.Symbol symbol2 = new Symbols.Symbol(-1, n, symbol.getLabel(), symbol.getComment());
                list.set(0, symbol2);
                List<Symbols.Symbol> list2 = map.get(instance.isROMaddress(symbol.getAddress(), false) ? symbol.getBank() * 16384 | symbol.getAddress() & 0x3FFF : symbol.getAddress());
                list2.set(list2.indexOf(symbol), symbol2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    /*
     * Unable to fully structure code
     */
    private static void readSjasmLines(List<SourceLine> var0, int[] var1_1, BitSet var2_2, SjasmParser.ParseResult var3_3, Map<String, List<Symbols.Symbol>> var4_4, util.map.Map<List<Symbols.Symbol>> var5_5) {
        var6_6 = null;
        var7_7 = null;
        var8_8 = new int[1];
        var9_9 = new BitSet();
        var10_10 = false;
        var11_11 = 256;
        var12_12 = var3_3.getLines();
        var13_13 = 0;
        while (var13_13 < var12_12.size()) {
            block23: {
                block24: {
                    block25: {
                        block26: {
                            block22: {
                                var14_14 = var12_12.get(var13_13);
                                if (var14_14.getSize() >= 0) break block22;
                                var0.add(new SourceLine(var14_14.toString()));
                                break block23;
                            }
                            var15_15 = var14_14.toString();
                            do {
                                var16_16 = (var15_15.indexOf(34) & 0x7FFFFFFF) > var15_15.indexOf(58) ? var15_15.indexOf(58) : -1;
                                v0 = var17_17 = var16_16 > 0 && Character.isJavaIdentifierPart(var15_15.charAt(var16_16 - 1)) != false ? var15_15.substring(0, var16_16) : "";
                                if (var17_17.isEmpty()) break;
                                var18_18 = var16_16;
                                var18_18 = Math.max(var18_18, var17_17.length());
                                var7_7 = var17_17;
                                while (var18_18 < var15_15.length() && ": \t".indexOf(var15_15.charAt(var18_18)) >= 0) {
                                    ++var18_18;
                                }
                            } while ((var15_15 = var15_15.substring(var18_18)).indexOf(58) > 0 && Character.isJavaIdentifierPart(var15_15.charAt(var15_15.indexOf(58) - 1)));
                            if (var15_15.trim().toLowerCase().startsWith("org")) {
                                var10_10 = true;
                            }
                            if (var14_14.getSize() <= 0) break block24;
                            var16_16 = var14_14.getAddress();
                            if (Z80Disassembler.msx && Z80Disassembler.dummyCartridge instanceof MSXDisk) {
                                if (var6_6 == null) {
                                    var17_17 = new MemoryFAT(12, var1_1);
                                    try {
                                        for (final filesystem.File var18_19 : var17_17.listFiles()) {
                                            if (var18_19.getSize() <= 0 || !var14_14.startsWith(var1_1, var18_19.mapAddress(0)) || !(var20_24 = var12_12.get(var13_13 + 1)).startsWith(var1_1, var18_19.mapAddress(var14_14.getSize()))) continue;
                                            var6_6 = new RamRomMap(){

                                                @Override
                                                public int toRomAddress(int n) {
                                                    if (n < 16384 || n >= 49152 && n < 49408) {
                                                        return Integer.MIN_VALUE;
                                                    }
                                                    try {
                                                        return var18_19.mapAddress(var8_8[0] + instance.mapRAMaddress(n) - 256);
                                                    }
                                                    catch (IOException iOException) {
                                                        iOException.printStackTrace();
                                                        return Integer.MIN_VALUE;
                                                    }
                                                }

                                                @Override
                                                public int toRamAddress(int n) {
                                                    throw new UnsupportedOperationException();
                                                }
                                            };
                                            break;
                                        }
                                    }
                                    catch (IOException var18_20) {
                                        var18_20.printStackTrace();
                                    }
                                }
                                if (var6_6 == null) {
                                    var0.clear();
                                    var0.add(new SourceLine("; Failed to locate corresponding file in dsk image."));
                                    return;
                                }
                                if (var10_10) {
                                    var8_8[0] = var8_8[0] + (var11_11 - var14_14.getAddress());
                                    var10_10 = false;
                                }
                                if (var7_7 != null) {
                                    Z80Disassembler.adjustMsxDiskSymbol(var7_7, var6_6, var5_5, var4_4);
                                }
                                var16_16 = var6_6.toRomAddress(Z80Disassembler.instance.mapRAMaddress(var14_14.getAddress()));
                            } else {
                                var6_6 = Z80Disassembler.defaultRamRomMap;
                            }
                            if (var16_16 < 0 || var2_2.get(var16_16)) break block24;
                            var11_11 = var14_14.getAddress() + var14_14.getSize();
                            if (var7_7 != null) {
                                Z80Disassembler.addLabel(var16_16);
                            } else {
                                Z80Disassembler.removeLabel(var16_16);
                            }
                            var7_7 = null;
                            var17_17 = Z80Disassembler.getInstruction(var16_16);
                            var18_21 = var14_14.getInstruction();
                            if (var18_21 == null) break block25;
                            if (var17_17 == null) {
                                try {
                                    Z80Disassembler.forceSetInstruction(var16_16, var18_21, var1_1, var6_6);
                                    var17_17 = Z80Disassembler.getInstruction(var16_16);
                                }
                                catch (Exception var19_23) {
                                    var19_23.printStackTrace();
                                }
                            }
                            if (var17_17 != null && var14_14.startsWith(var1_1, var16_16)) break block26;
                            Z80Disassembler.ERROR_STREAM.println("Mismatched instruction at " + Integer.toHexString(var16_16) + " in " + var14_14 + ": " + var17_17 + " != " + var18_21);
                            var0.add(new SourceLine(var14_14.toString()));
                            break block23;
                        }
                        var0.add(new SourceLine(var16_16, var14_14.toString(), (Z80Instruction)var17_17));
                        ** GOTO lbl92
                    }
                    Z80Disassembler.forceSetData(var16_16, var14_14.getSize(), var6_6);
                    if (!var14_14.startsWith(var1_1, var16_16)) {
                        Z80Disassembler.ERROR_STREAM.println("Mismatched byte at " + Integer.toHexString(var16_16) + " in " + var14_14 + ": " + (var16_16 < var1_1.length ? Integer.toHexString(var1_1[var16_16]) : "EOF") + " != " + Integer.toHexString(var14_14.getFirstByte()));
                        var0.add(new SourceLine(var14_14.toString()));
                    } else {
                        var0.add(new SourceLine(var16_16, var14_14.getSize(), var14_14.toString()));
lbl92:
                        // 2 sources

                        var2_2.set(var16_16, var16_16 + var14_14.getSize());
                    }
                    break block23;
                }
                var0.add(new SourceLine(var14_14.toString()));
            }
            ++var13_13;
        }
        var13_13 = var9_9.nextSetBit(0);
        while (var13_13 >= 0) {
            Z80Disassembler.addLabel(var13_13);
            var13_13 = var9_9.nextSetBit(var13_13 + 1);
        }
        var8_8[0] = 0;
    }

    private static void readLines(int n, ParsingState parsingState) {
        List<Z80SourceLine> list = parsingState.parseResult.getLines();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            n = Z80Disassembler.readLine(parsingState, list.get(n3), n, n3);
            if (list.size() != n2 || !parsingState.sdcc && n3 + 1 != parsingState.lines.size()) {
                throw new ConcurrentModificationException();
            }
            ++n3;
        }
        n3 = parsingState.labels.nextSetBit(0);
        while (n3 >= 0) {
            Z80Disassembler.addLabel(n3);
            n3 = parsingState.labels.nextSetBit(n3 + 1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private static int readLine(ParsingState parsingState, Z80SourceLine z80SourceLine, int n, int n2) {
        String string;
        RamRomMap ramRomMap = defaultRamRomMap;
        List<SourceLine> list = parsingState.lines;
        Map<String, List<Symbols.Symbol>> map = parsingState.symbols;
        SectionProvider sectionProvider = parsingState.sectionProvider;
        ROMBankMap rOMBankMap = parsingState.romBankMap;
        MemoryMap memoryMap = parsingState.memoryMap;
        BitSet bitSet = parsingState.labels;
        BitSet bitSet2 = parsingState.mapped;
        int[] nArray = parsingState.memory;
        Z80ParseResult z80ParseResult = parsingState.parseResult;
        List<Z80SourceLine> list2 = z80ParseResult.getLines();
        boolean bl = parsingState.sdcc;
        char c = z80ParseResult.getDialect().getChildLabelChar();
        if (z80SourceLine.getSize() < 0) {
            list.add(new SourceLine(z80SourceLine.toString()));
            return n;
        }
        if (z80SourceLine.getSize() == 0 && z80SourceLine.getLineNumber() == -1 && (string = z80SourceLine.toString()).startsWith(";* BEGINNING OF ")) {
            parsingState.indexPrevParsedLineWithSize = -1;
            parsingState.sectionEnd = Integer.MAX_VALUE;
            parsingState.prevLabel = null;
            n = -1;
        }
        string = z80SourceLine.toString();
        try {
            String[] stringArray;
            Object object;
            int n3;
            int n4;
            int n5;
            int n6 = (string.indexOf(34) & Integer.MAX_VALUE) < string.indexOf(59) ? string.indexOf(59, string.lastIndexOf(34) + 1) : string.indexOf(59);
            String string2 = (n6 >= 0 ? string.substring(0, n6) : string).trim();
            if (string2.isEmpty()) {
                list.add(new SourceLine(string));
                return n;
            }
            if (string2.charAt(0) == '.' && string2.length() > 1 && Character.toUpperCase(string2.charAt(1)) == 'D' && string2.toUpperCase().startsWith(".DSTRUCT")) {
                string2 = string2.split("\\s+")[1];
                parsingState.withinDstruct = true;
            }
            if (!(parsingState.sdccDataArea || string2.charAt(0) == '.' && string2.charAt(0) != c)) {
                int n7;
                if (Z80Disassembler.hasLabel(n) && !parsingState.prevWasLabel) {
                    Z80Disassembler.removeLabel(n);
                }
                int n8 = n5 = string2.charAt(0) == c ? 1 : 0;
                if (n5 != 0) {
                    string2 = parsingState.resolveChildLabel(string2);
                }
                int n9 = n4 = n < 0 ? 1 : 0;
                do {
                    List<Symbols.Symbol> list3;
                    void var24_38;
                    CharSequence charSequence;
                    if (bl && string2.charAt(string2.length() - 1) == '.' && string2.length() > 3 && (string2.charAt(string2.length() - 2) == '=' || string2.charAt(string2.length() - 2) == ' ' && string2.charAt(string2.length() - 3) == '=')) {
                        int n10 = string2.indexOf(61);
                        String string3 = string2.substring(0, n10).trim();
                        charSequence = string3;
                        n3 = string3.length();
                    } else {
                        charSequence = WLAParser.parseLabel(string2);
                        n3 = string2.length() > charSequence.length() && string2.charAt(charSequence.length()) == ':' ? charSequence.length() : -1;
                        String string4 = (n3 > 0 && Character.isJavaIdentifierPart(string2.charAt(n3 - 1)) || charSequence.length() > 0 && "+-".indexOf(charSequence.charAt(0)) >= 0 ? charSequence : "").toString();
                    }
                    object = var24_38.isEmpty() && string2.indexOf(32) < 0 ? map.get(string2) : ((list3 = map.get(charSequence)) != null ? list3 : map.get(bl && var24_38.length() > 32 && !map.containsKey(var24_38) ? var24_38.substring(0, 32) : var24_38));
                    if (object == null && var24_38.isEmpty()) break;
                    if (n5 == 0) {
                        parsingState.setPrevLabel((String)(var24_38.isEmpty() ? string2 : var24_38));
                    } else {
                        parsingState.pushChildLabel((String)(var24_38.isEmpty() ? string2 : var24_38));
                    }
                    parsingState.lastAmbiguousLabel = object != null && object.size() > 1 ? (var24_38.isEmpty() ? string2 : var24_38) : null;
                    list3 = object != null && object.size() == 1 ? object.get(0) : null;
                    n7 = n3;
                    parsingState.addrBeforeChangeByLabel = -1;
                    if (list3 != null) {
                        if (rOMBankMap != null && (bl || !parsingState.sectionDiscarded || ((Symbols.Symbol)((Object)list3)).getLabel().charAt(0) != '_')) {
                            if (instance.isROMaddress(((Symbols.Symbol)((Object)list3)).getAddress(), false)) {
                                parsingState.addrBeforeChangeByLabel = n;
                                n = rOMBankMap.resolveAddress(((Symbols.Symbol)((Object)list3)).getBank(), memoryMap.resolveAddress(parsingState.slot, ((Symbols.Symbol)((Object)list3)).getAddress()));
                                if (n < 0 || n5 != 0 && bitSet2.get(n)) {
                                    n = parsingState.addrBeforeChangeByLabel;
                                }
                                if (parsingState.addrBeforeChangeByLabel > 1 && parsingState.addrBeforeChangeByLabel < nArray.length && nArray[parsingState.addrBeforeChangeByLabel] == 0 && (nArray[parsingState.addrBeforeChangeByLabel - 1] == 118 || nArray[parsingState.addrBeforeChangeByLabel - 1] == 16)) {
                                    n = parsingState.addrBeforeChangeByLabel;
                                    parsingState.addrBeforeChangeByLabel = -1;
                                }
                                if (n >= parsingState.sectionEnd) {
                                    parsingState.sectionEnd = Integer.MAX_VALUE;
                                }
                            } else if (z80SourceLine.getSize() <= 0) {
                                n = -1;
                            }
                            parsingState.sectionDiscarded = false;
                        }
                        bitSet.clear();
                        n7 = Math.max(n7, ((Symbols.Symbol)((Object)list3)).getLabel().length());
                    } else {
                        n7 = Math.max(n7, var24_38.length());
                    }
                    if (n >= 0) {
                        Z80Disassembler.addLabel(n);
                        parsingState.prevWasLabel = true;
                    }
                    while (n7 < string2.length() && ": \t".indexOf(string2.charAt(n7)) >= 0) {
                        ++n7;
                    }
                } while ((string2 = string2.substring(n7)).indexOf(58) > 0 && (Character.isJavaIdentifierPart(string2.charAt(string2.indexOf(58) - 1)) || "+-".indexOf(string2.charAt(string2.indexOf(58) - 1)) >= 0));
                if (!(bl || parsingState.beginningOfSection || n < 0 || n4 == 0 && !parsingState.prevWasMismatched || bitSet2.get(n))) {
                    int n11 = n;
                    n3 = parsingState.indexPrevParsedLineWithSize;
                    while (n3 >= 0) {
                        Z80SourceLine z80SourceLine2 = list2.get(n3);
                        if (z80SourceLine2.getSize() > 0) {
                            object = list.get(n3);
                            if (((SourceLine)object).getAddress() >= 0 || (n11 -= z80SourceLine2.getSize()) < 0 || bitSet2.get(n11, n11 + z80SourceLine2.getSize()).cardinality() > 0 || !z80SourceLine2.startsWith(nArray, n11)) break;
                            if (z80SourceLine2.getInstruction() != null) {
                                Z80Disassembler.forceSetInstruction(n11, z80SourceLine2.getInstruction(), nArray, ramRomMap);
                            } else if (Z80Disassembler.isCode(n11)) {
                                Z80Disassembler.forceSetData(n11, z80SourceLine2.getSize(), ramRomMap);
                            }
                            list.set(n3, new SourceLine(n11, z80SourceLine2.getSize(), ((SourceLine)object).toString(), Z80Disassembler.getInstruction(n11)));
                            bitSet2.set(n11, n11 + z80SourceLine2.getSize());
                        } else if (z80SourceLine2.getSize() == 0) {
                            object = z80SourceLine2.toString();
                            int n12 = ((String)object).length();
                            n7 = 0;
                            while (n7 < n12 && ((String)object).charAt(n7) <= ' ') {
                                ++n7;
                            }
                            if (n12 > n7 + 2) {
                                String string5;
                                char c2 = ((String)object).charAt(n7);
                                char c3 = ((String)object).charAt(n7 + 1);
                                if ((c2 == '.' || c2 == ';' && c3 == '*' || c2 == 'S' || c2 == 's') && ((string5 = ((String)object).substring(n7).toUpperCase()).startsWith(".SECTION") || string5.startsWith(".ORG") || string5.startsWith(".BANK") || string5.startsWith("SECTION") || string5.startsWith(";* BEGINNING OF "))) break;
                            }
                        }
                        --n3;
                    }
                }
                if (string2.isEmpty()) {
                    list.add(new SourceLine(string));
                    return n;
                }
                if (z80SourceLine.getSize() > 0 && n >= nArray.length) {
                    ERROR_STREAM.println("Mismatched line exceeded memory: " + string);
                    list.add(new SourceLine(string));
                    return n;
                }
            }
            parsingState.prevWasLabel = false;
            if (!parsingState.sdccDataArea && z80SourceLine.getSize() > 0) {
                if (n >= parsingState.sectionEnd) {
                    n = -1;
                }
                if (n >= 0 && parsingState.addrBeforeChangeByLabel > n && Z80Disassembler.getRomBank(parsingState.addrBeforeChangeByLabel) == Z80Disassembler.getRomBank(n) && bitSet2.get(n) && !z80SourceLine.startsWith(nArray, parsingState.addrBeforeChangeByLabel) && z80SourceLine.startsWith(nArray, n)) {
                    n5 = n2 - 1;
                    while (n5 >= 0) {
                        SourceLine sourceLine = list.get(n5);
                        if (sourceLine.getSize() > 0 && parsingState.addrBeforeChangeByLabel >= sourceLine.getAddress() && sourceLine.getAddress() + sourceLine.getSize() >= n) {
                            int n13;
                            int n14 = n13 = sourceLine.getInstruction() == null ? n - sourceLine.getAddress() : 0;
                            if (n13 > 0 && n13 < sourceLine.getSize()) {
                                n3 = n2 - 1;
                                while (n3 > n5) {
                                    if (list.get(n3).getSize() > 0) {
                                        list.set(n3, new SourceLine(sourceLine.toString()));
                                        bitSet2.clear(sourceLine.getAddress(), sourceLine.getAddress() + sourceLine.getSize());
                                    }
                                    --n3;
                                }
                                list.set(n5, new SourceLine(sourceLine.getAddress(), n13, sourceLine.toString()));
                                bitSet2.clear(n, sourceLine.getAddress() + sourceLine.getSize());
                                bitSet2.set(sourceLine.getAddress(), sourceLine.getAddress() + sourceLine.getSize());
                                break;
                            }
                        }
                        --n5;
                    }
                }
                parsingState.indexPrevParsedLineWithSize = n2;
                n5 = parsingState.addrBeforeChangeByLabel;
                parsingState.addrBeforeChangeByLabel = -1;
                if (n < 0 && parsingState.lastAmbiguousLabel != null && z80SourceLine.getInstruction() != null && rOMBankMap != null) {
                    String string6 = parsingState.lastAmbiguousLabel;
                    int n15 = 0;
                    n3 = 0;
                    for (Symbols.Symbol symbol : map.get(bl && string6.length() > 32 ? string6.substring(0, 32) : string6)) {
                        int n16 = rOMBankMap.resolveAddress(symbol.getBank(), memoryMap.resolveAddress(parsingState.slot, symbol.getAddress()));
                        if (!z80SourceLine.startsWith(nArray, n16)) continue;
                        n3 = n16;
                        ++n15;
                    }
                    if (n15 == 1) {
                        n = n3;
                    }
                    parsingState.lastAmbiguousLabel = null;
                }
                if (n >= 0 && bitSet2.get(n, n + z80SourceLine.getSize()).cardinality() == 0) {
                    if (parsingState.beginningOfSection && parsingState.sectionName != null) {
                        parsingState.sectionMapped.add(parsingState.sectionName);
                    }
                    parsingState.beginningOfSection = false;
                    Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n);
                    Z80Instruction z80Instruction2 = z80SourceLine.getInstruction();
                    if (z80Instruction2 != null) {
                        if (z80Instruction == null) {
                            Z80Disassembler.forceSetInstruction(n, z80Instruction2, nArray, ramRomMap);
                            z80Instruction = Z80Disassembler.getInstruction(n);
                        }
                        if (!(z80Instruction != null && z80Instruction.getOpCode() == z80Instruction2.getOpCode() || z80Instruction != null && (z80Instruction.getOpCode() & 0xFFC7) == 199 && z80Instruction2.getOpCode() == 199)) {
                            if (instance instanceof LR35902Disassembler && z80Instruction != null) {
                                if (z80Instruction2.getOpCode() == 250 && z80Instruction.getOpCode() == 240 || z80Instruction2.getOpCode() == 234 && z80Instruction.getOpCode() == 224) {
                                    list.add(new SourceLine(n, z80SourceLine.toString(), z80Instruction));
                                    bitSet2.set(n, n + z80Instruction.getSize());
                                    parsingState.prevWasMismatched = false;
                                    return n + z80Instruction.getSize();
                                }
                                if (z80Instruction.getOpCode() == 0) {
                                    Z80Instruction z80Instruction3 = Z80Disassembler.getInstruction(n - 1);
                                    if (z80Instruction3 != null && z80Instruction3.getOpCode() == 0) {
                                        z80Instruction3 = Z80Disassembler.getInstruction(n - 2);
                                    }
                                    if (z80Instruction3 != null && (z80Instruction3.getOpCode() == 16 || z80Instruction3.getOpCode() == 118)) {
                                        void var24_46;
                                        int n17 = list.size() - 1;
                                        while (var24_46 >= 0 && (list.get((int)var24_46).getInstruction() == null || list.get((int)var24_46).getInstruction().getOpCode() == 0)) {
                                            --var24_46;
                                        }
                                        object = list.get((int)var24_46);
                                        if (((SourceLine)object).getInstruction().getOpCode() == 16 || ((SourceLine)object).getInstruction().getOpCode() == 118) {
                                            list.set((int)var24_46, new SourceLine(((SourceLine)object).getAddress(), ((SourceLine)object).getSize() + z80Instruction.getSize(), ((SourceLine)object).toString(), ((SourceLine)object).getInstruction()));
                                            void var26_56 = var24_46 + true;
                                            while (var26_56 < list.size()) {
                                                SourceLine sourceLine = list.get((int)var26_56);
                                                if (sourceLine.getSize() > 0) {
                                                    list.set((int)var26_56, new SourceLine(sourceLine.getAddress() + z80Instruction.getSize(), sourceLine.getSize(), sourceLine.toString(), sourceLine.getInstruction()));
                                                }
                                                ++var26_56;
                                            }
                                            bitSet2.set(n);
                                            parsingState.prevWasMismatched = false;
                                            if (z80Instruction3.getOpCode() == 118) {
                                                parsingState.autoNopAfterHalt = true;
                                            }
                                            return Z80Disassembler.readLine(parsingState, z80SourceLine, n + z80Instruction.getSize(), n2);
                                        }
                                    }
                                }
                            }
                            if (n5 >= 0 && !bitSet2.get(n5) && Z80Disassembler.getInstruction(n5) != null && Z80Disassembler.getInstruction(n5).getOpCode() == z80Instruction2.getOpCode()) {
                                n = n5;
                                z80Instruction = Z80Disassembler.getInstruction(n);
                            } else {
                                ERROR_STREAM.println("Mismatched instruction at " + Integer.toHexString(n) + " in " + z80SourceLine + ": " + z80Instruction + " != " + z80Instruction2);
                                if (parsingState.prevWasMismatched) {
                                    parsingState.prevWasMismatched = false;
                                    list.add(new SourceLine(z80SourceLine.toString()));
                                    return -1;
                                }
                                parsingState.prevWasMismatched = true;
                                list.add(new SourceLine(z80SourceLine.toString()));
                                return n + (z80Instruction != null ? z80Instruction.getSize() : z80SourceLine.getSize());
                            }
                        }
                        if (parsingState.autoNopAfterHalt && z80Instruction.getOpCode() == 118) {
                            list.add(new SourceLine(n, z80Instruction.getSize() + 1, z80SourceLine.toString(), z80Instruction));
                            bitSet2.set(n, n + z80SourceLine.getSize() + 1);
                            parsingState.prevWasMismatched = false;
                            return n + z80SourceLine.getSize() + 1;
                        }
                        list.add(new SourceLine(n, z80SourceLine.toString(), z80Instruction));
                    } else {
                        if (!(sourceMap instanceof CDBSourceMap)) {
                            Z80Disassembler.forceSetData(n, z80SourceLine.getSize(), ramRomMap);
                        }
                        if (!z80SourceLine.startsWith(nArray, n)) {
                            ERROR_STREAM.println("Mismatched byte at " + Integer.toHexString(n) + " in " + string + ": " + (n < nArray.length ? Integer.toHexString(nArray[n]) : "EOF") + " != " + Integer.toHexString(z80SourceLine.getFirstByte()));
                            if (parsingState.prevWasMismatched) {
                                parsingState.prevWasMismatched = false;
                                list.add(new SourceLine(z80SourceLine.toString()));
                                return -1;
                            }
                            if (!(instance instanceof LR35902Disassembler) || n < 260 || n >= 336) {
                                parsingState.prevWasMismatched = true;
                            }
                            list.add(new SourceLine(z80SourceLine.toString()));
                            return n + z80SourceLine.getSize();
                        }
                        list.add(new SourceLine(n, z80SourceLine.getSize(), z80SourceLine.toString()));
                    }
                    bitSet2.set(n, n + z80SourceLine.getSize());
                    parsingState.prevWasMismatched = false;
                    return n + z80SourceLine.getSize();
                }
                parsingState.beginningOfSection = false;
            }
            if (Character.toUpperCase(string2.charAt(0)) == 'P') {
                if ("POPS".equalsIgnoreCase(string2)) {
                    n = parsingState.returnOrg;
                    parsingState.sectionEnd = Integer.MAX_VALUE;
                } else if ("PUSHS".equalsIgnoreCase(string2)) {
                    parsingState.returnOrg = n;
                }
            }
            if (z80SourceLine.getSize() == 0 && z80SourceLine.getLineNumber() >= 0 && z80SourceLine.getPrefixLength() > 0 && string2.contains("@") && (stringArray = string2.split(",\\s?|\\s")).length >= 3 && "ds".equalsIgnoreCase(stringArray[0]) && "-".equals(stringArray[2])) {
                n = z80SourceLine.getFirstByte();
            }
            if (string2.charAt(0) == '.' || Character.toUpperCase(string2.charAt(0)) == 'S' || Character.toUpperCase(string2.charAt(0)) == 'E') {
                String string7 = string2.toUpperCase();
                if (Character.toUpperCase(string2.charAt(0)) == 'S') {
                    if (string7.startsWith("SECTION")) {
                        int n18;
                        String string8;
                        parsingState.sectionEnd = Integer.MAX_VALUE;
                        parsingState.sectionName = null;
                        parsingState.beginningOfSection = true;
                        parsingState.indexPrevParsedLineWithSize = -1;
                        parsingState.prevLabel = null;
                        n = -1;
                        n4 = string2.indexOf(34) + 1;
                        if (n4 > 0 && (n3 = (string8 = string2.substring(n4)).indexOf(34)) >= 0) {
                            String string9;
                            parsingState.sectionName = string9 = string8.substring(0, n3);
                            if (sectionProvider != null) {
                                n = sectionProvider.getSectionAddress(string9);
                                parsingState.sectionEnd = sectionProvider.getSectionEnd(string9) & Integer.MAX_VALUE;
                            }
                        }
                        if (sectionProvider == null && n < 0 && (n18 = string7.indexOf("ROM0")) >= 0) {
                            n3 = string7.indexOf(44, n18) & Integer.MAX_VALUE;
                            int n19 = string7.indexOf(91, n18);
                            if (n19 >= 0 && n19 < n3) {
                                object = string7.substring(n19 + 1, string7.indexOf(93));
                                n = ((String)object).charAt(0) == '$' ? Integer.parseInt(((String)object).substring(1), 16) : Integer.parseInt((String)object);
                            }
                        }
                    }
                } else if (parsingState.returnOrg >= 0 && string7.startsWith(".ENDS")) {
                    n = parsingState.returnOrg;
                    parsingState.returnOrg = -1;
                    parsingState.sectionEnd = Integer.MAX_VALUE;
                } else if (string7.startsWith(".SECTION")) {
                    parsingState.sectionEnd = Integer.MAX_VALUE;
                    parsingState.beginningOfSection = true;
                    parsingState.indexPrevParsedLineWithSize = -1;
                    parsingState.sectionDiscarded = true;
                    parsingState.prevLabel = null;
                    if (string7.contains("RETURNORG")) {
                        parsingState.returnOrg = n;
                    }
                    if (!string7.contains("FORCE") && !string7.contains("OVERWRITE")) {
                        n = -1;
                    }
                } else if (string7.startsWith(".AREA")) {
                    n = -1;
                    parsingState.sdccDataArea = string7.contains("DATA") || string7.contains("INITIALIZED") || string7.contains("BSS");
                } else if (string7.startsWith(".RAMSECTION")) {
                    n = -1;
                } else if (string7.startsWith(".STRUCT")) {
                    n = -1;
                } else {
                    if (string7.startsWith(".ENDR") || string7.startsWith("ENDR")) {
                        return Z80Disassembler.resolveUndeterminedRept(parsingState, string, n);
                    }
                    if (string7.startsWith(".ENDST")) {
                        parsingState.withinDstruct = false;
                    } else if (".ASCIITABLE".equals(string7)) {
                        n = -1;
                    } else if (string7.startsWith(".BANK")) {
                        parsingState.indexPrevParsedLineWithSize = -1;
                        parsingState.bank = z80SourceLine.getFirstByte();
                        parsingState.slot = z80SourceLine.getBytes()[1];
                    } else if (string7.startsWith(".SLOT")) {
                        parsingState.indexPrevParsedLineWithSize = -1;
                        parsingState.bank = -1;
                        parsingState.slot = z80SourceLine.getFirstByte();
                    } else if (string7.startsWith(".ORG")) {
                        parsingState.indexPrevParsedLineWithSize = -1;
                        n4 = z80SourceLine.getFirstByte();
                        if (n4 < 0) {
                            n = -1;
                        } else if (rOMBankMap == null) {
                            n = n4;
                        } else {
                            try {
                                n = rOMBankMap.resolveAddress(parsingState.bank, n4);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                n = -1;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(ERROR_STREAM);
        }
        list.add(new SourceLine(string));
        return n;
    }

    static void forceSetInstruction(int n, Z80Instruction z80Instruction, int[] nArray, RamRomMap ramRomMap) {
        if (Z80Disassembler.getInstruction(n) == null) {
            int n2;
            Z80Instruction z80Instruction2;
            int n3;
            if (Z80Disassembler.isCode(n)) {
                n3 = 1;
                while (n3 <= 4) {
                    z80Instruction2 = Z80Disassembler.getInstruction(n - n3);
                    if (z80Instruction2 != null) {
                        n2 = 0;
                        while (n2 < z80Instruction2.getSize()) {
                            Z80Disassembler.code[n - n3 + n2] = 1;
                            ++n2;
                        }
                        Z80Disassembler.undoCode(n - n3, ramRomMap);
                        break;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < z80Instruction.getSize()) {
                if (Z80Disassembler.isCode(n + n3)) {
                    int n4 = 0;
                    while (n4 < 4 && Z80Disassembler.getInstruction(n + n3) == null) {
                        --n3;
                        ++n4;
                    }
                    z80Instruction2 = Z80Disassembler.getInstruction(n + n3);
                    n2 = 0;
                    while (n2 < z80Instruction2.getSize()) {
                        Z80Disassembler.code[n + n3 + n2] = 1;
                        ++n2;
                    }
                    Z80Disassembler.undoCode(n + n3, ramRomMap);
                    n3 += z80Instruction2.getSize() - 1;
                }
                ++n3;
            }
            Z80Disassembler.setCode(nArray, ramRomMap, n);
        }
    }

    private static void forceSetData(int n, int n2, RamRomMap ramRomMap) {
        int n3 = 0;
        while (n3 < n2) {
            if (Z80Disassembler.isCode(n + n3)) {
                int n4 = 0;
                while (n4 < 4 && Z80Disassembler.getInstruction(n + n3) == null) {
                    --n3;
                    ++n4;
                }
                Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n + n3);
                int n5 = 0;
                while (n5 < z80Instruction.getSize()) {
                    Z80Disassembler.code[n + n3 + n5] = 1;
                    ++n5;
                }
                Z80Disassembler.undoCode(n + n3, ramRomMap);
                n3 += z80Instruction.getSize() - 1;
            }
            ++n3;
        }
    }

    private static int resolveUndeterminedRept(ParsingState parsingState, String string, int n) {
        List<SourceLine> list = parsingState.lines;
        List<Z80SourceLine> list2 = parsingState.parseResult.getLines();
        BitSet bitSet = parsingState.mapped;
        ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>();
        int n2 = list.size() - 1;
        while (n2 > 0) {
            String string2;
            SourceLine sourceLine = list.get(n2);
            if (sourceLine.getSize() == 0 && ((string2 = sourceLine.toString().trim().toUpperCase()).startsWith(".REPT") || string2.startsWith(".REPEAT") || string2.startsWith("REPT"))) break;
            --n2;
        }
        ++n2;
        int n3 = -1;
        boolean bl = false;
        block1: while (!bl && n != n3) {
            n3 = n;
            int n4 = n2;
            while (!bl && n4 < list.size()) {
                Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n);
                Z80Instruction z80Instruction2 = list.get(n4).getInstruction();
                if (z80Instruction != null && z80Instruction2 != null && z80Instruction.getOpCode() != z80Instruction2.getOpCode() || z80Instruction != null ^ z80Instruction2 != null || z80Instruction2 == null && !list2.get(n4).startsWith(parsingState.memory, n)) {
                    bl = true;
                } else if (list.get(n4).getSize() > 0) {
                    if (bitSet.get(n, n + list.get(n4).getSize()).cardinality() > 0) {
                        bl = true;
                        continue block1;
                    }
                    if (z80Instruction != null) {
                        arrayList.add(new SourceLine(n, list.get(n4).toString(), z80Instruction));
                    } else {
                        arrayList.add(new SourceLine(n, list.get(n4).getSize(), list.get(n4).toString()));
                    }
                    bitSet.set(n, n + list.get(n4).getSize());
                    n += list.get(n4).getSize();
                }
                ++n4;
            }
        }
        list.set(n2 - 1, new SourceLine(";" + list.get(n2 - 1).toString()));
        if (!arrayList.isEmpty()) {
            parsingState.putUndeterminedRept(list.size(), arrayList);
        }
        list.add(new SourceLine(";" + string));
        return n;
    }

    public static List<SourceLine> generateLines(int[] nArray, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map, util.map.Map<String> map2, AssemblerDialect assemblerDialect, SectionProvider sectionProvider, int n, int n2, boolean bl, String string, String string2, String string3, String string4, String string5, boolean bl2, boolean bl3, boolean bl4) {
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        if (dialect != null && dialect != assemblerDialect) {
            Arrays.fill(singleByteDataBlockLines, null);
        }
        dialect = assemblerDialect;
        MAX_DATA_BLOCK_SIZE = n;
        CREATE_LINK_FILE = bl;
        FORMAT_CODE_LABEL = string;
        FORMAT_DATA_LABEL = string2;
        FORMAT_RAM_LABEL = string3;
        FORMAT_SRAM_LABEL = string4;
        FORMAT_PORT_LABEL = string5;
        USE_ANONYMOUS_LABELS = bl2 && assemblerDialect.supportsAnonymousLabels();
        USE_UPPERCASE_MNEMONICS = bl3;
        PAD_MNEMONICS = bl4;
        DSB_DATA_BLOCK_SIZE = n2;
        boolean bl5 = dummyCartridge instanceof SMSCartridge && ((SMSCartridge)dummyCartridge).hasSEGAbranding();
        int n3 = 2;
        while (n3 < slots.length && bl5) {
            if (slots[n3] < 2) {
                bl5 = false;
            }
            ++n3;
        }
        if (bl5 && slots.length > 1) {
            Z80Disassembler.slots[1] = 1;
        }
        dataBlocks.clear();
        ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>();
        beginningOfDisassembly = arrayList.size();
        arrayList.add(SourceLine.DISASSEMBLY_HEAD_COMMENT);
        assemblerDialect.writeHeader(arrayList, nArray, bl5);
        assemblerDialect.writeRAMdefinitions(arrayList, map, sectionProvider, ramSeen, sramSeen, ramSizes, sramSizes, string3, string4);
        assemblerDialect.writePortDefinitions(arrayList, map2, portSeen, string5);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl6 = false;
        State state = null;
        Address address = null;
        BitSet bitSet = new BitSet();
        HashMap<Table> hashMap = new HashMap<Table>();
        for (Table table : jumpTables) {
            hashMap.put(table.start, table);
            bitSet.set(table.start);
        }
        for (Table table : pointerTables) {
            hashMap.put(table.start, table);
            bitSet.set(table.start);
        }
        int n7 = dummyCartridge instanceof MSXCartridge && !(dummyCartridge instanceof MSXDisk) ? ((MSXCartridge)dummyCartridge).getHeaderAddress() : -1;
        int n8 = instance instanceof LR35902Disassembler ? 260 : -1;
        BitSet bitSet2 = dataSeen.keyBitSet();
        BitSet bitSet3 = dummyCartridge instanceof MSXDisk ? new BitSet(0) : Symbols.getRomSymbolKeys(map);
        BitSet bitSet4 = dummyCartridge instanceof MSXDisk ? bitSet3 : Symbols.getRamSymbolKeys(map);
        BitSet bitSet5 = tableEntrySeen.keyBitSet();
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = Math.min(nArray.length, bl5 ? 32752 : dummyCartridge.getBankSize());
        if (sectionProvider == null) {
            assemblerDialect.writeStartOfBank(arrayList, 0, slots[0]);
        }
        labels.or(bitSet3);
        while (n4 < nArray.length) {
            int n15;
            Object object;
            if (sectionProvider != null && (object = sectionProvider.getRomSection(n4)) != null) {
                assemblerDialect.writeSection(arrayList, (Section)object);
            }
            if (n4 >= n14) {
                if (sectionProvider == null && n4 == n14) {
                    assemblerDialect.writeStartOfBank(arrayList, Z80Disassembler.getRomBank(n4), Z80Disassembler.getSlotAt(n4));
                }
                n14 = Math.min(nArray.length, n14 == 32752 ? 32768 : n14 + dummyCartridge.getBankSize());
            }
            if (n4 == n7) {
                int n16 = Z80Disassembler.writeMSXcartridgeHeader(arrayList, nArray, ramRomMap, map);
                dataBlocks.add(new DataBlock(n4, n16));
                n4 += n16;
            }
            if (n4 <= n8 && n4 >= 256 && !Z80Disassembler.isCode(n4)) {
                if (n4 < 260) {
                    Z80Disassembler.writeDataBlock(arrayList, nArray, ramRomMap, n4, 260, null, 1, null, false, map);
                    dataBlocks.add(new DataBlock(n4, 260 - n4));
                }
                LR35902Disassembler.writeGBcartridgeHeader(arrayList, (GBCartridge)dummyCartridge, nArray);
                dataBlocks.add(new DataBlock(n4, 336 - n4));
                n4 = 336;
            }
            if (n4 >= n6) {
                if (n4 > n13) {
                    n13 = bitSet5.nextSetBit(n4) & Integer.MAX_VALUE;
                }
                if (n4 == n13) {
                    Z80Disassembler.writeEntryComment(arrayList, nArray, tableEntrySeen.get(n4), n4, ramRomMap, map);
                }
            }
            if (n4 >= n9) {
                n9 = instructionStart.nextSetBit(n4) & Integer.MAX_VALUE;
            }
            Object object2 = object = n4 == n9 ? Z80Disassembler.getInstruction(n4) : null;
            if (object != null) {
                n4 = instance.writeInstruction(arrayList, n4, ramRomMap, (Z80Instruction)object, map, bitSet3, bitSet4, bitSet2, map2);
                continue;
            }
            int n17 = n4;
            if (n4 >= n12) {
                n12 = bitSet3.nextSetBit(n4 + 1) & Integer.MAX_VALUE;
            }
            if (n4 >= n11) {
                n11 = bitSet2.nextSetBit(n4 + 1) & Integer.MAX_VALUE;
            }
            if (n4 >= n6) {
                Table table;
                if (n4 > n10) {
                    n10 = bitSet.nextSetBit(n4) & Integer.MAX_VALUE;
                }
                Table table2 = table = n4 == n10 ? (Table)hashMap.get(n4) : null;
                if (table != null) {
                    n5 = table.start;
                    n6 = table.end;
                    state = table.state;
                    address = table.indexedBy;
                    if (address != null && !address.isRamAddress()) {
                        address = null;
                    }
                    bl6 = pointerTables.contains(table);
                } else {
                    state = null;
                }
            }
            if (n17 < (n4 = (n15 = Math.min(n9, Math.max(n6, Math.min(n10, Math.min(n12, Math.min(n11, n14)))))))) {
                Z80Disassembler.writeDataBlock(arrayList, nArray, ramRomMap, n17, n4, state, n17 >= n5 && n17 < n6 ? 2 : 1, address, bl6, map);
                try {
                    dataBlocks.add(new DataBlock(n17, n4 - n17));
                }
                catch (Exception exception) {
                    exception.printStackTrace(ERROR_STREAM);
                }
                continue;
            }
            ++n4;
        }
        arrayList.trimToSize();
        return arrayList;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static CpuLines generateCpuLines(DebuggableSystem var0, CpuLines var1_1, CpuLines var2_2, int[] var3_3, long var4_4, List<SourceLine> var6_5, int[] var7_6, util.map.Map<List<Symbols.Symbol>> var8_7, BitSet var9_8, BitSet var10_9, util.map.Map<String> var11_10) {
        if (Z80Disassembler.dialect == null) {
            throw new IllegalStateException("dialect must be set");
        }
        var12_11 = var0.getPrevPC();
        var13_12 = null;
        var14_13 = new BitSet(0);
        var15_14 = null;
        var16_15 = var0.getMemoryLength() / var1_1.getNumberOfBlocks();
        var17_16 = null;
        var18_17 = false;
        var19_18 = 0;
        while (var19_18 < var1_1.getNumberOfBlocks()) {
            block40: {
                var20_19 = var1_1.getLines(var19_18);
                var21_20 = var2_2.getLines(var19_18);
                if ((var4_4 & 1L << var19_18) != 0L) {
                    var20_19.clear();
                }
                if (!var20_19.isEmpty()) break block40;
                var22_21 = 0;
                for (SourceLine var23_23 : var21_20) {
                    if (var23_23.getAddress() >= 0) {
                        var3_3[var23_23.getAddress()] = var22_21;
                    }
                    ++var22_21;
                }
                var23_22 = (var19_18 + 1) * var16_15;
                var24_24 = var19_18 * var16_15;
                while (var24_24 < var23_22) {
                    block45: {
                        block42: {
                            block43: {
                                block44: {
                                    block41: {
                                        var25_26 = var3_3[var24_24];
                                        v0 = var26_27 = var25_26 < var21_20.size() ? var21_20.get(var25_26) : null;
                                        if (var26_27 != null && var24_24 != var26_27.getAddress()) {
                                            var26_27 = null;
                                        }
                                        if (!var0.isROMaddress(var24_24)) ** GOTO lbl-1000
                                        var27_28 = var0.mapAddress(var24_24);
                                        v1 = var28_30 = var27_28 >= 0 && var27_28 < var7_6.length ? var6_5.get(var7_6[var27_28]) : SourceLine.EMPTY_LINE;
                                        if (var28_30.getAddress() != var27_28) ** GOTO lbl-1000
                                        var29_33 = true;
                                        if (var28_30.getInstruction() == null) break block41;
                                        v2 = var30_35 = var20_19.isEmpty() == false ? var20_19.get(var20_19.size() - 1) : SourceLine.EMPTY_LINE;
                                        if (var30_35 != SourceLine.EMPTY_LINE && var30_35.getInstruction() == null) {
                                            var20_19.add(SourceLine.EMPTY_LINE);
                                        }
                                        var31_36 = var28_30.getInstruction();
                                        if (var26_27 != null && var31_36.equals(var26_27.getInstruction())) {
                                            var20_19.add(var26_27);
                                        } else {
                                            var20_19.add((SourceLine)(var24_24 == var28_30.getAddress() ? var28_30 : new SourceLine(var24_24, var28_30.toString(), var31_36)));
                                        }
                                        if ((var31_36.isRet() || var31_36.isJump()) && !var31_36.isConditional()) {
                                            var20_19.add(SourceLine.EMPTY_LINE);
                                        }
                                        break block42;
                                    }
                                    if (!var18_17 && (var12_11 < var24_24 || var12_11 >= var24_24 + var28_30.getSize())) break block43;
                                    var18_17 = true;
                                    if (var26_27 == null || var26_27.getInstruction() == null) break block44;
                                    var30_35 = var26_27.getInstruction();
                                    var20_19.add(var26_27);
                                    var24_24 += var26_27.getSize() - 1;
                                    if ((var30_35.isRet() || var30_35.isJump()) && !var30_35.isConditional()) {
                                        var20_19.add(SourceLine.EMPTY_LINE);
                                        var18_17 = false;
                                    }
                                    break block45;
                                }
                                var29_33 = false;
                                break block42;
                            }
                            if (var26_27 != null && var26_27.toString() == var28_30.toString()) {
                                var20_19.add(var26_27);
                            } else {
                                var20_19.add((SourceLine)(var24_24 == var28_30.getAddress() ? var28_30 : new SourceLine(var24_24, var28_30.getSize(), var28_30.toString())));
                            }
                        }
                        if (var29_33) {
                            var18_17 = false;
                            if ((var24_24 += var28_30.getSize() - 1) > var23_22) {
                                if ((var19_18 += (var24_24 - var23_22 - 1) / var16_15 + 1) >= var1_1.getNumberOfBlocks()) break;
                                var23_22 = (var19_18 + 1) * var16_15;
                            }
                        } else lbl-1000:
                        // 3 sources

                        {
                            if (!var0.isVRAMaddress(var24_24) || var0.isVRAMaddress(var12_11)) {
                                if (var26_27 != null && var26_27.getInstruction() != null && Z80Disassembler.isMatchingInstruction(var0, var24_24, var26_27.getInstruction())) {
                                    var27_29 = var26_27.getInstruction();
                                } else {
                                    if (var13_12 == null) {
                                        var13_12 = new int[8];
                                    }
                                    var28_31 = 0;
                                    while (var28_31 < var13_12.length) {
                                        var13_12[var28_31] = var0.peekByte(var24_24 + var28_31);
                                        ++var28_31;
                                    }
                                    var27_29 = Z80Disassembler.instance.getInstruction(var13_12, 0);
                                }
                            } else {
                                var27_29 = null;
                            }
                            if (var27_29 != null && var27_29.isValid() && (var12_11 <= var24_24 || var12_11 >= var24_24 + var27_29.getSize())) {
                                if (var26_27 != null && var27_29.equals(var26_27.getInstruction())) {
                                    var28_32 = var25_26 - 1;
                                    while (var28_32 >= 0 && var21_20.get(var28_32).getAddress() < 0 && var21_20.get(var28_32) != SourceLine.EMPTY_LINE) {
                                        var20_19.add(var21_20.get(var28_32));
                                        --var28_32;
                                    }
                                    var20_19.add(var26_27);
                                } else {
                                    if (var0.isRAMaddress(var24_24)) {
                                        for (Object var28_30 : Symbols.findRamSymbols(var24_24, var8_7)) {
                                            if (var28_30.getBank() != var0.getBank(var24_24)) continue;
                                            if (var15_14 == null) {
                                                var15_14 = new StringBuilder();
                                            } else {
                                                var15_14.setLength(0);
                                            }
                                            var20_19.add(new SourceLine(var15_14.append(var28_30.getLabel()).append(':').toString()));
                                        }
                                    }
                                    if (var17_16 != null && !var27_29.isRelative() && var17_16.getInstruction().equals(var27_29)) {
                                        var20_19.add(new SourceLine(var24_24, var17_16.toString(), var17_16.getInstruction()));
                                    } else {
                                        if (var15_14 == null) {
                                            var15_14 = new StringBuilder();
                                        } else {
                                            var15_14.setLength(0);
                                        }
                                        var17_16 = new SourceLine(var24_24, var15_14.append('\t').append(Z80Disassembler.injectSymbols(var24_24, var27_29, null, Z80Disassembler.defaultRamRomMap, var8_7, var9_8, var10_9, var14_13, var11_10)).toString(), var27_29);
                                        var20_19.add(var17_16);
                                    }
                                }
                                if ((var27_29.isRet() || var27_29.isJump()) && !var27_29.isConditional()) {
                                    var20_19.add(SourceLine.EMPTY_LINE);
                                }
                                var24_24 += var27_29.getSize() - 1;
                            } else {
                                if (var13_12 == null) {
                                    var13_12 = new int[8];
                                }
                                var13_12[0] = var0.peekByte(var24_24);
                                var28_30 = Z80Disassembler.getDataBlockLine(var13_12, Z80Disassembler.defaultRamRomMap, 0, 1, 1, null, var8_7);
                                if (var26_27 != null && var26_27.toString() == var28_30) {
                                    var20_19.add(var26_27);
                                } else {
                                    var20_19.add(new SourceLine(var24_24, 1, (String)var28_30));
                                }
                            }
                        }
                    }
                    ++var24_24;
                }
            }
            ++var19_18;
        }
        return var1_1;
    }

    public static boolean isMatchingInstruction(DebuggableSystem debuggableSystem, int n, Z80Instruction z80Instruction) {
        if (z80Instruction.getSize() == 1) {
            return debuggableSystem.peekByte(n) == z80Instruction.getOpCode();
        }
        int n2 = z80Instruction.getPrefix();
        if (n2 > 0 && debuggableSystem.peekByte(n++) != n2) {
            return false;
        }
        int n3 = z80Instruction.getOpCode();
        if (n3 >= 256 && debuggableSystem.peekByte(n++) != n3 >> 8) {
            return false;
        }
        if (n3 >= 256 && z80Instruction.hasDisplacement() && debuggableSystem.peekByte(n++) != (z80Instruction.getDisplacement() & 0xFF)) {
            return false;
        }
        if (debuggableSystem.peekByte(n++) != (n3 & 0xFF)) {
            return false;
        }
        if (n3 < 256 && z80Instruction.hasDisplacement() && debuggableSystem.peekByte(n++) != (z80Instruction.getDisplacement() & 0xFF)) {
            return false;
        }
        if (z80Instruction.hasArg()) {
            if (debuggableSystem.peekByte(n++) != (z80Instruction.getArg() & 0xFF)) {
                return false;
            }
            if (z80Instruction.getArgSize() > 1 && debuggableSystem.peekByte(n++) != z80Instruction.getArg() >> 8) {
                return false;
            }
        }
        return true;
    }

    public static AssemblerDialect getDialect() {
        return dialect;
    }

    private static void writeDataBlock(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, int n2, State state, int n3, Address address, boolean bl, util.map.Map<List<Symbols.Symbol>> map) {
        Object object;
        int n4;
        Object object2;
        if (n3 == 2) {
            object2 = "unknown";
            if (address != null && address.isRamAddress()) {
                n4 = address.getMin();
                object = Symbols.findRAMSymbol(n4, map);
                Object object3 = object2 = object != null ? ((Symbols.Symbol)object).getLabel() : String.format(FORMAT_RAM_LABEL, n4);
            }
            if (bl) {
                list.add(new SourceLine("; Pointer Table from " + Integer.toHexString(n).toUpperCase() + " to " + Integer.toHexString(n2 - 1).toUpperCase() + " (" + (n2 - n) / n3 + " entries, indexed by " + (String)object2 + ")"));
            } else {
                list.add(new SourceLine("; Jump Table from " + Integer.toHexString(n).toUpperCase() + " to " + Integer.toHexString(n2 - 1).toUpperCase() + " (" + (n2 - n) / n3 + " entries, indexed by " + (String)object2 + ")"));
            }
        } else {
            list.add(new SourceLine("; Data from " + Integer.toHexString(n).toUpperCase() + " to " + Integer.toHexString(n2 - 1).toUpperCase() + " (" + (n2 - n) / n3 + " bytes)"));
        }
        Z80Disassembler.writeDataBlockLabels(list, n, map);
        Object object4 = object2 = n3 > 1 ? Collections.emptyList() : Z80Disassembler.findRunsOfSameValue(nArray, n, n2);
        if (!(n2 - n <= 0 || n3 <= 1 && object2.isEmpty() && n2 - n > MAX_DATA_BLOCK_SIZE)) {
            if (state != null && state.getBank1().getSource() != null && !state.getBank1().getSource().isUnique()) {
                n4 = n;
                while (n4 < n2) {
                    DUMMY_STATE.setBank0(state.getBank0());
                    DUMMY_STATE.setBank1(state.getBank1());
                    DUMMY_STATE.setBank2(state.getBank2());
                    DUMMY_STATE.setBank3(state.getBank3());
                    DUMMY_STATE.setSRAMenabled(state.isSRAMenabled());
                    DUMMY_STATE.setSRAMbank(state.getSRAMbank());
                    int n5 = DUMMY_STATE.getBank1().getSource().getMin() + n4 - n;
                    DUMMY_STATE.setBank1(new Value(nArray[n5], new Address(n5, true, false, false, false)));
                    if (n4 + 2 < n2 && n4 + 2 == n5) {
                        list.add(new SourceLine(n4, 2, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4, n4 + 2, 2, DUMMY_STATE, map)));
                        list.add(new SourceLine(n4 + 2, 1, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4 + 2, n4 + 3, 1, DUMMY_STATE, map)));
                    } else if (n4 + 2 < n2 && n4 == n5) {
                        list.add(new SourceLine(n4, 1, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4, n4 + 1, 1, DUMMY_STATE, map)));
                        list.add(new SourceLine(n4 + 1, 2, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4 + 1, n4 + 3, 2, DUMMY_STATE, map)));
                    } else {
                        if (n2 - n4 < n3) break;
                        list.add(new SourceLine(n4, n2 - n4, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4, n2, n3, state, map)));
                        break;
                    }
                    n4 += 3;
                }
            } else {
                n4 = n;
                object = object2.iterator();
                while (n4 < n2) {
                    int[] nArray2 = object.hasNext() ? (int[])object.next() : null;
                    int n6 = nArray2 != null ? nArray2[0] : n2;
                    while (n4 + 16 < n6) {
                        list.add(new SourceLine(n4, 16, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4, n4 + 16, n3, state, map)));
                        n4 += 16;
                    }
                    if (n4 + n3 <= n6) {
                        list.add(new SourceLine(n4, n6 - n4, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n4, n6, n3, state, map)));
                        n4 += n6 - n4;
                    }
                    if ((n6 - n4) % n3 != 0) {
                        list.add(new SourceLine(n6 - 1, (n6 - n4) % n3, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n6 - (n6 - n4) % n3, n6, 1, state, map)));
                        n4 += (n6 - n4) % n3;
                    }
                    if (nArray2 == null) continue;
                    list.add(new SourceLine(n4, nArray2[1], String.valueOf(dialect.getDataPrefix(8)) + " " + nArray2[1] + "," + HexStrings.PREFIXED_HEX_STRINGS[nArray[nArray2[0]]]));
                    n4 += nArray2[1];
                }
            }
            if ((n2 - n4) % n3 != 0) {
                list.add(new SourceLine(n2 - 1, (n2 - n4) % n3, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n2 - (n2 - n4) % n3, n2, 1, state, map)));
            }
        } else if (n2 - n > MAX_DATA_BLOCK_SIZE) {
            list.add(new SourceLine(n, n2 - n, dialect.getIncBinLine(null)));
        }
        list.add(SourceLine.EMPTY_LINE);
    }

    private static List<int[]> findRunsOfSameValue(int[] nArray, int n, int n2) {
        if (n2 - n <= DSB_DATA_BLOCK_SIZE) {
            return Collections.emptyList();
        }
        int n3 = 0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n4 = n;
        while (n4 < n2) {
            if (n4 - n - n3 >= MAX_DATA_BLOCK_SIZE) {
                return Collections.emptyList();
            }
            int n5 = n4;
            while (n4 + 1 < n2 && nArray[n4 + 1] == nArray[n4]) {
                ++n4;
            }
            int n6 = n4 + 1 - n5;
            if (n6 > DSB_DATA_BLOCK_SIZE) {
                arrayList.add(new int[]{n5, n6});
                n3 += n6;
            }
            ++n4;
        }
        if (n2 - n - n3 >= MAX_DATA_BLOCK_SIZE) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    protected int writeInstruction(List<SourceLine> list, int n, RamRomMap ramRomMap, Z80Instruction z80Instruction, util.map.Map<List<Symbols.Symbol>> map, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, util.map.Map<String> map2) {
        String string = null;
        for (String string2 : Symbols.findComment(n, map)) {
            if (string2.length() <= 1) {
                list.add(SourceLine.EMPTY_LINE);
                continue;
            }
            if (string2.charAt(1) != ';') {
                list.add(new SourceLine(string2));
                continue;
            }
            string = string2.substring(1);
        }
        if (Z80Disassembler.hasLabel(n)) {
            int n2 = ramRomMap.toRamAddress(n);
            if (n2 >= 0) {
                list.add(new SourceLine("; Executed in RAM at " + Integer.toHexString(n2)));
            }
            Z80Disassembler.writeCodeLabels(list, n, map);
        }
        list.add(new SourceLine(n, "\t" + Z80Disassembler.injectSymbols(n, z80Instruction, string, ramRomMap, map, bitSet, bitSet2, bitSet3, map2), z80Instruction));
        if ((z80Instruction.isRet() || z80Instruction.isJump()) && !z80Instruction.isConditional()) {
            list.add(SourceLine.EMPTY_LINE);
        }
        return n + z80Instruction.getSize();
    }

    private static void writeCodeLabels(List<SourceLine> list, int n, util.map.Map<List<Symbols.Symbol>> map) {
        Z80Disassembler.writeCodeLabels(list, list.size(), n, map);
    }

    private static void writeCodeLabels(List<SourceLine> list, int n, int n2, util.map.Map<List<Symbols.Symbol>> map) {
        if (!Z80Disassembler.writeSymbolLabels(list, n, n2, map)) {
            list.add(n++, new SourceLine(String.valueOf(Z80Disassembler.getLabel(n2, map)) + ":"));
            prevNonChildLabel = null;
        }
    }

    private static boolean writeSymbolLabels(List<SourceLine> list, int n, int n2, util.map.Map<List<Symbols.Symbol>> map) {
        char c = dialect.getChildLabelChar();
        List<Symbols.Symbol> list2 = Symbols.findSymbols(n2, map);
        if (list2.isEmpty()) {
            return false;
        }
        for (Symbols.Symbol symbol : Z80Disassembler.reorderChildSymbols(list2)) {
            if (symbol.getComment() != null) {
                list.add(n++, new SourceLine(symbol.getComment()));
            }
            String string = symbol.getLabel();
            int n3 = 0;
            if (prevNonChildLabel != null && string.startsWith(prevNonChildLabel)) {
                int n4 = string.indexOf(c, n3);
                while (n4 >= 0) {
                    string = String.valueOf(string.substring(0, n3)) + string.substring(n4);
                    n4 = string.indexOf(c, ++n3);
                }
            }
            if (n3 == 0) {
                prevNonChildLabel = string;
            }
            list.add(n++, new SourceLine(String.valueOf(string) + ":"));
        }
        return true;
    }

    private static List<Symbols.Symbol> reorderChildSymbols(List<Symbols.Symbol> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        int n = list.size() - 1;
        while (n > 0) {
            Symbols.Symbol symbol = list.get(n);
            Symbols.Symbol symbol2 = list.get(n - 1);
            if (symbol.getLabel().length() < symbol2.getLabel().length() && symbol2.getLabel().startsWith(symbol.getLabel())) {
                list.set(n - 1, symbol);
                list.set(n, symbol2);
            }
            --n;
        }
        return list;
    }

    private static void writeDataBlockLabels(List<SourceLine> list, int n, util.map.Map<List<Symbols.Symbol>> map) {
        int n2 = list.size();
        if (!Z80Disassembler.writeSymbolLabels(list, n2, n, map) && dataSeen.containsKey(n)) {
            list.add(n2++, new SourceLine(String.valueOf(String.format(FORMAT_DATA_LABEL, n)) + ":"));
            Z80Disassembler.addLabel(n);
        }
    }

    private static void writeEntryComment(List<SourceLine> list, int[] nArray, int n, int n2, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map) {
        Table table;
        Table table2 = table = Z80Disassembler.isCode(n2) ? Z80Disassembler.getJumpTableAt(n) : Z80Disassembler.getPointerTableAt(n);
        if (table != null) {
            String string;
            Z80Instruction z80Instruction;
            Register[] registerArray = table.state.getRegs();
            int n3 = 1;
            int n4 = 2;
            if (registerArray[5].getSource() != null && registerArray[5].getSource().getMin() > 0) {
                n3 = registerArray[5].getSource().getMin();
                if (registerArray[5].getSource().getMultiplier() == 3) {
                    n4 = 3;
                }
            }
            if (((z80Instruction = Z80Disassembler.getInstruction(n3)) == null || z80Instruction.getOpCode() != 33 || instance.isRAMaddress(z80Instruction.getArg())) && (string = Z80Disassembler.getEntryComment(nArray, table, n, n2, ramRomMap, n4, map)) != null) {
                list.add(new SourceLine(string));
            }
        }
    }

    private static String getEntryComment(int[] nArray, Table table, int n, int n2, RamRomMap ramRomMap, int n3, util.map.Map<List<Symbols.Symbol>> map) {
        int n4 = Z80Disassembler.READ_WORD(nArray, n);
        if (instance.isROMaddress(n4, table.state) && n2 == Z80Disassembler.RESOLVE_ADDRESS(n4, ramRomMap, table.state)) {
            int n5 = (n - table.start) / n3 + 1;
            String string = Integer.toString(n5);
            if (n5 % 100 / 10 == 1) {
                string = String.valueOf(string) + "th";
            } else {
                switch (n5 % 10) {
                    case 1: {
                        string = String.valueOf(string) + "st";
                        break;
                    }
                    case 2: {
                        string = String.valueOf(string) + "nd";
                        break;
                    }
                    case 3: {
                        string = String.valueOf(string) + "rd";
                        break;
                    }
                    default: {
                        string = String.valueOf(string) + "th";
                    }
                }
            }
            Symbols.Symbol symbol = Symbols.findSymbol(table.start, map);
            Address address = null;
            Symbols.Symbol symbol2 = null;
            if (table.indexedBy != null && table.indexedBy.isRamAddress()) {
                address = table.indexedBy;
                symbol2 = Symbols.findRAMSymbol(address.getMin(), map);
            }
            if (Z80Disassembler.isCode(n2)) {
                return "; " + string + " entry of " + (symbol != null ? symbol.getLabel() : "Jump Table from " + Integer.toHexString(table.start).toUpperCase()) + " (indexed by " + (address != null ? (symbol2 != null ? symbol2.getLabel() : String.format(FORMAT_RAM_LABEL, address.getMin())) : "unknown") + ")";
            }
            return "; " + string + " entry of " + (symbol != null ? symbol.getLabel() : "Pointer Table from " + Integer.toHexString(table.start).toUpperCase()) + " (indexed by " + (address != null ? (symbol2 != null ? symbol2.getLabel() : String.format(FORMAT_RAM_LABEL, address.getMin())) : "unknown") + ")";
        }
        return null;
    }

    public static void writeSubDataBlockLine(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, int n2, util.map.Map<List<Symbols.Symbol>> map) {
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        if (list.size() >= 1 && list.get(list.size() - 1) != SourceLine.EMPTY_LINE) {
            list.add(SourceLine.EMPTY_LINE);
        }
        Z80Disassembler.writeDataBlock(list, nArray, ramRomMap, n, n2, null, 1, null, false, map);
        list.remove(list.size() - 1);
    }

    protected static String getDataBlockLine(int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, State state, util.map.Map<List<Symbols.Symbol>> map) {
        int n4;
        String string;
        boolean bl;
        if (n2 > nArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 - n < n3) {
            throw new IllegalArgumentException("Cannot add a data blockline for an empty datablock.");
        }
        boolean bl2 = bl = n3 == 1 && n2 - n == 1;
        if (bl && (string = singleByteDataBlockLines[nArray[n]]) != null) {
            return string;
        }
        if (state == null) {
            state = DUMMY_STATE;
            state.setSRAMenabled(Z80Disassembler.isSRAMenabled(n));
            state.setSRAMbank(Z80Disassembler.getSRAMbank(n));
        }
        string = dialect.getDataPrefix(n3);
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n2 - n) * n3 * HexStrings.PREFIXED_HEX_STRINGS[nArray[n]].length());
        boolean bl3 = dialect.requiresDataCommas();
        stringBuilder.append(string);
        if (n3 == 2) {
            n4 = n;
            while (n4 + (n3 - 1) < n2) {
                boolean bl4;
                Value value;
                int n5 = nArray[n4] | nArray[n4 + 1] << 8;
                if (!instance.isROMaddress(n5, state)) {
                    value = Value.ZERO;
                    bl4 = true;
                } else if (n5 >= 32768) {
                    value = state.getBank2();
                    bl4 = msx || value.getMin() < slots.length && slots[value.getMin()] == 2;
                } else if (n5 >= 16384) {
                    value = state.getBank1();
                    bl4 = msx || value.getMin() < slots.length && slots[value.getMin()] == 1;
                } else {
                    value = state.getBank0();
                    boolean bl5 = bl4 = value.getMin() < slots.length && slots[value.getMin()] == 0;
                }
                if (n4 != n && bl3) {
                    stringBuilder.append(',');
                }
                if (bl4 && n5 > 0 && (value.getSource() == null || value.getSource().isUnique())) {
                    Symbols.Symbol symbol = Z80Disassembler.findSymbol(n5, value.getMin(), map);
                    if (symbol != null) {
                        stringBuilder.append(" ").append(symbol.getLabel());
                    } else if (instance.isROMaddress(n5, state) && Z80Disassembler.isDataSeen(n5, ramRomMap, state, n4)) {
                        stringBuilder.append(String.format(" " + FORMAT_DATA_LABEL, Z80Disassembler.RESOLVE_ADDRESS(n5, ramRomMap, state)));
                    } else if (instance.isROMaddress(n5, state) && Z80Disassembler.isSeen(n5, ramRomMap, state, n4)) {
                        stringBuilder.append(String.format(" " + FORMAT_CODE_LABEL, Z80Disassembler.RESOLVE_ADDRESS(n5, ramRomMap, state)));
                    } else if (instance.isRAMaddress(n5) && Z80Disassembler.isRAMseen(instance.mapRAMaddress(n5), n4)) {
                        String string2;
                        if (instance.isMirrorAddress(n5)) {
                            int n6 = instance.mapMirrorAddress(n5);
                            string2 = String.format(" $%04X | " + FORMAT_RAM_LABEL, n5 ^ n6, n6);
                        } else {
                            string2 = String.format(" " + FORMAT_RAM_LABEL, n5);
                        }
                        stringBuilder.append(string2);
                    } else if (instance.isSRAMaddress(n5, state) && Z80Disassembler.isSRAMseen(n5, state, n4)) {
                        stringBuilder.append(String.format(" " + FORMAT_SRAM_LABEL, instance.mapSRAMaddress(n5, state)));
                    } else {
                        stringBuilder.append(HexStrings.PREFIXED_HEX_STRINGS[n5 >> 8]).append(HexStrings.HEX_STRINGS[n5 & 0xFF]);
                    }
                } else {
                    stringBuilder.append(HexStrings.PREFIXED_HEX_STRINGS[n5 >> 8]).append(HexStrings.HEX_STRINGS[n5 & 0xFF]);
                }
                n4 += n3;
            }
        } else if (bl3) {
            stringBuilder.append(HexStrings.PREFIXED_HEX_STRINGS[nArray[n]]);
            n4 = n + 1;
            while (n4 < n2) {
                stringBuilder.append(',').append(HexStrings.PREFIXED_HEX_STRINGS[nArray[n4]]);
                ++n4;
            }
        } else {
            n4 = n;
            while (n4 < n2) {
                stringBuilder.append(HexStrings.PREFIXED_HEX_STRINGS[nArray[n4]]);
                ++n4;
            }
        }
        String string3 = stringBuilder.toString();
        if (bl) {
            Z80Disassembler.singleByteDataBlockLines[nArray[n]] = string3;
        }
        return string3;
    }

    private static void updateLabel(int n, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, util.map.Map<String> map2, List<SourceLine> list, int n2) {
        String string;
        String string2 = list.get(n2).toString();
        if (string2.equals(string = String.valueOf(Z80Disassembler.getLabel(n, map)) + ":")) {
            return;
        }
        list.set(n2, new SourceLine(string));
        IntHashSet intHashSet = seen.get(n);
        if (intHashSet != null) {
            int[] nArray = intHashSet.keys();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = nArray[n4];
                int n6 = n2;
                int n7 = list.get(n6).getAddress();
                if (n5 < n) {
                    while (n7 < 0 || n7 > n5) {
                        n7 = list.get(--n6).getAddress();
                    }
                } else if (n5 > n) {
                    while (n7 < n5) {
                        n7 = list.get(++n6).getAddress();
                    }
                }
                if (n7 == n5) {
                    Z80Instruction z80Instruction = list.get(n6).getInstruction();
                    String string3 = null;
                    for (String string4 : Symbols.findComment(n, map)) {
                        if (string4.length() <= 1) {
                            list.add(SourceLine.EMPTY_LINE);
                            continue;
                        }
                        if (string4.charAt(1) != ';') {
                            list.add(new SourceLine(string4));
                            continue;
                        }
                        string3 = string4.substring(1);
                    }
                    list.set(n6, new SourceLine(n7, "\t" + Z80Disassembler.injectSymbols(n7, z80Instruction, string3, ramRomMap, map, bitSet, bitSet2, bitSet3, map2), z80Instruction));
                }
                ++n4;
            }
        }
    }

    private static String getAnonymousLabel(int n, util.map.Map<List<Symbols.Symbol>> map) {
        return Z80Disassembler.getAnonymousLabel(-1, n, map, new HashMap<String>());
    }

    private static String getAnonymousLabel(int n, int n2, util.map.Map<List<Symbols.Symbol>> map, HashMap<String> hashMap) {
        String string = hashMap.get(n2);
        if (string != null) {
            return string.isEmpty() ? null : string;
        }
        if (!Z80Disassembler.hasLabel(n2) || seen.get(n2) == null || tableEntrySeen.containsKey(n2) || Symbols.findSymbol(n2, map) != null) {
            return null;
        }
        IntHashSet intHashSet = seen.get(n2);
        int n3 = intHashSet.keys()[0];
        if (n < 0) {
            n = n3;
        }
        int[] nArray = intHashSet.keys();
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[n5];
            if (n6 > n2 ^ n3 > n2) {
                return null;
            }
            if (Math.abs(n6 - n2) > Math.abs(n3 - n2)) {
                n3 = n6;
            }
            ++n5;
        }
        if (n >= n2 && n2 == n3) {
            return "-";
        }
        if (Math.abs(n2 - n3) < 64) {
            if (n3 < n2 && n < n2) {
                String string2 = "+";
                n5 = n3 + 1;
                while (n5 < n2) {
                    String string3 = Z80Disassembler.getAnonymousLabel(n3, n5, map, hashMap);
                    if (string3 != null && string3.length() >= string2.length()) {
                        string2 = String.valueOf('+') + string3;
                    }
                    if (string2.length() > 32) {
                        string2 = "";
                        break;
                    }
                    ++n5;
                }
                hashMap.put(n2, string2);
                return string2;
            }
            if (n3 > n2 && n >= n2) {
                String string4 = "-";
                n5 = n3;
                while (n5 > n2) {
                    String string5 = Z80Disassembler.getAnonymousLabel(n3, n5, map, hashMap);
                    if (string5 != null && string5.length() >= string4.length()) {
                        string4 = String.valueOf('-') + string5;
                    }
                    if (string4.length() > 32) {
                        string4 = "";
                        break;
                    }
                    --n5;
                }
                hashMap.put(n2, string4);
                return string4;
            }
        }
        hashMap.put(n2, "");
        return null;
    }

    private static String getLabel(int n, util.map.Map<List<Symbols.Symbol>> map) {
        return Z80Disassembler.getLabel(n, -1, map);
    }

    private static String getLabel(int n, int n2, util.map.Map<List<Symbols.Symbol>> map) {
        Symbols.Symbol symbol;
        Symbols.Symbol symbol2 = symbol = n2 < 0 ? Symbols.findSymbol(n, map) : Z80Disassembler.findSymbol(n, n2, map);
        if (symbol != null) {
            return symbol.getLabel();
        }
        if (!Z80Disassembler.isCode(n)) {
            return null;
        }
        if (!USE_ANONYMOUS_LABELS || !seen.containsKey(n) || tableEntrySeen.containsKey(n)) {
            return String.format(FORMAT_CODE_LABEL, n);
        }
        String string = Z80Disassembler.getAnonymousLabel(n, map);
        if (string != null) {
            return string;
        }
        return String.format(FORMAT_CODE_LABEL, n);
    }

    private static String injectSymbols(int n, Z80Instruction z80Instruction, String string, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, util.map.Map<String> map2) {
        int n2;
        String string2 = z80Instruction.toString();
        if (USE_UPPERCASE_MNEMONICS) {
            string2 = string2.toUpperCase();
        }
        if (PAD_MNEMONICS && (n2 = string2.indexOf(32)) >= 0 && n2 < 5) {
            string2 = String.valueOf(String.format("%-5s", string2.substring(0, n2))) + string2.substring(n2 + 1);
        }
        if (dialect.requiresSquareBrackets()) {
            string2 = string2.replace('(', '[').replace(')', ']');
        }
        if (string != null) {
            string2 = String.valueOf(string2) + " " + string;
        }
        if (z80Instruction.hasArg()) {
            n2 = z80Instruction.getArg();
            if ((z80Instruction.getOpCode() & 0xFFC7) == 0) {
                String string3;
                if (Z80Disassembler.hasLabel(n + z80Instruction.getSize() + n2)) {
                    int n3 = n + z80Instruction.getSize() + n2;
                    return Z80Disassembler.replace(string2, Integer.toString(n2), Z80Disassembler.getLabel(n3, map));
                }
                if (dialect.requiresAbsoluteAddressesForRelativeBranches() && (string3 = dialect.getCurrentAddressSymbol()) != null) {
                    return Z80Disassembler.replace(string2, Integer.toString(n2), n2 + 2 == 0 ? string3 : String.valueOf(string3) + (n2 + 2 < 0 ? " - " + -(n2 + 2) : " + " + (n2 + 2)));
                }
                return string2;
            }
            if (n2 < 0) {
                return string2;
            }
            if (z80Instruction.isBranch()) {
                return Z80Disassembler.injectBranchSymbol(n, string2, n2, ramRomMap, map);
            }
            if (z80Instruction.getArgSize() == 2) {
                return Z80Disassembler.injectWordSymbol(n, string2, n2, ramRomMap, map, bitSet, bitSet2, bitSet3, map2);
            }
            return instance.injectByteSymbol(n, z80Instruction, string2, n2, ramRomMap, map, map2);
        }
        if ((z80Instruction.getOpCode() & 0xFFC7) == 199 && Z80Disassembler.hasLabel(z80Instruction.getOpCode() - 199)) {
            Symbols.Symbol symbol = Z80Disassembler.findSymbol(z80Instruction.getOpCode() - 199 & 0xFF, 0, map);
            if (symbol != null) {
                return String.valueOf(string2) + "\t; " + symbol.getLabel();
            }
            if (z80Instruction.getOpCode() == 199 && !instance.allowRST0H() || z80Instruction.getOpCode() == 255 && !instance.allowRST38H()) {
                return String.valueOf(string2) + "\t; Possibly invalid";
            }
            return String.valueOf(string2) + "\t; " + String.format(FORMAT_CODE_LABEL, z80Instruction.getOpCode() - 199);
        }
        return string2;
    }

    private static String injectBranchSymbol(int n, String string, int n2, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map) {
        int n3 = n2;
        if (instance.isROMaddress(n3, Z80Disassembler.isSRAMenabled(n))) {
            dummyCartridge.setBank0(Z80Disassembler.getBank0(n).getMin());
            dummyCartridge.setBank1(Z80Disassembler.getBank1(n).getMin());
            dummyCartridge.setBank2(Z80Disassembler.getBank2(n).getMin());
            dummyCartridge.setBank3(Z80Disassembler.getBank3(n).getMin());
            n3 = dummyCartridge.mapAddress(n3);
            if (Z80Disassembler.hasLabel(n3)) {
                return Z80Disassembler.replace(string, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF], Z80Disassembler.getLabel(n3, map));
            }
            return String.valueOf(string) + "\t; Possibly invalid";
        }
        if (instance.isRAMaddress(n3)) {
            int n4;
            Symbols.Symbol symbol = Symbols.findRAMSymbol(n3, map);
            String string2 = symbol != null ? symbol.getLabel() : String.format(FORMAT_RAM_LABEL, n3);
            n3 = instance.mapRAMaddress(n3);
            if (symbol != null || ramSeen.containsKey(n3)) {
                string = Z80Disassembler.replace(string, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF], string2);
            }
            if ((n4 = ramRomMap.toRomAddress(n3)) != Integer.MIN_VALUE) {
                if (Z80Disassembler.hasLabel(n4)) {
                    if (msx) {
                        return Z80Disassembler.replace(string, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF], Z80Disassembler.getLabel(n4, map));
                    }
                    return String.valueOf(string) + "\t; Code is loaded from " + Z80Disassembler.getLabel(n4, map);
                }
                if (symbol != null && msx && dummyCartridge instanceof MSXDisk) {
                    return Z80Disassembler.replace(string, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF], string2);
                }
                return String.valueOf(Z80Disassembler.replace(string, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF], string2)) + "\t; Possibly invalid";
            }
            return String.valueOf(string) + "\t; Possibly invalid";
        }
        if (instance.isSRAMaddress(n3, Z80Disassembler.isSRAMenabled(n))) {
            int n5;
            n3 = instance.mapSRAMaddress(n3, Z80Disassembler.getSRAMbank(n).getMin());
            String string3 = String.format(FORMAT_SRAM_LABEL, n3);
            if (sramSeen.containsKey(n3)) {
                string = Z80Disassembler.replace(string, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF], string3);
            }
            if ((n5 = sramCode.get(n3)) != Integer.MIN_VALUE) {
                if (Z80Disassembler.hasLabel(n5)) {
                    return String.valueOf(string) + "\t; Code is loaded from " + Z80Disassembler.getLabel(n5, map);
                }
                return String.valueOf(string) + "\t; Possibly invalid";
            }
            return String.valueOf(string) + "\t; Possibly invalid";
        }
        return string;
    }

    private static String injectWordSymbol(int n, String string, int n2, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, util.map.Map<String> map2) {
        Object object;
        State state = DUMMY_STATE;
        state.setBank0(Z80Disassembler.getBank0(n));
        state.setBank1(Z80Disassembler.getBank1(n));
        if (instance.hasBank2()) {
            state.setBank2(Z80Disassembler.getBank2(n));
        }
        if (instance.hasBank3()) {
            state.setBank3(Z80Disassembler.getBank3(n));
        }
        state.setSRAMenabled(Z80Disassembler.isSRAMenabled(n));
        state.setSRAMbank(Z80Disassembler.getSRAMbank(n));
        if (instance.isROMaddress(n2, state)) {
            int n3;
            int n4;
            int n5;
            object = Value.newUnknownValue(255);
            if (instance.isROMaddress(n2, Z80Disassembler.isSRAMenabled(n))) {
                if (n2 >= dummyCartridge.getBankSize() * 3) {
                    if (!instance.hasBank3()) {
                        return string;
                    }
                    object = Z80Disassembler.getBank3(n);
                } else if (n2 >= dummyCartridge.getBankSize() * 2) {
                    if (!instance.hasBank2()) {
                        return string;
                    }
                    object = Z80Disassembler.getBank2(n);
                } else {
                    object = n2 >= dummyCartridge.getBankSize() ? Z80Disassembler.getBank1(n) : Z80Disassembler.getBank0(n);
                }
            }
            String string2 = String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF];
            int n6 = ((Value)object).getMin() != 0 ? dummyCartridge.mapAddress(n2, ((Value)object).getMin()) : n2;
            int n7 = bitSet.nextSetBit(Math.max(0, n6 - 3));
            if (n7 >= 0) {
                n5 = Z80Disassembler.floorKey(bitSet, n7, n6);
                if (n5 <= n6 && !Z80Disassembler.isCode(n5) && (n4 = (n6 & 0x3FFF) - (n5 & 0x3FFF)) >= 0) {
                    Symbols.Symbol symbol;
                    Symbols.Symbol symbol2 = symbol = ((Value)object).getMin() != 0 ? Z80Disassembler.findSymbol(n2 - n4, ((Value)object).getMin(), map) : Symbols.findSymbol(n2 - n4, map);
                    if (n4 == 0) {
                        return String.valueOf(Z80Disassembler.replace(string, string2, symbol.getLabel())) + "\t; " + symbol.getLabel() + " =" + HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8] + HexStrings.HEX_STRINGS[n2 & 0xFF];
                    }
                    return String.valueOf(Z80Disassembler.replace(string, string2, String.valueOf(symbol.getLabel()) + " + " + n4)) + "\t; " + symbol.getLabel() + " + " + n4 + " =" + HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8] + HexStrings.HEX_STRINGS[n2 & 0xFF];
                }
                int n8 = n4 = n7 > n6 ? n7 : bitSet.nextSetBit(n6 + 1) & Integer.MAX_VALUE;
                if (n4 <= n6 + 3 && !Z80Disassembler.isCode(n4) && (n3 = (n4 & 0x3FFF) - (n6 & 0x3FFF)) >= 0) {
                    Symbols.Symbol symbol = ((Value)object).getMin() != 0 ? Z80Disassembler.findSymbol(n2 + n3, ((Value)object).getMin(), map) : Symbols.findSymbol(n2 + n3, map);
                    return String.valueOf(Z80Disassembler.replace(string, string2, String.valueOf(symbol.getLabel()) + " - " + n3)) + "\t; " + symbol.getLabel() + " - " + n3 + " =" + HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8] + HexStrings.HEX_STRINGS[n2 & 0xFF];
                }
            }
            if ((n5 = bitSet3.nextSetBit(Math.max(0, n6 - 2))) >= 0) {
                int n9;
                int n10 = n4 = n5 >= n6 ? n5 : bitSet3.nextSetBit(n6) & Integer.MAX_VALUE;
                if (n4 <= n6 + 3 && (n3 = (n4 & 0x3FFF) - (n6 & 0x3FFF)) >= 0 && instance.isROMaddress(n2 + n3, state) && Z80Disassembler.isDataSeen(n2 + n3, ramRomMap, state, n)) {
                    if (n3 == 0) {
                        return Z80Disassembler.replace(string, string2, String.format(FORMAT_DATA_LABEL, n6));
                    }
                    return Z80Disassembler.replace(string, string2, String.format(String.valueOf(FORMAT_DATA_LABEL) + " - " + n3, Z80Disassembler.RESOLVE_ADDRESS(n2 + n3, ramRomMap, state)));
                }
                n3 = Z80Disassembler.floorKey(bitSet3, n5, n6 - 1);
                if (n3 < n6 && instance.isROMaddress(n2 + (n9 = n6 - n3), state) && Z80Disassembler.isDataSeen(n2 - n9, ramRomMap, state, n)) {
                    return Z80Disassembler.replace(string, string2, String.format(String.valueOf(FORMAT_DATA_LABEL) + " + " + n9, Z80Disassembler.RESOLVE_ADDRESS(n2 - n9, ramRomMap, state)));
                }
            }
            if (Z80Disassembler.isSeen(n2, ramRomMap, state, n)) {
                return String.valueOf(Z80Disassembler.replace(string, string2, Z80Disassembler.getLabel(Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, state), ((Value)object).getMin(), map))) + (overridingRet.get(n) ? "\t; Overriding return address" : (ramRomMap.toRamAddress(Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, state)) != Integer.MIN_VALUE && Z80Disassembler.hasLabel(Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, state)) ? "\t; Loading Code into RAM" : ""));
            }
        } else {
            object = String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF];
            if (instance.isRAMaddress(n2)) {
                int n11;
                int n12 = bitSet2.nextSetBit(Math.max(0, n2 - 3));
                if (n12 >= 0 && (n11 = Z80Disassembler.floorKey(bitSet2, n12, n2)) <= n2) {
                    Symbols.Symbol symbol = Symbols.findRAMSymbol(n11, map);
                    if (symbol != null) {
                        if (n11 == n2) {
                            return String.valueOf(Z80Disassembler.replace(string, (String)object, symbol.getLabel())) + "\t; " + symbol.getLabel() + " =" + HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8] + HexStrings.HEX_STRINGS[n2 & 0xFF];
                        }
                        int n13 = n2 - n11;
                        return String.valueOf(Z80Disassembler.replace(string, (String)object, String.valueOf(symbol.getLabel()) + " + " + n13)) + "\t; " + symbol.getLabel() + " + " + n13 + " =" + HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8] + HexStrings.HEX_STRINGS[n2 & 0xFF];
                    }
                    System.err.println("Missing symbol for floorSymbolKey at " + Integer.toHexString(n11));
                }
                if (Z80Disassembler.isRAMseen(instance.mapRAMaddress(n2), n)) {
                    if (instance.isMirrorAddress(n2)) {
                        n11 = instance.mapMirrorAddress(n2);
                        return Z80Disassembler.replace(string, (String)object, String.format("$%04X | " + FORMAT_RAM_LABEL, n2 ^ n11, n11));
                    }
                    return Z80Disassembler.replace(string, (String)object, String.format(FORMAT_RAM_LABEL, n2));
                }
                if (instance.isRAMaddress(n2 - 1) && Z80Disassembler.isRAMseen(instance.mapRAMaddress(n2 - 1), n)) {
                    if (instance.isMirrorAddress(n2 - 1)) {
                        n11 = instance.mapMirrorAddress(n2 - 1);
                        return String.valueOf(Z80Disassembler.replace(string, (String)object, String.format("$%04X | " + FORMAT_RAM_LABEL, n2 - 1 ^ n11, n11))) + " + 1";
                    }
                    return String.valueOf(Z80Disassembler.replace(string, (String)object, String.format(FORMAT_RAM_LABEL, n2 - 1))) + " + 1";
                }
                return string;
            }
            if (instance.isSRAMaddress(n2, state) && Z80Disassembler.isSRAMseen(n2, state, n)) {
                return Z80Disassembler.replace(string, (String)object, String.format(FORMAT_SRAM_LABEL, instance.mapSRAMaddress(n2, Z80Disassembler.getSRAMbank(n).getMin())));
            }
            if (instance.isSRAMaddress(n2 + 1, state) && Z80Disassembler.isSRAMseen(n2 - 1, state, n)) {
                return String.valueOf(Z80Disassembler.replace(string, (String)object, String.format(FORMAT_SRAM_LABEL, instance.mapSRAMaddress(n2 - 1, Z80Disassembler.getSRAMbank(n).getMin())))) + " + 1";
            }
        }
        if (string.contains(HexStrings.PREFIXED_HEX_STRINGS[n2 & 0xFF].substring(2)) && Z80Disassembler.isPortSeen(n2 & 0xFF, n)) {
            String string3;
            object = String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + HexStrings.HEX_STRINGS[n2 & 0xFF];
            int n14 = n2 & 0xFF;
            String string4 = string3 = Z80Disassembler.isPortRead(n14, n) ? map2.get(-n14) : map2.get(n14);
            if (string3 != null) {
                return Z80Disassembler.replace(string, (String)object, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + "00 | " + string3);
            }
            return Z80Disassembler.replace(string, (String)object, String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n2 >> 8].substring(1)) + "00 | " + String.format(FORMAT_PORT_LABEL, n14));
        }
        return string;
    }

    private static int floorKey(BitSet bitSet, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = bitSet.nextSetBit(n3 + 1);
            if (n4 < 0 || n4 > n2) {
                return n3;
            }
            n3 = n4;
        }
        return n3;
    }

    protected String injectByteSymbol(int n, Z80Instruction z80Instruction, String string, int n2, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map, util.map.Map<String> map2) {
        Z80Instruction z80Instruction2;
        if (Z80Disassembler.isPortSeen(n2, n)) {
            String string2;
            String string3 = string2 = Z80Disassembler.isPortRead(n2, n) ? map2.get(-n2) : map2.get(n2);
            if (string2 != null) {
                return Z80Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), string2);
            }
            return Z80Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), String.format(FORMAT_PORT_LABEL, n2));
        }
        int n3 = dataSeenPartial.get(n);
        if (n3 != Integer.MIN_VALUE && (z80Instruction2 = Z80Disassembler.getInstruction(n3)) != null) {
            boolean bl;
            int n4 = z80Instruction.getDisplacement() > z80Instruction2.getDisplacement() ? n2 << 8 | z80Instruction2.getArg() : z80Instruction2.getArg() << 8 | n2;
            int n5 = 0;
            if (instance.isROMaddress(n4, Z80Disassembler.isSRAMenabled(n))) {
                if (n4 >= dummyCartridge.getBankSize() * 3) {
                    if (!instance.hasBank3()) {
                        return string;
                    }
                    n5 = Z80Disassembler.getBank3(n).getMin();
                } else if (n4 >= dummyCartridge.getBankSize() * 2) {
                    if (!instance.hasBank2()) {
                        return string;
                    }
                    n5 = Z80Disassembler.getBank2(n).getMin();
                } else {
                    n5 = n4 >= dummyCartridge.getBankSize() ? Z80Disassembler.getBank1(n).getMin() : Z80Disassembler.getBank0(n).getMin();
                }
            }
            State state = DUMMY_STATE;
            state.setBank0(Z80Disassembler.getBank0(n));
            state.setBank1(Z80Disassembler.getBank1(n));
            if (instance.hasBank2()) {
                state.setBank2(Z80Disassembler.getBank2(n));
            }
            if (instance.hasBank3()) {
                state.setBank3(Z80Disassembler.getBank3(n));
            }
            state.setSRAMenabled(Z80Disassembler.isSRAMenabled(n));
            state.setSRAMbank(Z80Disassembler.getSRAMbank(n));
            ArrayIntDeque arrayIntDeque = new ArrayIntDeque();
            if (instance.isROMaddress(n4, state)) {
                int n6 = 0;
                while (n6 < slots.length) {
                    if (n4 >= dummyCartridge.getBankSize() * 3) {
                        state.setBank3(new Value(n6));
                    } else if (n4 >= dummyCartridge.getBankSize() * 2) {
                        state.setBank2(new Value(n6));
                    } else if (n4 >= dummyCartridge.getBankSize()) {
                        state.setBank1(new Value(n6));
                    } else {
                        state.setBank0(new Value(n6));
                    }
                    if (Z80Disassembler.isSeen(n4, ramRomMap, state, n) || Z80Disassembler.isDataSeen(n4, ramRomMap, state, n) || instance.isROMaddress(n4 + 1, state) && (Z80Disassembler.isDataSeen(n4 + 1, ramRomMap, state, n) || instance.isROMaddress(n4 + 2, state) && (Z80Disassembler.isDataSeen(n4 + 2, ramRomMap, state, n) || instance.isROMaddress(n4 + 3, state) && Z80Disassembler.isDataSeen(n4 + 3, ramRomMap, state, n)))) {
                        arrayIntDeque.add(n6);
                    }
                    ++n6;
                }
                if (!arrayIntDeque.isEmpty() && !arrayIntDeque.contains(n5)) {
                    n5 = arrayIntDeque.getFirst();
                }
            }
            if (n4 >= dummyCartridge.getBankSize() * 3) {
                state.setBank3(new Value(n5));
            } else if (n4 >= dummyCartridge.getBankSize() * 2) {
                state.setBank2(new Value(n5));
            } else if (n4 >= dummyCartridge.getBankSize()) {
                state.setBank1(new Value(n5));
            } else {
                state.setBank0(new Value(n5));
            }
            Symbols.Symbol symbol = null;
            if (Z80Disassembler.getRomBank(n4) != n5 || !Z80Disassembler.isCode(n4)) {
                symbol = Z80Disassembler.findSymbol(n4, n5, map);
            }
            boolean bl2 = bl = n2 == (n4 & 0xFF);
            if (symbol != null) {
                String string4 = bl ? dialect.getLowByte(symbol.getLabel()) : dialect.getHighByte(symbol.getLabel());
                return String.valueOf(Z80Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), string4)) + "\t; " + string4 + " =" + HexStrings.PREFIXED_HEX_STRINGS[n2];
            }
            if (instance.isROMaddress(n4, state) && Z80Disassembler.isDataSeen(n4, ramRomMap, state, n)) {
                String string5 = bl ? dialect.getLowByte(FORMAT_DATA_LABEL) : dialect.getHighByte(FORMAT_DATA_LABEL);
                return Z80Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), String.format(string5, Z80Disassembler.RESOLVE_ADDRESS(n4, ramRomMap, state)));
            }
        }
        return string;
    }

    protected static Symbols.Symbol findSymbol(int n, int n2, util.map.Map<List<Symbols.Symbol>> map) {
        return Symbols.findSymbol(n, n2, dummyCartridge, map);
    }

    protected static String replace(String string, String string2, String string3) {
        if (string3 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
    }

    protected int[] getEntryPoints() {
        if (msx) {
            return msxEntryPoints;
        }
        return ENTRY_POINTS;
    }

    protected int getMaxEntryPoint() {
        if (msx) {
            return this.getEntryPoints().length > 0 ? this.getEntryPoints()[0] : -1;
        }
        return ENTRY_POINTS[2];
    }

    protected boolean allowRST0H() {
        return false;
    }

    protected boolean allowRST38H() {
        return false;
    }

    protected boolean hasBank2() {
        return true;
    }

    protected boolean hasBank3() {
        return msx;
    }

    protected int getDefaultSlot() {
        return 2;
    }

    protected int mapRAMaddress(int n) {
        if (msx) {
            return n ^ 0xC000;
        }
        return n < 65528 ? n & 0x1FFF : n;
    }

    protected boolean isMirrorAddress(int n) {
        return !msx && n >= 57344 && n < 65528;
    }

    protected int mapMirrorAddress(int n) {
        return n ^ 0x2000;
    }

    protected int mapSRAMaddress(int n, State state) {
        return this.mapSRAMaddress(n, state.getSRAMbank().getMin());
    }

    protected int mapSRAMaddress(int n, int n2) {
        return n2 * 16384 | n & 0x3FFF;
    }

    protected int mapPortAddress(int n) {
        return n;
    }

    protected boolean isROMaddress(int n, boolean bl) {
        dummyCartridge.setSRAMenabled(bl);
        return n >= 0 && dummyCartridge.isROMaddress(n);
    }

    protected boolean isROMaddress(int n, State state) {
        return this.isROMaddress(n, state.isSRAMenabled());
    }

    private boolean isROMaddress(Value value, State state) {
        return this.isROMaddress(value.getMin(), state);
    }

    protected boolean isRAMaddress(int n) {
        return msx && dummyCartridge instanceof MSXDisk || n >= 49152;
    }

    private boolean isRAMaddress(Value value) {
        if (value instanceof Address) {
            return Z80Disassembler.isRAMaddress((Address)value);
        }
        return this.isRAMaddress(value.getMin());
    }

    private static boolean isRAMaddress(Address address) {
        return address.isRamAddress();
    }

    protected boolean isSRAMaddress(int n, boolean bl) {
        dummyCartridge.setSRAMenabled(bl);
        return dummyCartridge.isSRAMaddress(n);
    }

    protected boolean isSRAMaddress(int n, State state) {
        return this.isSRAMaddress(n, state.isSRAMenabled());
    }

    private boolean isSRAMaddress(Value value, State state) {
        return this.isSRAMaddress(value.getMin(), state);
    }

    protected boolean isPortAddress(int n) {
        return false;
    }

    private boolean isPortAddress(Value value) {
        return this.isPortAddress(value.getMin());
    }

    private boolean isBiosAddress(int n, State state) {
        if (!msx) {
            return false;
        }
        if (dummyCartridge instanceof MSXDisk) {
            return n < 256;
        }
        return msx && !this.isRAMaddress(n) && !this.isROMaddress(n, state) && n < 16384;
    }

    private void analyze(int[] nArray, RamRomMap ramRomMap, File file, boolean bl, boolean bl2) {
        int n;
        Object object;
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        sourceMap = null;
        ERROR_STREAM = bl2 ? System.err : NIRVANA;
        ALLOW_CALLS_TO_UNKNOWN_RAM = bl;
        seen = new HashMap();
        dataSeen = new HashMap();
        ramSeen = new HashMap();
        sramSeen = new HashMap();
        portSeen = new HashMap();
        path = new HashMap();
        dataSeenPartial = new HashIntMap();
        ramSizes = new HashIntMap();
        sramSizes = new HashIntMap();
        ramCode = new HashIntBiMap();
        sramCode = new HashIntMap();
        tableEntrySeen = new HashIntMap();
        dataSeenExact = new BitSet();
        overridingRet = new BitSet();
        badCode = new BitSet();
        labels = new BitSet();
        code = new byte[nArray.length];
        instructions = new HashMap();
        indexMinValues = new int[msx || instance instanceof LR35902Disassembler ? 65536 : 8192];
        instructionStart = new BitSet();
        memoryJump = new BitSet();
        memoryTableRead = new BitSet();
        memoryTableReadRead = new BitSet();
        entriesOfTablePointToTables = new HashMap();
        entriesOfTablePointToTablesOfPointerTables = new BitSet();
        entriesOfTablePointToTablesOfTablesOfPointerTables = new HashMap();
        entriesOfTablePointToTablesOfJumpTables = new BitSet();
        entriesOfTablePointToJumpTables = new BitSet();
        memoryPointers = new HashMap();
        memoryPointerStates = new HashMap();
        memoryTables = new HashMap();
        memoryJumps = new HashMap();
        ramCodeWrites = new HashMap();
        jumpTables = new TreeSet();
        pointerTables = new TreeSet();
        functionPointers = new BitSet();
        bank0 = new HashMap();
        bank1 = new HashMap();
        bank2 = new HashMap();
        bank3 = new HashMap();
        sramEnabled = new BitSet();
        sramBank = new HashMap();
        dataBlocks = new ArrayList();
        retAddresses = new ArrayIntDeque();
        Z80Disassembler z80Disassembler = Z80Disassembler.getInstance();
        if (z80Disassembler instanceof LR35902Disassembler) {
            dummyCartridge = new GBCartridge(nArray){

                @Override
                protected void enableShutdownHook() {
                }

                @Override
                protected void writeRAMtoFile() {
                }

                @Override
                protected boolean readRAMfromFile() {
                    return false;
                }
            };
            if (code.length >= 336) {
                Arrays.fill(code, 260, 307, (byte)-128);
                Arrays.fill(code, 327, 336, (byte)-128);
            }
        } else if (msx) {
            object = nArray.length == 737280 || nArray.length / 2 == 737280 ? new MSXDisk(nArray){

                @Override
                protected void enableShutdownHook() {
                }

                @Override
                protected void writeRAMtoFile() {
                }

                @Override
                protected boolean readRAMfromFile() {
                    return false;
                }

                @Override
                public boolean isROMaddress(int n) {
                    return false;
                }
            } : new MSXCartridge(nArray){

                @Override
                protected void enableShutdownHook() {
                }

                @Override
                protected void writeRAMtoFile() {
                }

                @Override
                protected boolean readRAMfromFile() {
                    return false;
                }
            };
            dummyCartridge = object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (((MSXCartridge)object).getInitAddress() > 0 && ((MSXCartridge)object).isROMaddress(((MSXCartridge)object).getInitAddress())) {
                arrayList.add(((MSXCartridge)object).getInitAddress());
            }
            if (((MSXCartridge)object).getStatementAddress() > 0 && ((MSXCartridge)object).isROMaddress(((MSXCartridge)object).getStatementAddress())) {
                arrayList.add(((MSXCartridge)object).getStatementAddress());
            }
            if (((MSXCartridge)object).getDeviceAddress() > 0 && ((MSXCartridge)object).isROMaddress(((MSXCartridge)object).getDeviceAddress())) {
                arrayList.add(((MSXCartridge)object).getDeviceAddress());
            }
            if (((MSXCartridge)object).getTextAddress() > 0 && ((MSXCartridge)object).isROMaddress(((MSXCartridge)object).getTextAddress())) {
                arrayList.add(((MSXCartridge)object).getTextAddress());
            }
            msxEntryPoints = new int[arrayList.size()];
            n = 0;
            while (n < msxEntryPoints.length) {
                Z80Disassembler.msxEntryPoints[n] = (Integer)arrayList.get(n);
                ++n;
            }
        } else {
            dummyCartridge = new SMSCartridge(nArray){

                @Override
                protected void enableShutdownHook() {
                }

                @Override
                protected void writeRAMtoFile() {
                }

                @Override
                protected boolean readRAMfromFile() {
                    return false;
                }
            };
            object = (SMSCartridge)dummyCartridge;
            if (nArray.length >= 32768) {
                if (((SMSCartridge)object).hasSEGAbranding()) {
                    Arrays.fill(code, 32752, 32768, (byte)-128);
                    Z80Disassembler.code[32760] = 0;
                    Z80Disassembler.code[32761] = 0;
                }
                if (nArray[32736] == 83 && nArray[32737] == 68 && nArray[32738] == 83 && nArray[32739] == 67) {
                    Arrays.fill(code, 32736, 32752, (byte)-128);
                }
            }
        }
        abort = false;
        slots = new int[Z80Disassembler.getRomBank(nArray.length - 1) + 1];
        Arrays.fill(slots, z80Disassembler.getDefaultSlot());
        Z80Disassembler.slots[0] = 0;
        if (slots.length > 1) {
            Z80Disassembler.slots[1] = 1;
        }
        if (file != null) {
            z80Disassembler.loadConfig(nArray, ramRomMap, file);
        }
        try {
            int n2;
            BitSet bitSet;
            object = new State();
            int[] object22 = this.getEntryPoints();
            int n3 = object22.length;
            n = 0;
            while (n < n3) {
                int n4 = object22[n];
                if (Z80Disassembler.RESOLVE_ADDRESS(n4, ramRomMap, (State)object) < nArray.length) {
                    ArrayIntDeque arrayIntDeque;
                    if (n4 == 102) {
                        if (!Z80Disassembler.isCode(102)) {
                            arrayIntDeque = new ArrayIntDeque();
                            if (!this.analyze(nArray, ramRomMap, 102, 102, 0, (State)object, new ArrayIntDeque())) {
                                Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                            }
                        }
                    } else {
                        arrayIntDeque = new ArrayIntDeque();
                        if (!this.analyze(nArray, ramRomMap, n4, n4, 0, (State)object, arrayIntDeque)) {
                            if (this.isEntryPointOptional(n4)) {
                                Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                            } else {
                                ERROR_STREAM.println("Failed to disassemble from entry point at " + Integer.toHexString(n4) + ".");
                            }
                        }
                    }
                }
                ++n;
            }
            if (msx) {
                Value value;
                Value value2 = ((State)object).getRAMvalue(64922);
                if (value2.isUnique() && value2.getMin() == 195) {
                    int n5;
                    Value value3 = ((State)object).getRAMvalue(64923);
                    Value value4 = ((State)object).getRAMvalue(64924);
                    if (value3.isUnique() && value4.isUnique() && !this.analyze(nArray, ramRomMap, n5 = value4.getMin() << 8 | value3.getMin(), n5, 0, (State)object, new ArrayIntDeque())) {
                        ERROR_STREAM.println("Failed to disassemble from entry point at " + Integer.toHexString(n5) + ".");
                    }
                }
                if ((value = ((State)object).getRAMvalue(64927)).isUnique() && value.getMin() == 195) {
                    int n4;
                    Value value5 = ((State)object).getRAMvalue(64928);
                    Value n7 = ((State)object).getRAMvalue(64929);
                    if (value5.isUnique() && n7.isUnique() && !this.analyze(nArray, ramRomMap, n4 = n7.getMin() << 8 | value5.getMin(), n4, 0, (State)object, new ArrayIntDeque())) {
                        ERROR_STREAM.println("Failed to disassemble from entry point at " + Integer.toHexString(n4) + ".");
                    }
                }
            }
            this.analyzeJumpTables(nArray, ramRomMap);
            do {
                bitSet = functionPointers;
                functionPointers = (BitSet)functionPointers.clone();
                n2 = functionPointers.nextSetBit(0);
                while (n2 >= 0) {
                    ArrayIntDeque arrayIntDeque;
                    n3 = 0;
                    for (Table table : jumpTables) {
                        if (n2 < table.start || n2 >= table.end) continue;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 0) {
                        for (Table table : memoryTables.values()) {
                            if (n2 < table.start || n2 >= table.end) continue;
                            n3 = 1;
                            break;
                        }
                    }
                    if (!Z80Disassembler.isCode(n2) && n3 == 0 && !this.analyze(nArray, ramRomMap, n2, n2, n2, new State(), arrayIntDeque = new ArrayIntDeque())) {
                        Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                    }
                    n2 = functionPointers.nextSetBit(n2 + 1);
                }
            } while (!functionPointers.equals(bitSet));
            this.analyzeTables(nArray, ramRomMap);
            int[] nArray2 = dataSeen.keySet();
            int n5 = nArray2.length;
            n3 = 0;
            while (n3 < n5) {
                n2 = nArray2[n3];
                if (Z80Disassembler.isCode(n2)) {
                    dataSeen.remove(n2);
                }
                for (Table table : jumpTables) {
                    if (n2 <= table.start || n2 >= table.end) continue;
                    dataSeen.remove(n2);
                }
                for (Table table : pointerTables) {
                    if (n2 <= table.start || n2 >= table.end) continue;
                    dataSeen.remove(n2);
                }
                ++n3;
            }
            for (Map.Entry<IntHashSet> entry : new HashSet<Map.Entry<IntHashSet>>(portSeen.entrySet())) {
                IntHashSet intHashSet = entry.getValue();
                int[] nArray3 = intHashSet.keys();
                int n6 = nArray3.length;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = nArray3[n7];
                    if (!Z80Disassembler.isInstruction(n8)) {
                        intHashSet.remove(n8);
                        if (intHashSet.isEmpty()) {
                            portSeen.remove(entry.getKey());
                        }
                    }
                    ++n7;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void analyzeTables(int[] nArray, RamRomMap ramRomMap) {
        Z80Disassembler.analyzeRamCodeWrites(nArray, ramRomMap);
        Z80Disassembler.analyzeMemoryJumps(nArray, ramRomMap);
        this.analyzeJumpTables(nArray, ramRomMap);
        int n = jumpTables.size();
        Z80Disassembler.analyzePointerTables(nArray, ramRomMap);
        int n2 = 0;
        while (jumpTables.size() != n && n2 < 10) {
            n = jumpTables.size();
            int n3 = pointerTables.size();
            this.analyzeJumpTables(nArray, ramRomMap);
            if (pointerTables.size() != n3) {
                Z80Disassembler.analyzePointerTables(nArray, ramRomMap);
                ++n;
            }
            ++n2;
        }
    }

    public static void printStatistics() {
        for (Table table : jumpTables) {
            if (table.end <= table.start) continue;
            System.out.println(table);
        }
        for (Table table : jumpTables) {
            if (table.end <= table.start) continue;
            System.out.print(String.format(", { 0x%x, %d }", table.start, (table.end - table.start) / 2));
        }
        System.out.println();
        System.out.println(String.valueOf(jumpTables.size()) + " jump tables found!");
        for (Table table : pointerTables) {
            if (table.end <= table.start) continue;
            System.out.print(String.format(", { 0x%x, %d }", table.start, (table.end - table.start) / 2));
        }
        System.out.println();
        System.out.println(String.valueOf(pointerTables.size()) + " pointer tables found!");
        for (Table table : pointerTables) {
            if (table.end <= table.start) continue;
            System.out.println(table);
        }
        int n = functionPointers.nextSetBit(0);
        while (n >= 0) {
            System.out.print(String.valueOf(Integer.toHexString(n)) + " ");
            n = functionPointers.nextSetBit(n + 1);
        }
        System.out.println();
        System.out.println(String.valueOf(functionPointers.cardinality()) + " function pointers found!");
    }

    public static boolean checkOverlap(PrintStream printStream) {
        boolean bl = false;
        for (Table table : jumpTables) {
            for (Table table2 : jumpTables) {
                if (table == table2 || table.end <= table2.start || table2.end <= table.start) continue;
                bl = true;
                printStream.println("Jump Table " + table2 + " overlaps with " + table);
            }
        }
        for (Table table : pointerTables) {
            for (Table table2 : pointerTables) {
                if (table == table2 || table.end <= table2.start || table2.end <= table.start) continue;
                bl = true;
                printStream.println("Pointer Table " + table2 + " overlaps with " + table);
            }
        }
        if (bl) {
            printStream.println();
        }
        return bl;
    }

    private static boolean hasVisitedEntryAt(Table table, int[] nArray, RamRomMap ramRomMap, int n) {
        try {
            return tableEntrySeen.containsKey(Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n), ramRomMap, table.state));
        }
        catch (ResolveAddressException resolveAddressException) {
            return true;
        }
    }

    private void analyzeJumpTables(int[] nArray, RamRomMap ramRomMap) {
        this.analyzeJumpTables(nArray, ramRomMap, null, Math.max(nArray.length, 0x800000));
    }

    private void analyzeJumpTables(int[] nArray, RamRomMap ramRomMap, IntDeque intDeque, int n) {
        BitSet bitSet = new BitSet();
        int n2 = 0;
        boolean bl = false;
        int n3 = jumpTables.size();
        while (n3 != n2 || bl) {
            if (abort) {
                throw new AbortException("Abort by user.");
            }
            bl = false;
            n2 = n3;
            block3: for (Table object : new ArrayList<Table>(jumpTables)) {
                int n4;
                Z80Instruction z80Instruction;
                if (bl) break;
                RegisterPair[] registerPairArray = object.state.getRegPairs();
                int n5 = 1;
                int n6 = 2;
                int n7 = 2;
                if (registerPairArray[0].getSource() != null && registerPairArray[0].getSource().getMin() == object.start) {
                    n7 = 0;
                }
                if (registerPairArray[1].getSource() != null && registerPairArray[1].getSource().getMin() == object.start) {
                    n7 = 1;
                }
                if (registerPairArray[2].getSource() != null && registerPairArray[2].getSource().getMin() == object.start) {
                    n7 = 2;
                }
                if (registerPairArray[n7].getSource() != null && registerPairArray[n7].getSource().getMin() > 0) {
                    n5 = registerPairArray[n7].getSource().getMin();
                    if (registerPairArray[n7].getSource().getMultiplier() == 3) {
                        n6 = registerPairArray[n7].getSource().getMultiplier();
                    }
                }
                if ((z80Instruction = Z80Disassembler.getInstruction(n5)) == null || z80Instruction.getOpCode() != 33 || this.isRAMaddress(z80Instruction.getArg())) {
                    int n8;
                    n4 = object.start;
                    while (n4 < object.end && Z80Disassembler.isCode(n4)) {
                        n4 += n6;
                    }
                    if (object.start != n4) {
                        Table n9 = null;
                        Z80Disassembler.removeTable(jumpTables, object);
                        if (object.end > n4) {
                            n9 = new Table(object, n4, object.end);
                            jumpTables.add(n9);
                            bl = true;
                        }
                        Z80Disassembler.cleanUpJumpTable(n9, object, nArray, ramRomMap);
                        break;
                    }
                    int table = object.end;
                    boolean bl2 = false;
                    int arrayIntDeque = object.end;
                    while (arrayIntDeque > object.start && Z80Disassembler.READ_WORD(nArray, arrayIntDeque - n6) <= 0) {
                        arrayIntDeque -= n6;
                    }
                    for (Table n11 : jumpTables) {
                        if (n11 == object) continue;
                        if (n11.start > object.start && arrayIntDeque > n11.start) {
                            n8 = object.start;
                            while (n8 < arrayIntDeque && Z80Disassembler.hasVisitedEntryAt(object, nArray, ramRomMap, n8)) {
                                n8 += n6;
                            }
                            if (n8 >= n11.end || object.end > n11.end && (n11.end - n11.start) * 2 < object.end - n11.end) {
                                Z80Disassembler.removeTable(jumpTables, n11);
                                break;
                            }
                            arrayIntDeque = n11.start - 1;
                            continue;
                        }
                        if (object.start != n11.start) continue;
                        if (object.indexedBy != null && object.indexedBy.equals(n11.indexedBy) && object.state.getBank1().equals(n11.state.getBank1())) {
                            if (object.end > n11.end) {
                                Z80Disassembler.removeTable(jumpTables, n11);
                                break;
                            }
                            if (object.end >= n11.end) break;
                            arrayIntDeque = n11.end - 1;
                            break;
                        }
                        if (object.end < n11.end) {
                            Z80Disassembler.removeTable(jumpTables, n11);
                            break;
                        }
                        if (object.end <= n11.end) break;
                        arrayIntDeque = object.start - 1;
                        break;
                    }
                    table = object.start;
                    while (table < object.end && !bl) {
                        arrayIntDeque = Math.min(arrayIntDeque, (labels.nextSetBit(object.start + 1) & Integer.MAX_VALUE) - 1);
                        table = table;
                        n8 = -1;
                        while (table < arrayIntDeque) {
                            table = Z80Disassembler.READ_WORD(nArray, table);
                            if (table != n8) {
                                int state;
                                n8 = table;
                                if (!this.isROMaddress(table, object.state)) {
                                    ERROR_STREAM.println("Non-ROM entry " + Integer.toHexString(Z80Disassembler.READ_WORD(nArray, table)) + " in " + object);
                                    break;
                                }
                                DUMMY_STATE.setBank0(object.state.getBank0());
                                DUMMY_STATE.setBank1(object.state.getBank1());
                                DUMMY_STATE.setBank2(object.state.getBank2());
                                DUMMY_STATE.setBank3(object.state.getBank3());
                                DUMMY_STATE.setSRAMenabled(object.state.isSRAMenabled());
                                DUMMY_STATE.setSRAMbank(object.state.getSRAMbank());
                                if (n6 == 3) {
                                    if (DUMMY_STATE.getBank1().getSource() != null && !DUMMY_STATE.getBank1().getSource().isUnique()) {
                                        DUMMY_STATE.setBank1(Z80Disassembler.READ_BYTE(nArray, ramRomMap, DUMMY_STATE.getBank1().getSource().newValue(DUMMY_STATE.getBank1().getSource().getMin() + table - object.start, DUMMY_STATE.getBank1().getSource().getMin() + table - object.start), DUMMY_STATE));
                                    }
                                    if (this.hasBank2() && DUMMY_STATE.getBank2().getSource() != null && !DUMMY_STATE.getBank2().getSource().isUnique()) {
                                        DUMMY_STATE.setBank2(Z80Disassembler.READ_BYTE(nArray, ramRomMap, DUMMY_STATE.getBank2().getSource().newValue(DUMMY_STATE.getBank2().getSource().getMin() + table - object.start, DUMMY_STATE.getBank2().getSource().getMin() + table - object.start), DUMMY_STATE));
                                    }
                                }
                                if (Z80Disassembler.isSubInstructionByte(state = Z80Disassembler.RESOLVE_ADDRESS(table, ramRomMap, DUMMY_STATE))) break;
                            }
                            table += n6;
                        }
                        if (table < object.end) {
                            Table table2 = null;
                            Z80Disassembler.removeTable(jumpTables, object);
                            if (table - object.start > 0) {
                                table2 = new Table(object, object.start, table);
                                jumpTables.add(table2);
                                bl = true;
                            }
                            Z80Disassembler.cleanUpJumpTable(table2, object, nArray, ramRomMap);
                            break;
                        }
                        table = Z80Disassembler.READ_WORD(nArray, table);
                        State state = object.state;
                        if (n6 == 3) {
                            state = new State(object.state);
                            if (state.getBank1().getSource() != null && !state.getBank1().getSource().isUnique()) {
                                state.setBank1(Z80Disassembler.READ_BYTE(nArray, ramRomMap, state.getBank1().getSource().newValue(state.getBank1().getSource().getMin() + table - object.start, state.getBank1().getSource().getMin() + table - object.start), state));
                            }
                            if (this.hasBank2() && state.getBank2().getSource() != null && !state.getBank2().getSource().isUnique()) {
                                state.setBank2(Z80Disassembler.READ_BYTE(nArray, ramRomMap, state.getBank2().getSource().newValue(state.getBank2().getSource().getMin() + table - object.start, state.getBank2().getSource().getMin() + table - object.start), state));
                            }
                        }
                        int n9 = Z80Disassembler.RESOLVE_ADDRESS(table, ramRomMap, state);
                        if (bl2 && bitSet.get(n9)) break;
                        if (table > 0 && !tableEntrySeen.containsKey(n9)) {
                            if (bitSet.get(n9)) {
                                if (table != object.end) break;
                                table = table;
                            } else {
                                ArrayIntDeque arrayIntDeque2 = new ArrayIntDeque();
                                object.visitedAddresses.put(n9, arrayIntDeque2);
                                boolean bl3 = this.analyze(nArray, ramRomMap, table, table, -1, new int[]{-1}, new State(state), arrayIntDeque2, n);
                                n -= arrayIntDeque2.size();
                                if (!bl3) {
                                    bitSet.set(n9);
                                    Z80Disassembler.undoCode(arrayIntDeque2, ramRomMap);
                                    if (table != object.end) break;
                                    table = table;
                                    bl2 = true;
                                } else {
                                    Z80Disassembler.markSeen(table, ramRomMap, state, table);
                                }
                                if (!tableEntrySeen.containsKey(n9)) {
                                    tableEntrySeen.put(n9, table);
                                }
                                if (intDeque != null) {
                                    intDeque.pushAll(arrayIntDeque2);
                                }
                            }
                        }
                        if (table > 0 && tableEntrySeen.containsKey(n9) && !Z80Disassembler.isSeen(table, ramRomMap, state, table) && Z80Disassembler.isCode(n9)) {
                            Z80Disassembler.markSeen(table, ramRomMap, state, table);
                        }
                        if (table != object.end && table != object.start && Z80Disassembler.isCode(n9)) {
                            table = table + n6;
                        }
                        table += n6;
                    }
                    if (bl || table == object.end) continue;
                    Table bl4 = null;
                    Z80Disassembler.removeTable(jumpTables, object);
                    if (table - object.start > 0) {
                        bl4 = new Table(object, object.start, table);
                        jumpTables.add(bl4);
                        bl = true;
                    }
                    Z80Disassembler.cleanUpJumpTable(bl4, object, nArray, ramRomMap);
                    break;
                }
                n4 = object.end;
                for (Table n16 : jumpTables) {
                    if (n16.start <= object.start || n4 <= n16.start) continue;
                    n4 = n16.start - 1;
                }
                int n10 = object.start;
                while (n10 < n4 && nArray[n10] == 195) {
                    int table = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n10 + 1), ramRomMap, object.state);
                    if (Z80Disassembler.isSubInstructionByte(table)) break;
                    n10 += 3;
                }
                if (object.end != n10) {
                    Table n18 = null;
                    Z80Disassembler.removeTable(jumpTables, object);
                    if (n10 - object.start > 0) {
                        n18 = new Table(object, object.start, n10);
                        jumpTables.add(n18);
                        bl = true;
                    }
                    Z80Disassembler.cleanUpJumpTable(n18, object, nArray, ramRomMap);
                    break;
                }
                int n11 = object.start;
                while (n11 < object.end) {
                    if (!object.visitedAddresses.containsKey(n11)) {
                        try {
                            ArrayIntDeque arrayIntDeque = new ArrayIntDeque();
                            object.visitedAddresses.put(n11, arrayIntDeque);
                            boolean bl4 = this.analyze(nArray, ramRomMap, Z80Disassembler.UNRESOLVE_ADDRESS(n11, object.state), n11, -1, new int[]{-1}, new State(object.state), arrayIntDeque, n);
                            n -= arrayIntDeque.size();
                            if (!bl4) {
                                Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                                if (n11 == object.start) {
                                    Table table = null;
                                    Z80Disassembler.removeTable(jumpTables, object);
                                    if (object.start + 3 >= object.end) continue block3;
                                    table = new Table(object, object.start + 3, object.end);
                                    jumpTables.add(table);
                                    bl = true;
                                    continue block3;
                                }
                            }
                            if (intDeque != null) {
                                intDeque.pushAll(arrayIntDeque);
                            }
                        }
                        catch (ResolveAddressException resolveAddressException) {}
                    }
                    n11 += 3;
                }
            }
            n3 = jumpTables.size();
        }
        for (Table table : jumpTables) {
            Address address = table.source.getSource();
            if (address != null && address.isUnique()) {
                Z80Disassembler.markDataSeen(table.start, address.getMin(), true);
            }
            table.visitedAddresses.clear();
        }
    }

    private static void cleanUpJumpTable(Table table, Table table2, int[] nArray, RamRomMap ramRomMap) {
        int n;
        int n2;
        int n3 = table2.end;
        int n4 = table2.start;
        if (table != null) {
            n3 = table.start;
            n4 = table.end;
        }
        if (n3 > table2.start) {
            n2 = table2.start;
            while (n2 < n3 && !table2.visitedAddresses.isEmpty()) {
                if (!instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n2), table2.state)) {
                    ERROR_STREAM.println(String.valueOf(Integer.toHexString(Z80Disassembler.READ_WORD(nArray, n2))) + " in " + table2);
                } else {
                    n = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state);
                    if (table2.visitedAddresses.containsKey(n)) {
                        Z80Disassembler.unmarkSeen(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state, n2);
                        if (!Z80Disassembler.isSeen(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state, n2)) {
                            tableEntrySeen.remove(n);
                        }
                        Z80Disassembler.undoCode(table2.visitedAddresses.get(n), ramRomMap);
                        table2.visitedAddresses.remove(n);
                    }
                }
                n2 += 2;
            }
        }
        if (n4 < table2.end) {
            n2 = table2.end - 2;
            while (n2 >= n4 && !table2.visitedAddresses.isEmpty()) {
                if (!instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n2), table2.state)) {
                    ERROR_STREAM.println(String.valueOf(Integer.toHexString(Z80Disassembler.READ_WORD(nArray, n2))) + " in " + table2);
                } else {
                    n = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state);
                    if (table2.visitedAddresses.containsKey(n)) {
                        boolean bl = Z80Disassembler.isSeen(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state, n2);
                        Z80Disassembler.unmarkSeen(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state, n2);
                        if (bl) {
                            if (!Z80Disassembler.isSeen(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table2.state, n2)) {
                                tableEntrySeen.remove(n);
                            }
                            Z80Disassembler.undoCode(table2.visitedAddresses.get(n), ramRomMap);
                            table2.visitedAddresses.remove(n);
                        }
                    }
                }
                n2 -= 2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void analyzePointerTables(int[] nArray, RamRomMap ramRomMap) {
        int n;
        int n2;
        int n3;
        int n4;
        Address address;
        IntHashSet intHashSet = new IntHashSet();
        int n32 = 0;
        boolean bl = false;
        BitSet bitSet = new BitSet();
        for (Table table : jumpTables) {
            bitSet.set(table.start, table.end);
        }
        Iterator<Table> iterator = pointerTables.iterator();
        while (iterator.hasNext()) {
            Address address2;
            Table table = iterator.next();
            if (!bitSet.get(table.start)) continue;
            Table table2 = Z80Disassembler.getJumpTableAt(table.start);
            iterator.remove();
            if (table.start == table2.start || (address2 = table.source.getSource()) == null || !address2.isUnique()) continue;
            Z80Disassembler.unmarkDataSeen(table.start, address2.getMin());
        }
        for (Table table : new ArrayList<Table>(pointerTables)) {
            void var9_31;
            int n5 = table.start;
            while (var9_31 < table.end && (Z80Disassembler.isCode((int)var9_31) || instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, (int)var9_31), table.state) && Z80Disassembler.isCode(Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, (int)var9_31), ramRomMap, table.state)))) {
                var9_31 += 2;
            }
            if (table.start == var9_31) continue;
            Z80Disassembler.removeTable(pointerTables, table);
            if (table.fixedStart || table.end - var9_31 <= 0) continue;
            address = table.source.getSource();
            if (address != null && address.isUnique()) {
                Z80Disassembler.unmarkDataSeen(table.start, address.getMin());
            }
            if (bitSet.get((int)var9_31)) continue;
            pointerTables.add(new Table(table, (int)var9_31, table.end));
            if (address == null || !address.isUnique()) continue;
            Z80Disassembler.markDataSeen((int)var9_31, address.getMin(), true);
        }
        for (Table table : new ArrayList<Table>(pointerTables)) {
            void var9_34;
            int n7 = Math.min(table.end, bitSet.nextSetBit(table.start) & Integer.MAX_VALUE);
            n7 = n7 - (n7 - table.start) % 2;
            while (var9_34 > table.start && Z80Disassembler.READ_WORD(nArray, (int)(var9_34 - 2)) <= 0) {
                var9_34 -= 2;
            }
            if (table.end == var9_34) continue;
            Z80Disassembler.removeTable(pointerTables, table);
            if (var9_34 - table.start > 0) {
                pointerTables.add(new Table(table, table.start, (int)(var9_34 - (var9_34 - table.start) % 2)));
                continue;
            }
            address = table.source.getSource();
            if (address == null || !address.isUnique()) continue;
            Z80Disassembler.unmarkDataSeen(table.start, address.getMin());
        }
        TreeSet<Table> treeSet = new TreeSet<Table>(new Comparator<Table>(){

            @Override
            public int compare(Table table, Table table2) {
                if (table.start == table2.start) {
                    return table.end - table2.end;
                }
                return table.start - table2.start;
            }
        });
        treeSet.addAll(pointerTables);
        int n8 = pointerTables.size();
        while (n4 != n32 || bl) {
            bl = false;
            n32 = n4;
            for (Table table : new ArrayList<Table>(pointerTables)) {
                Object object;
                int n9 = table.end;
                Table table3 = treeSet.higher(table);
                if (table3 != null) {
                    if (table3.start > table.start && n9 > table3.start) {
                        n9 = table3.start - 1;
                    } else if (table.start == table3.start && table.end < table3.end) {
                        if (table.indexedBy != null && table.indexedBy.equals(table3.indexedBy)) {
                            if (table.state.getBank1().equals(table3.state.getBank1()) && (!instance.hasBank2() || table.state.getBank2().equals(table3.state.getBank2()))) {
                                n9 = table3.end - 1;
                            }
                        } else {
                            n9 = table.start - 1;
                        }
                    }
                }
                n3 = table.start;
                n9 = Math.min(n9, (labels.nextSetBit(table.start + 1) & Integer.MAX_VALUE) - 1);
                while (n3 < n9) {
                    n2 = Z80Disassembler.READ_WORD(nArray, n3);
                    if (n2 == 65535 || instance.isROMaddress(n2, table.state) && Z80Disassembler.isCode(Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, table.state)) || n3 != table.start && dataSeen.containsKey(n3) && (!instance.isROMaddress(n2, table.state) || !Z80Disassembler.hasVisitedEntryAt(table, nArray, ramRomMap, n3))) break;
                    n3 += 2;
                }
                if (table.end != n3) {
                    Object object2;
                    Z80Disassembler.removeTable(pointerTables, table);
                    treeSet.remove(table);
                    if (n3 - table.start > 0) {
                        object2 = new Table(table, table.start, n3);
                        pointerTables.add((Table)object2);
                        treeSet.add((Table)object2);
                    } else {
                        object2 = table.source.getSource();
                        if (object2 != null && ((Value)object2).isUnique() && Z80Disassembler.getPointerTableStartingAt(table.start) == null) {
                            Z80Disassembler.unmarkDataSeen(table.start, ((Value)object2).getMin());
                        }
                    }
                    bl = true;
                }
                n2 = table.end;
                if (!bl) {
                    int n10 = table.start;
                    while (n10 < n2) {
                        int n11 = Z80Disassembler.READ_WORD(nArray, n10);
                        if (instance.isROMaddress(n11, table.state)) {
                            Z80Disassembler.markDataSeen(n11, ramRomMap, table.state, n10, true);
                            if (n11 > 0 && !tableEntrySeen.containsKey(Z80Disassembler.RESOLVE_ADDRESS(n11, ramRomMap, table.state))) {
                                int n12;
                                util.map.Map<Table> map = entriesOfTablePointToTables.get(table.start);
                                if (map == null) {
                                    map = entriesOfTablePointToTables.get(table.start - 2);
                                }
                                if (map != null) {
                                    int n13;
                                    int n14;
                                    intHashSet.add(table.start);
                                    n12 = Z80Disassembler.RESOLVE_ADDRESS(instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, table.start), table.state) ? Z80Disassembler.READ_WORD(nArray, table.start) : n11, ramRomMap, table.state);
                                    int n15 = n14 = (table.end - table.start) / 2 >= 2 && instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, table.start + 2), table.state) ? Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, table.start + 2), ramRomMap, table.state) : n12;
                                    if (n14 != n12 && instance.isROMaddress(n13 = Z80Disassembler.READ_WORD(nArray, n12), table.state) && n14 == Z80Disassembler.RESOLVE_ADDRESS(n13, ramRomMap, table.state)) {
                                        n14 = n12;
                                    }
                                    for (Map.Entry<Table> entry : map.entrySet()) {
                                        IntHashSet intHashSet2;
                                        Table table4 = entry.getValue();
                                        if (table4.start != table.start) break;
                                        Address address3 = table4.source;
                                        int n16 = entry.getKey();
                                        if (map.containsKey(n16 - 2)) continue;
                                        State state = table4.state;
                                        if (instance.hasBank2() && state.getBank2().getSource() != null && state.getBank2().getSource().isRamAddress()) {
                                            Value value = state.getRAMvalue(state.getBank2().getSource().getMin());
                                            if (address3.getSource() == null || value.getSource() == null || !address3.getSource().equals(value.getSource().getSource())) continue;
                                            int n17 = value.getSource().getOffset();
                                            if (instance.isROMaddress(n11 + n17, state)) {
                                                state = new State(state, false);
                                                dummyCartridge.setBank2(Z80Disassembler.READ_BYTE(nArray, Z80Disassembler.RESOLVE_ADDRESS(n11 + n17, ramRomMap, state)));
                                                state.setBank2(new Value(dummyCartridge.getBank2()));
                                                table4 = new Table(table4, state);
                                            }
                                        }
                                        while (n16 < 2 && (Z80Disassembler.isCode(n12 + n16) || instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n12 + n16), state) && Z80Disassembler.isCode(Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n12 + n16), ramRomMap, state)))) {
                                            ++n16;
                                        }
                                        while (n16 < 2 && (Z80Disassembler.isCode(n14 + n16) || instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n14 + n16), state) && Z80Disassembler.isCode(Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n14 + n16), ramRomMap, state)))) {
                                            ++n16;
                                        }
                                        if (!instance.isROMaddress(n11 + n16, state) || Z80Disassembler.isCode(Z80Disassembler.RESOLVE_ADDRESS(n11 + n16, ramRomMap, state))) continue;
                                        int n18 = Z80Disassembler.RESOLVE_ADDRESS(n11 + n16, ramRomMap, state);
                                        if (bitSet.get(n18)) break;
                                        Table table5 = new Table(table4, n18, n18 + 512, true);
                                        int n19 = Z80Disassembler.READ_WORD(nArray, n18);
                                        if (instance.isROMaddress(n19, state)) {
                                            int n20 = Z80Disassembler.RESOLVE_ADDRESS(n19, ramRomMap, state);
                                            for (Table table6 : new ArrayList<Table>(pointerTables)) {
                                                int n21;
                                                Address address4;
                                                if (table6.start < n20 || table6.start - n20 >= 256 || !(address4 = table6.source).add(0).equals(table5.source.add(0)) || n20 < table6.start - (n21 = table6.source.getOffset()) || n20 >= table6.start) continue;
                                                Z80Disassembler.removeTable(pointerTables, table6);
                                                treeSet.remove(table6);
                                            }
                                        }
                                        if ((intHashSet2 = entriesOfTablePointToTablesOfTablesOfPointerTables.get(table.start)) == null) {
                                            intHashSet2 = entriesOfTablePointToTablesOfTablesOfPointerTables.get(table.start - 2);
                                        }
                                        if (intHashSet2 != null && intHashSet2.contains(n16)) {
                                            entriesOfTablePointToTablesOfPointerTables.set(table5.start);
                                        }
                                        if (entriesOfTablePointToTablesOfJumpTables.get(table.start)) {
                                            entriesOfTablePointToJumpTables.set(n18);
                                        } else if (entriesOfTablePointToTablesOfPointerTables.get(table.start) || table.start >= 2 && entriesOfTablePointToTablesOfPointerTables.get(table.start - 2)) {
                                            void var28_76;
                                            util.map.Map<Table> map2 = entriesOfTablePointToTables.get(table5.start);
                                            if (map2 == null) {
                                                HashMap hashMap = new HashMap();
                                                entriesOfTablePointToTables.put(table5.start, hashMap);
                                            }
                                            var28_76.put(0, table5);
                                        }
                                        pointerTables.add(table5);
                                        treeSet.add(table5);
                                    }
                                }
                                n12 = Z80Disassembler.RESOLVE_ADDRESS(n11, ramRomMap, table.state);
                                tableEntrySeen.put(n12, n10);
                                if (n12 >= n10 && n12 < n2) {
                                    n2 = n12 - (n12 - table.start) % 2;
                                }
                            }
                        } else if (instance.isRAMaddress(n11)) {
                            Z80Disassembler.markRAMseen(n11, n10, 1);
                        } else if (instance.isSRAMaddress(n11, table.state)) {
                            Z80Disassembler.markSRAMseen(n11, table.state, n10, 1);
                        }
                        n10 += 2;
                    }
                }
                if (n2 == table.end) continue;
                Z80Disassembler.removeTable(pointerTables, table);
                treeSet.remove(table);
                if (n2 - table.start > 0) {
                    object = new Table(table, table.start, n2);
                    pointerTables.add((Table)object);
                    treeSet.add((Table)object);
                } else {
                    object = table.source.getSource();
                    if (object != null && ((Value)object).isUnique()) {
                        Z80Disassembler.unmarkDataSeen(table.start, ((Value)object).getMin());
                    }
                    entriesOfTablePointToJumpTables.clear(table.start);
                }
                bl = true;
            }
            n4 = pointerTables.size();
        }
        block14: for (Table table : new ArrayList<Table>(pointerTables)) {
            for (Table table7 : pointerTables) {
                if (table7.equals(table) || table.start != table7.start) continue;
                if (table.end > table7.end) {
                    Z80Disassembler.removeTable(pointerTables, table7);
                    continue block14;
                }
                if (table.end >= table7.end) continue block14;
                Z80Disassembler.removeTable(pointerTables, table);
                continue block14;
            }
        }
        int n22 = entriesOfTablePointToJumpTables.nextSetBit(0);
        while (n >= 0) {
            Table table = Z80Disassembler.getPointerTableStartingAt(n);
            if (table != null) {
                void var9_40;
                int n23 = table.start;
                while (var9_40 < table.end) {
                    int n24 = Z80Disassembler.READ_WORD(nArray, (int)var9_40);
                    if (!instance.isROMaddress(n24, table.state)) break;
                    n2 = n3 = Z80Disassembler.RESOLVE_ADDRESS(n24, ramRomMap, table.state);
                    int n25 = 0;
                    while (n25 < 256 && !Z80Disassembler.hasLabel(n2) && !Z80Disassembler.hasLabel(n2 + 1) && instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n2), table.state)) {
                        int n26 = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n2), ramRomMap, table.state);
                        if (Z80Disassembler.isSubInstructionByte(n26)) break;
                        n2 += 2;
                        n25 += 2;
                    }
                    if (n2 > n3) {
                        n25 = 0;
                        for (Table table8 : jumpTables) {
                            if (table8.start != n3) continue;
                            n25 = 1;
                            break;
                        }
                        if (n25 == 0) {
                            Z80Disassembler.addTable(jumpTables, n3, n2, table.source, null, table.state);
                        }
                    }
                    var9_40 += 2;
                }
            }
            n = entriesOfTablePointToJumpTables.nextSetBit((int)(n + true));
        }
    }

    private static Table getPointerTableAt(int n) {
        for (Table table : pointerTables) {
            if (n < table.start || n >= table.end) continue;
            return table;
        }
        return null;
    }

    private static Table getJumpTableAt(int n) {
        for (Table table : jumpTables) {
            if (n < table.start || n >= table.end) continue;
            return table;
        }
        return null;
    }

    private static Table getPointerTableStartingAt(int n) {
        for (Table table : pointerTables) {
            if (table.start != n) continue;
            return table;
        }
        return null;
    }

    private static void analyzeMemoryJumps(int[] nArray, RamRomMap ramRomMap) {
        Z80Disassembler.analyzeMemoryJumps(nArray, ramRomMap, null, 524288);
    }

    private static void analyzeMemoryJumps(int[] nArray, RamRomMap ramRomMap, IntDeque intDeque, int n) {
        int n2 = 0;
        int n3 = memoryJumps.size();
        while (n3 != n2) {
            n2 = n3;
            for (MemoryJump memoryJump : new ArrayList<MemoryJump>(memoryJumps.values())) {
                Z80Instruction z80Instruction = Z80Disassembler.getInstruction(memoryJump.getSource());
                if (z80Instruction == null || z80Instruction.getArg() != memoryJump.getAddress() || Z80Disassembler.isSeen(memoryJump.getAddress(), ramRomMap, memoryJump.getState(), memoryJump.getSource())) continue;
                int n4 = Z80Disassembler.RESOLVE_ADDRESS(memoryJump.getAddress(), ramRomMap, memoryJump.getState());
                boolean bl = Z80Disassembler.hasLabel(n4);
                Z80Disassembler.markSeen(memoryJump.getAddress(), ramRomMap, memoryJump.getState(), memoryJump.getSource());
                ArrayIntDeque arrayIntDeque = new ArrayIntDeque();
                if (!instance.analyze(nArray, ramRomMap, memoryJump.getAddress(), memoryJump.getSource(), -1, new int[]{-1}, new State(memoryJump.getState()), arrayIntDeque, n / 2)) {
                    Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                    Z80Disassembler.unmarkSeen(memoryJump.getAddress(), ramRomMap, memoryJump.getState(), memoryJump.getSource());
                    if (bl) continue;
                    Z80Disassembler.removeLabel(n4);
                    continue;
                }
                if (intDeque == null) continue;
                intDeque.pushAll(arrayIntDeque);
            }
            n3 = memoryJumps.size();
        }
    }

    private static void analyzeRamCodeWrites(int[] nArray, RamRomMap ramRomMap) {
        Z80Disassembler.analyzeRamCodeWrites(nArray, ramRomMap, null);
    }

    private static void analyzeRamCodeWrites(int[] nArray, RamRomMap ramRomMap, IntDeque intDeque) {
        int n = 0;
        int n2 = ramCodeWrites.size();
        while (n2 != n) {
            n = n2;
            for (RamCodeWrite ramCodeWrite : new ArrayList<RamCodeWrite>(ramCodeWrites.values())) {
                State state = ramCodeWrite.getState();
                int n3 = ramCodeWrite.getAddress();
                int n4 = ramCodeWrite.getRomAddress();
                int n5 = ramCodeWrite.getFromAddress();
                if (Z80Disassembler.isSeen(n3, ramRomMap, state, n5)) continue;
                if (instance.isRAMaddress(n3)) {
                    Z80Disassembler.setRAMcodeAddress(instance.mapRAMaddress(n3), n4);
                }
                ArrayIntDeque arrayIntDeque = new ArrayIntDeque();
                Z80Disassembler.markSeen(n3, ramRomMap, state, n5);
                if (!instance.analyze(nArray, ramRomMap, n3, n5, -1, new int[]{-1}, new State(state), arrayIntDeque, 16384)) {
                    Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                    continue;
                }
                if (intDeque != null) {
                    intDeque.pushAll(arrayIntDeque);
                }
                if (Z80Disassembler.isCode(n4) || !instance.isRAMaddress(n3)) continue;
                Z80Disassembler.setRAMcodeAddress(instance.mapRAMaddress(n3), n4);
                State state2 = new State(state);
                arrayIntDeque.clear();
                state2.setRAMvalue(n3, new Value(255, Z80Disassembler.toAddress(n5, ramRomMap, state)));
                if (!instance.analyze(nArray, ramRomMap, n3, n5, -1, new int[]{-1}, state2, arrayIntDeque, 16384)) {
                    Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                    continue;
                }
                if (intDeque == null) continue;
                intDeque.pushAll(arrayIntDeque);
            }
            n2 = ramCodeWrites.size();
        }
    }

    private static final Address toAddress(Value value, RamRomMap ramRomMap, State state) {
        int n;
        if (value instanceof Address) {
            return (Address)value;
        }
        if (instance.isRAMaddress(value)) {
            return new Address(value, false, true, false, false);
        }
        if (instance.isSRAMaddress(value, state)) {
            return new Address(value, false, false, true, false);
        }
        if (instance.isPortAddress(value)) {
            return new Address(value, false, false, false, true);
        }
        if (!instance.isROMaddress(value, state)) {
            return new Address(value, false, false, false, false);
        }
        if (msx) {
            try {
                return new Address(value.newValue(Z80Disassembler.RESOLVE_ADDRESS(value.getMin(), ramRomMap, state), Z80Disassembler.RESOLVE_ADDRESS(value.getMax(), ramRomMap, state)), true, false, false, false);
            }
            catch (ResolveAddressException resolveAddressException) {
                return Address.asUnknown(value);
            }
        }
        int n2 = Z80Disassembler.getRomBank(value.getMin());
        if (n2 == 3) {
            Value value2;
            if (state.getBank3().getSource() != null && !state.getBank3().getSource().isUnique()) {
                return Address.asUnknown(value);
            }
            n = state.getBank3().getMin();
            if (state.getBank3().getSource() != null && state.getBank3().getSource().isUnique() && state.getBank3().getSource().isRamAddress() && (value2 = state.getRAMvalue(state.getBank3().getSource().getMin())).isUnique()) {
                n = value2.getMin();
            }
            if (n == 0) {
                return Address.asUnknown(value);
            }
        } else if (n2 == 2) {
            Value value3;
            if (state.getBank2().getSource() != null && !state.getBank2().getSource().isUnique()) {
                return Address.asUnknown(value);
            }
            n = state.getBank2().getMin();
            if (state.getBank2().getSource() != null && state.getBank2().getSource().isUnique() && state.getBank2().getSource().isRamAddress() && (value3 = state.getRAMvalue(state.getBank2().getSource().getMin())).isUnique()) {
                n = value3.getMin();
            }
            if (n == 0) {
                return Address.asUnknown(value);
            }
        } else if (n2 == 1) {
            Value value4;
            if (state.getBank1().getSource() != null && !state.getBank1().getSource().isUnique()) {
                return Address.asUnknown(value);
            }
            n = state.getBank1().getMin();
            if (state.getBank1().getSource() != null && state.getBank1().getSource().isUnique() && state.getBank1().getSource().isRamAddress() && (value4 = state.getRAMvalue(state.getBank1().getSource().getMin())).isUnique()) {
                n = value4.getMin();
            }
            if (n == 0) {
                return Address.asUnknown(value);
            }
        } else {
            n = state.getBank0().getMin();
        }
        return new Address(value.mapToBank(n, dummyCartridge.getBankSize()), true, false, false, false);
    }

    protected static final Address toAddress(int n, RamRomMap ramRomMap, State state) {
        int n2 = Z80Disassembler.getRomBank(n);
        if (n2 > 2 || !instance.isROMaddress(n, state)) {
            return new Address(n, instance.isROMaddress(n, state), instance.isRAMaddress(n), instance.isSRAMaddress(n, state), instance.isPortAddress(n));
        }
        return new Address(Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state), instance.isROMaddress(n, state), instance.isRAMaddress(n), instance.isSRAMaddress(n, state), instance.isPortAddress(n));
    }

    protected static final int RESOLVE_ADDRESS(int n, RamRomMap ramRomMap, State state, int n2) {
        try {
            return Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    protected static final int RESOLVE_ADDRESS(int n, RamRomMap ramRomMap, State state) {
        if (n < 0 || n >= 65536) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        boolean bl = state.isSRAMenabled();
        if (instance.isROMaddress(n, bl)) {
            dummyCartridge.setBank0(state.getBank0().getMin());
            dummyCartridge.setBank1(state.getBank1().getMin());
            dummyCartridge.setBank2(state.getBank2().getMin());
            dummyCartridge.setBank3(state.getBank3().getMin());
            return dummyCartridge.mapAddress(n);
        }
        if (instance.isRAMaddress(n)) {
            Value value = state.getRAMvalue(n);
            if (value.getSource() != null && value.getSource().isUnique() && !value.getSource().isRamAddress()) {
                return value.getSource().getMin();
            }
            int n2 = ramRomMap.toRomAddress(instance.mapRAMaddress(n));
            if (n2 != Integer.MIN_VALUE) {
                return n2;
            }
            n2 = defaultRamRomMap.toRomAddress(instance.mapRAMaddress(n));
            if (n2 != Integer.MIN_VALUE) {
                return n2;
            }
            throw new ResolveAddressException(n);
        }
        if (!instance.isSRAMaddress(n, bl)) {
            throw new ResolveAddressException(n);
        }
        Value value = state.getSRAMvalue(n);
        if (value.getSource() != null && value.getSource().isUnique() && !value.getSource().isSramAddress()) {
            return value.getSource().getMin();
        }
        int n3 = 1;
        while (n3 < 4) {
            int n4 = sramCode.get(instance.mapSRAMaddress(n, state) - n3);
            if (n4 != Integer.MIN_VALUE) {
                return n4 + n3;
            }
            ++n3;
        }
        throw new ResolveAddressException(n);
    }

    private static final int UNRESOLVE_ADDRESS(int n, State state) {
        int n2 = Z80Disassembler.getRomBank(n);
        if (msx && dummyCartridge.getBankSize() == 8192) {
            if (n2 == state.getBank3().getMin()) {
                return 0xA000 | n & 0x1FFF;
            }
            if (n2 == state.getBank2().getMin()) {
                return 0x8000 | n & 0x1FFF;
            }
            if (n2 == state.getBank1().getMin()) {
                return 0x6000 | n & 0x1FFF;
            }
            if (n2 == state.getBank0().getMin()) {
                return 0x4000 | n & 0x1FFF;
            }
            throw new ResolveAddressException(n);
        }
        if (instance.hasBank2() && n2 == state.getBank2().getMin()) {
            return 0x8000 | n & 0x3FFF;
        }
        if (n2 == state.getBank1().getMin()) {
            return 0x4000 | n & 0x3FFF;
        }
        if (n2 == state.getBank0().getMin()) {
            return n & 0x3FFF;
        }
        throw new ResolveAddressException(n);
    }

    protected Z80Instruction getInstruction(int[] nArray, int n) {
        Z80Instruction z80Instruction;
        if (code != null && nArray.length == code.length && instructionStart != null && (z80Instruction = Z80Disassembler.getInstruction(n)) != null) {
            return z80Instruction;
        }
        return Z80Instruction.parse(nArray, n);
    }

    protected boolean isEntryPointOptional(int n) {
        return false;
    }

    private boolean analyze(int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, State state, IntDeque intDeque) {
        Z80Disassembler.addLabel(Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state));
        return this.analyze(nArray, ramRomMap, n, n2, -1, new int[]{n3}, state, intDeque, Math.max(nArray.length, 262144));
    }

    private boolean analyze(int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, int[] nArray2, State state, IntDeque intDeque, int n4) {
        return this.analyze(new DisassemblerState(nArray, ramRomMap, n4), n, n2, n3, nArray2, state, 1, intDeque);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean analyze(DisassemblerState disassemblerState, int n, int n2, int n3, int[] nArray, State state, int n4, IntDeque intDeque) {
        disassemblerState = new DisassemblerState(disassemblerState);
        int[] nArray2 = disassemblerState.memory;
        RamRomMap ramRomMap = disassemblerState.ramRomMap;
        int n5 = disassemblerState.maxAddressesToVisit;
        try {
            Z80Instruction z80Instruction;
            state.setPC(n);
            if (this.hasBank2() && state.getSlot() == 2 && state.getBank2().getMin() == 0) {
                state.setBank2(Z80Disassembler.getBank2(n2));
                if (state.getBank2().getMin() == 0) {
                    Z80Disassembler.unmarkSeen(state.getPC(), ramRomMap, state, n2);
                    ERROR_STREAM.println("Bank 2 unknown at " + Integer.toHexString(n2).toUpperCase() + "!");
                    if (n4 <= 1) return false;
                    return true;
                }
            } else if (!msx && state.getSlot() == 1 && state.getBank1().getMin() == 0) {
                state.setBank1(Z80Disassembler.getBank1(n2));
                if (state.getBank1().getMin() == 0) {
                    Z80Disassembler.unmarkSeen(state.getPC(), ramRomMap, state, n2);
                    ERROR_STREAM.println("Bank 1 unknown at " + Integer.toHexString(n2).toUpperCase() + "!");
                    if (n4 <= 1) return false;
                    return true;
                }
            }
            if ((n = state.getAddress(ramRomMap)) == state.getPC() && !this.isROMaddress(state.getPC(), state)) {
                if (!this.isRAMaddress(state.getPC())) return false;
                ERROR_STREAM.println("Execution of unknown RAM from " + Integer.toHexString(Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, state)).toUpperCase() + "!");
                return true;
            }
            if (n4 > 215) {
                if (!Z80Disassembler.isCode(n)) {
                    Z80Disassembler.removeLabel(n);
                }
                ERROR_STREAM.println("Went too deep (" + n4 + ") at " + Integer.toHexString(n) + "!");
                return false;
            }
            int[] nArray3 = this.getEntryPoints();
            int n6 = this.getMaxEntryPoint();
            if (n3 >= 0) {
                try {
                    n3 = Z80Disassembler.RESOLVE_ADDRESS(n3, ramRomMap, state);
                }
                catch (ResolveAddressException resolveAddressException) {}
            }
            boolean bl = instance instanceof LR35902Disassembler;
            Z80Instruction z80Instruction2 = z80Instruction = this.getInstruction(nArray2, n);
            while (n < nArray2.length) {
                int n7;
                int n8;
                if (n == n3) {
                    return true;
                }
                if (abort) {
                    throw new AbortException("Abort by user.");
                }
                if (Z80Disassembler.isCode(n)) {
                    if (Z80Disassembler.isSubInstructionByte(n)) {
                        seen.remove(n);
                        Z80Disassembler.removeLabel(n);
                        ERROR_STREAM.println("Unaligned instruction at " + Integer.toHexString(n) + "!");
                        return true;
                    }
                    if (++disassemblerState.addressesSinceLastDiscovery >= 1000) {
                        return true;
                    }
                } else if (code[n] == 0) {
                    if (!z80Instruction.isValid()) {
                        seen.remove(n);
                        Z80Disassembler.removeLabel(n);
                        ERROR_STREAM.println("Invalid instruction at " + Integer.toHexString(n) + "!");
                        return false;
                    }
                    disassemblerState.addressesSinceLastDiscovery = 0;
                    Z80Disassembler.setBank0(n, state.getBank0());
                    Z80Disassembler.setBank1(n, state.getBank1());
                    if (this.hasBank2()) {
                        Z80Disassembler.setBank2(n, state.getBank2());
                    }
                    if (this.hasBank3()) {
                        Z80Disassembler.setBank3(n, state.getBank3());
                    }
                    Z80Disassembler.setSRAMenabled(n, state.isSRAMenabled());
                    Z80Disassembler.setSRAMbank(n, state.getSRAMbank());
                    n8 = 0;
                    while (n8 < z80Instruction.getSize()) {
                        IntHashSet intHashSet = dataSeen.remove(n + n8);
                        if (intHashSet != null && (z80Instruction.isJump() && !z80Instruction.isConditional() || z80Instruction.isRet())) {
                            dataSeen.put(n + n8 + 1, intHashSet);
                        }
                        if (n8 > 0) {
                            int n9;
                            Z80Disassembler.removeLabel(n + n8);
                            int n10 = n + n8;
                            if (n10 <= n6) {
                                n9 = 0;
                                while (n9 < nArray3.length) {
                                    int n11 = nArray3[n9];
                                    if (n10 == n11 && code[n11] > 0 && !this.isEntryPointOptional(n10)) {
                                        ERROR_STREAM.println("Entry point " + Integer.toHexString(n11) + " shouldn't be overwritten from " + Integer.toHexString(n2));
                                        return false;
                                    }
                                    ++n9;
                                }
                            }
                            if ((n9 = code[n10]) > 0 && Z80Disassembler.isInstruction(n10)) {
                                if (n9 > 1 && seen.containsKey(n10)) {
                                    ERROR_STREAM.println("Instruction to overwrite at " + Integer.toHexString(n10) + " is referenced by " + seen.get(n10));
                                    return msx;
                                }
                                Z80Disassembler.undoCode(n10, ramRomMap);
                                if (Z80Disassembler.isInstruction(n10)) {
                                    ERROR_STREAM.println("Failed to overwrite instruction at " + Integer.toHexString(n10) + "!");
                                    return false;
                                }
                                ERROR_STREAM.println("Overwriting instruction at " + Integer.toHexString(n10) + "!");
                            }
                        }
                        ++n8;
                    }
                }
                n8 = 0;
                while (n8 < z80Instruction.getSize()) {
                    if (code[n + n8] < 127) {
                        if (code[n + n8] < 0) {
                            if (code[n + n8] != -64) {
                                ERROR_STREAM.println("Negative code value at " + Integer.toHexString(n));
                                return false;
                            }
                        } else {
                            int n12 = n + n8;
                            code[n12] = (byte)(code[n12] + 1);
                        }
                    }
                    ++n8;
                }
                Z80Disassembler.setInstruction(n, z80Instruction);
                if (this.isSRAMaddress(state.getPC(), state)) {
                    Value value = state.getSRAMvalue(state.getPC());
                    if (value.getSource() != null && value.getSource().getSource() != null && Z80Disassembler.getInstruction(value.getSource().getSource()) != null) {
                        Z80Disassembler.markSeen(state.getPC(), ramRomMap, state, value.getSource().getSource().getMin());
                    }
                    sramCode.put(this.mapSRAMaddress(state.getPC(), state), n);
                } else if (this.isRAMaddress(state.getPC())) {
                    Value value = state.getRAMvalue(state.getPC());
                    if (value.getSource() != null && value.getSource().getSource() != null && Z80Disassembler.getInstruction(value.getSource().getSource()) != null) {
                        Z80Disassembler.markSeen(state.getPC(), ramRomMap, state, value.getSource().getSource().getMin());
                    }
                    Z80Disassembler.setRAMcodeAddress(this.mapRAMaddress(state.getPC()), n);
                }
                intDeque.push(n);
                if (intDeque.size() > n5) {
                    throw new AbortException("Too many addresses visited! " + Integer.toHexString(n) + " from " + Integer.toHexString(n2));
                }
                if (!(bl || msx || n2 != 56 && n2 != 102 || (z80Instruction.getOpCode() & 0xFFC7) != 192)) {
                    ERROR_STREAM.println("Invalid return from interrupt handler at " + Integer.toHexString(n) + "!");
                    return false;
                }
                state.addToPC(z80Instruction.getSize());
                n = this.analyzeInstruction(disassemblerState, z80Instruction, n + z80Instruction.getSize(), z80Instruction2, state, n2, nArray, intDeque, n4 + 1);
                if (this.isRAMaddress(state.getPC())) {
                    Z80Disassembler.setRAMcodeAddress(this.mapRAMaddress(state.getPC()), n);
                }
                if (n < 0) {
                    n = state.getAddress(ramRomMap);
                }
                if (shouldReturn != null) {
                    state.union(disassemblerState.conditionalRetStates);
                    Boolean bl2 = shouldReturn;
                    shouldReturn = null;
                    return bl2;
                }
                if (n > dummyCartridge.getBankSize() && (n7 = Z80Disassembler.getRomBank(n)) != state.getBank3().getMin() && n7 != state.getBank2().getMin() && n7 != state.getBank1().getMin() && n7 != state.getBank0().getMin()) {
                    if (state.getSlot() == 3) {
                        state.setBank3(Value.ZERO);
                    } else if (state.getSlot() == 2) {
                        state.setBank2(Value.ZERO);
                    } else if (state.getSlot() == 1) {
                        state.setBank1(Value.ZERO);
                    } else if (state.getSlot() == 0) {
                        state.setBank0(Value.ZERO);
                    }
                }
                if (this.hasBank2() && state.getSlot() == 2 && state.getBank2().getMin() == 0) {
                    state.setBank2(Z80Disassembler.getBank2(n));
                    if (state.getBank2().getMin() == 0) {
                        state.setBank2(new Value(Z80Disassembler.getRomBank(n)));
                        if (state.getBank2().getMin() == 0) {
                            ERROR_STREAM.println("Bank 2 unknown at " + Integer.toHexString(n).toUpperCase() + "!");
                            return true;
                        }
                    }
                } else if (!msx && state.getSlot() == 1 && state.getBank1().getMin() == 0) {
                    state.setBank1(Z80Disassembler.getBank1(n));
                    if (state.getBank1().getMin() == 0) {
                        state.setBank1(new Value(Z80Disassembler.getRomBank(n)));
                        if (state.getBank1().getMin() == 0) {
                            ERROR_STREAM.println("Bank 1 unknown at " + Integer.toHexString(n).toUpperCase() + "!");
                            return true;
                        }
                    }
                }
                if (n == n2) {
                    return true;
                }
                z80Instruction2 = z80Instruction;
                n = state.getAddress(ramRomMap);
                z80Instruction = this.getInstruction(nArray2, n);
            }
            return true;
        }
        catch (AbortException abortException) {
            ERROR_STREAM.println("Disassembly aborted: " + abortException.getMessage());
            return true;
        }
        catch (Exception exception) {
            if (ALLOW_CALLS_TO_UNKNOWN_RAM) {
                if (exception instanceof ResolveAddressException) return true;
            }
            exception.printStackTrace(ERROR_STREAM);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int analyzeInstruction(DisassemblerState var1_1, Z80Instruction var2_2, int var3_3, Z80Instruction var4_4, State var5_5, int var6_6, int[] var7_7, IntDeque var8_8, int var9_9) {
        block171: {
            block177: {
                block176: {
                    block175: {
                        block174: {
                            block173: {
                                block172: {
                                    block170: {
                                        var10_10 = var1_1.memory;
                                        var11_11 = var1_1.ramRomMap;
                                        var12_12 = var5_5.getRegs();
                                        var13_13 = var5_5.getRegPairs();
                                        var14_14 = var5_5.getStack();
                                        v0 = var15_15 = var2_2.getPrefix() > 0 ? var2_2.getPrefix() >> 5 & 5 : 2;
                                        if (var2_2.getOpCode() >> 6 != 0 || (var2_2.getOpCode() & 15) != 1 && (var2_2.getOpCode() & 7) != 6) break block170;
                                        if ((var2_2.getOpCode() & 15) == 1) {
                                            var16_16 = var2_2.getOpCode() >> 4;
                                            if (var16_16 < 3) {
                                                if (var16_16 == 2) {
                                                    var16_16 = var15_15;
                                                }
                                                var13_13[var16_16].ld(var2_2.getArg(), var3_3 - var2_2.getSize(), false);
                                            } else {
                                                var14_14.clear();
                                                var1_1.retAddressStackPos = 0;
                                                var1_1.retAddressValue = null;
                                                var5_5.setSpOffset(0);
                                            }
                                        } else if ((var2_2.getOpCode() & 7) == 6) {
                                            var16_17 = var2_2.getOpCode() >> 3 & 7;
                                            if (var16_17 == 6) {
                                                if (var2_2.getPrefix() > 0 && var4_4.getOpCode() == var2_2.getOpCode() && var2_2.getDisplacement() - var4_4.getDisplacement() == 1 && var4_4.getDisplacement() == 0 && (var17_33 = var2_2.getArg() << 8 | var4_4.getArg()) > 0 && var17_33 < 32768 && !Z80Disassembler.isCode(var17_33)) {
                                                    Z80Disassembler.functionPointers.set(var17_33);
                                                }
                                                Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[var15_15].getValue(), var2_2.getDisplacement(), new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)), var5_5);
                                            } else {
                                                var12_12[var16_17].ld(new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)));
                                            }
                                        }
                                        break block171;
                                    }
                                    if (var2_2.getOpCode() >> 6 != 0 || (var2_2.getOpCode() & 7) != 3 && (var2_2.getOpCode() & 7) != 4 && (var2_2.getOpCode() & 7) != 5) break block172;
                                    if ((var2_2.getOpCode() & 7) == 3) {
                                        var16_18 = var2_2.getOpCode() >> 4;
                                        if (var16_18 < 3) {
                                            if (var16_18 == 2) {
                                                var16_18 = var15_15;
                                            }
                                            if ((var2_2.getOpCode() & 8) != 0) {
                                                var13_13[var16_18].dec();
                                            } else {
                                                var13_13[var16_18].inc();
                                            }
                                        } else {
                                            var1_1.retAddressStackPos = var1_1.retAddressStackPos + ((var2_2.getOpCode() & 8) != 0 ? 1 : -1);
                                            var5_5.setSpOffset(var5_5.getSpOffset() + ((var2_2.getOpCode() & 8) != 0 ? -1 : 1));
                                        }
                                    } else if ((var2_2.getOpCode() & 7) == 4) {
                                        var16_19 = var2_2.getOpCode() >> 3 & 7;
                                        if (var16_19 != 6) {
                                            var12_12[var16_19].inc(var4_4 != null && var4_4.getOpCode() == 48 && var4_4.getArg() == 1);
                                        } else {
                                            Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[var15_15].getValue(), var2_2.getDisplacement(), Value.newUnknownValue(255), var5_5);
                                        }
                                    } else if ((var2_2.getOpCode() & 7) == 5) {
                                        var16_20 = var2_2.getOpCode() >> 3 & 7;
                                        if (var16_20 != 6) {
                                            var12_12[var16_20].dec();
                                        } else {
                                            Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[var15_15].getValue(), var2_2.getDisplacement(), Value.newUnknownValue(255), var5_5);
                                        }
                                    }
                                    break block171;
                                }
                                if (var2_2.getOpCode() >> 6 != 1) break block173;
                                Z80Disassembler.LD_r_r(var2_2, var5_5, var10_10, var11_11, var15_15);
                                break block171;
                            }
                            if (var2_2.getOpCode() >> 6 != 2) break block174;
                            Z80Disassembler.ALUOP_A_r(var2_2, var5_5, var10_10, var11_11, var15_15);
                            break block171;
                        }
                        if ((var2_2.getOpCode() & 65280) != 51968) break block175;
                        Z80Disassembler.CB(var2_2, var5_5, var10_10, var11_11, var15_15);
                        break block171;
                    }
                    if ((var2_2.getOpCode() & 207) != 193) break block176;
                    var16_21 = var2_2.getOpCode() >> 4 & 3;
                    if (var16_21 == 2) {
                        var16_21 = var15_15;
                    }
                    if (!var14_14.isEmpty()) {
                        var13_13[var16_21].value = var14_14.pop();
                        if (var16_21 == 3) {
                            var12_12[var16_21 << 1].setValue(var14_14.pop());
                            var12_12[var16_21 << 1 | 1].setValue(var14_14.pop());
                        } else {
                            var12_12[var16_21 << 1 | 1].setValue(var14_14.pop());
                            var12_12[var16_21 << 1].setValue(var14_14.pop());
                        }
                        if (var1_1.retAddressStackPos == 0) {
                            var1_1.retAddressValue = var13_13[var16_21].getValue();
                        }
                    } else {
                        var13_13[var16_21].value = null;
                        var12_12[var16_21 << 1 | 1].setValue(Value.newUnknownValue(255));
                        var12_12[var16_21 << 1].setValue(Value.newUnknownValue(255));
                    }
                    var5_5.setSpOffset(var5_5.getSpOffset() + 2);
                    var1_1.retAddressStackPos -= 2;
                    break block171;
                }
                if ((var2_2.getOpCode() & 207) != 197) break block177;
                var16_22 = var2_2.getOpCode() >> 4 & 3;
                if (var16_22 == 2) {
                    var16_22 = var15_15;
                }
                if (var16_22 == 3) {
                    var14_14.push(var12_12[var16_22 << 1 | 1].getValue());
                    var14_14.push(var12_12[var16_22 << 1].getValue());
                } else {
                    var14_14.push(var12_12[var16_22 << 1].getValue());
                    var14_14.push(var12_12[var16_22 << 1 | 1].getValue());
                }
                var14_14.push(var13_13[var16_22].value);
                var5_5.setSpOffset(var5_5.getSpOffset() - 2);
                var1_1.retAddressStackPos += 2;
                break block171;
            }
            switch (var2_2.getOpCode()) {
                case 7: {
                    var12_12[7].rlc();
                    break;
                }
                case 23: {
                    var12_12[7].rl();
                    break;
                }
                case 39: {
                    var12_12[7].setValue(Value.newUnknownValue(var12_12[7].getSource(), 153));
                    break;
                }
                case 15: {
                    var12_12[7].rrca();
                    break;
                }
                case 31: {
                    var12_12[7].rr();
                    break;
                }
                case 8: {
                    var5_5.exAF();
                    break;
                }
                case 2: {
                    Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[0].getValue(), var12_12[7].getValue(), var5_5);
                    break;
                }
                case 18: {
                    Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[1].getValue(), var12_12[7].getValue(), var5_5);
                    break;
                }
                case 50: {
                    Z80Disassembler.WRITE_BYTE(var10_10, var11_11, new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)), var12_12[7].getValue(), var5_5);
                    break;
                }
                case 9: {
                    var13_13[var15_15].add(var13_13[0]);
                    break;
                }
                case 25: {
                    var13_13[var15_15].add(var13_13[1]);
                    break;
                }
                case 41: {
                    var13_13[var15_15].add(var13_13[var15_15]);
                    break;
                }
                case 57: {
                    var13_13[var15_15].addSP();
                    break;
                }
                case 10: {
                    var12_12[7].setValue(Z80Disassembler.READ_BYTE(var10_10, var11_11, var13_13[0].getValue(), var5_5));
                    break;
                }
                case 26: {
                    var12_12[7].setValue(Z80Disassembler.READ_BYTE(var10_10, var11_11, var13_13[1].getValue(), var5_5));
                    break;
                }
                case 42: {
                    Z80Disassembler.READ_WORD(var13_13[var15_15], var10_10, var11_11, new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)), var5_5);
                    break;
                }
                case 58: {
                    var12_12[7].setValue(Z80Disassembler.READ_BYTE(var10_10, var11_11, new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)), var5_5));
                    break;
                }
                case 47: {
                    var12_12[7].cpl();
                    break;
                }
                case 211: {
                    Z80Disassembler.markPortSeen(var2_2.getArg(), var3_3 - var2_2.getSize());
                    break;
                }
                case 219: {
                    var12_12[7].setValue(Value.newUnknownValue(255));
                    Z80Disassembler.markPortSeen(var2_2.getArg(), var3_3 - var2_2.getSize());
                    break;
                }
                case 198: {
                    var12_12[7].add(var2_2.getArg());
                    break;
                }
                case 206: {
                    var12_12[7].adc(var2_2.getArg());
                    break;
                }
                case 214: 
                case 222: {
                    var12_12[7].sub(var2_2.getArg());
                    break;
                }
                case 230: {
                    var12_12[7].and(var2_2.getArg());
                    break;
                }
                case 238: {
                    var12_12[7].xor(var2_2.getArg());
                    break;
                }
                case 246: {
                    var12_12[7].or(var2_2.getArg());
                    break;
                }
                case 217: {
                    var5_5.exx();
                    break;
                }
                case 235: {
                    var13_13[1].ex(var13_13[2]);
                    break;
                }
                case 249: {
                    var5_5.ldSP(var13_13[var15_15]);
                    break;
                }
                case 24: {
                    if (var2_2.getArg() == -var2_2.getSize()) {
                        Z80Disassembler.addPath(var3_3 - var2_2.getSize(), var7_7[0]);
                        Z80Disassembler.markSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize());
                        Z80Disassembler.shouldReturn = Boolean.TRUE;
                        var5_5.popPC();
                        return var3_3;
                    }
                    if (var2_2.getArg() < 0 && Z80Disassembler.isSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize()) && Z80Disassembler.isLoop(var3_3 - var2_2.getSize())) {
                        Z80Disassembler.shouldReturn = Boolean.TRUE;
                        return var3_3;
                    }
                    if (this.isRAMaddress(var5_5.getPC())) {
                        Z80Disassembler.setRAMcodeAddress(this.mapRAMaddress(var5_5.getPC() + var2_2.getArg()), var3_3 + var2_2.getArg());
                    }
                    Z80Disassembler.addPath(var3_3 - var2_2.getSize(), var7_7[0]);
                    var7_7[0] = var3_3 - var2_2.getSize();
                    Z80Disassembler.markSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize());
                    var5_5.addToPC(var2_2.getArg());
                    var5_5.setPC(var5_5.getPC() & 65535);
                    break;
                }
                case 16: {
                    if (Z80Disassembler.isSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize())) break;
                    var16_23 = new State(var5_5);
                    var16_23.djnz();
                    if (this.isRAMaddress(var5_5.getPC())) {
                        Z80Disassembler.setRAMcodeAddress(this.mapRAMaddress(var5_5.getPC() + var2_2.getArg()), var3_3 + var2_2.getArg());
                    }
                    Z80Disassembler.markSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize());
                    if (var2_2.getArg() == 0 || this.analyze(var1_1, var5_5.getPC() + var2_2.getArg() & 65535, var3_3 - var2_2.getSize(), -1, var7_7, var16_23, var9_9 + 1, var8_8) || this.getEntryPoints().length > 0 && var6_6 == this.getEntryPoints()[0]) break;
                    Z80Disassembler.shouldReturn = Boolean.FALSE;
                    return var3_3;
                }
                case 32: 
                case 40: {
                    var3_3 = this.JR_cc(var1_1, var2_2, var5_5, var3_3, var6_6, var7_7, var9_9 + 1, var8_8);
                    if (Z80Disassembler.shouldReturn == null) break;
                    return var3_3;
                }
                case 48: {
                    if (var4_4.getOpCode() == 254) {
                        if (!Z80Disassembler.isSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize())) {
                            Z80Disassembler.markSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize());
                            var16_24 = new State(var5_5);
                            if (var4_4.getArg() > var12_12[7].getValue().getMin()) {
                                var16_24.getRegs()[7].setValue(var12_12[7].getValue().newValue(var4_4.getArg(), var12_12[7].getValue().getMax()));
                            }
                            if (!(var2_2.getArg() == 0 || this.analyze(var1_1, var5_5.getPC() + var2_2.getArg() & 65535, var3_3 - var2_2.getSize(), -1, var7_7, var16_24, var9_9 + 1, var8_8) || this.getEntryPoints().length > 0 && var6_6 == this.getEntryPoints()[0])) {
                                Z80Disassembler.shouldReturn = Boolean.FALSE;
                                return var3_3;
                            }
                        }
                        if (var4_4.getArg() <= 0 && (this.getEntryPoints().length <= 0 || var6_6 != this.getEntryPoints()[0])) {
                            Z80Disassembler.shouldReturn = Boolean.TRUE;
                            return var3_3;
                        }
                        if (var4_4.getArg() > var12_12[7].getValue().getMax()) break;
                        var12_12[7].setValue(var12_12[7].getValue().newValue(var12_12[7].getValue().getMin(), var4_4.getArg() - 1));
                        break;
                    }
                    var3_3 = this.JR_cc(var1_1, var2_2, var5_5, var3_3, var6_6, var7_7, var9_9 + 1, var8_8);
                    if (Z80Disassembler.shouldReturn == null) break;
                    return var3_3;
                }
                case 56: {
                    if (var4_4.getOpCode() == 254 && var4_4.getArg() > 0) {
                        if (!Z80Disassembler.isSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize())) {
                            Z80Disassembler.markSeen(var5_5.getPC() + var2_2.getArg() & 65535, var11_11, var5_5, var3_3 - var2_2.getSize());
                            var16_25 = new State(var5_5);
                            if (var4_4.getArg() <= var12_12[7].getValue().getMax()) {
                                var16_25.getRegs()[7].setValue(var12_12[7].getValue().newValue(var12_12[7].getValue().getMin(), var4_4.getArg() - 1));
                            }
                            if (!(var2_2.getArg() == 0 || this.analyze(var1_1, var5_5.getPC() + var2_2.getArg() & 65535, var3_3 - var2_2.getSize(), -1, var7_7, var16_25, var9_9 + 1, var8_8) || this.getEntryPoints().length > 0 && var6_6 == this.getEntryPoints()[0])) {
                                Z80Disassembler.shouldReturn = Boolean.FALSE;
                                return var3_3;
                            }
                        }
                        if (var4_4.getArg() <= var12_12[7].getValue().getMin()) break;
                        var12_12[7].setValue(var12_12[7].getValue().newValue(var4_4.getArg(), var12_12[7].getValue().getMax()));
                        break;
                    }
                    if (var4_4 instanceof LR35902Instruction && (var4_4.getOpCode() & 65528) == 52016) {
                        Z80Disassembler.removeInstruction(var3_3 -= var2_2.getSize());
                        Z80Disassembler.code[var3_3] = -64;
                        Z80Disassembler.code[var3_3 + 1] = 0;
                        var5_5.setPC(var5_5.getPC() - 1);
                        break;
                    }
                    var3_3 = this.JR_cc(var1_1, var2_2, var5_5, var3_3, var6_6, var7_7, var9_9 + 1, var8_8);
                    if (Z80Disassembler.shouldReturn == null) break;
                    return var3_3;
                }
                case 195: {
                    var19_39 = Z80Disassembler.instance.getEntryPoints();
                    var18_45 = var19_39.length;
                    var17_34 = 0;
                    while (var17_34 < var18_45) {
                        var16_26 = var19_39[var17_34];
                        if (var2_2.getArg() == var16_26 && Z80Disassembler.isCode(var16_26)) {
                            Z80Disassembler.shouldReturn = Boolean.TRUE;
                            return var3_3;
                        }
                        ++var17_34;
                    }
                    if (Z80Disassembler.instance.isRAMaddress(var2_2.getArg())) {
                        var16_27 = var5_5.getRAMvalue(var2_2.getArg());
                        if (var16_27 != null && var16_27.isUnique() && var16_27.getMin() == 195 && var5_5.getRAMvalue(var2_2.getArg() + 1).isUnique() && var5_5.getRAMvalue(var2_2.getArg() + 2) != null && var5_5.getRAMvalue(var2_2.getArg() + 2).isUnique()) {
                            var17_34 = var5_5.getRAMvalue(var2_2.getArg() + 2).getMin() << 8 | var5_5.getRAMvalue(var2_2.getArg() + 1).getMin();
                            if (Z80Disassembler.isSeen(var17_34, var11_11, var5_5, var3_3 - var2_2.getSize()) && Z80Disassembler.isLoop(var3_3 - var2_2.getSize())) {
                                Z80Disassembler.shouldReturn = Boolean.TRUE;
                                return var3_3;
                            }
                            Z80Disassembler.addPath(var3_3 - var2_2.getSize(), var7_7[0]);
                            var7_7[0] = var3_3 - var2_2.getSize();
                            Z80Disassembler.markSeen(var17_34, var11_11, var5_5, var3_3 - var2_2.getSize());
                            var5_5.setPC(var17_34);
                            if (Z80Disassembler.memoryTables.containsKey(var2_2.getArg() + 1)) break;
                            Z80Disassembler.memoryTables.put(var2_2.getArg() + 1, new Table(0, 0, Z80Disassembler.toAddress(var2_2.getArg() + 1, var11_11, var5_5), null, var5_5));
                            Z80Disassembler.memoryJump.set(var2_2.getArg() + 1);
                            break;
                        }
                    } else if (this.isBiosAddress(var2_2.getArg(), var5_5)) {
                        Z80Disassembler.shouldReturn = Boolean.TRUE;
                        return var3_3;
                    }
                    if (Z80Disassembler.isSeen(var2_2.getArg(), var11_11, var5_5, var3_3 - var2_2.getSize()) && Z80Disassembler.isLoop(var3_3 - var2_2.getSize())) {
                        Z80Disassembler.shouldReturn = Boolean.TRUE;
                        return var3_3;
                    }
                    Z80Disassembler.addPath(var3_3 - var2_2.getSize(), var7_7[0]);
                    var7_7[0] = var3_3 - var2_2.getSize();
                    Z80Disassembler.markSeen(var2_2.getArg(), var11_11, var5_5, var3_3 - var2_2.getSize());
                    var5_5.setPC(var2_2.getArg());
                    var3_3 = -1;
                    break;
                }
                case 194: 
                case 202: 
                case 210: 
                case 218: 
                case 226: 
                case 234: 
                case 242: 
                case 250: {
                    if (Z80Disassembler.isSeen(var2_2.getArg(), var11_11, var5_5, var3_3 - var2_2.getSize())) break;
                    Z80Disassembler.markSeen(var2_2.getArg(), var11_11, var5_5, var3_3 - var2_2.getSize());
                    if (this.analyze(var1_1, var2_2.getArg(), var3_3 - var2_2.getSize(), -1, new int[]{-1}, new State(var5_5), var9_9 + 1, var8_8) || this.getEntryPoints().length > 0 && var6_6 == this.getEntryPoints()[0]) break;
                    Z80Disassembler.shouldReturn = Boolean.FALSE;
                    return var3_3;
                }
                case 196: 
                case 204: 
                case 205: 
                case 212: 
                case 220: 
                case 228: 
                case 236: 
                case 244: 
                case 252: {
                    if (this.isBiosAddress(var2_2.getArg(), var5_5)) break;
                    var16_28 = var5_5;
                    if (var2_2.getOpCode() != 205) {
                        var5_5 = new State(var5_5);
                    }
                    var17_35 = var5_5.getPC();
                    try {
                        var18_46 = false;
                        if (Z80Disassembler.instance.isRAMaddress(var2_2.getArg())) {
                            if (Z80Disassembler.memoryJump.get(var2_2.getArg() + 1)) {
                                var19_40 = Z80Disassembler.memoryTables.get(var2_2.getArg() + 1);
                                if (var19_40 != null) {
                                    if (var19_40.start != 0) {
                                        Z80Disassembler.memoryJumps.put(var19_40.source.getMin() << 16 | var2_2.getArg() + 1, new MemoryJump(var19_40.source.getMin(), var19_40.start, var5_5));
                                    }
                                    var18_46 = true;
                                }
                            } else {
                                var19_40 = var5_5.getRAMvalue(var2_2.getArg());
                                if (var19_40 != null && var19_40.isUnique() && var19_40.getMin() == 195 && var5_5.getRAMvalue(var2_2.getArg() + 1).isUnique() && var5_5.getRAMvalue(var2_2.getArg() + 2) != null && var5_5.getRAMvalue(var2_2.getArg() + 2).isUnique()) {
                                    var20_50 = var5_5.getRAMvalue(var2_2.getArg() + 2).getMin() << 8 | var5_5.getRAMvalue(var2_2.getArg() + 1).getMin();
                                    Z80Disassembler.markSeen(var20_50, var11_11, var5_5, var3_3 - var2_2.getSize());
                                    if (!(this.analyze(var1_1, var20_50, var3_3 - var2_2.getSize(), -1, new int[]{-1}, var5_5, var9_9 + 1, var8_8) || this.getEntryPoints().length > 0 && var6_6 == this.getEntryPoints()[0])) {
                                        Z80Disassembler.shouldReturn = Boolean.FALSE;
                                        return var3_3;
                                    }
                                    var18_46 = true;
                                }
                                if (!Z80Disassembler.memoryTables.containsKey(var2_2.getArg() + 1)) {
                                    Z80Disassembler.memoryTables.put(var2_2.getArg() + 1, new Table(0, 0, Z80Disassembler.toAddress(var2_2.getArg() + 1, var11_11, var5_5), null, var5_5));
                                    Z80Disassembler.memoryJump.set(var2_2.getArg() + 1);
                                }
                            }
                        }
                        if (!var18_46) {
                            var19_41 = var5_5.getSpOffset();
                            var20_50 = Z80Disassembler.instance.isROMaddress(var2_2.getArg(), var5_5) != false && (this.getInstruction(var10_10, Z80Disassembler.RESOLVE_ADDRESS(var2_2.getArg(), var11_11, var5_5)).getOpCode() & 207) == 193 ? 1 : 0;
                            var5_5.setSpOffset(var4_4 != null && var4_4.getOpCode() == 51 ? 1 : 0);
                            if (var20_50 != 0) {
                                Z80Disassembler.retAddresses.push(var3_3);
                                var5_5.pushPC();
                            } else {
                                var5_5.setSpOffset(var5_5.getSpOffset() + 2);
                            }
                            var21_53 = var14_14.size();
                            Z80Disassembler.markSeen(var2_2.getArg(), var11_11, var5_5, var3_3 - var2_2.getSize());
                            if (!(this.analyze(var1_1, var2_2.getArg(), var3_3 - var2_2.getSize(), -1, new int[]{-1}, var5_5, var9_9 + 1, var8_8) || this.getEntryPoints().length > 0 && var6_6 == this.getEntryPoints()[0])) {
                                if (var20_50 != 0) {
                                    var5_5.popPC();
                                }
                                var5_5.setSpOffset(var19_41);
                                Z80Disassembler.shouldReturn = Boolean.FALSE;
                                return var3_3;
                            }
                            var5_5.setSpOffset(var19_41);
                            if (var20_50 != 0) {
                                while (var14_14.size() > var21_53) {
                                    var14_14.pop();
                                    var14_14.pop();
                                    var14_14.pop();
                                }
                                var5_5.setPC(var17_35);
                                var22_55 = var5_5.popPC();
                                var23_56 = Z80Disassembler.retAddresses.pop();
                                if (var23_56 != var3_3) {
                                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                                    return var3_3;
                                }
                                if (var22_55 != var17_35) {
                                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                                    return var3_3;
                                }
                            }
                        }
                    }
                    catch (ResolveAddressException v1) {
                        if (Z80Disassembler.ALLOW_CALLS_TO_UNKNOWN_RAM) ** GOTO lbl389
                        Z80Disassembler.ERROR_STREAM.println("Call to unknown RAM from " + Integer.toHexString(var3_3 - var2_2.getSize()));
                        Z80Disassembler.shouldReturn = Boolean.FALSE;
                        return var3_3;
                    }
lbl389:
                    // 2 sources

                    if (var5_5 != var16_28) {
                        var16_28.union(var5_5);
                    }
                    var5_5 = var16_28;
                    var5_5.setPC(var17_35);
                    break;
                }
                case 192: 
                case 200: 
                case 208: 
                case 216: 
                case 224: 
                case 232: 
                case 240: 
                case 248: {
                    if (var1_1.retAddressStackPos > 0 && !var14_14.isEmpty()) {
                        var16_29 = new State(var5_5);
                        var16_29.getStack().pop();
                        var17_36 = var16_29.getStack().pop();
                        var18_47 = var16_29.getStack().pop();
                        if (!var17_36.isUnique() || !var18_47.isUnique() || var18_47.getSource().getMin() - var17_36.getSource().getMin() != 1 || !this.isROMaddress(var19_42 = var18_47.getMin() << 8 | var17_36.getMin(), var5_5) || Z80Disassembler.isSeen(var19_42, var11_11, var16_29, var17_36.getSource().getMin())) break;
                        if (!Z80Disassembler.badCode.get(var19_42)) {
                            var20_51 = Z80Disassembler.hasLabel(var19_42);
                            Z80Disassembler.markSeen(var19_42, var11_11, var16_29, var17_36.getSource().getMin());
                            Z80Disassembler.overridingRet.set(var17_36.getSource().getMin());
                            var21_54 = new ArrayIntDeque();
                            if (!this.analyze(var1_1, var19_42, var17_36.getSource().getMin(), -1, new int[]{-1}, var16_29, var9_9 + 1, var21_54)) {
                                Z80Disassembler.undoCode(var21_54, var11_11);
                                if (!var20_51) {
                                    Z80Disassembler.removeLabel(var19_42);
                                }
                                Z80Disassembler.badCode.set(var19_42);
                            } else {
                                var8_8.pushAll(var21_54);
                            }
                        }
                    }
                    var1_1.conditionalRetStates.add(Z80Disassembler.unmodifiableState(var5_5));
                    break;
                }
                case 201: 
                case 60741: 
                case 60749: 
                case 60757: 
                case 60765: 
                case 60773: 
                case 60781: 
                case 60789: 
                case 60797: {
                    if (!(var4_4.getOpCode() != 49 || Z80Disassembler.isSeen(Z80Disassembler.READ_WORD(var10_10, var4_4.getArg()), var11_11, var5_5, var3_3 - var2_2.getSize()) && Z80Disassembler.isLoop(var3_3 - var2_2.getSize()))) {
                        Z80Disassembler.addPath(var3_3 - var2_2.getSize(), var7_7[0]);
                        var7_7[0] = var3_3 - var2_2.getSize();
                        Z80Disassembler.markSeen(Z80Disassembler.READ_WORD(var10_10, var4_4.getArg()), var11_11, var5_5, var3_3 - var2_2.getSize());
                        var5_5.setPC(Z80Disassembler.READ_WORD(var10_10, var4_4.getArg()));
                        break;
                    }
                    if ((var4_4.getOpCode() & 207) == 197 && this.JP_rr(var1_1, var2_2, var5_5, (var16_30 = var4_4.getOpCode() >> 4 & 3) == 2 ? var15_15 : var16_30, var3_3, var9_9 + 1, var8_8)) {
                        return var3_3;
                    }
                    if (var1_1.retAddressStackPos > 0 && !var14_14.isEmpty()) {
                        var14_14.pop();
                        var16_31 = var14_14.pop();
                        var17_37 = var14_14.pop();
                        if (var17_37.getMax() - var17_37.getMin() > 1 || var17_37.getSource() == null || var16_31.getSource() == null || var17_37.getSource().getMin() - var16_31.getSource().getMin() != 1 && (var16_31.getSource().getAdditional() == null || var17_37.getSource().getMin() - var16_31.getSource().getAdditional().getMin() != 1)) {
                            Z80Disassembler.shouldReturn = Boolean.TRUE;
                            return var3_3;
                        }
                        var18_48 = var17_37.getMin() << 8 | var16_31.getMin();
                        if (!this.isROMaddress(var18_48, var5_5) || Z80Disassembler.isSeen(var18_48, var11_11, var5_5, var16_31.getSource().getMin())) {
                            Z80Disassembler.shouldReturn = Boolean.TRUE;
                            return var3_3;
                        }
                        if (var16_31.getSource().getSource() != null && !Z80Disassembler.isCode(var16_31.getSource().getMin())) {
                            Z80Disassembler.addTable(Z80Disassembler.jumpTables, var16_31.getSource().getMin(), var16_31.getSource().getMin() + 2, var16_31.getSource().getSource(), null, var5_5);
                        }
                        if (!Z80Disassembler.badCode.get(var18_48)) {
                            var19_43 = Z80Disassembler.hasLabel(var18_48);
                            Z80Disassembler.markSeen(var18_48, var11_11, var5_5, var16_31.getSource().getMin());
                            Z80Disassembler.overridingRet.set(var16_31.getSource().getMin());
                            var20_52 = new ArrayIntDeque();
                            if (!this.analyze(var1_1, var18_48, var16_31.getSource().getMin(), -1, new int[]{-1}, var5_5, var9_9 + 1, var20_52)) {
                                Z80Disassembler.undoCode(var20_52, var11_11);
                                if (!var19_43) {
                                    Z80Disassembler.removeLabel(var18_48);
                                }
                                Z80Disassembler.badCode.set(var18_48);
                            } else {
                                var8_8.pushAll(var20_52);
                            }
                        }
                    }
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 34: {
                    Z80Disassembler.LD_nn_rr(var2_2, var5_5, var10_10, var11_11, var13_13[var15_15]);
                    break;
                }
                case 227: {
                    Z80Disassembler.EX_SP_HL(var1_1, var5_5, var15_15, var3_3);
                    break;
                }
                case 233: {
                    if (this.JP_rr(var1_1, var2_2, var5_5, var15_15, var3_3, var9_9 + 1, var8_8)) break;
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 199: 
                case 207: 
                case 215: 
                case 223: 
                case 231: 
                case 239: 
                case 247: 
                case 255: {
                    if (var2_2.getOpCode() == 199 && !this.allowRST0H()) {
                        Z80Disassembler.shouldReturn = Boolean.TRUE;
                        return var3_3;
                    }
                    if (var3_3 - var2_2.getSize() == var2_2.getOpCode() - 199) {
                        Z80Disassembler.ERROR_STREAM.println("RST " + Integer.toHexString(var2_2.getOpCode() - 199) + "H encountered that loops to itself from " + Integer.toHexString(var6_6) + "!");
                        Z80Disassembler.shouldReturn = Boolean.FALSE;
                        Z80Disassembler.undoCode(var3_3 - var2_2.getSize(), var11_11);
                        return var3_3;
                    }
                    if (var2_2.getOpCode() == 255) {
                        if (var10_10[var3_3] == var2_2.getOpCode()) {
                            Z80Disassembler.ERROR_STREAM.println("Consecutive RST " + Integer.toHexString(var2_2.getOpCode() - 199) + "H encountered at " + Integer.toHexString(var3_3 - var2_2.getSize()) + "!");
                            Z80Disassembler.shouldReturn = Boolean.FALSE;
                            return var3_3;
                        }
                        if (var6_6 == 56) {
                            Z80Disassembler.ERROR_STREAM.println("RST 38H encountered in interrupt handler at " + Integer.toHexString(var3_3 - var2_2.getSize()) + "!");
                            Z80Disassembler.shouldReturn = Boolean.FALSE;
                            return var3_3;
                        }
                        if (!this.allowRST38H()) {
                            Z80Disassembler.ERROR_STREAM.println("RST " + Integer.toHexString(var2_2.getOpCode() - 199) + "H encountered at " + Integer.toHexString(var3_3 - var2_2.getSize()) + "!");
                            Z80Disassembler.shouldReturn = Boolean.FALSE;
                            return var3_3;
                        }
                        if (Z80Disassembler.isSeen(56, var11_11, var5_5, var3_3 - var2_2.getSize())) {
                            Z80Disassembler.shouldReturn = Boolean.TRUE;
                            return var3_3;
                        }
                    }
                    Z80Disassembler.retAddresses.push(var3_3);
                    var16_32 = var5_5.getPC();
                    var5_5.pushPC();
                    var17_38 = var14_14.size();
                    Z80Disassembler.markSeen(var2_2.getOpCode() - 199, var11_11, var5_5, var3_3 - var2_2.getSize());
                    if (this.analyze(var1_1, var2_2.getOpCode() - 199, var3_3 - var2_2.getSize(), -1, new int[]{-1}, var5_5, var9_9 + 1, var8_8)) ** GOTO lbl505
                    var5_5.popPC();
                    Z80Disassembler.shouldReturn = Boolean.FALSE;
                    return var3_3;
lbl-1000:
                    // 1 sources

                    {
                        var14_14.pop();
                        var14_14.pop();
                        var14_14.pop();
lbl505:
                        // 2 sources

                        ** while (var14_14.size() > var17_38)
                    }
lbl506:
                    // 1 sources

                    var5_5.setPC(var16_32);
                    var18_49 = var5_5.popPC();
                    var19_44 = Z80Disassembler.retAddresses.pop();
                    if (var19_44 - var3_3 > 0 && var19_44 - var3_3 <= 3) {
                        var5_5.addToPC(var19_44 - var3_3);
                        var16_32 += var19_44 - var3_3;
                    } else if (var19_44 != var3_3) {
                        Z80Disassembler.shouldReturn = Boolean.TRUE;
                        return var3_3;
                    }
                    if (var18_49 == var16_32) break;
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 60787: {
                    Z80Disassembler.LD_nn_SP(var2_2, var5_5);
                    break;
                }
                case 60738: {
                    var13_13[var15_15].sub(var13_13[0]);
                    break;
                }
                case 60740: {
                    var12_12[7].neg();
                    break;
                }
                case 60739: {
                    Z80Disassembler.LD_nn_rr(var2_2, var5_5, var10_10, var11_11, var13_13[0]);
                    break;
                }
                case 60754: {
                    var13_13[var15_15].sub(var13_13[1]);
                    break;
                }
                case 60755: {
                    Z80Disassembler.LD_nn_rr(var2_2, var5_5, var10_10, var11_11, var13_13[1]);
                    break;
                }
                case 60770: {
                    var13_13[var15_15].sub(var13_13[var15_15]);
                    break;
                }
                case 60746: {
                    var13_13[var15_15].add(var13_13[0]);
                    break;
                }
                case 60762: {
                    var13_13[var15_15].add(var13_13[1]);
                    break;
                }
                case 60767: {
                    var12_12[7].ld(Value.newUnknownValue(255));
                    break;
                }
                case 60778: {
                    var13_13[var15_15].add(var13_13[var15_15]);
                    break;
                }
                case 60747: {
                    Z80Disassembler.READ_WORD(var13_13[0], var10_10, var11_11, new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)), var5_5);
                    break;
                }
                case 60763: {
                    Z80Disassembler.READ_WORD(var13_13[1], var10_10, var11_11, new Value(var2_2.getArg(), Z80Disassembler.toAddress(var5_5.getPC() - var2_2.getSize(), var11_11, var5_5)), var5_5);
                    break;
                }
                case 60848: {
                    if (Z80Disassembler.LDIR(var2_2, var5_5, var3_3, var11_11, var10_10)) break;
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 60856: {
                    if (Z80Disassembler.LDDR(var2_2, var5_5, var3_3, var11_11, var10_10)) break;
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 60832: {
                    Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[1].getValue(), Z80Disassembler.READ_BYTE(var10_10, var11_11, var13_13[2].getValue(), var5_5), var5_5);
                    var13_13[0].dec();
                    var13_13[1].inc();
                    var13_13[2].inc();
                    break;
                }
                case 60840: {
                    Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[1].getValue(), Z80Disassembler.READ_BYTE(var10_10, var11_11, var13_13[2].getValue(), var5_5), var5_5);
                    var13_13[0].dec();
                    var13_13[1].dec();
                    var13_13[2].dec();
                    break;
                }
                case 60835: {
                    Z80Disassembler.READ_BYTE(var10_10, var11_11, var13_13[2].getValue(), var5_5);
                    var13_13[2].inc();
                    var12_12[0].dec();
                    Z80Disassembler.markPortSeen(var12_12[1].getValue());
                    break;
                }
                case 60843: {
                    Z80Disassembler.READ_BYTE(var10_10, var11_11, var13_13[2].getValue(), var5_5);
                    var13_13[2].dec();
                    var12_12[0].dec();
                    Z80Disassembler.markPortSeen(var12_12[1].getValue());
                    break;
                }
                case 60851: {
                    if (Z80Disassembler.OTIR(var2_2, var5_5, var3_3, var11_11, var10_10)) break;
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 60859: {
                    if (Z80Disassembler.OTDR(var2_2, var5_5, var3_3, var11_11, var10_10)) break;
                    Z80Disassembler.shouldReturn = Boolean.TRUE;
                    return var3_3;
                }
                case 60834: 
                case 60842: 
                case 60850: 
                case 60858: {
                    Z80Disassembler.WRITE_BYTE(var10_10, var11_11, var13_13[2].getValue(), Value.newUnknownValue(255), var5_5);
                    Z80Disassembler.markPortSeen(var12_12[1].getValue());
                    break;
                }
                case 60737: 
                case 60745: 
                case 60753: 
                case 60761: 
                case 60769: 
                case 60777: 
                case 60785: 
                case 60793: {
                    Z80Disassembler.markPortSeen(var12_12[1].getValue());
                    break;
                }
                case 60736: 
                case 60744: 
                case 60752: 
                case 60760: 
                case 60768: 
                case 60776: 
                case 60784: 
                case 60792: {
                    Z80Disassembler.markPortSeen(var12_12[1].getValue());
                }
            }
        }
        return var3_3;
    }

    private static final void ALUOP_A_r(Z80Instruction z80Instruction, State state, int[] nArray, RamRomMap ramRomMap, int n) {
        Register[] registerArray = state.getRegs();
        RegisterPair[] registerPairArray = state.getRegPairs();
        int n2 = z80Instruction.getOpCode() & 7;
        switch (z80Instruction.getOpCode() >> 3 & 7) {
            case 0: {
                if (n2 == 6) {
                    registerArray[7].add(Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
                    break;
                }
                registerArray[7].add(registerArray[n2]);
                break;
            }
            case 1: {
                if (n2 == 6) {
                    registerArray[7].adc(Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
                    break;
                }
                registerArray[7].adc(registerArray[n2]);
                break;
            }
            case 2: 
            case 3: {
                if (n2 == 6) {
                    registerArray[7].sub(Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
                    break;
                }
                registerArray[7].sub(registerArray[n2]);
                break;
            }
            case 4: {
                if (n2 == 6) {
                    registerArray[7].and(Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
                    break;
                }
                registerArray[7].and(registerArray[7]);
                break;
            }
            case 5: {
                if (n2 == 6) {
                    registerArray[7].xor(Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
                    break;
                }
                registerArray[7].xor(registerArray[n2]);
                break;
            }
            case 6: {
                if (n2 == 6) {
                    registerArray[7].or(Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
                    break;
                }
                registerArray[7].or(registerArray[n2]);
            }
        }
    }

    private static final void CB(Z80Instruction z80Instruction, State state, int[] nArray, RamRomMap ramRomMap, int n) {
        Register[] registerArray = state.getRegs();
        RegisterPair[] registerPairArray = state.getRegPairs();
        int n2 = z80Instruction.getOpCode() >> 3 & 7;
        int n3 = z80Instruction.getOpCode() & 7;
        switch (z80Instruction.getOpCode() >> 6 & 3) {
            case 0: {
                switch (z80Instruction.getOpCode() >> 3 & 7) {
                    case 0: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).rlc(), state);
                            break;
                        }
                        registerArray[n3].rlc();
                        break;
                    }
                    case 1: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).rrc(), state);
                            break;
                        }
                        registerArray[n3].rrc();
                        break;
                    }
                    case 2: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).rl(), state);
                            break;
                        }
                        registerArray[n3].rl();
                        break;
                    }
                    case 3: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).rr(), state);
                            break;
                        }
                        registerArray[n3].rr();
                        break;
                    }
                    case 4: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).sla(), state);
                            break;
                        }
                        registerArray[n3].sla();
                        break;
                    }
                    case 5: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).sra(), state);
                            break;
                        }
                        registerArray[n3].sra();
                        break;
                    }
                    case 6: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).sll(), state);
                            break;
                        }
                        registerArray[n3].sll();
                        break;
                    }
                    case 7: {
                        if (n3 == 6) {
                            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).srl(), state);
                            break;
                        }
                        registerArray[n3].srl();
                    }
                }
                break;
            }
            case 1: {
                if (n3 != 6) break;
                Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state);
                break;
            }
            case 2: {
                if (n3 == 6) {
                    Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).resBit(n2), state);
                    break;
                }
                registerArray[n3].res(n2);
                break;
            }
            case 3: {
                if (n3 == 6) {
                    Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state).setBit(n2), state);
                    break;
                }
                registerArray[n3].set(n2);
            }
        }
    }

    private static final void LD_r_r(Z80Instruction z80Instruction, State state, int[] nArray, RamRomMap ramRomMap, int n) {
        Register[] registerArray = state.getRegs();
        RegisterPair[] registerPairArray = state.getRegPairs();
        int n2 = z80Instruction.getOpCode() >> 3 & 7;
        int n3 = z80Instruction.getOpCode() & 7;
        if (n3 == 6) {
            if (n2 != 6) {
                registerArray[n2].ld(Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), state));
            }
        } else if (n2 == 6) {
            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[n].getValue(), z80Instruction.getDisplacement(), registerArray[n3].getValue(), state);
        } else {
            registerArray[n2].ld(registerArray[n3]);
        }
    }

    private static final boolean LDIR(Z80Instruction z80Instruction, State state, int n, RamRomMap ramRomMap, int[] nArray) {
        RegisterPair[] registerPairArray = state.getRegPairs();
        if (registerPairArray[0].getValue().isUnique() && registerPairArray[1].getValue().isUnique() && registerPairArray[0].getMinValue() > 0) {
            int n2 = registerPairArray[0].getMinValue();
            int n3 = registerPairArray[1].getMinValue();
            int n4 = registerPairArray[2].getMinValue();
            if (registerPairArray[2].getValue().isUnique() && (n3 + n2 > 65536 || n4 + n2 > 65536)) {
                ERROR_STREAM.println("Invalid LDIR at " + Integer.toHexString(n - z80Instruction.getSize()));
                return false;
            }
            if (n3 >= n4 && n3 < n4 + n2) {
                if (instance.isSRAMaddress(n4, state)) {
                    Z80Disassembler.markSRAMseen(n4, state, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2 + (n3 - n4));
                    Z80Disassembler.markSRAMseen(n4, state, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2 + (n3 - n4));
                } else {
                    Z80Disassembler.markRAMseen(n4, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2 + (n3 - n4));
                    Z80Disassembler.markRAMseen(n4, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2 + (n3 - n4));
                }
            } else {
                if (instance.isRAMaddress(n3)) {
                    Z80Disassembler.markRAMseen(n3, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2);
                }
                if (instance.isRAMaddress(n4)) {
                    Z80Disassembler.markRAMseen(n4, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
                }
                if (instance.isSRAMaddress(n3, state)) {
                    Z80Disassembler.markSRAMseen(n3, state, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2);
                }
                if (instance.isSRAMaddress(n4, state)) {
                    Z80Disassembler.markSRAMseen(n4, state, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
                }
                Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[1].getValue(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state), state);
            }
            Value value = n3 == n4 + 1 ? Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state) : null;
            do {
                Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, n3++, value != null ? value : Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state), state);
                registerPairArray[1].inc();
                registerPairArray[2].inc();
                registerPairArray[0].dec();
            } while (--n2 > 0);
        } else {
            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[1].getValue(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state), state);
        }
        return true;
    }

    private static final boolean LDDR(Z80Instruction z80Instruction, State state, int n, RamRomMap ramRomMap, int[] nArray) {
        RegisterPair[] registerPairArray = state.getRegPairs();
        if (registerPairArray[0].getValue().isUnique() && registerPairArray[1].getValue().isUnique() && registerPairArray[0].getMinValue() > 0) {
            int n2 = registerPairArray[0].getMinValue();
            int n3 = registerPairArray[1].getMinValue();
            int n4 = registerPairArray[2].getMinValue();
            if (registerPairArray[2].getValue().isUnique() && (n3 - n2 < 0 || n4 - n2 < 0)) {
                ERROR_STREAM.println("Invalid LDDR at " + Integer.toHexString(n - z80Instruction.getSize()));
                return false;
            }
            if (n3 > n4 - n2 && n3 <= n4) {
                if (instance.isSRAMaddress(n4, state)) {
                    Z80Disassembler.markSRAMseen(n4, state, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2 + (n4 - n3));
                    Z80Disassembler.markSRAMseen(n4, state, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2 + (n4 - n3));
                } else {
                    Z80Disassembler.markRAMseen(n4, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2 + (n4 - n3));
                    Z80Disassembler.markRAMseen(n4, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2 + (n4 - n3));
                }
            } else {
                if (instance.isRAMaddress(n3)) {
                    Z80Disassembler.markRAMseen(n3, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2);
                }
                if (instance.isRAMaddress(n4)) {
                    Z80Disassembler.markRAMseen(n4, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
                }
                if (instance.isSRAMaddress(n3, state)) {
                    Z80Disassembler.markSRAMseen(n3, state, registerPairArray[1].getSource() == null ? 0 : registerPairArray[1].getSource().getMin(), n2);
                }
                if (instance.isSRAMaddress(n4, state)) {
                    Z80Disassembler.markSRAMseen(n4, state, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
                }
                Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[1].getValue(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state), state);
            }
            do {
                Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, n3--, Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state), state);
                registerPairArray[1].dec();
                registerPairArray[2].dec();
                registerPairArray[0].dec();
            } while (--n2 > 0);
        } else {
            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, registerPairArray[1].getValue(), Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state), state);
        }
        return true;
    }

    private static final boolean OTIR(Z80Instruction z80Instruction, State state, int n, RamRomMap ramRomMap, int[] nArray) {
        Register[] registerArray = state.getRegs();
        RegisterPair[] registerPairArray = state.getRegPairs();
        if (registerArray[0].getValue().isUnique() && registerArray[0].getValue().getMin() > 0) {
            int n2 = registerArray[0].getValue().getMin();
            int n3 = registerPairArray[2].getMinValue();
            if (registerPairArray[2].getValue().isUnique() && n3 + n2 > 65536) {
                ERROR_STREAM.println("Invalid OTIR at " + Integer.toHexString(n - z80Instruction.getSize()));
                return false;
            }
            Z80Disassembler.markPortSeen(registerArray[1].getValue());
            if (instance.isRAMaddress(n3)) {
                Z80Disassembler.markRAMseen(n3, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
            }
            if (instance.isSRAMaddress(n3, state)) {
                Z80Disassembler.markSRAMseen(n3, state, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
            }
            do {
                Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state);
                registerPairArray[2].inc();
                registerArray[0].dec();
            } while (--n2 > 0);
        } else {
            Z80Disassembler.markPortSeen(registerArray[1].getValue());
            Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state);
        }
        return true;
    }

    private static final boolean OTDR(Z80Instruction z80Instruction, State state, int n, RamRomMap ramRomMap, int[] nArray) {
        Register[] registerArray = state.getRegs();
        RegisterPair[] registerPairArray = state.getRegPairs();
        if (registerArray[0].getValue().isUnique() && registerArray[0].getValue().getMin() > 0) {
            int n2 = registerArray[0].getValue().getMin();
            int n3 = registerPairArray[2].getMinValue();
            if (registerPairArray[2].getValue().isUnique() && n3 - n2 < 0) {
                ERROR_STREAM.println("Invalid OTDR at " + Integer.toHexString(n - z80Instruction.getSize()));
                return false;
            }
            Z80Disassembler.markPortSeen(registerArray[1].getValue());
            if (instance.isRAMaddress(n3)) {
                Z80Disassembler.markRAMseen(n3, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
            }
            if (instance.isSRAMaddress(n3, state)) {
                Z80Disassembler.markSRAMseen(n3, state, registerPairArray[2].getSource() == null ? 0 : registerPairArray[2].getSource().getMin(), n2);
            }
            do {
                Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state);
                registerPairArray[2].dec();
                registerArray[0].dec();
            } while (--n2 > 0);
        } else {
            Z80Disassembler.markPortSeen(registerArray[1].getValue());
            Z80Disassembler.READ_BYTE(nArray, ramRomMap, registerPairArray[2].getValue(), state);
        }
        return true;
    }

    private int JR_cc(DisassemblerState disassemblerState, Z80Instruction z80Instruction, State state, int n, int n2, int[] nArray, int n3, IntDeque intDeque) {
        RamRomMap ramRomMap = disassemblerState.ramRomMap;
        if (this.isRAMaddress(state.getPC())) {
            Z80Disassembler.setRAMcodeAddress(this.mapRAMaddress(state.getPC() + z80Instruction.getArg()), n + z80Instruction.getArg());
        }
        if (z80Instruction.getArg() == 1) {
            Z80Disassembler.markSeen(state.getPC() + z80Instruction.getArg() & 0xFFFF, ramRomMap, state, n - z80Instruction.getSize());
            int n4 = state.getPC() + z80Instruction.getArg() & 0xFFFF;
            State state2 = new State(state);
            if (!(this.analyze(disassemblerState, state.getPC(), n - z80Instruction.getSize(), n4, nArray, state2, n3 + 1, intDeque) || this.getEntryPoints().length > 0 && n2 == this.getEntryPoints()[0])) {
                shouldReturn = Boolean.FALSE;
                return n;
            }
            if (state2.getPC() == n4) {
                state.union(state2);
                n = state2.getAddress(ramRomMap);
            }
            state.setPC(n4);
        } else if (!Z80Disassembler.isSeen(state.getPC() + z80Instruction.getArg() & 0xFFFF, ramRomMap, state, n - z80Instruction.getSize())) {
            Z80Disassembler.markSeen(state.getPC() + z80Instruction.getArg() & 0xFFFF, ramRomMap, state, n - z80Instruction.getSize());
            if (!(z80Instruction.getArg() == 0 || this.analyze(disassemblerState, state.getPC() + z80Instruction.getArg() & 0xFFFF, n - z80Instruction.getSize(), -1, nArray, new State(state), n3 + 1, intDeque) || this.getEntryPoints().length > 0 && n2 == this.getEntryPoints()[0])) {
                shouldReturn = Boolean.FALSE;
                return n;
            }
        }
        return n;
    }

    private boolean JP_rr(DisassemblerState disassemblerState, Z80Instruction z80Instruction, State state, int n, int n2, int n3, IntDeque intDeque) {
        int n4;
        Value value;
        int[] nArray = disassemblerState.memory;
        RamRomMap ramRomMap = disassemblerState.ramRomMap;
        int n5 = disassemblerState.retAddressStackPos;
        RegisterPair[] registerPairArray = state.getRegPairs();
        if (registerPairArray[n].getValue().isUnique()) {
            value = registerPairArray[n].getValue();
            if (value == disassemblerState.retAddressValue) {
                return false;
            }
            Address address = registerPairArray[n].getSource() != null ? registerPairArray[n].getSource() : (registerPairArray[n].lo.getSource() != null ? registerPairArray[n].lo.getSource() : null);
            int n6 = n4 = address != null ? address.getMin() : n2 - z80Instruction.getSize();
            if (!this.isROMaddress(value, state) || Z80Disassembler.isSeen(value.getMin(), ramRomMap, state, n4)) {
                return false;
            }
            if (address != null && address.getSource() != null && !Z80Disassembler.isCode(n4)) {
                Z80Disassembler.addTable(jumpTables, n4, n4 + 2, address.getSource(), null, state);
            }
        } else {
            int n7;
            int n8;
            Object object;
            Address address = registerPairArray[n].getSource();
            if (address != null) {
                if (registerPairArray[n].isRAMsource()) {
                    Table table = memoryTables.get(address.getMin());
                    if (table == null) {
                        if (!memoryTables.containsKey(address.getMin())) {
                            memoryTables.put(address.getMin(), new Table(0, 0, address, null, state));
                        }
                    } else if (table.start > 0) {
                        jumpTables.add(new Table(table, state));
                    }
                    memoryJump.set(address.getMin());
                } else if (!address.isUnique() && address.getMin() > 0) {
                    int n9;
                    int n10 = address.getMin();
                    int n11 = Math.min(nArray.length - 1, address.getMax() + 1) - n10;
                    int n12 = n9 = address.getMultiplier() == 3 ? address.getMultiplier() : 2;
                    if (n10 > 256 && (n11 == -1 || n11 == -2)) {
                        n11 = 256;
                        n10 -= n11;
                    }
                    Object object2 = object = address.getSource() != null ? address.getSource().getAdditional() : null;
                    if (object != null && ((Address)object).isRamAddress() && ((Value)object).isUnique()) {
                        if (Z80Disassembler.isCode(n10 - 1) && !Z80Disassembler.isCode(n10)) {
                            Z80Disassembler.indexMinValues[this.mapRAMaddress((int)((Value)object).getMin())] = 0;
                        } else {
                            n10 += indexMinValues[this.mapRAMaddress(((Value)object).getMin())] * n9;
                        }
                    }
                    while (n11 > 0 && (Z80Disassembler.isCode(n10) || !this.isROMaddress(Z80Disassembler.READ_WORD(nArray, n10), state))) {
                        n10 += n9;
                        n11 -= n9;
                    }
                    if (n11 > 0 && object != null && ((Address)object).isRamAddress() && indexMinValues[this.mapRAMaddress(((Value)object).getMin())] < (n10 - address.getMin()) / n9) {
                        Z80Disassembler.indexMinValues[this.mapRAMaddress((int)((Value)object).getMin())] = (n10 - address.getMin()) / n9;
                    }
                    n8 = n10;
                    n7 = 0;
                    while (n7 < n11 && !Z80Disassembler.hasLabel(n8) && !Z80Disassembler.hasLabel(n8 + 1) && this.isROMaddress(Z80Disassembler.READ_WORD(nArray, n8), state)) {
                        int n13 = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n8), ramRomMap, state);
                        if (Z80Disassembler.isSubInstructionByte(n13)) break;
                        n8 += n9;
                        n7 += n9;
                    }
                    if (n8 > n10) {
                        Z80Disassembler.addTable(jumpTables, n10, n8, registerPairArray[n].getSource(), (Address)object, state);
                    }
                } else if (registerPairArray[n].getMinValue() > 0) {
                    int n14 = Z80Disassembler.RESOLVE_ADDRESS(registerPairArray[n].getMinValue(), ramRomMap, state);
                    Address address2 = null;
                    if (registerPairArray[n].getSource() != null) {
                        address2 = registerPairArray[n].getSource().getAdditional();
                    }
                    while (n14 > 3 && nArray[n14 - 3] == 195 && !Z80Disassembler.isCode(n14 - 3)) {
                        n14 -= 3;
                    }
                    int n15 = n14;
                    while (nArray[n15] == 195) {
                        int n16 = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n15 + 1), ramRomMap, state);
                        if (Z80Disassembler.isSubInstructionByte(n16)) break;
                        n15 += 3;
                    }
                    if (n15 > n14) {
                        Z80Disassembler.addTable(jumpTables, n14, n15, Z80Disassembler.toAddress(registerPairArray[n].getValue(), ramRomMap, state), address2, state);
                    }
                } else if (registerPairArray[n].isROMsource() && !Z80Disassembler.isCode(address.getMin())) {
                    int n17 = Z80Disassembler.READ_WORD(nArray, address.getMin());
                    if (instance.isROMaddress(n17, state) && !Z80Disassembler.isSubInstructionByte(Z80Disassembler.RESOLVE_ADDRESS(n17, ramRomMap, state))) {
                        ArrayIntDeque arrayIntDeque = new ArrayIntDeque();
                        if (!this.analyze(disassemblerState, n17, n2 - z80Instruction.getSize(), -1, new int[]{-1}, state, n3 + 1, arrayIntDeque)) {
                            Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                        } else {
                            intDeque.pushAll(arrayIntDeque);
                        }
                    }
                } else if (address.getSource() != null) {
                    Address address3;
                    Address address4 = address.getSource().getAdditional();
                    Address address5 = address4 != null ? address4.getSource() : null;
                    Address address6 = address3 = address5 != null ? address5.getAdditional() : null;
                    if (address3 != null && address3.isRomAddress() && !address3.isUnique()) {
                        entriesOfTablePointToTablesOfJumpTables.set(address3.getMin());
                    } else if (address.getMultiplier() == 2 && address.getSource().isRamAddress()) {
                        object = memoryTables.get(address.getSource().getMin());
                        if (object == null && !memoryTables.containsKey(address.getSource().getMin())) {
                            memoryTables.put(address.getSource().getMin(), new Table(0, 0, address.getSource(), null, state));
                        }
                        memoryJump.set(address.getSource().getMin());
                    }
                }
            }
            if (n5 == 0 || state.getStack().isEmpty()) {
                return false;
            }
            State state2 = new State(state);
            LinkedList<Value> linkedList = state2.getStack();
            linkedList.pop();
            Value value2 = linkedList.pop();
            object = linkedList.pop();
            if (value2.getSource() == null || ((Value)object).getSource() == null || !value2.isUnique() || !((Value)object).isUnique() || ((Value)object).getSource().getMin() - value2.getSource().getMin() != 1) {
                return false;
            }
            n8 = ((Value)object).getMin() << 8 | value2.getMin();
            if (!this.isROMaddress(n8, state) || Z80Disassembler.isSeen(n8, ramRomMap, state, value2.getSource().getMin())) {
                return false;
            }
            n7 = Z80Disassembler.hasLabel(n8) ? 1 : 0;
            Z80Disassembler.markSeen(n8, ramRomMap, state, value2.getSource().getMin());
            overridingRet.set(value2.getSource().getMin());
            ArrayIntDeque arrayIntDeque = new ArrayIntDeque();
            if (!this.analyze(disassemblerState, n8, value2.getSource().getMin(), -1, new int[]{-1}, state2, n3 + 1, arrayIntDeque)) {
                Z80Disassembler.undoCode(arrayIntDeque, ramRomMap);
                if (n7 == 0) {
                    Z80Disassembler.removeLabel(n8);
                }
            } else {
                intDeque.pushAll(arrayIntDeque);
            }
            return false;
        }
        Z80Disassembler.markSeen(value.getMin(), ramRomMap, state, n4);
        state.setPC(value.getMin());
        return true;
    }

    private static void EX_SP_HL(DisassemblerState disassemblerState, State state, int n, int n2) {
        int[] nArray = disassemblerState.memory;
        RamRomMap ramRomMap = disassemblerState.ramRomMap;
        int n3 = disassemblerState.retAddressStackPos;
        RegisterPair[] registerPairArray = state.getRegPairs();
        if (nArray[n2] == 201) {
            Address address = registerPairArray[n].getSource();
            if (registerPairArray[n].isRAMsource()) {
                Table table = memoryTables.get(address.getMin());
                if (table == null) {
                    if (!memoryTables.containsKey(address.getMin())) {
                        memoryTables.put(address.getMin(), new Table(0, 0, address, null, state));
                    }
                    memoryJump.set(address.getMin());
                } else if (table.start > 0) {
                    jumpTables.add(table);
                }
            } else if (registerPairArray[n].hasMultipleSources() && address.isRomAddress()) {
                int n4 = Math.min(nArray.length - 1, address.getMax() + 1) - address.getMin();
                if (!address.isUnique()) {
                    int n5 = address.getMin();
                    Address address2 = address.getSource().getAdditional();
                    if (address2 != null && address2.isUnique() && address2.isRamAddress()) {
                        n5 += indexMinValues[instance.mapRAMaddress(address2.getMin())] * 2;
                    }
                    if (Z80Disassembler.isCode(n5)) {
                        n5 += 2;
                        n4 -= 2;
                    }
                    int n6 = n5;
                    int n7 = 0;
                    while (n7 < n4 && !Z80Disassembler.hasLabel(n6) && !Z80Disassembler.hasLabel(n6 + 1) && instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n6), state)) {
                        int n8 = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n6), ramRomMap, state);
                        if (!instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n6), state) || Z80Disassembler.isSubInstructionByte(n8)) break;
                        n6 += 2;
                        n7 += 2;
                    }
                    if (n6 > n5) {
                        if (n4 != address.getMax() - address.getMin() && address2 != null && address2.isUnique() && address2.isRamAddress() && indexMinValues[instance.mapRAMaddress(address2.getMin())] < (n5 - address.getMin()) / 2) {
                            Z80Disassembler.indexMinValues[Z80Disassembler.instance.mapRAMaddress((int)address2.getMin())] = (n5 - address.getMin()) / 2;
                        }
                        Z80Disassembler.addTable(jumpTables, n5, n6, registerPairArray[n].getSource(), address2, state);
                    }
                }
            }
        }
        if (n3 == 0 && !retAddresses.isEmpty()) {
            int n9 = retAddresses.pop();
            if (n9 == 0) {
                if (instance.isROMaddress(registerPairArray[n].getMinValue(), state)) {
                    retAddresses.push(Z80Disassembler.RESOLVE_ADDRESS(registerPairArray[n].getMinValue(), ramRomMap, state));
                } else {
                    retAddresses.push(registerPairArray[n].getMinValue());
                }
            } else {
                retAddresses.push(0);
            }
        }
        state.exStackTopHL(n);
    }

    protected static final void LD_nn_SP(Z80Instruction z80Instruction, State state) {
        state.saveSP(z80Instruction.getArg());
    }

    private static final void LD_nn_rr(Z80Instruction z80Instruction, State state, int[] nArray, RamRomMap ramRomMap, RegisterPair registerPair) {
        Z80Disassembler.WRITE_WORD(nArray, ramRomMap, new Value(z80Instruction.getArg(), Z80Disassembler.toAddress(state.getPC() - z80Instruction.getSize(), ramRomMap, state)), registerPair.lo.getValue(), registerPair.hi.getValue(), state);
    }

    protected static void markPortSeen(Value value) {
        if (value.getSource() != null && value.getSource().isRomAddress()) {
            Z80Disassembler.markPortSeen(instance.mapPortAddress(value.getMin()), value.getSource().getMin());
        }
    }

    protected static void markPortSeen(int n, int n2) {
        IntHashSet intHashSet = portSeen.get(n);
        if (intHashSet == null) {
            intHashSet = new IntHashSet();
            portSeen.put(n, intHashSet);
        }
        intHashSet.add(n2);
    }

    private static void unmarkPortSeen(int n, int n2) {
        try {
            IntHashSet intHashSet = portSeen.get(n);
            if (intHashSet != null && intHashSet.contains(n2)) {
                intHashSet.remove(n2);
                if (intHashSet.isEmpty()) {
                    portSeen.remove(n);
                }
            }
        }
        catch (Exception exception) {}
    }

    private static boolean isPortSeen(int n, int n2) {
        if (!Z80Disassembler.isCode(n2)) {
            return false;
        }
        IntHashSet intHashSet = portSeen.get(n);
        return intHashSet != null && intHashSet.contains(n2);
    }

    public static boolean isPortRead(int n, int n2) {
        if (!Z80Disassembler.isPortSeen(n, n2)) {
            return false;
        }
        Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n2);
        if (z80Instruction == null) {
            return false;
        }
        if (z80Instruction.isPortRead()) {
            return true;
        }
        if (z80Instruction.isPortWrite()) {
            return false;
        }
        int n3 = n2 + z80Instruction.getSize();
        int n4 = 0;
        while (n4 < 3) {
            Z80Instruction z80Instruction2;
            Z80Instruction z80Instruction3 = Z80Disassembler.getInstruction(n3);
            if (z80Instruction3 == null) {
                return false;
            }
            if (z80Instruction3.hasDestination() && (z80Instruction2 = Z80Disassembler.getInstruction(z80Instruction3.getDestination(n3, 0))) != null) {
                if (z80Instruction2.isPortRead()) {
                    return true;
                }
                if (z80Instruction2.isPortWrite()) {
                    return false;
                }
            }
            if (z80Instruction3.isPortRead()) {
                return true;
            }
            if (z80Instruction3.isPortWrite()) {
                return false;
            }
            n3 += z80Instruction3.getSize();
            ++n4;
        }
        return false;
    }

    private static void markRAMseen(Value value, Address address, int n) {
        Z80Disassembler.markRAMseen(value, address.getMin(), n);
    }

    private static void markRAMseen(Value value, int n, int n2) {
        Z80Disassembler.markRAMseen(value.getMin(), n, n2);
    }

    protected static void markRAMseen(int n, int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("size must be a natural number: " + n3);
        }
        if (instance.isRAMaddress(n)) {
            IntHashSet intHashSet = ramSeen.get(n = instance.mapRAMaddress(n));
            if (intHashSet == null) {
                intHashSet = new IntHashSet();
                ramSeen.put(n, intHashSet);
            }
            intHashSet.add(n2);
            if (!ramSizes.containsKey(n) || ramSizes.get(n) < n3) {
                ramSizes.put(n, n3);
            }
        }
    }

    protected static boolean isRAMseen(int n, int n2) {
        IntHashSet intHashSet = ramSeen.get(n);
        return intHashSet != null && intHashSet.contains(n2);
    }

    private static void markSRAMseen(Value value, State state, Address address, int n) {
        Z80Disassembler.markSRAMseen(value, state, address.getMin(), n);
    }

    private static void markSRAMseen(Value value, State state, int n, int n2) {
        Z80Disassembler.markSRAMseen(value.getMin(), state, n, n2);
    }

    private static void markSRAMseen(int n, State state, int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("size must be a natural number: " + n3);
        }
        IntHashSet intHashSet = sramSeen.get(n = instance.mapSRAMaddress(n, state));
        if (intHashSet == null) {
            intHashSet = new IntHashSet();
            sramSeen.put(n, intHashSet);
        }
        intHashSet.add(n2);
        Z80Disassembler.setSRAMenabled(n2, true);
        if (!sramSizes.containsKey(n) || sramSizes.get(n) < n3) {
            sramSizes.put(n, n3);
        }
    }

    private static boolean isSRAMseen(int n, State state, int n2) {
        IntHashSet intHashSet = sramSeen.get(instance.mapSRAMaddress(n, state));
        return intHashSet != null && intHashSet.contains(n2);
    }

    private static void markDataSeen(int n, RamRomMap ramRomMap, State state, int n2, boolean bl) {
        if (!instance.isROMaddress(n, state)) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(n)) + " is no ROM address.");
        }
        Z80Disassembler.markDataSeen(Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state), n2, bl);
    }

    private static void markDataSeen(Value value, RamRomMap ramRomMap, State state, Address address) {
        Z80Disassembler.markDataSeen(value, ramRomMap, state, address.getMin());
    }

    private static void markDataSeen(Value value, RamRomMap ramRomMap, State state, int n) {
        Z80Disassembler.markDataSeen(Z80Disassembler.toAddress(value, ramRomMap, state), n);
        Z80Disassembler.setBank0(n, state.getBank0());
        Z80Disassembler.setBank1(n, state.getBank1());
        Z80Disassembler.setBank2(n, state.getBank2());
        Z80Disassembler.setBank3(n, state.getBank3());
    }

    private static void markDataSeen(Address address, Address address2) {
        if (!address2.isRomAddress()) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(address2.getMin())) + " is no ROM address.");
        }
        Z80Disassembler.markDataSeen(address, address2.getMin());
    }

    private static void markDataSeen(Address address, int n) {
        if (!address.isRomAddress()) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(address.getMin())) + " is no ROM address.");
        }
        Z80Disassembler.markDataSeen(address.getMin(), n);
    }

    private static void markDataSeen(int n, Address address) {
        Z80Disassembler.markDataSeen(n, address.getMin());
    }

    private static void markDataSeen(int n, int n2) {
        Z80Disassembler.markDataSeen(n, n2, false);
    }

    private static void markDataSeen(int n, int n2, boolean bl) {
        if (!Z80Disassembler.isCode(n)) {
            IntHashSet intHashSet = dataSeen.get(n);
            if (!bl) {
                if (intHashSet == null && !dataSeenExact.get(n + 1) && (intHashSet = dataSeen.get(n + 1)) != null) {
                    dataSeen.put(n, intHashSet);
                    dataSeen.remove(n + 1);
                }
                if (intHashSet == null) {
                    intHashSet = dataSeen.get(n + 2);
                }
                if (intHashSet == null) {
                    intHashSet = dataSeen.get(n - 1);
                }
                if (intHashSet == null) {
                    intHashSet = dataSeen.get(n - 2);
                }
            } else {
                if (intHashSet == null && n > 1 && !dataSeenExact.get(n - 1) && (intHashSet = dataSeen.get(n - 1)) != null) {
                    dataSeen.put(n, intHashSet);
                    dataSeen.remove(n - 1);
                }
                if (intHashSet == null && n > 2 && !dataSeenExact.get(n - 2) && (intHashSet = dataSeen.get(n - 2)) != null) {
                    dataSeen.put(n, intHashSet);
                    dataSeen.remove(n - 2);
                }
            }
            if (intHashSet == null) {
                intHashSet = new IntHashSet();
                dataSeen.put(n, intHashSet);
            }
            if (bl) {
                dataSeenExact.set(n);
            }
            intHashSet.add(n2);
        }
    }

    private static void unmarkDataSeen(int n, RamRomMap ramRomMap, State state, int n2) {
        try {
            Z80Disassembler.unmarkDataSeen(Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state), n2);
        }
        catch (Exception exception) {}
    }

    private static void unmarkDataSeen(int n, int n2) {
        try {
            IntHashSet intHashSet = dataSeen.get(n);
            if (intHashSet != null && intHashSet.contains(n2)) {
                intHashSet.remove(n2);
                if (intHashSet.isEmpty()) {
                    dataSeen.remove(n);
                }
            }
        }
        catch (Exception exception) {}
    }

    private static boolean isDataSeen(int n, RamRomMap ramRomMap, State state, int n2) {
        IntHashSet intHashSet = dataSeen.get(Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state));
        return intHashSet != null && intHashSet.contains(n2);
    }

    private static boolean isLoop(int n) {
        return Z80Disassembler.isLoop(n, 1, new HashMap<Boolean>());
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isLoop(int var0, int var1_1, util.map.Map<Boolean> var2_2) {
        if (var1_1 > 32 || Z80Disassembler.abort) {
            return false;
        }
        var3_3 = var2_2.get(var0);
        if (var3_3 != null) {
            return var3_3;
        }
        var4_4 = Z80Disassembler.path.get(var0);
        if (var4_4 == null) {
            var2_2.put(var0, false);
            return false;
        }
        var5_5 = Z80Disassembler.path.get(var4_4.keys()[0]);
        if (var5_5 != null) ** GOTO lbl42
        var2_2.put(var0, false);
        return false;
lbl-1000:
        // 1 sources

        {
            if (var4_4 == var5_5) {
                var2_2.put(var0, true);
                return true;
            }
            if (var4_4.size() > 1) {
                var9_9 = var4_4.keys();
                var8_8 = var9_9.length;
                var7_7 = 0;
                while (var7_7 < var8_8) {
                    var6_6 = var9_9[var7_7];
                    if (var6_6 != var0 && Z80Disassembler.isLoop(var6_6, var1_1 + 1, var2_2)) {
                        var2_2.put(var0, true);
                        return true;
                    }
                    ++var7_7;
                }
            }
            if ((var5_5 = Z80Disassembler.path.get(var5_5.keys()[0])) == null) {
                var2_2.put(var0, false);
                return false;
            }
            if (var5_5 == var4_4) {
                var2_2.put(var0, true);
                return true;
            }
            var5_5 = Z80Disassembler.path.get(var5_5.keys()[0]);
            var4_4 = Z80Disassembler.path.get(var4_4.keys()[0]);
lbl42:
            // 2 sources

            ** while (var4_4 != null && var5_5 != null)
        }
lbl43:
        // 1 sources

        var2_2.put(var0, false);
        return false;
    }

    private static void addPath(int n, int n2) {
        IntHashSet intHashSet = path.get(n2);
        if (intHashSet == null) {
            intHashSet = new IntHashSet();
            path.put(n2, intHashSet);
        }
        intHashSet.add(n);
    }

    private static void markSeen(int n, RamRomMap ramRomMap, State state, int n2) {
        int n3;
        if (instance.isROMaddress(n, state)) {
            if (!msx && n >= 32768) {
                if (state.getBank2().getMin() == 0) {
                    ERROR_STREAM.println("Didn't mark " + Integer.toHexString(n) + " as seen from " + Integer.toHexString(n2));
                    return;
                }
            } else if (!msx && n >= 16384 && state.getBank1().getMin() == 0) {
                ERROR_STREAM.println("Didn't mark " + Integer.toHexString(n) + " as seen from " + Integer.toHexString(n2));
                return;
            }
        }
        if (Z80Disassembler.isSubInstructionByte(n3 = Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state))) {
            ERROR_STREAM.println("Address to be seen is unaligned.");
            return;
        }
        IntHashSet intHashSet = seen.get(n3);
        if (intHashSet == null) {
            intHashSet = new IntHashSet();
            seen.put(n3, intHashSet);
        }
        intHashSet.add(n2);
        Z80Disassembler.addLabel(n3);
    }

    private static void unmarkSeen(int n, RamRomMap ramRomMap, State state, int n2) {
        try {
            int n3 = Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state);
            IntHashSet intHashSet = seen.get(n3);
            if (intHashSet != null && intHashSet.remove(n2) && intHashSet.isEmpty()) {
                seen.remove(n3);
                int[] nArray = instance.getEntryPoints();
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = nArray[n5];
                    if (n3 == n6) {
                        return;
                    }
                    ++n5;
                }
                Z80Disassembler.removeLabel(n3);
            }
        }
        catch (Exception exception) {}
    }

    private static boolean isSeen(int n, RamRomMap ramRomMap, State state, int n2) {
        IntHashSet intHashSet = seen.get(Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state));
        return intHashSet != null && intHashSet.contains(n2);
    }

    public static int getSlot(int n) {
        if (slots == null || n >= slots.length) {
            return -1;
        }
        return slots[n];
    }

    private static int getSlotAt(int n) {
        return Z80Disassembler.getSlot(Z80Disassembler.getRomBank(n));
    }

    private static void setRAMcodeAddress(int n, int n2) {
        if (ramCode != null && n2 >= 0) {
            ramCode.put(n, n2);
        }
    }

    public static int getRAMcodeAddress(int n) {
        int n2;
        if (ramCode != null && (n2 = ramCode.get(n)) != Integer.MIN_VALUE) {
            return n2;
        }
        return Integer.MIN_VALUE;
    }

    public static int getSRAMcodeAddress(int n) {
        int n2;
        if (sramCode != null && (n2 = sramCode.get(n)) != Integer.MIN_VALUE) {
            return n2;
        }
        return Integer.MIN_VALUE;
    }

    public static int getDestination(int n, RamRomMap ramRomMap, int n2) {
        if (Z80Disassembler.isCode(n)) {
            return Integer.MIN_VALUE;
        }
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        State state = null;
        Table table = null;
        for (Table table2 : jumpTables) {
            if (n < table2.start || n >= table2.end) continue;
            table = table2;
            break;
        }
        if (table == null) {
            for (Table table2 : pointerTables) {
                if (n < table2.start || n >= table2.end) continue;
                table = table2;
                break;
            }
        }
        if (table != null) {
            state = table.state;
        }
        if (state != null && instance.isROMaddress(n2, state)) {
            return Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, state);
        }
        return Integer.MIN_VALUE;
    }

    public static int getDestination(int n, RamRomMap ramRomMap) {
        Object object;
        Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n);
        if (z80Instruction == null || z80Instruction.isPortAccess() || instance.isRAMaddress(z80Instruction.getDestination(n, Z80Disassembler.getSlotAt(n))) || instance.isSRAMaddress(z80Instruction.getDestination(n, Z80Disassembler.getSlotAt(n)), Z80Disassembler.isSRAMenabled(n))) {
            return Integer.MIN_VALUE;
        }
        int n2 = z80Instruction.getDestination(n, Z80Disassembler.getSlotAt(n));
        if (n2 < 0) {
            return Integer.MIN_VALUE;
        }
        int n3 = dataSeenPartial.get(n);
        if (n3 != Integer.MIN_VALUE && (object = Z80Disassembler.getInstruction(n3)) != null) {
            n2 = z80Instruction.getDisplacement() > ((Z80Instruction)object).getDisplacement() ? (z80Instruction.getArg() << 8 | ((Z80Instruction)object).getArg()) & 0xFFFF : (((Z80Instruction)object).getArg() << 8 | z80Instruction.getArg()) & 0xFFFF;
        }
        object = DUMMY_STATE;
        ((State)object).setSRAMenabled(Z80Disassembler.isSRAMenabled(n));
        ((State)object).setSRAMbank(Z80Disassembler.getSRAMbank(n));
        if (!instance.isROMaddress(n2, (State)object)) {
            return n2;
        }
        ((State)object).setBank0(Z80Disassembler.getBank0(n));
        ((State)object).setBank1(Z80Disassembler.getBank1(n));
        ((State)object).setBank2(Z80Disassembler.getBank2(n));
        ((State)object).setBank3(Z80Disassembler.getBank3(n));
        int n4 = Z80Disassembler.getSlotAt(n);
        if (n4 == 3) {
            ((State)object).setBank3(new Value(Z80Disassembler.getRomBank(n)));
        } else if (n4 == 2) {
            ((State)object).setBank2(new Value(Z80Disassembler.getRomBank(n)));
        } else if (n4 == 1) {
            ((State)object).setBank1(new Value(Z80Disassembler.getRomBank(n)));
        } else {
            ((State)object).setBank0(new Value(Z80Disassembler.getRomBank(n)));
        }
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        n2 = Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, (State)object);
        return n2;
    }

    static int getRomBank(int n) {
        return n / dummyCartridge.getBankSize();
    }

    static void addLabel(int n) {
        labels.set(n);
    }

    private static void removeLabel(int n) {
        labels.clear(n);
    }

    public static boolean hasLabel(int n) {
        return n >= 0 && labels != null && labels.get(n);
    }

    public static boolean hasDataLabel(int n) {
        return dataSeen != null && dataSeen.containsKey(n);
    }

    public static boolean hasRAMlabel(int n) {
        return ramSeen != null && ramSeen.containsKey(n);
    }

    public static boolean hasSRAMlabel(int n) {
        return sramSeen != null && sramSeen.containsKey(n);
    }

    /*
     * WARNING - void declaration
     */
    public static IntegerTreeMap findSections(int[] nArray, RamRomMap ramRomMap, Collection<List<Symbols.Symbol>> collection, boolean bl, boolean bl2) {
        int n;
        Object object;
        Object integerTreeMap2;
        int n2;
        Iterator<Map.Entry<Integer, IntegerTreeMap>> iterator;
        Map.Entry entry6;
        Object object3;
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        BitSet bitSet = new BitSet();
        HashMap<List<Symbols.Symbol>> hashMap = new HashMap<List<Symbols.Symbol>>();
        IntegerTreeMap integerTreeMap = new IntegerTreeMap();
        if (instance == null) {
            return integerTreeMap;
        }
        if (bl) {
            void var9_17;
            object3 = instance.getEntryPoints();
            int n3 = ((int[])object3).length;
            boolean arrayList = false;
            while (var9_17 < n3) {
                int n4 = object3[var9_17];
                integerTreeMap.put(n4, new IntegerTreeMap());
                ++var9_17;
            }
        }
        TreeSet<Map.Entry<IntHashSet>> treeSet = new TreeSet<Map.Entry<IntHashSet>>(new Comparator<Map.Entry<IntHashSet>>(){

            @Override
            public int compare(Map.Entry<IntHashSet> entry, Map.Entry<IntHashSet> entry2) {
                return entry.getKey() - entry2.getKey();
            }
        });
        if (bl) {
            treeSet.addAll(seen.entrySet());
        }
        if (bl2) {
            treeSet.addAll(dataSeen.entrySet());
        }
        for (List<Symbols.Symbol> list : collection) {
            entry6 = list.iterator();
            while (entry6.hasNext()) {
                object3 = entry6.next();
                if (!instance.isROMaddress(((Symbols.Symbol)object3).getAddress(), false)) continue;
                iterator = new IntHashSet(0);
                n2 = dummyCartridge.mapAddress(((Symbols.Symbol)object3).getAddress(), ((Symbols.Symbol)object3).getBank());
                if ((!bl || !Z80Disassembler.isCode(n2)) && (!bl2 || Z80Disassembler.isCode(n2))) continue;
                integerTreeMap2 = new Map.Entry<IntHashSet>(){

                    @Override
                    public int getKey() {
                        return n2;
                    }

                    @Override
                    public IntHashSet getValue() {
                        return iterator;
                    }
                };
                treeSet.add((Map.Entry<IntHashSet>)integerTreeMap2);
            }
        }
        block3: for (Map.Entry<IntHashSet> entry2 : treeSet) {
            object3 = Z80Disassembler.getPrevInstruction(entry2.getKey());
            if (object3 != null && ((Z80Instruction)object3).getOpCode() != 24 && ((Z80Instruction)object3).getOpCode() != 195 && ((Z80Instruction)object3).getOpCode() != 233 && (!((Z80Instruction)object3).isRet() || ((Z80Instruction)object3).isConditional())) continue;
            if (Z80Disassembler.getAnonymousLabel(entry2.getKey(), hashMap) != null) {
                bitSet.set(entry2.getKey());
                continue;
            }
            int n5 = 0;
            int[] entry7 = entry2.getValue().keys();
            int n6 = entry7.length;
            n2 = 0;
            while (n2 < n6) {
                int n7 = entry7[n2];
                Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n7);
                if (!Z80Disassembler.isCode(entry2.getKey()) || z80Instruction != null && z80Instruction.isCall() && ++n5 >= 2) {
                    integerTreeMap.put(entry2.getKey(), new IntegerTreeMap());
                    continue block3;
                }
                ++n2;
            }
        }
        for (Map.Entry<IntHashSet> entry3 : treeSet) {
            object3 = (IntegerTreeMap)integerTreeMap.get(entry3.getKey());
            if (object3 != null || (entry6 = integerTreeMap.floorEntry(entry3.getKey())) == null) continue;
            iterator = (IntegerTreeMap)entry6.getValue();
            n2 = Z80Disassembler.isCode((Integer)entry6.getKey()) ? 1 : 0;
            integerTreeMap2 = Z80Disassembler.getPrevInstruction(entry3.getKey());
            if (n2 != 0 && !bitSet.get(entry3.getKey()) && (integerTreeMap2 == null || ((Z80Instruction)integerTreeMap2).getOpCode() == 24 || ((Z80Instruction)integerTreeMap2).getOpCode() == 195 || ((Z80Instruction)integerTreeMap2).getOpCode() == 233 || ((Z80Instruction)integerTreeMap2).isRet() && !((Z80Instruction)integerTreeMap2).isConditional())) {
                object = entry3.getValue().keys();
                n = ((int[])object).length;
                int n8 = 0;
                while (n8 < n) {
                    int n32 = object[n8];
                    Map.Entry entry4 = integerTreeMap.floorEntry(n32);
                    if (entry4 != null && entry4.getValue() != iterator) {
                        n2 = 0;
                        break;
                    }
                    ++n8;
                }
            }
            if (n2 != 0) {
                ((TreeMap)((Object)iterator)).put(entry3.getKey(), new IntegerTreeMap());
                continue;
            }
            integerTreeMap.put(entry3.getKey(), new IntegerTreeMap());
        }
        if (bl2) {
            for (Map.Entry entry5 : new HashSet(integerTreeMap.entrySet())) {
                object3 = (IntegerTreeMap)entry5.getValue();
                for (Map.Entry entry6 : new HashSet(((TreeMap)object3).entrySet())) {
                    IntHashSet intHashSet = dataSeen.get((Integer)entry6.getKey());
                    if (intHashSet == null) continue;
                    int[] nArray2 = intHashSet.keys();
                    int n9 = nArray2.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        int n11 = nArray2[n10];
                        object = integerTreeMap.floorEntry(n11);
                        if (object != null && object.getValue() != object3) {
                            ((TreeMap)object3).remove(entry6.getKey());
                            integerTreeMap.put((Integer)entry6.getKey(), (IntegerTreeMap)entry6.getValue());
                        }
                        ++n10;
                    }
                }
            }
            ArrayList<Table> arrayList = new ArrayList<Table>(jumpTables);
            arrayList.addAll(pointerTables);
            for (Table table : arrayList) {
                IntegerTreeMap integerTreeMap3;
                int n12;
                int n13;
                int n14;
                if ((table.end - table.start) / 2 <= 1) continue;
                entry6 = new IntHashSet();
                int n15 = Integer.MAX_VALUE;
                int n16 = table.start;
                while (n16 < table.end) {
                    int n17;
                    int n18 = Z80Disassembler.READ_WORD(nArray, n16);
                    int n19 = n17 = instance.isROMaddress(n18, table.state) ? Z80Disassembler.RESOLVE_ADDRESS(n18, ramRomMap, table.state) : -1;
                    if (n17 > 0 && n17 < n15) {
                        n15 = n17;
                    }
                    ((IntHashSet)((Object)entry6)).add(n17);
                    n16 += 2;
                }
                n16 = Z80Disassembler.READ_WORD(nArray, table.start);
                int n20 = n14 = instance.isROMaddress(n16, table.state) ? Z80Disassembler.RESOLVE_ADDRESS(n16, ramRomMap, table.state) : -1;
                if (n14 > 0) {
                    for (Table table2 : arrayList) {
                        int n21;
                        if (table2 == table) continue;
                        n = Z80Disassembler.READ_WORD(nArray, table2.start);
                        int n22 = n21 = instance.isROMaddress(n, table2.state) ? Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, table2.state) : -1;
                        if (n21 != n14) continue;
                        int n23 = table2.start;
                        while (n23 < table2.end) {
                            n13 = Z80Disassembler.READ_WORD(nArray, n23);
                            int n24 = n12 = instance.isROMaddress(n13, table2.state) ? Z80Disassembler.RESOLVE_ADDRESS(n13, ramRomMap, table2.state) : -1;
                            if (n12 > 0 && n12 < n15) {
                                n15 = n12;
                            }
                            ((IntHashSet)((Object)entry6)).add(n12);
                            n23 += 2;
                        }
                    }
                }
                n16 = 1;
                int[] nArray3 = ((IntHashSet)((Object)entry6)).keys();
                int n25 = nArray3.length;
                int n26 = 0;
                while (n26 < n25) {
                    n14 = nArray3[n26];
                    if (n14 > n15) {
                        Integer n27 = integerTreeMap.lowerKey(n14);
                        boolean bl3 = false;
                        if (n27 != null) {
                            int[] nArray4 = ((IntHashSet)((Object)entry6)).keys();
                            int n28 = nArray4.length;
                            n12 = 0;
                            while (n12 < n28) {
                                n13 = nArray4[n12];
                                if (n13 == n27) {
                                    bl3 = true;
                                    break;
                                }
                                ++n12;
                            }
                        }
                        if (!bl3) {
                            n16 = 0;
                            break;
                        }
                    }
                    ++n26;
                }
                if (n16 == 0) continue;
                if (n15 == table.end) {
                    Map.Entry entry7;
                    n15 = table.start;
                    IntHashSet intHashSet = dataSeen.get(table.start);
                    if (intHashSet != null && (entry7 = integerTreeMap.lowerEntry(n15)) != null && intHashSet.size() <= 1 && (n25 = intHashSet.keys()[0]) >= entry7.getKey() && n25 < n15) {
                        ((IntegerTreeMap)entry7.getValue()).put(n15, (IntegerTreeMap)integerTreeMap.remove(n15));
                        n15 = entry7.getKey();
                    }
                }
                if ((integerTreeMap3 = (IntegerTreeMap)integerTreeMap.get(n15)) == null) continue;
                int[] nArray5 = ((IntHashSet)((Object)entry6)).keys();
                int n29 = nArray5.length;
                n25 = 0;
                while (n25 < n29) {
                    int n30 = nArray5[n25];
                    if (n30 > 0 && n30 != n15) {
                        integerTreeMap3.put(n30, (IntegerTreeMap)integerTreeMap.remove(n30));
                    }
                    ++n25;
                }
            }
        }
        return integerTreeMap;
    }

    public static boolean isCode(int n) {
        return code != null && n >= 0 && n < code.length && code[n] > 0;
    }

    public static boolean setCode(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, util.map.Map<List<Symbols.Symbol>> map, util.map.Map<String> map2, SectionProvider sectionProvider) {
        return Z80Disassembler.setCode(list, nArray, ramRomMap, n, -1, -1, -1, -1, -1, false, 0, map, map2, sectionProvider);
    }

    /*
     * Exception decompiling
     */
    public static synchronized boolean setCode(List<SourceLine> var0, int[] var1_1, RamRomMap var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, boolean var9_9, int var10_10, util.map.Map<List<Symbols.Symbol>> var11_11, util.map.Map<String> var12_12, SectionProvider var13_13) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean setCode(int[] nArray, RamRomMap ramRomMap, int n) {
        return Z80Disassembler.setCode(nArray, ramRomMap, n, -1, -1, -1, -1, false, 0);
    }

    private static boolean setCode(int[] nArray, RamRomMap ramRomMap, int n, int n2) {
        int n3 = 0;
        int n4 = dummyCartridge instanceof GBCartridge ? 1 : 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 >= slots.length) {
            return false;
        }
        if (msx && dummyCartridge.getBankSize() == 8192) {
            int n7 = Z80Disassembler.getRomBank(n - 16384);
            if (n7 == 3) {
                n6 = n2;
            } else if (n7 == 2) {
                n5 = n2;
            } else if (n7 == 1) {
                n4 = n2;
            } else if (n7 == 0) {
                n3 = n2;
            }
        } else {
            int n8 = n / 16384;
            if (n8 == 2) {
                n5 = n2;
            } else if (n8 == 1) {
                n4 = n2;
            } else if (n8 == 0) {
                n3 = n2;
            }
        }
        return Z80Disassembler.setCode(nArray, ramRomMap, n, n3, n4, n5, n6, false, 0);
    }

    private static boolean setCode(int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        return Z80Disassembler.setCode(nArray, ramRomMap, n, n2, n3, n4, n5, bl, n6, new ArrayIntDeque(), false);
    }

    private static synchronized boolean setCode(int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, IntDeque intDeque, boolean bl2) {
        int n8;
        Object object;
        int n9;
        int n10;
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            n10 = n;
            n2 = 0;
            n3 = dummyCartridge instanceof GBCartridge ? 1 : 0;
            n4 = 0;
            n5 = 0;
            int n11 = Z80Disassembler.getRomBank(n);
            if (n11 >= slots.length) {
                return false;
            }
            if (msx && dummyCartridge instanceof MSXDisk) {
                return false;
            }
            if (msx && dummyCartridge.getBankSize() == 8192) {
                if (slots[n11] == 3) {
                    n5 = n11;
                    n = 0xA000 | n & 0x1FFF;
                } else if (slots[n11] == 2) {
                    n4 = n11;
                    n = 0x8000 | n & 0x1FFF;
                } else if (slots[n11] == 1) {
                    n3 = n11;
                    n = 0x6000 | n & 0x1FFF;
                } else if (slots[n11] == 0) {
                    n2 = n11;
                    n = 0x4000 | n & 0x1FFF;
                }
            } else {
                if (slots[n11] == 2) {
                    n4 = n11;
                    n = 0x8000 | n & 0x3FFF;
                } else if (slots[n11] == 1) {
                    n3 = n11;
                    n = 0x4000 | n & 0x3FFF;
                } else if (slots[n11] == 0) {
                    n2 = n11;
                    n &= 0x3FFF;
                }
                if (msx) {
                    n += Math.max(0, ((MSXCartridge)dummyCartridge).getFirstPage() * 16384 - ((MSXCartridge)dummyCartridge).getHeaderAddress());
                }
            }
        } else {
            n10 = -1;
        }
        abort = false;
        State state = new State();
        state.setBank0(new Value(n2));
        state.setBank1(new Value(n3));
        state.setBank2(new Value(n4));
        state.setBank3(new Value(n5));
        state.setSRAMenabled(bl);
        state.setSRAMbank(new Value(n6));
        Z80Disassembler z80Disassembler = Z80Disassembler.getInstance();
        int n12 = Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state);
        if (n10 >= 0 && n12 != n10) {
            if (n10 >= 65536) {
                return false;
            }
            n = n10;
            n12 = Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state);
            if (n12 != n10) {
                return false;
            }
        }
        if (n12 < code.length) {
            if (code[n12] < 0) {
                n9 = z80Disassembler.getInstruction(nArray, n12).getSize() - 1;
                while (n9 >= 0) {
                    Z80Disassembler.code[n12 + n9] = 0;
                    --n9;
                }
            } else if (code[n12] > 0) {
                return false;
            }
        }
        n9 = Z80Disassembler.hasLabel(n12);
        int n13 = jumpTables.hashCode();
        int n14 = pointerTables.hashCode();
        int n15 = ramCodeWrites.size();
        int n16 = memoryJumps.size();
        if (!z80Disassembler.analyze(nArray, ramRomMap, n, n, -1, new int[]{-1}, state, intDeque, Math.max(131072, nArray.length / 16))) {
            if (intDeque.isEmpty()) {
                intDeque.push(n);
            }
            object = new ArrayIntDeque();
            block1: while (!intDeque.isEmpty() && object.size() < 8) {
                n8 = intDeque.removeLast();
                object.add(n8);
                while (Z80Disassembler.getInstruction(n8) != null && Z80Disassembler.getInstruction(n8).getDestination(n8, Z80Disassembler.getSlotAt(n8)) >= 0) {
                    int n7 = Z80Disassembler.getInstruction(n8).getDestination(n8, Z80Disassembler.getSlotAt(n8));
                    IntHashSet intHashSet = seen.get(n7);
                    if (n7 == n8 || intHashSet == null || !intHashSet.contains(n8)) continue block1;
                    n8 = n7;
                    if (z80Disassembler.isROMaddress(n8, state)) {
                        n8 = Z80Disassembler.RESOLVE_ADDRESS(n8, ramRomMap, state);
                    }
                    if (!intDeque.removeLastOccurrence(n8)) continue;
                    object.add(n8);
                }
            }
            Z80Disassembler.undoCode(intDeque, ramRomMap);
            while (!object.isEmpty()) {
                intDeque.push(object.pop());
            }
        }
        if (!intDeque.isEmpty()) {
            n = intDeque.getLast();
        }
        if (!Z80Disassembler.hasLabel(n) && Z80Disassembler.getPrevInstruction(n) == null) {
            Z80Disassembler.addLabel(n);
        }
        if (bl2) {
            int n7;
            boolean bl3 = false;
            for (Table table : jumpTables) {
                int n11 = table.start;
                while (n11 < table.end && !bl3) {
                    if (Z80Disassembler.isCode(n11)) {
                        bl3 = true;
                    }
                    ++n11;
                }
                if (bl3) break;
            }
            n8 = 0;
            for (Table table : pointerTables) {
                n7 = table.start;
                while (n7 < table.end && n8 == 0) {
                    if (Z80Disassembler.isCode(n7)) {
                        n8 = 1;
                    }
                    ++n7;
                }
                if (n8 != 0) break;
            }
            if (ramCodeWrites.size() != n15) {
                Z80Disassembler.analyzeRamCodeWrites(nArray, ramRomMap, intDeque);
            }
            if (memoryJumps.size() != n16) {
                Z80Disassembler.analyzeMemoryJumps(nArray, ramRomMap, intDeque, Math.max(65536, nArray.length / 32));
            }
            if (bl3 || jumpTables.hashCode() != n13) {
                z80Disassembler.analyzeJumpTables(nArray, ramRomMap, intDeque, Math.max(131072, nArray.length / 16));
            }
            if (n8 != 0 || pointerTables.hashCode() != n14) {
                int n17;
                int n18 = jumpTables.size();
                Z80Disassembler.analyzePointerTables(nArray, ramRomMap);
                int n19 = 0;
                while (jumpTables.size() != n17 && n19 < 10) {
                    n17 = jumpTables.size();
                    n7 = pointerTables.size();
                    z80Disassembler.analyzeJumpTables(nArray, ramRomMap, intDeque, Math.max(131072, nArray.length / 16));
                    if (pointerTables.size() != n7) {
                        Z80Disassembler.analyzePointerTables(nArray, ramRomMap);
                        ++n17;
                    }
                    ++n19;
                }
            }
        }
        if (!intDeque.isEmpty()) {
            object = intDeque.intIterator();
            n8 = object.next();
            while (object.hasNext()) {
                if (Z80Disassembler.getInstruction(n8) == null) {
                    Z80Disassembler.undoCode(n8, ramRomMap);
                    object.remove();
                }
                n8 = object.next();
            }
        }
        if (n9 == 0 && Z80Disassembler.hasLabel(n) && Z80Disassembler.getPrevInstruction(n) != null && (Z80Disassembler.getPrevInstruction(n).isConditional() || !Z80Disassembler.getPrevInstruction(n).isJump() && !Z80Disassembler.getPrevInstruction(n).isRet())) {
            Z80Disassembler.removeLabel(n);
        } else if (!Z80Disassembler.hasLabel(n) && (Z80Disassembler.getPrevInstruction(n) == null || !Z80Disassembler.getPrevInstruction(n).isConditional() && (Z80Disassembler.getPrevInstruction(n).isJump() || Z80Disassembler.getPrevInstruction(n).isRet()))) {
            Z80Disassembler.addLabel(n);
        }
        if (Z80Disassembler.getInstruction(n) == null) {
            Z80Disassembler.undoCode(intDeque, ramRomMap);
            ERROR_STREAM.println("Failed to disassemble from " + Integer.toHexString(n));
            return false;
        }
        return true;
    }

    private static void removeCodeFromDataSeen() {
        int n;
        BitSet bitSet = dataSeen.keyBitSet();
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            if (Z80Disassembler.isCode(n2)) {
                dataSeen.remove(n2);
            }
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        for (Table table : jumpTables) {
            n = bitSet.nextSetBit(table.start + 1) & Integer.MAX_VALUE;
            while (n < table.end) {
                dataSeen.remove(n);
                n = bitSet.nextSetBit(n + 1) & Integer.MAX_VALUE;
            }
        }
        for (Table table : pointerTables) {
            n = bitSet.nextSetBit(table.start + 1) & Integer.MAX_VALUE;
            while (n < table.end) {
                dataSeen.remove(n);
                n = bitSet.nextSetBit(n + 1) & Integer.MAX_VALUE;
            }
        }
    }

    public static boolean updateLines(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, util.map.Map<List<Symbols.Symbol>> map, util.map.Map<String> map2, SectionProvider sectionProvider) {
        Object object;
        int n2;
        if (Z80Disassembler.isCode(n)) {
            while (Z80Disassembler.isSubInstructionByte(n)) {
                --n;
            }
            return Z80Disassembler.setData(list, nArray, ramRomMap, n, map) | Z80Disassembler.setCode(list, nArray, ramRomMap, n, map, map2, sectionProvider);
        }
        String string = dialect.getDataPrefix(1);
        String string2 = dialect.getDataPrefix(2);
        String string3 = dialect.getDataPrefix(8);
        if (n < 336 && n >= 260 && instance instanceof LR35902Disassembler) {
            n2 = 0;
            while (n2 < dataBlocks.size()) {
                object = dataBlocks.get(n2);
                if (((DataBlock)object).start > n) break;
                if (n >= ((DataBlock)object).start && n < ((DataBlock)object).start + ((DataBlock)object).length) {
                    int n3 = Z80Disassembler.findBeginningOfDisassembly(list);
                    while (n3 < list.size()) {
                        if (list.get(n3).getAddress() == ((DataBlock)object).start) {
                            int n4 = Z80Disassembler.removeDataBlock(list, n3, n2);
                            ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>();
                            LR35902Disassembler.writeGBcartridgeHeader(arrayList, (GBCartridge)dummyCartridge, nArray);
                            dataBlocks.add(n2, (DataBlock)object);
                            list.addAll(n4, arrayList);
                            return true;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        n2 = Z80Disassembler.findBeginningOfDisassembly(list);
        while (n2 < list.size()) {
            object = list.get(n2);
            if (n >= ((SourceLine)object).getAddress() && n - ((SourceLine)object).getAddress() < ((SourceLine)object).getSize()) {
                if (n2 >= 3 && list.get(n2 - 3).getInstruction() != null && !list.get(n2 - 3).getInstruction().isBranch()) {
                    return Z80Disassembler.updateLines(list, nArray, ramRomMap, list.get(n2 - 3).getAddress(), map, map2, sectionProvider);
                }
                State state = null;
                String string4 = ((SourceLine)object).toString().substring(0, Math.min(((SourceLine)object).toString().length(), string3.length())).trim();
                if (string2.equals(string4)) {
                    int n3;
                    int n4;
                    block4: for (Table object2 : jumpTables) {
                        if (((SourceLine)object).getAddress() < object2.start || ((SourceLine)object).getAddress() >= object2.end) continue;
                        state = object2.state;
                        n4 = Z80Disassembler.READ_WORD(nArray, object2.start + (n - object2.start & 0xFFFFFFFE));
                        Z80Disassembler.setData(list, nArray, ramRomMap, n4, map);
                        Z80Disassembler.setCode(list, nArray, ramRomMap, n4, map, map2, sectionProvider);
                        object = list.get(n2);
                        n3 = 0;
                        while (n3 <= n2 || n2 + n3 < list.size()) {
                            if (n3 <= n2) {
                                object = list.get(n2 - n3);
                            }
                            if (n >= ((SourceLine)object).getAddress() && n - ((SourceLine)object).getAddress() < ((SourceLine)object).getSize()) {
                                n2 -= n3;
                                break block4;
                            }
                            if (n2 + n3 < list.size()) {
                                object = list.get(n2 + n3);
                            }
                            if (n >= ((SourceLine)object).getAddress() && n - ((SourceLine)object).getAddress() < ((SourceLine)object).getSize()) {
                                n2 += n3;
                                break block4;
                            }
                            ++n3;
                        }
                        break block4;
                    }
                    if (state == null) {
                        block6: for (Table table : pointerTables) {
                            DataBlock dataBlock;
                            int n5;
                            if (((SourceLine)object).getAddress() < table.start || ((SourceLine)object).getAddress() >= table.end) continue;
                            state = table.state;
                            n4 = n - (n - ((SourceLine)object).getAddress() & 1);
                            n3 = -1;
                            for (Map.Entry<IntHashSet> entry : dataSeen.entrySet()) {
                                IntHashSet intHashSet = entry.getValue();
                                if (!intHashSet.remove(n4)) continue;
                                n3 = entry.getKey();
                                if (!intHashSet.isEmpty()) break;
                                dataSeen.remove(entry.getKey());
                                break;
                            }
                            int n6 = Z80Disassembler.READ_WORD(nArray, n4);
                            Z80Disassembler.markDataSeen(n6, ramRomMap, state, n4, true);
                            if (n3 >= 0) {
                                int n7 = n3;
                                int n8 = n2;
                                block8: while (n8 < list.size()) {
                                    if (list.get(n8).getAddress() > n7) break;
                                    if (n7 >= list.get(n8).getAddress() && n7 < list.get(n8).getAddress() + list.get(n8).getSize()) {
                                        n5 = 0;
                                        while (n5 < dataBlocks.size()) {
                                            dataBlock = dataBlocks.get(n5);
                                            if (dataBlock.start > n7) break block8;
                                            if (n7 >= dataBlock.start && n7 < dataBlock.start + dataBlock.length) {
                                                n8 = Z80Disassembler.removeDataBlock(list, n8, n5);
                                                if (n7 == dataBlock.start) {
                                                    n8 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, dataBlock.start, dataBlock.start + dataBlock.length, n8, map);
                                                    break block8;
                                                }
                                                n8 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, dataBlock.start, n7, n8, map);
                                                n8 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, n7, dataBlock.start + dataBlock.length, n8, map);
                                                break block8;
                                            }
                                            ++n5;
                                        }
                                        break;
                                    }
                                    ++n8;
                                }
                            }
                            if (!instance.isROMaddress(n6, state)) break;
                            int n9 = Z80Disassembler.RESOLVE_ADDRESS(n6, ramRomMap, state);
                            int n10 = n2;
                            while (n10 < list.size()) {
                                if (list.get(n10).getAddress() > n9) break block6;
                                if (n9 >= list.get(n10).getAddress() && n9 < list.get(n10).getAddress() + list.get(n10).getSize()) {
                                    n5 = 0;
                                    while (n5 < dataBlocks.size()) {
                                        dataBlock = dataBlocks.get(n5);
                                        if (dataBlock.start > n9) break block6;
                                        if (n9 >= dataBlock.start && n9 < dataBlock.start + dataBlock.length) {
                                            n10 = Z80Disassembler.removeDataBlock(list, n10, n5);
                                            if (n9 == dataBlock.start) {
                                                n10 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, dataBlock.start, dataBlock.start + dataBlock.length, n10, map);
                                                break block6;
                                            }
                                            n10 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, dataBlock.start, n9, n10, map);
                                            n10 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, n9, dataBlock.start + dataBlock.length, n10, map);
                                            break block6;
                                        }
                                        ++n5;
                                    }
                                    break block6;
                                }
                                ++n10;
                            }
                            break block6;
                        }
                    }
                }
                if (state == null) {
                    state = DUMMY_STATE;
                }
                if (string.equals(string4)) {
                    list.set(n2, new SourceLine(((SourceLine)object).getAddress(), ((SourceLine)object).getSize(), Z80Disassembler.getDataBlockLine(nArray, ramRomMap, ((SourceLine)object).getAddress(), ((SourceLine)object).getAddress() + ((SourceLine)object).getSize(), 1, state, map)));
                } else if (string2.equals(string4)) {
                    list.set(n2, new SourceLine(((SourceLine)object).getAddress(), ((SourceLine)object).getSize(), Z80Disassembler.getDataBlockLine(nArray, ramRomMap, ((SourceLine)object).getAddress(), ((SourceLine)object).getAddress() + ((SourceLine)object).getSize(), 2, state, map)));
                } else if (string3.equals(string4)) {
                    list.remove(n2);
                    ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>();
                    Z80Disassembler.writeDataBlock(arrayList, nArray, ramRomMap, ((SourceLine)object).getAddress(), ((SourceLine)object).getAddress() + ((SourceLine)object).getSize(), null, 1, null, false, map);
                    int n11 = 0;
                    while (n11 < arrayList.size() && ((SourceLine)arrayList.get(n11)).getSize() == 0) {
                        ++n11;
                    }
                    list.addAll(n2, arrayList.subList(n11, arrayList.size() - 1));
                } else {
                    return false;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int findBeginningOfDisassembly(List<SourceLine> list) {
        if (beginningOfDisassembly < list.size() && list.get(beginningOfDisassembly) == SourceLine.DISASSEMBLY_HEAD_COMMENT) {
            return beginningOfDisassembly;
        }
        if (!list.isEmpty() && list.get(0) == SourceLine.DISASSEMBLY_HEAD_COMMENT) {
            beginningOfDisassembly = 0;
            return 0;
        }
        beginningOfDisassembly = list.lastIndexOf(SourceLine.DISASSEMBLY_HEAD_COMMENT) & Integer.MAX_VALUE;
        return beginningOfDisassembly;
    }

    private static int writeMSXcartridgeHeader(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, util.map.Map<List<Symbols.Symbol>> map) {
        MSXCartridge mSXCartridge = (MSXCartridge)dummyCartridge;
        int n = mSXCartridge.getHeaderAddress();
        int n2 = mSXCartridge.getInitAddress();
        int n3 = mSXCartridge.getStatementAddress();
        int n4 = mSXCartridge.getDeviceAddress();
        int n5 = mSXCartridge.getTextAddress();
        Z80Disassembler.addLabel(n);
        int n6 = 10;
        if (n2 > 0 && mSXCartridge.isROMaddress(n2)) {
            Z80Disassembler.addTable(jumpTables, n + 2, n + 4, Z80Disassembler.toAddress(Value.ZERO, ramRomMap, DUMMY_STATE), null, UNMODIFIABLE_DUMMY_STATE);
            Z80Disassembler.markSeen(n2, ramRomMap, DUMMY_STATE, n + 2);
            tableEntrySeen.put(Z80Disassembler.RESOLVE_ADDRESS(n2, ramRomMap, DUMMY_STATE), n + 2);
            if ((n2 & 0x3FFF) <= (n & 0x3FFF) + 10) {
                n6 = (n2 & 0x3FFF) - (n & 0x3FFF);
            }
        }
        if (n6 > 4) {
            if (n3 > 0 && mSXCartridge.isROMaddress(n3)) {
                Z80Disassembler.addTable(jumpTables, n + 4, n + 6, Z80Disassembler.toAddress(Value.ZERO, ramRomMap, DUMMY_STATE), null, UNMODIFIABLE_DUMMY_STATE);
                Z80Disassembler.markSeen(n3, ramRomMap, DUMMY_STATE, n + 4);
                tableEntrySeen.put(Z80Disassembler.RESOLVE_ADDRESS(n3, ramRomMap, DUMMY_STATE), n + 4);
            }
            if (n4 > 0 && mSXCartridge.isROMaddress(n4)) {
                Z80Disassembler.addTable(jumpTables, n + 6, n + 8, Z80Disassembler.toAddress(Value.ZERO, ramRomMap, DUMMY_STATE), null, UNMODIFIABLE_DUMMY_STATE);
                Z80Disassembler.markSeen(n4, ramRomMap, DUMMY_STATE, n + 6);
                tableEntrySeen.put(Z80Disassembler.RESOLVE_ADDRESS(n4, ramRomMap, DUMMY_STATE), n + 6);
            }
            if (n5 > 0 && mSXCartridge.isROMaddress(n5)) {
                Z80Disassembler.addTable(jumpTables, n + 8, n + 10, Z80Disassembler.toAddress(Value.ZERO, ramRomMap, DUMMY_STATE), null, UNMODIFIABLE_DUMMY_STATE);
                Z80Disassembler.markSeen(n5, ramRomMap, DUMMY_STATE, n + 8);
                tableEntrySeen.put(Z80Disassembler.RESOLVE_ADDRESS(n5, ramRomMap, DUMMY_STATE), n + 8);
            }
        }
        list.add(new SourceLine("MSXcartridgeHeader:"));
        list.add(new SourceLine(n + 0, 2, String.valueOf(dialect.getDataPrefix(1)) + " \"" + mSXCartridge.getID() + "\""));
        list.add(new SourceLine(n + 2, n6 - 2, Z80Disassembler.getDataBlockLine(nArray, ramRomMap, n + 2, n + 2 + n6 - 2, 2, null, map)));
        list.add(SourceLine.EMPTY_LINE);
        return n6;
    }

    public static synchronized boolean setData(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, util.map.Map<List<Symbols.Symbol>> map) {
        if (!Z80Disassembler.isCode(n)) {
            return false;
        }
        if (ramRomMap == null) {
            ramRomMap = defaultRamRomMap;
        }
        int n2 = Z80Disassembler.findBeginningOfDisassembly(list);
        while (n2 < list.size()) {
            SourceLine sourceLine = list.get(n2);
            if (n >= sourceLine.getAddress() && n - sourceLine.getAddress() < sourceLine.getSize()) {
                int n3;
                n = sourceLine.getAddress();
                while (list.get(n2 - 1).getAddress() < 0 && sourceLine != SourceLine.EMPTY_LINE) {
                    sourceLine = list.get(--n2);
                }
                while (sourceLine.getAddress() < 0) {
                    Z80Disassembler.removeLine(list, n2);
                    sourceLine = list.get(n2);
                }
                do {
                    int n4;
                    int n5 = 0;
                    while (n5 < sourceLine.getInstruction().getSize()) {
                        Z80Disassembler.code[sourceLine.getAddress() + n5] = 1;
                        ++n5;
                    }
                    IntHashSet intHashSet = seen.get(sourceLine.getAddress());
                    n3 = Z80Disassembler.hasLabel(sourceLine.getAddress());
                    Z80Disassembler.undoCode(sourceLine.getAddress(), ramRomMap);
                    if (n3 != 0) {
                        Z80Disassembler.addLabel(sourceLine.getAddress());
                    }
                    if (intHashSet != null && !intHashSet.isEmpty()) {
                        seen.put(sourceLine.getAddress(), intHashSet);
                    }
                    if ((n4 = sourceLine.getInstruction().getDestination(sourceLine.getAddress(), Z80Disassembler.getSlotAt(sourceLine.getAddress()))) >= 0 && !Z80Disassembler.hasLabel(n4) && Z80Disassembler.isCode(n4 - 1) && list.get(n2 - 2).getAddress() >= 0) {
                        SourceLine sourceLine2;
                        int n6;
                        if (n4 == sourceLine.getAddress()) {
                            if (list.get(n2 - 1).getAddress() < 0) {
                                Z80Disassembler.removeLine(list, --n2);
                            }
                        } else if (n4 < sourceLine.getAddress()) {
                            n6 = n2 - 1;
                            while (n6 > 0) {
                                sourceLine2 = list.get(n6);
                                if (n4 == sourceLine2.getAddress()) {
                                    if (list.get(n6 - 1).getAddress() >= 0) break;
                                    Z80Disassembler.removeLine(list, n6 - 1);
                                    --n2;
                                    break;
                                }
                                if (sourceLine2.getAddress() >= n4) {
                                    --n6;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            n6 = n2 + 1;
                            while (n6 < list.size()) {
                                sourceLine2 = list.get(n6);
                                if (n4 == sourceLine2.getAddress()) {
                                    if (list.get(n6 - 1).getAddress() >= 0) break;
                                    Z80Disassembler.removeLine(list, n6 - 1);
                                    break;
                                }
                                if (sourceLine2.getAddress() < 0 || sourceLine2.getAddress() <= n4) {
                                    ++n6;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    Z80Disassembler.removeLine(list, n2);
                } while ((sourceLine = list.get(n2)).getInstruction() != null && !Z80Disassembler.hasLabel(sourceLine.getAddress()));
                if (sourceLine.getInstruction() == null) {
                    int n7 = n2;
                    while (sourceLine.getAddress() < 0) {
                        sourceLine = list.get(++n7);
                    }
                    if (!Z80Disassembler.hasLabel(sourceLine.getAddress())) {
                        n3 = 0;
                        while (n3 < dataBlocks.size()) {
                            DataBlock dataBlock = dataBlocks.get(n3);
                            if (dataBlock.start > sourceLine.getAddress()) break;
                            if (sourceLine.getAddress() == dataBlock.start) {
                                n7 = Z80Disassembler.removeDataBlock(list, n7, n3);
                                Z80Disassembler.addDataBlock(list, nArray, ramRomMap, n, dataBlock.start + dataBlock.length, n7, n3, map);
                                return true;
                            }
                            ++n3;
                        }
                    }
                }
                Z80Disassembler.addDataBlock(list, nArray, ramRomMap, n, sourceLine.getAddress(), n2, map);
                return true;
            }
            ++n2;
        }
        if (Z80Disassembler.findBeginningOfDisassembly(list) > 0) {
            Z80Disassembler.undoCode(n, ramRomMap);
        }
        return false;
    }

    private static SourceLine removeLine(List<SourceLine> list, int n) {
        return list.remove(n);
    }

    private static void addLine(List<SourceLine> list, int n, SourceLine sourceLine) {
        list.add(n, sourceLine);
    }

    private static void addTable(Collection<Table> collection, int n, int n2, Address address, Address address2, State state) {
        if (state instanceof UnmodifiableState) {
            collection.add(new Table(n, n2, address, address2, state));
        } else {
            Table table = new Table(n, n2, address, address2, UNMODIFIABLE_DUMMY_STATE);
            if (!collection.contains(table)) {
                collection.add(new Table(n, n2, address, address2, state));
            }
        }
    }

    private static void removeTable(Collection<Table> collection, Table table) {
        collection.remove(table);
    }

    /*
     * Unable to fully structure code
     */
    private static int removeDataBlock(List<SourceLine> var0, int var1_1, int var2_2) {
        var3_3 = Z80Disassembler.dataBlocks.get(var2_2);
        var4_4 = var0.get(var1_1);
        while (var1_1 < var0.size() && var0.get(var1_1).getAddress() < 0) {
            ++var1_1;
        }
        if (var0.get(var1_1).getAddress() == var3_3.start) ** GOTO lbl10
        Z80Disassembler.ERROR_STREAM.println("Failed to remove datablock because it is not in the given line." + var3_3);
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var4_4 = var0.get(--var1_1);
lbl10:
            // 2 sources

            ** while (var0.get((int)(var1_1 - 1)).getAddress() < 0 && var4_4 != SourceLine.EMPTY_LINE && !var0.get((int)(var1_1 - 1)).toString().startsWith((String)".ORG") && !var0.get((int)(var1_1 - 1)).toString().startsWith((String)"SECTION"))
        }
lbl11:
        // 1 sources

        Z80Disassembler.dataBlocks.remove(var2_2);
        var5_5 = var1_1;
        while (var4_4.getAddress() < 0) {
            var4_4 = var0.get(++var5_5);
        }
        while (var4_4 != null && (var4_4.getAddress() < 0 || var4_4.getAddress() >= var3_3.start && var4_4.getAddress() + var4_4.getSize() < var3_3.start + var3_3.length)) {
            v0 = var4_4 = var5_5 + 1 < var0.size() ? var0.get(++var5_5) : null;
        }
        if (++var5_5 < var0.size() && var0.get(var5_5) == SourceLine.EMPTY_LINE) {
            ++var5_5;
        }
        var0.subList(var1_1, var5_5).clear();
        return var1_1;
    }

    private static int addDataBlock(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, util.map.Map<List<Symbols.Symbol>> map) {
        return Z80Disassembler.addDataBlock(list, nArray, ramRomMap, n, n2, n3, -1, map);
    }

    private static int addDataBlock(List<SourceLine> list, int[] nArray, RamRomMap ramRomMap, int n, int n2, int n3, int n4, util.map.Map<List<Symbols.Symbol>> map) {
        if (n2 <= n) {
            throw new IllegalArgumentException("Datablock is empty!");
        }
        if (n4 < 0) {
            n4 = dataBlocks.size();
            int n5 = 0;
            while (n5 < dataBlocks.size()) {
                if (Z80Disassembler.dataBlocks.get((int)n5).start >= n) {
                    if (n == Z80Disassembler.dataBlocks.get((int)n5).start) {
                        ERROR_STREAM.println("Datablocks starting at same address!");
                    }
                    n4 = n5;
                    break;
                }
                ++n5;
            }
        }
        if (list.get(n3 - 1) != SourceLine.EMPTY_LINE) {
            Z80Disassembler.addLine(list, n3++, SourceLine.EMPTY_LINE);
        }
        State state = null;
        Address address = null;
        int n6 = 1;
        boolean bl = false;
        ArrayList<Table> arrayList = new ArrayList<Table>(jumpTables);
        arrayList.addAll(pointerTables);
        for (Table object2 : arrayList) {
            if (n == object2.start) {
                if (n2 > object2.end) {
                    int n8 = dataBlocks.size();
                    n3 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, object2.start, object2.end, n3, n4, map);
                    return Z80Disassembler.addDataBlock(list, nArray, ramRomMap, object2.end, n2, n3, n4 += dataBlocks.size() - n8, map);
                }
                state = object2.state;
                address = object2.indexedBy;
                if (n2 - n >= 2) {
                    n6 = 2;
                }
                bl = pointerTables.contains(object2);
                break;
            }
            if (object2.start <= n || object2.start >= n2) continue;
            int n5 = dataBlocks.size();
            n3 = Z80Disassembler.addDataBlock(list, nArray, ramRomMap, n, object2.start, n3, n4, map);
            return Z80Disassembler.addDataBlock(list, nArray, ramRomMap, object2.start, n2, n3, n4 += dataBlocks.size() - n5, map);
        }
        ArrayList<SourceLine> arrayList2 = new ArrayList<SourceLine>();
        Z80Disassembler.writeDataBlock(arrayList2, nArray, ramRomMap, n, n2, state, n6, address, bl, map);
        list.addAll(n3, arrayList2);
        dataBlocks.add(n4, new DataBlock(n, n2 - n));
        return n3 += arrayList2.size();
    }

    private static void undoCode(IntDeque intDeque, RamRomMap ramRomMap) {
        while (!intDeque.isEmpty()) {
            Z80Disassembler.undoCode(intDeque.pop(), ramRomMap);
        }
    }

    private static void undoCode(int n, RamRomMap ramRomMap) {
        if (n >= code.length || code[n] == 127) {
            return;
        }
        Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n);
        if (z80Instruction != null) {
            int n2 = 0;
            while (n2 < z80Instruction.getSize()) {
                int n3 = n + n2;
                code[n3] = (byte)(code[n3] - 1);
                ++n2;
            }
        }
        if (code[n] == 0) {
            if (z80Instruction != null && z80Instruction.hasDestination() && instance.isROMaddress(z80Instruction.getDestination(n, Z80Disassembler.getSlotAt(n)), Z80Disassembler.isSRAMenabled(n))) {
                State state = DUMMY_STATE;
                state.setBank0(Z80Disassembler.getBank0(n));
                state.setBank1(Z80Disassembler.getBank1(n));
                state.setBank2(Z80Disassembler.getBank2(n));
                state.setBank3(Z80Disassembler.getBank3(n));
                state.setSRAMenabled(Z80Disassembler.isSRAMenabled(n));
                state.setSRAMbank(Z80Disassembler.getSRAMbank(n));
                Z80Disassembler.unmarkSeen(z80Instruction.getDestination(n, Z80Disassembler.getSlotAt(n)), ramRomMap, state, n);
                if (!z80Instruction.isBranch()) {
                    Z80Disassembler.unmarkDataSeen(z80Instruction.getArg(), ramRomMap, state, n);
                }
            }
            if (z80Instruction != null && z80Instruction.isPortAccess()) {
                Z80Disassembler.unmarkPortSeen(z80Instruction.getArg(), n);
            }
            Z80Disassembler.removeInstruction(n);
            seen.remove(n);
            if (!tableEntrySeen.containsKey(n)) {
                Z80Disassembler.removeLabel(n);
            }
        } else if (code[n] < 0) {
            ERROR_STREAM.println(String.valueOf(Integer.toHexString(n).toUpperCase()) + ": Too much undo!");
        }
    }

    protected static final Value READ_BYTE(int[] nArray, RamRomMap ramRomMap, Value value, State state) {
        return Z80Disassembler.READ_BYTE(nArray, ramRomMap, value, 0, state);
    }

    protected static final Value READ_BYTE(int[] nArray, RamRomMap ramRomMap, Value value, int n, State state) {
        if (value.isUnique()) {
            Z80Instruction z80Instruction;
            Address address;
            Z80Instruction z80Instruction2;
            if (value.getSource() != null && value.getSource().isUnique() && (z80Instruction2 = Z80Disassembler.getInstruction(address = value.getSource())) != null && z80Instruction2.hasArg() && (z80Instruction = instance.getInstruction(nArray, address.getMin() + z80Instruction2.getSize())) != null && ((z80Instruction2.getArg() & 0x3FFF) == (value.getMin() & 0x3FFF) || z80Instruction.hasArg() && (z80Instruction2.getArg() & 0xFF) == (value.getMin() & 0xFF) && (z80Instruction.getArg() & 0x3F) == (value.getMin() >> 8 & 0x3F))) {
                if (Z80Disassembler.toAddress(value, ramRomMap, state).isRomAddress()) {
                    Z80Disassembler.markDataSeen(value, ramRomMap, state, address);
                    if (z80Instruction2.getArgSize() == 1 && z80Instruction.hasArg() && (z80Instruction.getArg() & 0x3F) == (value.getMin() >> 8 & 0x3F)) {
                        try {
                            dataSeenPartial.put(address.getMin(), address.getMin() + z80Instruction2.getSize());
                            Z80Disassembler.markDataSeen(value, ramRomMap, state, address.getMin() + z80Instruction2.getSize());
                            dataSeenPartial.put(address.getMin() + z80Instruction2.getSize(), address.getMin());
                        }
                        catch (ResolveAddressException resolveAddressException) {}
                    }
                } else if (Z80Disassembler.toAddress(value, ramRomMap, state).isRamAddress()) {
                    Z80Disassembler.markRAMseen(value, address, 1);
                } else if (Z80Disassembler.toAddress(value, ramRomMap, state).isSramAddress()) {
                    Z80Disassembler.markSRAMseen(value, state, address, 1);
                } else if (Z80Disassembler.toAddress(value, ramRomMap, state).isPortAddress()) {
                    Z80Disassembler.markPortSeen(value);
                }
            }
            return Z80Disassembler.READ_BYTE(nArray, ramRomMap, value, n, state, true);
        }
        if (value.getSource() != null) {
            Address address;
            List<Value> list;
            util.map.Map<Table> map;
            Value value2;
            Value value3;
            Address address2 = value.getMin() != 0 || value.getMax() != 65535 || value.getSource().isRomAddress() && value.getSource().getSource() != null ? value.getSource() : value.getSource().getAdditional();
            if (address2 != null && address2.getSource() != null && address2.isRomAddress()) {
                Table table;
                value3 = address2.getSource().getAdditional();
                if (value3 != null && (!address2.getSource().isRomAddress() || address2.getSource().isUnique()) && ((Address)value3).isRomAddress() && !value3.isUnique() && Z80Disassembler.getPointerTableStartingAt(value3.getMin()) != null) {
                    value2 = value3;
                    value3 = address2.getSource();
                } else {
                    value2 = address2.getSource();
                }
                if (((Address)value2).isRamAddress() && value2.isUnique()) {
                    table = memoryTables.get(value2.getMin());
                    if (table != null) {
                        map = entriesOfTablePointToTables.get(table.start);
                        if (map == null) {
                            map = new HashMap<Table>();
                            entriesOfTablePointToTables.put(table.start, map);
                        }
                        map.put(address2.getOffset(), new Table(table.start, table.end, address2, (Address)value3, new State(state, false)));
                    }
                    if (value3 != null && value3.getSource() != null && value3.getSource().isRamAddress() && value3.getSource().isUnique()) {
                        memoryTableReadRead.set(value3.getSource().getMin());
                    }
                    memoryTableRead.set(value2.getMin());
                } else if (((Address)value2).isRomAddress() && !value2.isUnique()) {
                    table = Z80Disassembler.getPointerTableStartingAt(value2.getMin());
                    if (table == null) {
                        table = Z80Disassembler.getPointerTableStartingAt(value2.getMin() + 2);
                    }
                    if (table != null) {
                        map = entriesOfTablePointToTables.get(table.start);
                        if (map == null) {
                            map = new HashMap<Table>();
                            entriesOfTablePointToTables.put(table.start, map);
                        }
                        map.put(address2.getOffset(), new Table(table.start, table.end, address2, (Address)value3, new State(state, false)));
                    }
                }
                int n2 = address2.getMin();
                map = value2;
                list = Z80Disassembler.getInstruction((Address)((Object)map));
                if (!(value3 == null || list != null && ((Z80Instruction)((Object)list)).hasArg() && (((Z80Instruction)((Object)list)).getArg() & 0x3FFF) - (n2 & 0x3FFF) <= 0 && (((Z80Instruction)((Object)list)).getArg() & 0x3FFF) - (n2 & 0x3FFF) >= -2)) {
                    map = value3;
                    value3 = value2;
                    list = Z80Disassembler.getInstruction(map);
                }
                if (list != null && ((Z80Instruction)((Object)list)).hasArg() && (((Z80Instruction)((Object)list)).getArg() & 0x3FFF) - (n2 & 0x3FFF) <= 0 && (((Z80Instruction)((Object)list)).getArg() & 0x3FFF) - (n2 & 0x3FFF) >= -2) {
                    int n3 = address2.getMin();
                    int n4 = Math.min(nArray.length - 1, address2.getMax() + 1) - n3;
                    if (n3 > 256 && (n4 == -1 || n4 == -2)) {
                        n4 = 256;
                        n3 -= n4;
                    }
                    if (value3 != null && ((Address)value3).isRamAddress() && value3.isUnique()) {
                        n3 += indexMinValues[instance.mapRAMaddress(value3.getMin())] * 2;
                    }
                    int n5 = n3;
                    n4 = Math.min(1024, n4);
                    int n6 = address2.getMultiplier() == 16 ? address2.getMultiplier() : 2;
                    int n7 = 0;
                    while (n7 < n4) {
                        int n8 = Z80Disassembler.READ_WORD(nArray, n5);
                        if (n8 == 65535) break;
                        if (instance.isROMaddress(n8, state)) {
                            int n9;
                            if (n5 != n3 && Z80Disassembler.isCode(n5) || (n9 = Z80Disassembler.RESOLVE_ADDRESS(n8, ramRomMap, state)) < n8) break;
                            n4 = Math.min(n9 - n3 & Integer.MAX_VALUE, n4);
                        }
                        n5 += n6;
                        n7 += n6;
                    }
                    if (n5 > n3 && n5 - n3 < 1024) {
                        if (n6 == 16) {
                            n7 = n3;
                            while (!(n7 >= n5 || instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n7), state) && Z80Disassembler.isCode(Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n7), ramRomMap, state)))) {
                                Z80Disassembler.addTable(pointerTables, n7, n7 + 2, address2, (Address)value3, state);
                                n7 += address2.getMultiplier();
                            }
                        } else {
                            Z80Disassembler.addTable(pointerTables, n3, n5, address2, (Address)value3, state);
                        }
                    }
                    Z80Disassembler.markDataSeen(n2, map);
                }
            }
            value2 = value;
            value3 = value.getSource().getAdditional();
            if (value3 != null && ((Address)value3).isRamAddress() && value3.isUnique()) {
                value2 = value2.add(indexMinValues[instance.mapRAMaddress(value3.getMin())] * value.getMultiplier());
            }
            if (Z80Disassembler.toAddress(value2, ramRomMap, state).isRomAddress() && Z80Disassembler.isCode(Z80Disassembler.toAddress(value2, ramRomMap, state).getMin())) {
                value2 = value2.add(value.getMultiplier());
            }
            if ((map = Z80Disassembler.getInstruction(address = value.getSource())) != null && ((Z80Instruction)((Object)map)).hasArg() && (((Z80Instruction)((Object)map)).getArg() & 0x3FFF) == (value.getMin() & 0x3FFF)) {
                list = Z80Disassembler.toAddress(value2, ramRomMap, state);
                if (((Address)((Object)list)).isRomAddress()) {
                    Z80Disassembler.markDataSeen((Address)((Object)list), address);
                } else if (((Address)((Object)list)).isRamAddress()) {
                    Z80Disassembler.markRAMseen(value2, address, 1);
                } else if (((Address)((Object)list)).isSramAddress()) {
                    Z80Disassembler.markSRAMseen(value2, state, address, 1);
                } else if (((Address)((Object)list)).isPortAddress()) {
                    Z80Disassembler.markPortSeen(value2);
                }
            }
            if (Z80Disassembler.isRAMaddress(address)) {
                list = memoryPointers.get(address.getMin());
                if (list == null) {
                    list = new ArrayList();
                    memoryPointers.put(address.getMin(), list);
                }
                if (!memoryPointerStates.containsKey(address.getMin())) {
                    memoryPointerStates.put(address.getMin(), Z80Disassembler.unmodifiableState(state));
                }
                for (Value value4 : list) {
                    Z80Disassembler.READ_BYTE(nArray, ramRomMap, Z80Disassembler.toAddress(value4, ramRomMap, state), state);
                }
                Table table = memoryTables.get(address.getMin());
                if (table != null && table.start > 0) {
                    if (instance.hasBank2() && table.state.getBank2().getMin() == state.getBank2().getMin()) {
                        Z80Disassembler.removeTable(pointerTables, table);
                    }
                    pointerTables.add(new Table(table, state));
                }
            }
        }
        return Value.newUnknownValue(Z80Disassembler.toAddress(value, ramRomMap, state), 255);
    }

    private static final Z80Instruction getInstruction(Address address) {
        if (address != null && address.isRomAddress()) {
            return Z80Disassembler.getInstruction(address.getMin());
        }
        return null;
    }

    static final Z80Instruction getInstruction(int n) {
        if (!Z80Disassembler.isInstruction(n)) {
            return null;
        }
        return instructions.get(n);
    }

    public static final boolean isInstruction(int n) {
        return n >= 0 && instructionStart.get(n);
    }

    private static final boolean isSubInstructionByte(int n) {
        return Z80Disassembler.isCode(n) && !instructionStart.get(n);
    }

    private static final Z80Instruction getPrevInstruction(int n) {
        if (!Z80Disassembler.isCode(n - 1)) {
            return null;
        }
        int n2 = 1;
        while (n2 <= 3) {
            Z80Instruction z80Instruction = Z80Disassembler.getInstruction(n - n2);
            if (z80Instruction != null) {
                return z80Instruction;
            }
            ++n2;
        }
        return null;
    }

    private static final void setInstruction(int n, Z80Instruction z80Instruction) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        if (n < code.length && !instructionStart.get(n)) {
            instructions.put(n, z80Instruction);
            instructionStart.set(n);
        }
    }

    private static final void removeInstruction(int n) {
        instructions.remove(n);
        instructionStart.clear(n);
    }

    private static final Value getBank0(int n) {
        Value value = bank0.get(n);
        if (value == null) {
            return Value.ZERO;
        }
        return value;
    }

    private static final void setBank0(int n, Value value) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        if (value.getMin() > 0) {
            bank0.put(n, value);
        }
    }

    static final Value getBank1(int n) {
        Value value = bank1.get(n);
        if (value == null) {
            return Value.ZERO;
        }
        return value;
    }

    private static final void setBank1(int n, Value value) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        if (value.getMin() > 0) {
            bank1.put(n, value);
        }
    }

    static final Value getBank2(int n) {
        Value value = bank2.get(n);
        if (value == null) {
            return Value.ZERO;
        }
        return value;
    }

    private static final void setBank2(int n, Value value) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        if (value.getMin() > 0) {
            bank2.put(n, value);
        }
    }

    static final Value getBank3(int n) {
        Value value = bank3.get(n);
        if (value == null) {
            return Value.ZERO;
        }
        return value;
    }

    private static final void setBank3(int n, Value value) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        if (value.getMin() > 0) {
            bank3.put(n, value);
        }
    }

    private static final void setSRAMenabled(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        sramEnabled.set(n, bl);
    }

    private static final boolean isSRAMenabled(int n) {
        return sramEnabled.get(n);
    }

    private static final Value getSRAMbank(int n) {
        Value value = sramBank.get(n);
        if (value == null) {
            return Value.ZERO;
        }
        return value;
    }

    private static final void setSRAMbank(int n, Value value) {
        if (n < 0) {
            throw new IllegalArgumentException("Address must not be negative.");
        }
        if (value.getMin() > 0) {
            sramBank.put(n, value);
        }
    }

    private static final Value READ_BYTE(int[] nArray, RamRomMap ramRomMap, Value value, int n, State state, boolean bl) {
        if (value.isStackPointerValue()) {
            int n2 = value.getOffset();
            int n3 = n2 = n2 >= 0 ? n2 / 2 * 3 + n2 % 2 + 1 : n2;
            if (n2 < 0 || n2 >= state.getStack().size()) {
                return Value.newUnknownValue(255);
            }
            Value value2 = state.getStack().get(n2);
            if (value2 == null) {
                throw new IllegalStateException("Reading null from stack");
            }
            return value2;
        }
        if (value instanceof Address) {
            Address address = (Address)value;
            if (n != 0) {
                value = value.add(n);
            }
            if (!address.isRomAddress()) {
                return Z80Disassembler.READ_BYTE(nArray, ramRomMap, value.getMin(), null, state, bl);
            }
            return new Value(nArray[value.getMin()], address);
        }
        return Z80Disassembler.READ_BYTE(nArray, ramRomMap, value.getMin() + n, Z80Disassembler.toAddress(new Value(value.getMin() + n, value.getSource()), ramRomMap, state), state, bl);
    }

    private static final Value READ_BYTE(int[] nArray, RamRomMap ramRomMap, int n, Address address, State state, boolean bl) {
        if (address == null) {
            address = Z80Disassembler.toAddress(n, ramRomMap, state);
        }
        if (!msx && !(instance instanceof LR35902Disassembler)) {
            if ((n & 0xDFFF) == 57340) {
                return state.getRAMvalue(n);
            }
            if ((n & 0xDFFF) == 57341) {
                return state.getBank0().newSource(address);
            }
            if ((n & 0xDFFF) == 57342) {
                return state.getBank1().newSource(address);
            }
            if ((n & 0xDFFF) == 57343) {
                return state.getBank2().newSource(address);
            }
        }
        if (n == 65536) {
            return new Value(nArray[0], Z80Disassembler.toAddress(0, ramRomMap, state));
        }
        if (n < 0 || n > 65535) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (address.isUnknown()) {
            return Value.newUnknownValue(address, 255);
        }
        if (address.isRomAddress()) {
            if (nArray == null || Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state) >= nArray.length) {
                return Value.newUnknownValue(address, 255);
            }
            return new Value(nArray[Z80Disassembler.RESOLVE_ADDRESS(n, ramRomMap, state)], address);
        }
        if (address.isRamAddress()) {
            Value value = state.getRAMvalue(n);
            if (!bl) {
                return value;
            }
            return Value.newUnknownValue(Z80Disassembler.toAddress(address.newSource(value.getSource()), ramRomMap, state), 255);
        }
        if (address.isSramAddress()) {
            Value value = state.getSRAMvalue(n);
            if (!bl) {
                return value;
            }
            return Value.newUnknownValue(Z80Disassembler.toAddress(address.newSource(value.getSource()), ramRomMap, state), 255);
        }
        return Value.newUnknownValue(address, 255);
    }

    private static final int READ_BYTE(int[] nArray, int n) {
        if (n >= nArray.length) {
            return 0;
        }
        return nArray[n];
    }

    private static final int READ_WORD(int[] nArray, int n) {
        return Z80Disassembler.READ_BYTE(nArray, n + 1) << 8 | Z80Disassembler.READ_BYTE(nArray, n);
    }

    private static final void READ_WORD(RegisterPair registerPair, int[] nArray, RamRomMap ramRomMap, Value value, State state) {
        Value value2;
        Address address;
        Object object;
        if (value.isUnique() && value.getSource() != null && value.getSource().isUnique() && (object = Z80Disassembler.getInstruction(address = value.getSource())) != null && ((Z80Instruction)object).hasArg() && ((Z80Instruction)object).getArg() == value.getMin()) {
            value2 = Z80Disassembler.toAddress(value, ramRomMap, state);
            if (((Address)value2).isRomAddress()) {
                Z80Disassembler.markDataSeen((Address)value2, address);
            } else if (((Address)value2).isRamAddress()) {
                Z80Disassembler.markRAMseen(value2, address, 2);
            } else if (((Address)value2).isSramAddress()) {
                Z80Disassembler.markSRAMseen(value2, state, address, 2);
            } else if (((Address)value2).isPortAddress()) {
                Z80Disassembler.markPortSeen(value2);
            }
        }
        registerPair.lo.ld(Z80Disassembler.READ_BYTE(nArray, ramRomMap, value, state));
        registerPair.hi.ld(Z80Disassembler.READ_BYTE(nArray, ramRomMap, value.inc(), state));
        address = registerPair.getSource();
        if (address != null && address.isRamAddress()) {
            object = state.getRAMvalue(address.getMin());
            value2 = state.getRAMvalue(address.getMin() + 1);
            if (((Value)object).isUnique() && value2.isUnique() && Z80Disassembler.getInstruction(((Value)object).getSource()) != null) {
                registerPair.lo.ld((Value)object);
                registerPair.hi.ld(value2);
            }
        }
    }

    private static final void WRITE_WORD(int[] nArray, RamRomMap ramRomMap, Value value, Value value2, Value value3, State state) {
        if (value.isUnique()) {
            Address address;
            Z80Instruction z80Instruction;
            if (value.getSource() != null && value.getSource().isUnique() && (z80Instruction = Z80Disassembler.getInstruction(address = value.getSource())) != null && z80Instruction.hasArg() && z80Instruction.getArg() == value.getMin()) {
                if (instance.isRAMaddress(value)) {
                    Z80Disassembler.markRAMseen(value, address, 2);
                } else if (instance.isSRAMaddress(value, state)) {
                    Z80Disassembler.markSRAMseen(value, state, address, 2);
                } else if (instance.isPortAddress(value)) {
                    Z80Disassembler.markPortSeen(value);
                }
            }
            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, value.getMin(), value2, state);
            Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, value.getMin() + 1, value3, state);
        }
    }

    protected static final void WRITE_BYTE(int[] nArray, RamRomMap ramRomMap, Value value, Value value2, State state) {
        Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, value, 0, value2, state);
    }

    protected static final void WRITE_BYTE(int[] nArray, RamRomMap ramRomMap, Value value, int n, Value value2, State state) {
        if (!value.isStackPointerValue()) {
            if (value.isUnique()) {
                Address address;
                Z80Instruction z80Instruction;
                if (value.getSource() != null && value.getSource().isUnique() && (z80Instruction = Z80Disassembler.getInstruction(address = value.getSource())) != null && z80Instruction.hasArg() && z80Instruction.getArg() == value.getMin()) {
                    if (instance.isRAMaddress(value.getMin())) {
                        Z80Disassembler.markRAMseen(value, address, 1);
                    } else if (instance.isSRAMaddress(value.getMin(), state)) {
                        Z80Disassembler.markSRAMseen(value, state, address, 1);
                    } else if (instance.isPortAddress(value.getMin())) {
                        Z80Disassembler.markPortSeen(value);
                    }
                }
                Z80Disassembler.WRITE_BYTE(nArray, ramRomMap, value.getMin() + n, value2, state);
            } else if (value.getSource() != null && value.getSource().isRomAddress() && (value.getSource().getMultiplier() == 2 || value.getSource().getSource() != null && value.getSource().getSource().getMultiplier() == 2)) {
                Z80Disassembler.READ_BYTE(nArray, ramRomMap, value, state);
            }
        }
    }

    private static final void WRITE_BYTE(int[] nArray, RamRomMap ramRomMap, int n, Value value, State state) {
        List<Value> list;
        int n2;
        int n3;
        Value value2;
        if (n < 0 || n >= 65536) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (instance.isPortAddress(n)) {
            return;
        }
        dummyCartridge.setBank0(state.getBank0().getMin());
        dummyCartridge.setBank1(state.getBank1().getMin());
        dummyCartridge.setBank2(state.getBank2().getMin());
        dummyCartridge.setBank3(state.getBank3().getMin());
        dummyCartridge.setSRAMenabled(state.isSRAMenabled());
        dummyCartridge.setSRAMbank(state.getSRAMbank().getMin());
        int n4 = value.getMin();
        if (n4 == 0 && value.getSource() != null && value.getSource().isUnique() && value.getSource().isRamAddress() && (value2 = state.getRAMvalue(value.getSource().getMin())).isUnique() && n4 != value2.getMin()) {
            n4 = value2.getMin();
        }
        dummyCartridge.processWrite(n, n4, 0);
        if (dummyCartridge instanceof SMSCartridge && ((SMSCartridge)dummyCartridge).isDBMapper()) {
            throw new UnsupportedOperationException("DB Mapper is unsupported");
        }
        if (state.getSRAMbank().getMin() != dummyCartridge.getSRAMbank()) {
            if (dummyCartridge.getSRAMbank() < state.getSRAMbank().getMin() || dummyCartridge.getSRAMbank() > state.getSRAMbank().getMax()) {
                state.setSRAMbank(new Value(dummyCartridge.getSRAMbank(), value.getSource()));
            }
        } else if (state.getBank3().getMin() != dummyCartridge.getBank3()) {
            if (dummyCartridge.getBank3() < state.getBank3().getMin() || dummyCartridge.getBank3() > state.getBank3().getMax()) {
                state.setBank3(new Value(dummyCartridge.getBank3(), value.getSource()));
                if (state.getBank3().getMin() > 0 && state.getBank3().getMin() < slots.length) {
                    Z80Disassembler.slots[state.getBank3().getMin()] = 3;
                }
            }
        } else if (state.getBank2().getMin() != dummyCartridge.getBank2()) {
            if (dummyCartridge.getBank2() < state.getBank2().getMin() || dummyCartridge.getBank2() > state.getBank2().getMax()) {
                state.setBank2(new Value(dummyCartridge.getBank2(), value.getSource()));
                if (state.getBank2().getMin() > 0 && state.getBank2().getMin() < slots.length) {
                    Z80Disassembler.slots[state.getBank2().getMin()] = 2;
                }
            }
        } else if (state.getBank1().getMin() != dummyCartridge.getBank1()) {
            if (dummyCartridge.getBank1() < state.getBank1().getMin() || dummyCartridge.getBank1() > state.getBank1().getMax()) {
                state.setBank1(new Value(dummyCartridge.getBank1(), value.getSource()));
                if (state.getBank1().getMin() > 0 && state.getBank1().getMin() < slots.length) {
                    Z80Disassembler.slots[state.getBank1().getMin()] = 1;
                }
            }
        } else if (state.getBank0().getMin() != dummyCartridge.getBank0()) {
            if (dummyCartridge.getBank0() < state.getBank0().getMin() || dummyCartridge.getBank0() > state.getBank0().getMax()) {
                state.setBank0(new Value(dummyCartridge.getBank0(), value.getSource()));
                if (state.getBank0().getMin() > 0 && state.getBank0().getMin() < slots.length) {
                    Z80Disassembler.slots[state.getBank0().getMin()] = 0;
                }
            }
        } else if (instance.hasBank3()) {
            if (dummyCartridge.getBank3() < state.getBank3().getMin() || dummyCartridge.getBank3() > state.getBank3().getMax()) {
                state.setBank3(new Value(dummyCartridge.getBank3(), value.getSource()));
                if (state.getBank3().getMin() > 0 && state.getBank3().getMin() < slots.length) {
                    Z80Disassembler.slots[state.getBank2().getMin()] = 3;
                }
            }
        } else if (instance.hasBank2()) {
            if (dummyCartridge.getBank2() < state.getBank2().getMin() || dummyCartridge.getBank2() > state.getBank2().getMax()) {
                state.setBank2(new Value(dummyCartridge.getBank2(), value.getSource()));
                if (state.getBank2().getMin() > 0 && state.getBank2().getMin() < slots.length) {
                    Z80Disassembler.slots[state.getBank2().getMin()] = 2;
                }
            }
        } else if (dummyCartridge.getBank1() < state.getBank1().getMin() || dummyCartridge.getBank1() > state.getBank1().getMax()) {
            state.setBank1(new Value(dummyCartridge.getBank1(), value.getSource()));
        }
        state.setSRAMenabled(dummyCartridge.isSRAMenabled());
        if (instance.isSRAMaddress(n, state)) {
            state.setSRAMvalue(n, value);
        }
        if (!instance.isRAMaddress(n)) {
            return;
        }
        state.setRAMvalue(n, value);
        int n5 = instance.mapRAMaddress(n);
        if (ramCode.containsKey(n5) && value.getSource() != null && value.getSource().isUnique() && value.getSource().isRomAddress() && (!value.isUnique() || value.getMin() != 195)) {
            Object object;
            int n6 = n5;
            boolean bl = false;
            n3 = ramCode.get(n6 - 2);
            if (n3 != Integer.MIN_VALUE && (object = Z80Disassembler.getInstruction(n3)) != null && ((Z80Instruction)object).isBranch() && instance.isROMaddress(n2 = state.getRAMvalue(n6).getMin() << 8 | state.getRAMvalue(n6 - 1).getMin(), state)) {
                list = value.getSource();
                int n7 = list != null && ((Value)((Object)list)).getSource() != null ? ((Value)((Object)list)).getSource().getMin() : state.getAddress(ramRomMap);
                ramCodeWrites.put(n7, new RamCodeWrite(n2, n2, n7, state));
            }
            if (ramCode.containsKey(n6 - 1) && ramCode.containsKey(n6 - 2) && state.getRAMvalue(n6 - 2).isUnique() && state.getRAMvalue(n6 - 2).getMin() == 195) {
                n6 -= 2;
                bl = true;
            }
            if (!ramCode.containsKey(n6 - 1)) {
                Value value3;
                int n8;
                object = state.getRAMvalue(n6 += n - n5).getSource();
                int n9 = n2 = object != null && ((Value)object).getSource() != null ? ((Value)object).getSource().getMin() : state.getAddress(ramRomMap);
                if (bl && instance.isRAMaddress(n8 = state.getRAMvalue(n6 + 2).getMin() << 8 | state.getRAMvalue(n6 + 1).getMin()) && (value3 = state.getRAMvalue(instance.mapRAMaddress(n8))).getSource() != null && value3.getSource().isUnique() && value3.getSource().isRomAddress()) {
                    ramCodeWrites.put(value3.getSource().getMin(), new RamCodeWrite(n6, value3.getSource().getMin(), n2, state));
                }
                ramCodeWrites.put(value.getSource().getMin(), new RamCodeWrite(n6, value.getSource().getMin(), n2, state));
            }
        }
        if (n5 > 0) {
            int n10;
            Value value4;
            Address address;
            Object object;
            Object object2;
            if (value.getSource() == null || value.getSource().isRamAddress()) {
                return;
            }
            if (value.isUnique() && value.getMin() == 195) {
                int n11;
                Value value5;
                Address address2 = value.getSource();
                Value value6 = state.getRAMvalue(n + 1);
                if (value6.getSource() != null && (value5 = state.getRAMvalue(n + 2)).getSource() != null && ((Value)((Object)(list = value6.newValue(n11 = value5.getMin() << 8 | value6.getMin() & 0xFF, n2 = value5.getMax() << 8 | value6.getMax() & 0xFF)))).isUnique()) {
                    Table table;
                    if ((table = memoryTables.get(++n)) != null && memoryJump.get(n)) {
                        if (instance.isROMaddress(value6.getSource().getMin(), state)) {
                            memoryJumps.put(value6.getSource().getMin() << 16 | n, new MemoryJump(value6.getSource().getMin(), n11, table.state));
                        }
                    } else if (instance.isROMaddress(n11, state)) {
                        memoryJump.set(n);
                        if (!memoryTables.containsKey(n)) {
                            memoryTables.put(n, new Table(n11, n2, address2, null, state));
                        }
                    }
                    if ((object2 = memoryPointers.get(n)) == null) {
                        object2 = new ArrayList<Object>();
                        memoryPointers.put(n, (List<Value>)object2);
                    }
                    if (!object2.contains(object = list)) {
                        object2.add(object);
                        State state2 = memoryPointerStates.get(n);
                        if (state2 != null) {
                            Z80Disassembler.READ_BYTE(nArray, ramRomMap, (Value)object, state2);
                        }
                    }
                }
            }
            if ((address = (value4 = state.getRAMvalue(--n)).getSource()) == null) {
                return;
            }
            n3 = value.getMin() << 8 | value4.getMin() & 0xFF;
            Value value7 = value4.newValue(n3, n10 = value.getMax() << 8 | value4.getMax() & 0xFF);
            if (value7.isUnique()) {
                list = memoryTables.get(n);
                if (list != null && memoryJump.get(n) && instance.isROMaddress(n3, ((Table)((Object)list)).state)) {
                    memoryJumps.put(address.getMin() << 16 | n, new MemoryJump(address.getMin(), n3, ((Table)((Object)list)).state));
                } else {
                    Value value8 = state.getRAMvalue(n - 1);
                    if (value8.isUnique() && value8.getMin() == 195 && instance.isROMaddress(n3, state)) {
                        memoryJump.set(n);
                        if (!memoryTables.containsKey(n)) {
                            memoryTables.put(n, new Table(n3, n10, address, null, state));
                        }
                    }
                }
                List<Value> list2 = memoryPointers.get(n);
                if (list2 == null) {
                    list2 = new ArrayList<Value>();
                    memoryPointers.put(n, list2);
                }
                if (!list2.contains(object2 = value7)) {
                    list2.add((Value)object2);
                    object = memoryPointerStates.get(n);
                    if (object != null) {
                        Z80Disassembler.READ_BYTE(nArray, ramRomMap, object2, (State)object);
                    }
                }
            } else if (address.isRomAddress() && (address.getMultiplier() == 2 || address.getMultiplier() == 16 || address.getSource() != null && address.getSource().getMultiplier() == 2)) {
                Value value9;
                list = memoryPointers.get(n);
                if (list == null) {
                    list = new ArrayList<Value>();
                    memoryPointers.put(n, list);
                }
                if (!list.contains(value9 = value7)) {
                    list.add(value9);
                    object2 = memoryPointerStates.get(n);
                    if (object2 != null) {
                        Z80Disassembler.READ_BYTE(nArray, ramRomMap, value9, object2);
                    }
                }
                if (memoryJump.get(n) && address.getSource() != null && !address.getSource().isUnique() && (object2 = memoryTables.get(n)) != null) {
                    entriesOfTablePointToTablesOfJumpTables.set(address.getSource().getMin());
                }
                if (memoryTableRead.get(n) && address.getSource() != null && !address.getSource().isUnique()) {
                    entriesOfTablePointToTablesOfPointerTables.set(address.getSource().getMin());
                }
                if (memoryTableReadRead.get(n) && address.getSource() != null && !address.getSource().isUnique()) {
                    object2 = entriesOfTablePointToTablesOfTablesOfPointerTables.get(address.getSource().getMin());
                    if (object2 == null) {
                        object2 = new IntHashSet();
                        entriesOfTablePointToTablesOfTablesOfPointerTables.put(address.getSource().getMin(), (IntHashSet)object2);
                    }
                    ((IntHashSet)object2).add(address.getOffset());
                }
            }
            if (address.isRomAddress() && !address.isUnique() && address.getMultiplier() >= 2) {
                int n12 = address.getMin();
                if (n12 == 0) {
                    return;
                }
                int n13 = Math.min(nArray.length - 1, address.getMax() + 1) - n12;
                Object object3 = object2 = address.getSource() != null ? address.getSource().getAdditional() : null;
                if (object2 != null && ((Address)object2).isRamAddress() && ((Value)object2).isUnique()) {
                    n12 += indexMinValues[instance.mapRAMaddress(((Value)object2).getMin())] * 2;
                }
                if (Z80Disassembler.isCode(n12)) {
                    n12 += 2;
                    n13 -= 2;
                }
                int n14 = n12;
                int n15 = 0;
                while (n15 < n13 && !Z80Disassembler.hasLabel(n14) && !Z80Disassembler.hasLabel(n14 + 1) && instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n14), state)) {
                    int n16 = Z80Disassembler.RESOLVE_ADDRESS(Z80Disassembler.READ_WORD(nArray, n14), ramRomMap, state);
                    if (!instance.isROMaddress(Z80Disassembler.READ_WORD(nArray, n14), state) || Z80Disassembler.isSubInstructionByte(n16)) break;
                    n14 += 2;
                    n15 += 2;
                }
                if (n14 > n12) {
                    Table table;
                    if (n13 != address.getMax() - address.getMin() && object2 != null && ((Address)object2).isRamAddress() && indexMinValues[instance.mapRAMaddress(((Value)object2).getMin())] < (n12 - address.getMin()) / 2) {
                        Z80Disassembler.indexMinValues[Z80Disassembler.instance.mapRAMaddress((int)((Value)object2).getMin())] = (n12 - address.getMin()) / 2;
                    }
                    if ((table = memoryTables.get(n)) != null) {
                        if (memoryJump.get(n)) {
                            Z80Disassembler.addTable(jumpTables, n12, n14, address, (Address)object2, table.state);
                        }
                    } else if (!memoryTables.containsKey(n)) {
                        memoryTables.put(n, new Table(n12, n14, address, (Address)object2, state));
                    }
                }
            }
        }
    }

    static /* synthetic */ void access$2(int n, int n2, RamRomMap ramRomMap) {
        Z80Disassembler.forceSetData(n, n2, ramRomMap);
    }

    public static class CpuLines {
        private final List<SourceLine>[] blocks;
        private final int numberOfBlocks;

        public CpuLines(int n) {
            this.numberOfBlocks = n;
            this.blocks = new List[n];
            int n2 = 0;
            while (n2 < this.blocks.length) {
                this.blocks[n2] = new ArrayList<SourceLine>();
                ++n2;
            }
        }

        public int getNumberOfBlocks() {
            return this.numberOfBlocks;
        }

        public List<SourceLine> getLines(int n) {
            return this.blocks[n];
        }

        public synchronized SourceLine get(int n) {
            int n2 = 0;
            while (n2 < this.blocks.length && n >= this.blocks[n2].size()) {
                n -= this.blocks[n2].size();
                ++n2;
            }
            if (n2 >= this.blocks.length) {
                return null;
            }
            return this.blocks[n2].get(n);
        }

        public synchronized int size() {
            int n = this.blocks[0].size();
            int n2 = 1;
            while (n2 < this.blocks.length) {
                n += this.blocks[n2].size();
                ++n2;
            }
            return n;
        }

        public void clear() {
            List<SourceLine>[] listArray = this.blocks;
            int n = this.blocks.length;
            int n2 = 0;
            while (n2 < n) {
                List<SourceLine> list = listArray[n2];
                list.clear();
                ++n2;
            }
        }
    }

    static final class DataBlock {
        public final int start;
        public final int length;

        public DataBlock(int n, int n2) {
            this.start = n;
            this.length = n2;
        }

        public String toString() {
            return String.valueOf(Integer.toHexString(this.start).toUpperCase()) + " to " + Integer.toHexString(this.start + this.length - 1).toUpperCase();
        }
    }

    static final class DisassemblerCSourceMap
    extends AbstractCSourceMap {
        private final util.map.Map<String> filenameMap = new HashMap<String>();
        private final IntMap lineMap = new HashIntMap();

        public DisassemblerCSourceMap(File file) {
            super(file);
        }

        @Override
        public int getLineNumberROM(int n) {
            return this.lineMap.get(n);
        }

        @Override
        public File getFileROM(int n) {
            return this.findFile(this.filenameMap.get(n));
        }

        @Override
        public int getAddressROM(File file, int n) {
            for (Map.Entry<String> entry : this.filenameMap.entrySet()) {
                if (this.lineMap.get(entry.getKey()) != n || !file.getName().equals(entry.getValue())) continue;
                return entry.getKey();
            }
            return -1;
        }

        public void addMapping(int n, String string, int n2) {
            this.filenameMap.put(n, string);
            this.lineMap.put(n, n2);
        }

        @Override
        public boolean isValid() {
            return !this.filenameMap.isEmpty();
        }
    }

    static final class DisassemblerSourceMap
    implements SourceMap {
        private final File[] fileMap;
        private final int[] lineMap;

        DisassemblerSourceMap(int n) {
            this.lineMap = new int[n];
            this.fileMap = new File[n];
        }

        @Override
        public int getLineNumberROM(int n) {
            if (n < 0 || n >= this.lineMap.length) {
                return -1;
            }
            return this.lineMap[n];
        }

        @Override
        public File getFileROM(int n) {
            if (n < 0 || n >= this.fileMap.length) {
                return null;
            }
            return this.fileMap[n];
        }

        @Override
        public int getAddressROM(File file, int n) {
            int n2 = 0;
            while (n2 < this.lineMap.length) {
                if (this.lineMap[n2] == n && file.getName().equals(this.fileMap[n2].getName())) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public void addMapping(Z80SourceLine z80SourceLine, SourceLine sourceLine) {
            int n = sourceLine.getAddress();
            if (n < 0 || n >= this.lineMap.length) {
                return;
            }
            int n2 = z80SourceLine.getLineNumber();
            File file = z80SourceLine.getFile();
            int n3 = sourceLine.getSize();
            int n4 = 0;
            while (n4 < n3) {
                this.lineMap[n + n4] = n2;
                this.fileMap[n + n4] = file;
                ++n4;
            }
        }
    }

    protected static final class DisassemblerState {
        protected final int[] memory;
        protected final List<State> conditionalRetStates = new ArrayList<State>();
        protected final int maxAddressesToVisit;
        protected final RamRomMap ramRomMap;
        protected int retAddressStackPos;
        protected int addressesSinceLastDiscovery;
        protected Value retAddressValue;

        private DisassemblerState(int[] nArray, RamRomMap ramRomMap, int n, int n2) {
            this.memory = nArray;
            this.ramRomMap = ramRomMap != null ? ramRomMap : defaultRamRomMap;
            this.maxAddressesToVisit = n;
            this.addressesSinceLastDiscovery = n2;
        }

        public DisassemblerState(int[] nArray, int n) {
            this(nArray, null, n);
        }

        public DisassemblerState(int[] nArray, RamRomMap ramRomMap, int n) {
            this(nArray, ramRomMap, n, 0);
        }

        public DisassemblerState(DisassemblerState disassemblerState) {
            this(disassemblerState.memory, disassemblerState.ramRomMap, disassemblerState.maxAddressesToVisit, disassemblerState.addressesSinceLastDiscovery);
        }
    }

    public static final class IntegerTreeMap
    extends TreeMap<Integer, IntegerTreeMap> {
        public IntegerTreeMap() {
        }

        public IntegerTreeMap(IntegerTreeMap integerTreeMap, Comparator<Integer> comparator) {
            super(comparator);
            this.putAll(integerTreeMap);
        }
    }

    static final class MemoryJump {
        private final int source;
        private final int address;
        private final State state;

        public MemoryJump(int n, int n2, State state) {
            this.source = n;
            this.address = n2;
            if (instance.isROMaddress(n2, state)) {
                if (n2 >= dummyCartridge.getBankSize() * 3) {
                    if (state.getBank3().getMin() == 0 && Z80Disassembler.getBank3(n).getMin() != 0) {
                        state = new State(state);
                        state.setBank3(Z80Disassembler.getBank3(n));
                    }
                } else if (n2 >= dummyCartridge.getBankSize() * 2) {
                    if (state.getBank2().getMin() == 0 && Z80Disassembler.getBank2(n).getMin() != 0) {
                        state = new State(state);
                        state.setBank2(Z80Disassembler.getBank2(n));
                    }
                } else if (n2 >= dummyCartridge.getBankSize() && state.getBank1().getMin() == 0 && Z80Disassembler.getBank1(n).getMin() != 0) {
                    state = new State(state);
                    state.setBank1(Z80Disassembler.getBank1(n));
                }
            } else {
                throw new IllegalArgumentException("A memory jump must jump to ROM.");
            }
            this.state = Z80Disassembler.unmodifiableState(state);
        }

        public int getSource() {
            return this.source;
        }

        public int getAddress() {
            return this.address;
        }

        public State getState() {
            return this.state;
        }

        public String toString() {
            return String.valueOf(Integer.toHexString(this.source)) + " " + Integer.toHexString(this.address);
        }
    }

    private static class ParsingState {
        int bank;
        int slot;
        int returnOrg;
        int sectionEnd = Integer.MAX_VALUE;
        int indexPrevParsedLineWithSize;
        String sectionName;
        String lastAmbiguousLabel;
        boolean beginningOfSection;
        boolean sectionDiscarded;
        boolean prevWasMismatched;
        boolean prevWasLabel;
        int addrBeforeChangeByLabel;
        boolean withinDstruct;
        boolean sdccDataArea;
        boolean autoNopAfterHalt;
        String prevLabel;
        final LinkedList<String> childLabelStack = new LinkedList();
        final Z80ParseResult parseResult;
        final ROMBankMap romBankMap;
        final MemoryMap memoryMap;
        final List<SourceLine> lines;
        final List<assembler.Section> sections;
        final util.map.Map<List<assembler.Section>> sectionsByBank;
        final Map<Integer, List<SourceLine>> undeterminedRepts = new TreeMap(Collections.reverseOrder());
        final int[] memory;
        final Map<String, List<Symbols.Symbol>> symbols;
        final SectionProvider sectionProvider;
        final Set<String> sectionMapped = new HashSet<String>();
        final BitSet mapped = new BitSet();
        final BitSet labels = new BitSet();
        final boolean sdcc;

        public ParsingState(List<SourceLine> list, int[] nArray, Map<String, List<Symbols.Symbol>> map, SectionProvider sectionProvider, Z80ParseResult z80ParseResult, boolean bl) {
            this.lines = list;
            this.memory = nArray;
            this.symbols = map;
            this.sectionProvider = sectionProvider;
            this.sdcc = bl;
            this.parseResult = z80ParseResult;
            ROMBankMap rOMBankMap = z80ParseResult.getROMBankMap();
            this.romBankMap = !bl || rOMBankMap != null ? rOMBankMap : new DefaultROMBankMap(Z80Disassembler.getRomBank(nArray.length - 1) + 1, dummyCartridge.getBankSize());
            MemoryMap memoryMap = z80ParseResult.getMemoryMap();
            MemoryMap memoryMap2 = this.memoryMap = memoryMap != null ? memoryMap : new NoMemoryMap();
            if (sectionProvider != null) {
                this.sections = new ArrayList<assembler.Section>(sectionProvider.getNumberOfSections());
                for (assembler.Section section : z80ParseResult.getSections()) {
                    if (sectionProvider.getSectionAddress(section.getName().toString()) < 0) continue;
                    this.sections.add(section);
                }
            } else {
                this.sections = z80ParseResult.getSections();
            }
            this.sectionsByBank = ParsingState.groupSectionsByBank(this.sections);
        }

        private static util.map.Map<List<assembler.Section>> groupSectionsByBank(List<assembler.Section> list) {
            HashMap<List<assembler.Section>> hashMap = new HashMap<List<assembler.Section>>();
            for (assembler.Section section : list) {
                if (section.getSize() <= 0 || section.getMode() == Section.Mode.FORCE || section.getMode() == Section.Mode.OVERWRITE) continue;
                int n = section.getMode() == Section.Mode.SUPERFREE ? -1 : section.getBank();
                ArrayList<assembler.Section> arrayList = (ArrayList<assembler.Section>)hashMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<assembler.Section>();
                    hashMap.put(n, arrayList);
                }
                arrayList.add(section);
            }
            return hashMap;
        }

        public void setPrevLabel(String string) {
            if (!this.withinDstruct && "+-".indexOf(string.charAt(0)) < 0) {
                this.prevLabel = string;
                this.childLabelStack.clear();
            }
        }

        public String resolveChildLabel(String string) {
            char c = string.charAt(0);
            String string2 = string;
            while (!string2.isEmpty() && string2.charAt(0) == c) {
                string2 = string2.substring(1);
            }
            int n = string.length() - string2.length();
            while (!this.childLabelStack.isEmpty() && n <= this.childLabelStack.size()) {
                this.childLabelStack.pop();
            }
            if (this.childLabelStack.isEmpty()) {
                return String.valueOf(this.prevLabel) + c + string2;
            }
            return String.valueOf(this.childLabelStack.peek()) + c + string2;
        }

        public void pushChildLabel(String string) {
            if (!this.withinDstruct) {
                this.childLabelStack.push(string);
            }
        }

        public SourceMap createSourceMap() {
            DisassemblerSourceMap disassemblerSourceMap = new DisassemblerSourceMap(this.memory.length);
            List<SourceLine> list = this.lines;
            List<Z80SourceLine> list2 = this.parseResult.getLines();
            int n = Math.min(list.size(), list2.size());
            int n2 = 0;
            while (n2 < n) {
                SourceLine sourceLine = list.get(n2);
                Z80SourceLine z80SourceLine = list2.get(n2);
                disassemblerSourceMap.addMapping(z80SourceLine, sourceLine);
                ++n2;
            }
            return disassemblerSourceMap;
        }

        public void mapEmptySections() {
            if (this.romBankMap == null || this.sectionProvider == null) {
                return;
            }
            int n = -1;
            boolean bl = true;
            List<? extends Section>[] listArray = this.sectionProvider.getEmptyRomSections();
            int n2 = 0;
            while (n2 < this.memory.length / this.romBankMap.getBankSize(0)) {
                int n3;
                int n4;
                List<? extends Section> list;
                List<? extends Section> list2 = list = n2 < listArray.length ? listArray[n2] : null;
                if (list != null) {
                    for (Section section : list) {
                        n4 = this.romBankMap.resolveAddress(n2, section.getOrg());
                        n3 = section.getSize();
                        if (n < 0) {
                            n = this.memory[n4 + n3 - 1];
                        }
                        boolean bl2 = true;
                        int n5 = n3 - 1;
                        while (bl2 && n5 >= 0) {
                            if (this.mapped.get(n4 + n5) || this.memory[n4 + n5] != n) {
                                bl2 = false;
                            }
                            --n5;
                        }
                        if (!bl2) continue;
                        if (bl) {
                            this.lines.add(SourceLine.EMPTY_LINE);
                            this.lines.add(new SourceLine(";; EMPTY space"));
                            bl = false;
                        }
                        this.lines.add(new SourceLine(section.toString()));
                        this.lines.add(new SourceLine(n4, n3, String.valueOf(dialect.getDataPrefix(8)) + " " + n3 + "," + HexStrings.PREFIXED_HEX_STRINGS[n]));
                        this.mapped.set(n4, n4 + n3);
                    }
                } else if (!bl) {
                    int n6 = this.romBankMap.getBankAddress(n2);
                    int n7 = this.romBankMap.getBankSize(n2);
                    n4 = 1;
                    n3 = n7 - 1;
                    while (n4 != 0 && n3 >= 0) {
                        if (this.mapped.get(n6 + n3) || this.memory[n6 + n3] != n) {
                            n4 = 0;
                        }
                        --n3;
                    }
                    if (n4 != 0) {
                        this.lines.add(new SourceLine("; EMPTY space from " + Integer.toHexString(n6).toUpperCase() + " to " + Integer.toHexString(n6 + n7 - 1).toUpperCase() + " (" + n7 + " bytes)"));
                        this.lines.add(new SourceLine(n6, n7, String.valueOf(dialect.getDataPrefix(8)) + " " + n7 + "," + HexStrings.PREFIXED_HEX_STRINGS[n]));
                        this.mapped.set(n6, n6 + n7);
                    }
                }
                ++n2;
            }
        }

        public void mapFreeSections() {
            this.mapFreeSections(false);
        }

        public void mapSuperFreeSections() {
            this.mapFreeSections(true);
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        private void mapFreeSections(boolean var1_1) {
            if (this.romBankMap == null) {
                return;
            }
            var2_2 = Z80Disassembler.defaultRamRomMap;
            var3_3 = new TreeSet<assembler.Section>(new Comparator<assembler.Section>(){

                @Override
                public int compare(assembler.Section section, assembler.Section section2) {
                    int n = section2.getSize() - section.getSize();
                    if (n == 0) {
                        return section.getBegin() - section2.getBegin();
                    }
                    return n;
                }
            });
            for (Object var4_5 : this.sections) {
                if (var4_5.getMode() == Section.Mode.FORCE || var4_5.getMode() == Section.Mode.OVERWRITE || var1_1 ^ var4_5.getMode() == Section.Mode.SUPERFREE || this.sectionMapped.contains(var4_5.getName().toString())) continue;
                var3_3.add((assembler.Section)var4_5);
            }
            var4_5 = this.parseResult.getLines();
            if (this.lines.size() != var4_5.size()) {
                throw new IllegalStateException("Cannot map free sections because the number of parsed lines does not match the number of disassembly lines.");
            }
            for (Object var5_4 : var3_3) {
                var8_8 = false;
                var7_7 = var5_4.getBegin();
                while (var7_7 < var5_4.getEnd()) {
                    if (((Z80SourceLine)var4_5.get(var7_7)).getSize() > 0) break;
                    if (this.hasLabel(var7_7)) {
                        var8_8 = true;
                    }
                    ++var7_7;
                }
                if (var7_7 >= var5_4.getEnd() || this.lines.get(var7_7).getAddress() >= 0 || (var9_9 = this.findSection((assembler.Section)var5_4)) < 0 || this.mapped.get(var9_9) || this.mapped.get(var9_9, var9_9 + this.adjustRGBDSsectionSize((assembler.Section)var5_4)).cardinality() != 0) continue;
                while (var7_7 < var5_4.getEnd()) {
                    block18: {
                        block16: {
                            block17: {
                                var10_10 = (Z80SourceLine)var4_5.get(var7_7);
                                if (var10_10.getSize() <= 0) break block16;
                                if (var8_8) {
                                    Z80Disassembler.addLabel(var9_9);
                                    var8_8 = false;
                                }
                                var11_11 = this.lines.get(var7_7);
                                var12_12 = var10_10.getFirstByte();
                                if ((var12_12 < 0 || var9_9 < this.memory.length && this.memory[var9_9] == var12_12) && var11_11.getAddress() < 0) break block17;
                                if (var9_9 >= this.memory.length || !(Z80Disassembler.instance instanceof LR35902Disassembler)) ** GOTO lbl61
                                if (var12_12 == 250 && this.memory[var9_9] == 240 || var12_12 == 234 && this.memory[var9_9] == 224 || var12_12 == 199 && (this.memory[var9_9] & 199) == 199) {
                                    Z80Disassembler.forceSetInstruction(var9_9, var10_10.getInstruction(), this.memory, var2_2);
                                    var13_13 = Z80Disassembler.getInstruction(var9_9);
                                    this.lines.set(var7_7, new SourceLine(var9_9, var11_11.toString(), var13_13));
                                    this.mapped.set(var9_9, var9_9 + var13_13.getSize());
                                    var9_9 += var13_13.getSize();
                                    ++var7_7;
                                    continue;
                                }
                                if (this.memory[var9_9] != 0) ** GOTO lbl61
                                var13_14 = var9_9 - 1;
                                if (var13_14 >= 0 && this.memory[var9_9 - 1] == 0) {
                                    --var13_14;
                                }
                                if (this.memory[var13_14] != 16 && this.memory[var13_14] != 118) ** GOTO lbl61
                                var14_16 = var7_7 - 1;
                                while (var14_16 >= 0 && (this.lines.get(var14_16).getInstruction() == null || this.lines.get(var14_16).getInstruction().getOpCode() == 0)) {
                                    --var14_16;
                                }
                                var15_17 = this.lines.get(var14_16);
                                this.lines.set(var14_16, new SourceLine(var15_17.getAddress(), var15_17.getSize() + 1, var15_17.toString(), var15_17.getInstruction()));
                                ++var9_9;
                                continue;
lbl-1000:
                                // 1 sources

                                {
                                    var13_15 = this.lines.get(var7_7);
                                    if (var13_15.getSize() <= 0) continue;
                                    this.mapped.clear(var13_15.getAddress(), var13_15.getAddress() + var13_15.getSize());
                                    this.lines.set(var7_7, new SourceLine(((Z80SourceLine)var4_5.get(var7_7)).toString()));
lbl61:
                                    // 5 sources

                                    ** while (--var7_7 >= var5_4.getBegin())
                                }
lbl62:
                                // 1 sources

                                break;
                            }
                            if (var10_10.getInstruction() != null) {
                                Z80Disassembler.forceSetInstruction(var9_9, var10_10.getInstruction(), this.memory, var2_2);
                            } else if (Z80Disassembler.isCode(var9_9)) {
                                Z80Disassembler.access$2(var9_9, var10_10.getSize(), var2_2);
                            }
                            this.lines.set(var7_7, new SourceLine(var9_9, var10_10.getSize(), var11_11.toString(), Z80Disassembler.getInstruction(var9_9)));
                            this.mapped.set(var9_9, var9_9 + var10_10.getSize());
                            var9_9 += var10_10.getSize();
                            break block18;
                        }
                        if (this.hasLabel(var7_7)) {
                            var8_8 = true;
                        }
                    }
                    ++var7_7;
                }
                if (var7_7 < var5_4.getEnd()) continue;
                this.sectionMapped.add(var5_4.getName().toString());
            }
        }

        private boolean hasLabel(int n) {
            int n2;
            String string = this.lines.get(n).toString();
            CharSequence charSequence = WLAParser.parseLabel(string);
            int n3 = n2 = string.length() > charSequence.length() && string.charAt(charSequence.length()) == ':' ? charSequence.length() : -1;
            return n2 > 0 && Character.isJavaIdentifierPart(string.charAt(n2 - 1)) || charSequence.length() > 0 && "+-".indexOf(charSequence.charAt(0)) >= 0;
        }

        public int findSection(assembler.Section section) {
            if (this.romBankMap == null) {
                return -1;
            }
            if (this.sectionProvider != null) {
                int n = this.sectionProvider.getSectionAddress(section.getName().toString());
                return n < this.memory.length ? n : -1;
            }
            int n = this.adjustRGBDSsectionSize(section);
            if (section.getMode() == Section.Mode.SUPERFREE) {
                int n2 = this.romBankMap.getNumberOfROMBanks();
                int n3 = 0;
                Z80SourceLine z80SourceLine = null;
                int n4 = this.indexOfLineWithSize(section);
                while (n4 >= 0 && (z80SourceLine == null || z80SourceLine.getFirstByte() < 0)) {
                    if (z80SourceLine != null) {
                        n3 += z80SourceLine.getSize();
                    }
                    z80SourceLine = this.parseResult.getLines().get(n4);
                    n4 = this.indexOfLineWithSize(section, n4 + 1);
                }
                if (z80SourceLine == null) {
                    return -1;
                }
                n4 = z80SourceLine.getFirstByte();
                if (n4 < 0) {
                    return -1;
                }
                int n5 = -1;
                int n6 = n3;
                int n7 = this.getLengthOfCommonPrefix(section, -1);
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = Math.max(n7, this.getLengthOfCommonPrefix(section, n8));
                    int n10 = this.romBankMap.getBankAddress(n8);
                    int n11 = n10 + this.romBankMap.getBankSize(n8);
                    int n12 = Math.max(n6, section.getEnd() - section.getBegin() < 10 ? n9 : Math.max(3, n9));
                    int n13 = n10;
                    int n14 = 0;
                    int n15 = this.mapped.nextClearBit(n10);
                    while (n15 + section.getSize() <= n11 && n15 < this.memory.length) {
                        n13 = n15;
                        if ((n14 -= n15 - n13) <= 0) {
                            n14 = this.mapped.nextSetBit(n15) - n15 & Integer.MAX_VALUE;
                        }
                        if (n14 < n) {
                            n15 += n14 - 1;
                        } else if (z80SourceLine.startsWith(this.memory, n15 + n3)) {
                            int n16 = this.getLengthOfMatch(section, n15, n12);
                            int n17 = n15;
                            int n18 = n5;
                            while (n16 > n6) {
                                n12 = n6 = n16;
                                n16 = this.getLengthOfMatch(section, n18, n6);
                                if (n6 >= n16) {
                                    n5 = n17;
                                    continue;
                                }
                                int n19 = n17;
                                n17 = n18;
                                n18 = n19;
                            }
                        }
                        n15 = this.mapped.nextClearBit(n15 + 1);
                    }
                    ++n8;
                }
                return n5;
            }
            int n20 = this.getLengthOfCommonPrefix(section);
            int n21 = -1;
            int n22 = section.getEnd() - section.getBegin() < 10 ? n20 : Math.max(3, n20);
            int n23 = 0;
            Z80SourceLine z80SourceLine = null;
            int n24 = this.indexOfLineWithSize(section);
            while (n24 >= 0 && (z80SourceLine == null || z80SourceLine.getFirstByte() < 0)) {
                if (z80SourceLine != null) {
                    n23 += z80SourceLine.getSize();
                }
                z80SourceLine = this.parseResult.getLines().get(n24);
                n24 = this.indexOfLineWithSize(section, n24 + 1);
            }
            if (z80SourceLine == null) {
                return -1;
            }
            n24 = z80SourceLine.getFirstByte();
            if (n24 < 0) {
                return -1;
            }
            int n25 = this.romBankMap.getBankAddress(section.getBank());
            int n26 = n25 + this.romBankMap.getBankSize(section.getBank());
            int n27 = n25;
            int n28 = 0;
            int n29 = this.mapped.nextClearBit(n25);
            while (n29 + section.getSize() <= n26 && n29 < this.memory.length) {
                n27 = n29;
                if ((n28 -= n29 - n27) <= 0) {
                    n28 = this.mapped.nextSetBit(n29) - n29 & Integer.MAX_VALUE;
                }
                if (n28 < n) {
                    n29 += n28 - 1;
                } else if (z80SourceLine.startsWith(this.memory, n29 + n23)) {
                    int n30 = this.getLengthOfMatch(section, n29, n22);
                    int n31 = n29;
                    int n32 = n21;
                    while (n30 > n22) {
                        n22 = n30;
                        if (n22 >= (n30 = this.getLengthOfMatch(section, n32, n22))) {
                            n21 = n31;
                            continue;
                        }
                        int n33 = n31;
                        n31 = n32;
                        n32 = n33;
                    }
                }
                n29 = this.mapped.nextClearBit(n29 + 1);
            }
            return n21;
        }

        private int getLengthOfMatch(assembler.Section section, int n, int n2) {
            if (n < 0) {
                return 0;
            }
            int n3 = 0;
            int n4 = -1;
            while (n3 <= n2 && n < this.memory.length) {
                Z80Instruction z80Instruction;
                Z80SourceLine z80SourceLine;
                Z80SourceLine z80SourceLine2 = z80SourceLine = (n4 = this.indexOfLineWithSize(section, n4 + 1)) >= 0 ? this.parseResult.getLines().get(n4) : null;
                if (z80SourceLine == null || !z80SourceLine.startsWith(this.memory, n)) break;
                if (z80SourceLine.getInstruction() != null && (z80Instruction = instance.getInstruction(this.memory, n)) != null && z80Instruction.getSize() != z80SourceLine.getSize()) {
                    if (!(z80Instruction instanceof LR35902Instruction) || (z80Instruction.getOpCode() != 240 || z80SourceLine.getInstruction().getOpCode() != 250) && (z80Instruction.getOpCode() != 224 || z80SourceLine.getInstruction().getOpCode() != 234)) break;
                    n3 += z80SourceLine.getPrefixLength();
                    n += z80Instruction.getSize();
                    continue;
                }
                n3 += z80SourceLine.getPrefixLength();
                n += z80SourceLine.getSize();
            }
            return n3;
        }

        private int indexOfLineWithSize(assembler.Section section) {
            return this.indexOfLineWithSize(section, 0);
        }

        private int indexOfLineWithSize(assembler.Section section, int n) {
            List<Z80SourceLine> list = this.parseResult.getLines();
            int n2 = Math.max(section.getBegin(), n);
            while (n2 < section.getEnd()) {
                Z80SourceLine z80SourceLine = list.get(n2);
                if (z80SourceLine.getSize() > 0) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private int getLengthOfCommonPrefix(assembler.Section section) {
            return Math.max(this.getLengthOfCommonPrefix(section, -1), this.getLengthOfCommonPrefix(section, section.getBank()));
        }

        private int getLengthOfCommonPrefix(assembler.Section section, int n) {
            return this.getLengthOfCommonPrefix(section, this.sectionsByBank.get(n));
        }

        private int getLengthOfCommonPrefix(assembler.Section section, List<assembler.Section> list) {
            if (section == null || list == null) {
                return 0;
            }
            List<Z80SourceLine> list2 = this.parseResult.getLines();
            int n = this.indexOfLineWithSize(section);
            int n2 = 0;
            if (n >= 0) {
                for (assembler.Section section2 : list) {
                    if (section2 == section || this.sectionMapped.contains(section2.getName().toString())) continue;
                    int n3 = 0;
                    int n4 = n;
                    int n5 = this.indexOfLineWithSize(section2);
                    while (n4 >= 0 && n5 >= 0) {
                        Z80SourceLine z80SourceLine;
                        Z80SourceLine z80SourceLine2 = list2.get(n4);
                        if (!z80SourceLine2.matchesPrefix(z80SourceLine = list2.get(n5))) break;
                        ++n3;
                        n4 = this.indexOfLineWithSize(section, n4 + 1);
                        n5 = this.indexOfLineWithSize(section2, n5 + 1);
                    }
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
            }
            return n2;
        }

        private int adjustRGBDSsectionSize(assembler.Section section) {
            int n = section.getSize();
            if (!(instance instanceof LR35902Disassembler)) {
                return n;
            }
            List<Z80SourceLine> list = this.parseResult.getLines();
            int n2 = section.getBegin();
            while (n2 < section.getEnd()) {
                Z80SourceLine z80SourceLine = list.get(n2);
                Z80Instruction z80Instruction = z80SourceLine.getInstruction();
                if (z80Instruction != null && (z80Instruction.getOpCode() & 0xEF) == 234) {
                    --n;
                }
                ++n2;
            }
            if (n < 0) {
                System.err.println("Reduced size of section " + section.getName() + " from " + section.getSize() + " to " + n);
                return section.getSize();
            }
            return n;
        }

        public void putUndeterminedRept(int n, List<SourceLine> list) {
            this.undeterminedRepts.put(n, list);
        }

        public void resolveUndeterminedRepts() {
            for (Map.Entry<Integer, List<SourceLine>> entry : this.undeterminedRepts.entrySet()) {
                this.lines.addAll(entry.getKey(), (Collection<SourceLine>)entry.getValue());
            }
        }
    }

    public static class PortReference
    extends Reference {
        private final boolean includeInput;
        private final boolean includeOutput;

        PortReference(int n, boolean bl, boolean bl2) {
            super(n);
            this.includeInput = bl;
            this.includeOutput = bl2;
        }

        @Override
        public int getLabelAddress(LabelProvider labelProvider) {
            return -3;
        }

        @Override
        public Collection<Reference> getChildren(LabelProvider labelProvider) {
            TreeSet<Reference> treeSet = new TreeSet<Reference>();
            IntHashSet intHashSet = portSeen.get(this.address);
            if (intHashSet != null) {
                int[] nArray = intHashSet.keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    if (Z80Disassembler.isCode(n3) && (this.includeInput && this.includeOutput || this.includeInput && Z80Disassembler.isPortRead(this.address, n3) || this.includeOutput && !Z80Disassembler.isPortRead(this.address, n3))) {
                        treeSet.add(new Reference(n3));
                    }
                    ++n2;
                }
            }
            return Collections.unmodifiableSet(treeSet);
        }
    }

    static final class RamCodeWrite {
        private final int address;
        private final int romAddress;
        private final int fromAddress;
        private final State state;

        public RamCodeWrite(int n, int n2, int n3, State state) {
            this.address = n;
            this.romAddress = n2;
            this.fromAddress = n3;
            this.state = Z80Disassembler.unmodifiableState(state);
        }

        public int getAddress() {
            return this.address;
        }

        public int getRomAddress() {
            return this.romAddress;
        }

        public int getFromAddress() {
            return this.fromAddress;
        }

        public State getState() {
            return this.state;
        }
    }

    public static class RamReference
    extends Reference {
        RamReference(int n) {
            super(n);
        }

        @Override
        public int getLabelAddress(LabelProvider labelProvider) {
            return -1;
        }

        @Override
        public Collection<Reference> getChildren(LabelProvider labelProvider) {
            TreeSet<Reference> treeSet = new TreeSet<Reference>();
            IntHashSet intHashSet = ramSeen.get(this.address);
            if (intHashSet != null) {
                int[] nArray = intHashSet.keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    treeSet.add(new Reference(n3));
                    ++n2;
                }
            }
            return Collections.unmodifiableSet(treeSet);
        }
    }

    public static class Reference
    implements Comparable<Reference> {
        protected final int address;

        protected Reference(int n) {
            this.address = n;
        }

        public int getAddress() {
            return this.address;
        }

        public boolean isCode() {
            return Z80Disassembler.isCode(this.address);
        }

        public int getLabelAddress(LabelProvider labelProvider) {
            int n = this.address;
            while (n >= 0 && (!Z80Disassembler.hasLabel(n) || seen.get(n) != null && seen.get(n).size() == 1 && seen.get(n).contains(this.address)) && !Z80Disassembler.hasDataLabel(n) || Z80Disassembler.isSubInstructionByte(n) || labelProvider.getLabels(n).isEmpty()) {
                --n;
            }
            return n;
        }

        public Collection<Reference> getChildren(LabelProvider labelProvider) {
            int n;
            IntHashSet intHashSet;
            TreeSet<Reference> treeSet = new TreeSet<Reference>();
            if (Z80Disassembler.isCode(this.address)) {
                intHashSet = seen.get(this.address);
                if (intHashSet == null && (n = this.getLabelAddress(labelProvider)) >= 0) {
                    intHashSet = seen.get(n);
                }
            } else {
                intHashSet = dataSeen.get(this.address);
                if (intHashSet == null && (n = this.getLabelAddress(labelProvider)) >= 0) {
                    intHashSet = dataSeen.get(n);
                }
            }
            if (intHashSet != null) {
                int[] nArray = intHashSet.keys();
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    n = nArray[n3];
                    treeSet.add(new Reference(n));
                    ++n3;
                }
            }
            return Collections.unmodifiableSet(treeSet);
        }

        @Override
        public int compareTo(Reference reference) {
            return Integer.compare(this.address, reference.address);
        }
    }

    protected static class Register {
        Value value = Value.newUnknownValue(255);

        public Register() {
        }

        public void setValue(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        public Value getValue() {
            return this.value;
        }

        public Register(Register register) {
            this.value = register.value;
        }

        void ld(Value value) {
            this.setValue(value);
        }

        void ld(Register register) {
            this.value = register.value;
            if (this.value.max < this.value.min) {
                this.value = this.value.newValue(0, 255);
            }
        }

        void add(Register register) {
            this.value = this.value.add(register.value);
            this.ensureBoundaries();
        }

        void add(int n) {
            this.value = this.value.add(n);
            this.ensureBoundaries();
        }

        void adc(Address address, Value value) {
            this.value = this.value.adc(value).newSource(address);
            this.ensureBoundaries();
        }

        void adc(Register register) {
            this.value = this.value.adc(register.value);
            this.ensureBoundaries();
        }

        void adc(int n) {
            this.value = this.value.adc(n);
            this.ensureBoundaries();
        }

        void add(Address address, Value value) {
            this.value = this.value.add(value).newSource(address);
            this.ensureBoundaries();
        }

        void sub(Register register) {
            this.value = this.value.sub(register.value);
            if (this.value.min < 0) {
                this.value = this.value.newValue(0, 255);
            }
            this.ensureBoundaries();
        }

        void sub(int n) {
            this.value = this.value.sub(n);
            if (this.value.min < 0) {
                this.value = this.value.newValue(0, 255);
            }
            this.ensureBoundaries();
        }

        void sub(Address address, Value value) {
            this.value = this.value.sub(value).newSource(address);
            this.ensureBoundaries();
        }

        void inc(boolean bl) {
            this.value = this.value.inc(bl);
            this.ensureBoundaries();
        }

        void dec() {
            this.value = this.value.dec();
            this.ensureBoundaries();
        }

        void and(Register register) {
            this.value = this.value.and(register.value);
            this.ensureBoundaries();
        }

        void and(int n) {
            this.value = this.value.and(n);
        }

        void and(Address address, Value value) {
            this.value = this.value.and(value).newSource(address);
        }

        void xor(Register register) {
            this.value = register == this && this.value.source == null ? Value.ZERO : this.value.xor(register.value);
        }

        void xor(int n) {
            this.value = this.value.xor(n);
        }

        void xor(Address address, Value value) {
            this.value = this.value.xor(value).newSource(address);
        }

        void or(Register register) {
            this.value = this.value.or(register.value);
        }

        void or(int n) {
            this.value = this.value.or(n);
        }

        void or(Address address, Value value) {
            this.value = this.value.or(value).newSource(address);
        }

        void cpl() {
            this.value = this.value.newValue(this.value.getMax() & 0xFF ^ 0xFF, this.value.getMin() & 0xFF ^ 0xFF);
        }

        void rrca() {
            this.value = this.value.newValue((this.value.getMin() & 1) << 7 | this.value.getMin() >> 1, (this.value.getMax() & 1) << 7 | this.value.getMax() >> 1);
        }

        void res(int n) {
            this.value = this.value.resBit(n);
        }

        void set(int n) {
            this.value = this.value.setBit(n);
        }

        void neg() {
            this.value = this.value.neg().and(255);
            if (this.value.max < this.value.min) {
                this.value = this.value.newValue(0, 255);
            }
        }

        void rlc() {
            this.value = this.value.rlc().and(255);
        }

        void rrc() {
            this.value = this.value.rrc();
        }

        void rl() {
            this.value = this.value.rl().and(255);
        }

        void rr() {
            this.value = this.value.rr();
        }

        void sla() {
            this.value = this.value.sla().and(255);
        }

        void sra() {
            this.value = this.value.sra();
        }

        void sll() {
            this.value = this.value.sll().and(255);
        }

        void srl() {
            this.value = this.value.srl();
        }

        void swap() {
            this.value = this.value.swap();
        }

        void setSource(Address address) {
            this.value = this.value.newSource(address);
        }

        Address getSource() {
            return this.value.getSource();
        }

        void ensureBoundaries() {
            this.value = this.value.bound(0, 255);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    protected static class RegisterPair {
        final Register lo;
        final Register hi;
        Value value;

        public RegisterPair(Register register, Register register2) {
            this(register, register2, null);
        }

        public RegisterPair(Register register, Register register2, Value value) {
            this.lo = register2;
            this.hi = register;
            this.value = value;
        }

        public void ld(int n, int n2, boolean bl) {
            this.lo.ld(new Value(n & 0xFF, new Address(n2, !bl, bl, false, false)));
            this.hi.ld(new Value(n >> 8, new Address(n2 + 1, !bl, bl, false, false)));
        }

        public void add(RegisterPair registerPair) {
            if (this.lo.getValue().isUnique() && this.hi.getValue().isUnique()) {
                this.lo.setValue(this.lo.getValue().newMultiplier(registerPair.lo.getValue().getMultiplier()));
            }
            Address address = this.getSource();
            Address address2 = registerPair.getSource();
            if (address2 != null && (address == null || address.isRamAddress() || !address2.isRamAddress() && this.getValue().getMin() < registerPair.getValue().getMin())) {
                this.lo.setValue(registerPair.lo.getValue().add(this.lo.getValue()));
                this.hi.setValue(registerPair.hi.getValue().add(this.hi.getValue()));
            } else {
                this.lo.setValue(this.lo.getValue().add(registerPair.lo.getValue()));
                this.hi.setValue(this.hi.getValue().add(registerPair.hi.getValue()));
            }
            int n = this.lo.getValue().getMin();
            int n2 = this.lo.getValue().getMax();
            this.hi.setValue(this.hi.getValue().newValue(this.hi.getValue().getMin() + (n >> 8), this.hi.getValue().getMax() + (n2 >> 8)));
            if (n == n2 || registerPair.lo.getValue().isUnique() && registerPair.hi.getValue().isUnique()) {
                this.lo.setValue(this.lo.getValue().newValue(n &= 0xFF, n2 &= 0xFF));
            }
            if (this.hi.getValue().min >= 256 && this.hi.getValue().max >= 256) {
                if (this.hi.getValue().isUnique()) {
                    this.hi.setValue(this.hi.getValue().newValue(this.hi.getValue().min - 256, this.hi.getValue().max - 256));
                } else {
                    this.hi.setValue(this.hi.getValue().newValue(0, 255));
                }
            }
            this.ensureBoundaries();
        }

        public void addSP() {
            this.lo.setValue(Value.newUnknownValue(255));
            this.hi.setValue(Value.newUnknownValue(255));
        }

        public void sub(RegisterPair registerPair) {
            this.lo.setValue(this.lo.getValue().sub(registerPair.lo.getValue()));
            this.hi.setValue(this.hi.getValue().sub(registerPair.hi.getValue()));
            this.hi.setValue(this.hi.getValue().newValue(this.hi.getValue().getMin() + (this.lo.getValue().getMin() >> 8), this.hi.getValue().getMax() + (this.lo.getValue().getMax() >> 8)));
            this.ensureBoundaries();
        }

        public void inc() {
            Address address = this.getSource();
            if (address != null && address.isRomAddress() && !address.isUnique()) {
                this.value = Value.newCalculatedIncValue(this.getValue());
            } else {
                this.lo.setValue(this.lo.getValue().inc());
                if (this.lo.getValue().max >= 256 && this.lo.getValue().min == this.lo.getValue().max) {
                    this.hi.setValue(this.hi.getValue().inc());
                    this.lo.setValue(this.lo.getValue().newValue(0, 0));
                }
                this.ensureBoundaries();
            }
        }

        public void dec() {
            Address address = this.getSource();
            if (address != null && address.isRomAddress() && !address.isUnique()) {
                this.value = Value.newCalculatedDecValue(this.getValue());
            } else if (this.lo.getValue().min == 0) {
                boolean bl = this.lo.getValue().max == 0;
                int n = this.hi.getValue().getMin() - 1 & 0xFF;
                int n2 = this.hi.getValue().getMax();
                int n3 = 0;
                int n4 = this.lo.getValue().max - 1 & 0xFF;
                if (bl) {
                    n3 = 255;
                    n2 = n2 - 1 & 0xFF;
                } else if (n2 <= n) {
                    n = 0;
                    n2 = 255;
                    n4 = 255;
                }
                this.hi.setValue(this.hi.getValue().newValue(n, n2));
                this.lo.setValue(this.lo.getValue().newValue(n3, n4));
            } else {
                this.lo.setValue(this.lo.getValue().dec());
            }
        }

        public void ex(RegisterPair registerPair) {
            Value value = this.hi.getValue();
            this.hi.setValue(registerPair.hi.getValue());
            registerPair.hi.setValue(value);
            value = this.lo.getValue();
            this.lo.setValue(registerPair.lo.getValue());
            registerPair.lo.setValue(value);
            value = this.value;
            this.value = registerPair.value;
            registerPair.value = value;
        }

        public void ensureBoundaries() {
            this.lo.ensureBoundaries();
            this.hi.ensureBoundaries();
        }

        public Value getValue() {
            if (this.value != null && this.getMinValue() == this.value.getMin() && this.getMaxValue() == this.value.getMax() && this.getSource() == this.value.getSource() && this.lo.getValue().getMultiplier() == this.value.getMultiplier()) {
                return this.value;
            }
            this.value = this.lo.getValue().newValue(this.getMinValue(), this.getMaxValue());
            return this.value;
        }

        public int getMinValue() {
            return this.hi.getValue().getMin() << 8 | this.lo.getValue().getMin() & 0xFF;
        }

        public int getMaxValue() {
            return this.hi.getValue().getMax() << 8 | this.lo.getValue().getMax() & 0xFF;
        }

        public boolean isHighValueUnique() {
            return this.hi.getValue().isUnique();
        }

        public boolean isRAMsource() {
            Address address = this.getSource();
            return address != null && address.isRamAddress();
        }

        public boolean isROMsource() {
            Address address = this.getSource();
            return address != null && !address.isRamAddress();
        }

        public boolean hasMultipleSources() {
            Address address = this.getSource();
            return address != null && address.getMax() > address.getMin();
        }

        public Address getSource() {
            if (this.hi.getSource() == null || this.lo.getSource() == null) {
                return null;
            }
            int n = this.hi.getSource().getMin() + this.hi.getSource().getOffset() - (this.lo.getSource().getMin() + this.lo.getSource().getOffset());
            if (n == 1 || n == 0 && this.lo.getSource().getMax() - this.lo.getSource().getMin() < 256) {
                return this.lo.getSource();
            }
            return null;
        }

        public Address getHighSource() {
            return this.hi.getSource();
        }

        public String toString() {
            if (this.getSource() != null) {
                return this.getValue().toString();
            }
            return "(" + this.hi + ", " + this.lo + ")";
        }
    }

    public static class SourceLine {
        private final int address;
        private final int size;
        private final String line;
        private final Z80Instruction instruction;
        public static final SourceLine EMPTY_LINE = new SourceLine();
        public static final SourceLine DISASSEMBLING = new SourceLine("Disassembling...");
        public static final SourceLine DISASSEMBLY_HEAD_COMMENT = new SourceLine("; This disassembly was created using Emulicious (https://www.emulicious.net)");
        public static final SourceLine PORTS_HEAD_COMMENT = new SourceLine("; Ports");

        SourceLine(int n, int n2, String string, Z80Instruction z80Instruction) {
            if (n < 0 && n2 > 0) {
                throw new IllegalArgumentException("If address < 0 size must be 0 but was " + n2 + " in " + string);
            }
            if (n >= 0 && n2 <= 0) {
                throw new IllegalArgumentException("Size must not be <= 0 for any line with an address but was " + n2 + " in " + string);
            }
            if (n2 > 32768) {
                throw new IllegalArgumentException("Size too large (" + n2 + ") in line: " + string);
            }
            this.address = n;
            this.line = string;
            this.instruction = z80Instruction;
            this.size = n2;
        }

        SourceLine(int n, String string, Z80Instruction z80Instruction) {
            this(n, z80Instruction.getSize(), string, z80Instruction);
        }

        SourceLine(int n, int n2, String string) {
            this(n, n2, string, null);
        }

        public SourceLine(String string) {
            this(-1, 0, string);
        }

        private SourceLine() {
            this("");
        }

        public int getAddress() {
            return this.address;
        }

        public int getSize() {
            return this.size;
        }

        public Z80Instruction getInstruction() {
            return this.instruction;
        }

        public String toString() {
            return this.line;
        }
    }

    public static class SramReference
    extends Reference {
        SramReference(int n) {
            super(n);
        }

        @Override
        public int getLabelAddress(LabelProvider labelProvider) {
            return -2;
        }

        @Override
        public Collection<Reference> getChildren(LabelProvider labelProvider) {
            TreeSet<Reference> treeSet = new TreeSet<Reference>();
            IntHashSet intHashSet = sramSeen.get(this.address);
            if (intHashSet != null) {
                int[] nArray = intHashSet.keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    treeSet.add(new Reference(n3));
                    ++n2;
                }
            }
            return Collections.unmodifiableSet(treeSet);
        }
    }

    protected static class State {
        private int pc;
        private RegisterPair regPairPC;
        private final Register[] regs = new Register[12];
        private final Register[] regsEx = new Register[8];
        private final RegisterPair[] regPairs = new RegisterPair[this.regs.length / 2];
        private final RegisterPair[] regPairsEx = new RegisterPair[this.regsEx.length / 2];
        private Value bank0;
        private Value bank1;
        private Value bank2;
        private Value bank3;
        private boolean sramEnabled;
        private Value sramBank;
        private LinkedList<Value> stack = new LinkedList();
        private LinkedList<Value> savedStack;
        private int spOffset;
        private int savedSpOffset;
        private final HashMapStack<Value> ram;
        private final HashMapStack<Value> sram;
        private int addressSavedStack;

        public State() {
            Register register;
            Register register2;
            int n = 0;
            while (n < this.regs.length) {
                this.regs[n] = new Register();
                if ((n & 1) != 0) {
                    if (n >> 1 == 3) {
                        register2 = this.regs[n];
                        register = this.regs[n - 1];
                    } else {
                        register2 = this.regs[n - 1];
                        register = this.regs[n];
                    }
                    this.regPairs[n >> 1] = new RegisterPair(register2, register);
                }
                ++n;
            }
            n = 0;
            while (n < this.regsEx.length) {
                this.regsEx[n] = new Register();
                if ((n & 1) != 0) {
                    if (n >> 1 == 3) {
                        register2 = this.regsEx[n];
                        register = this.regsEx[n - 1];
                    } else {
                        register2 = this.regsEx[n - 1];
                        register = this.regsEx[n];
                    }
                    this.regPairsEx[n >> 1] = new RegisterPair(register2, register);
                }
                ++n;
            }
            this.bank0 = Value.ZERO;
            this.bank1 = code != null && code.length > dummyCartridge.getBankSize() ? Value.ONE : Value.ZERO;
            this.bank2 = code != null && code.length > dummyCartridge.getBankSize() * 2 ? Value.TWO : Value.ZERO;
            this.bank3 = Value.ZERO;
            this.sramBank = Value.ZERO;
            this.ram = new HashMapStack();
            this.sram = new HashMapStack();
        }

        public State(State state, boolean bl) {
            this.pc = state.pc;
            this.COPY_REGISTERS(state);
            this.bank0 = state.bank0;
            this.bank1 = state.bank1;
            this.bank2 = state.bank2;
            this.bank3 = state.bank3;
            this.sramEnabled = state.sramEnabled;
            this.sramBank = state.sramBank;
            if (bl) {
                this.stack.addAll(state.stack);
            }
            this.spOffset = state.spOffset;
            this.ram = new HashMapStack<Value>(state.ram);
            this.sram = new HashMapStack<Value>(state.sram);
        }

        public State(State state) {
            this(state, true);
        }

        public Value getBank0() {
            return this.bank0;
        }

        public void setBank0(Value value) {
            this.bank0 = value;
        }

        public Value getBank1() {
            return this.bank1;
        }

        public void setBank1(Value value) {
            this.bank1 = value;
        }

        public Value getBank2() {
            return this.bank2;
        }

        public void setBank2(Value value) {
            this.bank2 = value;
        }

        public Value getBank3() {
            return this.bank3;
        }

        public void setBank3(Value value) {
            this.bank3 = value;
        }

        public boolean isSRAMenabled() {
            return this.sramEnabled;
        }

        public void setSRAMenabled(boolean bl) {
            this.sramEnabled = bl;
        }

        public Value getSRAMbank() {
            return this.sramBank;
        }

        public void setSRAMbank(Value value) {
            this.sramBank = value;
        }

        private final void COPY_REGISTERS(State state) {
            Register register;
            Register register2;
            int n = 0;
            while (n < state.regs.length) {
                this.regs[n] = new Register(state.regs[n]);
                if ((n & 1) != 0) {
                    if (n >> 1 == 3) {
                        register2 = this.regs[n];
                        register = this.regs[n - 1];
                    } else {
                        register2 = this.regs[n - 1];
                        register = this.regs[n];
                    }
                    this.regPairs[n >> 1] = new RegisterPair(register2, register, state.regPairs[n >> 1].value);
                }
                ++n;
            }
            this.regs[6].setValue(Value.newUnknownValue(255));
            n = 0;
            while (n < state.regsEx.length) {
                this.regsEx[n] = new Register(state.regsEx[n]);
                if ((n & 1) != 0) {
                    if (n >> 1 == 3) {
                        register2 = this.regsEx[n];
                        register = this.regsEx[n - 1];
                    } else {
                        register2 = this.regsEx[n - 1];
                        register = this.regsEx[n];
                    }
                    this.regPairsEx[n >> 1] = new RegisterPair(register2, register, state.regPairsEx[n >> 1].value);
                }
                ++n;
            }
            this.regsEx[6].setValue(Value.newUnknownValue(255));
        }

        public void exx() {
            int n = 0;
            while (n < 3) {
                this.regPairs[n].ex(this.regPairsEx[n]);
                ++n;
            }
        }

        public void exAF() {
            this.regPairs[3].ex(this.regPairsEx[3]);
        }

        public void exStackTopHL(int n) {
            Value value;
            Value value2;
            Value value3;
            if (!this.stack.isEmpty()) {
                value3 = this.stack.pop();
                value2 = this.stack.pop();
                value = this.stack.pop();
            } else {
                value3 = null;
                value2 = Value.newUnknownValue(255);
                value = Value.newUnknownValue(255);
            }
            this.stack.push(this.regPairs[n].hi.getValue());
            this.stack.push(this.regPairs[n].lo.getValue());
            this.stack.push(this.regPairs[n].value);
            this.regPairs[n].value = value3;
            this.regPairs[n].lo.setValue(value2);
            this.regPairs[n].hi.setValue(value);
        }

        public final int getPC() {
            return this.pc;
        }

        public void setPC(int n) {
            if (n >= 65536) {
                throw new IllegalArgumentException("PC is only 16 bit wide. " + Integer.toHexString(n) + " doesn't fit into it.");
            }
            this.pc = n;
        }

        public int getSpOffset() {
            return this.spOffset;
        }

        public void setSpOffset(int n) {
            this.spOffset = n;
        }

        public final int getAddress(RamRomMap ramRomMap) {
            return Z80Disassembler.RESOLVE_ADDRESS(this.getPC(), ramRomMap, this);
        }

        public final int getSlot() {
            if (msx && this.getPC() >= 16384) {
                return Z80Disassembler.getRomBank(this.getPC() - 16384);
            }
            return Z80Disassembler.getRomBank(this.getPC());
        }

        public void pushPC() {
            if (this.regPairPC == null) {
                this.regPairPC = new RegisterPair(new Register(), new Register());
            }
            this.regPairPC.ld(this.pc, this.pc - 1, false);
            this.stack.push(this.regPairPC.hi.value);
            this.stack.push(this.regPairPC.lo.value);
            this.stack.push(this.regPairPC.value);
            this.spOffset -= 2;
        }

        public Register[] getRegs() {
            return this.regs;
        }

        public RegisterPair[] getRegPairs() {
            return this.regPairs;
        }

        public LinkedList<Value> getStack() {
            return this.stack;
        }

        public void addToSP(int n) {
            while (n > 0) {
                if (this.stack.isEmpty()) {
                    return;
                }
                n -= 2;
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
            }
            while (n < 0) {
                this.stack.push(Value.newUnknownValue(255));
                this.stack.push(Value.newUnknownValue(255));
                this.stack.push(null);
                n += 2;
            }
            this.spOffset += n;
        }

        public void saveSP(int n) {
            if (this.savedStack == null) {
                this.savedStack = this.stack;
                this.addressSavedStack = n;
                this.savedSpOffset = this.spOffset;
            }
        }

        public void ldSP(RegisterPair registerPair) {
            if (this.savedStack != null && this.stack != this.savedStack && registerPair.getSource() != null && registerPair.getSource().isUnique() && registerPair.getSource().getMin() == this.addressSavedStack) {
                this.stack = this.savedStack;
                this.spOffset = this.savedSpOffset;
                this.savedStack = null;
            } else {
                this.stack = new LinkedList();
            }
        }

        public void union(Collection<State> collection) {
            if (collection.isEmpty()) {
                return;
            }
            int n = 0;
            while (n < this.regs.length) {
                int n2 = this.regs[n].getValue().min;
                int n3 = this.regs[n].getValue().max;
                for (State state : collection) {
                    if (state.regs[n].getValue().min < n2) {
                        n2 = state.regs[n].getValue().min;
                    }
                    if (state.regs[n].getValue().max <= n3) continue;
                    n3 = state.regs[n].getValue().max;
                }
                this.regs[n].setValue(this.regs[n].getValue().newValue(n2, n3));
                ++n;
            }
            for (State state : collection) {
                this.unionRAM(state);
                this.unionSRAM(state);
            }
        }

        public void union(State state) {
            int n = 0;
            while (n < this.regs.length) {
                int n2 = this.regs[n].getValue().min;
                int n3 = this.regs[n].getValue().max;
                if (state.regs[n].getValue().min < n2) {
                    n2 = state.regs[n].getValue().min;
                }
                if (state.regs[n].getValue().max > n3) {
                    n3 = state.regs[n].getValue().max;
                }
                this.regs[n].setValue(this.regs[n].getValue().newValue(n2, n3));
                ++n;
            }
            this.unionRAM(state);
            this.unionSRAM(state);
        }

        private void unionRAM(State state) {
            for (Map.Entry<Value> entry : state.ram.topEntrySet()) {
                Value value = this.ram.get(entry.getKey());
                Value value2 = value == null ? entry.getValue() : value.newValue(Math.min(value.getMin(), entry.getValue().getMin()), Math.max(value.getMax(), entry.getValue().getMax()));
                this.ram.put(entry.getKey(), value2);
            }
        }

        private void unionSRAM(State state) {
            for (Map.Entry<Value> entry : state.sram.topEntrySet()) {
                Value value = this.sram.get(entry.getKey());
                Value value2 = value == null ? entry.getValue() : value.newValue(Math.min(value.getMin(), entry.getValue().getMin()), Math.max(value.getMax(), entry.getValue().getMax()));
                this.sram.put(entry.getKey(), value2);
            }
        }

        public Value getSRAMvalue(int n) {
            Value value = this.sram.get(instance.mapSRAMaddress(n, this.sramBank.getMin()));
            if (value == null) {
                return Value.newUnknownValue(255);
            }
            return value;
        }

        public void setSRAMvalue(int n, Value value) {
            this.sram.put(instance.mapSRAMaddress(n, this.sramBank.getMin()), value);
        }

        public Value getRAMvalue(int n) {
            Value value = this.ram.get(instance.mapRAMaddress(n));
            if (value == null) {
                return Value.newUnknownValue(255);
            }
            return value;
        }

        public void setRAMvalue(int n, Value value) {
            this.ram.put(instance.mapRAMaddress(n), value);
        }

        public void djnz() {
            Value value = this.regs[0].value;
            this.regs[0].value = value.newValue(1, Math.max(1, value.max));
        }

        public int popPC() {
            if (this.stack.isEmpty()) {
                return -1;
            }
            this.stack.pop();
            Value value = this.stack.pop();
            Value value2 = this.stack.pop();
            this.spOffset += 2;
            if (!value.isUnique() || !value2.isUnique()) {
                return -1;
            }
            return value2.getMin() << 8 | value.getMin();
        }

        public void addToPC(int n) {
            this.setPC(this.pc + n);
        }
    }

    static final class Table
    implements Comparable<Table> {
        final int start;
        final int end;
        final Address source;
        final Address indexedBy;
        final State state;
        final HashMap<IntDeque> visitedAddresses;
        final boolean fixedStart;

        private Table(int n, int n2, Address address, Address address2, State state, HashMap<IntDeque> hashMap, boolean bl) {
            if (address == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            if (state == null) {
                throw new IllegalArgumentException("state must not be null");
            }
            this.start = n;
            this.end = n2;
            this.source = address;
            this.indexedBy = address2;
            this.state = Z80Disassembler.unmodifiableState(state);
            this.visitedAddresses = hashMap;
            this.fixedStart = bl;
        }

        public Table(int n, int n2, Address address, Address address2, State state) {
            this(n, n2, address, address2, state, new HashMap<IntDeque>(), false);
        }

        public Table(Table table, int n, int n2, boolean bl) {
            this(n, n2, table.source, table.indexedBy, table.state, new HashMap<IntDeque>(), bl);
            if (!bl && table.fixedStart && n != table.start) {
                throw new IllegalArgumentException();
            }
        }

        public Table(Table table, int n, int n2) {
            this(table, n, n2, table.fixedStart);
        }

        public Table(Table table, State state) {
            this(table.start, table.end, table.source, table.indexedBy, state);
        }

        @Override
        public int compareTo(Table table) {
            if (this.end - this.start - (table.end - table.start) == 0) {
                return this.start - table.start;
            }
            return this.end - this.start - (table.end - table.start);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.end;
            n = 31 * n + this.start;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Table)) {
                return false;
            }
            Table table = (Table)object;
            if (this.end != table.end) {
                return false;
            }
            return this.start == table.start;
        }

        public String toString() {
            return "$" + Integer.toHexString(this.start).toUpperCase() + " (" + (this.end - this.start) / 2 + " entries, indexed by " + (this.indexedBy != null && this.indexedBy.isRamAddress() ? String.format("$%04X", this.indexedBy.getMin()) : "unknown") + ")";
        }
    }

    protected static final class UnmodifiableState
    extends State {
        public UnmodifiableState(State state) {
            super(state);
        }

        @Override
        public void setBank0(Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBank1(Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBank2(Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBank3(Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSRAMenabled(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void exx() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void exAF() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void exStackTopHL(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPC(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pushPC() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addToPC(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addToSP(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void saveSP(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ldSP(RegisterPair registerPair) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void union(Collection<State> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void union(State state) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRAMvalue(int n, Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void djnz() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int popPC() {
            throw new UnsupportedOperationException();
        }
    }
}

