/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import assembler.HexStrings;
import assembler.LR35902Instruction;
import assembler.Z80Instruction;
import components.cartridge.GBCartridge;
import components.cpu.CpuInfo;
import components.cpu.LR35902Info;
import disassembler.Symbols;
import disassembler.Value;
import disassembler.Z80Disassembler;
import disassembler.dialects.RgbdsDialect;
import java.util.BitSet;
import java.util.List;
import system.RamRomMap;
import util.deque.IntDeque;
import util.map.HashMap;
import util.map.Map;

public class LR35902Disassembler
extends Z80Disassembler {
    private static final int[] ENTRY_POINTS = new int[]{256, 64, 72, 80, 88, 96};

    @Override
    protected Z80Instruction getInstruction(int[] nArray, int n) {
        Z80Instruction z80Instruction = super.getInstruction(nArray, n);
        if (z80Instruction instanceof LR35902Instruction) {
            return z80Instruction;
        }
        return LR35902Instruction.parse(nArray, n);
    }

    public static Z80Disassembler createInstance() {
        msx = false;
        if (instance == null) {
            instance = new LR35902Disassembler();
            return instance;
        }
        if (!instance.getClass().equals(LR35902Disassembler.class)) {
            LR35902Disassembler.cleanUp();
            instance = null;
            return LR35902Disassembler.createInstance();
        }
        return instance;
    }

    @Override
    protected CpuInfo getCpuInfo() {
        return LR35902Info.getInstance();
    }

    @Override
    protected int[] getEntryPoints() {
        return ENTRY_POINTS;
    }

    @Override
    protected int getMaxEntryPoint() {
        return ENTRY_POINTS[0];
    }

    @Override
    protected boolean allowRST0H() {
        return true;
    }

    @Override
    protected boolean allowRST38H() {
        return true;
    }

    @Override
    protected boolean hasBank2() {
        return false;
    }

    @Override
    protected int getDefaultSlot() {
        return 1;
    }

    @Override
    protected boolean isRAMaddress(int n) {
        return n >= 49152 && n < 65024 || n >= 65408 && n < 65535;
    }

    @Override
    protected int mapRAMaddress(int n) {
        if (n >= 65408) {
            return n;
        }
        return n & 0x1FFF;
    }

    @Override
    protected boolean isMirrorAddress(int n) {
        return n < 65024 && super.isMirrorAddress(n);
    }

    @Override
    protected boolean isROMaddress(int n, Z80Disassembler.State state) {
        return n >= 0 && n < 32768;
    }

    @Override
    protected boolean isROMaddress(int n, boolean bl) {
        return n >= 0 && n < 32768;
    }

    @Override
    protected boolean isPortAddress(int n) {
        return n >= 65280 && n < 65408 || n == 65535;
    }

    @Override
    protected int analyzeInstruction(Z80Disassembler.DisassemblerState disassemblerState, Z80Instruction z80Instruction, int n, Z80Instruction z80Instruction2, Z80Disassembler.State state, int n2, int[] nArray, IntDeque intDeque, int n3) {
        if (!(n != 64 && n != 256 || z80Instruction.isJump() || z80Instruction.isRet() || z80Instruction.isConditional())) {
            shouldReturn = false;
            return n;
        }
        int[] nArray2 = disassemblerState.memory;
        RamRomMap ramRomMap = disassemblerState.ramRomMap;
        Z80Disassembler.Register[] registerArray = state.getRegs();
        Z80Disassembler.RegisterPair[] registerPairArray = state.getRegPairs();
        switch (z80Instruction.getOpCode()) {
            case 8: {
                LR35902Disassembler.LD_nn_SP(z80Instruction, state);
                break;
            }
            case 16: {
                return n + 1;
            }
            case 34: {
                LR35902Disassembler.WRITE_BYTE(nArray2, ramRomMap, registerPairArray[2].getValue(), registerArray[7].getValue(), state);
                registerPairArray[2].inc();
                break;
            }
            case 42: {
                registerArray[7].setValue(LR35902Disassembler.READ_BYTE(nArray2, ramRomMap, registerPairArray[2].getValue(), state));
                registerPairArray[2].inc();
                break;
            }
            case 50: {
                LR35902Disassembler.WRITE_BYTE(nArray2, ramRomMap, registerPairArray[2].getValue(), registerArray[7].getValue(), state);
                registerPairArray[2].dec();
                break;
            }
            case 58: {
                registerArray[7].setValue(LR35902Disassembler.READ_BYTE(nArray2, ramRomMap, registerPairArray[2].getValue(), state));
                registerPairArray[2].dec();
                break;
            }
            case 211: {
                break;
            }
            case 217: {
                shouldReturn = Boolean.TRUE;
                return n;
            }
            case 219: {
                break;
            }
            case 221: {
                break;
            }
            case 224: {
                LR35902Disassembler.WRITE_BYTE(nArray2, ramRomMap, new Value(0xFF00 | z80Instruction.getArg(), LR35902Disassembler.toAddress(state.getPC() - z80Instruction.getSize(), ramRomMap, state)), registerArray[7].getValue(), state);
                if (this.isPortAddress(0xFF00 | z80Instruction.getArg())) {
                    LR35902Disassembler.markPortSeen(z80Instruction.getArg(), n - z80Instruction.getSize());
                    break;
                }
                if (!this.isRAMaddress(0xFF00 | z80Instruction.getArg())) break;
                LR35902Disassembler.markRAMseen(0xFF00 | z80Instruction.getArg(), n - z80Instruction.getSize(), 1);
                break;
            }
            case 226: {
                LR35902Disassembler.WRITE_BYTE(nArray2, ramRomMap, registerArray[1].getValue().or(65280), registerArray[7].getValue(), state);
                if (this.isPortAddress(0xFF00 | registerArray[1].getValue().getMin())) {
                    LR35902Disassembler.markPortSeen(registerArray[1].getValue());
                    break;
                }
                if (registerArray[1].getSource() == null || !registerArray[1].getSource().isUnique() || !this.isRAMaddress(0xFF00 | registerArray[1].getValue().getMin())) break;
                LR35902Disassembler.markRAMseen(0xFF00 | registerArray[1].getValue().getMin(), registerArray[1].getSource().getMin(), 1);
                break;
            }
            case 227: {
                break;
            }
            case 228: {
                break;
            }
            case 232: {
                state.addToSP(z80Instruction.getArg());
                disassemblerState.retAddressStackPos -= z80Instruction.getArg();
                break;
            }
            case 234: {
                LR35902Disassembler.WRITE_BYTE(nArray2, ramRomMap, new Value(z80Instruction.getArg(), LR35902Disassembler.toAddress(state.getPC() - z80Instruction.getSize(), ramRomMap, state)), registerArray[7].getValue(), state);
                break;
            }
            case 235: {
                break;
            }
            case 236: {
                break;
            }
            case 237: {
                break;
            }
            case 240: {
                registerArray[7].setValue(LR35902Disassembler.READ_BYTE(nArray2, ramRomMap, new Value(0xFF00 | z80Instruction.getArg(), LR35902Disassembler.toAddress(state.getPC() - z80Instruction.getSize(), ramRomMap, state)), state));
                if (this.isPortAddress(0xFF00 | z80Instruction.getArg())) {
                    LR35902Disassembler.markPortSeen(z80Instruction.getArg(), n - z80Instruction.getSize());
                    break;
                }
                if (!this.isRAMaddress(0xFF00 | z80Instruction.getArg())) break;
                LR35902Disassembler.markRAMseen(0xFF00 | z80Instruction.getArg(), n - z80Instruction.getSize(), 1);
                break;
            }
            case 242: {
                registerArray[7].setValue(LR35902Disassembler.READ_BYTE(nArray2, ramRomMap, registerArray[1].getValue().or(65280), state));
                if (this.isPortAddress(0xFF00 | registerArray[1].getValue().getMin())) {
                    LR35902Disassembler.markPortSeen(registerArray[1].getValue());
                    break;
                }
                if (registerArray[1].getSource() == null || !registerArray[1].getSource().isUnique() || !this.isRAMaddress(0xFF00 | registerArray[1].getValue().getMin())) break;
                LR35902Disassembler.markRAMseen(0xFF00 | registerArray[1].getValue().getMin(), registerArray[1].getSource().getMin(), 1);
                break;
            }
            case 244: {
                break;
            }
            case 248: {
                registerArray[4].setValue(Value.newUnknownValue(0));
                registerArray[5].setValue(Value.newStackPointerValue(z80Instruction.getArg() - state.getSpOffset()));
                break;
            }
            case 250: {
                registerArray[7].setValue(LR35902Disassembler.READ_BYTE(nArray2, ramRomMap, new Value(z80Instruction.getArg(), LR35902Disassembler.toAddress(state.getPC() - z80Instruction.getSize(), ramRomMap, state)), state));
                break;
            }
            case 252: {
                break;
            }
            case 253: {
                break;
            }
            case 52016: 
            case 52017: 
            case 52018: 
            case 52019: 
            case 52020: 
            case 52021: 
            case 52022: 
            case 52023: {
                if ((z80Instruction.getOpCode() & 7) == 6) {
                    LR35902Disassembler.WRITE_BYTE(nArray2, ramRomMap, registerPairArray[2].getValue(), z80Instruction.getDisplacement(), LR35902Disassembler.READ_BYTE(nArray2, ramRomMap, registerPairArray[2].getValue(), z80Instruction.getDisplacement(), state).swap(), state);
                    break;
                }
                registerArray[z80Instruction.getOpCode() & 7].swap();
                break;
            }
            default: {
                return super.analyzeInstruction(disassemblerState, z80Instruction, n, z80Instruction2, state, n2, nArray, intDeque, n3);
            }
        }
        return n;
    }

    @Override
    protected int writeInstruction(List<Z80Disassembler.SourceLine> list, int n, RamRomMap ramRomMap, Z80Instruction z80Instruction, Map<List<Symbols.Symbol>> map, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, Map<String> map2) {
        n = super.writeInstruction(list, n, ramRomMap, z80Instruction, map, bitSet, bitSet2, bitSet3, map2);
        return z80Instruction.getOpCode() == 16 && dialect instanceof RgbdsDialect ? n + 1 : n;
    }

    @Override
    protected String injectByteSymbol(int n, Z80Instruction z80Instruction, String string, int n2, RamRomMap ramRomMap, Map<List<Symbols.Symbol>> map, Map<String> map2) {
        Object object;
        if ((z80Instruction.getOpCode() & 0xEF) == 224 && n2 >= 128 && n2 < 254 || z80Instruction.getOpCode() == 14) {
            object = Symbols.findRAMSymbol(0xFF00 | n2, map);
            if (object != null) {
                return String.valueOf(LR35902Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), z80Instruction.getOpCode() == 14 ? dialect.getLowByte(((Symbols.Symbol)object).getLabel()) : ((Symbols.Symbol)object).getLabel())) + "\t; " + ((Symbols.Symbol)object).getLabel() + " = $FF" + HexStrings.HEX_STRINGS[n2];
            }
            if (LR35902Disassembler.isRAMseen(this.mapRAMaddress(0xFF00 | n2), n)) {
                return LR35902Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), z80Instruction.getOpCode() == 14 ? dialect.getLowByte(String.format(FORMAT_RAM_LABEL, 0xFF00 | n2)) : String.format(FORMAT_RAM_LABEL, 0xFF00 | n2));
            }
        }
        if ((z80Instruction.getOpCode() & 0xEF) == 224 && n2 < 128) {
            Object object2 = object = LR35902Disassembler.isPortRead(n2, n) ? map2.get(-n2) : map2.get(n2);
            if (object != null) {
                return LR35902Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), (String)object);
            }
            return LR35902Disassembler.replace(string, HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1), String.format(FORMAT_PORT_LABEL, n2));
        }
        return super.injectByteSymbol(n, z80Instruction, string, n2, ramRomMap, map, map2);
    }

    static void writeGBcartridgeHeader(List<Z80Disassembler.SourceLine> list, GBCartridge gBCartridge, int[] nArray) {
        String string;
        String string2;
        if (nArray.length < 336) {
            return;
        }
        String string3 = dialect.getDataPrefix(1);
        String string4 = dialect.getDataPrefix(2);
        boolean bl = dialect.requiresDataCommas();
        int[] nArray2 = GBCartridge.getExpectedNintendoLogo();
        int[] nArray3 = GBCartridge.getExpectedAnaloguePocketLogo();
        list.add(new Z80Disassembler.SourceLine("GBcartridgeHeader:"));
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 0;
        while (bl2 && n < nArray2.length) {
            if (nArray2[n] != nArray[260 + n]) {
                bl2 = false;
                if (n < nArray2.length / 2) {
                    bl3 = false;
                }
            }
            ++n;
        }
        n = bl2 ? 0 : 1;
        int n2 = 0;
        while (n != 0 && n2 < nArray3.length) {
            if (nArray3[n2] != nArray[260 + n2]) {
                n = 0;
            }
            ++n2;
        }
        HashMap<List<Symbols.Symbol>> hashMap = new HashMap<List<Symbols.Symbol>>();
        if (n != 0) {
            list.add(new Z80Disassembler.SourceLine("; Analogue Pocket Logo: OK"));
        } else {
            list.add(new Z80Disassembler.SourceLine("; Nintendo Logo: " + (bl2 ? "OK" : (bl3 ? "Half-OK, Game Boy will lock up but Game Boy Color will work" : "WRONG, Game Boy will lock up"))));
        }
        LR35902Disassembler.addLabel(260);
        list.add(new Z80Disassembler.SourceLine(260, 16, LR35902Disassembler.getDataBlockLine(nArray, null, 260, 276, 1, null, hashMap)));
        list.add(new Z80Disassembler.SourceLine(276, 16, LR35902Disassembler.getDataBlockLine(nArray, null, 276, 292, 1, null, hashMap)));
        list.add(new Z80Disassembler.SourceLine(292, 16, LR35902Disassembler.getDataBlockLine(nArray, null, 292, 308, 1, null, hashMap)));
        list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 308;
        while (n3 < 319 && nArray[n3] != 0) {
            stringBuilder.append((char)nArray[n3]);
            ++n3;
        }
        String string5 = stringBuilder.toString();
        stringBuilder.setLength(0);
        if (!string5.isEmpty()) {
            stringBuilder.append(' ').append('\"').append(string5).append('\"');
        }
        int n4 = 308 + string5.length();
        while (n4 < 319) {
            if (n4 > 308 && bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(HexStrings.PREFIXED_HEX_STRINGS[nArray[n4]]);
            ++n4;
        }
        stringBuilder.append(" ; Title");
        list.add(new Z80Disassembler.SourceLine(308, 11, String.valueOf(string3) + stringBuilder));
        stringBuilder.setLength(0);
        n4 = 319;
        while (n4 < 323 && nArray[n4] != 0) {
            stringBuilder.append((char)nArray[n4]);
            ++n4;
        }
        String string6 = stringBuilder.toString();
        stringBuilder.setLength(0);
        if (!string6.isEmpty()) {
            stringBuilder.append(' ').append('\"').append(string6).append('\"');
        }
        int n5 = 319 + string6.length();
        while (n5 < 323) {
            if (n5 > 319 && bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(HexStrings.PREFIXED_HEX_STRINGS[nArray[n5]]);
            ++n5;
        }
        stringBuilder.append(" ; Manufacturer Code / End of Title");
        list.add(new Z80Disassembler.SourceLine(319, 4, String.valueOf(string3) + stringBuilder));
        list.add(new Z80Disassembler.SourceLine(323, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[323]] + "      ; CGB Flag: " + ((nArray[323] & 0x80) == 0 ? "Game does not support CGB functions." : ((nArray[323] & 0xCC) == 128 ? "Game supports CGB functions, but works on old gameboys also." : ((nArray[323] & 0xCC) == 192 ? "Game works on CGB only (physically the same as 80h)." : ((nArray[323] & 0x8C) != 0 ? "PGB Mode" : "Unknown value"))))));
        if (nArray[324] == 0 && nArray[325] == 0) {
            list.add(new Z80Disassembler.SourceLine(324, 2, String.valueOf(LR35902Disassembler.getDataBlockLine(nArray, null, 324, 326, 1, null, hashMap)) + " ; New Licensee Code"));
        } else {
            String string7 = String.valueOf(Character.toString((char)nArray[324])) + (char)nArray[325];
            list.add(new Z80Disassembler.SourceLine(324, 2, String.valueOf(string3) + " \"" + string7 + "\"     ; New Licensee Code"));
        }
        list.add(new Z80Disassembler.SourceLine(326, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[326]] + "      ; SGB Flag: " + (nArray[326] == 3 ? "Game supports SGB functions" : "No SGB functions (Normal Gameboy or CGB only game)")));
        list.add(new Z80Disassembler.SourceLine(327, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[327]] + "      ; Cartridge Type: " + gBCartridge.getTypeString()));
        switch (nArray[328]) {
            case 0: {
                string2 = "32 KByte \tno ROM banking";
                break;
            }
            case 1: {
                string2 = "64 KByte \t4 banks";
                break;
            }
            case 2: {
                string2 = "128 KByte \t8 banks";
                break;
            }
            case 3: {
                string2 = "256 KByte \t16 banks";
                break;
            }
            case 4: {
                string2 = "512 KByte \t32 banks";
                break;
            }
            case 5: {
                string2 = "1 MByte \t64 banks (only 63 banks used by MBC1)";
                break;
            }
            case 6: {
                string2 = "2 MByte \t128 banks (only 125 banks used by MBC1)";
                break;
            }
            case 7: {
                string2 = "4 MByte \t256 banks";
                break;
            }
            case 8: {
                string2 = "8 MByte \t512 banks";
                break;
            }
            case 82: {
                string2 = "1.1 MByte \t72 banks";
                break;
            }
            case 83: {
                string2 = "1.2 MByte \t80 banks";
                break;
            }
            case 84: {
                string2 = "1.5 MByte \t96 banks";
                break;
            }
            default: {
                string2 = "Unknown";
            }
        }
        list.add(new Z80Disassembler.SourceLine(328, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[328]] + "      ; ROM Size: " + string2));
        switch (nArray[329]) {
            case 0: {
                string = "None";
                break;
            }
            case 1: {
                string = "2 KBytes";
                break;
            }
            case 2: {
                string = "8 Kbytes";
                break;
            }
            case 3: {
                string = "32 KBytes (4 banks of 8KBytes each)";
                break;
            }
            case 4: {
                string = "128 KBytes (16 banks of 8KBytes each)";
                break;
            }
            case 5: {
                string = "64 KBytes (8 banks of 8KBytes each)";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        list.add(new Z80Disassembler.SourceLine(329, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[329]] + "      ; RAM Size: " + string));
        list.add(new Z80Disassembler.SourceLine(330, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[330]] + "      ; Destination Code: " + (nArray[330] == 0 ? "Japanese" : (nArray[330] == 1 ? "Non-Japanese" : "Undefined"))));
        list.add(new Z80Disassembler.SourceLine(331, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[331]] + "      ; Old Licensee Code" + (nArray[331] == 51 ? " (Overriden by New Licensee Code)" : "")));
        list.add(new Z80Disassembler.SourceLine(332, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[332]] + "      ; Mask ROM Version number"));
        int n6 = GBCartridge.calcHeaderChecksum(nArray);
        boolean bl4 = nArray[333] == (n6 & 0xFF);
        list.add(new Z80Disassembler.SourceLine(333, 1, String.valueOf(string3) + HexStrings.PREFIXED_HEX_STRINGS[nArray[333]] + "      ; Header Checksum: " + (bl4 ? "OK" : "WRONG, GameBoy will crash (should be" + HexStrings.PREFIXED_HEX_STRINGS[n6 & 0xFF] + ")")));
        n6 = 0;
        int n7 = 0;
        while (n7 < nArray.length) {
            if (n7 != 334 && n7 != 335) {
                n6 += nArray[n7];
            }
            ++n7;
        }
        bl4 = (nArray[334] << 8 | nArray[335]) == (n6 & 0xFFFF);
        list.add(new Z80Disassembler.SourceLine(334, 2, String.valueOf(string4) + HexStrings.PREFIXED_HEX_STRINGS[nArray[335]] + HexStrings.HEX_STRINGS[nArray[334]] + "    ; Global Checksum: " + (bl4 ? "OK" : "WRONG, GameBoy does not care (should be" + HexStrings.PREFIXED_HEX_STRINGS[n6 & 0xFF] + HexStrings.HEX_STRINGS[n6 >> 8 & 0xFF] + ")")));
        list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
    }

    @Override
    protected int mapSRAMaddress(int n, int n2) {
        return n2 * 8192 | n & 0x1FFF;
    }

    @Override
    protected int mapPortAddress(int n) {
        return n & 0xFF;
    }

    @Override
    protected boolean isEntryPointOptional(int n) {
        return n != 64 && n != 256;
    }

    public static Z80Instruction disassemble(int[] nArray, int n) {
        block4: {
            try {
                if (n >= 0 && n < nArray.length) break block4;
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        if (instance != null) {
            return instance.getInstruction(nArray, n);
        }
        return LR35902Instruction.parse(nArray, n);
    }
}

