/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import disassembler.Value;

public class Address
extends Value {
    private final boolean rom;
    private final boolean ram;
    private final boolean sram;
    private final boolean port;
    private final int offset;

    public Address(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(n);
        this.rom = bl;
        this.ram = bl2;
        this.sram = bl3;
        this.port = bl4;
        this.offset = 0;
    }

    public Address(Value value, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(value.getMin(), value.getMax(), value.getMultiplier(), value.getSource());
        this.rom = bl;
        this.ram = bl2;
        this.sram = bl3;
        this.port = bl4;
        this.offset = value.getOffset();
    }

    private Address(Address address, int n, int n2, int n3) {
        super(n, n2, n3, address.getSource());
        this.rom = address.rom;
        this.ram = address.ram;
        this.sram = address.sram;
        this.port = address.port;
        this.offset = address.offset;
    }

    private Address(Address address, int n, int n2) {
        super(n, n2, address.getMultiplier(), address.getSource());
        this.rom = address.rom;
        this.ram = address.ram;
        this.sram = address.sram;
        this.port = address.port;
        this.offset = address.offset;
    }

    private Address(Address address, Address address2) {
        super(address.getMin(), address.getMax(), address.getMultiplier(), address2);
        this.rom = address.rom;
        this.ram = address.ram;
        this.sram = address.sram;
        this.port = address.port;
        this.offset = address.offset;
    }

    public boolean isRomAddress() {
        return this.rom;
    }

    public boolean isRamAddress() {
        return this.ram;
    }

    public boolean isSramAddress() {
        return this.sram;
    }

    public boolean isPortAddress() {
        return this.port;
    }

    public boolean isUnknown() {
        return this instanceof UnknownAddress;
    }

    public boolean isCombined() {
        return this instanceof CombinedAddress;
    }

    public Address getAdditional() {
        if (!this.isCombined()) {
            return null;
        }
        return ((CombinedAddress)this).getAdditional();
    }

    public static Address asUnknown(Value value) {
        if (value instanceof UnknownAddress) {
            return (UnknownAddress)value;
        }
        return new UnknownAddress(value);
    }

    public static Address combine(Address address, Address address2) {
        if (address != null && address2 != null) {
            if (!address.isUnique() && address2.isUnique()) {
                return new CombinedAddress(address2, address);
            }
            return new CombinedAddress(address, address2);
        }
        if (address == null) {
            return address2;
        }
        return address;
    }

    @Override
    public Value newValue(int n, int n2, int n3) {
        if (n == this.min && n2 == this.max && n3 == this.multiplier) {
            return this;
        }
        return new Address(this, n, n2, n3);
    }

    @Override
    public Value newValue(int n, int n2) {
        if (n == this.min && n2 == this.max) {
            return this;
        }
        return new Address(this, n, n2);
    }

    @Override
    public Value newSource(Address address) {
        if (address == this.source) {
            return this;
        }
        return new Address(this, address);
    }

    @Override
    public Value newMultiplier(int n) {
        return this;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String toString() {
        if (this.getOffset() > 0) {
            return String.valueOf(super.toString()) + " + " + this.getOffset();
        }
        return super.toString();
    }

    private static class CombinedAddress
    extends Address {
        private final Address additional;

        public CombinedAddress(Address address, Address address2) {
            super(address, address.isRomAddress(), address.isRamAddress(), address.isSramAddress(), address.isPortAddress());
            this.additional = address instanceof CombinedAddress ? new CombinedAddress(address.getAdditional(), address2) : address2;
        }

        @Override
        public int getMultiplier() {
            return Math.max(this.multiplier, this.additional.multiplier);
        }

        @Override
        public Address getAdditional() {
            return this.additional;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) || this.additional.equals(object);
        }
    }

    private static class UnknownAddress
    extends Address {
        public UnknownAddress(Value value) {
            super(value, false, false, false, false);
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    }
}

