/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.requests;

import dap.messages.Request;
import dap.types.StackFrameFormat;
import json.JSONObject;

public class StackTraceRequest
extends Request {
    private final int threadId;
    private final int startFrame;
    private final int levels;
    private final StackFrameFormat stackFrameFormat;

    public StackTraceRequest(JSONObject jSONObject) {
        super(jSONObject);
        JSONObject jSONObject2 = this.getArguments();
        this.threadId = jSONObject2.getInt("threadId");
        this.startFrame = jSONObject2.getInt("startFrame", 0);
        this.levels = jSONObject2.getInt("levels", 0);
        this.stackFrameFormat = StackFrameFormat.from(jSONObject2.getObjectOptional("stackFrameFormat"));
    }

    public int getThreadId() {
        return this.threadId;
    }

    public int getStartFrame() {
        return this.startFrame;
    }

    public int getLevels() {
        return this.levels;
    }

    public StackFrameFormat getStackFrameFormat() {
        return this.stackFrameFormat;
    }
}

