/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.events;

import dap.messages.Event;
import dap.types.Breakpoint;
import json.JSONObject;

public class BreakpointEvent
extends Event {
    private final Reason reason;
    private final Breakpoint breakpoint;

    public BreakpointEvent(Reason reason, Breakpoint breakpoint) {
        if (reason == null) {
            throw new IllegalArgumentException("reason must not be null");
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException("breakpoint must not be null");
        }
        this.reason = reason;
        this.breakpoint = breakpoint;
    }

    @Override
    public String getEvent() {
        return "breakpoint";
    }

    @Override
    public JSONObject getBody() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("reason", this.reason.toString().toLowerCase());
        jSONObject.put("breakpoint", this.breakpoint);
        return jSONObject;
    }

    public static enum Reason {
        CHANGED,
        NEW,
        REMOVED;

    }
}

