/*
 * Decompiled with CFR 0.152.
 */
package components.video;

import components.OutputListener;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;

public class TMS9918A {
    public static final int SIGNATURE = 0x110000;
    public static final int INVALID_VDP_ACCESS = 0x1100FF;
    public static final int RENDER_LINE = 0x110000;
    public static final int SET_MODE = 0x110001;
    public static final int CRAM_WRITE = 0x110002;
    public static final int CRAM_WRITTEN = 0x110003;
    public static final int VRAM_WRITE = 0x110004;
    public static final int VRAM_READ = 0x110005;
    public static final int STATUS_READ = 0x110006;
    public static final int PREPARE_SPRITES = 0x110007;
    public static final int ADDRESS_WRITE = 0x110010;
    public static final int REGISTER_WRITE = 0x110011;
    public static final int REGISTER_WRITTEN = 0x110012;
    public static final int ADDRESS_WRITE_CANCELLED = 0x110013;
    public static final int INTERRUPT = 1114303;
    public static final int SCANLINES_PAL = 313;
    public static final int SCANLINES_NTSC = 262;
    public static final int VRAM_CHANGE_MASK = 131072;
    public static final int ADDRESS_MASK = 131071;
    public static final int DATA_OFFSET = 20;
    public static final int DATA_MASK = 0xFF00000;
    public static final int CYCLES_PER_LINE = 228;
    protected static final int PIXELS_PER_LINE = 342;
    private static final int CYCLES_PER_INCREASE = 26;
    protected final int VRAM_ADDRESS_MASK = 16383;
    private final int SCANLINES;
    private static final int LINES_VERTICAL_BLANKING = 3;
    private static final int LINES_TOP_BLANKING = 13;
    protected static final int LINES_BOTTOM_BLANKING = 3;
    private static final int LINES_BLANKING = 19;
    private final int REGS_MASK;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    protected final int[] vram;
    protected final int[] cram;
    protected final int[] regs;
    protected int regStatus;
    private int regCode;
    protected int regAddress;
    private int buffer;
    protected boolean hiByteNext;
    protected int height;
    protected int line;
    protected int counter;
    private final int[] screenMapBaseAddress = new int[32];
    private int[] spriteAttributeTableAddress = new int[12];
    private int[] prevSpriteAttributeTableAddress = new int[12];
    private boolean nextSATprepared;
    private boolean backDropColorChanged;
    private int[] backDropColor = new int[288];
    private boolean[] displayOn = new boolean[299];
    private boolean displayOnChanged;
    private int latchedHScroll;
    private int hScroll;
    private int vScroll;
    private int modeBits;
    private int spriteCollisionCycleMin = 228;
    private int spriteCollisionCycleMax;
    private int overflowSprite;
    protected boolean lineInterruptPending;
    protected boolean lineInterruptDelayed;
    protected int timer;
    private int slot;
    private boolean shouldIncrease;
    private boolean shouldRead;

    public TMS9918A(int n) {
        this(n, new int[16384], new int[16], new int[8]);
    }

    protected TMS9918A(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        this.SCANLINES = n;
        this.vram = nArray;
        this.cram = nArray2;
        this.regs = nArray3;
        int n2 = 1;
        while (n2 < nArray3.length) {
            n2 <<= 1;
        }
        this.REGS_MASK = n2 - 1;
    }

    public int[] getVRAM() {
        return this.vram;
    }

    public int[] getCRAM() {
        return this.cram;
    }

    public int getColorBlue(int n) {
        return (this.cram[n] & 0x30) >> 4;
    }

    public int getColorGreen(int n) {
        return (this.cram[n] & 0xC) >> 2;
    }

    public int getColorRed(int n) {
        return this.cram[n] & 3;
    }

    public int getColor(int n) {
        return this.cram[n];
    }

    public int getColorMaxIntensity() {
        return 3;
    }

    public int getAddress() {
        return this.regAddress;
    }

    public int getRegStatus(int n) {
        return this.regStatus;
    }

    public int getLine() {
        return this.line;
    }

    public int getCyclesPerFrame() {
        return this.getScanlines() * 228;
    }

    public int getScanlines() {
        return this.SCANLINES;
    }

    public int getLinesTopBorder() {
        return this.getScanlines() - this.getScreenHeight() - 19 - this.getLinesBottomBorder();
    }

    public int getLinesBottomBorder() {
        return this.getScanlines() - this.getScreenHeight() - 19 >> 3 << 2;
    }

    public int getModeBits() {
        return this.modeBits;
    }

    public String getModeName(int n) {
        switch (n) {
            case 0: {
                return "M0";
            }
            case 1: {
                return "M1";
            }
            case 2: {
                return "M2";
            }
            case 3: {
                return "M1 extended";
            }
            case 4: {
                return "M3";
            }
            case 6: {
                return "M3 extended";
            }
            case 5: 
            case 7: {
                return "Invalid mode";
            }
        }
        return "Invalid: " + n;
    }

    public void setSpriteOverflowFlag(int n) {
        if (this.getLine() < this.getScreenHeight()) {
            if ((this.regStatus & 0x40) == 0) {
                this.overflowSprite = n;
            }
            this.regStatus |= 0x40;
        }
    }

    public void setSpriteCollisionX(int n) {
        int n2 = TMS9918A.pixelToCycles(n);
        if (n2 < this.spriteCollisionCycleMin) {
            this.spriteCollisionCycleMin = n2;
        }
        if (n2 > this.spriteCollisionCycleMax) {
            this.spriteCollisionCycleMax = n2;
        }
    }

    static final int pixelToCycles(int n) {
        return n * 228 / 342 + 23;
    }

    static final int cyclesToPixel(int n) {
        return (n * 342 - 114) / 228;
    }

    public int getScreenHeight() {
        return 192;
    }

    public int getDisplayAdjustHorizontal() {
        return 0;
    }

    public int getDisplayAdjustVertical() {
        return 0;
    }

    public int getDisplayOffset() {
        return 0;
    }

    public boolean hasTransparency() {
        return true;
    }

    public boolean isSpritesDisabled() {
        return false;
    }

    protected boolean isLineInterruptEnabled() {
        return false;
    }

    public boolean isSyncEnabled() {
        return (this.regs[0] & 1) != 0;
    }

    public boolean isDisplayOn() {
        return (this.regs[1] & 0x40) != 0;
    }

    public boolean isDisplayOn(int n) {
        return this.displayOn[11 + n];
    }

    protected boolean isFrameInterruptEnabled() {
        return (this.regs[1] & 0x20) != 0;
    }

    public boolean isLargeSpritesEnabled() {
        return (this.regs[1] & 2) != 0;
    }

    public boolean isDoubledSpritesEnabled() {
        return (this.regs[1] & 1) != 0;
    }

    public int getScreenMapBaseAddress() {
        return (this.regs[2] & 0xF) << 10;
    }

    public int getScreenMapBaseAddress(int n) {
        return this.screenMapBaseAddress[n];
    }

    public int getSpritesDoneY() {
        return 208;
    }

    public int getColorTableAddress() {
        if (this.getModeBits() == 2) {
            return (this.regs[3] & 0x80) << 6;
        }
        return this.regs[3] << 6;
    }

    public int getColorTableMask() {
        if (this.getModeBits() == 2) {
            return this.regs[3] << 6 | 0x7F;
        }
        return this.vram.length - 1;
    }

    public int getPatternGeneratorTableAddress() {
        if ((this.getModeBits() & 2) != 0) {
            return (this.regs[4] & 4) << 11;
        }
        return (this.regs[4] & 7) << 11;
    }

    public int getPatternGeneratorTableMask() {
        if ((this.getModeBits() & 2) != 0) {
            return (this.regs[4] & 7) << 11 | 0x7FF;
        }
        return this.vram.length - 1;
    }

    public int getSpriteAttributeTableAddress() {
        return this.makeSATaddress();
    }

    public int getSpriteAttributeTableAddress(int n) {
        return this.spriteAttributeTableAddress[Math.min(n, this.spriteAttributeTableAddress.length - 1)];
    }

    public int getPrevSpriteAttributeTableAddress(int n) {
        return this.prevSpriteAttributeTableAddress[Math.min(n, this.prevSpriteAttributeTableAddress.length - 1)];
    }

    protected int makeSATaddress() {
        return (this.regs[5] & 0x7F) << 7;
    }

    public int getSpritePatternAddress() {
        return (this.regs[6] & 7) << 11;
    }

    public int getBackDropColor(int n, int n2) {
        return this.backDropColor[n];
    }

    public int getBackDropColor() {
        return this.getBackDropColor(0, 0);
    }

    public int getTextColor(int n, int n2) {
        return this.regs[7] >> 4;
    }

    public int getTextColor() {
        return this.getTextColor(0, 0);
    }

    public int getHorizontalScroll() {
        return this.hScroll;
    }

    public int getVerticalScroll() {
        return this.vScroll;
    }

    protected int readVRAM(int n) {
        return this.vram[n];
    }

    protected void writeVRAM(int n, int n2) {
        this.vram[n] = n2;
    }

    public int readByte(int n, int n2) {
        this.update(n2);
        int n3 = -1;
        if (this.hiByteNext) {
            this.fireOutputAvailable(0x110013, this.getAddress());
        }
        this.hiByteNext = false;
        switch (n) {
            case 0: {
                n3 = this.buffer;
                if (this.shouldRead) {
                    this.fireInvalidVDPaccess();
                }
                this.shouldRead = true;
                this.fireOutputAvailable(0x110005, this.regAddress);
                break;
            }
            case 1: {
                if (228 - this.timer > this.spriteCollisionCycleMin) {
                    this.regStatus |= 0x20;
                    if (228 - this.timer > this.spriteCollisionCycleMax) {
                        this.spriteCollisionCycleMin = 228;
                        this.spriteCollisionCycleMax = 0;
                    }
                }
                this.fireOutputAvailable(0x110006, 0);
                n3 = this.regStatus | this.overflowSprite;
                this.regStatus = 0;
                this.lineInterruptPending = false;
                this.fireOutputAvailable(1114303, -1);
            }
        }
        this.timer += n2;
        return n3;
    }

    protected void regWrite(int n, int n2) {
        this.regWrite(n, n2, false);
    }

    protected void regWrite(int n, int n2, boolean bl) {
        if ((n &= this.REGS_MASK) >= this.regs.length) {
            return;
        }
        int n3 = this.regs[n] ^ n2;
        if (!bl) {
            this.fireOutputAvailable(0x110011, n2 << 8 | n);
        }
        this.regs[n] = n2;
        this.fireOutputAvailable(0x110012, n2 << 16 | (n2 ^ n3) << 8 | n);
        switch (n) {
            case 0: {
                if ((n3 & 0x10) == 0) break;
                this.fireOutputAvailable(1114303, this.lineInterruptPending && this.isLineInterruptEnabled() ? 2 : -1);
                break;
            }
            case 1: {
                if ((n3 & 0x20) != 0) {
                    this.fireOutputAvailable(1114303, (this.regStatus & 0x80) != 0 && this.isFrameInterruptEnabled() ? 1 : -1);
                }
                if ((n3 & 0x40) == 0) break;
                int n4 = TMS9918A.cyclesToPixel(228 - this.timer) - 19;
                if (n4 < this.displayOn.length) {
                    Arrays.fill(this.displayOn, Math.max(0, n4), this.displayOn.length, this.isDisplayOn());
                }
                this.displayOnChanged = true;
                break;
            }
            case 2: {
                if (TMS9918A.cyclesToPixel(228 - this.timer - 4) / 8 - 1 >= this.screenMapBaseAddress.length) break;
                Arrays.fill(this.screenMapBaseAddress, Math.max(0, TMS9918A.cyclesToPixel(228 - this.timer - 4) / 8 - 1), this.screenMapBaseAddress.length, this.getScreenMapBaseAddress());
                break;
            }
            case 5: {
                if (228 - this.timer <= 190) {
                    Arrays.fill(this.spriteAttributeTableAddress, Math.min(this.spriteAttributeTableAddress.length, Math.max(0, 228 - this.timer - 4 - (228 - this.timer) / 8 << 1)), this.spriteAttributeTableAddress.length, this.makeSATaddress());
                    break;
                }
                Arrays.fill(this.prevSpriteAttributeTableAddress, Math.min(this.prevSpriteAttributeTableAddress.length, Math.max(0, (228 - this.timer - 187 - (228 - this.timer) / 211 * 3) / 4 - (228 - this.timer - 187) / 20 + (228 - this.timer - 187) / 40)), this.prevSpriteAttributeTableAddress.length, this.makeSATaddress());
                this.nextSATprepared = true;
                break;
            }
            case 7: {
                int n5 = TMS9918A.cyclesToPixel(228 - this.timer) - 20;
                if (n5 < this.backDropColor.length) {
                    Arrays.fill(this.backDropColor, Math.max(0, n5), this.backDropColor.length, this.regs[7] & 0xF);
                }
                this.backDropColorChanged = true;
                break;
            }
            case 8: {
                if (this.timer <= 1) break;
                this.latchedHScroll = this.regs[8];
            }
        }
    }

    protected void cramWrite(int n, int n2) {
        boolean bl = this.cram[n & 0x1F] != n2;
        this.fireOutputAvailable(0x110002, n2 << 8 | n & 0x1F);
        this.cram[n & 0x1F] = n2;
        this.fireOutputAvailable(0x110003, bl ? 0x20 | n & 0x1F : n & 0x1F);
        this.requestIncrease();
    }

    public void processInput(int n, int n2, int n3) {
        this.update(n3);
        switch (n) {
            case 0: {
                this.processInputPort0(n2);
                break;
            }
            case 1: {
                this.processInputPort1(n2);
            }
        }
        this.timer += n3;
    }

    private final void processInputPort0(int n) {
        this.buffer = n;
        if (this.regCode == 3) {
            this.cramWrite(this.regAddress, this.buffer);
        } else {
            this.fireOutputAvailable(0x110004, this.buffer << 20 | (this.vram[this.getAddress()] != this.buffer ? 0x20000 | this.getAddress() : this.getAddress()));
            this.writeVRAM(this.regAddress, this.buffer);
            this.requestIncrease();
        }
        this.hiByteNext = false;
    }

    protected void processInputPort1(int n) {
        if (this.hiByteNext) {
            this.regCode = n >> 6;
            this.regAddress = (n & 0x3F) << 8 | this.regAddress & 0xFF;
            this.fireOutputAvailable(0x110010, this.regAddress);
            if (this.shouldRead) {
                this.fireInvalidVDPaccess();
            }
            this.shouldRead = false;
            switch (this.regCode) {
                case 0: {
                    this.shouldRead = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.regWrite(n & 0x7F, this.regAddress & 0xFF);
                    break;
                }
            }
        } else {
            this.regAddress = this.regAddress & 0xFF00 | n;
            this.fireOutputAvailable(0x110010, this.regAddress);
            if (this.shouldIncrease || this.shouldRead) {
                this.fireInvalidVDPaccess();
            }
        }
        boolean bl = this.hiByteNext = !this.hiByteNext;
        if (this.regCode > 0 && this.shouldIncrease && (this.regAddress + 1 & 0x7F) < (this.regAddress & 0x7F)) {
            this.regAddress = this.regAddress + 256 & 0x3FFF;
            this.shouldIncrease = false;
            this.fireInvalidVDPaccess();
        }
    }

    public void reset() {
        this.spriteCollisionCycleMin = 228;
        this.lineInterruptPending = false;
        this.lineInterruptDelayed = false;
        this.hiByteNext = false;
        Arrays.fill(this.regs, 0);
        this.backDropColorChanged = true;
        this.displayOnChanged = true;
        this.nextSATprepared = false;
        this.latchedHScroll = 0;
        this.modeBits = -1;
        this.latchValues();
        this.shouldIncrease = false;
        this.shouldRead = false;
        this.line = 0;
        int n = (int)(System.currentTimeMillis() % 1000L);
        this.timer = 228 * (157 + (n / 16 + 1) % 12) + n % 16;
    }

    public void update(int n) {
        if (this.lineInterruptDelayed) {
            if (this.timer > 0) {
                this.timer = 0;
                return;
            }
            this.lineInterruptDelayed = false;
            this.fireOutputAvailable(1114303, 2);
            this.timer = 228;
        }
        this.timer -= n;
        while (this.timer <= 0) {
            this.renderLine();
            if (this.line++ == this.height) {
                this.regStatus |= 0x80;
                if (this.isFrameInterruptEnabled()) {
                    this.fireOutputAvailable(1114303, 1);
                }
            }
            if (this.line >= this.getScanlines()) {
                this.overflowSprite = 31;
                this.line = 0;
                this.vScroll = this.regs[9];
            }
            this.latchValues();
            if (this.line <= this.height) {
                if (this.spriteCollisionCycleMin < 228) {
                    this.regStatus |= 0x20;
                }
                this.spriteCollisionCycleMin = 228;
                this.spriteCollisionCycleMax = 0;
                this.fireOutputAvailable(0x110007, this.line);
            }
            if (this.nextSATprepared) {
                Arrays.fill(this.spriteAttributeTableAddress, this.makeSATaddress());
                Arrays.fill(this.prevSpriteAttributeTableAddress, this.makeSATaddress());
            }
            this.nextSATprepared = false;
            if (this.lineInterruptDelayed) break;
            this.timer += 228;
        }
        this.handleIncreaseAddress();
    }

    protected void renderLine() {
        this.fireOutputAvailable(0x110000, this.line);
    }

    protected void latchValues() {
        int n;
        this.hScroll = this.latchedHScroll;
        this.latchedHScroll = this.regs[8];
        if (this.backDropColorChanged) {
            Arrays.fill(this.backDropColor, this.regs[7] & 0xF);
            this.backDropColorChanged = false;
        }
        if (this.displayOnChanged) {
            Arrays.fill(this.displayOn, this.isDisplayOn());
            this.displayOnChanged = false;
        }
        Arrays.fill(this.screenMapBaseAddress, this.getScreenMapBaseAddress());
        int[] nArray = this.spriteAttributeTableAddress;
        this.spriteAttributeTableAddress = this.prevSpriteAttributeTableAddress;
        this.prevSpriteAttributeTableAddress = nArray;
        if (!this.nextSATprepared) {
            Arrays.fill(this.spriteAttributeTableAddress, this.makeSATaddress());
        }
        if ((n = this.makeModeBits()) != this.modeBits) {
            this.modeBits = n;
            this.fireOutputAvailable(0x110001, n);
        }
        this.height = this.getScreenHeight();
    }

    protected int makeModeBits() {
        return (this.regs[1] & 8) >> 1 | this.regs[0] & 2 | (this.regs[1] & 0x10) >> 4;
    }

    protected void handleIncreaseAddress() {
        if (this.isEmulateVdpConstraints()) {
            int n;
            if (this.timer == 228) {
                n = 8;
            } else {
                n = (227 - this.timer) / 26;
                if (n == 8) {
                    n = 7;
                }
            }
            if (n != this.slot || this.line >= this.height || !this.isDisplayOn() || this.timer < 20 || this.timer > 212) {
                if (this.shouldRead) {
                    this.buffer = this.readVRAM(this.regAddress);
                    this.requestIncrease();
                    this.shouldRead = false;
                }
                if (this.shouldIncrease) {
                    this.regAddress = this.regAddress + 1 & 0x3FFF;
                    this.shouldIncrease = false;
                }
            }
            this.slot = n;
        } else {
            if (this.shouldRead) {
                this.buffer = this.readVRAM(this.regAddress);
                this.requestIncrease();
                this.shouldRead = false;
            }
            if (this.shouldIncrease) {
                this.regAddress = this.regAddress + 1 & 0x3FFF;
                this.shouldIncrease = false;
            }
        }
    }

    protected boolean isEmulateVdpConstraints() {
        return true;
    }

    private void requestIncrease() {
        if (this.shouldIncrease) {
            if ((228 - this.timer) % 26 == 0) {
                this.regAddress = this.regAddress + 1 & 0x3FFF;
            }
            this.fireInvalidVDPaccess();
        }
        this.shouldIncrease = true;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setReg(int n, int n2) {
        this.regWrite(n, n2, true);
    }

    private final void fireInvalidVDPaccess() {
        this.fireOutputAvailable(0x1100FF, (228 - this.timer) % 26);
    }

    protected final void fireOutputAvailable(int n, int n2) {
        int n3 = TMS9918A.cyclesToPixel(228 - (this.timer <= 0 ? this.timer + 228 : this.timer));
        OutputListener[] outputListenerArray = this.listeners;
        int n4 = this.listeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, n2, n3);
            ++n5;
        }
    }

    public final void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public final void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getTimer() {
                return TMS9918A.this.timer;
            }

            @Override
            public int getReg(int n) {
                if (n >= TMS9918A.this.regs.length) {
                    return 0;
                }
                return TMS9918A.this.regs[n];
            }

            @Override
            public int[] getCram() {
                return TMS9918A.this.cram;
            }

            @Override
            public int[] getVram() {
                return TMS9918A.this.vram;
            }

            @Override
            public boolean isHiByteNext() {
                return TMS9918A.this.hiByteNext;
            }

            @Override
            public int getLine() {
                return TMS9918A.this.line;
            }

            @Override
            public int getRegAddress() {
                return TMS9918A.this.regAddress;
            }

            @Override
            public int getRegStatus() {
                return TMS9918A.this.regStatus;
            }

            @Override
            public int getRegCode() {
                return TMS9918A.this.regCode;
            }

            @Override
            public int getBuffer() {
                return TMS9918A.this.buffer;
            }

            @Override
            public int getCounter() {
                return TMS9918A.this.counter;
            }

            @Override
            public boolean isLineInterruptPending() {
                return TMS9918A.this.lineInterruptPending;
            }

            @Override
            public int getCramLatch() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setState(State state, boolean bl) {
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = state.getReg(n);
            ++n;
        }
        this.vScroll = this.regs[9];
        this.backDropColorChanged = true;
        this.displayOnChanged = true;
        this.nextSATprepared = false;
        this.latchValues();
        this.hScroll = this.latchedHScroll;
        System.arraycopy(state.getCram(), 0, this.cram, 0, this.cram.length);
        n = 0;
        while (n < this.cram.length) {
            this.fireOutputAvailable(0x110003, 0x20 | n);
            ++n;
        }
        System.arraycopy(state.getVram(), 0, this.vram, 0, this.vram.length);
        n = 0;
        while (n < this.vram.length) {
            this.fireOutputAvailable(0x110004, this.vram[n] << 20 | 0x20000 | n);
            ++n;
        }
        if (!bl) {
            this.line = 0;
            while (this.line < this.getScanlines()) {
                if (this.line <= this.height) {
                    this.fireOutputAvailable(0x110007, this.line);
                }
                this.fireOutputAvailable(0x110000, this.line);
                ++this.line;
            }
        }
        this.slot = -1;
        this.timer = state.getTimer();
        this.hiByteNext = state.isHiByteNext();
        this.line = state.getLine();
        this.regAddress = state.getRegAddress() & 0x3FFF;
        this.regStatus = state.getRegStatus();
        this.regCode = state.getRegCode();
        this.buffer = state.getBuffer();
        this.counter = state.getCounter();
        this.lineInterruptPending = state.isLineInterruptPending();
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getTimer();

        public int getReg(int var1);

        public int[] getCram();

        public int[] getVram();

        public boolean isHiByteNext();

        public int getLine();

        public int getRegAddress();

        public int getRegStatus();

        public int getRegCode();

        public int getBuffer();

        public int getCounter();

        public boolean isLineInterruptPending();

        public int getCramLatch();
    }

    protected static class StateClone
    implements State {
        private final int[] regs = new int[11];
        private final int[] vram;
        private final int[] cram;
        private int timer;
        private boolean hiByteNext;
        private int line;
        private int regAddress;
        private int regStatus;
        private int regCode;
        private int buffer;
        private int counter;
        private boolean lineInterruptPending;

        public StateClone(State state) {
            this.vram = new int[state.getVram().length];
            this.cram = new int[state.getCram().length];
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            int n = 0;
            while (n < this.regs.length) {
                this.regs[n] = state.getReg(n);
                ++n;
            }
            System.arraycopy(state.getVram(), 0, this.vram, 0, this.vram.length);
            System.arraycopy(state.getCram(), 0, this.cram, 0, this.cram.length);
            this.timer = state.getTimer();
            this.hiByteNext = state.isHiByteNext();
            this.line = state.getLine();
            this.regAddress = state.getRegAddress();
            this.regStatus = state.getRegStatus();
            this.regCode = state.getRegCode();
            this.buffer = state.getBuffer();
            this.counter = state.getCounter();
            this.lineInterruptPending = state.isLineInterruptPending();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getTimer() {
            return this.timer;
        }

        @Override
        public int getReg(int n) {
            if (n >= this.regs.length) {
                return 0;
            }
            return this.regs[n];
        }

        @Override
        public int[] getCram() {
            return this.cram;
        }

        @Override
        public int[] getVram() {
            return this.vram;
        }

        @Override
        public boolean isHiByteNext() {
            return this.hiByteNext;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getRegAddress() {
            return this.regAddress;
        }

        @Override
        public int getRegStatus() {
            return this.regStatus;
        }

        @Override
        public int getRegCode() {
            return this.regCode;
        }

        @Override
        public int getBuffer() {
            return this.buffer;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public boolean isLineInterruptPending() {
            return this.lineInterruptPending;
        }

        @Override
        public int getCramLatch() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

