/*
 * Decompiled with CFR 0.152.
 */
package components.cartridge;

import components.cartridge.Cartridge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.UnmodifiableClassException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import patching.IPS;

public class GBCartridge
extends Cartridge {
    private final int MASK_ROM_BANK;
    private final int mbc;
    private final int huc;
    private final boolean wisdomTree;
    private final boolean hasBattery;
    private final boolean hasTimer;
    private final boolean hasRumble;
    private final int[] ram;
    private final int ramMask;
    private final int mbc1bankMask;
    private final int mbc1bankShift;
    private int huc3mode;
    private int huc3accessIndex;
    private int huc3accessFlags;
    private int huc3read;
    private int regROMBankNumber;
    private int regRAMBankNumber;
    private int romBankOffset;
    private int ramBankOffset = -40960;
    private boolean modeRAM;
    private boolean ramEnabled;
    private int clockSeconds;
    private int clockMinutes;
    private int clockHours;
    private int clockDays;
    private int clockControl;
    private int clockLatchedSeconds;
    private int clockLatchedMinutes;
    private int clockLatchedHours;
    private int clockLatchedDays;
    private int clockLatchedControl;
    private Date clockLastTime = new Date();
    private boolean ramChanged;
    private long lastWriteMillis;
    private int cycles;
    private int prevCycles;

    public GBCartridge(int[] nArray) {
        super(GBCartridge.ensureMinimumRomSize(nArray, 16384));
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        switch (this.getType()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n = 1;
                break;
            }
            case 5: 
            case 6: {
                n = 2;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                n = 4;
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                bl = true;
            }
            case 25: 
            case 26: 
            case 27: {
                n = 5;
                break;
            }
            case 254: {
                n = -1;
                n2 = 3;
                break;
            }
            case 255: {
                n = -1;
                n2 = 1;
                this.ramEnabled = true;
            }
        }
        this.mbc = n;
        this.huc = n2;
        this.hasTimer = false;
        this.hasBattery = false;
        this.hasRumble = bl;
        if (n == 2) {
            this.ram = new int[512];
            this.ramMask = 15;
        } else {
            this.ram = new int[this.getRAMSize()];
            this.ramMask = 255;
        }
        Arrays.fill(this.ram, 255);
        this.mbc1bankShift = this.isMBC1multicart() ? 4 : 5;
        this.mbc1bankMask = (1 << this.mbc1bankShift) - 1;
        this.wisdomTree = this.detectIsWisdomTree();
        int n3 = (nArray.length - 1) / 16384;
        while ((n3 & n3 + 1) != 0) {
            ++n3;
        }
        this.MASK_ROM_BANK = n3;
        this.reset();
    }

    public GBCartridge(String string, IPS iPS) throws IOException {
        super(string, iPS);
        this.rom = GBCartridge.ensureMinimumRomSize(this.rom, 16384);
        if ((this.rom.length & 0x3FFF) != 0) {
            int[] nArray = new int[this.rom.length + (16384 - (this.rom.length & 0x3FFF))];
            Arrays.fill(nArray, 255);
            System.arraycopy(this.rom, 0, nArray, 0, this.rom.length);
            this.rom = nArray;
        }
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.getType()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n = 1;
                break;
            }
            case 5: 
            case 6: {
                n = 2;
                break;
            }
            case 15: 
            case 16: {
                bl = true;
            }
            case 17: 
            case 18: 
            case 19: {
                n = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                n = 4;
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                bl3 = true;
            }
            case 25: 
            case 26: 
            case 27: {
                n = 5;
                break;
            }
            case 254: {
                n = -1;
                n2 = 3;
                break;
            }
            case 255: {
                n = -1;
                n2 = 1;
                this.ramEnabled = true;
                break;
            }
            default: {
                System.err.println("Unknown type: " + Integer.toHexString(this.getType()));
            }
        }
        switch (this.getType()) {
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 30: 
            case 255: {
                bl2 = true;
            }
        }
        this.mbc = n;
        this.huc = n2;
        this.hasTimer = bl;
        this.hasBattery = bl2;
        this.hasRumble = bl3;
        if (n == 2) {
            this.ram = new int[512];
            this.ramMask = 15;
        } else {
            this.ram = new int[this.getRAMSize()];
            this.ramMask = 255;
        }
        Arrays.fill(this.ram, 255);
        if (bl2) {
            this.readRAMfromFile();
            this.enableShutdownHook();
        }
        this.mbc1bankShift = this.isMBC1multicart() ? 4 : 5;
        this.mbc1bankMask = (1 << this.mbc1bankShift) - 1;
        this.wisdomTree = this.detectIsWisdomTree();
        int n3 = (this.rom.length - 1) / 16384;
        while ((n3 & n3 + 1) != 0) {
            ++n3;
        }
        this.MASK_ROM_BANK = n3;
        this.reset();
    }

    private boolean detectIsWisdomTree() {
        if (this.mbc > 0 || this.huc > 0) {
            return false;
        }
        int n = "WISDOM TREE".indexOf(32);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rom.length) {
            if (n2 == "WISDOM TREE".length()) {
                return true;
            }
            n2 = n2 == n && (this.rom[n3] == 0 || (char)this.rom[n3] == ' ') ? ++n2 : (n2 < "WISDOM TREE".length() && this.rom[n3] == "WISDOM TREE".charAt(n2) ? ++n2 : 0);
            ++n3;
        }
        return false;
    }

    @Override
    public int mapAddress(int n) {
        if (n < 16384) {
            if (this.wisdomTree) {
                return n + this.romBankOffset;
            }
            if (this.modeRAM) {
                return (this.regROMBankNumber & ~this.mbc1bankMask & this.MASK_ROM_BANK) * 16384 | n;
            }
            return n;
        }
        if (n < 32768) {
            return n + this.romBankOffset;
        }
        if (this.isSRAMaddress(n)) {
            return n + this.ramBankOffset & this.ram.length - 1;
        }
        return n;
    }

    @Override
    public int mapAddress(int n, int n2) {
        if (n < 16384) {
            return n;
        }
        if (this.isSRAMaddress(n)) {
            return (n2 * 8192 | n & 0x1FFF) & this.ram.length - 1;
        }
        return Math.max(1, n2 & this.MASK_ROM_BANK) * 16384 | n & 0x3FFF;
    }

    @Override
    public boolean isROMaddress(int n) {
        return n < 32768;
    }

    @Override
    public boolean isSRAMaddress(int n) {
        return this.hasSRAM() && n >= 40960 && n < 49152;
    }

    public boolean isTimerAddress(int n) {
        return this.hasTimer && n >= 40960 && n < 49152;
    }

    public int getTimerByte(int n, int n2) {
        if (this.isTimerAddress(n) && this.mbc == 3) {
            switch (n2) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 14: 
                case 15: {
                    return 255;
                }
                case 8: {
                    return this.clockLatchedSeconds;
                }
                case 9: {
                    return this.clockLatchedMinutes;
                }
                case 10: {
                    return this.clockLatchedHours;
                }
                case 11: {
                    return this.clockLatchedDays;
                }
                case 12: {
                    return this.clockLatchedControl;
                }
            }
        }
        return 255;
    }

    public void setTimerByte(int n, int n2, int n3) {
        if (this.isTimerAddress(n) && this.mbc == 3) {
            switch (n2) {
                case 8: {
                    this.cycles = this.prevCycles;
                    this.clockSeconds = n3 & 0x3F;
                    break;
                }
                case 9: {
                    this.clockMinutes = n3 & 0x3F;
                    break;
                }
                case 10: {
                    this.clockHours = n3 & 0x1F;
                    break;
                }
                case 11: {
                    this.clockDays = n3;
                    break;
                }
                case 12: {
                    this.clockControl = n3;
                }
            }
            this.ramChanged = true;
        }
    }

    @Override
    public int getBank0() {
        if (this.wisdomTree) {
            return this.romBankOffset / 32768;
        }
        if (this.modeRAM) {
            return this.regROMBankNumber & ~this.mbc1bankMask & this.MASK_ROM_BANK;
        }
        return 0;
    }

    @Override
    public int getBank1() {
        return this.regROMBankNumber & this.MASK_ROM_BANK;
    }

    @Override
    public int getBank2() {
        return 0;
    }

    @Override
    public int getBank3() {
        return 0;
    }

    @Override
    public int getBank(int n) {
        if (n < 16384) {
            return this.getBank0();
        }
        if (n < 32768) {
            return this.getBank1();
        }
        if (n < 40960) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < 49152) {
            return this.getSRAMbank();
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public void setBank(int n, int n2) {
        if (n < 16384) {
            this.setBank0(n2);
        } else if (n < 32768) {
            this.setBank1(n2);
        } else if (n >= 40960 && n < 49152) {
            this.setSRAMbank(n2);
        }
    }

    @Override
    public int getBankSize() {
        return this.wisdomTree ? 32768 : 16384;
    }

    @Override
    public boolean isSRAMenabled() {
        return this.ramEnabled;
    }

    @Override
    public int getSRAMbank() {
        return this.regRAMBankNumber;
    }

    @Override
    public void setBank0(int n) {
        if (this.wisdomTree) {
            this.romBankOffset = n * 32768;
        }
    }

    @Override
    public void setBank1(int n) {
        if (this.mbc >= 1 && this.mbc <= 3 && n == 0) {
            n = 1;
        }
        this.regROMBankNumber = n;
        this.setROMBank(this.regROMBankNumber);
    }

    @Override
    public void setBank2(int n) {
    }

    @Override
    public void setBank3(int n) {
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.ramEnabled = bl;
    }

    @Override
    public void setSRAMbank(int n) {
        this.regRAMBankNumber = n;
        this.setRAMBank(this.regRAMBankNumber);
    }

    @Override
    public void shutdown() {
        if (this.hasBattery) {
            this.writeRAMtoFile();
        }
    }

    public static int calcHeaderChecksum(int[] nArray) {
        int n = 0;
        int n2 = 308;
        while (n2 < 333) {
            n += -nArray[n2] - 1;
            ++n2;
        }
        return n;
    }

    public boolean isHeaderChecksumValid() {
        return this.rom[333] == (GBCartridge.calcHeaderChecksum(this.rom) & 0xFF);
    }

    public static int[] getExpectedNintendoLogo() {
        int[] nArray = new int[48];
        nArray[0] = 206;
        nArray[1] = 237;
        nArray[2] = 102;
        nArray[3] = 102;
        nArray[4] = 204;
        nArray[5] = 13;
        nArray[7] = 11;
        nArray[8] = 3;
        nArray[9] = 115;
        nArray[11] = 131;
        nArray[13] = 12;
        nArray[15] = 13;
        nArray[17] = 8;
        nArray[18] = 17;
        nArray[19] = 31;
        nArray[20] = 136;
        nArray[21] = 137;
        nArray[23] = 14;
        nArray[24] = 220;
        nArray[25] = 204;
        nArray[26] = 110;
        nArray[27] = 230;
        nArray[28] = 221;
        nArray[29] = 221;
        nArray[30] = 217;
        nArray[31] = 153;
        nArray[32] = 187;
        nArray[33] = 187;
        nArray[34] = 103;
        nArray[35] = 99;
        nArray[36] = 110;
        nArray[37] = 14;
        nArray[38] = 236;
        nArray[39] = 204;
        nArray[40] = 221;
        nArray[41] = 220;
        nArray[42] = 153;
        nArray[43] = 159;
        nArray[44] = 187;
        nArray[45] = 185;
        nArray[46] = 51;
        nArray[47] = 62;
        return nArray;
    }

    public static int[] getExpectedAnaloguePocketLogo() {
        int[] nArray = new int[48];
        nArray[0] = 1;
        nArray[1] = 16;
        nArray[2] = 206;
        nArray[3] = 239;
        nArray[6] = 68;
        nArray[7] = 170;
        nArray[9] = 116;
        nArray[11] = 24;
        nArray[12] = 17;
        nArray[13] = 149;
        nArray[15] = 52;
        nArray[17] = 26;
        nArray[19] = 213;
        nArray[21] = 34;
        nArray[23] = 105;
        nArray[24] = 111;
        nArray[25] = 246;
        nArray[26] = 247;
        nArray[27] = 115;
        nArray[28] = 9;
        nArray[29] = 144;
        nArray[30] = 225;
        nArray[31] = 16;
        nArray[32] = 68;
        nArray[33] = 64;
        nArray[34] = 154;
        nArray[35] = 144;
        nArray[36] = 213;
        nArray[37] = 208;
        nArray[38] = 68;
        nArray[39] = 48;
        nArray[40] = 169;
        nArray[41] = 33;
        nArray[42] = 93;
        nArray[43] = 72;
        nArray[44] = 34;
        nArray[45] = 224;
        nArray[46] = 248;
        nArray[47] = 96;
        return nArray;
    }

    public boolean isHeaderLogoValid(boolean bl) {
        int[] nArray = bl ? GBCartridge.getExpectedAnaloguePocketLogo() : GBCartridge.getExpectedNintendoLogo();
        boolean bl2 = true;
        int n = 0;
        while (bl2 && n < nArray.length) {
            if (nArray[n] != this.rom[260 + n]) {
                bl2 = false;
            }
            ++n;
        }
        return bl2;
    }

    public boolean isHeaderLogoHalfValid() {
        int[] nArray = GBCartridge.getExpectedNintendoLogo();
        boolean bl = true;
        int n = 0;
        while (bl && n < nArray.length / 2) {
            if (nArray[n] != this.rom[260 + n]) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private boolean isMBC1multicart() {
        if (this.mbc != 1 || (this.rom.length - 1) / 16384 < 16) {
            return false;
        }
        int n = 1;
        while (n * 16 * 16384 < this.rom.length) {
            boolean bl = true;
            int n2 = 0;
            while (bl && n2 < 48) {
                int n3 = n * 16 * 16384 + 260 + n2;
                if (this.rom[n3] != this.rom[n3 & 0x3FFF]) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int[] getEntryPoint() {
        int[] nArray = new int[4];
        System.arraycopy(this.rom, 256, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getNintendoLogo() {
        int[] nArray = new int[48];
        System.arraycopy(this.rom, 260, nArray, 0, nArray.length);
        return nArray;
    }

    public String getTitle() {
        String string = "";
        int n = 0;
        while (n < 16) {
            if (this.rom[n + 308] == 0 || this.rom[n + 308] >= 128) break;
            string = String.valueOf(string) + (char)this.rom[n + 308];
            ++n;
        }
        return string;
    }

    public String getManufacturerCode() {
        String string = "";
        int n = 0;
        while (n < 4) {
            if (this.rom[n + 319] == 0) break;
            string = String.valueOf(string) + (char)this.rom[n + 319];
            ++n;
        }
        return string;
    }

    public boolean isDMGSupported() {
        return this.rom[323] != 192;
    }

    public boolean isCGBSupported() {
        return (this.rom[323] & 0x80) != 0;
    }

    public boolean isSGBSupported() {
        return this.rom[326] == 3;
    }

    public int getType() {
        if (this.rom.length > 327) {
            return this.rom[327];
        }
        return 0;
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return "ROM ONLY";
            }
            case 1: {
                return this.isMBC1multicart() ? "MBC1M" : "MBC1";
            }
            case 2: {
                return "MBC1+RAM";
            }
            case 3: {
                return "MBC1+RAM+BATTERY";
            }
            case 5: {
                return "MBC2";
            }
            case 6: {
                return "MBC2+BATTERY";
            }
            case 8: {
                return "ROM+RAM";
            }
            case 9: {
                return "ROM+RAM+BATTERY";
            }
            case 11: {
                return "MMM01";
            }
            case 12: {
                return "MMM01+RAM";
            }
            case 13: {
                return "MMM01+RAM+BATTERY";
            }
            case 15: {
                return "MBC3+TIMER+BATTERY";
            }
            case 16: {
                return "MBC3+TIMER+RAM+BATTERY";
            }
            case 17: {
                return "MBC3";
            }
            case 18: {
                return "MBC3+RAM";
            }
            case 19: {
                return "MBC3+RAM+BATTERY";
            }
            case 25: {
                return "MBC5";
            }
            case 26: {
                return "MBC5+RAM";
            }
            case 27: {
                return "MBC5+RAM+BATTERY";
            }
            case 28: {
                return "MBC5+RUMBLE";
            }
            case 29: {
                return "MBC5+RUMBLE+RAM";
            }
            case 30: {
                return "MBC5+RUMBLE+RAM+BATTERY";
            }
            case 32: {
                return "MBC6";
            }
            case 34: {
                return "MBC7+SENSOR+RUMBLE+RAM+BATTERY";
            }
            case 252: {
                return "POCKET CAMERA";
            }
            case 253: {
                return "BANDAI TAMA5";
            }
            case 254: {
                return "HuC3";
            }
            case 255: {
                return "HuC1+RAM+BATTERY";
            }
        }
        return "Unknown";
    }

    public int getROMSize() {
        if (this.rom[328] < 8) {
            return 32768 << this.rom[328];
        }
        if (this.rom[328] == 82) {
            return 0x120000;
        }
        if (this.rom[328] == 83) {
            return 0x140000;
        }
        if (this.rom[328] == 84) {
            return 0x180000;
        }
        return 0;
    }

    public int getRAMSize() {
        if (this.rom.length > 329) {
            switch (this.rom[329]) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 2048;
                }
                case 2: {
                    return 8192;
                }
                case 3: {
                    return 32768;
                }
                case 4: {
                    return 131072;
                }
                case 5: {
                    return 65536;
                }
            }
        }
        return 0;
    }

    public boolean isJapaneseRelease() {
        return this.rom[330] == 0;
    }

    public String getLicenseeCode() {
        if (this.rom[331] != 51) {
            return Character.toString((char)this.rom[331]);
        }
        String string = "";
        string = String.valueOf(string) + (char)this.rom[324];
        string = String.valueOf(string) + (char)this.rom[325];
        return string;
    }

    public int getGameVersion() {
        return this.rom[332];
    }

    private void setROMBank(int n) {
        this.romBankOffset = (n & this.MASK_ROM_BANK) * 16384 - 16384;
    }

    private void setRAMBank(int n) {
        if (n < this.ram.length / 8192) {
            this.ramBankOffset = n * 8192 - 40960;
        }
    }

    private boolean readRTC(FileInputStream fileInputStream) {
        byte[] byArray;
        block6: {
            try {
                byArray = new byte[48];
                if (fileInputStream.read(byArray) >= byArray.length) break block6;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        this.clockSeconds = byteBuffer.getInt();
        this.clockMinutes = byteBuffer.getInt();
        this.clockHours = byteBuffer.getInt();
        this.clockDays = byteBuffer.getInt();
        this.clockControl = byteBuffer.getInt();
        this.clockLatchedSeconds = byteBuffer.getInt();
        this.clockLatchedMinutes = byteBuffer.getInt();
        this.clockLatchedHours = byteBuffer.getInt();
        this.clockLatchedDays = byteBuffer.getInt();
        this.clockLatchedControl = byteBuffer.getInt();
        this.clockLastTime = new Date(byteBuffer.getLong() * 1000L);
        Date date = new Date();
        if (date.after(this.clockLastTime)) {
            int n = (int)((date.getTime() - this.clockLastTime.getTime()) / 1000L);
            this.clockSeconds += n;
            this.clockMinutes += this.clockSeconds / 60;
            this.clockSeconds %= 60;
            this.clockHours += this.clockMinutes / 60;
            this.clockMinutes %= 60;
            this.clockDays += this.clockHours / 24;
            this.clockHours %= 24;
            if (this.clockDays >= 256) {
                this.clockControl ^= 1;
                if ((this.clockControl & 1) == 0) {
                    this.clockControl |= 0x80;
                }
                this.clockDays &= 0xFF;
            }
        }
        this.clockLastTime = date;
        return true;
    }

    @Override
    public boolean readRAMfromFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[this.ram.length];
            fileInputStream.read(byArray);
            if (this.hasTimer) {
                this.readRTC(fileInputStream);
            }
            fileInputStream.close();
            int n = 0;
            while (n < this.ram.length) {
                this.ram[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    protected void writeRAMtoFile() {
        if (!this.ramChanged) {
            return;
        }
        try {
            File file = this.makeRAMfile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[this.ram.length];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)this.ram[n];
                ++n;
            }
            fileOutputStream.write(byArray);
            if (this.hasTimer) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(48).order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.putInt(this.clockSeconds);
                byteBuffer.putInt(this.clockMinutes);
                byteBuffer.putInt(this.clockHours);
                byteBuffer.putInt(this.clockDays);
                byteBuffer.putInt(this.clockControl);
                byteBuffer.putInt(this.clockLatchedSeconds);
                byteBuffer.putInt(this.clockLatchedMinutes);
                byteBuffer.putInt(this.clockLatchedHours);
                byteBuffer.putInt(this.clockLatchedDays);
                byteBuffer.putInt(this.clockLatchedControl);
                byteBuffer.putLong(this.clockLastTime.getTime() / 1000L);
                fileOutputStream.write(byteBuffer.array());
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.ramChanged = false;
    }

    @Override
    public boolean hasSRAM() {
        return this.ram != null && this.ram.length > 0;
    }

    public boolean hasTimer() {
        return this.hasTimer;
    }

    @Override
    public int[] getSRAM() {
        return this.ram;
    }

    @Override
    public void reset() {
        if (this.hasBattery) {
            this.writeRAMtoFile();
        }
        this.ramEnabled = false;
        this.romBankOffset = 0;
        this.regROMBankNumber = this.rom.length > 16384 ? 1 : 0;
        this.ramBankOffset = -40960;
    }

    @Override
    public int readByte(int n, int n2) {
        if (this.cheatHandler != null) {
            int n3;
            int n4;
            if (n == 64) {
                this.cheatHandler.applyCheats();
            }
            if ((n4 = this.cheatHandler.readCheat(n, n3 = this.doReadByte(n))) >= 0) {
                return n4;
            }
            return n3;
        }
        return this.doReadByte(n);
    }

    private int doReadByte(int n) {
        if (n < 16384) {
            if (this.wisdomTree) {
                return this.rom[n + this.romBankOffset];
            }
            if (this.modeRAM) {
                return this.rom[(this.regROMBankNumber & ~this.mbc1bankMask & this.MASK_ROM_BANK) * 16384 | n];
            }
            return this.rom[n];
        }
        if (n < 32768) {
            if (n + this.romBankOffset >= this.rom.length) {
                return 255;
            }
            return this.rom[n + this.romBankOffset];
        }
        if (this.mbc == 3) {
            switch (this.regRAMBankNumber) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 14: 
                case 15: {
                    return -1;
                }
                case 8: {
                    return this.clockLatchedSeconds;
                }
                case 9: {
                    return this.clockLatchedMinutes;
                }
                case 10: {
                    return this.clockLatchedHours;
                }
                case 11: {
                    return this.clockLatchedDays;
                }
                case 12: {
                    return this.clockLatchedControl;
                }
            }
        } else if (this.huc == 3) {
            switch (this.huc3mode) {
                case 0: 
                case 10: {
                    break;
                }
                case 12: {
                    if (this.huc3accessFlags == 2) {
                        return 1;
                    }
                    return this.huc3read;
                }
                case 13: {
                    return 1;
                }
                case 14: {
                    return 255;
                }
                default: {
                    return 1;
                }
            }
        }
        if (this.ramEnabled) {
            return this.ram[n + this.ramBankOffset & this.ram.length - 1];
        }
        return -1;
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        if (n < 32768) {
            block0 : switch (this.mbc) {
                case -1: {
                    switch (this.huc) {
                        case 1: {
                            this.processWriteHuC1(n, n2);
                            break block0;
                        }
                        case 3: {
                            this.processWriteHuC3(n, n2);
                        }
                    }
                    break;
                }
                case 0: {
                    if (this.wisdomTree) {
                        this.processWriteWisdomTree(n);
                        break;
                    }
                    this.fireNonStandardAddressWrite(n);
                    break;
                }
                case 1: {
                    this.processWriteMBC1(n, n2);
                    break;
                }
                case 2: {
                    this.processWriteMBC2(n, n2);
                    break;
                }
                case 3: {
                    this.processWriteMBC3(n, n2, n3);
                    break;
                }
                case 5: {
                    this.processWriteMBC5(n, n2);
                }
            }
        } else if (n >= 40960 && n < 49152) {
            if (this.mbc == 3) {
                switch (this.regRAMBankNumber) {
                    case 8: {
                        this.cycles = this.prevCycles;
                        this.clockSeconds = n2 & 0x3F;
                        break;
                    }
                    case 9: {
                        this.clockMinutes = n2 & 0x3F;
                        break;
                    }
                    case 10: {
                        this.clockHours = n2 & 0x1F;
                        break;
                    }
                    case 11: {
                        this.clockDays = n2;
                        break;
                    }
                    case 12: {
                        this.clockControl = n2;
                    }
                }
                this.ramChanged = true;
                if (this.regRAMBankNumber >= 8 && this.regRAMBankNumber <= 12) {
                    return;
                }
            } else if (this.huc == 3) {
                switch (this.huc3mode) {
                    case 11: {
                        switch (n2 >> 4) {
                            case 1: {
                                if (this.huc3accessIndex < 3) {
                                    this.huc3read = this.clockMinutes >> this.huc3accessIndex * 4 & 0xF;
                                } else if (this.huc3accessIndex < 7) {
                                    this.huc3read = this.clockDays >> (this.huc3accessIndex - 3) * 4 & 0xF;
                                }
                                ++this.huc3accessIndex;
                                break;
                            }
                            case 2: 
                            case 3: {
                                if (this.huc3accessIndex < 3) {
                                    this.clockMinutes &= this.clockMinutes & ~(15 << this.huc3accessIndex * 4) | (n2 & 0xF) << this.huc3accessIndex * 4;
                                } else if (this.huc3accessIndex < 7) {
                                    this.clockDays &= this.clockDays & ~(15 << (this.huc3accessIndex - 3) * 4) | (n2 & 0xF) << (this.huc3accessIndex - 3) * 4;
                                }
                                if (n2 >> 4 != 3) break;
                                ++this.huc3accessIndex;
                                break;
                            }
                            case 4: {
                                this.huc3accessIndex = this.huc3accessIndex & 0xF0 | n2 & 0xF;
                                break;
                            }
                            case 5: {
                                this.huc3accessIndex = n2 & 0xF0 | this.huc3accessIndex & 0xF;
                                break;
                            }
                            case 6: {
                                this.huc3accessFlags = n2 & 0xF;
                            }
                        }
                        return;
                    }
                    case 12: {
                        return;
                    }
                    case 13: {
                        return;
                    }
                    case 14: {
                        return;
                    }
                }
            }
            if (this.ramEnabled) {
                if (this.ram[n + this.ramBankOffset & this.ram.length - 1] != (this.ramMask ^ 0xFF | n2 & this.ramMask)) {
                    this.ramChanged = true;
                }
                this.ram[n + this.ramBankOffset & this.ram.length - 1] = this.ramMask ^ 0xFF | n2 & this.ramMask;
            }
        }
    }

    @Override
    public void update(int n) {
        if (this.hasTimer && (this.clockControl & 0x40) == 0) {
            this.cycles += n;
            this.updateRTC();
        }
    }

    private void processWriteMBC1(int n, int n2) {
        if ((n & 0x1EFF) != 0) {
            this.fireNonStandardAddressWrite(n);
        }
        switch (n >> 13) {
            case 0: {
                long l;
                if ((n2 & 0xF) != 10 && this.ramEnabled && this.hasBattery && (l = System.currentTimeMillis()) - this.lastWriteMillis >= 5000L) {
                    this.writeRAMtoFile();
                    this.lastWriteMillis = l;
                }
                this.ramEnabled = (n2 & 0xF) == 10 && this.ram.length > 0;
                break;
            }
            case 1: {
                if ((n2 &= 0x1F) == 0) {
                    n2 = 1;
                }
                this.regROMBankNumber = this.regROMBankNumber & ~this.mbc1bankMask | n2;
                this.setROMBank(this.regROMBankNumber);
                break;
            }
            case 2: {
                this.regRAMBankNumber = n2 & 3;
                this.regROMBankNumber = (n2 & 3) << this.mbc1bankShift | this.regROMBankNumber & this.mbc1bankMask;
                if (this.modeRAM) {
                    this.setRAMBank(this.regRAMBankNumber);
                }
                this.setROMBank(this.regROMBankNumber);
                break;
            }
            case 3: {
                if (this.modeRAM && (n2 & 1) == 0) {
                    this.setRAMBank(0);
                } else if (!this.modeRAM && (n2 & 1) != 0) {
                    this.setRAMBank(this.regRAMBankNumber);
                }
                this.modeRAM = (n2 & 1) != 0;
            }
        }
    }

    private void processWriteMBC2(int n, int n2) {
        if (n >> 14 == 0) {
            if ((n & 0x100) == 0) {
                long l;
                if ((n2 & 0xF) != 10 && this.ramEnabled && this.hasBattery && (l = System.currentTimeMillis()) - this.lastWriteMillis >= 5000L) {
                    this.writeRAMtoFile();
                    this.lastWriteMillis = l;
                }
                this.ramEnabled = (n2 & 0xF) == 10;
            } else {
                if ((n2 &= 0xF) == 0) {
                    n2 = 1;
                }
                this.regROMBankNumber = n2;
                this.setROMBank(this.regROMBankNumber);
            }
        }
    }

    private void processWriteMBC3(int n, int n2, int n3) {
        if ((n & 0x1FFF) != 0) {
            this.fireNonStandardAddressWrite(n);
        }
        switch (n >> 13) {
            case 0: {
                long l;
                if ((n2 & 0xF) != 10 && this.ramEnabled && this.hasBattery && (l = System.currentTimeMillis()) - this.lastWriteMillis >= 5000L) {
                    this.writeRAMtoFile();
                    this.lastWriteMillis = l;
                }
                this.ramEnabled = (n2 & 0xF) == 10 && this.ram.length > 0;
                break;
            }
            case 1: {
                if (n2 == 0) {
                    n2 = 1;
                }
                this.regROMBankNumber = n2;
                this.setROMBank(this.regROMBankNumber);
                break;
            }
            case 2: {
                this.regRAMBankNumber = n2 & 0xF;
                this.setRAMBank(this.regRAMBankNumber & 3);
                break;
            }
            case 3: {
                if (!this.hasTimer) break;
                this.update(n3);
                if ((this.clockControl & 0x40) == 0) {
                    this.cycles -= n3;
                }
                this.clockLastTime = new Date();
                this.clockLatchedSeconds = this.clockSeconds;
                this.clockLatchedMinutes = this.clockMinutes;
                this.clockLatchedHours = this.clockHours;
                this.clockLatchedDays = this.clockDays;
                this.clockLatchedControl = this.clockControl & 0xC1;
            }
        }
    }

    private void updateRTC() {
        long l = (this.cycles - this.prevCycles) / 0x400000;
        if (l > 0L) {
            this.prevCycles = this.cycles;
            this.clockSeconds = (int)((long)this.clockSeconds + l % 60L & 0x3FL);
            if (this.clockSeconds == 60) {
                this.clockSeconds = 0;
                this.clockMinutes = this.clockMinutes + 1 & 0x3F;
                if (this.clockMinutes == 60) {
                    this.clockMinutes = 0;
                    this.clockHours = this.clockHours + 1 & 0x1F;
                    if (this.clockHours == 24) {
                        this.clockHours = 0;
                        if (++this.clockDays >= 256) {
                            this.clockDays = 0;
                            this.clockControl ^= 1;
                            if ((this.clockControl & 1) == 0) {
                                this.clockControl |= 0x80;
                            }
                        }
                    }
                }
            }
        }
    }

    private void processWriteMBC5(int n, int n2) {
        switch (n >> 13) {
            case 0: {
                long l;
                if ((n & 0x1FFF) != 0) {
                    this.fireNonStandardAddressWrite(n);
                }
                if ((n2 & 0xF) != 10 && this.ramEnabled && this.hasBattery && (l = System.currentTimeMillis()) - this.lastWriteMillis >= 5000L) {
                    this.writeRAMtoFile();
                    this.lastWriteMillis = l;
                }
                this.ramEnabled = (n2 & 0xF) == 10 && this.ram.length > 0;
                break;
            }
            case 1: {
                if ((n & 0xFFF) != 0) {
                    this.fireNonStandardAddressWrite(n);
                }
                this.regROMBankNumber = (n & 0x1000) != 0 ? (n2 & 1) << 8 | this.regROMBankNumber & 0xFF : this.regROMBankNumber & 0x100 | n2;
                this.setROMBank(this.regROMBankNumber);
                break;
            }
            case 2: {
                if ((n & 0x1FFF) != 0) {
                    this.fireNonStandardAddressWrite(n);
                }
                if (this.hasRumble) {
                    n2 &= 7;
                }
                this.regRAMBankNumber = n2 & 0xF;
                this.setRAMBank(this.regRAMBankNumber);
                break;
            }
            case 3: {
                this.fireNonStandardAddressWrite(n);
            }
        }
    }

    private void processWriteHuC1(int n, int n2) {
        switch (n >> 13) {
            case 0: {
                long l;
                if ((n2 & 0xF) == 14 && this.ramEnabled && this.hasBattery && (l = System.currentTimeMillis()) - this.lastWriteMillis >= 5000L) {
                    this.writeRAMtoFile();
                    this.lastWriteMillis = l;
                }
                this.ramEnabled = (n2 & 0xF) != 14;
                break;
            }
            case 1: {
                this.regROMBankNumber = n2;
                this.setROMBank(this.regROMBankNumber);
                break;
            }
            case 2: {
                this.regRAMBankNumber = n2;
                this.setRAMBank(this.regRAMBankNumber);
            }
        }
    }

    private void processWriteHuC3(int n, int n2) {
        switch (n >> 13) {
            case 0: {
                long l;
                if ((n2 & 0xF) != 10 && this.ramEnabled && this.hasBattery && (l = System.currentTimeMillis()) - this.lastWriteMillis >= 5000L) {
                    this.writeRAMtoFile();
                    this.lastWriteMillis = l;
                }
                this.huc3mode = n2 & 0xF;
                this.ramEnabled = this.huc3mode == 10;
                break;
            }
            case 1: {
                this.regROMBankNumber = n2;
                this.setROMBank(this.regROMBankNumber);
                break;
            }
            case 2: {
                this.regRAMBankNumber = n2;
                this.setRAMBank(this.regRAMBankNumber);
            }
        }
    }

    private void processWriteWisdomTree(int n) {
        int n2 = n & this.MASK_ROM_BANK >> 1;
        this.romBankOffset = n2 * 32768;
    }

    int[] getMBCwrites() {
        switch (this.mbc) {
            case 1: {
                int[] nArray = new int[8];
                nArray[1] = this.ramEnabled ? 10 : 0;
                nArray[2] = 8192;
                nArray[3] = this.regROMBankNumber;
                nArray[4] = 16384;
                nArray[5] = this.regRAMBankNumber;
                nArray[6] = 24576;
                nArray[7] = this.modeRAM ? 1 : 0;
                return nArray;
            }
            case 2: {
                int[] nArray = new int[4];
                nArray[1] = this.ramEnabled ? 10 : 0;
                nArray[2] = 256;
                nArray[3] = this.regROMBankNumber;
                return nArray;
            }
            case 3: {
                int[] nArray = new int[8];
                nArray[1] = this.ramEnabled ? 10 : 0;
                nArray[2] = 8192;
                nArray[3] = this.regROMBankNumber;
                nArray[4] = 16384;
                nArray[5] = this.regRAMBankNumber;
                nArray[6] = 24576;
                return nArray;
            }
            case 5: {
                int[] nArray = new int[8];
                nArray[1] = this.ramEnabled ? 10 : 0;
                nArray[2] = 8192;
                nArray[3] = this.regROMBankNumber & 0xFF;
                nArray[4] = 12288;
                nArray[5] = this.regROMBankNumber >> 8;
                nArray[6] = 16384;
                nArray[7] = this.regRAMBankNumber;
                return nArray;
            }
        }
        return null;
    }

    public State getState() {
        return new UnmodifiableRegularState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public WriteBasedState toWriteBased() {
                return new WriteBasedStateClone(this);
            }

            @Override
            public int getROMBankNumber() {
                return GBCartridge.this.regROMBankNumber;
            }

            @Override
            public int getRAMBankNumber() {
                return GBCartridge.this.regRAMBankNumber;
            }

            @Override
            public boolean isModeRam() {
                return GBCartridge.this.modeRAM;
            }

            @Override
            public boolean isRamEnabled() {
                return GBCartridge.this.ramEnabled;
            }

            @Override
            public int[] getRAM() {
                return GBCartridge.this.ram;
            }

            @Override
            public int getClockCycles() {
                return GBCartridge.this.cycles - GBCartridge.this.prevCycles;
            }

            @Override
            public int getClockSeconds() {
                return GBCartridge.this.clockSeconds;
            }

            @Override
            public int getClockMinutes() {
                return GBCartridge.this.clockMinutes;
            }

            @Override
            public int getClockHours() {
                return GBCartridge.this.clockHours;
            }

            @Override
            public int getClockDays() {
                return GBCartridge.this.clockDays;
            }

            @Override
            public int getClockControl() {
                return GBCartridge.this.clockControl;
            }

            @Override
            public int getClockLatchedSeconds() {
                return GBCartridge.this.clockLatchedSeconds;
            }

            @Override
            public int getClockLatchedMinutes() {
                return GBCartridge.this.clockLatchedMinutes;
            }

            @Override
            public int getClockLatchedHours() {
                return GBCartridge.this.clockLatchedHours;
            }

            @Override
            public int getClockLatchedDays() {
                return GBCartridge.this.clockLatchedDays;
            }

            @Override
            public int getClockLatchedControl() {
                return GBCartridge.this.clockLatchedControl;
            }

            @Override
            public Date getClockLastTime() {
                return GBCartridge.this.clockLastTime;
            }
        };
    }

    public void setState(State state, boolean bl) {
        if (state instanceof WriteBasedState) {
            WriteBasedState writeBasedState = (WriteBasedState)state;
            int[] nArray = writeBasedState.getWrites();
            if (nArray != null) {
                int n = 0;
                while (n < nArray.length) {
                    this.processWrite(nArray[n], nArray[n + 1], 0);
                    n += 2;
                }
            }
        } else if (state instanceof RegularState) {
            RegularState regularState = (RegularState)state;
            this.setBank1(regularState.getROMBankNumber());
            this.setSRAMbank(regularState.getRAMBankNumber());
            this.modeRAM = regularState.isModeRam();
            this.ramEnabled = regularState.isRamEnabled();
            this.prevCycles = 0;
            this.cycles = regularState.getClockCycles();
        }
        if (!(bl && !this.ramEnabled && this.hasBattery || state.getRAM() == null)) {
            System.arraycopy(state.getRAM(), 0, this.ram, 0, Math.min(this.ram.length, state.getRAM().length));
        }
    }

    public static interface RegularState
    extends State {
        public int getROMBankNumber();

        public int getRAMBankNumber();

        public boolean isModeRam();

        public boolean isRamEnabled();
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public WriteBasedState toWriteBased();

        public int[] getRAM();

        public int getClockCycles();

        public int getClockSeconds();

        public int getClockMinutes();

        public int getClockHours();

        public int getClockDays();

        public int getClockControl();

        public int getClockLatchedSeconds();

        public int getClockLatchedMinutes();

        public int getClockLatchedHours();

        public int getClockLatchedDays();

        public int getClockLatchedControl();

        public Date getClockLastTime();
    }

    private class StateClone
    implements RegularState {
        private int regROMBankNumber;
        private int regRAMBankNumber;
        private boolean modeRAM;
        private boolean ramEnabled;
        private int clockCycles;
        private int clockSeconds;
        private int clockMinutes;
        private int clockHours;
        private int clockDays;
        private int clockControl;
        private int clockLatchedSeconds;
        private int clockLatchedMinutes;
        private int clockLatchedHours;
        private int clockLatchedDays;
        private int clockLatchedControl;
        private Date clockLastTime;
        private final int[] ram;

        public StateClone(State state) {
            this.ram = new int[state.getRAM().length];
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            RegularState regularState = (RegularState)state;
            this.regROMBankNumber = regularState.getROMBankNumber();
            this.regRAMBankNumber = regularState.getRAMBankNumber();
            this.modeRAM = regularState.isModeRam();
            this.ramEnabled = regularState.isRamEnabled();
            System.arraycopy(state.getRAM(), 0, this.ram, 0, this.ram.length);
            this.clockCycles = state.getClockCycles();
            this.clockSeconds = state.getClockSeconds();
            this.clockMinutes = state.getClockMinutes();
            this.clockHours = state.getClockHours();
            this.clockDays = state.getClockDays();
            this.clockControl = state.getClockControl();
            this.clockLatchedSeconds = state.getClockLatchedSeconds();
            this.clockLatchedMinutes = state.getClockLatchedMinutes();
            this.clockLatchedHours = state.getClockLatchedHours();
            this.clockLatchedDays = state.getClockLatchedDays();
            this.clockLatchedControl = state.getClockLatchedControl();
            this.clockLastTime = state.getClockLastTime();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public WriteBasedState toWriteBased() {
            return new WriteBasedStateClone(this);
        }

        @Override
        public int getROMBankNumber() {
            return this.regROMBankNumber;
        }

        @Override
        public int getRAMBankNumber() {
            return this.regRAMBankNumber;
        }

        @Override
        public boolean isModeRam() {
            return this.modeRAM;
        }

        @Override
        public boolean isRamEnabled() {
            return this.ramEnabled;
        }

        @Override
        public int[] getRAM() {
            return this.ram;
        }

        @Override
        public int getClockCycles() {
            return this.clockCycles;
        }

        @Override
        public int getClockSeconds() {
            return this.clockSeconds;
        }

        @Override
        public int getClockMinutes() {
            return this.clockMinutes;
        }

        @Override
        public int getClockHours() {
            return this.clockHours;
        }

        @Override
        public int getClockDays() {
            return this.clockDays;
        }

        @Override
        public int getClockControl() {
            return this.clockControl;
        }

        @Override
        public int getClockLatchedSeconds() {
            return this.clockLatchedSeconds;
        }

        @Override
        public int getClockLatchedMinutes() {
            return this.clockLatchedMinutes;
        }

        @Override
        public int getClockLatchedHours() {
            return this.clockLatchedHours;
        }

        @Override
        public int getClockLatchedDays() {
            return this.clockLatchedDays;
        }

        @Override
        public int getClockLatchedControl() {
            return this.clockLatchedControl;
        }

        @Override
        public Date getClockLastTime() {
            return this.clockLastTime;
        }
    }

    public static abstract class UnmodifiableRegularState
    implements RegularState {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }

    public static abstract class UnmodifiableWriteBasedState
    implements WriteBasedState {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }

    public static interface WriteBasedState
    extends State {
        public int[] getWrites();
    }

    private class WriteBasedStateClone
    extends StateClone
    implements WriteBasedState {
        private final int[] writes;

        public WriteBasedStateClone(State state) {
            super(state);
            this.writes = GBCartridge.this.getMBCwrites();
        }

        @Override
        public WriteBasedState toWriteBased() {
            return this;
        }

        @Override
        public int[] getWrites() {
            return this.writes;
        }
    }
}

