/*
 * Decompiled with CFR 0.152.
 */
package cheats;

import cheats.Cheat;
import cheats.CheatModel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public final class BizHawkCheats {
    private BizHawkCheats() {
    }

    public static void from(File file, CheatModel cheatModel) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    BizHawkCheat bizHawkCheat = new BizHawkCheat(string.split("\t"));
                    cheatModel.addCheat(bizHawkCheat);
                    if (bizHawkCheat.isActive()) {
                        cheatModel.setActive(bizHawkCheat, true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String sizeToString(int n) {
        switch (n) {
            case 4: {
                return "d";
            }
            case 2: {
                return "w";
            }
            case 1: {
                return "b";
            }
        }
        return "b";
    }

    public static void writeTo(File file, CheatModel cheatModel) {
        if (cheatModel != null && cheatModel.getCheatCount() > 0) {
            try {
                PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                int n = 0;
                while (n < cheatModel.getCheatCount()) {
                    Cheat cheat = cheatModel.getCheat(n);
                    printStream.print(String.format("%04x", cheat.getAddress()));
                    printStream.print(String.format("\t%02x", cheat.getValue()));
                    printStream.print(cheat.getCompare() < 0 ? "\tN" : String.format("\t%02x", cheat.getCompare()));
                    printStream.print("\t" + cheat.getDomain());
                    printStream.print("\t" + (cheatModel.isActive(cheat) ? "1" : "0"));
                    printStream.print("\t" + cheat.getName());
                    printStream.print("\t" + BizHawkCheats.sizeToString(cheat.getSize()));
                    printStream.print("\t" + cheat.getDisplayType());
                    printStream.print("\t" + (cheat.isBigEndian() ? "1" : "0"));
                    printStream.print("\t" + (Object)((Object)cheat.getComparator()));
                    printStream.println();
                    ++n;
                }
                printStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    private static class BizHawkCheat
    implements Cheat {
        private final int address;
        private final int value;
        private final int compare;
        private final String domain;
        private final boolean active;
        private final String name;
        private final int size;
        private final String displayType;
        private final boolean bigEndian;
        private final Cheat.Comparator comparator;

        public BizHawkCheat(String[] stringArray) {
            this(Integer.parseInt(stringArray[0], 16), Integer.parseInt(stringArray[1], 16), BizHawkCheat.parseCompare(stringArray[2]), stringArray[3], Integer.parseInt(stringArray[4]) != 0, stringArray[5], BizHawkCheat.parseSize(stringArray[6]), stringArray[7], Integer.parseInt(stringArray[8]) != 0, Cheat.Comparator.from(stringArray[9]));
        }

        public BizHawkCheat(int n, int n2, int n3, String string, boolean bl, String string2, int n4, String string3, boolean bl2, Cheat.Comparator comparator) {
            this.address = n;
            this.value = n2;
            this.compare = n3;
            this.domain = string;
            this.active = bl;
            this.name = string2;
            this.size = n4;
            this.displayType = string3;
            this.bigEndian = bl2;
            this.comparator = comparator;
        }

        private static int parseCompare(String string) {
            try {
                return Integer.parseInt(string, 16);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        private static int parseSize(String string) {
            switch (string.charAt(0)) {
                case 'b': {
                    return 1;
                }
                case 'w': {
                    return 2;
                }
                case 'd': {
                    return 4;
                }
            }
            throw new IllegalArgumentException("Unknown size: " + string.charAt(0));
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public int getCompare() {
            return this.compare;
        }

        @Override
        public Cheat.Comparator getComparator() {
            return this.comparator;
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public String getDisplayType() {
            return this.displayType;
        }

        @Override
        public boolean isBigEndian() {
            return this.bigEndian;
        }
    }
}

