/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.Z80Instruction;

public class LR35902Instruction
extends Z80Instruction {
    private static final LR35902Instruction[] instructionsSwap = new LR35902Instruction[8];
    private static final LR35902Instruction[] instructions = new LR35902Instruction[256];

    protected LR35902Instruction(int n, int n2, int n3) {
        super(n, 0, 256, n2, n3);
    }

    protected LR35902Instruction(int n, int n2) {
        super(n, n2);
    }

    public static LR35902Instruction getInstance(int n, int n2, int n3) {
        return new LR35902Instruction(n, n2, n3);
    }

    public static Z80Instruction getInstance(int n, int n2) {
        if (n2 == 203 && (n & 0xF8) == 48) {
            if (instructionsSwap[n & 7] == null) {
                LR35902Instruction.instructionsSwap[n & 7] = new LR35902Instruction(n, 203);
            }
            return instructionsSwap[n & 7];
        }
        return Z80Instruction.getInstance(n, n2);
    }

    public static LR35902Instruction getInstance(int n) {
        if (instructions[n] == null) {
            LR35902Instruction.instructions[n] = new LR35902Instruction(n, -1073741824, 0);
        }
        return instructions[n];
    }

    public static Z80Instruction parse(int[] nArray, int n) {
        int n2 = n;
        int n3 = nArray[n++];
        int n4 = -1073741824;
        switch (n3) {
            case 8: {
                n4 = nArray[n++] | nArray[n++] << 8;
                break;
            }
            case 16: 
            case 34: 
            case 42: 
            case 50: 
            case 58: 
            case 217: {
                break;
            }
            case 224: {
                n4 = nArray[n++];
                break;
            }
            case 226: {
                break;
            }
            case 232: {
                n4 = (byte)nArray[n++];
                break;
            }
            case 233: {
                break;
            }
            case 234: {
                n4 = nArray[n++] | nArray[n++] << 8;
                break;
            }
            case 240: {
                n4 = nArray[n++];
                break;
            }
            case 242: 
            case 244: {
                break;
            }
            case 248: {
                n4 = (byte)nArray[n++];
                break;
            }
            case 250: {
                n4 = nArray[n++] | nArray[n++] << 8;
                break;
            }
            case 211: 
            case 219: 
            case 221: 
            case 227: 
            case 228: 
            case 235: 
            case 236: 
            case 237: 
            case 252: 
            case 253: {
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                break;
            }
            case 198: 
            case 206: 
            case 214: 
            case 222: {
                n4 = nArray[n++];
                break;
            }
            case 203: {
                n3 = nArray[n];
                if ((n3 & 0xF8) == 48) {
                    if (instructionsSwap[n3 & 7] == null) {
                        LR35902Instruction.instructionsSwap[n3 & 7] = new LR35902Instruction(n3, 203);
                    }
                    return instructionsSwap[n3 & 7];
                }
            }
            default: {
                return Z80Instruction.parse(nArray, n2);
            }
        }
        return n - n2 == 1 ? LR35902Instruction.getInstance(n3) : LR35902Instruction.getInstance(n3, n4, n - n2 - 1);
    }

    @Override
    public boolean hasDestination() {
        switch (this.opCode) {
            case 8: 
            case 224: 
            case 234: 
            case 240: 
            case 250: {
                return true;
            }
            case 16: 
            case 34: 
            case 42: 
            case 50: 
            case 58: 
            case 211: 
            case 217: 
            case 219: 
            case 221: 
            case 226: 
            case 227: 
            case 228: 
            case 232: 
            case 235: 
            case 236: 
            case 237: 
            case 242: 
            case 244: 
            case 248: 
            case 252: 
            case 253: {
                return false;
            }
        }
        return super.hasDestination();
    }

    @Override
    public int getDestination(int n, int n2) {
        switch (this.opCode) {
            case 224: 
            case 240: {
                return 65280 + this.arg;
            }
            case 8: 
            case 16: 
            case 34: 
            case 42: 
            case 50: 
            case 58: 
            case 211: 
            case 217: 
            case 219: 
            case 221: 
            case 226: 
            case 227: 
            case 228: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 242: 
            case 244: 
            case 248: 
            case 250: 
            case 252: 
            case 253: {
                return this.arg;
            }
        }
        return super.getDestination(n, n2);
    }

    @Override
    public boolean isRet() {
        return (this.opCode & 0xFFFF) == 201 || (this.opCode & 0xFFFF) == 217 || (this.opCode & 0xFFE7) == 192;
    }

    @Override
    public boolean isJump() {
        return (this.opCode & 0xFFFF) == 195 || (this.opCode & 0xFFFF) == 233 || (this.opCode & 0xFFE7) == 194 || (this.opCode & 0xFFFF) == 24 || (this.opCode & 0xFFE7) == 32;
    }

    @Override
    public boolean isConditional() {
        return (this.opCode & 0xFFE7) == 32 || (this.opCode & 0xFFE3) == 192 || (this.opCode & 0xFFE7) == 194;
    }

    @Override
    public boolean isMemoryRead() {
        return this.opCode == 250 || this.opCode == 242 || this.opCode == 240 || super.isMemoryRead();
    }

    @Override
    public boolean isMemoryWrite() {
        return this.opCode == 234 || this.opCode == 226 || this.opCode == 224 || super.isMemoryWrite();
    }

    @Override
    public int getMemoryAccessRegister() {
        if (this.opCode >= 224) {
            return -1;
        }
        return super.getMemoryAccessRegister();
    }

    @Override
    public int getMemoryAccessSize() {
        return this.isMemoryAccess() ? 1 : 0;
    }

    @Override
    public boolean isPortRead() {
        return (this.opCode & 0xFFFF) == 240 && (this.arg < 128 || this.arg == 255) || (this.opCode & 0xFFFF) == 242;
    }

    @Override
    public boolean isPortWrite() {
        return (this.opCode & 0xFFFF) == 224 && (this.arg < 128 || this.arg == 255) || (this.opCode & 0xFFFF) == 226;
    }

    @Override
    public boolean isValid() {
        switch (this.opCode) {
            case 211: 
            case 219: 
            case 221: 
            case 227: 
            case 228: 
            case 235: 
            case 236: 
            case 237: 
            case 244: 
            case 252: 
            case 253: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String buildString() {
        if ((this.opCode & 0xFFF8) == 128) {
            return "add " + this.registerToString(this.opCode);
        }
        if ((this.opCode & 0xFFF8) == 136) {
            return "adc " + this.registerToString(this.opCode);
        }
        if ((this.opCode & 0xFFF8) == 152) {
            return "sbc " + this.registerToString(this.opCode);
        }
        if (this.opCode == 198) {
            return "add " + LR35902Instruction.toHexString(this.arg, 1);
        }
        if (this.opCode == 206) {
            return "adc " + LR35902Instruction.toHexString(this.arg, 1);
        }
        if (this.opCode == 222) {
            return "sbc " + LR35902Instruction.toHexString(this.arg, 1);
        }
        switch (this.opCode) {
            case 8: {
                return "ld (" + LR35902Instruction.toHexString(this.arg, 2) + "), sp";
            }
            case 16: {
                return "stop";
            }
            case 34: {
                return "ldi (hl), a";
            }
            case 42: {
                return "ldi a, (hl)";
            }
            case 50: {
                return "ldd (hl), a";
            }
            case 58: {
                return "ldd a, (hl)";
            }
            case 211: {
                return String.valueOf(String.format("%02x", this.opCode)) + (this.arg > Integer.MIN_VALUE ? String.format(" %02x", this.arg & 0xFF) : "");
            }
            case 217: {
                return "reti";
            }
            case 219: 
            case 221: {
                return String.valueOf(String.format("%02x", this.opCode)) + (this.arg > Integer.MIN_VALUE ? String.format(" %02x", this.arg & 0xFF) : "");
            }
            case 224: {
                return "ldh (" + LR35902Instruction.toHexString(this.arg, 1) + "), a";
            }
            case 226: {
                return "ldh (c), a";
            }
            case 227: 
            case 228: {
                return String.valueOf(String.format("%02x", this.opCode)) + (this.arg > Integer.MIN_VALUE ? String.format(" %02x", this.arg & 0xFF) : "");
            }
            case 232: {
                return "add sp, " + this.arg;
            }
            case 233: {
                return "jp hl";
            }
            case 234: {
                return "ld (" + LR35902Instruction.toHexString(this.arg, 2) + "), a";
            }
            case 235: 
            case 236: 
            case 237: {
                return String.valueOf(String.format("%02x", this.opCode)) + (this.arg > Integer.MIN_VALUE ? String.format(" %02x", this.arg & 0xFF) : "");
            }
            case 240: {
                return "ldh a, (" + LR35902Instruction.toHexString(this.arg, 1) + ")";
            }
            case 242: {
                return "ldh a, (c)";
            }
            case 244: {
                return String.valueOf(String.format("%02x", this.opCode)) + (this.arg > Integer.MIN_VALUE ? String.format(" %02x", this.arg & 0xFF) : "");
            }
            case 248: {
                return "ld hl, sp+" + this.arg;
            }
            case 250: {
                return "ld a, (" + LR35902Instruction.toHexString(this.arg, 2) + ")";
            }
            case 252: {
                return String.valueOf(String.format("%02x", this.opCode)) + (this.arg > Integer.MIN_VALUE ? String.format(" %02x", this.arg & 0xFF) : "");
            }
        }
        if ((this.opCode & 0xFFF8) == 52016) {
            return "swap " + this.registerToString(this.opCode & 7);
        }
        return super.buildString();
    }

    public static /* bridge */ /* synthetic */ Z80Instruction getInstance(int n) {
        return LR35902Instruction.getInstance(n);
    }

    public static /* bridge */ /* synthetic */ Z80Instruction getInstance(int n, int n2, int n3) {
        return LR35902Instruction.getInstance(n, n2, n3);
    }
}

