/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.LiteralElement;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SimpleAttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import com.sun.org.apache.xml.internal.serializer.ElemDesc;

final class LiteralAttribute
extends Instruction {
    private final String _name;
    private final AttributeValue _value;

    public LiteralAttribute(String string, String string2, Parser parser, SyntaxTreeNode syntaxTreeNode) {
        this._name = string;
        this.setParent(syntaxTreeNode);
        this._value = AttributeValue.create(this, string2, parser);
    }

    @Override
    public void display(int n) {
        this.indent(n);
        Util.println("LiteralAttribute name=" + this._name + " value=" + this._value);
    }

    @Override
    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        this._value.typeCheck(symbolTable);
        this.typeCheckContents(symbolTable);
        return Type.Void;
    }

    @Override
    protected boolean contextDependent() {
        return this._value.contextDependent();
    }

    @Override
    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new PUSH(constantPoolGen, this._name));
        this._value.translate(classGenerator, methodGenerator);
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        if (syntaxTreeNode instanceof LiteralElement && ((LiteralElement)syntaxTreeNode).allAttributesUnique()) {
            String string;
            int n = 0;
            boolean bl = false;
            ElemDesc elemDesc = ((LiteralElement)syntaxTreeNode).getElemDesc();
            if (elemDesc != null) {
                if (elemDesc.isAttrFlagSet(this._name, 4)) {
                    n |= 2;
                    bl = true;
                } else if (elemDesc.isAttrFlagSet(this._name, 2)) {
                    n |= 4;
                }
            }
            if (this._value instanceof SimpleAttributeValue && !this.hasBadChars(string = ((SimpleAttributeValue)this._value).toString()) && !bl) {
                n |= 1;
            }
            instructionList.append(new PUSH(constantPoolGen, n));
            instructionList.append(methodGenerator.uniqueAttribute());
        } else {
            instructionList.append(methodGenerator.attribute());
        }
    }

    private boolean hasBadChars(String string) {
        for (char c : string.toCharArray()) {
            if (c >= ' ' && '~' >= c && c != '<' && c != '>' && c != '&' && c != '\"') continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public AttributeValue getValue() {
        return this._value;
    }
}

