/*
 * Decompiled with CFR 0.152.
 */
package treetable;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import treetable.TreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel
implements TreeExpansionListener,
TreeModelListener {
    private final JTree tree;
    private final TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
        this.tree = jTree;
        this.treeTableModel = treeTableModel;
    }

    public void installTreeListeners() {
        this.tree.addTreeExpansionListener(this);
        this.treeTableModel.addTreeModelListener(this);
    }

    public void uninstallTreeListeners() {
        this.tree.removeTreeExpansionListener(this);
        this.treeTableModel.removeTreeModelListener(this);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return TreeTableModel.class;
        }
        return this.treeTableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.nodeForRow(n);
        }
        return this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.fireTableDataChanged();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.fireTableDataChanged();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (this.tree.isExpanded(treeModelEvent.getTreePath())) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.tree.isExpanded(treeModelEvent.getTreePath())) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.tree.isExpanded(treeModelEvent.getTreePath())) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.tree.isExpanded(treeModelEvent.getTreePath())) {
            this.fireTableDataChanged();
        }
    }
}

