/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.input.AbstractButtonInputProvider;
import components.input.PointerInputProvider;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.BitSet;
import jinput.JInputHandler;
import platform.DisplayWindow;

public class GamepadInput
extends AbstractButtonInputProvider
implements PointerInputProvider {
    private final BitSet keys = new BitSet();
    private final int controller;
    private final float width;
    private final float height;
    private float x;
    private float y;
    private final BitSet mappedButtons = new BitSet();
    private int[][] buttonMap = new int[2][38];
    private boolean requireWindowFocus;

    public GamepadInput(DisplayWindow displayWindow, int n) {
        Component component;
        this.controller = n;
        this.width = 288.0f;
        this.height = 256.0f;
        this.x = this.width / 2.0f;
        this.y = this.height / 2.0f;
        DisplayWindow displayWindow2 = component = displayWindow;
        while (component != null) {
            displayWindow2 = component;
            component = component.getParent();
        }
        final DisplayWindow displayWindow3 = displayWindow2;
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!GamepadInput.this.requireWindowFocus || displayWindow3.isFocusOwner()) {
                    GamepadInput.this.keys.set(keyEvent.getKeyCode());
                    if (GamepadInput.this.mappedButtons.get(keyEvent.getKeyCode())) {
                        GamepadInput.this.fireButtonPressed();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                GamepadInput.this.keys.clear(keyEvent.getKeyCode());
            }
        };
        JInputHandler.addKeyListener(n, keyAdapter);
    }

    @Override
    public int[] getButtonMap(int n) {
        return (int[])this.buttonMap[n].clone();
    }

    @Override
    public void setButtonMap(int[][] nArray) {
        this.mappedButtons.clear();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length && n < this.buttonMap.length) {
                if (nArray[n] != null) {
                    this.buttonMap[n] = (int[])nArray[n].clone();
                    int n2 = 0;
                    while (n2 < nArray[n].length) {
                        int n3 = nArray[n][n2];
                        if (n3 >= 0) {
                            this.mappedButtons.set(n3);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public boolean isRequireWindowFocus() {
        return this.requireWindowFocus;
    }

    @Override
    public void setRequireWindowFocus(boolean bl) {
        this.requireWindowFocus = bl;
    }

    private boolean isButtonDown(int n, int n2) {
        if (n2 < this.buttonMap[n].length && this.buttonMap[n][n2] >= 0) {
            return this.keys.get(this.buttonMap[n][n2]);
        }
        return false;
    }

    @Override
    public boolean isButtonDown(int n) {
        return this.isButtonDown(0, n) || this.isButtonDown(1, n);
    }

    private void updatePosition() {
        float f;
        float f2 = JInputHandler.getX(this.controller);
        if (Math.abs(f2) >= 0.15f) {
            this.x += f2 * 5.0f;
            if (this.x < 0.0f) {
                this.x = 0.0f;
            }
            if (this.x >= this.width) {
                this.x = this.width;
            }
        }
        if (Math.abs(f = JInputHandler.getY(this.controller)) >= 0.15f) {
            this.y += f * 5.0f;
            if (this.y < 0.0f) {
                this.y = 0.0f;
            }
            if (this.y >= this.height) {
                this.y = this.height;
            }
        }
    }

    @Override
    public int getX() {
        return Math.round(this.x);
    }

    @Override
    public int getY() {
        return Math.round(this.y);
    }

    @Override
    public boolean isOnScreen() {
        return true;
    }

    @Override
    public void frameFinished() {
        this.updatePosition();
    }
}

