/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import components.OutputListener;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;

public class SN76489 {
    public static final int SIGNATURE = 0x220000;
    public static final int REGISTER_WRITE = 0x220000;
    public static final int STEREO_WRITE = 0x220001;
    public static final int UPDATE = 2228351;
    private static final int[][] VOLUME_LEVELS;
    private final int[] volumeLevels;
    private final int CYCLES_PER_SECOND;
    private final int FRAMES_PER_SECOND;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    private final int[] regVolume = new int[4];
    private final int[] regTone = new int[3];
    private int regNoise;
    private int regStereo = 255;
    private final int[] counter = new int[4];
    private final int[] samples = new int[4];
    private final int[] direction = new int[4];
    private int randomNumber;
    private int regLinearFeedbackShift;
    private int latchedRegister;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[16];
        nArray[0] = 2827;
        nArray[1] = 2246;
        nArray[2] = 1784;
        nArray[3] = 1417;
        nArray[4] = 1126;
        nArray[5] = 894;
        nArray[6] = 710;
        nArray[7] = 564;
        nArray[8] = 448;
        nArray[9] = 356;
        nArray[10] = 283;
        nArray[11] = 225;
        nArray[12] = 178;
        nArray[13] = 142;
        nArray[14] = 113;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 1784;
        nArray2[1] = 1784;
        nArray2[2] = 1784;
        nArray2[3] = 1520;
        nArray2[4] = 1246;
        nArray2[5] = 994;
        nArray2[6] = 808;
        nArray2[7] = 646;
        nArray2[8] = 514;
        nArray2[9] = 396;
        nArray2[10] = 318;
        nArray2[11] = 246;
        nArray2[12] = 192;
        nArray2[13] = 150;
        nArray2[14] = 120;
        nArrayArray[1] = nArray2;
        VOLUME_LEVELS = nArrayArray;
    }

    public SN76489(int n, int n2, int n3) {
        this.CYCLES_PER_SECOND = n;
        this.FRAMES_PER_SECOND = n2;
        this.volumeLevels = VOLUME_LEVELS[n3 % VOLUME_LEVELS.length];
    }

    public int getCyclesPerSecond() {
        return this.CYCLES_PER_SECOND;
    }

    public int getFramesPerSecond() {
        return this.FRAMES_PER_SECOND;
    }

    private int calcNextLFSRNumber() {
        if ((this.regNoise & 4) != 0) {
            int n = this.regLinearFeedbackShift & 9;
            n ^= n >> 8;
            n ^= n >> 4;
            n ^= n >> 2;
            n ^= n >> 1;
            this.regLinearFeedbackShift = (n & 1) << 15 | this.regLinearFeedbackShift >> 1;
        } else {
            this.regLinearFeedbackShift = (this.regLinearFeedbackShift & 1) << 15 | this.regLinearFeedbackShift >> 1;
        }
        return this.regLinearFeedbackShift & 1;
    }

    private int getVolume(int n) {
        if (n == 3) {
            return Math.min(15, this.regVolume[n] + 1);
        }
        return this.regVolume[n];
    }

    private int getCyclesPerSample(int n) {
        if (n == 3) {
            switch (this.regNoise & 3) {
                case 0: {
                    return 256;
                }
                case 1: {
                    return 512;
                }
                case 2: {
                    return 1024;
                }
                case 3: {
                    return this.getCyclesPerSample(2);
                }
            }
        }
        return 16 * Math.max(1, this.regTone[n]);
    }

    public void processInput(int n, int n2, int n3) {
        this.fireOutputAvailable(2228351, n3);
        if (n == 6) {
            this.regStereo = n2;
            this.fireOutputAvailable(0x220001, n2);
        } else if ((n2 & 0x80) != 0) {
            this.latchedRegister = (n2 & 0x70) >> 4;
            this.fireOutputAvailable(0x220000, ((n2 & 0x80) != 0 || (this.latchedRegister & 1) != 0 || this.latchedRegister >> 1 == 3 ? n2 & 0xF : n2 & 0x3F) << 8 | n2 & 0x80 | this.latchedRegister);
            if ((this.latchedRegister & 1) != 0) {
                this.regVolume[this.latchedRegister >> 1] = n2 & 0xF;
            } else if (this.latchedRegister >> 1 == 3) {
                this.regNoise = n2 & 0xF;
                this.regLinearFeedbackShift = 32768;
            } else {
                this.regTone[this.latchedRegister >> 1] = this.regTone[this.latchedRegister >> 1] & 0x3F0 | n2 & 0xF;
            }
        } else {
            this.fireOutputAvailable(0x220000, ((n2 & 0x80) != 0 || (this.latchedRegister & 1) != 0 || this.latchedRegister >> 1 == 3 ? n2 & 0xF : n2 & 0x3F) << 8 | n2 & 0x80 | this.latchedRegister);
            if ((this.latchedRegister & 1) != 0) {
                this.regVolume[this.latchedRegister >> 1] = n2 & 0xF;
            } else if (this.latchedRegister >> 1 == 3) {
                this.regNoise = n2 & 0xF;
            } else {
                this.regTone[this.latchedRegister >> 1] = (n2 & 0x3F) << 4 | this.regTone[this.latchedRegister >> 1] & 0xF;
            }
        }
    }

    public boolean isChannelEnabled(boolean bl, int n) {
        return (this.regStereo & 1 << (bl ? n : 4 + n)) != 0;
    }

    public int getSamples(int n) {
        return this.samples[n];
    }

    public void advanceChannels(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.counter.length) {
            this.advanceChannel(n2, n);
            ++n2;
        }
    }

    private void advanceChannel(int n, int n2) {
        int n3 = this.counter[n];
        int n4 = n;
        this.counter[n4] = this.counter[n4] - n2;
        int n5 = this.getCyclesPerSample(n);
        int n6 = (n == 3 ? this.randomNumber : this.direction[n]) * n3;
        while (this.counter[n] <= 0) {
            int n7 = n;
            this.direction[n7] = this.direction[n7] ^ 1;
            if (n == 3) {
                if (this.direction[n] == 1) {
                    this.randomNumber = this.calcNextLFSRNumber();
                }
                n6 += this.randomNumber * n5;
            } else {
                n6 += this.direction[n] * n5;
            }
            int n8 = n;
            this.counter[n8] = this.counter[n8] + n5;
        }
        this.samples[n] = (n6 -= (n == 3 ? this.randomNumber : this.direction[n]) * this.counter[n]) * this.volumeLevels[this.getVolume(n)];
    }

    public void reset() {
        Arrays.fill(this.regVolume, 15);
        Arrays.fill(this.regTone, 0);
        this.regNoise = 0;
    }

    public void setReg(int n, int n2) {
        if ((n & 1) != 0) {
            this.regVolume[n >> 1] = n2 & 0xF;
        } else if (n >> 1 == 3) {
            this.regNoise = n2 & 0xF;
        } else {
            this.regTone[n >> 1] = n2 & 0x3FF;
        }
    }

    protected void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getRegVolume(int n) {
                return SN76489.this.regVolume[n];
            }

            @Override
            public int getRegTone(int n) {
                return SN76489.this.regTone[n];
            }

            @Override
            public int getRegNoise() {
                return SN76489.this.regNoise;
            }

            @Override
            public int getRegStereo() {
                return SN76489.this.regStereo;
            }

            @Override
            public int getRegLinearFeedbackShift() {
                return SN76489.this.regLinearFeedbackShift;
            }

            @Override
            public int getLatchedRegister() {
                return SN76489.this.latchedRegister;
            }
        };
    }

    public void setState(State state) {
        int n = 0;
        while (n < this.regVolume.length) {
            this.regVolume[n] = state.getRegVolume(n) & 0xF;
            ++n;
        }
        n = 0;
        while (n < this.regTone.length) {
            this.regTone[n] = state.getRegTone(n) & 0x3FF;
            ++n;
        }
        this.regNoise = state.getRegNoise();
        this.regStereo = state.getRegStereo();
        this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
        this.latchedRegister = state.getLatchedRegister();
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getRegVolume(int var1);

        public int getRegTone(int var1);

        public int getRegNoise();

        public int getRegStereo();

        public int getRegLinearFeedbackShift();

        public int getLatchedRegister();
    }

    private static class StateClone
    implements State {
        private final int[] regVolume = new int[4];
        private final int[] regTone = new int[3];
        private int regNoise;
        private int regStereo;
        private int regLinearFeedbackShift;
        private int latchedRegister;

        public StateClone(State state) {
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            int n = 0;
            while (n < this.regVolume.length) {
                this.regVolume[n] = state.getRegVolume(n);
                ++n;
            }
            n = 0;
            while (n < this.regTone.length) {
                this.regTone[n] = state.getRegTone(n);
                ++n;
            }
            this.regNoise = state.getRegNoise();
            this.regStereo = state.getRegStereo();
            this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
            this.latchedRegister = state.getLatchedRegister();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getRegVolume(int n) {
            return this.regVolume[n];
        }

        @Override
        public int getRegTone(int n) {
            return this.regTone[n];
        }

        @Override
        public int getRegNoise() {
            return this.regNoise;
        }

        @Override
        public int getRegStereo() {
            return this.regStereo;
        }

        @Override
        public int getRegLinearFeedbackShift() {
            return this.regLinearFeedbackShift;
        }

        @Override
        public int getLatchedRegister() {
            return this.latchedRegister;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

