/*
 * Decompiled with CFR 0.152.
 */
package components.cartridge;

import components.cartridge.Cartridge;
import components.cartridge.Mapper;
import components.sound.SCC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import msx.MSXDevice;
import patching.IPS;
import util.io.IOUtilities;

public class MSXCartridge
extends Cartridge
implements MSXDevice {
    private int[] ram = new int[0];
    private final int MASK_BANK;
    private int frame5ROMPageNumber;
    private int frame4ROMPageNumber;
    private int frame3ROMPageNumber;
    private int frame2ROMPageNumber;
    private int frame1ROMPageNumber;
    private int frame0ROMPageNumber;
    private int ramPageNumber;
    private boolean ramWriteProtect;
    private boolean ramEnabled;
    private boolean ramChanged;
    protected long lastWriteMillis;
    private SCC scc;
    protected Mapper mapper = new AutoDetectMapper();

    public MSXCartridge(int[] nArray) {
        super(MSXCartridge.ensureMinimumRomSize(nArray, 8192));
        int n;
        int n2 = this.getHeaderAddress() + 16;
        boolean bl = true;
        if (n2 + "ROM_NEO8".length() < nArray.length) {
            n = "ROM_NE".length() - 1;
            while (bl && n >= 0) {
                if (nArray[n2 + n] != "ROM_NE".charAt(n)) {
                    bl = false;
                }
                --n;
            }
            if (bl) {
                if (nArray[n2 + 6] == 79 && nArray[n2 + 7] == 56) {
                    this.mapper = new Neo8Mapper();
                } else if (nArray[n2 + 6] == 49 && nArray[n2 + 7] == 54) {
                    this.mapper = new Neo16Mapper();
                } else {
                    bl = false;
                }
            }
        }
        if (!bl) {
            if (nArray.length <= 32768) {
                this.mapper = new NoMapper();
            } else if (nArray.length <= 49152) {
                this.mapper = new NoMapper64();
            } else if (this.getHeaderAddress() == 376832) {
                this.mapper = new RtypeMapper();
            }
            if (nArray.length > 10 && nArray[0] == 65 && nArray[1] == 66 && nArray[2] == 52 && nArray[3] == 70 && nArray[4] == 0 && nArray[5] == 28 && nArray[6] == 190 && nArray[7] == 190 && nArray[8] == 195 && nArray[9] == 98 && nArray[10] == 6) {
                this.mapper = new Total128mapper();
            }
            if ((n = this.calcCRC32()) == -1448714123) {
                this.mapper = new Ascii16Mapper();
            } else if (n == 1597328997) {
                this.mapper = new Ascii16Mapper();
            } else if (n == -211946877 || n == 1191755217) {
                this.mapper = new Ascii16Mapper();
            }
        }
        n = (nArray.length - 1) / 8192;
        while ((n & n + 1) != 0) {
            ++n;
        }
        this.MASK_BANK = n;
        this.reset();
    }

    public MSXCartridge(String string, IPS iPS) throws IOException {
        super(string, iPS);
        int n;
        this.readRAMfromFile();
        MSXCartridge.ensureMinimumRomSize(this.rom, 8192);
        if ((this.rom.length & 0x1FFF) != 0) {
            int[] nArray = new int[this.rom.length + (8192 - (this.rom.length & 0x1FFF))];
            Arrays.fill(nArray, 255);
            System.arraycopy(this.rom, 0, nArray, 0, this.rom.length);
            this.rom = nArray;
        }
        int n2 = this.getHeaderAddress() + 16;
        boolean bl = true;
        if (n2 + "ROM_NEO8".length() < this.rom.length) {
            n = "ROM_NE".length() - 1;
            while (bl && n >= 0) {
                if (this.rom[n2 + n] != "ROM_NE".charAt(n)) {
                    bl = false;
                }
                --n;
            }
            if (bl) {
                if (this.rom[n2 + 6] == 79 && this.rom[n2 + 7] == 56) {
                    this.mapper = new Neo8Mapper();
                } else if (this.rom[n2 + 6] == 49 && this.rom[n2 + 7] == 54) {
                    this.mapper = new Neo16Mapper();
                } else {
                    bl = false;
                }
            }
        }
        if (!bl) {
            if (this.rom.length <= 32768) {
                this.mapper = new NoMapper();
            } else if (this.rom.length <= 49152) {
                this.mapper = new NoMapper64();
            } else if (this.getHeaderAddress() == 376832) {
                this.mapper = new RtypeMapper();
            }
            if (this.rom.length > 10 && this.rom[0] == 65 && this.rom[1] == 66 && this.rom[2] == 52 && this.rom[3] == 70 && this.rom[4] == 0 && this.rom[5] == 28 && this.rom[6] == 190 && this.rom[7] == 190 && this.rom[8] == 195 && this.rom[9] == 98 && this.rom[10] == 6) {
                this.mapper = new Total128mapper();
            }
            if ((n = this.calcCRC32()) == -1448714123) {
                this.mapper = new Ascii16Mapper();
            } else if (n == 1597328997) {
                this.mapper = new Ascii16Mapper();
            } else if (n == -211946877 || n == 1191755217) {
                this.mapper = new Ascii16Mapper();
            }
        }
        n = (this.rom.length - 1) / 8192;
        while ((n & n + 1) != 0) {
            ++n;
        }
        this.MASK_BANK = n;
        this.reset();
    }

    public int getFirstPage() {
        int n = this.getInitAddress();
        if (n == 0 || this.getStatementAddress() > 0 && this.getStatementAddress() < n) {
            n = this.getStatementAddress();
        }
        if (n == 0 || this.getDeviceAddress() > 0 && this.getDeviceAddress() < n) {
            n = this.getDeviceAddress();
        }
        if (n == 0 || this.getTextAddress() > 0 && this.getTextAddress() < n) {
            n = this.getTextAddress();
        }
        if (n >> 14 == 2 && this.rom.length == 32768) {
            return 1;
        }
        return n >> 14;
    }

    public int getHeaderAddress() {
        if (this.rom.length < 10) {
            return -1;
        }
        if (this.rom[0] == 65 && this.rom[1] == 66) {
            return 0;
        }
        if (this.rom.length < 16394) {
            return -1;
        }
        if (this.rom[16384] == 65 && this.rom[16385] == 66) {
            return 16384;
        }
        if (this.rom.length >= 376842 && this.rom[376832] == 65 && this.rom[376833] == 66) {
            return 376832;
        }
        return -1;
    }

    public String getID() {
        int n = this.getHeaderAddress();
        if (n < 0) {
            return "";
        }
        return String.valueOf(Character.toString((char)this.rom[n])) + Character.toString((char)this.rom[n + 1]);
    }

    public int getInitAddress() {
        int n = this.getHeaderAddress();
        if (n < 0) {
            return 0;
        }
        return this.rom[n + 3] << 8 | this.rom[n + 2];
    }

    public int getStatementAddress() {
        int n = this.getHeaderAddress();
        if (n < 0) {
            return 0;
        }
        return this.rom[n + 5] << 8 | this.rom[n + 4];
    }

    public int getDeviceAddress() {
        int n = this.getHeaderAddress();
        if (n < 0) {
            return 0;
        }
        return this.rom[n + 7] << 8 | this.rom[n + 6];
    }

    public int getTextAddress() {
        int n = this.getHeaderAddress();
        if (n < 0) {
            return 0;
        }
        return this.rom[n + 9] << 8 | this.rom[n + 8];
    }

    @Override
    public boolean isROMaddress(int n) {
        return this.mapper.isROMaddress(n);
    }

    @Override
    public boolean isSRAMaddress(int n) {
        return this.mapper.isSRAMaddress(n);
    }

    @Override
    public int mapAddress(int n) {
        return this.mapper.mapAddress(n);
    }

    @Override
    public int mapAddress(int n, int n2) {
        return this.mapper.mapAddress(n, n2);
    }

    @Override
    public void setBank0(int n) {
        this.frame0ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setBank1(int n) {
        this.frame1ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setBank2(int n) {
        this.frame2ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setBank3(int n) {
        this.frame3ROMPageNumber = n & this.MASK_BANK;
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.ramEnabled = bl;
    }

    @Override
    public void setSRAMbank(int n) {
        this.ramPageNumber = n;
    }

    @Override
    public int getBank0() {
        return this.frame0ROMPageNumber;
    }

    @Override
    public int getBank1() {
        return this.frame1ROMPageNumber;
    }

    @Override
    public int getBank2() {
        return this.frame2ROMPageNumber;
    }

    @Override
    public int getBank3() {
        return this.frame3ROMPageNumber;
    }

    @Override
    public int getBank(int n) {
        return this.mapper.getBank(n);
    }

    @Override
    public void setBank(int n, int n2) {
        if (n < 16384) {
            return;
        }
        if (n < 49152) {
            int n3 = n / this.getBankSize();
            switch (n3) {
                case 0: {
                    this.frame0ROMPageNumber = n2;
                    break;
                }
                case 1: {
                    this.frame1ROMPageNumber = n2;
                    break;
                }
                case 2: {
                    this.frame2ROMPageNumber = n2;
                    break;
                }
                case 3: {
                    this.frame3ROMPageNumber = n2;
                    break;
                }
                case 4: {
                    this.frame4ROMPageNumber = n2;
                    break;
                }
                case 5: {
                    this.frame5ROMPageNumber = n2;
                }
            }
        }
    }

    @Override
    public int getBankSize() {
        return this.mapper instanceof Ascii16Mapper || this.mapper instanceof Neo16Mapper || this.mapper instanceof NoMapper || this.mapper instanceof NoMapper64 || this.mapper instanceof RtypeMapper ? 16384 : 8192;
    }

    @Override
    public boolean isSRAMenabled() {
        return this.ramEnabled;
    }

    @Override
    public int getSRAMbank() {
        return this.ramPageNumber;
    }

    @Override
    public void shutdown() {
        this.writeRAMtoFile();
    }

    public void setSCC(SCC sCC) {
        this.scc = sCC;
    }

    public int getMapper() {
        if (this.mapper instanceof NoMapper64) {
            return 13;
        }
        if (this.mapper instanceof NoMapper) {
            if (((NoMapper)this.mapper).offset8000) {
                return 11;
            }
            if (((NoMapper)this.mapper).offset0) {
                return 12;
            }
            return 10;
        }
        if (this.mapper instanceof Total128mapper) {
            return 9;
        }
        if (this.mapper instanceof RtypeMapper) {
            return 7;
        }
        if (this.mapper instanceof Konami8Mapper) {
            return 1;
        }
        if (this.mapper instanceof Konami8sccMapper) {
            return 2;
        }
        if (this.mapper instanceof Ascii16Mapper) {
            return 3;
        }
        if (this.mapper instanceof Ascii8Mapper) {
            return 4;
        }
        return 0;
    }

    public String getMapperName() {
        if (this.mapper instanceof AutoDetectMapper) {
            return "";
        }
        if (this.mapper instanceof NoMapper64) {
            return "No Mapper 64K";
        }
        if (this.mapper instanceof NoMapper) {
            return "No Mapper (" + (((NoMapper)this.mapper).offset0 ? "$0000" : (((NoMapper)this.mapper).offset8000 ? "$8000" : "$4000")) + ")";
        }
        String string = this.mapper.getClass().getSimpleName();
        String string2 = string.substring(0, string.length() - "Mapper".length());
        return String.valueOf(string2) + " Mapper";
    }

    @Override
    public boolean readRAMfromFile(File file) {
        try {
            byte[] byArray = IOUtilities.toByteArray(new FileInputStream(file));
            if (this.ram == null || this.ram.length != byArray.length) {
                this.ram = new int[byArray.length];
            }
            int n = 0;
            while (n < this.ram.length) {
                this.ram[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    protected void writeRAMtoFile() {
        if (!this.ramChanged) {
            return;
        }
        if (this.ramFilename != null) {
            try {
                File file = this.makeRAMfile();
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[this.ram.length];
                int n = 0;
                while (n < byArray.length) {
                    byArray[n] = (byte)this.ram[n];
                    ++n;
                }
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.ramChanged = false;
    }

    @Override
    public boolean hasSRAM() {
        return this.ram != null && this.ram.length > 0;
    }

    @Override
    public int[] getSRAM() {
        return this.ram;
    }

    @Override
    public void reset() {
        this.writeRAMtoFile();
        this.ramEnabled = false;
        this.ramWriteProtect = false;
        this.mapper.reset();
    }

    @Override
    public int readByte(int n, int n2) {
        if (this.cheatHandler != null) {
            int n3;
            int n4;
            if (n == 56) {
                this.cheatHandler.applyCheats();
            }
            if ((n4 = this.cheatHandler.readCheat(n, n3 = this.mapper.readByte(n))) >= 0) {
                return n4;
            }
            return n3;
        }
        return this.getByte(n);
    }

    @Override
    public int getByte(int n) {
        return this.mapper.readByte(n);
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        this.mapper.processWrite(n, n2);
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getFrame3ROMPageNumber() {
                return MSXCartridge.this.frame3ROMPageNumber;
            }

            @Override
            public int getFrame2ROMPageNumber() {
                return MSXCartridge.this.frame2ROMPageNumber;
            }

            @Override
            public int getFrame1ROMPageNumber() {
                return MSXCartridge.this.frame1ROMPageNumber;
            }

            @Override
            public int getFrame0ROMPageNumber() {
                return MSXCartridge.this.frame0ROMPageNumber;
            }

            @Override
            public int getRamPageNumber() {
                return MSXCartridge.this.ramPageNumber;
            }

            @Override
            public boolean isRamWriteProtect() {
                return MSXCartridge.this.ramWriteProtect;
            }

            @Override
            public boolean isRamEnabled() {
                return MSXCartridge.this.ramEnabled;
            }

            @Override
            public int[] getRAM() {
                return MSXCartridge.this.ram;
            }
        };
    }

    public void setState(State state, boolean bl) {
        this.frame3ROMPageNumber = state.getFrame3ROMPageNumber();
        this.frame2ROMPageNumber = state.getFrame2ROMPageNumber();
        this.frame1ROMPageNumber = state.getFrame1ROMPageNumber();
        this.frame0ROMPageNumber = state.getFrame0ROMPageNumber();
        this.ramPageNumber = state.getRamPageNumber();
        this.ramWriteProtect = state.isRamWriteProtect();
        this.ramEnabled = state.isRamEnabled();
        if (this.ramEnabled) {
            this.enableShutdownHook();
        }
        if (this.ramEnabled && this.ram.length < 16384 * (this.ramPageNumber + 1)) {
            int[] nArray = this.ram;
            this.ram = new int[16384 * (this.ramPageNumber + 1)];
            Arrays.fill(this.ram, 255);
            System.arraycopy(nArray, 0, this.ram, 0, nArray.length);
            if (nArray.length > 0) {
                System.out.println(String.valueOf(nArray.length) + " bytes of RAM copied.");
            }
        }
        if (!bl || this.ramEnabled) {
            System.arraycopy(state.getRAM(), 0, this.ram, 0, Math.min(this.ram.length, state.getRAM().length));
        }
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        this.processWrite(n, n2, n3);
    }

    public class Ascii16Mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n >= 16384 && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return MSXCartridge.this.ramEnabled && n >= 32768 && n < 49152;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 1: {
                    return MSXCartridge.this.frame0ROMPageNumber;
                }
                case 2: {
                    return MSXCartridge.this.frame1ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 1: {
                    return 16384 * MSXCartridge.this.frame0ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * MSXCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 16384 * n2 | n & 0x3FFF;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 1: {
                    return MSXCartridge.this.rom[16384 * MSXCartridge.this.frame0ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    if (MSXCartridge.this.ramEnabled) {
                        return MSXCartridge.this.ram[n & 0x7FF];
                    }
                    return MSXCartridge.this.rom[16384 * MSXCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (MSXCartridge.this.ramEnabled && n >> 14 == 2) {
                if (MSXCartridge.this.ram[n & 0x7FF] != n2) {
                    MSXCartridge.this.ramChanged = true;
                }
                ((MSXCartridge)MSXCartridge.this).ram[n & 0x7FF] = n2;
            }
            switch (n & 0xF800) {
                case 24576: {
                    MSXCartridge.this.frame0ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK >> 1;
                    break;
                }
                case 28672: {
                    long l;
                    MSXCartridge.this.frame1ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK >> 1;
                    if (MSXCartridge.this.ramEnabled && n2 != 16 && (l = System.currentTimeMillis()) - MSXCartridge.this.lastWriteMillis >= 5000L) {
                        MSXCartridge.this.writeRAMtoFile();
                        MSXCartridge.this.lastWriteMillis = l;
                    }
                    MSXCartridge.this.ramEnabled = n2 == 16;
                    if (MSXCartridge.this.ramEnabled) {
                        MSXCartridge.this.enableShutdownHook();
                    }
                    if (!MSXCartridge.this.ramEnabled || MSXCartridge.this.ram.length >= 2048) break;
                    int[] nArray = MSXCartridge.this.ram;
                    MSXCartridge.this.ram = new int[2048];
                    Arrays.fill(MSXCartridge.this.ram, 255);
                    System.arraycopy(nArray, 0, MSXCartridge.this.ram, 0, nArray.length);
                    if (nArray.length <= 0) break;
                    System.out.println(String.valueOf(nArray.length) + " bytes of RAM copied.");
                }
            }
        }
    }

    public class Ascii8Mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n >= 16384 && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 2: {
                    return MSXCartridge.this.frame0ROMPageNumber;
                }
                case 3: {
                    return MSXCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return MSXCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return MSXCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 2: {
                    return 8192 * MSXCartridge.this.frame0ROMPageNumber | n & 0x1FFF;
                }
                case 3: {
                    return 8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 8192 * n2 | n & 0x1FFF;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 0;
            MSXCartridge.this.frame2ROMPageNumber = 0;
            MSXCartridge.this.frame3ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 13) {
                case 2: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame0ROMPageNumber | n & 0x1FFF];
                }
                case 3: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF];
                }
                case 4: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF];
                }
                case 5: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n & 0xF800) {
                case 24576: {
                    MSXCartridge.this.frame0ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 26624: {
                    MSXCartridge.this.frame1ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 28672: {
                    MSXCartridge.this.frame2ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 30720: {
                    MSXCartridge.this.frame3ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                }
            }
        }
    }

    public class AutoDetectMapper
    implements Mapper {
        private final int offset;
        private boolean pageRegisterAt6000written;
        private boolean pageRegisterAt7000written;
        private boolean address8000read;
        private int prev8000write;

        public AutoDetectMapper() {
            this.offset = 16384 - MSXCartridge.this.getHeaderAddress() & 0xFFFFC000;
        }

        @Override
        public boolean isROMaddress(int n) {
            return n - this.offset >= 0 && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            return n - this.offset;
        }

        @Override
        public int mapAddress(int n, int n2) {
            if (n2 == 0 && n >= 16384) {
                return n - this.offset;
            }
            return n2 * 8192 | n & 0x1FFF;
        }

        @Override
        public void reset() {
            if (MSXCartridge.this.rom.length > 32768) {
                MSXCartridge.this.frame2ROMPageNumber = 2;
            }
            if (MSXCartridge.this.rom.length > 16384) {
                MSXCartridge.this.frame1ROMPageNumber = 1;
            }
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.ramPageNumber = 0;
            this.pageRegisterAt6000written = false;
            this.pageRegisterAt7000written = false;
            this.prev8000write = -1;
        }

        @Override
        public int readByte(int n) {
            switch (n / 16384) {
                case 0: {
                    if (this.offset == 0) {
                        System.out.println("No Mapper 64K detected");
                        MSXCartridge.this.mapper = new NoMapper64();
                    }
                }
                case 3: {
                    if (this.offset != 0) break;
                }
                case 1: 
                case 2: {
                    if (n == 32768) {
                        this.address8000read = true;
                    }
                    if (this.pageRegisterAt7000written && n >= 32768 && n < 49152 && MSXCartridge.this.frame1ROMPageNumber < MSXCartridge.this.MASK_BANK >> 1) {
                        System.out.println("ASCII 16KB detected");
                        MSXCartridge.this.mapper = new Ascii16Mapper();
                        return MSXCartridge.this.mapper.readByte(n);
                    }
                    if (this.pageRegisterAt6000written && !this.pageRegisterAt7000written && n >= 24576 && n < 32768) {
                        System.out.println("Konami 8K without SCC detected");
                        MSXCartridge.this.mapper = new Konami8Mapper();
                        return MSXCartridge.this.mapper.readByte(n);
                    }
                    if (n - this.offset >= MSXCartridge.this.rom.length) break;
                    return MSXCartridge.this.rom[n - this.offset];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n & 0xF800) {
                case 32768: 
                case 40960: {
                    int n3;
                    if (this.address8000read && n == 32768 && (n2 == (n3 = MSXCartridge.this.getByte(n)) && this.prev8000write == (n3 ^ 0xFF) || n2 == (n3 ^ 0xFF))) {
                        this.prev8000write = n2;
                        break;
                    }
                    System.out.println("Konami 8K without SCC detected");
                    MSXCartridge.this.mapper = new Konami8Mapper();
                    break;
                }
                case 20480: 
                case 36864: 
                case 45056: {
                    System.out.println("Konami 8K with SCC detected");
                    MSXCartridge.this.mapper = new Konami8sccMapper();
                    break;
                }
                case 26624: 
                case 30720: {
                    System.out.println("ASCII 8KB detected");
                    if (this.pageRegisterAt7000written) {
                        MSXCartridge.this.frame2ROMPageNumber = MSXCartridge.this.frame1ROMPageNumber;
                    }
                    MSXCartridge.this.mapper = new Ascii8Mapper();
                    MSXCartridge.this.frame1ROMPageNumber = 1;
                    break;
                }
                case 24576: {
                    MSXCartridge.this.frame0ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    boolean bl = this.pageRegisterAt6000written = MSXCartridge.this.frame0ROMPageNumber > 0;
                    if (!this.pageRegisterAt7000written) break;
                    System.out.println("ASCII 16KB detected");
                    MSXCartridge.this.mapper = new Ascii16Mapper();
                    break;
                }
                case 28672: {
                    if (n2 == 16) {
                        System.out.println("ASCII 16KB detected");
                        MSXCartridge.this.mapper = new Ascii16Mapper();
                    } else {
                        MSXCartridge.this.frame1ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    }
                    this.pageRegisterAt7000written = true;
                }
            }
            if (!(MSXCartridge.this.mapper instanceof AutoDetectMapper)) {
                MSXCartridge.this.mapper.processWrite(n, n2);
            }
        }
    }

    public class Konami8Mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n >= 16384 && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return MSXCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return MSXCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return MSXCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 2: {
                    return n - 16384;
                }
                case 3: {
                    return 8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 8192 * n2 | n & 0x1FFF;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame1ROMPageNumber = 0;
            MSXCartridge.this.frame2ROMPageNumber = 0;
            MSXCartridge.this.frame3ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 13) {
                case 2: {
                    return MSXCartridge.this.rom[n - 16384];
                }
                case 3: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF];
                }
                case 4: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF];
                }
                case 5: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n) {
                case 24576: {
                    MSXCartridge.this.frame1ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 32768: {
                    MSXCartridge.this.frame2ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 40960: {
                    MSXCartridge.this.frame3ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                }
            }
        }
    }

    public class Konami8sccMapper
    implements Mapper {
        private boolean sccEnabled;

        @Override
        public boolean isROMaddress(int n) {
            return n >= 16384 && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 2: {
                    return MSXCartridge.this.frame0ROMPageNumber;
                }
                case 3: {
                    return MSXCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return MSXCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return MSXCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 2: {
                    return 8192 * MSXCartridge.this.frame0ROMPageNumber | n & 0x1FFF;
                }
                case 3: {
                    return 8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 8192 * n2 | n & 0x1FFF;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 0;
            MSXCartridge.this.frame2ROMPageNumber = 0;
            MSXCartridge.this.frame3ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 13) {
                case 2: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame0ROMPageNumber | n & 0x1FFF];
                }
                case 3: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF];
                }
                case 4: {
                    if (this.sccEnabled && n >= 38912) {
                        return MSXCartridge.this.scc == null ? 255 : MSXCartridge.this.scc.readByte(n, 0);
                    }
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF];
                }
                case 5: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (this.sccEnabled && MSXCartridge.this.scc != null) {
                MSXCartridge.this.scc.writeByte(n, n2, 0);
            }
            switch (n & 0xF800) {
                case 20480: {
                    MSXCartridge.this.frame0ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 28672: {
                    MSXCartridge.this.frame1ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 36864: {
                    MSXCartridge.this.frame2ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                    this.sccEnabled = (n2 & 0x3F) == 63;
                    break;
                }
                case 45056: {
                    MSXCartridge.this.frame3ROMPageNumber = n2 & MSXCartridge.this.MASK_BANK;
                }
            }
        }
    }

    public class Neo16Mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return true;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return MSXCartridge.this.frame2ROMPageNumber;
                }
                case 1: {
                    return MSXCartridge.this.frame0ROMPageNumber;
                }
                case 2: {
                    return MSXCartridge.this.frame1ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return 16384 * MSXCartridge.this.frame2ROMPageNumber | n & 0x3FFF;
                }
                case 1: {
                    return 16384 * MSXCartridge.this.frame0ROMPageNumber | n & 0x3FFF;
                }
                case 2: {
                    return 16384 * MSXCartridge.this.frame1ROMPageNumber | n & 0x3FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 16384 * n2 | n & 0x3FFF;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 0;
            MSXCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return MSXCartridge.this.rom[16384 * MSXCartridge.this.frame2ROMPageNumber | n & 0x3FFF];
                }
                case 1: {
                    return MSXCartridge.this.rom[16384 * MSXCartridge.this.frame0ROMPageNumber | n & 0x3FFF];
                }
                case 2: {
                    return MSXCartridge.this.rom[16384 * MSXCartridge.this.frame1ROMPageNumber | n & 0x3FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n & 0x3000) {
                case 4096: {
                    MSXCartridge.this.frame2ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame2ROMPageNumber & 0xFF : MSXCartridge.this.frame2ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK >> 1;
                    break;
                }
                case 8192: {
                    MSXCartridge.this.frame0ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame0ROMPageNumber & 0xFF : MSXCartridge.this.frame0ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK >> 1;
                    break;
                }
                case 12288: {
                    MSXCartridge.this.frame1ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame1ROMPageNumber & 0xFF : MSXCartridge.this.frame1ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK >> 1;
                }
            }
        }
    }

    public class Neo8Mapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return true;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 13) {
                case 0: {
                    return MSXCartridge.this.frame4ROMPageNumber;
                }
                case 1: {
                    return MSXCartridge.this.frame5ROMPageNumber;
                }
                case 2: {
                    return MSXCartridge.this.frame0ROMPageNumber;
                }
                case 3: {
                    return MSXCartridge.this.frame1ROMPageNumber;
                }
                case 4: {
                    return MSXCartridge.this.frame2ROMPageNumber;
                }
                case 5: {
                    return MSXCartridge.this.frame3ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 13) {
                case 0: {
                    return 8192 * MSXCartridge.this.frame4ROMPageNumber | n & 0x1FFF;
                }
                case 1: {
                    return 8192 * MSXCartridge.this.frame5ROMPageNumber | n & 0x1FFF;
                }
                case 2: {
                    return 8192 * MSXCartridge.this.frame0ROMPageNumber | n & 0x1FFF;
                }
                case 3: {
                    return 8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF;
                }
                case 4: {
                    return 8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF;
                }
                case 5: {
                    return 8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return 8192 * n2 | n & 0x1FFF;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 0;
            MSXCartridge.this.frame2ROMPageNumber = 0;
            MSXCartridge.this.frame3ROMPageNumber = 0;
            MSXCartridge.this.frame4ROMPageNumber = 0;
            MSXCartridge.this.frame5ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 13) {
                case 0: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame4ROMPageNumber | n & 0x1FFF];
                }
                case 1: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame5ROMPageNumber | n & 0x1FFF];
                }
                case 2: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame0ROMPageNumber | n & 0x1FFF];
                }
                case 3: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame1ROMPageNumber | n & 0x1FFF];
                }
                case 4: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame2ROMPageNumber | n & 0x1FFF];
                }
                case 5: {
                    return MSXCartridge.this.rom[8192 * MSXCartridge.this.frame3ROMPageNumber | n & 0x1FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n & 0x3800) {
                case 4096: {
                    MSXCartridge.this.frame4ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame4ROMPageNumber & 0xFF : MSXCartridge.this.frame4ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 6144: {
                    MSXCartridge.this.frame5ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame1ROMPageNumber & 0xFF : MSXCartridge.this.frame5ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 8192: {
                    MSXCartridge.this.frame0ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame0ROMPageNumber & 0xFF : MSXCartridge.this.frame0ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 10240: {
                    MSXCartridge.this.frame1ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame1ROMPageNumber & 0xFF : MSXCartridge.this.frame1ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 12288: {
                    MSXCartridge.this.frame2ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame2ROMPageNumber & 0xFF : MSXCartridge.this.frame2ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK;
                    break;
                }
                case 14336: {
                    MSXCartridge.this.frame3ROMPageNumber = ((n & 1) != 0 ? n2 << 8 | MSXCartridge.this.frame3ROMPageNumber & 0xFF : MSXCartridge.this.frame3ROMPageNumber & 0xFF00 | n2) & MSXCartridge.this.MASK_BANK;
                }
            }
        }
    }

    public class NoMapper
    implements Mapper {
        private final boolean offset0;
        private final boolean offset8000;
        private final int MASK;

        public NoMapper() {
            this.offset0 = MSXCartridge.this.getFirstPage() == 0;
            this.offset8000 = MSXCartridge.this.getFirstPage() == 2;
            this.MASK = MSXCartridge.this.rom.length - 1;
        }

        @Override
        public boolean isROMaddress(int n) {
            return n >= (this.offset0 ? 0 : 16384) && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n / 16384) {
                case 0: {
                    if (!this.offset0) break;
                    return n & this.MASK;
                }
                case 1: {
                    if (this.offset8000) {
                        return 0;
                    }
                }
                case 2: {
                    return n - 16384 & this.MASK;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n / 16384) {
                case 0: {
                    if (!this.offset0) break;
                    return n & this.MASK;
                }
                case 1: {
                    if (this.offset8000) {
                        return 0;
                    }
                }
                case 2: {
                    return n - 16384 & this.MASK;
                }
            }
            return 0;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 1;
        }

        @Override
        public int readByte(int n) {
            switch (n / 16384) {
                case 0: {
                    if (!this.offset0) break;
                    return MSXCartridge.this.rom[n & this.MASK];
                }
                case 1: {
                    if (this.offset8000) {
                        return 255;
                    }
                }
                case 2: {
                    return MSXCartridge.this.rom[n - 16384 & this.MASK];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (!this.offset0 && !this.offset8000) {
                switch (n & 0xF800) {
                    case 20480: 
                    case 36864: 
                    case 45056: {
                        System.out.println("Konami 8K with SCC detected");
                        MSXCartridge.this.mapper = new Konami8sccMapper();
                        MSXCartridge.this.mapper.processWrite(n, n2);
                    }
                }
            }
        }
    }

    public class NoMapper64
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n < MSXCartridge.this.rom.length;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            return n;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = 1;
            MSXCartridge.this.frame2ROMPageNumber = 2;
            MSXCartridge.this.frame3ROMPageNumber = 3;
        }

        @Override
        public int readByte(int n) {
            if (n >= MSXCartridge.this.rom.length) {
                return 255;
            }
            return MSXCartridge.this.rom[n];
        }

        @Override
        public void processWrite(int n, int n2) {
            switch (n & 0xF800) {
                case 20480: 
                case 36864: 
                case 45056: {
                    System.out.println("Konami 8K with SCC detected");
                    MSXCartridge.this.mapper = new Konami8sccMapper();
                    MSXCartridge.this.mapper.reset();
                    MSXCartridge.this.mapper.processWrite(n, n2);
                }
            }
        }
    }

    public class RtypeMapper
    implements Mapper {
        @Override
        public boolean isROMaddress(int n) {
            return n >= 16384 && n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 1: {
                    return 23;
                }
                case 2: {
                    return MSXCartridge.this.frame2ROMPageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 1: {
                    return 0x5C000 | n & 0x3FFF;
                }
                case 2: {
                    return MSXCartridge.this.frame2ROMPageNumber * 16384 | n & 0x3FFF;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 1: {
                    return 0x5C000 | n & 0x3FFF;
                }
                case 2: {
                    return n2 * 16384 | n & 0x3FFF;
                }
            }
            return 0;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame2ROMPageNumber = 0;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 1: {
                    return MSXCartridge.this.rom[0x5C000 | n & 0x3FFF];
                }
                case 2: {
                    return MSXCartridge.this.rom[MSXCartridge.this.frame2ROMPageNumber * 16384 | n & 0x3FFF];
                }
            }
            return 255;
        }

        @Override
        public void processWrite(int n, int n2) {
            if (n >> 14 == 1) {
                MSXCartridge.this.frame2ROMPageNumber = n2 & (0x1F ^ (n2 & 0x10) >> 1);
            }
        }
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getFrame3ROMPageNumber();

        public int getFrame2ROMPageNumber();

        public int getFrame1ROMPageNumber();

        public int getFrame0ROMPageNumber();

        public int getRamPageNumber();

        public boolean isRamWriteProtect();

        public boolean isRamEnabled();

        public int[] getRAM();
    }

    private static class StateClone
    implements State {
        private int frame3ROMPageNumber;
        private int frame2ROMPageNumber;
        private int frame1ROMPageNumber;
        private int frame0ROMPageNumber;
        private int ramPageNumber;
        private boolean ramWriteProtect;
        private boolean ramEnabled;
        private final int[] ram;

        public StateClone(State state) {
            this.ram = new int[state.getRAM().length];
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            this.frame3ROMPageNumber = state.getFrame3ROMPageNumber();
            this.frame2ROMPageNumber = state.getFrame2ROMPageNumber();
            this.frame1ROMPageNumber = state.getFrame1ROMPageNumber();
            this.frame0ROMPageNumber = state.getFrame0ROMPageNumber();
            this.ramPageNumber = state.getRamPageNumber();
            this.ramWriteProtect = state.isRamWriteProtect();
            this.ramEnabled = state.isRamEnabled();
            System.arraycopy(state.getRAM(), 0, this.ram, 0, this.ram.length);
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getFrame3ROMPageNumber() {
            return this.frame3ROMPageNumber;
        }

        @Override
        public int getFrame2ROMPageNumber() {
            return this.frame2ROMPageNumber;
        }

        @Override
        public int getFrame1ROMPageNumber() {
            return this.frame1ROMPageNumber;
        }

        @Override
        public int getFrame0ROMPageNumber() {
            return this.frame0ROMPageNumber;
        }

        @Override
        public int getRamPageNumber() {
            return this.ramPageNumber;
        }

        @Override
        public boolean isRamWriteProtect() {
            return this.ramWriteProtect;
        }

        @Override
        public boolean isRamEnabled() {
            return this.ramEnabled;
        }

        @Override
        public int[] getRAM() {
            return this.ram;
        }
    }

    public class Total128mapper
    implements Mapper {
        private int pageNumber;

        @Override
        public boolean isROMaddress(int n) {
            return n < 49152;
        }

        @Override
        public boolean isSRAMaddress(int n) {
            return false;
        }

        @Override
        public int getBank(int n) {
            switch (n >> 14) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 2: {
                    return this.pageNumber;
                }
            }
            return 0;
        }

        @Override
        public int mapAddress(int n) {
            switch (n >> 14) {
                case 0: {
                    return n & 0x3FFF;
                }
                case 1: 
                case 2: {
                    return 8192 * this.pageNumber | n - 16384;
                }
            }
            return n;
        }

        @Override
        public int mapAddress(int n, int n2) {
            switch (n >> 14) {
                case 0: {
                    return n & 0x3FFF;
                }
                case 1: 
                case 2: {
                    return 8192 * n2 | n - 16384;
                }
            }
            return n;
        }

        @Override
        public void reset() {
            MSXCartridge.this.frame0ROMPageNumber = 0;
            this.pageNumber = 0;
            MSXCartridge.this.frame1ROMPageNumber = this.pageNumber / 2 & MSXCartridge.this.MASK_BANK;
            MSXCartridge.this.frame2ROMPageNumber = this.pageNumber / 2 + 1 & MSXCartridge.this.MASK_BANK;
        }

        @Override
        public int readByte(int n) {
            switch (n >> 14) {
                case 0: {
                    return MSXCartridge.this.rom[n];
                }
                case 1: 
                case 2: {
                    return MSXCartridge.this.rom[8192 * this.pageNumber | n - 16384];
                }
            }
            return 0;
        }

        @Override
        public void processWrite(int n, int n2) {
            int n3 = n & 0xE000;
            if (n3 == 8192) {
                this.pageNumber = n2 ^ 0x1F;
                MSXCartridge.this.frame1ROMPageNumber = this.pageNumber / 2 & MSXCartridge.this.MASK_BANK;
                MSXCartridge.this.frame2ROMPageNumber = this.pageNumber / 2 + 1 & MSXCartridge.this.MASK_BANK;
            } else if (n3 == 24576) {
                this.pageNumber = n2;
                MSXCartridge.this.frame1ROMPageNumber = this.pageNumber / 2 & MSXCartridge.this.MASK_BANK;
                MSXCartridge.this.frame2ROMPageNumber = this.pageNumber / 2 + 1 & MSXCartridge.this.MASK_BANK;
            }
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

