/*
 * Decompiled with CFR 0.152.
 */
package components.cartridge;

import cheats.CheatHandler;
import components.cartridge.CartridgeEventListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import patching.IPS;
import util.io.IOUtilities;

public abstract class Cartridge {
    protected static final long WRITE_TO_FILE_THROTTLE = 5000L;
    protected int[] rom;
    private Thread shutdownHook;
    protected final String ramFilename;
    protected CheatHandler cheatHandler;
    private File ramFolder;
    private final LinkedList<CartridgeEventListener> listenerList = new LinkedList();
    private CartridgeEventListener[] listeners = new CartridgeEventListener[0];

    protected Cartridge(int[] nArray) {
        this.rom = nArray;
        this.ramFilename = null;
    }

    protected Cartridge(String string, IPS iPS) throws IOException {
        InputStream inputStream;
        ZipFile zipFile = null;
        if (string.toLowerCase().contains(".zip")) {
            int n = string.lastIndexOf(File.separatorChar);
            if (n < 0) {
                throw new FileNotFoundException("File within zip file is unspecified.");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            zipFile = new ZipFile(string2);
            ZipEntry zipEntry = zipFile.getEntry(string3);
            inputStream = zipFile.getInputStream(zipEntry);
            int n2 = string3.lastIndexOf(46);
            String string4 = n2 > 0 ? string3.substring(0, n2) : string3;
            this.ramFilename = String.valueOf(string2.substring(0, string2.lastIndexOf(46))) + File.separatorChar + string4 + ".sav";
        } else if (string.startsWith("resource:")) {
            string = string.substring("resource:".length());
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            this.ramFilename = Cartridge.makeRamFilename(string);
        } else {
            inputStream = new FileInputStream(new File(string));
            this.ramFilename = Cartridge.makeRamFilename(string);
        }
        byte[] byArray = IOUtilities.toByteArray(inputStream);
        if (zipFile != null) {
            zipFile.close();
        }
        this.rom = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.rom[n] = byArray[n] & 0xFF;
            ++n;
        }
        if (iPS != null) {
            this.applyPatch(iPS, false);
        }
    }

    protected static int[] ensureMinimumRomSize(int[] nArray, int n) {
        if (nArray.length < n) {
            int[] nArray2 = new int[n];
            Arrays.fill(nArray2, 255);
            int n2 = 1;
            while (n2 < nArray.length) {
                n2 <<= 1;
            }
            int n3 = 0;
            while (n3 + n2 <= nArray2.length) {
                System.arraycopy(nArray, 0, nArray2, n3, nArray.length);
                n3 += n2;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public static final String makeRamFilename(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n > 0 ? string.substring(0, n) : string;
        return String.valueOf(string2) + ".sav";
    }

    protected File makeRAMfile() {
        File file = new File(this.ramFilename);
        if (file.exists()) {
            return file;
        }
        return this.ramFolder != null ? new File(this.ramFolder, file.getName()) : file;
    }

    public void setRamFolder(File file) {
        this.ramFolder = file;
        this.readRAMfromFile();
    }

    public boolean applyPatch(IPS iPS, boolean bl) {
        int[] nArray = iPS.apply(this.rom);
        if (bl && nArray.length == this.rom.length) {
            System.arraycopy(nArray, 0, this.rom, 0, nArray.length);
        } else {
            this.rom = nArray;
        }
        return !bl || nArray != this.rom;
    }

    public int calcCRC32() {
        CRC32 cRC32 = new CRC32();
        int[] nArray = this.rom;
        int n = this.rom.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            cRC32.update(n3);
            ++n2;
        }
        return (int)cRC32.getValue();
    }

    public byte[] calcMD5() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int[] nArray = this.rom;
            int n = this.rom.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                messageDigest.update((byte)n3);
                ++n2;
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public int[] getRom() {
        return this.rom;
    }

    protected void enableShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Cartridge.this.shutdown();
                    }
                    catch (Throwable throwable) {}
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public void eject() {
        this.shutdown();
        this.listenerList.clear();
        this.listeners = new CartridgeEventListener[0];
        this.cheatHandler = null;
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {}
            this.shutdownHook = null;
        }
    }

    protected boolean readRAMfromFile() {
        return this.readRAMfromFile(this.makeRAMfile());
    }

    public void update(int n) {
    }

    public void setCheatHandler(CheatHandler cheatHandler) {
        this.cheatHandler = cheatHandler;
    }

    protected final void fireNonStandardAddressWrite(int n) {
        CartridgeEventListener[] cartridgeEventListenerArray = this.listeners;
        int n2 = this.listeners.length;
        int n3 = 0;
        while (n3 < n2) {
            CartridgeEventListener cartridgeEventListener = cartridgeEventListenerArray[n3];
            cartridgeEventListener.nonStandardAddressWrite(n);
            ++n3;
        }
    }

    public final void addCartridgeEventListener(CartridgeEventListener cartridgeEventListener) {
        if (!this.listenerList.contains(cartridgeEventListener)) {
            this.listenerList.addFirst(cartridgeEventListener);
            this.listeners = this.listenerList.toArray(new CartridgeEventListener[this.listenerList.size()]);
        }
    }

    public final void removeCartridgeEventListener(CartridgeEventListener cartridgeEventListener) {
        if (this.listenerList.remove(cartridgeEventListener)) {
            this.listeners = this.listenerList.toArray(new CartridgeEventListener[this.listenerList.size()]);
        }
    }

    public abstract boolean hasSRAM();

    public abstract int[] getSRAM();

    public abstract void reset();

    public abstract int readByte(int var1, int var2);

    public abstract void processWrite(int var1, int var2, int var3);

    public abstract boolean isROMaddress(int var1);

    public abstract boolean isSRAMaddress(int var1);

    public abstract int mapAddress(int var1);

    public abstract int mapAddress(int var1, int var2);

    public abstract boolean readRAMfromFile(File var1);

    protected abstract void shutdown();

    public abstract int getBank0();

    public abstract int getBank1();

    public abstract int getBank2();

    public abstract int getBank3();

    public abstract int getBank(int var1);

    public abstract int getBankSize();

    public abstract boolean isSRAMenabled();

    public abstract int getSRAMbank();

    public abstract void setBank0(int var1);

    public abstract void setBank1(int var1);

    public abstract void setBank2(int var1);

    public abstract void setBank3(int var1);

    public abstract void setBank(int var1, int var2);

    public abstract void setSRAMenabled(boolean var1);

    public abstract void setSRAMbank(int var1);
}

