/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.oracle.webservices.internal.api.databinding.ExternalMetadataFeature;
import com.oracle.webservices.internal.api.databinding.WSDLResolver;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.databinding.DatabindingConfig;
import com.sun.xml.internal.ws.api.databinding.DatabindingFactory;
import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.api.databinding.WSDLGenInfo;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.api.policy.PolicyResolver;
import com.sun.xml.internal.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.internal.ws.api.server.AsyncProvider;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.server.InstanceResolver;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.XMLEntityResolver;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.db.DatabindingImpl;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.ReflectAnnotationReader;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapMutator;
import com.sun.xml.internal.ws.policy.jaxws.PolicyUtil;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.EndpointAwareTube;
import com.sun.xml.internal.ws.server.SDDocumentImpl;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.ServiceDefinitionImpl;
import com.sun.xml.internal.ws.server.WSDLGenResolver;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.server.provider.ProviderInvokerTube;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.HandlerAnnotationProcessor;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EndpointFactory {
    private static final EndpointFactory instance = new EndpointFactory();
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server.endpoint");

    public static EndpointFactory getInstance() {
        return instance;
    }

    public static <T> WSEndpoint<T> createEndpoint(Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, EntityResolver entityResolver, boolean bl2) {
        return EndpointFactory.createEndpoint(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, bl2, true);
    }

    public static <T> WSEndpoint<T> createEndpoint(Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, EntityResolver entityResolver, boolean bl2, boolean bl3) {
        EndpointFactory endpointFactory;
        EndpointFactory endpointFactory2 = endpointFactory = container != null ? container.getSPI(EndpointFactory.class) : null;
        if (endpointFactory == null) {
            endpointFactory = EndpointFactory.getInstance();
        }
        return endpointFactory.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, bl2, bl3);
    }

    public <T> WSEndpoint<T> create(Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, EntityResolver entityResolver, boolean bl2) {
        return this.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, bl2, true);
    }

    public <T> WSEndpoint<T> create(Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, EntityResolver entityResolver, boolean bl2, boolean bl3) {
        EndpointAwareTube endpointAwareTube;
        Iterable<WebServiceFeature> iterable;
        List<SDDocumentImpl> list;
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        MetadataReader metadataReader = EndpointFactory.getExternalMetadatReader(clazz, wSBinding);
        if (bl3) {
            EndpointFactory.verifyImplementorClass(clazz, metadataReader);
        }
        if (invoker == null) {
            invoker = InstanceResolver.createDefault(clazz).createInvoker();
        }
        ArrayList<SDDocumentSource> arrayList = new ArrayList<SDDocumentSource>();
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if (sDDocumentSource != null && !arrayList.contains(sDDocumentSource)) {
            arrayList.add(sDDocumentSource);
        }
        if (container == null) {
            container = ContainerResolver.getInstance().getContainer();
        }
        if (qName == null) {
            qName = EndpointFactory.getDefaultServiceName(clazz, metadataReader);
        }
        if (qName2 == null) {
            qName2 = EndpointFactory.getDefaultPortName(qName, clazz, metadataReader);
        }
        if (!((String)(object = qName.getNamespaceURI())).equals(list = qName2.getNamespaceURI())) {
            throw new ServerRtException("wrong.tns.for.port", list, object);
        }
        if (wSBinding == null) {
            wSBinding = BindingImpl.create(BindingID.parse(clazz));
        }
        if (bl3 && sDDocumentSource != null) {
            EndpointFactory.verifyPrimaryWSDL(sDDocumentSource, qName);
        }
        object = null;
        if (bl3 && clazz.getAnnotation(WebServiceProvider.class) == null) {
            object = RuntimeModeler.getPortTypeName(clazz, metadataReader);
        }
        list = EndpointFactory.categoriseMetadata(arrayList, qName, (QName)object);
        SDDocumentImpl sDDocumentImpl = sDDocumentSource != null ? SDDocumentImpl.create(sDDocumentSource, qName, (QName)object) : EndpointFactory.findPrimary(list);
        WSDLPort wSDLPort = null;
        AbstractSEIModelImpl abstractSEIModelImpl = null;
        if (sDDocumentImpl != null) {
            wSDLPort = EndpointFactory.getWSDLPort(sDDocumentImpl, (List<? extends SDDocumentSource>)list, qName, qName2, container, entityResolver);
        }
        WebServiceFeatureList webServiceFeatureList = ((BindingImpl)wSBinding).getFeatures();
        if (bl3) {
            webServiceFeatureList.parseAnnotations(clazz);
        }
        PolicyMap policyMap = null;
        if (this.isUseProviderTube(clazz, bl3)) {
            if (wSDLPort != null) {
                policyMap = wSDLPort.getOwner().getParent().getPolicyMap();
                iterable = wSDLPort.getFeatures();
            } else {
                policyMap = PolicyResolverFactory.create().resolve(new PolicyResolver.ServerContext(null, container, clazz, false, new PolicyMapMutator[0]));
                iterable = PolicyUtil.getPortScopedFeatures(policyMap, qName, qName2);
            }
            webServiceFeatureList.mergeFeatures(iterable, true);
            endpointAwareTube = this.createProviderInvokerTube(clazz, wSBinding, invoker, container);
        } else {
            abstractSEIModelImpl = EndpointFactory.createSEIModel(wSDLPort, clazz, qName, qName2, wSBinding, sDDocumentImpl);
            if (wSBinding instanceof SOAPBindingImpl) {
                ((SOAPBindingImpl)wSBinding).setPortKnownHeaders(((SOAPSEIModel)abstractSEIModelImpl).getKnownHeaders());
            }
            if (sDDocumentImpl == null) {
                sDDocumentImpl = EndpointFactory.generateWSDL(wSBinding, abstractSEIModelImpl, list, container, clazz);
                wSDLPort = EndpointFactory.getWSDLPort(sDDocumentImpl, (List<? extends SDDocumentSource>)list, qName, qName2, container, entityResolver);
                abstractSEIModelImpl.freeze(wSDLPort);
            }
            policyMap = wSDLPort.getOwner().getParent().getPolicyMap();
            webServiceFeatureList.mergeFeatures(wSDLPort.getFeatures(), true);
            endpointAwareTube = this.createSEIInvokerTube(abstractSEIModelImpl, invoker, wSBinding);
        }
        if (bl) {
            EndpointFactory.processHandlerAnnotation(wSBinding, clazz, qName, qName2);
        }
        if (sDDocumentImpl != null) {
            list = EndpointFactory.findMetadataClosure(sDDocumentImpl, list, entityResolver);
        }
        iterable = sDDocumentImpl != null ? new ServiceDefinitionImpl(list, sDDocumentImpl) : null;
        return this.create(qName, qName2, wSBinding, container, abstractSEIModelImpl, wSDLPort, clazz, (ServiceDefinitionImpl)iterable, endpointAwareTube, bl2, policyMap);
    }

    protected <T> WSEndpoint<T> create(QName qName, QName qName2, WSBinding wSBinding, Container container, SEIModel sEIModel, WSDLPort wSDLPort, Class<T> clazz, ServiceDefinitionImpl serviceDefinitionImpl, EndpointAwareTube endpointAwareTube, boolean bl, PolicyMap policyMap) {
        return new WSEndpointImpl<T>(qName, qName2, wSBinding, container, sEIModel, wSDLPort, clazz, serviceDefinitionImpl, endpointAwareTube, bl, policyMap);
    }

    protected boolean isUseProviderTube(Class<?> clazz, boolean bl) {
        return !bl || clazz.getAnnotation(WebServiceProvider.class) != null;
    }

    protected EndpointAwareTube createSEIInvokerTube(AbstractSEIModelImpl abstractSEIModelImpl, Invoker invoker, WSBinding wSBinding) {
        return new SEIInvokerTube(abstractSEIModelImpl, invoker, wSBinding);
    }

    protected <T> EndpointAwareTube createProviderInvokerTube(Class<T> clazz, WSBinding wSBinding, Invoker invoker, Container container) {
        return ProviderInvokerTube.create(clazz, wSBinding, invoker, container);
    }

    private static List<SDDocumentImpl> findMetadataClosure(SDDocumentImpl sDDocumentImpl, List<SDDocumentImpl> list, EntityResolver entityResolver) {
        Object object;
        HashMap<String, SDDocumentImpl> hashMap = new HashMap<String, SDDocumentImpl>();
        for (SDDocumentImpl object22 : list) {
            hashMap.put(object22.getSystemId().toString(), object22);
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put(sDDocumentImpl.getSystemId().toString(), sDDocumentImpl);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(sDDocumentImpl.getImports());
        while (!arrayList.isEmpty()) {
            object = (String)arrayList.remove(0);
            SDDocumentImpl sDDocumentImpl2 = (SDDocumentImpl)hashMap.get(object);
            if (sDDocumentImpl2 == null && entityResolver != null) {
                try {
                    InputSource exception = entityResolver.resolveEntity(null, (String)object);
                    if (exception != null) {
                        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
                        XMLStreamReader xMLStreamReader = XmlUtil.newXMLInputFactory(true).createXMLStreamReader(exception.getByteStream());
                        mutableXMLStreamBuffer.createFromXMLStreamReader(xMLStreamReader);
                        SDDocumentSource sDDocumentSource = SDDocumentImpl.create(new URL((String)object), mutableXMLStreamBuffer);
                        sDDocumentImpl2 = SDDocumentImpl.create(sDDocumentSource, null, null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (sDDocumentImpl2 == null || hashMap2.containsKey(object)) continue;
            hashMap2.put(object, sDDocumentImpl2);
            arrayList.addAll(sDDocumentImpl2.getImports());
        }
        object = new ArrayList();
        object.addAll(hashMap2.values());
        return object;
    }

    private static <T> void processHandlerAnnotation(WSBinding wSBinding, Class<T> clazz, QName qName, QName qName2) {
        HandlerAnnotationInfo handlerAnnotationInfo = HandlerAnnotationProcessor.buildHandlerInfo(clazz, qName, qName2, wSBinding);
        if (handlerAnnotationInfo != null) {
            wSBinding.setHandlerChain(handlerAnnotationInfo.getHandlers());
            if (wSBinding instanceof SOAPBinding) {
                ((SOAPBinding)((Object)wSBinding)).setRoles(handlerAnnotationInfo.getRoles());
            }
        }
    }

    public static boolean verifyImplementorClass(Class<?> clazz) {
        return EndpointFactory.verifyImplementorClass(clazz, null);
    }

    public static boolean verifyImplementorClass(Class<?> clazz, MetadataReader metadataReader) {
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        WebServiceProvider webServiceProvider = metadataReader.getAnnotation(WebServiceProvider.class, clazz);
        WebService webService = metadataReader.getAnnotation(WebService.class, clazz);
        if (webServiceProvider == null && webService == null) {
            throw new IllegalArgumentException(clazz + " has neither @WebService nor @WebServiceProvider annotation");
        }
        if (webServiceProvider != null && webService != null) {
            throw new IllegalArgumentException(clazz + " has both @WebService and @WebServiceProvider annotations");
        }
        if (webServiceProvider != null) {
            if (Provider.class.isAssignableFrom(clazz) || AsyncProvider.class.isAssignableFrom(clazz)) {
                return true;
            }
            throw new IllegalArgumentException(clazz + " doesn't implement Provider or AsyncProvider interface");
        }
        return false;
    }

    private static AbstractSEIModelImpl createSEIModel(WSDLPort wSDLPort, Class<?> clazz, @NotNull QName qName, @NotNull QName qName2, WSBinding wSBinding, SDDocumentSource sDDocumentSource) {
        DatabindingFactory databindingFactory = DatabindingFactory.newInstance();
        DatabindingConfig databindingConfig = new DatabindingConfig();
        databindingConfig.setEndpointClass(clazz);
        databindingConfig.getMappingInfo().setServiceName(qName);
        databindingConfig.setWsdlPort(wSDLPort);
        databindingConfig.setWSBinding(wSBinding);
        databindingConfig.setClassLoader(clazz.getClassLoader());
        databindingConfig.getMappingInfo().setPortName(qName2);
        if (sDDocumentSource != null) {
            databindingConfig.setWsdlURL(sDDocumentSource.getSystemId());
        }
        databindingConfig.setMetadataReader(EndpointFactory.getExternalMetadatReader(clazz, wSBinding));
        DatabindingImpl databindingImpl = (DatabindingImpl)databindingFactory.createRuntime(databindingConfig);
        return (AbstractSEIModelImpl)databindingImpl.getModel();
    }

    public static MetadataReader getExternalMetadatReader(Class<?> clazz, WSBinding wSBinding) {
        ExternalMetadataFeature externalMetadataFeature = wSBinding.getFeature(ExternalMetadataFeature.class);
        if (externalMetadataFeature != null) {
            return externalMetadataFeature.getMetadataReader(clazz.getClassLoader(), false);
        }
        return null;
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> clazz) {
        return EndpointFactory.getDefaultServiceName(clazz, null);
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> clazz, MetadataReader metadataReader) {
        return EndpointFactory.getDefaultServiceName(clazz, true, metadataReader);
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> clazz, boolean bl) {
        return EndpointFactory.getDefaultServiceName(clazz, bl, null);
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> clazz, boolean bl, MetadataReader metadataReader) {
        QName qName;
        WebServiceProvider webServiceProvider;
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if ((webServiceProvider = metadataReader.getAnnotation(WebServiceProvider.class, clazz)) != null) {
            String string = webServiceProvider.targetNamespace();
            String string2 = webServiceProvider.serviceName();
            qName = new QName(string, string2);
        } else {
            qName = RuntimeModeler.getServiceName(clazz, metadataReader, bl);
        }
        assert (qName != null);
        return qName;
    }

    @NotNull
    public static QName getDefaultPortName(QName qName, Class<?> clazz) {
        return EndpointFactory.getDefaultPortName(qName, clazz, null);
    }

    @NotNull
    public static QName getDefaultPortName(QName qName, Class<?> clazz, MetadataReader metadataReader) {
        return EndpointFactory.getDefaultPortName(qName, clazz, true, metadataReader);
    }

    @NotNull
    public static QName getDefaultPortName(QName qName, Class<?> clazz, boolean bl) {
        return EndpointFactory.getDefaultPortName(qName, clazz, bl, null);
    }

    @NotNull
    public static QName getDefaultPortName(QName qName, Class<?> clazz, boolean bl, MetadataReader metadataReader) {
        QName qName2;
        WebServiceProvider webServiceProvider;
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if ((webServiceProvider = metadataReader.getAnnotation(WebServiceProvider.class, clazz)) != null) {
            String string = webServiceProvider.targetNamespace();
            String string2 = webServiceProvider.portName();
            qName2 = new QName(string, string2);
        } else {
            qName2 = RuntimeModeler.getPortName(clazz, metadataReader, qName.getNamespaceURI(), bl);
        }
        assert (qName2 != null);
        return qName2;
    }

    @Nullable
    public static String getWsdlLocation(Class<?> clazz) {
        return EndpointFactory.getWsdlLocation(clazz, new ReflectAnnotationReader());
    }

    @Nullable
    public static String getWsdlLocation(Class<?> clazz, MetadataReader metadataReader) {
        WebService webService;
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if ((webService = metadataReader.getAnnotation(WebService.class, clazz)) != null) {
            return EndpointFactory.nullIfEmpty(webService.wsdlLocation());
        }
        WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
        assert (webServiceProvider != null);
        return EndpointFactory.nullIfEmpty(webServiceProvider.wsdlLocation());
    }

    private static String nullIfEmpty(String string) {
        if (string.length() < 1) {
            string = null;
        }
        return string;
    }

    private static SDDocumentImpl generateWSDL(WSBinding wSBinding, AbstractSEIModelImpl abstractSEIModelImpl, List<SDDocumentImpl> list, Container container, Class clazz) {
        Object object;
        BindingID bindingID = wSBinding.getBindingId();
        if (!bindingID.canGenerateWSDL()) {
            throw new ServerRtException("can.not.generate.wsdl", bindingID);
        }
        if (bindingID.toString().equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            object = ServerMessages.GENERATE_NON_STANDARD_WSDL();
            logger.warning((String)object);
        }
        object = new WSDLGenResolver(list, abstractSEIModelImpl.getServiceQName(), abstractSEIModelImpl.getPortTypeName());
        WSDLGenInfo wSDLGenInfo = new WSDLGenInfo();
        wSDLGenInfo.setWsdlResolver((WSDLResolver)object);
        wSDLGenInfo.setContainer(container);
        wSDLGenInfo.setExtensions(ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
        wSDLGenInfo.setInlineSchemas(false);
        wSDLGenInfo.setSecureXmlProcessingDisabled(EndpointFactory.isSecureXmlProcessingDisabled(wSBinding.getFeatures()));
        abstractSEIModelImpl.getDatabinding().generateWSDL(wSDLGenInfo);
        return ((WSDLGenResolver)object).updateDocs();
    }

    private static boolean isSecureXmlProcessingDisabled(WSFeatureList wSFeatureList) {
        return false;
    }

    private static List<SDDocumentImpl> categoriseMetadata(List<SDDocumentSource> list, QName qName, QName qName2) {
        ArrayList<SDDocumentImpl> arrayList = new ArrayList<SDDocumentImpl>(list.size());
        for (SDDocumentSource sDDocumentSource : list) {
            arrayList.add(SDDocumentImpl.create(sDDocumentSource, qName, qName2));
        }
        return arrayList;
    }

    private static void verifyPrimaryWSDL(@NotNull SDDocumentSource sDDocumentSource, @NotNull QName qName) {
        SDDocumentImpl sDDocumentImpl = SDDocumentImpl.create(sDDocumentSource, qName, null);
        if (!(sDDocumentImpl instanceof SDDocument.WSDL)) {
            throw new WebServiceException(sDDocumentSource.getSystemId() + " is not a WSDL. But it is passed as a primary WSDL");
        }
        SDDocument.WSDL wSDL = (SDDocument.WSDL)((Object)sDDocumentImpl);
        if (!wSDL.hasService()) {
            if (wSDL.getAllServices().isEmpty()) {
                throw new WebServiceException("Not a primary WSDL=" + sDDocumentSource.getSystemId() + " since it doesn't have Service " + qName);
            }
            throw new WebServiceException("WSDL " + sDDocumentImpl.getSystemId() + " has the following services " + wSDL.getAllServices() + " but not " + qName + ". Maybe you forgot to specify a serviceName and/or targetNamespace in @WebService/@WebServiceProvider?");
        }
    }

    @Nullable
    private static SDDocumentImpl findPrimary(@NotNull List<SDDocumentImpl> list) {
        SDDocumentImpl sDDocumentImpl = null;
        boolean bl = false;
        boolean bl2 = false;
        for (SDDocumentImpl sDDocumentImpl2 : list) {
            if (!(sDDocumentImpl2 instanceof SDDocument.WSDL)) continue;
            SDDocument.WSDL wSDL = (SDDocument.WSDL)((Object)sDDocumentImpl2);
            if (wSDL.hasService()) {
                sDDocumentImpl = sDDocumentImpl2;
                if (bl) {
                    throw new ServerRtException("duplicate.primary.wsdl", sDDocumentImpl2.getSystemId());
                }
                bl = true;
            }
            if (!wSDL.hasPortType()) continue;
            if (bl2) {
                throw new ServerRtException("duplicate.abstract.wsdl", sDDocumentImpl2.getSystemId());
            }
            bl2 = true;
        }
        return sDDocumentImpl;
    }

    @NotNull
    private static WSDLPort getWSDLPort(SDDocumentSource sDDocumentSource, List<? extends SDDocumentSource> list, @NotNull QName qName, @NotNull QName qName2, Container container, EntityResolver entityResolver) {
        URL uRL = sDDocumentSource.getSystemId();
        try {
            WSDLModel wSDLModel = RuntimeWSDLParser.parse(new XMLEntityResolver.Parser(sDDocumentSource), (XMLEntityResolver)new EntityResolverImpl(list, entityResolver), false, container, ServiceFinder.find(WSDLParserExtension.class).toArray());
            if (wSDLModel.getServices().size() == 0) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_NOSERVICE_IN_WSDLMODEL(uRL));
            }
            WSDLService wSDLService = wSDLModel.getService(qName);
            if (wSDLService == null) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_INCORRECTSERVICE(qName, uRL));
            }
            WSDLPort wSDLPort = wSDLService.get(qName2);
            if (wSDLPort == null) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_INCORRECTSERVICEPORT(qName, qName2, uRL));
            }
            return wSDLPort;
        }
        catch (IOException iOException) {
            throw new ServerRtException("runtime.parser.wsdl", uRL, iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException("runtime.saxparser.exception", xMLStreamException.getMessage(), xMLStreamException.getLocation(), xMLStreamException);
        }
        catch (SAXException sAXException) {
            throw new ServerRtException("runtime.parser.wsdl", uRL, sAXException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new ServerRtException("runtime.parser.wsdl", uRL, serviceConfigurationError);
        }
    }

    private static final class EntityResolverImpl
    implements XMLEntityResolver {
        private Map<String, SDDocumentSource> metadata = new HashMap<String, SDDocumentSource>();
        private EntityResolver resolver;

        public EntityResolverImpl(List<? extends SDDocumentSource> list, EntityResolver entityResolver) {
            for (SDDocumentSource sDDocumentSource : list) {
                this.metadata.put(sDDocumentSource.getSystemId().toExternalForm(), sDDocumentSource);
            }
            this.resolver = entityResolver;
        }

        @Override
        public XMLEntityResolver.Parser resolveEntity(String string, String string2) throws IOException, XMLStreamException {
            Object object;
            if (string2 != null && (object = this.metadata.get(string2)) != null) {
                return new XMLEntityResolver.Parser((SDDocumentSource)object);
            }
            if (this.resolver != null) {
                try {
                    object = this.resolver.resolveEntity(string, string2);
                    if (object != null) {
                        XMLEntityResolver.Parser parser = new XMLEntityResolver.Parser(null, XMLStreamReaderFactory.create((InputSource)object, true));
                        return parser;
                    }
                }
                catch (SAXException sAXException) {
                    throw new XMLStreamException(sAXException);
                }
            }
            return null;
        }
    }
}

