/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.AssertionValidationProcessor;
import com.sun.xml.internal.ws.policy.EffectivePolicyModifier;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionValidator;
import java.util.Collection;
import java.util.LinkedList;

public class EffectiveAlternativeSelector {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(EffectiveAlternativeSelector.class);

    public static void doSelection(EffectivePolicyModifier effectivePolicyModifier) throws PolicyException {
        AssertionValidationProcessor assertionValidationProcessor = AssertionValidationProcessor.getInstance();
        EffectiveAlternativeSelector.selectAlternatives(effectivePolicyModifier, assertionValidationProcessor);
    }

    protected static void selectAlternatives(EffectivePolicyModifier effectivePolicyModifier, AssertionValidationProcessor assertionValidationProcessor) throws PolicyException {
        Policy policy;
        PolicyMap policyMap = effectivePolicyModifier.getMap();
        for (PolicyMapKey policyMapKey : policyMap.getAllServiceScopeKeys()) {
            policy = policyMap.getServiceEffectivePolicy(policyMapKey);
            effectivePolicyModifier.setNewEffectivePolicyForServiceScope(policyMapKey, EffectiveAlternativeSelector.selectBestAlternative(policy, assertionValidationProcessor));
        }
        for (PolicyMapKey policyMapKey : policyMap.getAllEndpointScopeKeys()) {
            policy = policyMap.getEndpointEffectivePolicy(policyMapKey);
            effectivePolicyModifier.setNewEffectivePolicyForEndpointScope(policyMapKey, EffectiveAlternativeSelector.selectBestAlternative(policy, assertionValidationProcessor));
        }
        for (PolicyMapKey policyMapKey : policyMap.getAllOperationScopeKeys()) {
            policy = policyMap.getOperationEffectivePolicy(policyMapKey);
            effectivePolicyModifier.setNewEffectivePolicyForOperationScope(policyMapKey, EffectiveAlternativeSelector.selectBestAlternative(policy, assertionValidationProcessor));
        }
        for (PolicyMapKey policyMapKey : policyMap.getAllInputMessageScopeKeys()) {
            policy = policyMap.getInputMessageEffectivePolicy(policyMapKey);
            effectivePolicyModifier.setNewEffectivePolicyForInputMessageScope(policyMapKey, EffectiveAlternativeSelector.selectBestAlternative(policy, assertionValidationProcessor));
        }
        for (PolicyMapKey policyMapKey : policyMap.getAllOutputMessageScopeKeys()) {
            policy = policyMap.getOutputMessageEffectivePolicy(policyMapKey);
            effectivePolicyModifier.setNewEffectivePolicyForOutputMessageScope(policyMapKey, EffectiveAlternativeSelector.selectBestAlternative(policy, assertionValidationProcessor));
        }
        for (PolicyMapKey policyMapKey : policyMap.getAllFaultMessageScopeKeys()) {
            policy = policyMap.getFaultMessageEffectivePolicy(policyMapKey);
            effectivePolicyModifier.setNewEffectivePolicyForFaultMessageScope(policyMapKey, EffectiveAlternativeSelector.selectBestAlternative(policy, assertionValidationProcessor));
        }
    }

    private static Policy selectBestAlternative(Policy policy, AssertionValidationProcessor assertionValidationProcessor) throws PolicyException {
        AssertionSet assertionSet = null;
        AlternativeFitness alternativeFitness = AlternativeFitness.UNEVALUATED;
        for (AssertionSet assertionSet2 : policy) {
            AlternativeFitness alternativeFitness2 = assertionSet2.isEmpty() ? AlternativeFitness.SUPPORTED_EMPTY : AlternativeFitness.UNEVALUATED;
            for (PolicyAssertion policyAssertion : assertionSet2) {
                PolicyAssertionValidator.Fitness fitness = assertionValidationProcessor.validateClientSide(policyAssertion);
                switch (fitness) {
                    case UNKNOWN: 
                    case UNSUPPORTED: 
                    case INVALID: {
                        LOGGER.warning(LocalizationMessages.WSP_0075_PROBLEMATIC_ASSERTION_STATE(policyAssertion.getName(), (Object)fitness));
                        break;
                    }
                }
                alternativeFitness2 = alternativeFitness2.combine(fitness);
            }
            if (alternativeFitness.compareTo(alternativeFitness2) < 0) {
                assertionSet = assertionSet2;
                alternativeFitness = alternativeFitness2;
            }
            if (alternativeFitness != AlternativeFitness.SUPPORTED) continue;
            break;
        }
        switch (alternativeFitness) {
            case INVALID: {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0053_INVALID_CLIENT_SIDE_ALTERNATIVE()));
            }
            case UNKNOWN: 
            case UNSUPPORTED: 
            case PARTIALLY_SUPPORTED: {
                LOGGER.warning(LocalizationMessages.WSP_0019_SUBOPTIMAL_ALTERNATIVE_SELECTED((Object)alternativeFitness));
                break;
            }
        }
        Object object = null;
        if (assertionSet != null) {
            object = new LinkedList();
            object.add(assertionSet);
        }
        return Policy.createPolicy(policy.getNamespaceVersion(), policy.getName(), policy.getId(), (Collection<AssertionSet>)object);
    }

    private static enum AlternativeFitness {
        UNEVALUATED{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                switch (fitness) {
                    case UNKNOWN: {
                        return UNKNOWN;
                    }
                    case UNSUPPORTED: {
                        return UNSUPPORTED;
                    }
                    case SUPPORTED: {
                        return SUPPORTED;
                    }
                    case INVALID: {
                        return INVALID;
                    }
                }
                return UNEVALUATED;
            }
        }
        ,
        INVALID{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                return INVALID;
            }
        }
        ,
        UNKNOWN{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                switch (fitness) {
                    case UNKNOWN: {
                        return UNKNOWN;
                    }
                    case UNSUPPORTED: {
                        return UNSUPPORTED;
                    }
                    case SUPPORTED: {
                        return PARTIALLY_SUPPORTED;
                    }
                    case INVALID: {
                        return INVALID;
                    }
                }
                return UNEVALUATED;
            }
        }
        ,
        UNSUPPORTED{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                switch (fitness) {
                    case UNKNOWN: 
                    case UNSUPPORTED: {
                        return UNSUPPORTED;
                    }
                    case SUPPORTED: {
                        return PARTIALLY_SUPPORTED;
                    }
                    case INVALID: {
                        return INVALID;
                    }
                }
                return UNEVALUATED;
            }
        }
        ,
        PARTIALLY_SUPPORTED{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                switch (fitness) {
                    case UNKNOWN: 
                    case UNSUPPORTED: 
                    case SUPPORTED: {
                        return PARTIALLY_SUPPORTED;
                    }
                    case INVALID: {
                        return INVALID;
                    }
                }
                return UNEVALUATED;
            }
        }
        ,
        SUPPORTED_EMPTY{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                throw new UnsupportedOperationException("Combine operation was called unexpectedly on 'SUPPORTED_EMPTY' alternative fitness enumeration state.");
            }
        }
        ,
        SUPPORTED{

            @Override
            AlternativeFitness combine(PolicyAssertionValidator.Fitness fitness) {
                switch (fitness) {
                    case UNKNOWN: 
                    case UNSUPPORTED: {
                        return PARTIALLY_SUPPORTED;
                    }
                    case SUPPORTED: {
                        return SUPPORTED;
                    }
                    case INVALID: {
                        return INVALID;
                    }
                }
                return UNEVALUATED;
            }
        };


        abstract AlternativeFitness combine(PolicyAssertionValidator.Fitness var1);
    }
}

