/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.db;

import com.oracle.webservices.internal.api.message.MessageContext;
import com.sun.xml.internal.ws.api.databinding.ClientCallBridge;
import com.sun.xml.internal.ws.api.databinding.Databinding;
import com.sun.xml.internal.ws.api.databinding.DatabindingConfig;
import com.sun.xml.internal.ws.api.databinding.EndpointCallBridge;
import com.sun.xml.internal.ws.api.databinding.JavaCallInfo;
import com.sun.xml.internal.ws.api.databinding.WSDLGenInfo;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageContextFactory;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.WSDLOperationMapping;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.sei.StubAsyncHandler;
import com.sun.xml.internal.ws.client.sei.StubHandler;
import com.sun.xml.internal.ws.db.DatabindingProviderImpl;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.server.sei.TieHandler;
import com.sun.xml.internal.ws.wsdl.ActionBasedOperationSignature;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import com.sun.xml.internal.ws.wsdl.writer.WSDLGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;

public final class DatabindingImpl
implements Databinding {
    AbstractSEIModelImpl seiModel;
    Map<Method, StubHandler> stubHandlers;
    Map<JavaMethodImpl, TieHandler> wsdlOpMap = new HashMap<JavaMethodImpl, TieHandler>();
    Map<Method, TieHandler> tieHandlers = new HashMap<Method, TieHandler>();
    OperationDispatcher operationDispatcher;
    OperationDispatcher operationDispatcherNoWsdl;
    boolean clientConfig = false;
    Codec codec;
    MessageContextFactory packetFactory = null;

    public DatabindingImpl(DatabindingProviderImpl databindingProviderImpl, DatabindingConfig databindingConfig) {
        RuntimeModeler runtimeModeler = new RuntimeModeler(databindingConfig);
        runtimeModeler.setClassLoader(databindingConfig.getClassLoader());
        this.seiModel = runtimeModeler.buildRuntimeModel();
        WSDLPort wSDLPort = databindingConfig.getWsdlPort();
        this.packetFactory = new MessageContextFactory(this.seiModel.getWSBinding().getFeatures());
        this.clientConfig = this.isClientConfig(databindingConfig);
        if (this.clientConfig) {
            this.initStubHandlers();
        }
        this.seiModel.setDatabinding(this);
        if (wSDLPort != null) {
            this.freeze(wSDLPort);
        }
        if (this.operationDispatcher == null) {
            this.operationDispatcherNoWsdl = new OperationDispatcher(null, this.seiModel.getWSBinding(), this.seiModel);
        }
        for (JavaMethodImpl javaMethodImpl : this.seiModel.getJavaMethods()) {
            if (javaMethodImpl.isAsync()) continue;
            TieHandler tieHandler = new TieHandler(javaMethodImpl, this.seiModel.getWSBinding(), this.packetFactory);
            this.wsdlOpMap.put(javaMethodImpl, tieHandler);
            this.tieHandlers.put(tieHandler.getMethod(), tieHandler);
        }
    }

    private boolean isClientConfig(DatabindingConfig databindingConfig) {
        if (databindingConfig.getContractClass() == null) {
            return false;
        }
        if (!databindingConfig.getContractClass().isInterface()) {
            return false;
        }
        return databindingConfig.getEndpointClass() == null || databindingConfig.getEndpointClass().isInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze(WSDLPort wSDLPort) {
        if (this.clientConfig) {
            return;
        }
        DatabindingImpl databindingImpl = this;
        synchronized (databindingImpl) {
            if (this.operationDispatcher == null) {
                this.operationDispatcher = wSDLPort == null ? null : new OperationDispatcher(wSDLPort, this.seiModel.getWSBinding(), this.seiModel);
            }
        }
    }

    public SEIModel getModel() {
        return this.seiModel;
    }

    private void initStubHandlers() {
        Object object;
        this.stubHandlers = new HashMap<Method, StubHandler>();
        HashMap<ActionBasedOperationSignature, JavaMethodImpl> hashMap = new HashMap<ActionBasedOperationSignature, JavaMethodImpl>();
        for (JavaMethodImpl javaMethodImpl : this.seiModel.getJavaMethods()) {
            if (javaMethodImpl.getMEP().isAsync) continue;
            object = new StubHandler(javaMethodImpl, this.packetFactory);
            hashMap.put(javaMethodImpl.getOperationSignature(), javaMethodImpl);
            this.stubHandlers.put(javaMethodImpl.getMethod(), (StubHandler)object);
        }
        for (JavaMethodImpl javaMethodImpl : this.seiModel.getJavaMethods()) {
            object = (JavaMethodImpl)hashMap.get(javaMethodImpl.getOperationSignature());
            if (javaMethodImpl.getMEP() != MEP.ASYNC_CALLBACK && javaMethodImpl.getMEP() != MEP.ASYNC_POLL) continue;
            Method method = javaMethodImpl.getMethod();
            StubAsyncHandler stubAsyncHandler = new StubAsyncHandler(javaMethodImpl, (JavaMethodImpl)object, this.packetFactory);
            this.stubHandlers.put(method, stubAsyncHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaMethodImpl resolveJavaMethod(Packet packet) throws DispatchException {
        WSDLOperationMapping wSDLOperationMapping = packet.getWSDLOperationMapping();
        if (wSDLOperationMapping == null) {
            DatabindingImpl databindingImpl = this;
            synchronized (databindingImpl) {
                wSDLOperationMapping = this.operationDispatcher != null ? this.operationDispatcher.getWSDLOperationMapping(packet) : this.operationDispatcherNoWsdl.getWSDLOperationMapping(packet);
            }
        }
        return (JavaMethodImpl)wSDLOperationMapping.getJavaMethod();
    }

    public com.oracle.webservices.internal.api.databinding.JavaCallInfo deserializeRequest(Packet packet) {
        JavaCallInfo javaCallInfo = new JavaCallInfo();
        try {
            JavaMethodImpl javaMethodImpl = this.resolveJavaMethod(packet);
            TieHandler tieHandler = this.wsdlOpMap.get(javaMethodImpl);
            javaCallInfo.setMethod(tieHandler.getMethod());
            Object[] objectArray = tieHandler.readRequest(packet.getMessage());
            javaCallInfo.setParameters(objectArray);
        }
        catch (DispatchException dispatchException) {
            javaCallInfo.setException(dispatchException);
        }
        return javaCallInfo;
    }

    public com.oracle.webservices.internal.api.databinding.JavaCallInfo deserializeResponse(Packet packet, com.oracle.webservices.internal.api.databinding.JavaCallInfo javaCallInfo) {
        StubHandler stubHandler = this.stubHandlers.get(javaCallInfo.getMethod());
        try {
            return stubHandler.readResponse(packet, javaCallInfo);
        }
        catch (Throwable throwable) {
            javaCallInfo.setException(throwable);
            return javaCallInfo;
        }
    }

    public WebServiceFeature[] getFeatures() {
        return null;
    }

    @Override
    public Packet serializeRequest(com.oracle.webservices.internal.api.databinding.JavaCallInfo javaCallInfo) {
        StubHandler stubHandler = this.stubHandlers.get(javaCallInfo.getMethod());
        Packet packet = stubHandler.createRequestPacket(javaCallInfo);
        packet.setState(Packet.State.ClientRequest);
        return packet;
    }

    @Override
    public Packet serializeResponse(com.oracle.webservices.internal.api.databinding.JavaCallInfo javaCallInfo) {
        Object object;
        Method method = javaCallInfo.getMethod();
        Message message = null;
        if (method != null && (object = this.tieHandlers.get(method)) != null) {
            return ((TieHandler)object).serializeResponse(javaCallInfo);
        }
        if (javaCallInfo.getException() instanceof DispatchException) {
            message = ((DispatchException)javaCallInfo.getException()).fault;
        }
        object = (Packet)this.packetFactory.createContext(message);
        ((Packet)object).setState(Packet.State.ServerResponse);
        return object;
    }

    @Override
    public ClientCallBridge getClientBridge(Method method) {
        return this.stubHandlers.get(method);
    }

    @Override
    public void generateWSDL(WSDLGenInfo wSDLGenInfo) {
        WSDLGenerator wSDLGenerator = new WSDLGenerator(this.seiModel, wSDLGenInfo.getWsdlResolver(), this.seiModel.getWSBinding(), wSDLGenInfo.getContainer(), this.seiModel.getEndpointClass(), wSDLGenInfo.isInlineSchemas(), wSDLGenInfo.isSecureXmlProcessingDisabled(), wSDLGenInfo.getExtensions());
        wSDLGenerator.doGeneration();
    }

    @Override
    public EndpointCallBridge getEndpointBridge(Packet packet) throws DispatchException {
        JavaMethodImpl javaMethodImpl = this.resolveJavaMethod(packet);
        return this.wsdlOpMap.get(javaMethodImpl);
    }

    Codec getCodec() {
        if (this.codec == null) {
            this.codec = ((BindingImpl)this.seiModel.getWSBinding()).createCodec();
        }
        return this.codec;
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        return this.getCodec().encode(packet, outputStream);
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        this.getCodec().decode(inputStream, string, packet);
    }

    @Override
    public com.oracle.webservices.internal.api.databinding.JavaCallInfo createJavaCallInfo(Method method, Object[] objectArray) {
        return new JavaCallInfo(method, objectArray);
    }

    @Override
    public com.oracle.webservices.internal.api.databinding.JavaCallInfo deserializeResponse(MessageContext messageContext, com.oracle.webservices.internal.api.databinding.JavaCallInfo javaCallInfo) {
        return this.deserializeResponse((Packet)messageContext, javaCallInfo);
    }

    @Override
    public com.oracle.webservices.internal.api.databinding.JavaCallInfo deserializeRequest(MessageContext messageContext) {
        return this.deserializeRequest((Packet)messageContext);
    }

    @Override
    public MessageContextFactory getMessageContextFactory() {
        return this.packetFactory;
    }
}

