/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.TypeResolver;
import com.sun.beans.finder.AbstractFinder;
import com.sun.beans.finder.PrimitiveWrapperMap;
import com.sun.beans.finder.Signature;
import com.sun.beans.finder.SignatureException;
import com.sun.beans.util.Cache;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import sun.reflect.misc.ReflectUtil;

public final class MethodFinder
extends AbstractFinder<Method> {
    private static final Cache<Signature, Method> CACHE = new Cache<Signature, Method>(Cache.Kind.SOFT, Cache.Kind.SOFT){

        @Override
        public Method create(Signature signature) {
            try {
                MethodFinder methodFinder = new MethodFinder(signature.getName(), signature.getArgs());
                return MethodFinder.findAccessibleMethod((Method)methodFinder.find(signature.getType().getMethods()));
            }
            catch (Exception exception) {
                throw new SignatureException(exception);
            }
        }
    };
    private final String name;

    public static Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        if (string == null) {
            throw new IllegalArgumentException("Method name is not set");
        }
        PrimitiveWrapperMap.replacePrimitivesWithWrappers(classArray);
        Signature signature = new Signature(clazz, string, classArray);
        try {
            Method method = CACHE.get(signature);
            return method == null || ReflectUtil.isPackageAccessible(method.getDeclaringClass()) ? method : CACHE.create(signature);
        }
        catch (SignatureException signatureException) {
            throw signatureException.toNoSuchMethodException("Method '" + string + "' is not found");
        }
    }

    public static Method findInstanceMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Method method = MethodFinder.findMethod(clazz, string, classArray);
        if (Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + string + "' is static");
        }
        return method;
    }

    public static Method findStaticMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Method method = MethodFinder.findMethod(clazz, string, classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + string + "' is not static");
        }
        return method;
    }

    public static Method findAccessibleMethod(Method method) throws NoSuchMethodException {
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers()) && ReflectUtil.isPackageAccessible(clazz)) {
            return method;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + method.getName() + "' is not accessible");
        }
        for (Type type : clazz.getGenericInterfaces()) {
            try {
                return MethodFinder.findAccessibleMethod(method, type);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return MethodFinder.findAccessibleMethod(method, clazz.getGenericSuperclass());
    }

    private static Method findAccessibleMethod(Method method, Type type) throws NoSuchMethodException {
        String string = method.getName();
        Object[] objectArray = method.getParameterTypes();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return MethodFinder.findAccessibleMethod(clazz.getMethod(string, (Class<?>[])objectArray));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            for (Method method2 : clazz.getMethods()) {
                Object[] objectArray2;
                if (!method2.getName().equals(string) || (objectArray2 = method2.getParameterTypes()).length != objectArray.length) continue;
                if (Arrays.equals(objectArray, objectArray2)) {
                    return MethodFinder.findAccessibleMethod(method2);
                }
                Type[] typeArray = method2.getGenericParameterTypes();
                if (objectArray.length != typeArray.length || !Arrays.equals(objectArray, TypeResolver.erase(TypeResolver.resolve((Type)parameterizedType, typeArray)))) continue;
                return MethodFinder.findAccessibleMethod(method2);
            }
        }
        throw new NoSuchMethodException("Method '" + string + "' is not accessible");
    }

    private MethodFinder(String string, Class<?>[] classArray) {
        super(classArray);
        this.name = string;
    }

    @Override
    protected boolean isValid(Method method) {
        return super.isValid(method) && method.getName().equals(this.name);
    }
}

