/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.kerberos.KrbServicePermissionCollection;

public final class ServicePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -1227585031618624935L;
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    public ServicePermission(String string, String string2) {
        super(string);
        this.init(string, ServicePermission.getMask(string2));
    }

    private void init(String string, int n) {
        if (string == null) {
            throw new NullPointerException("service principal can't be null");
        }
        if ((n & 3) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = n;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.impliesIgnoreMask(servicePermission);
    }

    boolean impliesIgnoreMask(ServicePermission servicePermission) {
        return this.getName().equals("*") || this.getName().equals(servicePermission.getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.getName().equals(servicePermission.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    private static String getActions(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n & 1) == 1) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("initiate");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("accept");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = ServicePermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new KrbServicePermissionCollection();
    }

    int getMask() {
        return this.mask;
    }

    private static int getMask(String string) {
        if (string == null) {
            throw new NullPointerException("action can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 7 || cArray[n2 - 7] != 'i' && cArray[n2 - 7] != 'I' || cArray[n2 - 6] != 'n' && cArray[n2 - 6] != 'N' || cArray[n2 - 5] != 'i' && cArray[n2 - 5] != 'I' || cArray[n2 - 4] != 't' && cArray[n2 - 4] != 'T' || cArray[n2 - 3] != 'i' && cArray[n2 - 3] != 'I' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 8;
                n |= 1;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'a' && cArray[n2 - 5] != 'A' || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'c' && cArray[n2 - 3] != 'C' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'p' && cArray[n2 - 1] != 'P' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), ServicePermission.getMask(this.actions));
    }
}

