/*
 * Decompiled with CFR 0.152.
 */
package replay;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import replay.Bk2ReplayData;

public class Bk2InputLogIterator
implements Iterator<String> {
    private final Bk2ReplayData replayData;
    private final Reader reader;
    private final StringBuffer sb = new StringBuffer();
    private boolean skipLF;
    private String line;
    private int lineNumber;
    private int nextLineNumber;

    public Bk2InputLogIterator(Bk2ReplayData bk2ReplayData) throws IOException {
        this.replayData = bk2ReplayData;
        this.reader = new InputStreamReader(bk2ReplayData.getInputLog(), "UTF-8");
        String string = this.readLine();
        int n = 1;
        while (string != null && (string.isEmpty() || string.charAt(0) != '|')) {
            string = this.readLine();
            ++n;
        }
        if (string == null) {
            this.reader.close();
        }
        this.line = string;
        this.nextLineNumber = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readLine() throws IOException {
        this.sb.setLength(0);
        int n = this.reader.read();
        while (n >= 0) {
            block5: {
                char c = (char)n;
                if (c == '\n' || c == '\r') {
                    if (c == '\n' && this.skipLF) {
                        this.skipLF = false;
                        break block5;
                    } else {
                        if (c != '\r') return this.sb.toString();
                        this.skipLF = true;
                        return this.sb.toString();
                    }
                }
                this.sb.append(c);
            }
            n = this.reader.read();
        }
        if (n < 0) {
            return null;
        }
        String string = this.sb.toString();
        return string;
    }

    @Override
    public boolean hasNext() {
        return !this.replayData.isClosed() && this.line != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.line;
        try {
            this.lineNumber = this.nextLineNumber;
            do {
                this.line = this.readLine();
                ++this.nextLineNumber;
            } while (this.line != null && (this.line.isEmpty() || this.line.charAt(0) != '|'));
            if (this.line == null) {
                this.reader.close();
                this.replayData.close();
            }
        }
        catch (IOException iOException) {
            this.line = null;
            iOException.printStackTrace();
        }
        return string;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

