/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.ComponentWrapper;
import disassembler.dialects.AssemblerDialect;
import disassembler.dialects.WlaGbDialect;
import disassembler.dialects.WlaSmsDialect;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import platform.Emulicious;

class DisassemblerSettingsDialog
extends JDialog {
    boolean result;

    public DisassemblerSettingsDialog(Window window) {
        super(window, String.valueOf(Emulicious.TITLE) + " - Disassembler Settings", DEFAULT_MODALITY_TYPE);
        this.setIconImages(window.getIconImages());
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Assembler Dialect:");
        jPanel.add((Component)jLabel, "North");
        final JComboBox<AssemblerDialect> jComboBox = new JComboBox<AssemblerDialect>(Emulicious.getAssemblerDialects());
        jComboBox.setSelectedIndex(Emulicious.indexOfSelectedAssemblerDialect());
        jPanel.add(jComboBox, "Center");
        this.add((Component)ComponentWrapper.wrapComponent(jPanel), "North");
        AssemblerDialect assemblerDialect = Emulicious.getSelectedAssemblerDialect();
        boolean bl = assemblerDialect.getClass() == WlaSmsDialect.class || assemblerDialect.getClass() == WlaGbDialect.class;
        int n = bl ? 12 : 10;
        JPanel jPanel2 = new JPanel(new GridLayout(n, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel2.add(jPanel3);
        String string = Emulicious.getProperties().getProperty("MaxDataBlockSize");
        final JTextField jTextField = new JTextField(string, 6);
        final JCheckBox jCheckBox = new JCheckBox("", Integer.parseInt(string) < Integer.MAX_VALUE);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.setEnabled(jCheckBox.isSelected());
                if (!jTextField.isEnabled()) {
                    jTextField.setText("");
                } else {
                    jTextField.setText("1024");
                }
            }
        });
        jTextField.setEnabled(jCheckBox.isSelected());
        if (!jTextField.isEnabled()) {
            jTextField.setText("");
        }
        jPanel3.add(jCheckBox);
        jPanel3.add(new JLabel("Generate incbin directives for datablocks larger than: "));
        jPanel3.add(jTextField);
        final JCheckBox jCheckBox2 = new JCheckBox("Create WLA DX Linkfile", Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerCreateLinkFile")));
        if (bl) {
            jPanel2.add(jCheckBox2);
        }
        final JCheckBox jCheckBox3 = new JCheckBox("Use Anonymous Labels", Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseAnonymousLabels")));
        if (bl) {
            jPanel2.add(jCheckBox3);
        }
        final JCheckBox jCheckBox4 = new JCheckBox("Use upper case mnemonics", Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseUpperCaseMnemonics")));
        jPanel2.add(jCheckBox4);
        final JCheckBox jCheckBox5 = new JCheckBox("Pad mnemonics", Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerPadMnemonics")));
        jPanel2.add(jCheckBox5);
        final JCheckBox jCheckBox6 = new JCheckBox("Allow calls to unknown RAM", Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerAllowCallsToUnknownRAM")));
        jPanel2.add(jCheckBox6);
        JPanel jPanel4 = new JPanel();
        jPanel2.add(jPanel4);
        String string2 = Emulicious.getProperties().getProperty("DisassemblerDsbBlockSize");
        final JTextField jTextField2 = new JTextField(string2, 3);
        final JCheckBox jCheckBox7 = new JCheckBox("", Integer.parseInt(string2) < Integer.MAX_VALUE);
        jCheckBox7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField2.setEnabled(jCheckBox7.isSelected());
                if (!jTextField2.isEnabled()) {
                    jTextField2.setText("");
                } else {
                    jTextField2.setText("8");
                }
            }
        });
        jTextField2.setEnabled(jCheckBox7.isSelected());
        if (!jTextField2.isEnabled()) {
            jTextField2.setText("");
        }
        jPanel4.add(jCheckBox7);
        jPanel4.add(new JLabel("Group datablocks with same value larger than: "));
        jPanel4.add(jTextField2);
        JPanel jPanel5 = new JPanel();
        jPanel2.add(jPanel5);
        String string3 = Emulicious.getProperties().getProperty("DisassemblerFormatCodeLabel");
        final JTextField jTextField3 = new JTextField(string3, 10);
        jPanel5.add(new JLabel("Code Label Format: "));
        jPanel5.add(jTextField3);
        JPanel jPanel6 = new JPanel();
        jPanel2.add(jPanel6);
        String string4 = Emulicious.getProperties().getProperty("DisassemblerFormatDataLabel");
        final JTextField jTextField4 = new JTextField(string4, 10);
        jPanel6.add(new JLabel("Data Label Format: "));
        jPanel6.add(jTextField4);
        JPanel jPanel7 = new JPanel();
        jPanel2.add(jPanel7);
        String string5 = Emulicious.getProperties().getProperty("DisassemblerFormatRAMlabel");
        final JTextField jTextField5 = new JTextField(string5, 10);
        jPanel7.add(new JLabel("RAM Label Format: "));
        jPanel7.add(jTextField5);
        JPanel jPanel8 = new JPanel();
        jPanel2.add(jPanel8);
        String string6 = Emulicious.getProperties().getProperty("DisassemblerFormatSRAMlabel");
        final JTextField jTextField6 = new JTextField(string6, 10);
        jPanel8.add(new JLabel("SRAM Label Format: "));
        jPanel8.add(jTextField6);
        JPanel jPanel9 = new JPanel();
        jPanel2.add(jPanel9);
        String string7 = Emulicious.getProperties().getProperty("DisassemblerFormatPortLabel");
        final JTextField jTextField7 = new JTextField(string7, 10);
        jPanel9.add(new JLabel("Port Label Format: "));
        jPanel9.add(jTextField7);
        this.add((Component)jPanel2, "Center");
        JPanel jPanel10 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!jCheckBox.isSelected()) {
                        Emulicious.getProperties().setProperty("MaxDataBlockSize", "2147483647");
                    } else {
                        if (Integer.parseInt(jTextField.getText()) < 0) {
                            throw new NumberFormatException();
                        }
                        Emulicious.getProperties().setProperty("MaxDataBlockSize", "" + Integer.parseInt(jTextField.getText()));
                    }
                    if (!jCheckBox7.isSelected()) {
                        Emulicious.getProperties().setProperty("DisassemblerDsbBlockSize", "2147483647");
                    } else {
                        if (Integer.parseInt(jTextField2.getText()) < 0) {
                            throw new NumberFormatException();
                        }
                        Emulicious.getProperties().setProperty("DisassemblerDsbBlockSize", "" + Integer.parseInt(jTextField2.getText()));
                    }
                    Emulicious.getProperties().setProperty("DisassemblerFormatCodeLabel", jTextField3.getText());
                    Emulicious.getProperties().setProperty("DisassemblerFormatDataLabel", jTextField4.getText());
                    Emulicious.getProperties().setProperty("DisassemblerFormatRAMlabel", jTextField5.getText());
                    Emulicious.getProperties().setProperty("DisassemblerFormatSRAMlabel", jTextField6.getText());
                    Emulicious.getProperties().setProperty("DisassemblerFormatPortLabel", jTextField7.getText());
                    Emulicious.getProperties().setProperty("DisassemblerCreateLinkFile", "" + jCheckBox2.isSelected());
                    Emulicious.getProperties().setProperty("DisassemblerUseAnonymousLabels", "" + jCheckBox3.isSelected());
                    Emulicious.getProperties().setProperty("DisassemblerUseUpperCaseMnemonics", "" + jCheckBox4.isSelected());
                    Emulicious.getProperties().setProperty("DisassemblerPadMnemonics", "" + jCheckBox5.isSelected());
                    Emulicious.getProperties().setProperty("DisassemblerAllowCallsToUnknownRAM", "" + jCheckBox6.isSelected());
                    Emulicious.saveAssemblerDialectSelection(jComboBox.getSelectedIndex());
                    DisassemblerSettingsDialog.this.result = true;
                    DisassemblerSettingsDialog.this.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(DisassemblerSettingsDialog.this, "Input size of datablocks is invalid. Please enter a non-negative integer number smaller than 2147483647 .", "Invalid input", 0);
                }
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jPanel10.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisassemblerSettingsDialog.this.dispose();
            }
        });
        jPanel10.add(jButton2);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", jButton2.getAction());
        this.add((Component)jPanel10, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(window);
        this.setVisible(true);
    }

    public boolean getResult() {
        return this.result;
    }
}

