/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.ClickableJLabel;
import common.FileChooser;
import common.MenuItem;
import common.ScreenUtilities;
import components.OutputListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import platform.Emulicious;
import platform.MemoryEditorModel;
import platform.MemoryTracer;

public class MemoryTracerWindow {
    static MemoryTracerWindow tracerWindow;
    final Window window;
    final MemoryEditorModel model;
    final JTabbedPane tabbedPane;
    JList<String> ram;
    JList<String> vram;
    JList<String> palettes;
    JList<String> sram;
    JList<?>[] additionalMemoryModels;
    private final OutputListener listener = new OutputListener(){

        @Override
        public void outputAvailable(int n, int n2, int n3) {
            MemoryTracerWindow.this.ram.repaint();
            MemoryTracerWindow.this.vram.repaint();
            MemoryTracerWindow.this.palettes.repaint();
            MemoryTracerWindow.this.sram.repaint();
            JList<?>[] jListArray = MemoryTracerWindow.this.additionalMemoryModels;
            int n4 = MemoryTracerWindow.this.additionalMemoryModels.length;
            int n5 = 0;
            while (n5 < n4) {
                JList<?> jList = jListArray[n5];
                jList.repaint();
                ++n5;
            }
        }
    };

    private MemoryTracerWindow(JFrame jFrame, MemoryEditorModel memoryEditorModel, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Memory Tracer");
        this.window.setIconImages(jFrame.getIconImages());
        this.window.setLayout(new BorderLayout());
        this.model = memoryEditorModel;
        this.tabbedPane = new JTabbedPane();
        this.updateTabs();
        this.tabbedPane.setEnabled(MemoryTracer.isEnabled());
        this.ram.setEnabled(MemoryTracer.isEnabled());
        this.vram.setEnabled(MemoryTracer.isEnabled());
        this.palettes.setEnabled(MemoryTracer.isEnabled());
        this.sram.setEnabled(MemoryTracer.isEnabled());
        this.window.add((Component)this.tabbedPane, "Center");
        MemoryTracer.addOutputListener(this.listener);
        final JCheckBox jCheckBox = new JCheckBox("Enabled", MemoryTracer.isEnabled());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryTracer.setEnabled(jCheckBox.isSelected());
                if (jCheckBox.isSelected()) {
                    Emulicious.getProperties().setProperty("MemoryTracer", "true");
                } else {
                    Emulicious.getProperties().remove("MemoryTracer");
                }
                MemoryTracerWindow.this.tabbedPane.setEnabled(MemoryTracer.isEnabled());
                MemoryTracerWindow.this.ram.setEnabled(MemoryTracer.isEnabled());
                MemoryTracerWindow.this.vram.setEnabled(MemoryTracer.isEnabled());
                MemoryTracerWindow.this.palettes.setEnabled(MemoryTracer.isEnabled());
                MemoryTracerWindow.this.sram.setEnabled(MemoryTracer.isEnabled());
                JList<?>[] jListArray = MemoryTracerWindow.this.additionalMemoryModels;
                int n = MemoryTracerWindow.this.additionalMemoryModels.length;
                int n2 = 0;
                while (n2 < n) {
                    JList<?> jList = jListArray[n2];
                    jList.setEnabled(MemoryTracer.isEnabled());
                    ++n2;
                }
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("Display file offsets for ROM", Boolean.parseBoolean(Emulicious.getProperties().getProperty("MemoryTracerDisplayFileOffsetsForROM")));
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryTracer.setDisplayFileOffsetsForROM(jCheckBox2.isSelected());
                Emulicious.getProperties().setProperty("MemoryTracerDisplayFileOffsetsForROM", Boolean.toString(jCheckBox2.isSelected()));
                MemoryTracerWindow.this.tabbedPane.repaint();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox2);
        this.window.add((Component)jPanel, "North");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuFile());
        if (tracerWindow == null || !tracerWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(jFrame);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(jFrame);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private void updateTabs() {
        int n = Math.max(0, this.tabbedPane.getSelectedIndex());
        this.tabbedPane.removeAll();
        this.ram = new JList<String>(new DefaultListModel<String>(){

            @Override
            public String getElementAt(int n) {
                return String.valueOf(MemoryTracerWindow.this.model.ramAddressToString(n)) + " <- " + MemoryTracerWindow.this.model.sourceToString(MemoryTracerWindow.this.model.getRAMsource(n));
            }

            @Override
            public int getSize() {
                return MemoryTracerWindow.this.model.getRAM().length;
            }
        });
        this.ram.setCellRenderer(new CellRenderer());
        this.ram.setPrototypeCellValue(this.ram.getModel().getElementAt(0));
        this.tabbedPane.add("RAM", new JScrollPane(this.ram));
        this.vram = new JList<String>(new DefaultListModel<String>(){

            @Override
            public String getElementAt(int n) {
                return String.valueOf(MemoryTracerWindow.this.model.vramAddressToString(n)) + " <- " + MemoryTracerWindow.this.model.traceToString(MemoryTracerWindow.this.model.getVRAMsource(n));
            }

            @Override
            public int getSize() {
                return MemoryTracerWindow.this.model.getVRAM().length;
            }
        });
        this.vram.setCellRenderer(new CellRenderer());
        this.vram.setPrototypeCellValue(this.vram.getModel().getElementAt(0));
        this.tabbedPane.add("VRAM", new JScrollPane(this.vram));
        this.palettes = new JList<String>(new DefaultListModel<String>(){

            @Override
            public String getElementAt(int n) {
                return String.valueOf(MemoryTracerWindow.this.model.palAddressToString(n)) + " <- " + MemoryTracerWindow.this.model.traceToString(MemoryTracerWindow.this.model.getColorSource(n));
            }

            @Override
            public int getSize() {
                return MemoryTracerWindow.this.model.getNumberOfPaletteBytes();
            }
        });
        this.palettes.setCellRenderer(new CellRenderer());
        this.palettes.setPrototypeCellValue(this.palettes.getModel().getElementAt(0));
        this.tabbedPane.add("Palettes", new JScrollPane(this.palettes));
        this.sram = new JList<String>(new DefaultListModel<String>(){

            @Override
            public String getElementAt(int n) {
                return String.valueOf(MemoryTracerWindow.this.model.sramAddressToString(n)) + " <- " + MemoryTracerWindow.this.model.traceToString(MemoryTracerWindow.this.model.getSRAMsource(n));
            }

            @Override
            public int getSize() {
                return MemoryTracerWindow.this.model.getSRAM().length;
            }
        });
        this.sram.setCellRenderer(new CellRenderer());
        this.sram.setPrototypeCellValue(this.sram.getModel().getElementAt(0));
        this.tabbedPane.add("SRAM", new JScrollPane(this.sram));
        MemoryEditorModel.MemoryModel[] memoryModelArray = this.model.getAdditionalMemoryModels();
        this.additionalMemoryModels = new JList[memoryModelArray.length];
        int n2 = 0;
        while (n2 < memoryModelArray.length) {
            final MemoryEditorModel.MemoryModel memoryModel = memoryModelArray[n2];
            JList<String> jList = new JList<String>(new DefaultListModel<String>(){

                @Override
                public String getElementAt(int n) {
                    return String.valueOf(memoryModel.addressToString(n)) + " <- " + memoryModel.getSource(n);
                }

                @Override
                public int getSize() {
                    return memoryModel.length();
                }
            });
            jList.setCellRenderer(new CellRenderer());
            this.additionalMemoryModels[n2] = jList;
            jList.setPrototypeCellValue(jList.getModel().getElementAt(0));
            if (memoryModel.getSource(0) != null) {
                this.tabbedPane.add(memoryModel.getName(), new JScrollPane(jList));
            }
            jList.setEnabled(MemoryTracer.isEnabled());
            ++n2;
        }
        if (n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    private JMenu makeMenuFile() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('f');
        MenuItem menuItem = new MenuItem("Save ROM Map As...", 115);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryTracerWindow.showSaveROMMapFileChooser(MemoryTracerWindow.this.window);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        menuItem = new MenuItem("Close", 108);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tracerWindow.setVisible(false);
            }
        });
        return jMenu;
    }

    static void showSaveROMMapFileChooser(Component component) {
        FileChooser fileChooser = new FileChooser(Emulicious.getROMfile().getParentFile());
        fileChooser.setDialogTitle("Save ROM Map As...");
        fileChooser.setSelectedFile(new File("ROM Map.txt"));
        if (fileChooser.showSaveDialog(component) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                MemoryTracer.printROMMap(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static SourceLabel createSourceLabel() {
        SourceLabel sourceLabel = new SourceLabel();
        return sourceLabel;
    }

    public static void open(JFrame jFrame, MemoryEditorModel memoryEditorModel, boolean bl) {
        if (tracerWindow == null) {
            tracerWindow = new MemoryTracerWindow(jFrame, memoryEditorModel, Emulicious.isUseFrames());
            tracerWindow.setVisible(true);
        } else if (!bl) {
            tracerWindow.setVisible(true);
        }
    }

    static void systemUpdated() {
        if (tracerWindow != null) {
            tracerWindow.updateTabs();
        }
    }

    public static void close() {
        if (tracerWindow != null) {
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Open", "" + tracerWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "X", "" + tracerWindow.getX());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Y", "" + tracerWindow.getY());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Width", "" + tracerWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + tracerWindow.getClass().getSimpleName() + "Height", "" + tracerWindow.getHeight());
            MemoryTracer.removeOutputListener(MemoryTracerWindow.tracerWindow.listener);
            tracerWindow.dispose();
            tracerWindow = null;
        }
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(null);
            }
            return component;
        }
    }

    public static class SourceLabel
    extends ClickableJLabel {
        private long source;

        public void setSource(long l) {
            this.source = l;
            this.setText(MemoryTracer.sourceToString(l));
            this.setToolTipText(l != 0L ? MemoryTracer.traceToString(l) : null);
        }

        private boolean canOpenPart(int n) {
            if (n < 0) {
                return false;
            }
            if (!MemoryTracer.isEnabled()) {
                return true;
            }
            long l = MemoryTracer.resolveTrace(this.source);
            return n == 1 ? MemoryTracer.isRomInstruction(l) : MemoryTracer.isRomSource(l) || MemoryTracer.isRamSource(l) || MemoryTracer.isSramSource(l) || MemoryTracer.isVramSource(l);
        }

        private void openPart(int n) {
            if (!this.canOpenPart(n)) {
                return;
            }
            if (!MemoryTracer.isEnabled()) {
                Emulicious.openMemoryTracer();
            } else {
                long l = MemoryTracer.resolveTrace(this.source);
                if (n == 0) {
                    if (MemoryTracer.isRomSource(l)) {
                        Emulicious.openMemoryEditorROM(MemoryTracer.getSourceAddress(l));
                    } else if (MemoryTracer.isRamSource(l)) {
                        Emulicious.openMemoryEditorRAM(MemoryTracer.getSourceAddress(l));
                    } else if (MemoryTracer.isSramSource(l)) {
                        Emulicious.openMemoryEditorSRAM(MemoryTracer.getSourceAddress(l));
                    } else if (MemoryTracer.isVramSource(l)) {
                        Emulicious.openMemoryEditorVRAM(MemoryTracer.getSourceAddress(l));
                    }
                } else if (n == 1 && MemoryTracer.isRomInstruction(l)) {
                    Emulicious.openDebugger(MemoryTracer.getInstructionAddress(l));
                }
            }
        }

        private int partAt(int n) {
            if (!MemoryTracer.isEnabled()) {
                return 0;
            }
            String string = this.getText();
            int n2 = string.indexOf("see");
            if (n >= n2 - " (".length() && n < n2 + "see ".length()) {
                return -1;
            }
            return n < n2 ? 0 : 1;
        }

        @Override
        protected boolean canClick(int n) {
            return this.canOpenPart(this.partAt(n));
        }

        @Override
        protected void indexClicked(int n) {
            this.openPart(this.partAt(n));
        }
    }
}

