/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.GenericDesktopUsage;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;
import net.java.games.input.OSXAbstractController;
import net.java.games.input.OSXComponent;
import net.java.games.input.OSXHIDDevice;
import net.java.games.input.OSXHIDDeviceIterator;
import net.java.games.input.OSXHIDElement;
import net.java.games.input.OSXHIDQueue;
import net.java.games.input.OSXKeyboard;
import net.java.games.input.OSXMouse;
import net.java.games.input.Rumbler;
import net.java.games.input.UsagePage;
import net.java.games.input.UsagePair;
import net.java.games.util.plugins.Plugin;

public final class OSXEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private static boolean supported = false;
    private final Controller[] controllers = this.isSupported() ? OSXEnvironmentPlugin.enumerateControllers() : new Controller[0];

    static {
        String string = OSXEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.equals("Mac OS X")) {
            supported = true;
            OSXEnvironmentPlugin.loadLibrary("jinput-osx");
        }
    }

    static void loadLibrary(final String string) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    String string2 = System.getProperty("net.java.games.input.librarypath");
                    if (string2 != null) {
                        System.load(String.valueOf(string2) + File.separator + System.mapLibraryName(string));
                    } else {
                        System.loadLibrary(string);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    unsatisfiedLinkError.printStackTrace();
                    supported = false;
                }
                return null;
            }
        });
    }

    static String getPrivilegedProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    static String getPrivilegedProperty(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    private static final boolean isMacOSXEqualsOrBetterThan(int n, int n2) {
        int n3;
        int n4;
        String string = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            n4 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            OSXEnvironmentPlugin.log("Exception occurred while trying to determine OS version: " + exception);
            return false;
        }
        return n4 > n || n4 == n && n3 >= n2;
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    private static final void addElements(OSXHIDQueue oSXHIDQueue, List<OSXHIDElement> list, List<OSXComponent> list2, boolean bl) throws IOException {
        for (OSXHIDElement oSXHIDElement : list) {
            Component.Identifier identifier = oSXHIDElement.getIdentifier();
            if (identifier == null) continue;
            if (bl) {
                if (identifier == Component.Identifier.Button._0) {
                    identifier = Component.Identifier.Button.LEFT;
                } else if (identifier == Component.Identifier.Button._1) {
                    identifier = Component.Identifier.Button.RIGHT;
                } else if (identifier == Component.Identifier.Button._2) {
                    identifier = Component.Identifier.Button.MIDDLE;
                }
            }
            OSXComponent oSXComponent = new OSXComponent(identifier, oSXHIDElement);
            list2.add(oSXComponent);
            oSXHIDQueue.addElement(oSXHIDElement, oSXComponent);
        }
    }

    private static final Keyboard createKeyboardFromDevice(OSXHIDDevice oSXHIDDevice, List<OSXHIDElement> list) throws IOException {
        ArrayList<OSXComponent> arrayList = new ArrayList<OSXComponent>();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list, arrayList, false);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        return new OSXKeyboard(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0]);
    }

    private static final Mouse createMouseFromDevice(OSXHIDDevice oSXHIDDevice, List<OSXHIDElement> list) throws IOException {
        ArrayList<OSXComponent> arrayList = new ArrayList<OSXComponent>();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list, arrayList, true);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXMouse oSXMouse = new OSXMouse(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0]);
        if (oSXMouse.getPrimaryButton() != null && oSXMouse.getX() != null && oSXMouse.getY() != null) {
            return oSXMouse;
        }
        oSXHIDQueue.release();
        return null;
    }

    private static final AbstractController createControllerFromDevice(OSXHIDDevice oSXHIDDevice, List<OSXHIDElement> list, Controller.Type type) throws IOException {
        ArrayList<OSXComponent> arrayList = new ArrayList<OSXComponent>();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list, arrayList, false);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        return new OSXAbstractController(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0], type);
    }

    private static final void createControllersFromDevice(OSXHIDDevice oSXHIDDevice, List<Controller> list) throws IOException {
        UsagePair usagePair = oSXHIDDevice.getUsagePair();
        if (usagePair == null) {
            return;
        }
        List<OSXHIDElement> list2 = oSXHIDDevice.getElements();
        if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && (usagePair.getUsage() == GenericDesktopUsage.MOUSE || usagePair.getUsage() == GenericDesktopUsage.POINTER)) {
            Mouse mouse = OSXEnvironmentPlugin.createMouseFromDevice(oSXHIDDevice, list2);
            if (mouse != null) {
                list.add(mouse);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && (usagePair.getUsage() == GenericDesktopUsage.KEYBOARD || usagePair.getUsage() == GenericDesktopUsage.KEYPAD)) {
            list.add(OSXEnvironmentPlugin.createKeyboardFromDevice(oSXHIDDevice, list2));
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.JOYSTICK) {
            list.add(OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list2, Controller.Type.STICK));
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.MULTI_AXIS_CONTROLLER) {
            list.add(OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list2, Controller.Type.STICK));
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.GAME_PAD) {
            list.add(OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list2, Controller.Type.GAMEPAD));
        }
    }

    private static final Controller[] enumerateControllers() {
        Controller[] controllerArray;
        ArrayList<Controller> arrayList;
        block12: {
            arrayList = new ArrayList<Controller>();
            try {
                controllerArray = new OSXHIDDeviceIterator();
                try {
                    while (true) {
                        try {
                            while (true) {
                                OSXHIDDevice oSXHIDDevice;
                                if ((oSXHIDDevice = controllerArray.next()) == null) {
                                    break block12;
                                }
                                boolean bl = false;
                                try {
                                    int n = arrayList.size();
                                    OSXEnvironmentPlugin.createControllersFromDevice(oSXHIDDevice, arrayList);
                                    bl = n != arrayList.size();
                                }
                                catch (IOException iOException) {
                                    OSXEnvironmentPlugin.log("Failed to create controllers from device: " + oSXHIDDevice.getProductName());
                                }
                                if (bl) continue;
                                oSXHIDDevice.release();
                            }
                        }
                        catch (IOException iOException) {
                            OSXEnvironmentPlugin.log("Failed to enumerate device: " + iOException.getMessage());
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    controllerArray.close();
                }
            }
            catch (IOException iOException) {
                OSXEnvironmentPlugin.log("Failed to enumerate devices: " + iOException.getMessage());
                return new Controller[0];
            }
        }
        controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }
}

