/*
 * Decompiled with CFR 0.152.
 */
package util.set;

import java.util.Arrays;
import util.set.IntSet;

public class IntHashSet
implements IntSet {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int KEY_FREE = 0;
    private int[] keys;
    private boolean hasFreeKey;
    private int size;
    private int threshold;
    private int mask;
    private final float loadFactor;
    private int[] cachedKeys;

    public IntHashSet(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.mask = n2 - 1;
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.keys = new int[n2];
        this.clear();
    }

    public IntHashSet(int n) {
        this(n, 0.75f);
    }

    public IntHashSet() {
        this(16, 0.75f);
    }

    private static final int hash(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >> 16;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(int n) {
        if (n == 0) {
            return this.hasFreeKey;
        }
        int n2 = IntHashSet.hash(n) & this.mask;
        int n3 = this.keys[n2];
        while (n3 != 0) {
            if (n3 == n) {
                return true;
            }
            n2 = n2 + 1 & this.mask;
            n3 = this.keys[n2];
        }
        return false;
    }

    @Override
    public void addAll(IntSet intSet) {
        int[] nArray = intSet.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.add(n3);
            ++n2;
        }
    }

    @Override
    public boolean add(int n) {
        if (n == 0) {
            return this.addFreeKey();
        }
        int n2 = IntHashSet.hash(n) & this.mask;
        int n3 = this.keys[n2];
        while (n3 != 0) {
            if (n3 == n) {
                return false;
            }
            n2 = n2 + 1 & this.mask;
            n3 = this.keys[n2];
        }
        this.addKey(n, n2);
        return true;
    }

    private final void addKey(int n, int n2) {
        this.keys[n2] = n;
        if (this.size++ >= this.threshold) {
            this.resize(this.keys.length << 1);
        }
        this.cachedKeys = null;
    }

    private final boolean addFreeKey() {
        if (this.hasFreeKey) {
            return false;
        }
        ++this.size;
        this.hasFreeKey = true;
        this.cachedKeys = null;
        return true;
    }

    private final void resize(int n) {
        if (this.keys.length == 0x40000000) {
            return;
        }
        int[] nArray = this.keys;
        this.keys = new int[n];
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.size = this.hasFreeKey ? 1 : 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 != 0) {
                this.add(n3);
            }
            ++n2;
        }
    }

    @Override
    public boolean remove(int n) {
        if (n == 0) {
            return this.removeFreeKey();
        }
        int n2 = IntHashSet.hash(n) & this.mask;
        int n3 = this.keys[n2];
        while (n3 != 0) {
            if (n3 == n) {
                int n4 = n2 + 1 & this.mask;
                int n5 = this.keys[n4];
                while (n3 != 0 && n5 != 0) {
                    int n6 = IntHashSet.hash(n5) & this.mask;
                    if (n4 != n6 && (n2 - n6 & this.mask) < this.mask >> 1) {
                        this.keys[n2] = n5;
                        n2 = n4;
                        n3 = n5;
                    }
                    n4 = n4 + 1 & this.mask;
                    n5 = this.keys[n4];
                }
                this.keys[n2] = 0;
                --this.size;
                this.cachedKeys = null;
                return true;
            }
            n2 = n2 + 1 & this.mask;
            n3 = this.keys[n2];
        }
        return false;
    }

    private final boolean removeFreeKey() {
        if (!this.hasFreeKey) {
            return false;
        }
        this.hasFreeKey = false;
        --this.size;
        this.cachedKeys = null;
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        this.hasFreeKey = false;
        this.size = 0;
        this.cachedKeys = null;
    }

    @Override
    public int[] keys() {
        if (this.cachedKeys == null) {
            this.cachedKeys = new int[this.size];
            int n = 0;
            if (this.hasFreeKey) {
                this.cachedKeys[n++] = 0;
            }
            int n2 = 0;
            while (n2 < this.keys.length) {
                int n3 = this.keys[n2];
                if (n3 != 0) {
                    this.cachedKeys[n++] = n3;
                }
                ++n2;
            }
        }
        return this.cachedKeys;
    }

    public String toString() {
        return Arrays.toString(this.keys());
    }
}

