/*
 * Decompiled with CFR 0.152.
 */
package testing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import platform.Emulicious;
import replay.Bk2ReplayData;
import replay.InputLog;
import testing.AssertionChecker;
import testing.InputBasedTestCaseRunner;
import util.map.HashMap;
import util.map.Map;

public class Bk2TestCaseRunner
implements InputBasedTestCaseRunner {
    private final Bk2ReplayData replayData;
    private final InputLog inputLog;
    private final AssertionChecker assertionChecker;
    private final Map<List<String>> assertions;
    private final String name;
    private boolean done;
    private Exception exception;
    private String failedAssertion;
    private int result;
    private int frame = 0;

    public Bk2TestCaseRunner(File file, AssertionChecker assertionChecker) throws IOException {
        this.replayData = new Bk2ReplayData(file);
        this.inputLog = Emulicious.getInputLog(this.replayData);
        this.assertionChecker = assertionChecker;
        try {
            this.assertions = Bk2TestCaseRunner.readAssertions(this.replayData);
        }
        catch (IOException iOException) {
            this.replayData.close();
            throw iOException;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        this.name = n >= 0 ? string.substring(0, n) : string;
    }

    private static Map<List<String>> readAssertions(Bk2ReplayData bk2ReplayData) throws IOException {
        HashMap<List<String>> hashMap = new HashMap<List<String>>();
        InputStream inputStream = bk2ReplayData.getFile("Assertions.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = string.indexOf(58);
            if (n < 0) {
                bufferedReader.close();
                throw new IOException("Missing colon in line: " + string);
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            try {
                int n2 = Integer.parseInt(string2);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(n2, arrayList);
                }
                arrayList.add(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Failed to parse frame number in line: " + string + " (" + numberFormatException.getMessage() + ")");
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return hashMap;
    }

    @Override
    public InputLog getInputLog() throws IOException {
        return this.inputLog;
    }

    @Override
    public void frameStarted() {
        List<String> list;
        if (this.done) {
            return;
        }
        if (!this.inputLog.hasNext()) {
            this.done = true;
            try {
                this.replayData.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if ((list = this.assertions.get(this.frame++)) != null) {
            try {
                for (String string : list) {
                    if (this.assertionChecker.checkAssertion(string)) continue;
                    this.result = 1;
                    this.failedAssertion = string;
                    this.done = true;
                    try {
                        this.replayData.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                this.exception = exception;
                this.result = -1;
                this.done = true;
                try {
                    this.replayData.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return !this.done;
    }

    @Override
    public String getTestCaseName() {
        return this.name;
    }

    @Override
    public int getResult() {
        return this.result;
    }

    @Override
    public String getFailedAssertion() {
        return this.failedAssertion;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }
}

