/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import components.cartridge.Cartridge;
import disassembler.AbstractCSourceMap;
import disassembler.Symbols;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sdcc.cdb.LinkerCRecord;
import sdcc.cdb.Record;
import util.map.HashMap;
import util.map.Map;

public class CDBSourceMap
extends AbstractCSourceMap {
    private final Map<LinkerCRecord> linkerCrecords = new HashMap<LinkerCRecord>();

    public CDBSourceMap(File file, List<Record> list, java.util.Map<String, List<Symbols.Symbol>> map, Cartridge cartridge) {
        super(file);
        for (Record record : list) {
            int n;
            int n2;
            if (!(record instanceof LinkerCRecord)) continue;
            LinkerCRecord linkerCRecord = (LinkerCRecord)record;
            List<Symbols.Symbol> list2 = map.get("C$" + linkerCRecord.getFilename() + "$" + linkerCRecord.getLineNumber() + "$" + linkerCRecord.getLevel() + "$" + linkerCRecord.getBlock());
            if (list2 != null && !list2.isEmpty()) {
                n2 = list2.get(0).getAddress();
                n = list2.get(0).getBank();
            } else {
                n2 = linkerCRecord.getEndAddress() & 0xFFFF;
                n = linkerCRecord.getEndAddress() / 65536;
            }
            this.linkerCrecords.put(cartridge.mapAddress(n2, n), linkerCRecord);
        }
    }

    public Set<String> determineFilesNotFound() {
        HashSet<String> hashSet = new HashSet<String>();
        for (LinkerCRecord linkerCRecord : this.linkerCrecords.values()) {
            if (this.findFile(linkerCRecord.getFilename()) != null) continue;
            hashSet.add(linkerCRecord.getFilename());
        }
        return hashSet;
    }

    @Override
    public int getLineNumberROM(int n) {
        LinkerCRecord linkerCRecord = this.linkerCrecords.get(n);
        return linkerCRecord != null ? linkerCRecord.getLineNumber() - 1 : -1;
    }

    @Override
    public File getFileROM(int n) {
        LinkerCRecord linkerCRecord = this.linkerCrecords.get(n);
        if (linkerCRecord == null) {
            return null;
        }
        return this.findFile(linkerCRecord.getFilename());
    }

    @Override
    public int getAddressROM(File file, int n) {
        if (this.findFile(file.getName()) != null) {
            for (Map.Entry<LinkerCRecord> entry : this.linkerCrecords.entrySet()) {
                if (entry.getValue().getLineNumber() - 1 != n || !file.getName().replace(' ', '_').replace('-', '_').equals(entry.getValue().getFilename())) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    @Override
    public boolean isValid() {
        return !this.linkerCrecords.isEmpty();
    }
}

