/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import disassembler.CSourceMap;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCSourceMap
implements CSourceMap {
    private static final File NO_FILE = new File("FILE_DOES_NOT_EXIST");
    private final List<File> srcFolders = new ArrayList<File>();
    private final Map<String, File> files = new HashMap<String, File>();

    protected AbstractCSourceMap(File file) {
        if (file.getParentFile() != null && !AbstractCSourceMap.isProjectFolder(file)) {
            if (AbstractCSourceMap.isProjectFolder(file.getParentFile())) {
                file = file.getParentFile();
            } else if (AbstractCSourceMap.isProjectFolder(file.getParentFile().getParentFile())) {
                file = file.getParentFile().getParentFile();
            } else if (file.getParentFile().getParentFile() != null && AbstractCSourceMap.isProjectFolder(file.getParentFile().getParentFile().getParentFile())) {
                file = file.getParentFile().getParentFile().getParentFile();
            }
        }
        this.srcFolders.add(file);
        if (new File(file, "msxgl_config.h").exists() && file.getParentFile() != null) {
            File file2 = new File(file.getParentFile(), "engine");
            if (!(file2.isDirectory() && new File(file2, "src").isDirectory() && new File(file2, "script").isDirectory())) {
                file2 = null;
            }
            if (file2 == null && !(file2 = new File(new File(file.getParentFile(), "MSXgl"), "engine")).isDirectory()) {
                file2 = null;
            }
            if (!(file2 != null || file.getParentFile().getParentFile() == null || (file2 = new File(file.getParentFile().getParentFile(), "engine")).isDirectory() && new File(file2, "src").isDirectory() && new File(file2, "script").isDirectory())) {
                file2 = null;
            }
            if (file2 != null) {
                this.srcFolders.add(new File(file2, "src"));
            }
            if (AbstractCSourceMap.isProjectFolder(file.getParentFile())) {
                this.srcFolders.add(file.getParentFile());
            }
        }
    }

    private static boolean isProjectFolder(File file) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        if (new File(file, "src").isDirectory()) {
            return true;
        }
        if (new File(file, ".vscode").isDirectory()) {
            return !new File(new File(file, ".vscode"), "extensions").isDirectory();
        }
        if (new File(file, "msxgl_config.h").exists()) {
            return true;
        }
        return new File(file, ".vs").isDirectory();
    }

    protected File findFile(String string) {
        if (string == null) {
            return null;
        }
        File file = this.files.get(string);
        if (file != null) {
            return file != NO_FILE ? file : null;
        }
        for (File file2 : this.srcFolders) {
            file = AbstractCSourceMap.findFile(file2, string);
            if (file != null) break;
        }
        this.files.put(string, file != null ? file : NO_FILE);
        return file;
    }

    private static File findFile(File file, final String string) {
        File[] fileArray;
        if (string == null) {
            return null;
        }
        File file2 = new File(file, string);
        if (file2.exists()) {
            return file2;
        }
        if (new File(string).isAbsolute()) {
            return new File(string);
        }
        if (file == null) {
            file = new File(".");
        }
        if ((fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return (string2.indexOf(32) >= 0 || string2.indexOf(45) >= 0) && string2.replace(' ', '_').replace('-', '_').equals(string);
            }
        })) != null && fileArray.length == 1) {
            return fileArray[0];
        }
        File[] fileArray2 = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray2 != null) {
            File[] fileArray3 = fileArray2;
            int n = fileArray2.length;
            int n2 = 0;
            while (n2 < n) {
                File file3;
                File file4 = fileArray3[n2];
                if (!file4.isHidden() && (file3 = AbstractCSourceMap.findFile(file4, string)) != null) {
                    return file3;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void addSrcFolder(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Failed to add additional source folder:\n" + file + " is not a directory.");
        }
        this.srcFolders.add(file);
    }
}

