/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.requests;

import dap.messages.Request;
import json.JSONObject;

public class InitializeRequest
extends Request {
    private final String clientID;
    private final String clientName;
    private final String adapterID;
    private final String locale;
    private final boolean linesStartAt1;
    private final boolean columnsStartAt1;
    private final String pathFormat;
    private final boolean supportsVariableType;
    private final boolean supportsVariablePaging;
    private final boolean supportsRunInTerminalRequest;
    private final boolean supportsMemoryReferences;
    private final boolean supportsProgressReporting;

    public InitializeRequest(JSONObject jSONObject) {
        super(jSONObject);
        JSONObject jSONObject2 = this.getArguments();
        this.clientID = jSONObject2.getString("clientID");
        this.clientName = jSONObject2.getString("clientName");
        this.adapterID = jSONObject2.getString("adapterID");
        if (this.adapterID == null) {
            throw new IllegalArgumentException("adapterID must be provided");
        }
        this.locale = jSONObject2.getString("locale");
        this.linesStartAt1 = jSONObject2.getBoolean("linesStartAt1", true);
        this.columnsStartAt1 = jSONObject2.getBoolean("columnsStartAt1", true);
        this.pathFormat = jSONObject2.getString("pathFormat", "path");
        this.supportsVariableType = jSONObject2.getBoolean("supportsVariableType");
        this.supportsVariablePaging = jSONObject2.getBoolean("supportsVariablePaging");
        this.supportsRunInTerminalRequest = jSONObject2.getBoolean("supportsRunInTerminalRequest");
        this.supportsMemoryReferences = jSONObject2.getBoolean("supportsMemoryReferences");
        this.supportsProgressReporting = jSONObject2.getBoolean("supportsProgressReporting");
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getAdapterID() {
        return this.adapterID;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isLinesStartAt1() {
        return this.linesStartAt1;
    }

    public boolean isColumnsStartAt1() {
        return this.columnsStartAt1;
    }

    public String getPathFormat() {
        return this.pathFormat;
    }

    public boolean isSupportsVariableType() {
        return this.supportsVariableType;
    }

    public boolean isSupportsVariablePaging() {
        return this.supportsVariablePaging;
    }

    public boolean isSupportsRunInTerminalRequest() {
        return this.supportsRunInTerminalRequest;
    }

    public boolean isSupportsMemoryReferences() {
        return this.supportsMemoryReferences;
    }

    public boolean isSupportsProgressReporting() {
        return this.supportsProgressReporting;
    }

    @Override
    public String toString() {
        return "InitializeRequest [clientID=" + this.clientID + ", clientName=" + this.clientName + ", adapterID=" + this.adapterID + ", locale=" + this.locale + ", linesStartAt1=" + this.linesStartAt1 + ", columnsStartAt1=" + this.columnsStartAt1 + ", pathFormat=" + this.pathFormat + ", supportsVariableType=" + this.supportsVariableType + ", supportsVariablePaging=" + this.supportsVariablePaging + ", supportsRunInTerminalRequest=" + this.supportsRunInTerminalRequest + ", supportsMemoryReferences=" + this.supportsMemoryReferences + ", supportsProgressReporting=" + this.supportsProgressReporting + "]";
    }
}

