/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.events;

import dap.messages.Event;
import json.JSONObject;

public class StoppedEvent
extends Event {
    private final Reason reason;
    private final String description;
    private final int threadId;
    private final Boolean preserveFocusHint;
    private final String text;
    private final Boolean allThreadsStopped;

    public StoppedEvent(Reason reason, int n) {
        this(reason, null, n, null, null, null);
    }

    public StoppedEvent(Reason reason, String string, int n, String string2) {
        this(reason, string, n, null, string2, null);
    }

    public StoppedEvent(Reason reason, String string, int n, Boolean bl, String string2, Boolean bl2) {
        if (reason == null) {
            throw new IllegalArgumentException("reason must not be null");
        }
        this.reason = reason;
        this.description = string;
        this.threadId = n;
        this.preserveFocusHint = bl;
        this.text = string2;
        this.allThreadsStopped = bl2;
    }

    @Override
    public String getEvent() {
        return "stopped";
    }

    @Override
    public JSONObject getBody() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("reason", this.reason.toString().toLowerCase().replace("_", " "));
        jSONObject.put("description", this.description);
        if (this.threadId >= 0) {
            jSONObject.put("threadId", this.threadId);
        }
        jSONObject.put("preserveFocusHint", (Object)this.preserveFocusHint);
        jSONObject.put("text", this.text);
        jSONObject.put("allThreadsStopped", (Object)this.allThreadsStopped);
        return jSONObject;
    }

    public static enum Reason {
        STEP,
        BREAKPOINT,
        EXCEPTION,
        PAUSE,
        ENTRY,
        GOTO,
        FUNCTION_BREAKPOINT,
        DATA_BREAKPOINT,
        INSTRUCTION_BREAKPOINT;

    }
}

