/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import java.util.Objects;
import java.util.WeakHashMap;

public class ResourceType {
    private static final WeakHashMap<String, ResourceType> types = new WeakHashMap(32);
    public static final ResourceType FILE_OPEN = ResourceType.of("file.open");
    public static final ResourceType FILE_READ = ResourceType.of("file.read");
    public static final ResourceType FILE_WRITE = ResourceType.of("file.write");
    public static final ResourceType STDERR_WRITE = ResourceType.of("stderr.write");
    public static final ResourceType STDIN_READ = ResourceType.of("stdin.read");
    public static final ResourceType STDOUT_WRITE = ResourceType.of("stdout.write");
    public static final ResourceType SOCKET_OPEN = ResourceType.of("socket.open");
    public static final ResourceType SOCKET_READ = ResourceType.of("socket.read");
    public static final ResourceType SOCKET_WRITE = ResourceType.of("socket.write");
    public static final ResourceType DATAGRAM_OPEN = ResourceType.of("datagram.open");
    public static final ResourceType DATAGRAM_RECEIVED = ResourceType.of("datagram.received");
    public static final ResourceType DATAGRAM_SENT = ResourceType.of("datagram.sent");
    public static final ResourceType DATAGRAM_READ = ResourceType.of("datagram.read");
    public static final ResourceType DATAGRAM_WRITE = ResourceType.of("datagram.write");
    public static final ResourceType THREAD_CREATED = ResourceType.of("thread.created");
    public static final ResourceType THREAD_CPU = ResourceType.of("thread.cpu");
    public static final ResourceType HEAP_RETAINED = ResourceType.of("heap.retained");
    public static final ResourceType HEAP_ALLOCATED = ResourceType.of("heap.allocated");
    public static final ResourceType FILEDESCRIPTOR_OPEN = ResourceType.of("filedescriptor.open");
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceType of(String string2) {
        WeakHashMap<String, ResourceType> weakHashMap = types;
        synchronized (weakHashMap) {
            return types.computeIfAbsent(string2, string -> new ResourceType((String)string));
        }
    }

    private ResourceType(String string) {
        this.name = Objects.requireNonNull(string, "name");
        if (string.length() == 0) {
            throw new IllegalArgumentException("name must not be empty");
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int n = 5;
        n = 17 * n + Objects.hashCode(this.name);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceType resourceType = (ResourceType)object;
        return Objects.equals(this.name, resourceType.name);
    }
}

