/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventFilter;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.SecondaryLoop;
import java.awt.SequencedEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.PeerEvent;
import sun.util.logging.PlatformLogger;

class WaitDispatchSupport
implements SecondaryLoop {
    private static final PlatformLogger log = PlatformLogger.getLogger("java.awt.event.WaitDispatchSupport");
    private EventDispatchThread dispatchThread;
    private EventFilter filter;
    private volatile Conditional extCondition;
    private volatile Conditional condition;
    private long interval;
    private static Timer timer;
    private TimerTask timerTask;
    private AtomicBoolean keepBlockingEDT = new AtomicBoolean(false);
    private AtomicBoolean keepBlockingCT = new AtomicBoolean(false);
    private final Runnable wakingRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.fine("Wake up EDT");
            Object object = WaitDispatchSupport.getTreeLock();
            synchronized (object) {
                WaitDispatchSupport.this.keepBlockingCT.set(false);
                WaitDispatchSupport.getTreeLock().notifyAll();
            }
            log.fine("Wake up EDT done");
        }
    };

    private static synchronized void initializeTimer() {
        if (timer == null) {
            timer = new Timer("AWT-WaitDispatchSupport-Timer", true);
        }
    }

    public WaitDispatchSupport(EventDispatchThread eventDispatchThread) {
        this(eventDispatchThread, null);
    }

    public WaitDispatchSupport(EventDispatchThread eventDispatchThread, Conditional conditional) {
        if (eventDispatchThread == null) {
            throw new IllegalArgumentException("The dispatchThread can not be null");
        }
        this.dispatchThread = eventDispatchThread;
        this.extCondition = conditional;
        this.condition = new Conditional(){

            @Override
            public boolean evaluate() {
                boolean bl;
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("evaluate(): blockingEDT=" + WaitDispatchSupport.this.keepBlockingEDT.get() + ", blockingCT=" + WaitDispatchSupport.this.keepBlockingCT.get());
                }
                boolean bl2 = bl = WaitDispatchSupport.this.extCondition != null ? WaitDispatchSupport.this.extCondition.evaluate() : true;
                if (!WaitDispatchSupport.this.keepBlockingEDT.get() || !bl) {
                    if (WaitDispatchSupport.this.timerTask != null) {
                        WaitDispatchSupport.this.timerTask.cancel();
                        WaitDispatchSupport.this.timerTask = null;
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public WaitDispatchSupport(EventDispatchThread eventDispatchThread, Conditional conditional, EventFilter eventFilter, long l) {
        this(eventDispatchThread, conditional);
        this.filter = eventFilter;
        if (l < 0L) {
            throw new IllegalArgumentException("The interval value must be >= 0");
        }
        this.interval = l;
        if (l != 0L) {
            WaitDispatchSupport.initializeTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enter() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("enter(): blockingEDT=" + this.keepBlockingEDT.get() + ", blockingCT=" + this.keepBlockingCT.get());
        }
        if (!this.keepBlockingEDT.compareAndSet(false, true)) {
            log.fine("The secondary loop is already running, aborting");
            return false;
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                log.fine("Starting a new event pump");
                if (WaitDispatchSupport.this.filter == null) {
                    WaitDispatchSupport.this.dispatchThread.pumpEvents(WaitDispatchSupport.this.condition);
                } else {
                    WaitDispatchSupport.this.dispatchThread.pumpEventsForFilter(WaitDispatchSupport.this.condition, WaitDispatchSupport.this.filter);
                }
            }
        };
        Thread thread = Thread.currentThread();
        if (thread == this.dispatchThread) {
            SequencedEvent sequencedEvent;
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("On dispatch thread: " + this.dispatchThread);
            }
            if (this.interval != 0L) {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("scheduling the timer for " + this.interval + " ms");
                }
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (WaitDispatchSupport.this.keepBlockingEDT.compareAndSet(true, false)) {
                            WaitDispatchSupport.this.wakeupEDT();
                        }
                    }
                };
                timer.schedule(this.timerTask, this.interval);
            }
            if ((sequencedEvent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentSequencedEvent()) != null) {
                if (log.isLoggable(PlatformLogger.Level.FINE)) {
                    log.fine("Dispose current SequencedEvent: " + sequencedEvent);
                }
                sequencedEvent.dispose();
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    runnable.run();
                    return null;
                }
            });
        } else {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("On non-dispatch thread: " + thread);
            }
            Object object = WaitDispatchSupport.getTreeLock();
            synchronized (object) {
                if (this.filter != null) {
                    this.dispatchThread.addEventFilter(this.filter);
                }
                try {
                    EventQueue eventQueue = this.dispatchThread.getEventQueue();
                    eventQueue.postEvent(new PeerEvent(this, runnable, 1L));
                    this.keepBlockingCT.set(true);
                    if (this.interval > 0L) {
                        long l = System.currentTimeMillis();
                        while (this.keepBlockingCT.get() && (this.extCondition == null || this.extCondition.evaluate()) && l + this.interval > System.currentTimeMillis()) {
                            WaitDispatchSupport.getTreeLock().wait(this.interval);
                        }
                    } else {
                        while (this.keepBlockingCT.get() && (this.extCondition == null || this.extCondition.evaluate())) {
                            WaitDispatchSupport.getTreeLock().wait();
                        }
                    }
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("waitDone " + this.keepBlockingEDT.get() + " " + this.keepBlockingCT.get());
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("Exception caught while waiting: " + interruptedException);
                    }
                }
                finally {
                    if (this.filter != null) {
                        this.dispatchThread.removeEventFilter(this.filter);
                    }
                }
                this.keepBlockingEDT.set(false);
                this.keepBlockingCT.set(false);
            }
        }
        return true;
    }

    @Override
    public boolean exit() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("exit(): blockingEDT=" + this.keepBlockingEDT.get() + ", blockingCT=" + this.keepBlockingCT.get());
        }
        if (this.keepBlockingEDT.compareAndSet(true, false)) {
            this.wakeupEDT();
            return true;
        }
        return false;
    }

    private static final Object getTreeLock() {
        return Component.LOCK;
    }

    private void wakeupEDT() {
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("wakeupEDT(): EDT == " + this.dispatchThread);
        }
        EventQueue eventQueue = this.dispatchThread.getEventQueue();
        eventQueue.postEvent(new PeerEvent(this, this.wakingRunnable, 1L));
    }
}

