/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeProxy;
import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.utils.FastStringBuffer;
import com.sun.org.apache.xml.internal.utils.NSInfo;
import com.sun.org.apache.xml.internal.utils.StringBufferPool;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMHelper {
    Hashtable m_NSInfos = new Hashtable();
    protected static final NSInfo m_NSInfoUnProcWithXMLNS = new NSInfo(false, true);
    protected static final NSInfo m_NSInfoUnProcWithoutXMLNS = new NSInfo(false, false);
    protected static final NSInfo m_NSInfoUnProcNoAncestorXMLNS = new NSInfo(false, false, 2);
    protected static final NSInfo m_NSInfoNullWithXMLNS = new NSInfo(true, true);
    protected static final NSInfo m_NSInfoNullWithoutXMLNS = new NSInfo(true, false);
    protected static final NSInfo m_NSInfoNullNoAncestorXMLNS = new NSInfo(true, false, 2);
    protected Vector m_candidateNoAncestorXMLNS = new Vector();
    protected Document m_DOMFactory = null;

    public static Document createDocument(boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            if (bl) {
                try {
                    documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_CREATEDOCUMENT_NOT_SUPPORTED", null));
        }
    }

    public static Document createDocument() {
        return DOMHelper.createDocument(false);
    }

    public boolean shouldStripSourceNode(Node node) throws TransformerException {
        return false;
    }

    public String getUniqueID(Node node) {
        return "N" + Integer.toHexString(node.hashCode()).toUpperCase();
    }

    public static boolean isNodeAfter(Node node, Node node2) {
        Node node3;
        if (node == node2 || DOMHelper.isNodeTheSame(node, node2)) {
            return true;
        }
        boolean bl = true;
        Node node4 = DOMHelper.getParentOfNode(node);
        if (node4 == (node3 = DOMHelper.getParentOfNode(node2)) || DOMHelper.isNodeTheSame(node4, node3)) {
            if (null != node4) {
                bl = DOMHelper.isNodeAfterSibling(node4, node, node2);
            }
        } else {
            int n;
            int n2;
            int n3 = 2;
            int n4 = 2;
            while (node4 != null) {
                ++n3;
                node4 = DOMHelper.getParentOfNode(node4);
            }
            while (node3 != null) {
                ++n4;
                node3 = DOMHelper.getParentOfNode(node3);
            }
            Node node5 = node;
            Node node6 = node2;
            if (n3 < n4) {
                n2 = n4 - n3;
                for (n = 0; n < n2; ++n) {
                    node6 = DOMHelper.getParentOfNode(node6);
                }
            } else if (n3 > n4) {
                n2 = n3 - n4;
                for (n = 0; n < n2; ++n) {
                    node5 = DOMHelper.getParentOfNode(node5);
                }
            }
            Node node7 = null;
            Node node8 = null;
            while (null != node5) {
                if (node5 == node6 || DOMHelper.isNodeTheSame(node5, node6)) {
                    if (null == node7) {
                        bl = n3 < n4;
                        break;
                    }
                    bl = DOMHelper.isNodeAfterSibling(node5, node7, node8);
                    break;
                }
                node7 = node5;
                node5 = DOMHelper.getParentOfNode(node5);
                node8 = node6;
                node6 = DOMHelper.getParentOfNode(node6);
            }
        }
        return bl;
    }

    public static boolean isNodeTheSame(Node node, Node node2) {
        if (node instanceof DTMNodeProxy && node2 instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).equals((DTMNodeProxy)node2);
        }
        return node == node2;
    }

    private static boolean isNodeAfterSibling(Node node, Node node2, Node node3) {
        boolean bl = false;
        short s = node2.getNodeType();
        short s2 = node3.getNodeType();
        if (2 != s && 2 == s2) {
            bl = false;
        } else if (2 == s && 2 != s2) {
            bl = true;
        } else if (2 == s) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < n; ++i) {
                Node node4 = namedNodeMap.item(i);
                if (node2 == node4 || DOMHelper.isNodeTheSame(node2, node4)) {
                    if (bl3) {
                        bl = false;
                        break;
                    }
                    bl2 = true;
                    continue;
                }
                if (node3 != node4 && !DOMHelper.isNodeTheSame(node3, node4)) continue;
                if (bl2) {
                    bl = true;
                    break;
                }
                bl3 = true;
            }
        } else {
            boolean bl4 = false;
            boolean bl5 = false;
            for (Node node5 = node.getFirstChild(); null != node5; node5 = node5.getNextSibling()) {
                if (node2 == node5 || DOMHelper.isNodeTheSame(node2, node5)) {
                    if (bl5) {
                        bl = false;
                        break;
                    }
                    bl4 = true;
                    continue;
                }
                if (node3 != node5 && !DOMHelper.isNodeTheSame(node3, node5)) continue;
                if (bl4) {
                    bl = true;
                    break;
                }
                bl5 = true;
            }
        }
        return bl;
    }

    public short getLevel(Node node) {
        short s = 1;
        while (null != (node = DOMHelper.getParentOfNode(node))) {
            s = (short)(s + 1);
        }
        return s;
    }

    public String getNamespaceForPrefix(String string, Element element) {
        Node node = element;
        String string2 = null;
        if (string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else if (string.equals("xmlns")) {
            string2 = "http://www.w3.org/2000/xmlns/";
        } else {
            short s;
            String string3;
            String string4 = string3 = string == "" ? "xmlns" : "xmlns:" + string;
            while (null != node && null == string2 && ((s = node.getNodeType()) == 1 || s == 5)) {
                Attr attr;
                if (s == 1 && (attr = node.getAttributeNode(string3)) != null) {
                    string2 = attr.getNodeValue();
                    break;
                }
                node = DOMHelper.getParentOfNode(node);
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNamespaceOfNode(Node node) {
        String string;
        boolean bl;
        NSInfo nSInfo;
        short s = node.getNodeType();
        if (2 != s) {
            Object v = this.m_NSInfos.get(node);
            nSInfo = v == null ? null : (NSInfo)v;
            bl = nSInfo == null ? false : nSInfo.m_hasProcessedNS;
        } else {
            bl = false;
            nSInfo = null;
        }
        if (bl) {
            return nSInfo.m_namespace;
        }
        String string2 = null;
        String string3 = node.getNodeName();
        int n = string3.indexOf(58);
        if (2 == s) {
            if (n <= 0) return string2;
            string = string3.substring(0, n);
        } else {
            string = n >= 0 ? string3.substring(0, n) : "";
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else {
            Node node2 = node;
            while (null != node2 && null == string2 && (null == nSInfo || nSInfo.m_ancestorHasXMLNSAttrs != 2)) {
                short s2 = node2.getNodeType();
                if (null == nSInfo || nSInfo.m_hasXMLNSAttrs) {
                    boolean bl4 = false;
                    if (s2 == 1) {
                        NamedNodeMap namedNodeMap = node2.getAttributes();
                        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                            String string4;
                            Node node3 = namedNodeMap.item(i);
                            String string5 = node3.getNodeName();
                            if (string5.charAt(0) != 'x') continue;
                            boolean bl5 = string5.startsWith("xmlns:");
                            if (!string5.equals("xmlns") && !bl5) continue;
                            if (node == node2) {
                                bl3 = true;
                            }
                            bl4 = true;
                            bl2 = true;
                            String string6 = string4 = bl5 ? string5.substring(6) : "";
                            if (!string4.equals(string)) continue;
                            string2 = node3.getNodeValue();
                            break;
                        }
                    }
                    if (2 != s2 && null == nSInfo && node != node2) {
                        nSInfo = bl4 ? m_NSInfoUnProcWithXMLNS : m_NSInfoUnProcWithoutXMLNS;
                        this.m_NSInfos.put(node2, nSInfo);
                    }
                }
                if (2 == s2) {
                    node2 = DOMHelper.getParentOfNode(node2);
                } else {
                    this.m_candidateNoAncestorXMLNS.addElement(node2);
                    this.m_candidateNoAncestorXMLNS.addElement(nSInfo);
                    node2 = node2.getParentNode();
                }
                if (null == node2) continue;
                Object v = this.m_NSInfos.get(node2);
                nSInfo = v == null ? null : (NSInfo)v;
            }
            int n2 = this.m_candidateNoAncestorXMLNS.size();
            if (n2 > 0) {
                if (!bl2 && null == node2) {
                    for (int i = 0; i < n2; i += 2) {
                        Object e = this.m_candidateNoAncestorXMLNS.elementAt(i + 1);
                        if (e == m_NSInfoUnProcWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(i), m_NSInfoUnProcNoAncestorXMLNS);
                            continue;
                        }
                        if (e != m_NSInfoNullWithoutXMLNS) continue;
                        this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(i), m_NSInfoNullNoAncestorXMLNS);
                    }
                }
                this.m_candidateNoAncestorXMLNS.removeAllElements();
            }
        }
        if (2 == s) return string2;
        if (null == string2) {
            if (bl2) {
                if (bl3) {
                    this.m_NSInfos.put(node, m_NSInfoNullWithXMLNS);
                    return string2;
                } else {
                    this.m_NSInfos.put(node, m_NSInfoNullWithoutXMLNS);
                }
                return string2;
            } else {
                this.m_NSInfos.put(node, m_NSInfoNullNoAncestorXMLNS);
            }
            return string2;
        } else {
            this.m_NSInfos.put(node, new NSInfo(string2, bl3));
        }
        return string2;
    }

    public String getLocalNameOfNode(Node node) {
        String string = node.getNodeName();
        int n = string.indexOf(58);
        return n < 0 ? string : string.substring(n + 1);
    }

    public String getExpandedElementName(Element element) {
        String string = this.getNamespaceOfNode(element);
        return null != string ? string + ":" + this.getLocalNameOfNode(element) : this.getLocalNameOfNode(element);
    }

    public String getExpandedAttributeName(Attr attr) {
        String string = this.getNamespaceOfNode(attr);
        return null != string ? string + ":" + this.getLocalNameOfNode(attr) : this.getLocalNameOfNode(attr);
    }

    public boolean isIgnorableWhitespace(Text text) {
        boolean bl = false;
        return bl;
    }

    public Node getRoot(Node node) {
        Node node2 = null;
        while (node != null) {
            node2 = node;
            node = DOMHelper.getParentOfNode(node);
        }
        return node2;
    }

    public Node getRootNode(Node node) {
        short s = node.getNodeType();
        return 9 == s || 11 == s ? node : node.getOwnerDocument();
    }

    public boolean isNamespaceNode(Node node) {
        if (2 == node.getNodeType()) {
            String string = node.getNodeName();
            return string.startsWith("xmlns:") || string.equals("xmlns");
        }
        return false;
    }

    public static Node getParentOfNode(Node node) throws RuntimeException {
        Node node2;
        short s = node.getNodeType();
        if (2 == s) {
            Document document = node.getOwnerDocument();
            DOMImplementation dOMImplementation = document.getImplementation();
            if (dOMImplementation != null && dOMImplementation.hasFeature("Core", "2.0")) {
                Element element = ((Attr)node).getOwnerElement();
                return element;
            }
            Element element = document.getDocumentElement();
            if (null == element) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_CHILD_HAS_NO_OWNER_DOCUMENT_ELEMENT", null));
            }
            node2 = DOMHelper.locateAttrParent(element, node);
        } else {
            node2 = node.getParentNode();
        }
        return node2;
    }

    public Element getElementByID(String string, Document document) {
        return null;
    }

    public String getUnparsedEntityURI(String string, Document document) {
        String string2 = "";
        DocumentType documentType = document.getDoctype();
        if (null != documentType) {
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (null == namedNodeMap) {
                return string2;
            }
            Entity entity = (Entity)namedNodeMap.getNamedItem(string);
            if (null == entity) {
                return string2;
            }
            String string3 = entity.getNotationName();
            if (null != string3 && null == (string2 = entity.getSystemId())) {
                string2 = entity.getPublicId();
            }
        }
        return string2;
    }

    private static Node locateAttrParent(Element element, Node node) {
        Node node2 = null;
        Attr attr = element.getAttributeNode(node.getNodeName());
        if (attr == node) {
            node2 = element;
        }
        if (null == node2) {
            for (Node node3 = element.getFirstChild(); null != node3 && (1 != node3.getNodeType() || null == (node2 = DOMHelper.locateAttrParent((Element)node3, node))); node3 = node3.getNextSibling()) {
            }
        }
        return node2;
    }

    public void setDOMFactory(Document document) {
        this.m_DOMFactory = document;
    }

    public Document getDOMFactory() {
        if (null == this.m_DOMFactory) {
            this.m_DOMFactory = DOMHelper.createDocument();
        }
        return this.m_DOMFactory;
    }

    public static String getNodeData(Node node) {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            DOMHelper.getNodeData(node, fastStringBuffer);
            string = fastStringBuffer.length() > 0 ? fastStringBuffer.toString() : "";
        }
        finally {
            StringBufferPool.free(fastStringBuffer);
        }
        return string;
    }

    public static void getNodeData(Node node, FastStringBuffer fastStringBuffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                for (Node node2 = node.getFirstChild(); null != node2; node2 = node2.getNextSibling()) {
                    DOMHelper.getNodeData(node2, fastStringBuffer);
                }
                break;
            }
            case 3: 
            case 4: {
                fastStringBuffer.append(node.getNodeValue());
                break;
            }
            case 2: {
                fastStringBuffer.append(node.getNodeValue());
                break;
            }
            case 7: {
                break;
            }
        }
    }
}

