/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="java.net.AbstractPlainSocketImpl")
abstract class AbstractPlainSocketImplRMHooks {
    protected FileDescriptor fd;

    AbstractPlainSocketImplRMHooks() {
    }

    abstract void socketClose0(boolean var1);

    @InstrumentationMethod
    protected synchronized void create(boolean bl) throws IOException {
        this.create(bl);
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.fd);
        ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                this.socketClose0(false);
                throw new IOException("Resource limited: too many open file descriptors");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            resourceRequest.request(-l, resourceIdImpl);
            this.socketClose0(false);
            throw new IOException("Resource limited: too many open file descriptors", resourceRequestDeniedException);
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    protected void close() throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        int n = -1;
        if (this.fd != null) {
            resourceIdImpl = ResourceIdImpl.of(this.fd);
            resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
        }
        try {
            this.close();
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
    }
}

