/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.client.ServiceInterceptor;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class ServiceInterceptorFactory {
    private static ThreadLocal<Set<ServiceInterceptorFactory>> threadLocalFactories = new ThreadLocal<Set<ServiceInterceptorFactory>>(){

        @Override
        protected Set<ServiceInterceptorFactory> initialValue() {
            return new HashSet<ServiceInterceptorFactory>();
        }
    };

    public abstract ServiceInterceptor create(@NotNull WSService var1);

    @NotNull
    public static ServiceInterceptor load(@NotNull WSService wSService, @Nullable ClassLoader classLoader) {
        ArrayList<ServiceInterceptor> arrayList = new ArrayList<ServiceInterceptor>();
        for (ServiceInterceptorFactory serviceInterceptorFactory : ServiceFinder.find(ServiceInterceptorFactory.class)) {
            arrayList.add(serviceInterceptorFactory.create(wSService));
        }
        for (ServiceInterceptorFactory serviceInterceptorFactory : threadLocalFactories.get()) {
            arrayList.add(serviceInterceptorFactory.create(wSService));
        }
        return ServiceInterceptor.aggregate(arrayList.toArray(new ServiceInterceptor[arrayList.size()]));
    }

    public static boolean registerForThread(ServiceInterceptorFactory serviceInterceptorFactory) {
        return threadLocalFactories.get().add(serviceInterceptorFactory);
    }

    public static boolean unregisterForThread(ServiceInterceptorFactory serviceInterceptorFactory) {
        return threadLocalFactories.get().remove(serviceInterceptorFactory);
    }
}

