/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.util;

public class BufferAllocator {
    public static int SMALL_SIZE_LIMIT = 128;
    public static int MEDIUM_SIZE_LIMIT = 2048;
    public static int LARGE_SIZE_LIMIT = 8192;
    char[] smallCharBuffer;
    char[] mediumCharBuffer;
    char[] largeCharBuffer;
    byte[] smallByteBuffer;
    byte[] mediumByteBuffer;
    byte[] largeByteBuffer;

    public char[] getCharBuffer(int n) {
        if (n <= SMALL_SIZE_LIMIT) {
            char[] cArray = this.smallCharBuffer;
            this.smallCharBuffer = null;
            return cArray;
        }
        if (n <= MEDIUM_SIZE_LIMIT) {
            char[] cArray = this.mediumCharBuffer;
            this.mediumCharBuffer = null;
            return cArray;
        }
        if (n <= LARGE_SIZE_LIMIT) {
            char[] cArray = this.largeCharBuffer;
            this.largeCharBuffer = null;
            return cArray;
        }
        return null;
    }

    public void returnCharBuffer(char[] cArray) {
        if (cArray == null) {
            return;
        }
        if (cArray.length <= SMALL_SIZE_LIMIT) {
            this.smallCharBuffer = cArray;
        } else if (cArray.length <= MEDIUM_SIZE_LIMIT) {
            this.mediumCharBuffer = cArray;
        } else if (cArray.length <= LARGE_SIZE_LIMIT) {
            this.largeCharBuffer = cArray;
        }
    }

    public byte[] getByteBuffer(int n) {
        if (n <= SMALL_SIZE_LIMIT) {
            byte[] byArray = this.smallByteBuffer;
            this.smallByteBuffer = null;
            return byArray;
        }
        if (n <= MEDIUM_SIZE_LIMIT) {
            byte[] byArray = this.mediumByteBuffer;
            this.mediumByteBuffer = null;
            return byArray;
        }
        if (n <= LARGE_SIZE_LIMIT) {
            byte[] byArray = this.largeByteBuffer;
            this.largeByteBuffer = null;
            return byArray;
        }
        return null;
    }

    public void returnByteBuffer(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (byArray.length <= SMALL_SIZE_LIMIT) {
            this.smallByteBuffer = byArray;
        } else if (byArray.length <= MEDIUM_SIZE_LIMIT) {
            this.mediumByteBuffer = byArray;
        } else if (byArray.length <= LARGE_SIZE_LIMIT) {
            this.largeByteBuffer = byArray;
        }
    }
}

