/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.model.impl;

import com.sun.xml.internal.bind.api.impl.NameConverter;
import com.sun.xml.internal.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.PropertyKind;
import com.sun.xml.internal.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.PropertySeed;
import com.sun.xml.internal.bind.v2.model.impl.SingleTypePropertyInfoImpl;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;

class AttributePropertyInfoImpl<TypeT, ClassDeclT, FieldT, MethodT>
extends SingleTypePropertyInfoImpl<TypeT, ClassDeclT, FieldT, MethodT>
implements AttributePropertyInfo<TypeT, ClassDeclT> {
    private final QName xmlName;
    private final boolean isRequired;

    AttributePropertyInfoImpl(ClassInfoImpl<TypeT, ClassDeclT, FieldT, MethodT> classInfoImpl, PropertySeed<TypeT, ClassDeclT, FieldT, MethodT> propertySeed) {
        super(classInfoImpl, propertySeed);
        XmlAttribute xmlAttribute = propertySeed.readAnnotation(XmlAttribute.class);
        assert (xmlAttribute != null);
        this.isRequired = xmlAttribute.required() ? true : this.nav().isPrimitive(this.getIndividualType());
        this.xmlName = this.calcXmlName(xmlAttribute);
    }

    private QName calcXmlName(XmlAttribute xmlAttribute) {
        String string = xmlAttribute.namespace();
        String string2 = xmlAttribute.name();
        if (string2.equals("##default")) {
            string2 = NameConverter.standard.toVariableName(this.getName());
        }
        if (string.equals("##default")) {
            XmlSchema xmlSchema = this.reader().getPackageAnnotation(XmlSchema.class, this.parent.getClazz(), this);
            if (xmlSchema != null) {
                switch (xmlSchema.attributeFormDefault()) {
                    case QUALIFIED: {
                        string = this.parent.getTypeName().getNamespaceURI();
                        if (string.length() != 0) break;
                        string = this.parent.builder.defaultNsUri;
                        break;
                    }
                    case UNQUALIFIED: 
                    case UNSET: {
                        string = "";
                    }
                }
            } else {
                string = "";
            }
        }
        return new QName(string.intern(), string2.intern());
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public final QName getXmlName() {
        return this.xmlName;
    }

    @Override
    public final PropertyKind kind() {
        return PropertyKind.ATTRIBUTE;
    }
}

