/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import platform.debugger.BreakpointWindow;
import platform.debugger.Debugger;

class BreakpointSelectionWindow
extends JDialog {
    private JTable table;

    private BreakpointSelectionWindow(Window window, Debugger debugger) {
        super(window, "Select Breakpoint As Trigger For Overlay", DEFAULT_MODALITY_TYPE);
        this.setIconImage(window.getIconImages().get(0));
        this.table = BreakpointWindow.createBreakpointsTable(debugger);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        JPanel jPanel = BreakpointWindow.createBreakpointsPanel(this.table, debugger);
        jPanel.setBorder(BorderFactory.createTitledBorder("Select Breakpoint As Trigger For Overlay"));
        this.add((Component)jPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BreakpointSelectionWindow.this.table.clearSelection();
                BreakpointSelectionWindow.this.dispose();
            }
        });
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointSelectionWindow.this.dispose();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointSelectionWindow.this.table.clearSelection();
                BreakpointSelectionWindow.this.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.add((Component)jPanel2, "South");
        this.pack();
        this.setLocationRelativeTo(window);
        this.setVisible(true);
    }

    private int getSelectedRow() {
        return this.table.getSelectedRow() < this.table.getRowCount() - 1 ? this.table.getSelectedRow() : -1;
    }

    public static int open(Window window, Debugger debugger) {
        return new BreakpointSelectionWindow(window, debugger).getSelectedRow();
    }
}

