/*
 * Decompiled with CFR 0.152.
 */
package network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import network.SerialTransferListener;

public class Network {
    private SerialTransferListener serialTransferListener;
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private Socket ackSocket;
    private OutputStream out;
    private InputStream in;
    private OutputStream ackOut;
    private InputStream ackIn;
    private int data;
    private volatile int control;
    private volatile int opponentData;
    private volatile int opponentControl;
    private Thread acceptorThread;
    private Thread connectorThread;
    private Thread receiverThread;

    public void listen(int n) {
        if (this.clientSocket != null) {
            return;
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = new ServerSocket(n);
                System.out.println("Listening on port " + n);
                this.accept();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void accept() {
        if (this.acceptorThread == null) {
            this.acceptorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Network.this.clientSocket = Network.this.serverSocket.accept();
                            Network.this.ackSocket = Network.this.serverSocket.accept();
                            System.out.println("Connection accepted from " + Network.this.clientSocket.getInetAddress().getCanonicalHostName());
                            Network.this.setupSockets();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            Network.this.acceptorThread = null;
                        }
                    }
                    finally {
                        Network.this.acceptorThread = null;
                    }
                }
            }, "Connection Acceptor Thread");
            this.acceptorThread.start();
        }
    }

    public void connect(String string, int n) {
        this.connect(string, n, false);
    }

    public void connect(final String string, final int n, final boolean bl) {
        if (this.serverSocket != null) {
            return;
        }
        if (this.clientSocket == null && this.connectorThread == null) {
            this.connectorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Network.this.clientSocket = new Socket(string, n);
                            Network.this.ackSocket = new Socket(string, n);
                            System.out.println("Connection to " + string + " established");
                            Network.this.setupSockets();
                        }
                        catch (UnknownHostException unknownHostException) {
                            unknownHostException.printStackTrace();
                            Network.this.connectorThread = null;
                        }
                        catch (IOException iOException) {
                            block9: {
                                if (bl) {
                                    Network.this.listen(n);
                                    break block9;
                                }
                                iOException.printStackTrace();
                            }
                            Network.this.connectorThread = null;
                        }
                    }
                    finally {
                        Network.this.connectorThread = null;
                    }
                }
            }, "Connector Thread");
            this.connectorThread.start();
        }
    }

    private void setupSockets() {
        try {
            this.clientSocket.setTcpNoDelay(true);
            this.ackSocket.setTcpNoDelay(true);
            this.ackSocket.setSoTimeout(100);
            this.out = this.clientSocket.getOutputStream();
            this.in = this.clientSocket.getInputStream();
            this.ackOut = this.ackSocket.getOutputStream();
            this.ackIn = this.ackSocket.getInputStream();
            this.startReceiverThread();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void startReceiverThread() {
        if (this.receiverThread == null) {
            this.receiverThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            while (Network.this.in != null) {
                                int n;
                                int n2 = Network.this.receive();
                                int n3 = Network.this.receive();
                                Network network = Network.this;
                                synchronized (network) {
                                    Network.this.opponentData = n2;
                                    Network.this.opponentControl = n3;
                                    n = Network.this.control;
                                }
                                if ((n & n3 & 0x80) == 0 || ((n ^ n3) & 1) == 0) continue;
                                Network.this.startSerialTransfer();
                            }
                        }
                        catch (Exception exception) {
                            Network.this.receiverThread = null;
                        }
                    }
                    finally {
                        Network.this.receiverThread = null;
                    }
                }
            }, "Receiver Thread");
            this.receiverThread.start();
        }
    }

    public boolean isConnected() {
        return this.in != null && this.out != null;
    }

    public String getHostName() {
        return this.clientSocket.getInetAddress().getCanonicalHostName();
    }

    public String getState() {
        if (this.in != null && this.out != null) {
            return "Game Link connected to " + this.clientSocket.getInetAddress().getCanonicalHostName();
        }
        if (this.serverSocket != null) {
            return "Listening for Game Link connections";
        }
        return "";
    }

    private void send(int n, int n2) {
        block3: {
            try {
                if (this.out != null) {
                    byte[] byArray = new byte[]{(byte)n, (byte)n2};
                    this.out.write(byArray);
                }
            }
            catch (IOException iOException) {
                this.out = null;
                if (this.serverSocket == null) break block3;
                this.accept();
            }
        }
    }

    private void sendAck() {
        try {
            if (this.ackOut != null) {
                this.ackOut.write(0);
            }
        }
        catch (IOException iOException) {
            this.ackOut = null;
        }
    }

    private void waitForAck() {
        try {
            if (this.ackIn != null) {
                this.ackIn.read();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException iOException) {
            this.ackIn = null;
        }
    }

    private int receive() {
        block3: {
            try {
                if (this.in != null) {
                    return this.in.read();
                }
            }
            catch (IOException iOException) {
                this.in = null;
                if (this.serverSocket == null) break block3;
                this.accept();
            }
        }
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSerialTransfer(int n, int n2) {
        if (!this.isConnected() && (n2 & 1) != 0) {
            this.serialTransferListener.transferStarted();
            this.serialTransferListener.transferFinished(255);
        } else if (this.data != n || this.control != n2) {
            int n3;
            Network network = this;
            synchronized (network) {
                this.data = n;
                this.control = n2;
                this.send(n, n2);
                n3 = this.opponentControl;
            }
            if ((n2 & n3 & 0x80) != 0 && ((n2 ^ n3) & 1) != 0) {
                new Thread(){

                    @Override
                    public void run() {
                        Network.this.startSerialTransfer();
                    }
                }.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSerialTransfer() {
        this.sendAck();
        this.serialTransferListener.transferStarted();
        this.waitForAck();
        Network network = this;
        synchronized (network) {
            this.serialTransferListener.transferFinished(this.opponentData);
            this.control &= 0x7F;
            this.opponentControl &= 0x7F;
        }
    }

    public void setSerialTransferListener(SerialTransferListener serialTransferListener) {
        this.serialTransferListener = serialTransferListener;
    }
}

