/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class Policy
implements Iterable<AssertionSet> {
    private static final String POLICY_TOSTRING_NAME = "policy";
    private static final List<AssertionSet> NULL_POLICY_ASSERTION_SETS = Collections.unmodifiableList(new LinkedList());
    private static final List<AssertionSet> EMPTY_POLICY_ASSERTION_SETS = Collections.unmodifiableList(new LinkedList<AssertionSet>(Arrays.asList(AssertionSet.emptyAssertionSet())));
    private static final Set<QName> EMPTY_VOCABULARY = Collections.unmodifiableSet(new TreeSet<QName>(PolicyUtils.Comparison.QNAME_COMPARATOR));
    private static final Policy ANONYMOUS_NULL_POLICY = new Policy(null, null, NULL_POLICY_ASSERTION_SETS, EMPTY_VOCABULARY);
    private static final Policy ANONYMOUS_EMPTY_POLICY = new Policy(null, null, EMPTY_POLICY_ASSERTION_SETS, EMPTY_VOCABULARY);
    private String policyId;
    private String name;
    private NamespaceVersion nsVersion;
    private final List<AssertionSet> assertionSets;
    private final Set<QName> vocabulary;
    private final Collection<QName> immutableVocabulary;
    private final String toStringName;

    public static Policy createNullPolicy() {
        return ANONYMOUS_NULL_POLICY;
    }

    public static Policy createEmptyPolicy() {
        return ANONYMOUS_EMPTY_POLICY;
    }

    public static Policy createNullPolicy(String string, String string2) {
        if (string == null && string2 == null) {
            return ANONYMOUS_NULL_POLICY;
        }
        return new Policy(string, string2, NULL_POLICY_ASSERTION_SETS, EMPTY_VOCABULARY);
    }

    public static Policy createNullPolicy(NamespaceVersion namespaceVersion, String string, String string2) {
        if ((namespaceVersion == null || namespaceVersion == NamespaceVersion.getLatestVersion()) && string == null && string2 == null) {
            return ANONYMOUS_NULL_POLICY;
        }
        return new Policy(namespaceVersion, string, string2, NULL_POLICY_ASSERTION_SETS, EMPTY_VOCABULARY);
    }

    public static Policy createEmptyPolicy(String string, String string2) {
        if (string == null && string2 == null) {
            return ANONYMOUS_EMPTY_POLICY;
        }
        return new Policy(string, string2, EMPTY_POLICY_ASSERTION_SETS, EMPTY_VOCABULARY);
    }

    public static Policy createEmptyPolicy(NamespaceVersion namespaceVersion, String string, String string2) {
        if ((namespaceVersion == null || namespaceVersion == NamespaceVersion.getLatestVersion()) && string == null && string2 == null) {
            return ANONYMOUS_EMPTY_POLICY;
        }
        return new Policy(namespaceVersion, string, string2, EMPTY_POLICY_ASSERTION_SETS, EMPTY_VOCABULARY);
    }

    public static Policy createPolicy(Collection<AssertionSet> collection) {
        if (collection == null || collection.isEmpty()) {
            return Policy.createNullPolicy();
        }
        return new Policy(POLICY_TOSTRING_NAME, collection);
    }

    public static Policy createPolicy(String string, String string2, Collection<AssertionSet> collection) {
        if (collection == null || collection.isEmpty()) {
            return Policy.createNullPolicy(string, string2);
        }
        return new Policy(POLICY_TOSTRING_NAME, string, string2, collection);
    }

    public static Policy createPolicy(NamespaceVersion namespaceVersion, String string, String string2, Collection<AssertionSet> collection) {
        if (collection == null || collection.isEmpty()) {
            return Policy.createNullPolicy(namespaceVersion, string, string2);
        }
        return new Policy(namespaceVersion, POLICY_TOSTRING_NAME, string, string2, collection);
    }

    private Policy(String string, String string2, List<AssertionSet> list, Set<QName> set) {
        this.nsVersion = NamespaceVersion.getLatestVersion();
        this.toStringName = POLICY_TOSTRING_NAME;
        this.name = string;
        this.policyId = string2;
        this.assertionSets = list;
        this.vocabulary = set;
        this.immutableVocabulary = Collections.unmodifiableCollection(this.vocabulary);
    }

    Policy(String string, Collection<AssertionSet> collection) {
        this.nsVersion = NamespaceVersion.getLatestVersion();
        this.toStringName = string;
        if (collection == null || collection.isEmpty()) {
            this.assertionSets = NULL_POLICY_ASSERTION_SETS;
            this.vocabulary = EMPTY_VOCABULARY;
            this.immutableVocabulary = EMPTY_VOCABULARY;
        } else {
            this.assertionSets = new LinkedList<AssertionSet>();
            this.vocabulary = new TreeSet<QName>(PolicyUtils.Comparison.QNAME_COMPARATOR);
            this.immutableVocabulary = Collections.unmodifiableCollection(this.vocabulary);
            this.addAll(collection);
        }
    }

    Policy(String string, String string2, String string3, Collection<AssertionSet> collection) {
        this(string, collection);
        this.name = string2;
        this.policyId = string3;
    }

    private Policy(NamespaceVersion namespaceVersion, String string, String string2, List<AssertionSet> list, Set<QName> set) {
        this.nsVersion = namespaceVersion;
        this.toStringName = POLICY_TOSTRING_NAME;
        this.name = string;
        this.policyId = string2;
        this.assertionSets = list;
        this.vocabulary = set;
        this.immutableVocabulary = Collections.unmodifiableCollection(this.vocabulary);
    }

    Policy(NamespaceVersion namespaceVersion, String string, Collection<AssertionSet> collection) {
        this.nsVersion = namespaceVersion;
        this.toStringName = string;
        if (collection == null || collection.isEmpty()) {
            this.assertionSets = NULL_POLICY_ASSERTION_SETS;
            this.vocabulary = EMPTY_VOCABULARY;
            this.immutableVocabulary = EMPTY_VOCABULARY;
        } else {
            this.assertionSets = new LinkedList<AssertionSet>();
            this.vocabulary = new TreeSet<QName>(PolicyUtils.Comparison.QNAME_COMPARATOR);
            this.immutableVocabulary = Collections.unmodifiableCollection(this.vocabulary);
            this.addAll(collection);
        }
    }

    Policy(NamespaceVersion namespaceVersion, String string, String string2, String string3, Collection<AssertionSet> collection) {
        this(namespaceVersion, string, collection);
        this.name = string2;
        this.policyId = string3;
    }

    private boolean add(AssertionSet assertionSet) {
        if (assertionSet == null) {
            return false;
        }
        if (this.assertionSets.contains(assertionSet)) {
            return false;
        }
        this.assertionSets.add(assertionSet);
        this.vocabulary.addAll(assertionSet.getVocabulary());
        return true;
    }

    private boolean addAll(Collection<AssertionSet> collection) {
        assert (collection != null && !collection.isEmpty()) : LocalizationMessages.WSP_0036_PRIVATE_METHOD_DOES_NOT_ACCEPT_NULL_OR_EMPTY_COLLECTION();
        boolean bl = true;
        for (AssertionSet assertionSet : collection) {
            bl &= this.add(assertionSet);
        }
        Collections.sort(this.assertionSets);
        return bl;
    }

    Collection<AssertionSet> getContent() {
        return this.assertionSets;
    }

    public String getId() {
        return this.policyId;
    }

    public String getName() {
        return this.name;
    }

    public NamespaceVersion getNamespaceVersion() {
        return this.nsVersion;
    }

    public String getIdOrName() {
        if (this.policyId != null) {
            return this.policyId;
        }
        return this.name;
    }

    public int getNumberOfAssertionSets() {
        return this.assertionSets.size();
    }

    @Override
    public Iterator<AssertionSet> iterator() {
        return this.assertionSets.iterator();
    }

    public boolean isNull() {
        return this.assertionSets.size() == 0;
    }

    public boolean isEmpty() {
        return this.assertionSets.size() == 1 && this.assertionSets.get(0).isEmpty();
    }

    public boolean contains(String string) {
        for (QName qName : this.vocabulary) {
            if (!qName.getNamespaceURI().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Collection<QName> getVocabulary() {
        return this.immutableVocabulary;
    }

    public boolean contains(QName qName) {
        return this.vocabulary.contains(qName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Policy)) {
            return false;
        }
        Policy policy = (Policy)object;
        boolean bl = true;
        bl = bl && this.vocabulary.equals(policy.vocabulary);
        bl = bl && this.assertionSets.size() == policy.assertionSets.size() && this.assertionSets.containsAll(policy.assertionSets);
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.vocabulary.hashCode();
        n = 37 * n + this.assertionSets.hashCode();
        return n;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        String string3 = PolicyUtils.Text.createIndent(n + 2);
        stringBuffer.append(string).append(this.toStringName).append(" {").append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("namespace version = '").append(this.nsVersion.name()).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("id = '").append(this.policyId).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("name = '").append(this.name).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("vocabulary {").append(PolicyUtils.Text.NEW_LINE);
        if (this.vocabulary.isEmpty()) {
            stringBuffer.append(string3).append("no entries").append(PolicyUtils.Text.NEW_LINE);
        } else {
            int n2 = 1;
            for (QName qName : this.vocabulary) {
                stringBuffer.append(string3).append(n2++).append(". entry = '").append(qName.getNamespaceURI()).append(':').append(qName.getLocalPart()).append('\'').append(PolicyUtils.Text.NEW_LINE);
            }
        }
        stringBuffer.append(string2).append('}').append(PolicyUtils.Text.NEW_LINE);
        if (this.assertionSets.isEmpty()) {
            stringBuffer.append(string2).append("no assertion sets").append(PolicyUtils.Text.NEW_LINE);
        } else {
            for (AssertionSet assertionSet : this.assertionSets) {
                assertionSet.toString(n + 1, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
            }
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }
}

